﻿!mod$ v1 sum:fcdfe75dc34013b1
!need$ 7c82aa6df56b3ef2 n dftd4_damping_rational
!need$ 0bdd588a0f21a6d3 n dftd4_model
!need$ 35a7e622b47b677d n dftd4_version
!need$ 1b926fced2ddebd6 n dftd4_damping
!need$ c301c17a17af4c8a n mctc_io_math
!need$ 2f18d312ff6970f0 n mctc_io_convert
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
module dftd4_output
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_convert,only:autoaa
use mctc_io_convert,only:autokcal
use mctc_io_convert,only:autoev
use mctc_io_math,only:matinv_3x3
use dftd4_damping,only:damping_param
use dftd4_damping_rational,only:rational_damping_param
use dftd4_model,only:dispersion_model
use dftd4_version,only:get_dftd4_version
private::wp
private::structure_type
private::autoaa
private::autokcal
private::autoev
private::matinv_3x3
private::damping_param
private::rational_damping_param
private::dispersion_model
private::get_dftd4_version
private::getline
private::write_json_array
contains
subroutine ascii_atomic_radii(unit,mol,disp)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(dispersion_model),intent(in)::disp
end
subroutine ascii_atomic_references(unit,mol,disp)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(dispersion_model),intent(in)::disp
end
subroutine ascii_system_properties(unit,mol,disp,cn,q,c6,alpha)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(dispersion_model),intent(in)::disp
real(8),intent(in)::cn(:)
real(8),intent(in)::q(:)
real(8),intent(in)::c6(:,:)
real(8),intent(in)::alpha(:)
end
subroutine ascii_results(unit,mol,energy,gradient,sigma)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
real(8),intent(in)::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
end
subroutine ascii_pairwise(unit,mol,pair_disp2,pair_disp3)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
real(8),intent(in)::pair_disp2(:,:)
real(8),intent(in)::pair_disp3(:,:)
end
subroutine ascii_damping_param(unit,param,method)
integer(4),intent(in)::unit
class(damping_param),intent(in)::param
character(*,1),intent(in),optional::method
end
subroutine turbomole_gradlatt(mol,fname,energy,sigma,stat)
type(structure_type),intent(in)::mol
character(*,1),intent(in)::fname
real(8),intent(in)::energy
real(8),intent(in)::sigma(1_8:3_8,1_8:3_8)
integer(4),intent(out)::stat
end
subroutine turbomole_gradient(mol,fname,energy,gradient,stat)
type(structure_type),intent(in)::mol
character(*,1),intent(in)::fname
real(8),intent(in)::energy
real(8),intent(in)::gradient(:,:)
integer(4),intent(out)::stat
end
subroutine getline(unit,line,iostat)
integer(4),intent(in)::unit
character(:,1),allocatable,intent(out)::line
integer(4),intent(out),optional::iostat
end
subroutine json_results(unit,indentation,energy,gradient,sigma,hessian,cn,q,c6,alpha,pairwise_energy2,pairwise_energy3)
integer(4),intent(in)::unit
character(*,1),intent(in),optional::indentation
real(8),intent(in),optional::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
real(8),intent(in),optional::hessian(:,:,:,:)
real(8),intent(in),optional::cn(:)
real(8),intent(in),optional::q(:)
real(8),intent(in),optional::c6(:,:)
real(8),intent(in),optional::alpha(:)
real(8),intent(in),optional::pairwise_energy2(:,:)
real(8),intent(in),optional::pairwise_energy3(:,:)
end
subroutine write_json_array(unit,array,indent)
integer(4),intent(in)::unit
real(8),intent(in)::array(:)
character(:,1),allocatable,intent(in)::indent
end
subroutine tagged_result(unit,energy,gradient,sigma,hessian)
integer(4),intent(in)::unit
real(8),intent(in),optional::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
real(8),intent(in),optional::hessian(:,:,:,:)
end
end
