﻿!mod$ v1 sum:eed8a8aff4dc7253
module grib_api
integer(4),parameter::kindofint=4_4
integer(4),parameter::kindoflong=4_4
integer(4),parameter::kindofsize_t=8_4
integer(4),parameter::kindofsize=8_4
integer(4),parameter::kindofdouble=8_4
integer(4),parameter::kindoffloat=4_4
integer(4),parameter::sizeofinteger=4_4
integer(4),parameter::sizeofinteger2=2_4
integer(4),parameter::sizeofinteger4=4_4
integer(4),parameter::sizeofreal4=4_4
integer(4),parameter::sizeofreal8=8_4
integer(4),parameter::grib_runtime_error=-80_4
integer(4),parameter::grib_assertion_failure=-79_4
integer(4),parameter::grib_unable_to_compare_accessors=-78_4
integer(4),parameter::grib_type_and_value_mismatch=-77_4
integer(4),parameter::grib_type_mismatch=-76_4
integer(4),parameter::grib_name_mismatch=-75_4
integer(4),parameter::grib_count_mismatch=-74_4
integer(4),parameter::grib_offset_mismatch=-73_4
integer(4),parameter::grib_string_value_mismatch=-72_4
integer(4),parameter::grib_byte_value_mismatch=-71_4
integer(4),parameter::grib_long_value_mismatch=-70_4
integer(4),parameter::grib_double_value_mismatch=-69_4
integer(4),parameter::grib_value_mismatch=-68_4
integer(4),parameter::grib_functionality_not_enabled=-67_4
integer(4),parameter::grib_wrong_bitmap_size=-66_4
integer(4),parameter::grib_out_of_range=-65_4
integer(4),parameter::grib_unsupported_edition=-64_4
integer(4),parameter::grib_attribute_not_found=-63_4
integer(4),parameter::grib_too_many_attributes=-62_4
integer(4),parameter::grib_attribute_clash=-61_4
integer(4),parameter::grib_null_pointer=-60_4
integer(4),parameter::grib_missing_bufr_entry=-59_4
integer(4),parameter::grib_wrong_conversion=-58_4
integer(4),parameter::grib_string_too_small=-57_4
integer(4),parameter::grib_invalid_key_value=-56_4
integer(4),parameter::grib_value_different=-55_4
integer(4),parameter::grib_different_edition=-54_4
integer(4),parameter::grib_invalid_bpv=-53_4
integer(4),parameter::grib_corrupted_index=-52_4
integer(4),parameter::grib_message_malformed=-51_4
integer(4),parameter::grib_underflow=-50_4
integer(4),parameter::grib_switch_no_match=-49_4
integer(4),parameter::grib_constant_field=-48_4
integer(4),parameter::grib_message_too_large=-47_4
integer(4),parameter::grib_internal_array_too_small=-46_4
integer(4),parameter::grib_premature_end_of_file=-45_4
integer(4),parameter::grib_null_index=-44_4
integer(4),parameter::grib_end_of_index=-43_4
integer(4),parameter::grib_wrong_grid=-42_4
integer(4),parameter::grib_no_values=-41_4
integer(4),parameter::grib_end=-40_4
integer(4),parameter::grib_wrong_type=-39_4
integer(4),parameter::grib_no_definitions=-38_4
integer(4),parameter::grib_hash_array_no_match=-37_4
integer(4),parameter::grib_concept_no_match=-36_4
integer(4),parameter::grib_out_of_area=-35_4
integer(4),parameter::grib_missing_key=-34_4
integer(4),parameter::grib_invalid_orderby=-33_4
integer(4),parameter::grib_invalid_nearest=-32_4
integer(4),parameter::grib_invalid_keys_iterator=-31_4
integer(4),parameter::grib_invalid_iterator=-30_4
integer(4),parameter::grib_invalid_index=-29_4
integer(4),parameter::grib_invalid_grib=-28_4
integer(4),parameter::grib_invalid_file=-27_4
integer(4),parameter::grib_wrong_step_unit=-26_4
integer(4),parameter::grib_wrong_step=-25_4
integer(4),parameter::grib_invalid_type=-24_4
integer(4),parameter::grib_wrong_length=-23_4
integer(4),parameter::grib_value_cannot_be_missing=-22_4
integer(4),parameter::grib_invalid_section_number=-21_4
integer(4),parameter::grib_null_handle=-20_4
integer(4),parameter::grib_invalid_argument=-19_4
integer(4),parameter::grib_read_only=-18_4
integer(4),parameter::grib_out_of_memory=-17_4
integer(4),parameter::grib_geocalculus_problem=-16_4
integer(4),parameter::grib_no_more_in_set=-15_4
integer(4),parameter::grib_encoding_error=-14_4
integer(4),parameter::grib_decoding_error=-13_4
integer(4),parameter::grib_invalid_message=-12_4
integer(4),parameter::grib_io_problem=-11_4
integer(4),parameter::grib_not_found=-10_4
integer(4),parameter::grib_wrong_array_size=-9_4
integer(4),parameter::grib_code_not_found_in_table=-8_4
integer(4),parameter::grib_file_not_found=-7_4
integer(4),parameter::grib_array_too_small=-6_4
integer(4),parameter::grib_7777_not_found=-5_4
integer(4),parameter::grib_not_implemented=-4_4
integer(4),parameter::grib_buffer_too_small=-3_4
integer(4),parameter::grib_internal_error=-2_4
integer(4),parameter::grib_end_of_file=-1_4
integer(4),parameter::grib_success=0_4
integer(4),parameter::grib_null=-1_4
procedure(integer(4))::grib_f_open_file
procedure(integer(4))::grib_f_close_file
procedure(integer(4))::grib_f_read_file
procedure(integer(4))::grib_f_write_file
procedure(integer(4))::grib_f_multi_support_on
procedure(integer(4))::grib_f_multi_support_off
procedure(integer(4))::grib_f_keys_iterator_new
procedure(integer(4))::grib_f_keys_iterator_next
procedure(integer(4))::grib_f_keys_iterator_delete
procedure(integer(4))::codes_f_bufr_keys_iterator_new
procedure(integer(4))::codes_f_bufr_keys_iterator_next
procedure(integer(4))::codes_f_bufr_keys_iterator_get_name
procedure(integer(4))::codes_f_bufr_keys_iterator_rewind
procedure(integer(4))::codes_f_bufr_keys_iterator_delete
procedure(integer(4))::grib_f_skip_computed
procedure(integer(4))::grib_f_skip_coded
procedure(integer(4))::grib_f_skip_edition_specific
procedure(integer(4))::grib_f_skip_duplicates
procedure(integer(4))::grib_f_skip_read_only
procedure(integer(4))::grib_f_skip_function
procedure(integer(4))::grib_f_keys_iterator_get_name
procedure(integer(4))::grib_f_keys_iterator_rewind
procedure(integer(4))::grib_f_new_from_message
procedure(integer(4))::grib_f_new_from_message_int
procedure(integer(4))::grib_f_new_from_message_no_copy
procedure(integer(4))::grib_f_new_from_message_no_copy_int
procedure(integer(4))::grib_f_new_from_samples
procedure(integer(4))::codes_bufr_f_new_from_samples
procedure(integer(4))::grib_f_read_any_from_file
procedure(integer(4))::any_f_new_from_file
procedure(integer(4))::any_f_load_all_from_file
procedure(integer(4))::any_f_new_from_loaded
procedure(integer(4))::any_f_scan_file
procedure(integer(4))::any_f_new_from_scanned_file
procedure(integer(4))::codes_f_clear_loaded_from_file
procedure(integer(4))::grib_f_new_from_file
procedure(integer(4))::bufr_f_new_from_file
procedure(integer(4))::grib_f_headers_only_new_from_file
procedure(integer(4))::grib_f_release
procedure(integer(4))::grib_f_dump
procedure(integer(4))::grib_f_get_error_string
procedure(integer(4))::grib_f_get_native_type
procedure(integer(4))::grib_f_get_size_int
procedure(integer(4))::grib_f_get_size_long
procedure(integer(4))::grib_f_get_data_real4
procedure(integer(4))::grib_f_get_data_real8
procedure(integer(4))::grib_f_get_int
procedure(integer(4))::grib_f_get_long
procedure(integer(4))::grib_f_get_int_array
procedure(integer(4))::grib_f_get_long_array
procedure(integer(4))::grib_f_get_real4
procedure(integer(4))::grib_f_get_real4_array
procedure(integer(4))::grib_f_get_byte_array
procedure(integer(4))::grib_f_get_real8
procedure(integer(4))::grib_f_get_real8_array
procedure(integer(4))::grib_f_get_real4_element
procedure(integer(4))::grib_f_get_real8_element
procedure(integer(4))::grib_f_get_real4_elements
procedure(integer(4))::grib_f_get_real8_elements
procedure(integer(4))::grib_f_get_string
procedure(integer(4))::grib_f_get_string_array
procedure(integer(4))::codes_f_bufr_copy_data
procedure(integer(4))::grib_f_is_missing
procedure(integer(4))::grib_f_is_defined
procedure(integer(4))::grib_f_key_is_computed
procedure(integer(4))::grib_f_grib_surface_type_requires_value
procedure(integer(4))::grib_f_new_from_index
procedure(integer(4))::grib_f_index_new_from_file
procedure(integer(4))::grib_f_index_add_file
procedure(integer(4))::grib_f_index_read
procedure(integer(4))::grib_f_index_write
procedure(integer(4))::grib_f_index_release
procedure(integer(4))::grib_f_index_get_size_long
procedure(integer(4))::grib_f_index_get_size_int
procedure(integer(4))::grib_f_index_get_int
procedure(integer(4))::grib_f_index_get_long
procedure(integer(4))::grib_f_index_get_string
procedure(integer(4))::grib_f_index_get_real8
procedure(integer(4))::grib_f_index_select_real8
procedure(integer(4))::grib_f_index_select_string
procedure(integer(4))::grib_f_index_select_int
procedure(integer(4))::grib_f_index_select_long
procedure(integer(4))::grib_f_set_int
procedure(integer(4))::grib_f_set_int_array
procedure(integer(4))::grib_f_set_long
procedure(integer(4))::grib_f_set_long_array
procedure(integer(4))::grib_f_set_byte_array
procedure(integer(4))::grib_f_set_real4
procedure(integer(4))::grib_f_set_real4_array
procedure(integer(4))::grib_f_set_real8
procedure(integer(4))::grib_f_set_real8_array
procedure(integer(4))::grib_f_set_force_real4_array
procedure(integer(4))::grib_f_set_force_real8_array
procedure(integer(4))::grib_f_set_string
procedure(integer(4))::grib_f_set_string_array
procedure(integer(4))::grib_f_set_missing
procedure(integer(4))::grib_f_gribex_mode_on
procedure(integer(4))::grib_f_gribex_mode_off
procedure(integer(4))::codes_f_bufr_multi_element_constant_arrays_on
procedure(integer(4))::codes_f_bufr_multi_element_constant_arrays_off
procedure(integer(4))::grib_f_find_nearest_single
procedure(integer(4))::grib_f_find_nearest_four_single
procedure(integer(4))::grib_f_find_nearest_multiple
procedure(integer(4))::grib_f_get_message_size
procedure(integer(4))::grib_f_copy_message
procedure(integer(4))::grib_f_get_message
procedure(integer(4))::grib_f_count_in_file
procedure(integer(4))::grib_f_write
procedure(integer(4))::grib_f_multi_write
procedure(integer(4))::grib_f_multi_append
procedure(integer(4))::grib_f_clone
procedure(integer(4))::grib_f_copy_namespace
procedure()::grib_f_check
procedure()::grib_f_set_debug
procedure()::grib_f_set_data_quality_checks
procedure(integer(4))::grib_f_util_sections_copy
procedure(integer(4))::grib_f_set_definitions_path
procedure(integer(4))::grib_f_set_samples_path
procedure(integer(4))::grib_f_julian_to_datetime
procedure(integer(4))::grib_f_datetime_to_julian
procedure(integer(4))::grib_f_copy_key
real(8),parameter::grib_missing_double=-1.0000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104e100_8
integer(4),parameter::grib_missing_long=2147483647_4
interface grib_new_from_message
procedure::grib_new_from_message_int4
procedure::grib_new_from_message_char
end interface
interface grib_new_from_message_no_copy
procedure::grib_new_from_message_no_copy_int4
procedure::grib_new_from_message_no_copy_char
end interface
interface grib_get_element
procedure::grib_get_real4_element
procedure::grib_get_real8_element
procedure::grib_get_real4_elements
procedure::grib_get_real8_elements
end interface
interface grib_find_nearest
procedure::grib_find_nearest_single
procedure::grib_find_nearest_four_single
procedure::grib_find_nearest_multiple
end interface
interface grib_get_data
procedure::grib_get_data_real4
procedure::grib_get_data_real8
end interface
interface grib_index_get
procedure::grib_index_get_int
procedure::grib_index_get_string
procedure::grib_index_get_real8
end interface
interface grib_index_get_size
procedure::grib_index_get_size_int
end interface
interface grib_index_select
procedure::grib_index_select_int
procedure::grib_index_select_string
procedure::grib_index_select_real8
end interface
interface grib_get
procedure::grib_get_int
procedure::grib_get_real4
procedure::grib_get_real8
procedure::grib_get_string
procedure::grib_get_int_array
procedure::grib_get_byte_array
procedure::grib_get_real4_array
procedure::grib_get_real8_array
end interface
interface grib_get_size
procedure::grib_get_size_int
end interface
interface grib_set
procedure::grib_set_int
procedure::grib_set_real4
procedure::grib_set_real8
procedure::grib_set_string
procedure::grib_set_int_array
procedure::grib_set_byte_array
procedure::grib_set_real4_array
procedure::grib_set_real8_array
end interface
interface grib_set_force
procedure::grib_set_force_real4_array
procedure::grib_set_force_real8_array
end interface
interface grib_read_from_file
procedure::grib_read_from_file_int4
procedure::grib_read_from_file_int4_size_t
procedure::grib_read_from_file_char
procedure::grib_read_from_file_char_size_t
end interface
interface grib_read_bytes
procedure::grib_read_bytes_int4
procedure::grib_read_bytes_int4_size_t
procedure::grib_read_bytes_char
procedure::grib_read_bytes_char_size_t
procedure::grib_read_bytes_real8
procedure::grib_read_bytes_real8_size_t
procedure::grib_read_bytes_real4
procedure::grib_read_bytes_real4_size_t
end interface
interface grib_write_bytes
procedure::grib_write_bytes_int4
procedure::grib_write_bytes_int4_size_t
procedure::grib_write_bytes_char
procedure::grib_write_bytes_char_size_t
procedure::grib_write_bytes_real8
procedure::grib_write_bytes_real8_size_t
procedure::grib_write_bytes_real4
procedure::grib_write_bytes_real4_size_t
end interface
interface grib_get_message_size
procedure::grib_get_message_size_int
procedure::grib_get_message_size_size_t
end interface
interface grib_get_message
procedure::grib_get_message_int
procedure::grib_get_message_size_t
end interface
contains
subroutine grib_set_missing(gribid,key,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out),optional::status
end
subroutine grib_index_create(indexid,filename,keys,status)
integer(4),intent(inout)::indexid
character(*,1),intent(in)::filename
character(*,1),intent(in)::keys
integer(4),intent(out),optional::status
end
subroutine grib_index_add_file(indexid,filename,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::filename
integer(4),intent(out),optional::status
end
subroutine grib_index_get_size_long(indexid,key,size,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(out)::size
integer(4),intent(out),optional::status
end
subroutine grib_index_get_size_int(indexid,key,size,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(out)::size
integer(4),intent(out),optional::status
end
subroutine grib_index_get_int(indexid,key,values,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_index_get_long(indexid,key,values,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_index_get_real8(indexid,key,values,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
real(8),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_index_get_string(indexid,key,values,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
character(*,1),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_index_select_string(indexid,key,value,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
character(*,1),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_index_select_int(indexid,key,value,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_index_select_long(indexid,key,value,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
integer(4),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_index_select_real8(indexid,key,value,status)
integer(4),intent(in)::indexid
character(*,1),intent(in)::key
real(8),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_new_from_index(indexid,gribid,status)
integer(4),intent(in)::indexid
integer(4),intent(out)::gribid
integer(4),intent(out),optional::status
end
subroutine grib_index_read(indexid,filename,status)
integer(4),intent(inout)::indexid
character(*,1),intent(in)::filename
integer(4),intent(out),optional::status
end
subroutine grib_index_write(indexid,filename,status)
integer(4),intent(inout)::indexid
character(*,1),intent(in)::filename
integer(4),intent(out),optional::status
end
subroutine grib_index_release(indexid,status)
integer(4),intent(in)::indexid
integer(4),intent(out),optional::status
end
subroutine grib_open_file(ifile,filename,mode,status)
integer(4),intent(out)::ifile
character(*,1),intent(in)::filename
character(*,1),intent(in)::mode
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_char(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(out)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_char_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(out)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_int4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_int4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_real4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(out)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_real4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_real8(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(out)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_bytes_real8_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_int4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::buffer(:)
integer(4),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_int4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_real4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(out)::buffer(:)
integer(4),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_real4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_real8(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(out)::buffer(:)
integer(4),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_real8_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_char(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(out)::buffer(:)
integer(4),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_read_from_file_char_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(out)::buffer(:)
integer(8),intent(inout)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_char(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(in)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_char_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
character(1_4,1),intent(in)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_int4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(in)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_int4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
integer(4),intent(in)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_real4(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(in)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_real4_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(4),intent(in)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_real8(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(in)::buffer(:)
integer(4),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_write_bytes_real8_size_t(ifile,buffer,nbytes,status)
integer(4),intent(in)::ifile
real(8),intent(in)::buffer(:)
integer(8),intent(in)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_close_file(ifile,status)
integer(4),intent(in)::ifile
integer(4),intent(out),optional::status
end
subroutine grib_count_in_file(ifile,n,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::n
integer(4),intent(out),optional::status
end
subroutine grib_headers_only_new_from_file(ifile,gribid,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::gribid
integer(4),intent(out),optional::status
end
subroutine grib_new_from_file(ifile,gribid,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::gribid
integer(4),intent(out),optional::status
end
subroutine bufr_new_from_file(ifile,bufrid,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::bufrid
integer(4),intent(out),optional::status
end
subroutine any_new_from_file(ifile,msgid,status)
integer(4),intent(in)::ifile
integer(4),intent(out)::msgid
integer(4),intent(out),optional::status
end
subroutine grib_new_from_message_char(gribid,message,status)
integer(4),intent(out)::gribid
character(1_4,1),intent(in)::message(:)
integer(4),intent(out),optional::status
end
subroutine grib_new_from_message_no_copy_char(gribid,message,status)
integer(4),intent(out)::gribid
character(1_4,1),intent(in)::message(:)
integer(4),intent(out),optional::status
end
subroutine grib_new_from_message_no_copy_int4(gribid,message,status)
integer(4),intent(out)::gribid
integer(4),intent(in)::message(:)
integer(4),intent(out),optional::status
end
subroutine grib_new_from_message_int4(gribid,message,status)
integer(4),intent(out)::gribid
integer(4),intent(in)::message(:)
integer(4),intent(out),optional::status
end
subroutine grib_new_from_samples(gribid,samplename,status)
integer(4),intent(out)::gribid
character(*,1),intent(in)::samplename
integer(4),intent(out),optional::status
end
subroutine grib_release(gribid,status)
integer(4),intent(in)::gribid
integer(4),intent(out),optional::status
end
subroutine grib_clone(gribid_src,gribid_dest,status)
integer(4),intent(in)::gribid_src
integer(4),intent(out)::gribid_dest
integer(4),intent(out),optional::status
end
subroutine grib_util_sections_copy(gribid_from,gribid_to,what,gribid_out,status)
integer(4),intent(in)::gribid_from
integer(4),intent(in)::gribid_to
integer(4),intent(in)::what
integer(4),intent(out)::gribid_out
integer(4),intent(out),optional::status
end
subroutine grib_copy_namespace(gribid_src,namespace,gribid_dest,status)
integer(4),intent(in)::gribid_src
character(*,1),intent(in)::namespace
integer(4),intent(in)::gribid_dest
integer(4),intent(out),optional::status
end
subroutine grib_check(status,caller,string)
integer(4),intent(in)::status
character(*,1),intent(in)::caller
character(*,1),intent(in)::string
end
subroutine grib_get_data_real4(gribid,lats,lons,values,status)
integer(4),intent(in)::gribid
real(4),intent(out)::lats(:)
real(4),intent(out)::lons(:)
real(4),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_data_real8(gribid,lats,lons,values,status)
integer(4),intent(in)::gribid
real(8),intent(out)::lats(:)
real(8),intent(out)::lons(:)
real(8),intent(out)::values(:)
integer(4),intent(out),optional::status
end
subroutine grib_keys_iterator_new(gribid,iterid,namespace,status)
integer(4),intent(in)::gribid
integer(4),intent(inout)::iterid
character(*,1),intent(in)::namespace
integer(4),intent(out),optional::status
end
subroutine grib_keys_iterator_next(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out)::status
end
subroutine grib_keys_iterator_delete(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_keys_iterator_get_name(iterid,name,status)
integer(4),intent(in)::iterid
character(*,1),intent(out)::name
integer(4),intent(out),optional::status
end
subroutine grib_keys_iterator_rewind(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_dump(gribid,status)
integer(4),intent(in)::gribid
integer(4),intent(out),optional::status
end
subroutine grib_get_error_string(error,error_message,status)
integer(4),intent(in)::error
character(*,1),intent(out)::error_message
integer(4),intent(out),optional::status
end
subroutine grib_get_size_int(gribid,key,size,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::size
integer(4),intent(out),optional::status
end
subroutine grib_get_size_long(gribid,key,size,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::size
integer(4),intent(out),optional::status
end
subroutine grib_get_int(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_long(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_native_type(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_is_missing(gribid,key,is_missing,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::is_missing
integer(4),intent(out),optional::status
end
subroutine grib_is_defined(gribid,key,is_defined,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::is_defined
integer(4),intent(out),optional::status
end
subroutine grib_get_real4(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(4),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_real8(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(8),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_string(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
character(*,1),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_int_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_long_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_byte_array(gribid,key,value,length,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
character(1_4,1),intent(out)::value(:)
integer(4),intent(out),optional::length
integer(4),intent(out),optional::status
end
subroutine grib_get_real4_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(4),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_real8_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(8),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_real4_element(gribid,key,kindex,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::kindex
real(4),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_real8_element(gribid,key,kindex,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::kindex
real(8),intent(out)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_real4_elements(gribid,key,kindex,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::kindex(:)
real(4),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_real8_elements(gribid,key,kindex,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::kindex(:)
real(8),intent(out)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_int(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_set_long(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_set_real4(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(4),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_set_real8(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(8),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_set_int_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_long_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
integer(4),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_byte_array(gribid,key,value,length,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
character(1_4,1),intent(in)::value(:)
integer(4),intent(out),optional::length
integer(4),intent(out),optional::status
end
subroutine grib_set_real4_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(4),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_real8_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(8),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_force_real4_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(4),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_force_real8_array(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
real(8),intent(in)::value(:)
integer(4),intent(out),optional::status
end
subroutine grib_set_string(gribid,key,value,status)
integer(4),intent(in)::gribid
character(*,1),intent(in)::key
character(*,1),intent(in)::value
integer(4),intent(out),optional::status
end
subroutine grib_get_message_size_int(gribid,nbytes,status)
integer(4),intent(in)::gribid
integer(4),intent(out)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_get_message_size_size_t(gribid,nbytes,status)
integer(4),intent(in)::gribid
integer(8),intent(out)::nbytes
integer(4),intent(out),optional::status
end
subroutine grib_copy_message(gribid,message,status)
integer(4),intent(in)::gribid
character(1_4,1),intent(out)::message(:)
integer(4),intent(out),optional::status
end
subroutine grib_get_message_size_t(gribid,message,mess_len,status)
integer(4),intent(in)::gribid
character(1_4,1),intent(out),pointer::message(:)
integer(8),intent(out)::mess_len
integer(4),intent(out),optional::status
end
subroutine grib_get_message_int(gribid,message,mess_len,status)
integer(4),intent(in)::gribid
character(1_4,1),intent(out),pointer::message(:)
integer(4),intent(out)::mess_len
integer(4),intent(out),optional::status
end
subroutine grib_write(gribid,ifile,status)
integer(4),intent(in)::gribid
integer(4),intent(in)::ifile
integer(4),intent(out),optional::status
end
subroutine grib_multi_write(multigribid,ifile,status)
integer(4),intent(in)::multigribid
integer(4),intent(in)::ifile
integer(4),intent(out),optional::status
end
subroutine grib_multi_append(ingribid,startsection,multigribid,status)
integer(4),intent(in)::ingribid
integer(4),intent(in)::startsection
integer(4),intent(out)::multigribid
integer(4),intent(out),optional::status
end
subroutine grib_find_nearest_multiple(gribid,is_lsm,inlats,inlons,outlats,outlons,values,distances,indexes,status)
integer(4),intent(in)::gribid
logical(4),intent(in)::is_lsm
real(8),intent(in)::inlats(:)
real(8),intent(in)::inlons(:)
real(8),intent(out)::outlats(:)
real(8),intent(out)::outlons(:)
real(8),intent(out)::values(:)
real(8),intent(out)::distances(:)
integer(4),intent(out)::indexes(:)
integer(4),intent(out),optional::status
end
subroutine grib_find_nearest_single(gribid,is_lsm,inlat,inlon,outlat,outlon,value,distance,kindex,status)
integer(4),intent(in)::gribid
logical(4),intent(in)::is_lsm
real(8),intent(in)::inlat
real(8),intent(in)::inlon
real(8),intent(out)::outlat
real(8),intent(out)::outlon
real(8),intent(out)::value
real(8),intent(out)::distance
integer(4),intent(out)::kindex
integer(4),intent(out),optional::status
end
subroutine grib_find_nearest_four_single(gribid,is_lsm,inlat,inlon,outlat,outlon,value,distance,kindex,status)
integer(4),intent(in)::gribid
logical(4),intent(in)::is_lsm
real(8),intent(in)::inlat
real(8),intent(in)::inlon
real(8),intent(out)::outlat(1_8:4_8)
real(8),intent(out)::outlon(1_8:4_8)
real(8),intent(out)::value(1_8:4_8)
real(8),intent(out)::distance(1_8:4_8)
integer(4),intent(out)::kindex(1_8:4_8)
integer(4),intent(out),optional::status
end
subroutine grib_multi_support_on(status)
integer(4),intent(out),optional::status
end
subroutine grib_multi_support_off(status)
integer(4),intent(out),optional::status
end
subroutine grib_gribex_mode_on(status)
integer(4),intent(out),optional::status
end
subroutine grib_gribex_mode_off(status)
integer(4),intent(out),optional::status
end
subroutine grib_skip_computed(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_skip_coded(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_skip_duplicates(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_skip_read_only(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_skip_function(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_skip_edition_specific(iterid,status)
integer(4),intent(in)::iterid
integer(4),intent(out),optional::status
end
subroutine grib_set_debug(dmode)
integer(4),intent(in)::dmode
end
subroutine grib_set_data_quality_checks(val)
integer(4),intent(in)::val
end
subroutine grib_set_definitions_path(path,status)
character(*,1),intent(in)::path
integer(4),intent(out),optional::status
end
subroutine grib_set_samples_path(path,status)
character(*,1),intent(in)::path
integer(4),intent(out),optional::status
end
end
