#ifndef _EFL_NET_SERVER_WINDOWS_EO_H_
#define _EFL_NET_SERVER_WINDOWS_EO_H_

#ifndef _EFL_NET_SERVER_WINDOWS_EO_CLASS_TYPE
#define _EFL_NET_SERVER_WINDOWS_EO_CLASS_TYPE

typedef Eo Efl_Net_Server_Windows;

#endif

#ifndef _EFL_NET_SERVER_WINDOWS_EO_TYPES
#define _EFL_NET_SERVER_WINDOWS_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief A Windows NamedPipe server.
 *
 * The @ref efl_net_server_serve method calls CreateNamedPipe() directly, so
 * the path will be accessed and created in that method. If the created socket
 * must be subject to some special mode or user, change before executing said
 * method.
 *
 * @ingroup Efl_Net_Server_Windows
 */
#define EFL_NET_SERVER_WINDOWS_CLASS efl_net_server_windows_class_get()

ECORE_CON_API ECORE_CON_API_WEAK const Efl_Class *efl_net_server_windows_class_get(void) EINA_CONST;

/**
 * @brief If server allows remote (different machine) clients.
 *
 * If this property is @c true, then it will allow clients to connect from
 * remote machines. If @c false (default), then just local clients are allowed.
 *
 * @param[in] obj The object.
 * @param[in] allow_remote If @c true, server will allow remote machines to
 * connect.
 *
 * @ingroup Efl_Net_Server_Windows
 */
ECORE_CON_API ECORE_CON_API_WEAK void efl_net_server_windows_allow_remote_set(Eo *obj, Eina_Bool allow_remote);

/**
 * @brief If server allows remote (different machine) clients.
 *
 * If this property is @c true, then it will allow clients to connect from
 * remote machines. If @c false (default), then just local clients are allowed.
 *
 * @param[in] obj The object.
 *
 * @return If @c true, server will allow remote machines to connect.
 *
 * @ingroup Efl_Net_Server_Windows
 */
ECORE_CON_API ECORE_CON_API_WEAK Eina_Bool efl_net_server_windows_allow_remote_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
