/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CUFAttr.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace cuf {
// CUDA Fortran variable attributes
enum class DataAttribute : uint32_t {
  Constant = 0,
  Device = 1,
  Managed = 2,
  Pinned = 3,
  Shared = 4,
  Unified = 5,
};

::std::optional<DataAttribute> symbolizeDataAttribute(uint32_t);
::llvm::StringRef stringifyDataAttribute(DataAttribute);
::std::optional<DataAttribute> symbolizeDataAttribute(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForDataAttribute() {
  return 5;
}


inline ::llvm::StringRef stringifyEnum(DataAttribute enumValue) {
  return stringifyDataAttribute(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<DataAttribute> symbolizeEnum<DataAttribute>(::llvm::StringRef str) {
  return symbolizeDataAttribute(str);
}
} // namespace cuf

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::cuf::DataAttribute, ::cuf::DataAttribute> {
  template <typename ParserT>
  static FailureOr<::cuf::DataAttribute> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for CUDA Fortran variable attributes");

    // Symbolize the keyword.
    if (::std::optional<::cuf::DataAttribute> attr = ::cuf::symbolizeEnum<::cuf::DataAttribute>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [constant, device, managed, pinned, shared, unified] for CUDA Fortran variable attributes, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::cuf::DataAttribute>, std::optional<::cuf::DataAttribute>> {
  template <typename ParserT>
  static FailureOr<std::optional<::cuf::DataAttribute>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::cuf::DataAttribute>{};

    // Symbolize the keyword.
    if (::std::optional<::cuf::DataAttribute> attr = ::cuf::symbolizeEnum<::cuf::DataAttribute>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [constant, device, managed, pinned, shared, unified] for CUDA Fortran variable attributes, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::cuf::DataAttribute value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::cuf::DataAttribute> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::cuf::DataAttribute getEmptyKey() {
    return static_cast<::cuf::DataAttribute>(StorageInfo::getEmptyKey());
  }

  static inline ::cuf::DataAttribute getTombstoneKey() {
    return static_cast<::cuf::DataAttribute>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::cuf::DataAttribute &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::cuf::DataAttribute &lhs, const ::cuf::DataAttribute &rhs) {
    return lhs == rhs;
  }
};
}

namespace cuf {
// CUDA Fortran data transfer kind
enum class DataTransferKind : uint32_t {
  DeviceHost = 0,
  HostDevice = 1,
  DeviceDevice = 2,
};

::std::optional<DataTransferKind> symbolizeDataTransferKind(uint32_t);
::llvm::StringRef stringifyDataTransferKind(DataTransferKind);
::std::optional<DataTransferKind> symbolizeDataTransferKind(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForDataTransferKind() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(DataTransferKind enumValue) {
  return stringifyDataTransferKind(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<DataTransferKind> symbolizeEnum<DataTransferKind>(::llvm::StringRef str) {
  return symbolizeDataTransferKind(str);
}
} // namespace cuf

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::cuf::DataTransferKind, ::cuf::DataTransferKind> {
  template <typename ParserT>
  static FailureOr<::cuf::DataTransferKind> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for CUDA Fortran data transfer kind");

    // Symbolize the keyword.
    if (::std::optional<::cuf::DataTransferKind> attr = ::cuf::symbolizeEnum<::cuf::DataTransferKind>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [device_host, host_device, device_device] for CUDA Fortran data transfer kind, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::cuf::DataTransferKind>, std::optional<::cuf::DataTransferKind>> {
  template <typename ParserT>
  static FailureOr<std::optional<::cuf::DataTransferKind>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::cuf::DataTransferKind>{};

    // Symbolize the keyword.
    if (::std::optional<::cuf::DataTransferKind> attr = ::cuf::symbolizeEnum<::cuf::DataTransferKind>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [device_host, host_device, device_device] for CUDA Fortran data transfer kind, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::cuf::DataTransferKind value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::cuf::DataTransferKind> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::cuf::DataTransferKind getEmptyKey() {
    return static_cast<::cuf::DataTransferKind>(StorageInfo::getEmptyKey());
  }

  static inline ::cuf::DataTransferKind getTombstoneKey() {
    return static_cast<::cuf::DataTransferKind>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::cuf::DataTransferKind &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::cuf::DataTransferKind &lhs, const ::cuf::DataTransferKind &rhs) {
    return lhs == rhs;
  }
};
}

namespace cuf {
// CUDA Fortran procedure attributes
enum class ProcAttribute : uint32_t {
  Host = 0,
  Device = 1,
  HostDevice = 2,
  Global = 3,
  GridGlobal = 4,
};

::std::optional<ProcAttribute> symbolizeProcAttribute(uint32_t);
::llvm::StringRef stringifyProcAttribute(ProcAttribute);
::std::optional<ProcAttribute> symbolizeProcAttribute(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForProcAttribute() {
  return 4;
}


inline ::llvm::StringRef stringifyEnum(ProcAttribute enumValue) {
  return stringifyProcAttribute(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ProcAttribute> symbolizeEnum<ProcAttribute>(::llvm::StringRef str) {
  return symbolizeProcAttribute(str);
}
} // namespace cuf

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::cuf::ProcAttribute, ::cuf::ProcAttribute> {
  template <typename ParserT>
  static FailureOr<::cuf::ProcAttribute> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for CUDA Fortran procedure attributes");

    // Symbolize the keyword.
    if (::std::optional<::cuf::ProcAttribute> attr = ::cuf::symbolizeEnum<::cuf::ProcAttribute>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [host, device, host_device, global, grid_global] for CUDA Fortran procedure attributes, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::cuf::ProcAttribute>, std::optional<::cuf::ProcAttribute>> {
  template <typename ParserT>
  static FailureOr<std::optional<::cuf::ProcAttribute>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::cuf::ProcAttribute>{};

    // Symbolize the keyword.
    if (::std::optional<::cuf::ProcAttribute> attr = ::cuf::symbolizeEnum<::cuf::ProcAttribute>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [host, device, host_device, global, grid_global] for CUDA Fortran procedure attributes, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::cuf::ProcAttribute value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::cuf::ProcAttribute> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::cuf::ProcAttribute getEmptyKey() {
    return static_cast<::cuf::ProcAttribute>(StorageInfo::getEmptyKey());
  }

  static inline ::cuf::ProcAttribute getTombstoneKey() {
    return static_cast<::cuf::ProcAttribute>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::cuf::ProcAttribute &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::cuf::ProcAttribute &lhs, const ::cuf::ProcAttribute &rhs) {
    return lhs == rhs;
  }
};
}

