/* BEGIN_LEGAL 

Copyright (c) 2024 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file xed-reg-enum.h

// This file was automatically generated.
// Do not edit this file.

#if !defined(XED_REG_ENUM_H)
# define XED_REG_ENUM_H
#include "xed-common-hdrs.h"
#define XED_REG_INVALID_DEFINED 1
#define XED_REG_BNDCFGU_DEFINED 1
#define XED_REG_BNDSTATUS_DEFINED 1
#define XED_REG_BND0_DEFINED 1
#define XED_REG_BND1_DEFINED 1
#define XED_REG_BND2_DEFINED 1
#define XED_REG_BND3_DEFINED 1
#define XED_REG_CR0_DEFINED 1
#define XED_REG_CR1_DEFINED 1
#define XED_REG_CR2_DEFINED 1
#define XED_REG_CR3_DEFINED 1
#define XED_REG_CR4_DEFINED 1
#define XED_REG_CR5_DEFINED 1
#define XED_REG_CR6_DEFINED 1
#define XED_REG_CR7_DEFINED 1
#define XED_REG_CR8_DEFINED 1
#define XED_REG_CR9_DEFINED 1
#define XED_REG_CR10_DEFINED 1
#define XED_REG_CR11_DEFINED 1
#define XED_REG_CR12_DEFINED 1
#define XED_REG_CR13_DEFINED 1
#define XED_REG_CR14_DEFINED 1
#define XED_REG_CR15_DEFINED 1
#define XED_REG_DR0_DEFINED 1
#define XED_REG_DR1_DEFINED 1
#define XED_REG_DR2_DEFINED 1
#define XED_REG_DR3_DEFINED 1
#define XED_REG_DR4_DEFINED 1
#define XED_REG_DR5_DEFINED 1
#define XED_REG_DR6_DEFINED 1
#define XED_REG_DR7_DEFINED 1
#define XED_REG_FLAGS_DEFINED 1
#define XED_REG_EFLAGS_DEFINED 1
#define XED_REG_RFLAGS_DEFINED 1
#define XED_REG_AX_DEFINED 1
#define XED_REG_CX_DEFINED 1
#define XED_REG_DX_DEFINED 1
#define XED_REG_BX_DEFINED 1
#define XED_REG_SP_DEFINED 1
#define XED_REG_BP_DEFINED 1
#define XED_REG_SI_DEFINED 1
#define XED_REG_DI_DEFINED 1
#define XED_REG_R8W_DEFINED 1
#define XED_REG_R9W_DEFINED 1
#define XED_REG_R10W_DEFINED 1
#define XED_REG_R11W_DEFINED 1
#define XED_REG_R12W_DEFINED 1
#define XED_REG_R13W_DEFINED 1
#define XED_REG_R14W_DEFINED 1
#define XED_REG_R15W_DEFINED 1
#define XED_REG_R16W_DEFINED 1
#define XED_REG_R17W_DEFINED 1
#define XED_REG_R18W_DEFINED 1
#define XED_REG_R19W_DEFINED 1
#define XED_REG_R20W_DEFINED 1
#define XED_REG_R21W_DEFINED 1
#define XED_REG_R22W_DEFINED 1
#define XED_REG_R23W_DEFINED 1
#define XED_REG_R24W_DEFINED 1
#define XED_REG_R25W_DEFINED 1
#define XED_REG_R26W_DEFINED 1
#define XED_REG_R27W_DEFINED 1
#define XED_REG_R28W_DEFINED 1
#define XED_REG_R29W_DEFINED 1
#define XED_REG_R30W_DEFINED 1
#define XED_REG_R31W_DEFINED 1
#define XED_REG_EAX_DEFINED 1
#define XED_REG_ECX_DEFINED 1
#define XED_REG_EDX_DEFINED 1
#define XED_REG_EBX_DEFINED 1
#define XED_REG_ESP_DEFINED 1
#define XED_REG_EBP_DEFINED 1
#define XED_REG_ESI_DEFINED 1
#define XED_REG_EDI_DEFINED 1
#define XED_REG_R8D_DEFINED 1
#define XED_REG_R9D_DEFINED 1
#define XED_REG_R10D_DEFINED 1
#define XED_REG_R11D_DEFINED 1
#define XED_REG_R12D_DEFINED 1
#define XED_REG_R13D_DEFINED 1
#define XED_REG_R14D_DEFINED 1
#define XED_REG_R15D_DEFINED 1
#define XED_REG_R16D_DEFINED 1
#define XED_REG_R17D_DEFINED 1
#define XED_REG_R18D_DEFINED 1
#define XED_REG_R19D_DEFINED 1
#define XED_REG_R20D_DEFINED 1
#define XED_REG_R21D_DEFINED 1
#define XED_REG_R22D_DEFINED 1
#define XED_REG_R23D_DEFINED 1
#define XED_REG_R24D_DEFINED 1
#define XED_REG_R25D_DEFINED 1
#define XED_REG_R26D_DEFINED 1
#define XED_REG_R27D_DEFINED 1
#define XED_REG_R28D_DEFINED 1
#define XED_REG_R29D_DEFINED 1
#define XED_REG_R30D_DEFINED 1
#define XED_REG_R31D_DEFINED 1
#define XED_REG_RAX_DEFINED 1
#define XED_REG_RCX_DEFINED 1
#define XED_REG_RDX_DEFINED 1
#define XED_REG_RBX_DEFINED 1
#define XED_REG_RSP_DEFINED 1
#define XED_REG_RBP_DEFINED 1
#define XED_REG_RSI_DEFINED 1
#define XED_REG_RDI_DEFINED 1
#define XED_REG_R8_DEFINED 1
#define XED_REG_R9_DEFINED 1
#define XED_REG_R10_DEFINED 1
#define XED_REG_R11_DEFINED 1
#define XED_REG_R12_DEFINED 1
#define XED_REG_R13_DEFINED 1
#define XED_REG_R14_DEFINED 1
#define XED_REG_R15_DEFINED 1
#define XED_REG_R16_DEFINED 1
#define XED_REG_R17_DEFINED 1
#define XED_REG_R18_DEFINED 1
#define XED_REG_R19_DEFINED 1
#define XED_REG_R20_DEFINED 1
#define XED_REG_R21_DEFINED 1
#define XED_REG_R22_DEFINED 1
#define XED_REG_R23_DEFINED 1
#define XED_REG_R24_DEFINED 1
#define XED_REG_R25_DEFINED 1
#define XED_REG_R26_DEFINED 1
#define XED_REG_R27_DEFINED 1
#define XED_REG_R28_DEFINED 1
#define XED_REG_R29_DEFINED 1
#define XED_REG_R30_DEFINED 1
#define XED_REG_R31_DEFINED 1
#define XED_REG_AL_DEFINED 1
#define XED_REG_CL_DEFINED 1
#define XED_REG_DL_DEFINED 1
#define XED_REG_BL_DEFINED 1
#define XED_REG_SPL_DEFINED 1
#define XED_REG_BPL_DEFINED 1
#define XED_REG_SIL_DEFINED 1
#define XED_REG_DIL_DEFINED 1
#define XED_REG_R8B_DEFINED 1
#define XED_REG_R9B_DEFINED 1
#define XED_REG_R10B_DEFINED 1
#define XED_REG_R11B_DEFINED 1
#define XED_REG_R12B_DEFINED 1
#define XED_REG_R13B_DEFINED 1
#define XED_REG_R14B_DEFINED 1
#define XED_REG_R15B_DEFINED 1
#define XED_REG_R16B_DEFINED 1
#define XED_REG_R17B_DEFINED 1
#define XED_REG_R18B_DEFINED 1
#define XED_REG_R19B_DEFINED 1
#define XED_REG_R20B_DEFINED 1
#define XED_REG_R21B_DEFINED 1
#define XED_REG_R22B_DEFINED 1
#define XED_REG_R23B_DEFINED 1
#define XED_REG_R24B_DEFINED 1
#define XED_REG_R25B_DEFINED 1
#define XED_REG_R26B_DEFINED 1
#define XED_REG_R27B_DEFINED 1
#define XED_REG_R28B_DEFINED 1
#define XED_REG_R29B_DEFINED 1
#define XED_REG_R30B_DEFINED 1
#define XED_REG_R31B_DEFINED 1
#define XED_REG_AH_DEFINED 1
#define XED_REG_CH_DEFINED 1
#define XED_REG_DH_DEFINED 1
#define XED_REG_BH_DEFINED 1
#define XED_REG_ERROR_DEFINED 1
#define XED_REG_RIP_DEFINED 1
#define XED_REG_EIP_DEFINED 1
#define XED_REG_IP_DEFINED 1
#define XED_REG_K0_DEFINED 1
#define XED_REG_K1_DEFINED 1
#define XED_REG_K2_DEFINED 1
#define XED_REG_K3_DEFINED 1
#define XED_REG_K4_DEFINED 1
#define XED_REG_K5_DEFINED 1
#define XED_REG_K6_DEFINED 1
#define XED_REG_K7_DEFINED 1
#define XED_REG_MMX0_DEFINED 1
#define XED_REG_MMX1_DEFINED 1
#define XED_REG_MMX2_DEFINED 1
#define XED_REG_MMX3_DEFINED 1
#define XED_REG_MMX4_DEFINED 1
#define XED_REG_MMX5_DEFINED 1
#define XED_REG_MMX6_DEFINED 1
#define XED_REG_MMX7_DEFINED 1
#define XED_REG_SSP_DEFINED 1
#define XED_REG_IA32_U_CET_DEFINED 1
#define XED_REG_MXCSR_DEFINED 1
#define XED_REG_STACKPUSH_DEFINED 1
#define XED_REG_STACKPOP_DEFINED 1
#define XED_REG_GDTR_DEFINED 1
#define XED_REG_LDTR_DEFINED 1
#define XED_REG_IDTR_DEFINED 1
#define XED_REG_TR_DEFINED 1
#define XED_REG_TSC_DEFINED 1
#define XED_REG_TSCAUX_DEFINED 1
#define XED_REG_MSRS_DEFINED 1
#define XED_REG_FSBASE_DEFINED 1
#define XED_REG_GSBASE_DEFINED 1
#define XED_REG_TILECONFIG_DEFINED 1
#define XED_REG_IA32_KERNEL_GS_BASE_DEFINED 1
#define XED_REG_DFV0_DEFINED 1
#define XED_REG_DFV1_DEFINED 1
#define XED_REG_DFV2_DEFINED 1
#define XED_REG_DFV3_DEFINED 1
#define XED_REG_DFV4_DEFINED 1
#define XED_REG_DFV5_DEFINED 1
#define XED_REG_DFV6_DEFINED 1
#define XED_REG_DFV7_DEFINED 1
#define XED_REG_DFV8_DEFINED 1
#define XED_REG_DFV9_DEFINED 1
#define XED_REG_DFV10_DEFINED 1
#define XED_REG_DFV11_DEFINED 1
#define XED_REG_DFV12_DEFINED 1
#define XED_REG_DFV13_DEFINED 1
#define XED_REG_DFV14_DEFINED 1
#define XED_REG_DFV15_DEFINED 1
#define XED_REG_X87CONTROL_DEFINED 1
#define XED_REG_X87STATUS_DEFINED 1
#define XED_REG_X87TAG_DEFINED 1
#define XED_REG_X87PUSH_DEFINED 1
#define XED_REG_X87POP_DEFINED 1
#define XED_REG_X87POP2_DEFINED 1
#define XED_REG_X87OPCODE_DEFINED 1
#define XED_REG_X87LASTCS_DEFINED 1
#define XED_REG_X87LASTIP_DEFINED 1
#define XED_REG_X87LASTDS_DEFINED 1
#define XED_REG_X87LASTDP_DEFINED 1
#define XED_REG_ES_DEFINED 1
#define XED_REG_CS_DEFINED 1
#define XED_REG_SS_DEFINED 1
#define XED_REG_DS_DEFINED 1
#define XED_REG_FS_DEFINED 1
#define XED_REG_GS_DEFINED 1
#define XED_REG_TMP0_DEFINED 1
#define XED_REG_TMP1_DEFINED 1
#define XED_REG_TMP2_DEFINED 1
#define XED_REG_TMP3_DEFINED 1
#define XED_REG_TMP4_DEFINED 1
#define XED_REG_TMP5_DEFINED 1
#define XED_REG_TMP6_DEFINED 1
#define XED_REG_TMP7_DEFINED 1
#define XED_REG_TMP8_DEFINED 1
#define XED_REG_TMP9_DEFINED 1
#define XED_REG_TMP10_DEFINED 1
#define XED_REG_TMP11_DEFINED 1
#define XED_REG_TMP12_DEFINED 1
#define XED_REG_TMP13_DEFINED 1
#define XED_REG_TMP14_DEFINED 1
#define XED_REG_TMP15_DEFINED 1
#define XED_REG_TMM0_DEFINED 1
#define XED_REG_TMM1_DEFINED 1
#define XED_REG_TMM2_DEFINED 1
#define XED_REG_TMM3_DEFINED 1
#define XED_REG_TMM4_DEFINED 1
#define XED_REG_TMM5_DEFINED 1
#define XED_REG_TMM6_DEFINED 1
#define XED_REG_TMM7_DEFINED 1
#define XED_REG_UIF_DEFINED 1
#define XED_REG_ST0_DEFINED 1
#define XED_REG_ST1_DEFINED 1
#define XED_REG_ST2_DEFINED 1
#define XED_REG_ST3_DEFINED 1
#define XED_REG_ST4_DEFINED 1
#define XED_REG_ST5_DEFINED 1
#define XED_REG_ST6_DEFINED 1
#define XED_REG_ST7_DEFINED 1
#define XED_REG_XCR0_DEFINED 1
#define XED_REG_XMM0_DEFINED 1
#define XED_REG_XMM1_DEFINED 1
#define XED_REG_XMM2_DEFINED 1
#define XED_REG_XMM3_DEFINED 1
#define XED_REG_XMM4_DEFINED 1
#define XED_REG_XMM5_DEFINED 1
#define XED_REG_XMM6_DEFINED 1
#define XED_REG_XMM7_DEFINED 1
#define XED_REG_XMM8_DEFINED 1
#define XED_REG_XMM9_DEFINED 1
#define XED_REG_XMM10_DEFINED 1
#define XED_REG_XMM11_DEFINED 1
#define XED_REG_XMM12_DEFINED 1
#define XED_REG_XMM13_DEFINED 1
#define XED_REG_XMM14_DEFINED 1
#define XED_REG_XMM15_DEFINED 1
#define XED_REG_XMM16_DEFINED 1
#define XED_REG_XMM17_DEFINED 1
#define XED_REG_XMM18_DEFINED 1
#define XED_REG_XMM19_DEFINED 1
#define XED_REG_XMM20_DEFINED 1
#define XED_REG_XMM21_DEFINED 1
#define XED_REG_XMM22_DEFINED 1
#define XED_REG_XMM23_DEFINED 1
#define XED_REG_XMM24_DEFINED 1
#define XED_REG_XMM25_DEFINED 1
#define XED_REG_XMM26_DEFINED 1
#define XED_REG_XMM27_DEFINED 1
#define XED_REG_XMM28_DEFINED 1
#define XED_REG_XMM29_DEFINED 1
#define XED_REG_XMM30_DEFINED 1
#define XED_REG_XMM31_DEFINED 1
#define XED_REG_YMM0_DEFINED 1
#define XED_REG_YMM1_DEFINED 1
#define XED_REG_YMM2_DEFINED 1
#define XED_REG_YMM3_DEFINED 1
#define XED_REG_YMM4_DEFINED 1
#define XED_REG_YMM5_DEFINED 1
#define XED_REG_YMM6_DEFINED 1
#define XED_REG_YMM7_DEFINED 1
#define XED_REG_YMM8_DEFINED 1
#define XED_REG_YMM9_DEFINED 1
#define XED_REG_YMM10_DEFINED 1
#define XED_REG_YMM11_DEFINED 1
#define XED_REG_YMM12_DEFINED 1
#define XED_REG_YMM13_DEFINED 1
#define XED_REG_YMM14_DEFINED 1
#define XED_REG_YMM15_DEFINED 1
#define XED_REG_YMM16_DEFINED 1
#define XED_REG_YMM17_DEFINED 1
#define XED_REG_YMM18_DEFINED 1
#define XED_REG_YMM19_DEFINED 1
#define XED_REG_YMM20_DEFINED 1
#define XED_REG_YMM21_DEFINED 1
#define XED_REG_YMM22_DEFINED 1
#define XED_REG_YMM23_DEFINED 1
#define XED_REG_YMM24_DEFINED 1
#define XED_REG_YMM25_DEFINED 1
#define XED_REG_YMM26_DEFINED 1
#define XED_REG_YMM27_DEFINED 1
#define XED_REG_YMM28_DEFINED 1
#define XED_REG_YMM29_DEFINED 1
#define XED_REG_YMM30_DEFINED 1
#define XED_REG_YMM31_DEFINED 1
#define XED_REG_ZMM0_DEFINED 1
#define XED_REG_ZMM1_DEFINED 1
#define XED_REG_ZMM2_DEFINED 1
#define XED_REG_ZMM3_DEFINED 1
#define XED_REG_ZMM4_DEFINED 1
#define XED_REG_ZMM5_DEFINED 1
#define XED_REG_ZMM6_DEFINED 1
#define XED_REG_ZMM7_DEFINED 1
#define XED_REG_ZMM8_DEFINED 1
#define XED_REG_ZMM9_DEFINED 1
#define XED_REG_ZMM10_DEFINED 1
#define XED_REG_ZMM11_DEFINED 1
#define XED_REG_ZMM12_DEFINED 1
#define XED_REG_ZMM13_DEFINED 1
#define XED_REG_ZMM14_DEFINED 1
#define XED_REG_ZMM15_DEFINED 1
#define XED_REG_ZMM16_DEFINED 1
#define XED_REG_ZMM17_DEFINED 1
#define XED_REG_ZMM18_DEFINED 1
#define XED_REG_ZMM19_DEFINED 1
#define XED_REG_ZMM20_DEFINED 1
#define XED_REG_ZMM21_DEFINED 1
#define XED_REG_ZMM22_DEFINED 1
#define XED_REG_ZMM23_DEFINED 1
#define XED_REG_ZMM24_DEFINED 1
#define XED_REG_ZMM25_DEFINED 1
#define XED_REG_ZMM26_DEFINED 1
#define XED_REG_ZMM27_DEFINED 1
#define XED_REG_ZMM28_DEFINED 1
#define XED_REG_ZMM29_DEFINED 1
#define XED_REG_ZMM30_DEFINED 1
#define XED_REG_ZMM31_DEFINED 1
#define XED_REG_LAST_DEFINED 1
#define XED_REG_BNDCFG_FIRST_DEFINED 1
#define XED_REG_BNDCFG_LAST_DEFINED 1
#define XED_REG_BNDSTAT_FIRST_DEFINED 1
#define XED_REG_BNDSTAT_LAST_DEFINED 1
#define XED_REG_BOUND_FIRST_DEFINED 1
#define XED_REG_BOUND_LAST_DEFINED 1
#define XED_REG_CR_FIRST_DEFINED 1
#define XED_REG_CR_LAST_DEFINED 1
#define XED_REG_DR_FIRST_DEFINED 1
#define XED_REG_DR_LAST_DEFINED 1
#define XED_REG_FLAGS_FIRST_DEFINED 1
#define XED_REG_FLAGS_LAST_DEFINED 1
#define XED_REG_GPR16_FIRST_DEFINED 1
#define XED_REG_GPR16_LAST_DEFINED 1
#define XED_REG_GPR32_FIRST_DEFINED 1
#define XED_REG_GPR32_LAST_DEFINED 1
#define XED_REG_GPR64_FIRST_DEFINED 1
#define XED_REG_GPR64_LAST_DEFINED 1
#define XED_REG_GPR8_FIRST_DEFINED 1
#define XED_REG_GPR8_LAST_DEFINED 1
#define XED_REG_GPR8h_FIRST_DEFINED 1
#define XED_REG_GPR8h_LAST_DEFINED 1
#define XED_REG_INVALID_FIRST_DEFINED 1
#define XED_REG_INVALID_LAST_DEFINED 1
#define XED_REG_IP_FIRST_DEFINED 1
#define XED_REG_IP_LAST_DEFINED 1
#define XED_REG_MASK_FIRST_DEFINED 1
#define XED_REG_MASK_LAST_DEFINED 1
#define XED_REG_MMX_FIRST_DEFINED 1
#define XED_REG_MMX_LAST_DEFINED 1
#define XED_REG_MSR_FIRST_DEFINED 1
#define XED_REG_MSR_LAST_DEFINED 1
#define XED_REG_MXCSR_FIRST_DEFINED 1
#define XED_REG_MXCSR_LAST_DEFINED 1
#define XED_REG_PSEUDO_FIRST_DEFINED 1
#define XED_REG_PSEUDO_LAST_DEFINED 1
#define XED_REG_PSEUDOX87_FIRST_DEFINED 1
#define XED_REG_PSEUDOX87_LAST_DEFINED 1
#define XED_REG_SR_FIRST_DEFINED 1
#define XED_REG_SR_LAST_DEFINED 1
#define XED_REG_TMP_FIRST_DEFINED 1
#define XED_REG_TMP_LAST_DEFINED 1
#define XED_REG_TREG_FIRST_DEFINED 1
#define XED_REG_TREG_LAST_DEFINED 1
#define XED_REG_UIF_FIRST_DEFINED 1
#define XED_REG_UIF_LAST_DEFINED 1
#define XED_REG_X87_FIRST_DEFINED 1
#define XED_REG_X87_LAST_DEFINED 1
#define XED_REG_XCR_FIRST_DEFINED 1
#define XED_REG_XCR_LAST_DEFINED 1
#define XED_REG_XMM_FIRST_DEFINED 1
#define XED_REG_XMM_LAST_DEFINED 1
#define XED_REG_YMM_FIRST_DEFINED 1
#define XED_REG_YMM_LAST_DEFINED 1
#define XED_REG_ZMM_FIRST_DEFINED 1
#define XED_REG_ZMM_LAST_DEFINED 1
typedef enum {
  XED_REG_INVALID,
  XED_REG_BNDCFGU,
  XED_REG_BNDSTATUS,
  XED_REG_BND0,
  XED_REG_BND1,
  XED_REG_BND2,
  XED_REG_BND3,
  XED_REG_CR0,
  XED_REG_CR1,
  XED_REG_CR2,
  XED_REG_CR3,
  XED_REG_CR4,
  XED_REG_CR5,
  XED_REG_CR6,
  XED_REG_CR7,
  XED_REG_CR8,
  XED_REG_CR9,
  XED_REG_CR10,
  XED_REG_CR11,
  XED_REG_CR12,
  XED_REG_CR13,
  XED_REG_CR14,
  XED_REG_CR15,
  XED_REG_DR0,
  XED_REG_DR1,
  XED_REG_DR2,
  XED_REG_DR3,
  XED_REG_DR4,
  XED_REG_DR5,
  XED_REG_DR6,
  XED_REG_DR7,
  XED_REG_FLAGS,
  XED_REG_EFLAGS,
  XED_REG_RFLAGS,
  XED_REG_AX,
  XED_REG_CX,
  XED_REG_DX,
  XED_REG_BX,
  XED_REG_SP,
  XED_REG_BP,
  XED_REG_SI,
  XED_REG_DI,
  XED_REG_R8W,
  XED_REG_R9W,
  XED_REG_R10W,
  XED_REG_R11W,
  XED_REG_R12W,
  XED_REG_R13W,
  XED_REG_R14W,
  XED_REG_R15W,
  XED_REG_R16W,
  XED_REG_R17W,
  XED_REG_R18W,
  XED_REG_R19W,
  XED_REG_R20W,
  XED_REG_R21W,
  XED_REG_R22W,
  XED_REG_R23W,
  XED_REG_R24W,
  XED_REG_R25W,
  XED_REG_R26W,
  XED_REG_R27W,
  XED_REG_R28W,
  XED_REG_R29W,
  XED_REG_R30W,
  XED_REG_R31W,
  XED_REG_EAX,
  XED_REG_ECX,
  XED_REG_EDX,
  XED_REG_EBX,
  XED_REG_ESP,
  XED_REG_EBP,
  XED_REG_ESI,
  XED_REG_EDI,
  XED_REG_R8D,
  XED_REG_R9D,
  XED_REG_R10D,
  XED_REG_R11D,
  XED_REG_R12D,
  XED_REG_R13D,
  XED_REG_R14D,
  XED_REG_R15D,
  XED_REG_R16D,
  XED_REG_R17D,
  XED_REG_R18D,
  XED_REG_R19D,
  XED_REG_R20D,
  XED_REG_R21D,
  XED_REG_R22D,
  XED_REG_R23D,
  XED_REG_R24D,
  XED_REG_R25D,
  XED_REG_R26D,
  XED_REG_R27D,
  XED_REG_R28D,
  XED_REG_R29D,
  XED_REG_R30D,
  XED_REG_R31D,
  XED_REG_RAX,
  XED_REG_RCX,
  XED_REG_RDX,
  XED_REG_RBX,
  XED_REG_RSP,
  XED_REG_RBP,
  XED_REG_RSI,
  XED_REG_RDI,
  XED_REG_R8,
  XED_REG_R9,
  XED_REG_R10,
  XED_REG_R11,
  XED_REG_R12,
  XED_REG_R13,
  XED_REG_R14,
  XED_REG_R15,
  XED_REG_R16,
  XED_REG_R17,
  XED_REG_R18,
  XED_REG_R19,
  XED_REG_R20,
  XED_REG_R21,
  XED_REG_R22,
  XED_REG_R23,
  XED_REG_R24,
  XED_REG_R25,
  XED_REG_R26,
  XED_REG_R27,
  XED_REG_R28,
  XED_REG_R29,
  XED_REG_R30,
  XED_REG_R31,
  XED_REG_AL,
  XED_REG_CL,
  XED_REG_DL,
  XED_REG_BL,
  XED_REG_SPL,
  XED_REG_BPL,
  XED_REG_SIL,
  XED_REG_DIL,
  XED_REG_R8B,
  XED_REG_R9B,
  XED_REG_R10B,
  XED_REG_R11B,
  XED_REG_R12B,
  XED_REG_R13B,
  XED_REG_R14B,
  XED_REG_R15B,
  XED_REG_R16B,
  XED_REG_R17B,
  XED_REG_R18B,
  XED_REG_R19B,
  XED_REG_R20B,
  XED_REG_R21B,
  XED_REG_R22B,
  XED_REG_R23B,
  XED_REG_R24B,
  XED_REG_R25B,
  XED_REG_R26B,
  XED_REG_R27B,
  XED_REG_R28B,
  XED_REG_R29B,
  XED_REG_R30B,
  XED_REG_R31B,
  XED_REG_AH,
  XED_REG_CH,
  XED_REG_DH,
  XED_REG_BH,
  XED_REG_ERROR,
  XED_REG_RIP,
  XED_REG_EIP,
  XED_REG_IP,
  XED_REG_K0,
  XED_REG_K1,
  XED_REG_K2,
  XED_REG_K3,
  XED_REG_K4,
  XED_REG_K5,
  XED_REG_K6,
  XED_REG_K7,
  XED_REG_MMX0,
  XED_REG_MMX1,
  XED_REG_MMX2,
  XED_REG_MMX3,
  XED_REG_MMX4,
  XED_REG_MMX5,
  XED_REG_MMX6,
  XED_REG_MMX7,
  XED_REG_SSP,
  XED_REG_IA32_U_CET,
  XED_REG_MXCSR,
  XED_REG_STACKPUSH,
  XED_REG_STACKPOP,
  XED_REG_GDTR,
  XED_REG_LDTR,
  XED_REG_IDTR,
  XED_REG_TR,
  XED_REG_TSC,
  XED_REG_TSCAUX,
  XED_REG_MSRS,
  XED_REG_FSBASE,
  XED_REG_GSBASE,
  XED_REG_TILECONFIG,
  XED_REG_IA32_KERNEL_GS_BASE,
  XED_REG_DFV0,
  XED_REG_DFV1,
  XED_REG_DFV2,
  XED_REG_DFV3,
  XED_REG_DFV4,
  XED_REG_DFV5,
  XED_REG_DFV6,
  XED_REG_DFV7,
  XED_REG_DFV8,
  XED_REG_DFV9,
  XED_REG_DFV10,
  XED_REG_DFV11,
  XED_REG_DFV12,
  XED_REG_DFV13,
  XED_REG_DFV14,
  XED_REG_DFV15,
  XED_REG_X87CONTROL,
  XED_REG_X87STATUS,
  XED_REG_X87TAG,
  XED_REG_X87PUSH,
  XED_REG_X87POP,
  XED_REG_X87POP2,
  XED_REG_X87OPCODE,
  XED_REG_X87LASTCS,
  XED_REG_X87LASTIP,
  XED_REG_X87LASTDS,
  XED_REG_X87LASTDP,
  XED_REG_ES,
  XED_REG_CS,
  XED_REG_SS,
  XED_REG_DS,
  XED_REG_FS,
  XED_REG_GS,
  XED_REG_TMP0,
  XED_REG_TMP1,
  XED_REG_TMP2,
  XED_REG_TMP3,
  XED_REG_TMP4,
  XED_REG_TMP5,
  XED_REG_TMP6,
  XED_REG_TMP7,
  XED_REG_TMP8,
  XED_REG_TMP9,
  XED_REG_TMP10,
  XED_REG_TMP11,
  XED_REG_TMP12,
  XED_REG_TMP13,
  XED_REG_TMP14,
  XED_REG_TMP15,
  XED_REG_TMM0,
  XED_REG_TMM1,
  XED_REG_TMM2,
  XED_REG_TMM3,
  XED_REG_TMM4,
  XED_REG_TMM5,
  XED_REG_TMM6,
  XED_REG_TMM7,
  XED_REG_UIF,
  XED_REG_ST0,
  XED_REG_ST1,
  XED_REG_ST2,
  XED_REG_ST3,
  XED_REG_ST4,
  XED_REG_ST5,
  XED_REG_ST6,
  XED_REG_ST7,
  XED_REG_XCR0,
  XED_REG_XMM0,
  XED_REG_XMM1,
  XED_REG_XMM2,
  XED_REG_XMM3,
  XED_REG_XMM4,
  XED_REG_XMM5,
  XED_REG_XMM6,
  XED_REG_XMM7,
  XED_REG_XMM8,
  XED_REG_XMM9,
  XED_REG_XMM10,
  XED_REG_XMM11,
  XED_REG_XMM12,
  XED_REG_XMM13,
  XED_REG_XMM14,
  XED_REG_XMM15,
  XED_REG_XMM16,
  XED_REG_XMM17,
  XED_REG_XMM18,
  XED_REG_XMM19,
  XED_REG_XMM20,
  XED_REG_XMM21,
  XED_REG_XMM22,
  XED_REG_XMM23,
  XED_REG_XMM24,
  XED_REG_XMM25,
  XED_REG_XMM26,
  XED_REG_XMM27,
  XED_REG_XMM28,
  XED_REG_XMM29,
  XED_REG_XMM30,
  XED_REG_XMM31,
  XED_REG_YMM0,
  XED_REG_YMM1,
  XED_REG_YMM2,
  XED_REG_YMM3,
  XED_REG_YMM4,
  XED_REG_YMM5,
  XED_REG_YMM6,
  XED_REG_YMM7,
  XED_REG_YMM8,
  XED_REG_YMM9,
  XED_REG_YMM10,
  XED_REG_YMM11,
  XED_REG_YMM12,
  XED_REG_YMM13,
  XED_REG_YMM14,
  XED_REG_YMM15,
  XED_REG_YMM16,
  XED_REG_YMM17,
  XED_REG_YMM18,
  XED_REG_YMM19,
  XED_REG_YMM20,
  XED_REG_YMM21,
  XED_REG_YMM22,
  XED_REG_YMM23,
  XED_REG_YMM24,
  XED_REG_YMM25,
  XED_REG_YMM26,
  XED_REG_YMM27,
  XED_REG_YMM28,
  XED_REG_YMM29,
  XED_REG_YMM30,
  XED_REG_YMM31,
  XED_REG_ZMM0,
  XED_REG_ZMM1,
  XED_REG_ZMM2,
  XED_REG_ZMM3,
  XED_REG_ZMM4,
  XED_REG_ZMM5,
  XED_REG_ZMM6,
  XED_REG_ZMM7,
  XED_REG_ZMM8,
  XED_REG_ZMM9,
  XED_REG_ZMM10,
  XED_REG_ZMM11,
  XED_REG_ZMM12,
  XED_REG_ZMM13,
  XED_REG_ZMM14,
  XED_REG_ZMM15,
  XED_REG_ZMM16,
  XED_REG_ZMM17,
  XED_REG_ZMM18,
  XED_REG_ZMM19,
  XED_REG_ZMM20,
  XED_REG_ZMM21,
  XED_REG_ZMM22,
  XED_REG_ZMM23,
  XED_REG_ZMM24,
  XED_REG_ZMM25,
  XED_REG_ZMM26,
  XED_REG_ZMM27,
  XED_REG_ZMM28,
  XED_REG_ZMM29,
  XED_REG_ZMM30,
  XED_REG_ZMM31,
  XED_REG_LAST,
  XED_REG_BNDCFG_FIRST=XED_REG_BNDCFGU, //< PSEUDO
  XED_REG_BNDCFG_LAST=XED_REG_BNDCFGU, //<PSEUDO
  XED_REG_BNDSTAT_FIRST=XED_REG_BNDSTATUS, //< PSEUDO
  XED_REG_BNDSTAT_LAST=XED_REG_BNDSTATUS, //<PSEUDO
  XED_REG_BOUND_FIRST=XED_REG_BND0, //< PSEUDO
  XED_REG_BOUND_LAST=XED_REG_BND3, //<PSEUDO
  XED_REG_CR_FIRST=XED_REG_CR0, //< PSEUDO
  XED_REG_CR_LAST=XED_REG_CR15, //<PSEUDO
  XED_REG_DR_FIRST=XED_REG_DR0, //< PSEUDO
  XED_REG_DR_LAST=XED_REG_DR7, //<PSEUDO
  XED_REG_FLAGS_FIRST=XED_REG_FLAGS, //< PSEUDO
  XED_REG_FLAGS_LAST=XED_REG_RFLAGS, //<PSEUDO
  XED_REG_GPR16_FIRST=XED_REG_AX, //< PSEUDO
  XED_REG_GPR16_LAST=XED_REG_R31W, //<PSEUDO
  XED_REG_GPR32_FIRST=XED_REG_EAX, //< PSEUDO
  XED_REG_GPR32_LAST=XED_REG_R31D, //<PSEUDO
  XED_REG_GPR64_FIRST=XED_REG_RAX, //< PSEUDO
  XED_REG_GPR64_LAST=XED_REG_R31, //<PSEUDO
  XED_REG_GPR8_FIRST=XED_REG_AL, //< PSEUDO
  XED_REG_GPR8_LAST=XED_REG_R31B, //<PSEUDO
  XED_REG_GPR8h_FIRST=XED_REG_AH, //< PSEUDO
  XED_REG_GPR8h_LAST=XED_REG_BH, //<PSEUDO
  XED_REG_INVALID_FIRST=XED_REG_INVALID, //< PSEUDO
  XED_REG_INVALID_LAST=XED_REG_ERROR, //<PSEUDO
  XED_REG_IP_FIRST=XED_REG_RIP, //< PSEUDO
  XED_REG_IP_LAST=XED_REG_IP, //<PSEUDO
  XED_REG_MASK_FIRST=XED_REG_K0, //< PSEUDO
  XED_REG_MASK_LAST=XED_REG_K7, //<PSEUDO
  XED_REG_MMX_FIRST=XED_REG_MMX0, //< PSEUDO
  XED_REG_MMX_LAST=XED_REG_MMX7, //<PSEUDO
  XED_REG_MSR_FIRST=XED_REG_SSP, //< PSEUDO
  XED_REG_MSR_LAST=XED_REG_IA32_U_CET, //<PSEUDO
  XED_REG_MXCSR_FIRST=XED_REG_MXCSR, //< PSEUDO
  XED_REG_MXCSR_LAST=XED_REG_MXCSR, //<PSEUDO
  XED_REG_PSEUDO_FIRST=XED_REG_STACKPUSH, //< PSEUDO
  XED_REG_PSEUDO_LAST=XED_REG_DFV15, //<PSEUDO
  XED_REG_PSEUDOX87_FIRST=XED_REG_X87CONTROL, //< PSEUDO
  XED_REG_PSEUDOX87_LAST=XED_REG_X87LASTDP, //<PSEUDO
  XED_REG_SR_FIRST=XED_REG_ES, //< PSEUDO
  XED_REG_SR_LAST=XED_REG_GS, //<PSEUDO
  XED_REG_TMP_FIRST=XED_REG_TMP0, //< PSEUDO
  XED_REG_TMP_LAST=XED_REG_TMP15, //<PSEUDO
  XED_REG_TREG_FIRST=XED_REG_TMM0, //< PSEUDO
  XED_REG_TREG_LAST=XED_REG_TMM7, //<PSEUDO
  XED_REG_UIF_FIRST=XED_REG_UIF, //< PSEUDO
  XED_REG_UIF_LAST=XED_REG_UIF, //<PSEUDO
  XED_REG_X87_FIRST=XED_REG_ST0, //< PSEUDO
  XED_REG_X87_LAST=XED_REG_ST7, //<PSEUDO
  XED_REG_XCR_FIRST=XED_REG_XCR0, //< PSEUDO
  XED_REG_XCR_LAST=XED_REG_XCR0, //<PSEUDO
  XED_REG_XMM_FIRST=XED_REG_XMM0, //< PSEUDO
  XED_REG_XMM_LAST=XED_REG_XMM31, //<PSEUDO
  XED_REG_YMM_FIRST=XED_REG_YMM0, //< PSEUDO
  XED_REG_YMM_LAST=XED_REG_YMM31, //<PSEUDO
  XED_REG_ZMM_FIRST=XED_REG_ZMM0, //< PSEUDO
  XED_REG_ZMM_LAST=XED_REG_ZMM31 //<PSEUDO
} xed_reg_enum_t;

/// This converts strings to #xed_reg_enum_t types.
/// @param s A C-string.
/// @return #xed_reg_enum_t
/// @ingroup ENUM
XED_DLL_EXPORT xed_reg_enum_t str2xed_reg_enum_t(const char* s);
/// This converts strings to #xed_reg_enum_t types.
/// @param p An enumeration element of type xed_reg_enum_t.
/// @return string
/// @ingroup ENUM
XED_DLL_EXPORT const char* xed_reg_enum_t2str(const xed_reg_enum_t p);

/// Returns the last element of the enumeration
/// @return xed_reg_enum_t The last element of the enumeration.
/// @ingroup ENUM
XED_DLL_EXPORT xed_reg_enum_t xed_reg_enum_t_last(void);
#endif
