﻿!mod$ v1 sum:9f8aa3d6e64573f2
!need$ fad59bc1560ba7b1 n mbd_lapack
!need$ 4d3ad4f29fa4ff76 n mbd_utils
!need$ 58272acdba890bc4 n mbd_constants
module mbd_matrix
use mbd_lapack,only:mmul
use mbd_lapack,only:invh
use mbd_lapack,only:eigh
use mbd_lapack,only:eigvals
use mbd_lapack,only:eigvalsh
use mbd_utils,only:findval
use mbd_utils,only:exception_t
use mbd_utils,only:atom_index_t
use mbd_utils,only:is_true
use mbd_utils,only:clock_t
use mbd_constants,only:dp
use mbd_constants,only:kind
use mbd_constants,only:pi
use mbd_constants,only:acos
use mbd_constants,only:ang
use mbd_constants,only:mbd_exc_neg_eigvals
use mbd_constants,only:mbd_exc_neg_pol
use mbd_constants,only:mbd_exc_linalg
use mbd_constants,only:mbd_exc_unimpl
use mbd_constants,only:mbd_exc_damping
use mbd_constants,only:mbd_exc_input
use mbd_constants,only:mbd_log_lvl_debug
use mbd_constants,only:mbd_log_lvl_info
use mbd_constants,only:mbd_log_lvl_warn
use mbd_constants,only:mbd_log_lvl_error
use mbd_constants,only:zero_real
use mbd_constants,only:zero_complex
use mbd_constants,only:imi
use mbd_lapack,only:mbd_lapack$mbd_lapack$eigh_complex=>eigh_complex
use mbd_lapack,only:mbd_lapack$mbd_lapack$eigh_real=>eigh_real
use mbd_lapack,only:mbd_lapack$mbd_lapack$eigvals_real=>eigvals_real
use mbd_lapack,only:mbd_lapack$mbd_lapack$eigvalsh_complex=>eigvalsh_complex
use mbd_lapack,only:mbd_lapack$mbd_lapack$eigvalsh_real=>eigvalsh_real
use mbd_lapack,only:mbd_lapack$mbd_lapack$invh_real=>invh_real
use mbd_lapack,only:mbd_lapack$mbd_lapack$mmul_complex=>mmul_complex
use mbd_lapack,only:mbd_lapack$mbd_lapack$mmul_real=>mmul_real
use mbd_utils,only:mbd_utils$mbd_utils$findval_int=>findval_int
private::mmul
private::invh
private::eigh
private::eigvals
private::eigvalsh
private::findval
private::exception_t
private::atom_index_t
private::is_true
private::clock_t
private::dp
private::kind
private::pi
private::acos
private::ang
private::mbd_exc_neg_eigvals
private::mbd_exc_neg_pol
private::mbd_exc_linalg
private::mbd_exc_unimpl
private::mbd_exc_damping
private::mbd_exc_input
private::mbd_log_lvl_debug
private::mbd_log_lvl_info
private::mbd_log_lvl_warn
private::mbd_log_lvl_error
private::zero_real
private::zero_complex
private::imi
private::mbd_lapack$mbd_lapack$eigh_complex
private::mbd_lapack$mbd_lapack$eigh_real
private::mbd_lapack$mbd_lapack$eigvals_real
private::mbd_lapack$mbd_lapack$eigvalsh_complex
private::mbd_lapack$mbd_lapack$eigvalsh_real
private::mbd_lapack$mbd_lapack$invh_real
private::mbd_lapack$mbd_lapack$mmul_complex
private::mbd_lapack$mbd_lapack$mmul_real
private::mbd_utils$mbd_utils$findval_int
type::matrix_re_t
real(8),allocatable::val(:,:)
type(atom_index_t)::idx
contains
procedure::siz=>matrix_re_siz
procedure::init=>matrix_re_init
procedure::add_diag=>matrix_re_add_diag
procedure::add_diag_scalar=>matrix_re_add_diag_scalar
procedure::mult_cross=>matrix_re_mult_cross
procedure::mult_rows=>matrix_re_mult_rows
procedure::mult_cols_3n=>matrix_re_mult_cols_3n
procedure::mult_col=>matrix_re_mult_col
procedure::mmul=>matrix_re_mmul
procedure::invh=>matrix_re_invh
procedure::eigh=>matrix_re_eigh
procedure::eigvals=>matrix_re_eigvals
procedure::eigvalsh=>matrix_re_eigvalsh
procedure::sum_all=>matrix_re_sum_all
procedure::contract_n_transp=>matrix_re_contract_n_transp
procedure::contract_n33diag_cols=>matrix_re_contract_n33diag_cols
procedure::contract_n33_rows=>matrix_re_contract_n33_rows
procedure::copy_from=>matrix_re_copy_from
procedure::move_from=>matrix_re_move_from
procedure::init_from=>matrix_re_init_from
procedure::alloc_from=>matrix_re_alloc_from
end type
type::matrix_cplx_t
complex(8),allocatable::val(:,:)
type(atom_index_t)::idx
contains
procedure::siz=>matrix_cplx_siz
procedure::init=>matrix_cplx_init
procedure::add_diag=>matrix_cplx_add_diag
procedure::add_diag_scalar=>matrix_cplx_add_diag_scalar
procedure::mult_cross=>matrix_cplx_mult_cross
procedure::mult_rows=>matrix_cplx_mult_rows
procedure::mult_cols_3n=>matrix_cplx_mult_cols_3n
procedure::mult_col=>matrix_cplx_mult_col
procedure::mmul=>matrix_cplx_mmul
procedure::eigh=>matrix_cplx_eigh
procedure::eigvalsh=>matrix_cplx_eigvalsh
procedure::sum_all=>matrix_cplx_sum_all
procedure::contract_n_transp=>matrix_cplx_contract_n_transp
procedure::contract_n33diag_cols=>matrix_cplx_contract_n33diag_cols
procedure::contract_n33_rows=>matrix_cplx_contract_n33_rows
procedure::copy_from=>matrix_cplx_copy_from
procedure::move_from=>matrix_cplx_move_from
procedure::init_from=>matrix_cplx_init_from
procedure::alloc_from=>matrix_cplx_alloc_from
end type
private::matrix_re_siz
private::matrix_re_init
private::matrix_re_init_from
private::matrix_re_copy_from
private::matrix_re_move_from
private::matrix_re_alloc_from
private::matrix_re_add_diag_scalar
private::matrix_re_add_diag
private::matrix_re_mult_cross
private::matrix_re_mult_rows
private::matrix_re_mult_cols_3n
private::matrix_re_mult_col
private::matrix_re_eigh
private::matrix_re_eigvalsh
private::matrix_re_sum_all
private::matrix_re_contract_n_transp
private::contract_cross_33_real
private::matrix_re_contract_n33diag_cols
private::matrix_re_contract_n33_rows
private::matrix_re_mmul
private::matrix_cplx_siz
private::matrix_cplx_init
private::matrix_cplx_init_from
private::matrix_cplx_copy_from
private::matrix_cplx_move_from
private::matrix_cplx_alloc_from
private::matrix_cplx_add_diag_scalar
private::matrix_cplx_add_diag
private::matrix_cplx_mult_cross
private::matrix_cplx_mult_rows
private::matrix_cplx_mult_cols_3n
private::matrix_cplx_mult_col
private::matrix_cplx_eigh
private::matrix_cplx_eigvalsh
private::matrix_cplx_sum_all
private::matrix_cplx_contract_n_transp
private::contract_cross_33_complex
private::matrix_cplx_contract_n33diag_cols
private::matrix_cplx_contract_n33_rows
private::matrix_cplx_mmul
private::matrix_re_invh
private::matrix_re_eigvals
interface contract_cross_33
procedure::contract_cross_33_real
procedure::contract_cross_33_complex
end interface
contains
function matrix_re_siz(this,ndim) result(siz)
class(matrix_re_t),intent(in)::this
integer(4),intent(in)::ndim
integer(4)::siz
end
subroutine matrix_re_init(this,idx)
class(matrix_re_t),intent(out)::this
type(atom_index_t),intent(in)::idx
end
subroutine matrix_re_init_from(this,other)
class(matrix_re_t),intent(out)::this
type(matrix_re_t),intent(in)::other
end
subroutine matrix_re_copy_from(this,other)
class(matrix_re_t),intent(out)::this
type(matrix_re_t),intent(in)::other
end
subroutine matrix_re_move_from(this,other)
class(matrix_re_t),intent(out)::this
type(matrix_re_t),intent(inout)::other
end
subroutine matrix_re_alloc_from(this,other)
class(matrix_re_t),intent(out)::this
type(matrix_re_t),intent(in)::other
end
subroutine matrix_re_add_diag_scalar(this,d)
class(matrix_re_t),intent(inout)::this
real(8),intent(in)::d
end
subroutine matrix_re_add_diag(this,d)
class(matrix_re_t),intent(inout)::this
real(8),intent(in)::d(:)
end
subroutine matrix_re_mult_cross(this,b,c)
class(matrix_re_t),intent(inout)::this
real(8),intent(in)::b(:)
real(8),intent(in),optional::c(:)
end
subroutine matrix_re_mult_rows(this,b)
class(matrix_re_t),intent(inout)::this
real(8),intent(in)::b(:)
end
subroutine matrix_re_mult_cols_3n(this,b)
class(matrix_re_t),intent(inout)::this
real(8),intent(in)::b(:)
end
subroutine matrix_re_mult_col(this,idx,a)
class(matrix_re_t),intent(inout)::this
integer(4),intent(in)::idx
real(8),intent(in)::a(:)
end
subroutine matrix_re_eigh(a,eigs,exc,src,vals_only,clock)
class(matrix_re_t),intent(inout)::a
real(8),intent(out)::eigs(:)
type(exception_t),intent(out),optional::exc
type(matrix_re_t),intent(in),optional::src
logical(4),intent(in),optional::vals_only
type(clock_t),intent(inout),optional::clock
end
function matrix_re_eigvalsh(a,exc,destroy,clock) result(eigs)
class(matrix_re_t),intent(inout)::a
type(exception_t),intent(out),optional::exc
logical(4),intent(in),optional::destroy
type(clock_t),intent(inout),optional::clock
real(8)::eigs(1_8:int(3_4*a%idx%n_atoms,kind=8))
end
function matrix_re_sum_all(this) result(res)
class(matrix_re_t),intent(in)::this
real(8)::res
end
subroutine matrix_re_contract_n_transp(this,dir,res)
class(matrix_re_t),intent(in)::this
character(*,1),intent(in)::dir
real(8),intent(out),target::res(:,:)
end
function contract_cross_33_real(k_atom,a,a_prime,b,b_prime) result(res)
integer(4),intent(in)::k_atom
type(matrix_re_t),intent(in)::a
real(8),intent(in)::a_prime(:,:)
type(matrix_re_t),intent(in)::b
real(8),intent(in)::b_prime(:,:)
real(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_re_contract_n33diag_cols(a) result(res)
class(matrix_re_t),intent(in)::a
real(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_re_contract_n33_rows(a) result(res)
class(matrix_re_t),intent(in)::a
real(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_re_mmul(a,b,transa,transb) result(c)
class(matrix_re_t),intent(in)::a
type(matrix_re_t),intent(in)::b
character(1_8,1),intent(in),optional::transa
character(1_8,1),intent(in),optional::transb
type(matrix_re_t)::c
end
function matrix_cplx_siz(this,ndim) result(siz)
class(matrix_cplx_t),intent(in)::this
integer(4),intent(in)::ndim
integer(4)::siz
end
subroutine matrix_cplx_init(this,idx)
class(matrix_cplx_t),intent(out)::this
type(atom_index_t),intent(in)::idx
end
subroutine matrix_cplx_init_from(this,other)
class(matrix_cplx_t),intent(out)::this
type(matrix_cplx_t),intent(in)::other
end
subroutine matrix_cplx_copy_from(this,other)
class(matrix_cplx_t),intent(out)::this
type(matrix_cplx_t),intent(in)::other
end
subroutine matrix_cplx_move_from(this,other)
class(matrix_cplx_t),intent(out)::this
type(matrix_cplx_t),intent(inout)::other
end
subroutine matrix_cplx_alloc_from(this,other)
class(matrix_cplx_t),intent(out)::this
type(matrix_cplx_t),intent(in)::other
end
subroutine matrix_cplx_add_diag_scalar(this,d)
class(matrix_cplx_t),intent(inout)::this
real(8),intent(in)::d
end
subroutine matrix_cplx_add_diag(this,d)
class(matrix_cplx_t),intent(inout)::this
real(8),intent(in)::d(:)
end
subroutine matrix_cplx_mult_cross(this,b,c)
class(matrix_cplx_t),intent(inout)::this
real(8),intent(in)::b(:)
real(8),intent(in),optional::c(:)
end
subroutine matrix_cplx_mult_rows(this,b)
class(matrix_cplx_t),intent(inout)::this
real(8),intent(in)::b(:)
end
subroutine matrix_cplx_mult_cols_3n(this,b)
class(matrix_cplx_t),intent(inout)::this
real(8),intent(in)::b(:)
end
subroutine matrix_cplx_mult_col(this,idx,a)
class(matrix_cplx_t),intent(inout)::this
integer(4),intent(in)::idx
real(8),intent(in)::a(:)
end
subroutine matrix_cplx_eigh(a,eigs,exc,src,vals_only,clock)
class(matrix_cplx_t),intent(inout)::a
real(8),intent(out)::eigs(:)
type(exception_t),intent(out),optional::exc
type(matrix_cplx_t),intent(in),optional::src
logical(4),intent(in),optional::vals_only
type(clock_t),intent(inout),optional::clock
end
function matrix_cplx_eigvalsh(a,exc,destroy,clock) result(eigs)
class(matrix_cplx_t),intent(inout)::a
type(exception_t),intent(out),optional::exc
logical(4),intent(in),optional::destroy
type(clock_t),intent(inout),optional::clock
real(8)::eigs(1_8:int(3_4*a%idx%n_atoms,kind=8))
end
function matrix_cplx_sum_all(this) result(res)
class(matrix_cplx_t),intent(in)::this
complex(8)::res
end
subroutine matrix_cplx_contract_n_transp(this,dir,res)
class(matrix_cplx_t),intent(in)::this
character(*,1),intent(in)::dir
complex(8),intent(out),target::res(:,:)
end
function contract_cross_33_complex(k_atom,a,a_prime,b,b_prime) result(res)
integer(4),intent(in)::k_atom
type(matrix_cplx_t),intent(in)::a
complex(8),intent(in)::a_prime(:,:)
type(matrix_cplx_t),intent(in)::b
complex(8),intent(in)::b_prime(:,:)
complex(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_cplx_contract_n33diag_cols(a) result(res)
class(matrix_cplx_t),intent(in)::a
complex(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_cplx_contract_n33_rows(a) result(res)
class(matrix_cplx_t),intent(in)::a
complex(8)::res(1_8:int(a%idx%n_atoms,kind=8))
end
function matrix_cplx_mmul(a,b,transa,transb) result(c)
class(matrix_cplx_t),intent(in)::a
type(matrix_cplx_t),intent(in)::b
character(1_8,1),intent(in),optional::transa
character(1_8,1),intent(in),optional::transb
type(matrix_cplx_t)::c
end
subroutine matrix_re_invh(a,exc,src,clock)
class(matrix_re_t),intent(inout)::a
type(exception_t),intent(out),optional::exc
type(matrix_re_t),intent(in),optional::src
type(clock_t),intent(inout),optional::clock
end
function matrix_re_eigvals(a,exc,destroy) result(eigs)
class(matrix_re_t),intent(in),target::a
type(exception_t),intent(out),optional::exc
logical(4),intent(in),optional::destroy
complex(8)::eigs(1_8:int(3_4*a%idx%n_atoms,kind=8))
end
end
