%feature("docstring") OT::NormalFactory
"Normal factory.

Parameters
----------
robust : bool, optional
    Flag to select robust estimators of the parameters.
    
    By default, robust is False.

Notes
-----    
The parameters are estimated by likelihood maximization if *robust=False*:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\vect{\\mu}}_n^{\\strut} = \\bar{\\vect{x}}_n\\\\
      \\displaystyle\\Hat{\\mathrm{Cov}}_n = \\frac{1}{n-1}\\sum_{i=1}^n\\left(\\vect{X}_i-\\Hat{\\vect{\\mu}}_n\\right)\\left(\\vect{X}_i-\\Hat{\\vect{\\mu}}_n\\right)^t
    \\end{eqnarray*}

If *robust=True*, the estimation is done using the empirical median :math:`q_{n, 0.5}` as an estimate of :math:`\\mu`, the empirical inter-quartile :math:`frac{q_{n, 0.75}-q_{n, 0.25}}{a_{0.75}-a_{0.25}}` as an estimate of the standard deviation, where :math:`a_{0.75}` and :math:`a_{0.25}` are the 75% and 25% quantiles of the standard normal distribution, and the correlation matrix :math:`R_n` is estimated as the shape matrix of the underlying :class:`~openturns.NormalCopula` using :class:`~openturns.NormalCopulaFactory`.

See also
--------
DistributionFactory, Normal, NormalCopulaFactory

Examples
--------

In the following example, the parameters of a :class:`~openturns.Normal` 
are estimated from a sample. 

>>> import openturns as ot
>>> ot.RandomGenerator.SetSeed(0)
>>> size = 10000
>>> distribution = ot.Normal(1.0, 2.0)
>>> sample = distribution.getSample(size)
>>> factory = ot.NormalFactory()
>>> estimated = factory.build(sample)"

// ----------------------------------------------------------------------------

%feature("docstring") OT::NormalFactory::buildAsNormal
"Estimate the distribution as native distribution.


**Available usages**:

    buildAsNormal()

    buildAsNormal(*sample*)

    buildAsNormal(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
   The parameters of the :class:`~openturns.Normal`.

Returns
-------
distribution : :class:`~openturns.Normal`
    The estimated distribution as a Normal.
    
    In the first usage, the default Normal distribution is built."
