%feature("docstring") OT::Tuples
"Tuples generator.

Available constructors:
    Tuples()

    Tuples(*bounds*)

Parameters
----------
bounds : :class:`~openturns.Indices`
    The cardinal of all the sets forming the cartesian product.

See also
--------
CombinatorialGenerator, Combinations, KPermutations

Notes
-----
In the first usage, the generator is built using the default values
:math:`bounds = [1]`.

In the second usage, the generator produces all the indices
:math:`[i_0, \\ldots, i_{d-1}]` with :math:`i_k \\in \\{0, \\ldots, bounds[k] - 1\\}`
where :math:`d` is the dimension of *bounds*.

The number of indices generated is:

.. math::
    
    \\prod_{k = 0}^{d - 1} bounds[k]

The tuples generator generates a collection of :class:`~openturns.Indices` that
contains all the elements of the following Cartesian product:

.. math::
    
    \\prod_{k = 0}^{d - 1} \\{ 0, \\ldots, bounds[k] -1 \\}

Examples
--------
>>> import openturns as ot
>>> tuples = ot.Tuples([3, 4])
>>> print(tuples.generate())
[[0,0],[1,0],[2,0],[0,1],[1,1],[2,1],[0,2],[1,2],[2,2],[0,3],[1,3],[2,3]]#12
"

// ---------------------------------------------------------------------

%feature("docstring") OT::Tuples::getBounds
"Accessor to the bounds.

Returns
-------
bounds : :class:`~openturns.Indices`
    The cardinal of all the sets forming the cartesian product."

// ---------------------------------------------------------------------

%feature("docstring") OT::Tuples::setBounds
"Accessor to the bounds.

Parameters
----------
bounds : :class:`~openturns.Indices`
    The cardinal of all the sets forming the cartesian product."
