%feature("docstring") OT::TranslationFunction
"Translation function.

Parameters
----------
constant : sequence of float
    Vector :math:`\\vect{c}`.

See also
--------
Function

Notes
-----
This implements a :class:`~openturns.Function` :math:`f`
defined as :

.. math::

    f : & \\Rset^n \\rightarrow \\Rset^n  \\\\
        & \\vect{X} \\mapsto \\vect{X} + \\vect{c}

where:

- :math:`\\vect{c}` is the :math:`\\Rset^n` vector defined by the object *constant*."

// ---------------------------------------------------------------------

%feature("docstring") OT::TranslationFunction::getConstant
"Accessor to the constant.

Returns
-------
constant : :class:`~openturns.Point`
    Vector :math:`\\vect{c}`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::TranslationFunction::setConstant
"Accessor to the constant.

Parameters
----------
constant : sequence of float
    Vector :math:`\\vect{c}`
"
