/**
 *
 * @file spm/config.h.in
 *
 * Spm configuration parameters
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 1.2.4
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Tony Delarue
 * @date 2024-07-02
 *
 **/
#ifndef _spm_config_h_
#define _spm_config_h_

#define SPM_VERSION_MAJOR 1
#define SPM_VERSION_MINOR 2
#define SPM_VERSION_MICRO 4

/* #undef SPM_WITH_FORTRAN */
/* #undef SPM_WITH_MPI */

#define SPM_MPI_COMM_SIZE 4

/* system */
#define HAVE_FALLTHROUGH
#define HAVE_ASPRINTF
#define HAVE_VASPRINTF
#define HAVE_GETOPT_LONG
#define HAVE_GETOPT_H
#define HAVE_COMPLEX_H

/* BLAS set_num_threads */
#define HAVE_BLAS_SET_NUM_THREADS
/* #undef HAVE_BLI_THREAD_SET_NUM_THREADS */
/* #undef HAVE_MKL_SET_NUM_THREADS */
#define HAVE_OPENBLAS_SET_NUM_THREADS

/* Datatypes used */
/* #undef SPM_INT64 */

/* Exploit the scotch version from the library compiling spm */
#define SPM_WITH_SCOTCH

/* LAPACKE */
#define LAPACKE_WITH_LASCL
#define LAPACKE_WITH_LASSQ

#if defined(HAVE_FALLTHROUGH)
#define spm_attr_fallthrough __attribute__((fallthrough))
#else
#define spm_attr_fallthrough do {} while(0)
#endif

#if defined(WIN32) || defined(_WIN32)
#define SPM_OS_WINDOWS 1
#endif

/*
 * BEGIN_C_DECLS should be used at the beginning of your declarations,
 * so that C++ compilers don't mangle their names.  Use END_C_DECLS at
 * the end of C declarations.
 */
#undef BEGIN_C_DECLS
#undef END_C_DECLS
#if defined(c_plusplus) || defined(__cplusplus)
# define BEGIN_C_DECLS extern "C" {
# define END_C_DECLS }
#else
#define BEGIN_C_DECLS          /* empty */
#define END_C_DECLS            /* empty */
#endif

#endif /* _spm_config_h_ */
