from ...core.utils import general

IMAQ_errors = {
        0xBFF60001: "IMG_ERR_FIRST_ERROR",
        0xBFF60001: "IMG_ERR_NOT_SUPPORTED",
        0xBFF60003: "IMG_ERR_SYSTEM_MEMORY_FULL",
        0xBFF6000E: "IMG_ERR_BUFFER_SIZE_TOO_SMALL",
        0xBFF60013: "IMG_ERR_BUFFER_LIST_NOT_LOCKED",
        0xBFF60015: "IMG_ERR_BAD_INTERFACE_FILE",
        0xBFF60017: "IMG_ERR_BAD_USER_RECT",
        0xBFF60018: "IMG_ERR_BAD_CAMERA_FILE",
        0xBFF6001A: "IMG_ERR_NO_BUFFERS_CONFIGURED",
        0xBFF6001B: "IMG_ERR_BAD_BUFFER_LIST_FINAL_COMMAND",
        0xBFF6001C: "IMG_ERR_BAD_BUFFER_LIST_COMMAND",
        0xBFF6001D: "IMG_ERR_BAD_BUFFER_POINTER",
        0xBFF6001E: "IMG_ERR_BOARD_NOT_RUNNING",
        0xBFF6001F: "IMG_ERR_VIDEO_LOCK",
        0xBFF60021: "IMG_ERR_BOARD_RUNNING",
        0xBFF60022: "IMG_ERR_TIMEOUT",
        0xBFF60024: "IMG_ERR_ZERO_BUFFER_SIZE",
        0xBFF60027: "IMG_ERR_NO_INTERFACE_FOUND",
        0xBFF6002C: "IMG_ERR_FIFO_OVERFLOW",
        0xBFF6002D: "IMG_ERR_MEMORY_PAGE_LOCK_FAULT",
        0xBFF60034: "IMG_ERR_BAD_CAMERA_TYPE",
        0xBFF60038: "IMG_ERR_BAD_CLOCK_FREQUENCY",
        0xBFF6003A: "IMG_ERR_HARDWARE_NOT_CAPABLE",
        0xBFF60044: "IMG_ERR_ATTRIBUTE_NOT_SETTABLE",
        0xBFF6004D: "IMG_ERR_ONBOARD_MEMORY_FULL",
        0xBFF60051: "IMG_ERR_BUFFER_NOT_RELEASED",
        0xBFF60052: "IMG_ERR_BAD_LUT_TYPE",
        0xBFF60053: "IMG_ERR_ATTRIBUTE_NOT_READABLE",
        0xBFF60054: "IMG_ERR_BOARD_NOT_SUPPORTED",
        0xBFF60055: "IMG_ERR_BAD_FRAME_FIELD",
        0xBFF60056: "IMG_ERR_INVALID_ATTRIBUTE",
        0xBFF60057: "IMG_ERR_BAD_LINE_MAP",
        0xBFF60059: "IMG_ERR_BAD_CHANNEL",
        0xBFF6005A: "IMG_ERR_BAD_CHROMA_FILTER",
        0xBFF6005B: "IMG_ERR_BAD_SCALE",
        0xBFF6005D: "IMG_ERR_BAD_TRIGGER_MODE",
        0xBFF6005E: "IMG_ERR_BAD_CLAMP_START",
        0xBFF6005F: "IMG_ERR_BAD_CLAMP_STOP",
        0xBFF60060: "IMG_ERR_BAD_BRIGHTNESS",
        0xBFF60061: "IMG_ERR_BAD_CONTRAST",
        0xBFF60062: "IMG_ERR_BAD_SATURATION",
        0xBFF60063: "IMG_ERR_BAD_TINT",
        0xBFF60064: "IMG_ERR_BAD_HUE_OFF_ANGLE",
        0xBFF60065: "IMG_ERR_BAD_ACQUIRE_FIELD",
        0xBFF60066: "IMG_ERR_BAD_LUMA_BANDWIDTH",
        0xBFF60067: "IMG_ERR_BAD_LUMA_COMB",
        0xBFF60068: "IMG_ERR_BAD_CHROMA_PROCESS",
        0xBFF60069: "IMG_ERR_BAD_CHROMA_BANDWIDTH",
        0xBFF6006A: "IMG_ERR_BAD_CHROMA_COMB",
        0xBFF6006B: "IMG_ERR_BAD_RGB_CORING",
        0xBFF6006C: "IMG_ERR_BAD_HUE_REPLACE_VALUE",
        0xBFF6006D: "IMG_ERR_BAD_RED_GAIN",
        0xBFF6006E: "IMG_ERR_BAD_GREEN_GAIN",
        0xBFF6006F: "IMG_ERR_BAD_BLUE_GAIN",
        0xBFF60070: "IMG_ERR_BAD_START_FIELD",
        0xBFF60071: "IMG_ERR_BAD_TAP_DIRECTION",
        0xBFF60072: "IMG_ERR_BAD_MAX_IMAGE_RECT",
        0xBFF60073: "IMG_ERR_BAD_TAP_TYPE",
        0xBFF60074: "IMG_ERR_BAD_SYNC_RECT",
        0xBFF60075: "IMG_ERR_BAD_ACQWINDOW_RECT",
        0xBFF60076: "IMG_ERR_BAD_HSL_CORING",
        0xBFF60077: "IMG_ERR_BAD_TAP_0_VALID_RECT",
        0xBFF60078: "IMG_ERR_BAD_TAP_1_VALID_RECT",
        0xBFF60079: "IMG_ERR_BAD_TAP_2_VALID_RECT",
        0xBFF6007A: "IMG_ERR_BAD_TAP_3_VALID_RECT",
        0xBFF6007B: "IMG_ERR_BAD_TAP_RECT",
        0xBFF6007C: "IMG_ERR_BAD_NUM_TAPS",
        0xBFF6007D: "IMG_ERR_BAD_TAP_NUM",
        0xBFF6007E: "IMG_ERR_BAD_QUAD_NUM",
        0xBFF6007F: "IMG_ERR_BAD_NUM_DATA_LINES",
        0xBFF60080: "IMG_ERR_BAD_BITS_PER_COMPONENT",
        0xBFF60081: "IMG_ERR_BAD_NUM_COMPONENTS",
        0xBFF60082: "IMG_ERR_BAD_BIN_THRESHOLD_LOW",
        0xBFF60083: "IMG_ERR_BAD_BIN_THRESHOLD_HIGH",
        0xBFF60084: "IMG_ERR_BAD_BLACK_REF_VOLT",
        0xBFF60085: "IMG_ERR_BAD_WHITE_REF_VOLT",
        0xBFF60086: "IMG_ERR_BAD_FREQ_STD",
        0xBFF60087: "IMG_ERR_BAD_HDELAY",
        0xBFF60088: "IMG_ERR_BAD_LOCK_SPEED",
        0xBFF60089: "IMG_ERR_BAD_BUFFER_LIST",
        0xBFF6008A: "IMG_ERR_BOARD_NOT_INITIALIZED",
        0xBFF6008B: "IMG_ERR_BAD_PCLK_SOURCE",
        0xBFF6008C: "IMG_ERR_BAD_VIDEO_LOCK_CHANNEL",
        0xBFF6008D: "IMG_ERR_BAD_LOCK_SEL",
        0xBFF6008E: "IMG_ERR_BAD_BAUD_RATE",
        0xBFF6008F: "IMG_ERR_BAD_STOP_BITS",
        0xBFF60090: "IMG_ERR_BAD_DATA_BITS",
        0xBFF60091: "IMG_ERR_BAD_PARITY",
        0xBFF60092: "IMG_ERR_TERM_STRING_NOT_FOUND",
        0xBFF60093: "IMG_ERR_SERIAL_READ_TIMEOUT",
        0xBFF60094: "IMG_ERR_SERIAL_WRITE_TIMEOUT",
        0xBFF60095: "IMG_ERR_BAD_SYNCHRONICITY",
        0xBFF60096: "IMG_ERR_BAD_INTERLACING_CONFIG",
        0xBFF60098: "IMG_ERR_BAD_CHIP_CODE",
        0xBFF60099: "IMG_ERR_LUT_NOT_PRESENT",
        0xBFF6009A: "IMG_ERR_DSPFILTER_NOT_PRESENT",
        0xBFF6009B: "IMG_ERR_DEVICE_NOT_FOUND",
        0xBFF6009C: "IMG_ERR_ONBOARD_MEM_CONFIG",
        0xBFF6009D: "IMG_ERR_BAD_POINTER",
        0xBFF6009E: "IMG_ERR_BAD_BUFFER_LIST_INDEX",
        0xBFF6009F: "IMG_ERR_INVALID_BUFFER_ATTRIBUTE",
        0xBFF600A0: "IMG_ERR_INVALID_BUFFER_PTR",
        0xBFF600A1: "IMG_ERR_BUFFER_LIST_ALREADY_LOCKED",
        0xBFF600A2: "IMG_ERR_BAD_DEVICE_TYPE",
        0xBFF600A3: "IMG_ERR_BAD_BAR_SIZE",
        0xBFF600A5: "IMG_ERR_NO_VALID_COUNTER_RECT",
        0xBFF600A6: "IMG_ERR_ACQ_STOPPED",
        0xBFF600A7: "IMG_ERR_BAD_TRIGGER_ACTION",
        0xBFF600A8: "IMG_ERR_BAD_TRIGGER_POLARITY",
        0xBFF600A9: "IMG_ERR_BAD_TRIGGER_NUMBER",
        0xBFF600AA: "IMG_ERR_BUFFER_NOT_AVAILABLE",
        0xBFF600AC: "IMG_ERR_BAD_PULSE_ID",
        0xBFF600AD: "IMG_ERR_BAD_PULSE_TIMEBASE",
        0xBFF600AE: "IMG_ERR_BAD_PULSE_GATE",
        0xBFF600AF: "IMG_ERR_BAD_PULSE_GATE_POLARITY",
        0xBFF600B0: "IMG_ERR_BAD_PULSE_OUTPUT",
        0xBFF600B1: "IMG_ERR_BAD_PULSE_OUTPUT_POLARITY",
        0xBFF600B2: "IMG_ERR_BAD_PULSE_MODE",
        0xBFF600B3: "IMG_ERR_NOT_ENOUGH_RESOURCES",
        0xBFF600B4: "IMG_ERR_INVALID_RESOURCE",
        0xBFF600B5: "IMG_ERR_BAD_FVAL_ENABLE",
        0xBFF600B6: "IMG_ERR_BAD_WRITE_ENABLE_MODE",
        0xBFF600B7: "IMG_ERR_COMPONENT_MISMATCH",
        0xBFF600B8: "IMG_ERR_FPGA_PROGRAMMING_FAILED",
        0xBFF600B9: "IMG_ERR_CONTROL_FPGA_FAILED",
        0xBFF600BA: "IMG_ERR_CHIP_NOT_READABLE",
        0xBFF600BB: "IMG_ERR_CHIP_NOT_WRITABLE",
        0xBFF600BC: "IMG_ERR_I2C_BUS_FAILED",
        0xBFF600BD: "IMG_ERR_DEVICE_IN_USE",
        0xBFF600BE: "IMG_ERR_BAD_TAP_DATALANES",
        0xBFF600BF: "IMG_ERR_BAD_VIDEO_GAIN",
        0xBFF600C0: "IMG_ERR_VHA_MODE_NOT_ALLOWED",
        0xBFF600C1: "IMG_ERR_BAD_TRACKING_SPEED",
        0xBFF600C2: "IMG_ERR_BAD_COLOR_INPUT_SELECT",
        0xBFF600C3: "IMG_ERR_BAD_HAV_OFFSET",
        0xBFF600C4: "IMG_ERR_BAD_HS1_OFFSET",
        0xBFF600C5: "IMG_ERR_BAD_HS2_OFFSET",
        0xBFF600C6: "IMG_ERR_BAD_IF_CHROMA",
        0xBFF600C7: "IMG_ERR_BAD_COLOR_OUTPUT_FORMAT",
        0xBFF600C8: "IMG_ERR_BAD_SAMSUNG_SCHCMP",
        0xBFF600C9: "IMG_ERR_BAD_SAMSUNG_CDLY",
        0xBFF600CA: "IMG_ERR_BAD_SECAM_DETECT",
        0xBFF600CB: "IMG_ERR_BAD_FSC_DETECT",
        0xBFF600CC: "IMG_ERR_BAD_SAMSUNG_CFTC",
        0xBFF600CD: "IMG_ERR_BAD_SAMSUNG_CGTC",
        0xBFF600CE: "IMG_ERR_BAD_SAMSUNG_SAMPLE_RATE",
        0xBFF600CF: "IMG_ERR_BAD_SAMSUNG_VSYNC_EDGE",
        0xBFF600D0: "IMG_ERR_SAMSUNG_LUMA_GAIN_CTRL",
        0xBFF600D1: "IMG_ERR_BAD_SET_COMB_COEF",
        0xBFF600D2: "IMG_ERR_SAMSUNG_CHROMA_TRACK",
        0xBFF600D3: "IMG_ERR_SAMSUNG_DROP_LINES",
        0xBFF600D4: "IMG_ERR_VHA_OPTIMIZATION_NOT_ALLOWED",
        0xBFF600D5: "IMG_ERR_BAD_PG_TRANSITION",
        0xBFF600D6: "IMG_ERR_TOO_MANY_PG_TRANSITIONS",
        0xBFF600D7: "IMG_ERR_BAD_CL_DATA_CONFIG",
        0xBFF600D8: "IMG_ERR_BAD_OCCURRENCE",
        0xBFF600D9: "IMG_ERR_BAD_PG_MODE",
        0xBFF600DA: "IMG_ERR_BAD_PG_SOURCE",
        0xBFF600DB: "IMG_ERR_BAD_PG_GATE",
        0xBFF600DC: "IMG_ERR_BAD_PG_GATE_POLARITY",
        0xBFF600DD: "IMG_ERR_BAD_PG_WAVEFORM_INITIAL_STATE",
        0xBFF600DE: "IMG_ERR_INVALID_CAMERA_ATTRIBUTE",
        0xBFF600DF: "IMG_ERR_BOARD_CLOSED",
        0xBFF600E0: "IMG_ERR_FILE_NOT_FOUND",
        0xBFF600E1: "IMG_ERR_BAD_1409_DSP_FILE",
        0xBFF600E2: "IMG_ERR_BAD_SCARABXCV200_32_FILE",
        0xBFF600E3: "IMG_ERR_BAD_SCARABXCV200_16_FILE",
        0xBFF600E4: "IMG_ERR_BAD_CAMERA_LINK_FILE",
        0xBFF600E5: "IMG_ERR_BAD_1411_CSC_FILE",
        0xBFF600E6: "IMG_ERR_BAD_ERROR_CODE",
        0xBFF600E7: "IMG_ERR_DRIVER_TOO_OLD",
        0xBFF600E8: "IMG_ERR_INSTALLATION_CORRUPT",
        0xBFF600E9: "IMG_ERR_NO_ONBOARD_MEMORY",
        0xBFF600EA: "IMG_ERR_BAD_BAYER_PATTERN",
        0xBFF600EB: "IMG_ERR_CANNOT_INITIALIZE_BOARD",
        0xBFF600EC: "IMG_ERR_CALIBRATION_DATA_CORRUPT",
        0xBFF600ED: "IMG_ERR_DRIVER_FAULT",
        0xBFF600EE: "IMG_ERR_ADDRESS_OUT_OF_RANGE",
        0xBFF600EF: "IMG_ERR_ONBOARD_ACQUISITION",
        0xBFF600F0: "IMG_ERR_NOT_AN_ONBOARD_ACQUISITION",
        0xBFF600F1: "IMG_ERR_BOARD_ALREADY_INITIALIZED",
        0xBFF600F2: "IMG_ERR_NO_SERIAL_PORT",
        0xBFF600F3: "IMG_ERR_BAD_VENABLE_GATING_MODE",
        0xBFF600F4: "IMG_ERR_BAD_1407_LUT_FILE",
        0xBFF600F5: "IMG_ERR_BAD_SYNC_DETECT_LEVEL",
        0xBFF600F6: "IMG_ERR_BAD_1405_GAIN_FILE",
        0xBFF600F7: "IMG_ERR_CLAMP_DAC_NOT_PRESENT",
        0xBFF600F8: "IMG_ERR_GAIN_DAC_NOT_PRESENT",
        0xBFF600F9: "IMG_ERR_REF_DAC_NOT_PRESENT",
        0xBFF600FA: "IMG_ERR_BAD_SCARABXC2S200_FILE",
        0xBFF600FB: "IMG_ERR_BAD_LUT_GAIN",
        0xBFF600FC: "IMG_ERR_BAD_MAX_BUF_LIST_ITER",
        0xBFF600FD: "IMG_ERR_BAD_PG_LINE_NUM",
        0xBFF600FE: "IMG_ERR_BAD_BITS_PER_PIXEL",
        0xBFF600FF: "IMG_ERR_TRIGGER_ALARM",
        0xBFF60100: "IMG_ERR_BAD_SCARABXC2S200_03052009_FILE",
        0xBFF60101: "IMG_ERR_LUT_CONFIG",
        0xBFF60102: "IMG_ERR_CONTROL_FPGA_REQUIRES_NEWER_DRIVER",
        0xBFF60103: "IMG_ERR_CONTROL_FPGA_PROGRAMMING_FAILED",
        0xBFF60104: "IMG_ERR_BAD_TRIGGER_SIGNAL_LEVEL",
        0xBFF60105: "IMG_ERR_CAMERA_FILE_REQUIRES_NEWER_DRIVER",
        0xBFF60106: "IMG_ERR_DUPLICATED_BUFFER",
        0xBFF60107: "IMG_ERR_NO_ERROR",
        0xBFF60108: "IMG_ERR_INTERFACE_NOT_SUPPORTED",
        0xBFF60109: "IMG_ERR_BAD_PCLK_POLARITY",
        0xBFF6010A: "IMG_ERR_BAD_ENABLE_POLARITY",
        0xBFF6010B: "IMG_ERR_BAD_PCLK_SIGNAL_LEVEL",
        0xBFF6010C: "IMG_ERR_BAD_ENABLE_SIGNAL_LEVEL",
        0xBFF6010D: "IMG_ERR_BAD_DATA_SIGNAL_LEVEL",
        0xBFF6010E: "IMG_ERR_BAD_CTRL_SIGNAL_LEVEL",
        0xBFF6010F: "IMG_ERR_BAD_WINDOW_HANDLE",
        0xBFF60110: "IMG_ERR_CANNOT_WRITE_FILE",
        0xBFF60111: "IMG_ERR_CANNOT_READ_FILE",
        0xBFF60112: "IMG_ERR_BAD_SIGNAL_TYPE",
        0xBFF60113: "IMG_ERR_BAD_SAMPLES_PER_LINE",
        0xBFF60114: "IMG_ERR_BAD_SAMPLES_PER_LINE_REF",
        0xBFF60115: "IMG_ERR_USE_EXTERNAL_HSYNC",
        0xBFF60116: "IMG_ERR_BUFFER_NOT_ALIGNED",
        0xBFF60117: "IMG_ERR_ROWPIXELS_TOO_SMALL",
        0xBFF60118: "IMG_ERR_ROWPIXELS_NOT_ALIGNED",
        0xBFF60119: "IMG_ERR_ROI_WIDTH_NOT_ALIGNED",
        0xBFF6011A: "IMG_ERR_LINESCAN_NOT_ALLOWED",
        0xBFF6011B: "IMG_ERR_INTERFACE_FILE_REQUIRES_NEWER_DRIVER",
        0xBFF6011C: "IMG_ERR_BAD_SKIP_COUNT",
        0xBFF6011D: "IMG_ERR_BAD_NUM_X_ZONES",
        0xBFF6011E: "IMG_ERR_BAD_NUM_Y_ZONES",
        0xBFF6011F: "IMG_ERR_BAD_NUM_TAPS_PER_X_ZONE",
        0xBFF60120: "IMG_ERR_BAD_NUM_TAPS_PER_Y_ZONE",
        0xBFF60121: "IMG_ERR_BAD_TEST_IMAGE_TYPE",
        0xBFF60122: "IMG_ERR_CANNOT_ACQUIRE_FROM_CAMERA",
        0xBFF60123: "IMG_ERR_BAD_CTRL_LINE_SOURCE",
        0xBFF60124: "IMG_ERR_BAD_PIXEL_EXTRACTOR",
        0xBFF60125: "IMG_ERR_BAD_NUM_TIME_SLOTS",
        0xBFF60126: "IMG_ERR_BAD_PLL_VCO_DIVIDER",
        0xBFF60127: "IMG_ERR_CRITICAL_TEMP",
        0xBFF60128: "IMG_ERR_BAD_DPA_OFFSET",
        0xBFF60129: "IMG_ERR_BAD_NUM_POST_TRIGGER_BUFFERS",
        0xBFF6012A: "IMG_ERR_BAD_DVAL_MODE",
        0xBFF6012B: "IMG_ERR_BAD_TRIG_GEN_REARM_SOURCE",
        0xBFF6012C: "IMG_ERR_BAD_ASM_GATE_SOURCE",
        0xBFF6012D: "IMG_ERR_TOO_MANY_BUFFERS",
        0xBFF6012E: "IMG_ERR_BAD_TAP_4_VALID_RECT",
        0xBFF6012F: "IMG_ERR_BAD_TAP_5_VALID_RECT",
        0xBFF60130: "IMG_ERR_BAD_TAP_6_VALID_RECT",
        0xBFF60131: "IMG_ERR_BAD_TAP_7_VALID_RECT",
        0xBFF60132: "IMG_ERR_FRONT_END_BANDWIDTH_EXCEEDED",
        0xBFF60133: "IMG_ERR_BAD_PORT_NUMBER",
        0xBFF60134: "IMG_ERR_PORT_CONFIG_CONFLICT",
        0xBFF60135: "IMG_ERR_BITSTREAM_INCOMPATIBLE",
        0xBFF60136: "IMG_ERR_SERIAL_PORT_IN_USE",
        0xBFF60137: "IMG_ERR_BAD_ENCODER_DIVIDE_FACTOR",
        0xBFF60138: "IMG_ERR_ENCODER_NOT_SUPPORTED",
        0xBFF60139: "IMG_ERR_BAD_ENCODER_POLARITY",
        0xBFF6013A: "IMG_ERR_BAD_ENCODER_FILTER",
        0xBFF6013B: "IMG_ERR_ENCODER_POSITION_NOT_SUPPORTED",
        0xBFF6013C: "IMG_ERR_IMAGE_IN_USE",
        0xBFF6013D: "IMG_ERR_BAD_SCARABXL4000_FILE",
        0xBFF6013E: "IMG_ERR_BAD_CAMERA_ATTRIBUTE_VALUE",
        0xBFF6013F: "IMG_ERR_BAD_PULSE_WIDTH",
        0xBFF60140: "IMG_ERR_FPGA_FILE_NOT_FOUND",
        0xBFF60141: "IMG_ERR_FPGA_FILE_CORRUPT",
        0xBFF60142: "IMG_ERR_BAD_PULSE_DELAY",
        0xBFF60143: "IMG_ERR_BAD_PG_IDLE_SIGNAL_LEVEL",
        0xBFF60144: "IMG_ERR_BAD_PG_WAVEFORM_IDLE_STATE",
        0xBFF60145: "IMG_ERR_64_BIT_MEMORY_NOT_SUPPORTED",
        0xBFF60146: "IMG_ERR_64_BIT_MEMORY_UPDATE_AVAILABLE",
        0xBFF60147: "IMG_ERR_32_BIT_MEMORY_LIMITATION",
        0xBFF60148: "IMG_ERR_KERNEL_NOT_LOADED",
        0xBFF60149: "IMG_ERR_BAD_SENSOR_SHUTTER_PERIOD",
        0xBFF6014A: "IMG_ERR_BAD_SENSOR_CCD_TYPE",
        0xBFF6014B: "IMG_ERR_BAD_SENSOR_PARTIAL_SCAN",
        0xBFF6014C: "IMG_ERR_BAD_SENSOR_BINNING",
        0xBFF6014D: "IMG_ERR_BAD_SENSOR_GAIN",
        0xBFF6014E: "IMG_ERR_BAD_SENSOR_BRIGHTNESS",
        0xBFF6014F: "IMG_ERR_BAD_LED_STATE",
        0xBFF60150: "IMG_ERR_64_BIT_NOT_SUPPORTED",
        0xBFF60151: "IMG_ERR_BAD_TRIGGER_DELAY",
        0xBFF60152: "IMG_ERR_LIGHTING_CURRENT_EXCEEDS_LIMITS",
        0xBFF60153: "IMG_ERR_LIGHTING_INVALID_MODE",
        0xBFF60154: "IMG_ERR_LIGHTING_EXTERNAL_INVALID_MODE",
        0xBFF60155: "IMG_ERR_BAD_SENSOR_EXPOSURE",
        0xBFF60156: "IMG_ERR_BAD_FRAME_RATE",
        0xBFF60157: "IMG_ERR_BAD_SENSOR_PARTIAL_SCAN_BINNING_COMBINATION",
        0xBFF60158: "IMG_ERR_SOFTWARE_TRIGGER_NOT_CONFIGURED",
        0xBFF60159: "IMG_ERR_FREE_RUN_MODE_NOT_ALLOWED",
        0xBFF6015A: "IMG_ERR_BAD_LIGHTING_RAMPUP",
        0xBFF6015B: "IMG_ERR_AFE_CONFIG_TIMEOUT",
        0xBFF6015C: "IMG_ERR_LIGHTING_ARM_TIMEOUT",
        0xBFF6015D: "IMG_ERR_LIGHTING_SHORT_CIRCUIT",
        0xBFF6015E: "IMG_ERR_BAD_BOARD_HEALTH",
        0xBFF6015F: "IMG_ERR_LIGHTING_BAD_CONTINUOUS_CURRENT_LIMIT",
        0xBFF60160: "IMG_ERR_LIGHTING_BAD_STROBE_DUTY_CYCLE_LIMIT",
        0xBFF60161: "IMG_ERR_LIGHTING_BAD_STROBE_DURATION_LIMIT",
        0xBFF60162: "IMG_ERR_BAD_LIGHTING_CURRENT_EXPOSURE_COMBINATION",
        0xBFF60163: "IMG_ERR_LIGHTING_HEAD_CONFIG_NOT_FOUND",
        0xBFF60164: "IMG_ERR_LIGHTING_HEAD_DATA_CORRUPT",
        0xBFF60165: "IMG_ERR_LIGHTING_ABORT_TIMEOUT",
        0xBFF60166: "IMG_ERR_LIGHTING_BAD_STROBE_CURRENT_LIMIT",
        0xBFF60167: "IMG_ERR_DMA_ENGINE_UNRESPONSIVE",
        0xBFF60168: "IMG_ERR_IMAGE_NOT_32BYTE_ALIGNED",
        0xBFF60169: "IMG_ERR_IMAGE_BORDER_NONZERO",
        0xBFF60170: "IMG_ERR_POCL_FAULT",
        0xBFF60171: "IMG_ERR_POCL_VIDEO_LOCK",
        0xBFF60172: "IMG_ERR_POCL_BAD_FUSE",
        0xBFF60173: "IMG_ERR_POCL_NO_AUX_POWER",
        0xBFF60174: "IMG_ERR_PULSE_UPDATE_NOT_SUPPORTED",
        0xBFF60174: "IMG_ERR_LAST_ERROR",
}
IMAQ_errors_inv=general.invert_dict(IMAQ_errors)


_IMG_BASE=0x3FF60000
IMAQ_attrs = {
    (_IMG_BASE+0x0001): "IMG_ATTR_INTERFACE_TYPE",
    (_IMG_BASE+0x0002): "IMG_ATTR_PIXDEPTH",
    (_IMG_BASE+0x0003): "IMG_ATTR_COLOR",
    (_IMG_BASE+0x0004): "IMG_ATTR_HASRAM",
    (_IMG_BASE+0x0005): "IMG_ATTR_RAMSIZE",
    (_IMG_BASE+0x0006): "IMG_ATTR_CHANNEL",
    (_IMG_BASE+0x0007): "IMG_ATTR_FRAME_FIELD",
    (_IMG_BASE+0x0009): "IMG_ATTR_HORZ_RESOLUTION",
    (_IMG_BASE+0x000A): "IMG_ATTR_VERT_RESOLUTION",
    (_IMG_BASE+0x000B): "IMG_ATTR_LUT",
    (_IMG_BASE+0x000C): "IMG_ATTR_LINESCAN",
    (_IMG_BASE+0x000D): "IMG_ATTR_GAIN",
    (_IMG_BASE+0x000E): "IMG_ATTR_CHROMA_FILTER",
    (_IMG_BASE+0x000F): "IMG_ATTR_WHITE_REF",
    (_IMG_BASE+0x0010): "IMG_ATTR_BLACK_REF",
    (_IMG_BASE+0x0011): "IMG_ATTR_DATALINES",
    (_IMG_BASE+0x0012): "IMG_ATTR_NUM_EXT_LINES",
    (_IMG_BASE+0x0013): "IMG_ATTR_NUM_RTSI_LINES",
    (_IMG_BASE+0x0014): "IMG_ATTR_NUM_RTSI_IN_USE",
    (_IMG_BASE+0x0065): "IMG_ATTR_MEM_LOCKED",
    (_IMG_BASE+0x0066): "IMG_ATTR_BITSPERPIXEL",
    (_IMG_BASE+0x0067): "IMG_ATTR_BYTESPERPIXEL",
    (_IMG_BASE+0x0068): "IMG_ATTR_ACQWINDOW_LEFT",
    (_IMG_BASE+0x0069): "IMG_ATTR_ACQWINDOW_TOP",
    (_IMG_BASE+0x006A): "IMG_ATTR_ACQWINDOW_WIDTH",
    (_IMG_BASE+0x006B): "IMG_ATTR_ACQWINDOW_HEIGHT",
    (_IMG_BASE+0x0070): "IMG_ATTR_LINE_COUNT",
    (_IMG_BASE+0x0071): "IMG_ATTR_FREE_BUFFERS",
    (_IMG_BASE+0x0072): "IMG_ATTR_HSCALE",
    (_IMG_BASE+0x0073): "IMG_ATTR_VSCALE",
    (_IMG_BASE+0x0074): "IMG_ATTR_ACQ_IN_PROGRESS",
    (_IMG_BASE+0x0075): "IMG_ATTR_START_FIELD",
    (_IMG_BASE+0x0076): "IMG_ATTR_FRAME_COUNT",
    (_IMG_BASE+0x0077): "IMG_ATTR_LAST_VALID_BUFFER",
    (_IMG_BASE+0x0078): "IMG_ATTR_ROWBYTES",
    (_IMG_BASE+0x007B): "IMG_ATTR_CALLBACK",
    (_IMG_BASE+0x007C): "IMG_ATTR_CURRENT_BUFLIST",
    (_IMG_BASE+0x007D): "IMG_ATTR_FRAMEWAIT_MSEC",
    (_IMG_BASE+0x007E): "IMG_ATTR_TRIGGER_MODE",
    (_IMG_BASE+0x0082): "IMG_ATTR_INVERT",
    (_IMG_BASE+0x0083): "IMG_ATTR_XOFF_BUFFER",
    (_IMG_BASE+0x0084): "IMG_ATTR_YOFF_BUFFER",
    (_IMG_BASE+0x0085): "IMG_ATTR_NUM_BUFFERS",
    (_IMG_BASE+0x0088): "IMG_ATTR_LOST_FRAMES",
    (_IMG_BASE+0x008F): "IMG_ATTR_COLOR_WHITE_REF",
    (_IMG_BASE+0x0090): "IMG_ATTR_COLOR_BLACK_REF",
    (_IMG_BASE+0x0091): "IMG_ATTR_COLOR_CLAMP_START",
    (_IMG_BASE+0x0092): "IMG_ATTR_COLOR_CLAMP_STOP",
    (_IMG_BASE+0x0093): "IMG_ATTR_COLOR_ZERO_START",
    (_IMG_BASE+0x0094): "IMG_ATTR_COLOR_ZERO_STOP",
    (_IMG_BASE+0x0095): "IMG_ATTR_COLOR_AVG_COUNT",
    (_IMG_BASE+0x0096): "IMG_ATTR_COLOR_SW_CHROMA_FILTER",
    (_IMG_BASE+0x0097): "IMG_ATTR_COLOR_NTSC_SETUP_ENABLE",
    (_IMG_BASE+0x0098): "IMG_ATTR_COLOR_NTSC_SETUP_VALUE",
    (_IMG_BASE+0x0099): "IMG_ATTR_COLOR_BRIGHTNESS",
    (_IMG_BASE+0x009A): "IMG_ATTR_COLOR_CONTRAST",
    (_IMG_BASE+0x009B): "IMG_ATTR_COLOR_SATURATION",
    (_IMG_BASE+0x009C): "IMG_ATTR_COLOR_TINT",
    (_IMG_BASE+0x009D): "IMG_ATTR_COLOR_SW_POST_GAIN",
    (_IMG_BASE+0x009E): "IMG_ATTR_COLOR_BURST_START",
    (_IMG_BASE+0x009F): "IMG_ATTR_COLOR_BURST_STOP",
    (_IMG_BASE+0x00A0): "IMG_ATTR_COLOR_BLANK_START",
    (_IMG_BASE+0x00A1): "IMG_ATTR_COLOR_BLANK_STOP",
    (_IMG_BASE+0x00A2): "IMG_ATTR_COLOR_IMAGE_X_SHIFT",
    (_IMG_BASE+0x00A3): "IMG_ATTR_COLOR_GAIN",
    (_IMG_BASE+0x00A5): "IMG_ATTR_COLOR_CLAMP_START_REF",
    (_IMG_BASE+0x00A6): "IMG_ATTR_COLOR_CLAMP_STOP_REF",
    (_IMG_BASE+0x00A7): "IMG_ATTR_COLOR_ZERO_START_REF",
    (_IMG_BASE+0x00A8): "IMG_ATTR_COLOR_ZERO_STOP_REF",
    (_IMG_BASE+0x00A9): "IMG_ATTR_COLOR_BURST_START_REF",
    (_IMG_BASE+0x00AA): "IMG_ATTR_COLOR_BURST_STOP_REF",
    (_IMG_BASE+0x00AB): "IMG_ATTR_COLOR_BLANK_START_REF",
    (_IMG_BASE+0x00AC): "IMG_ATTR_COLOR_BLANK_STOP_REF",
    (_IMG_BASE+0x00AD): "IMG_ATTR_COLOR_MODE",
    (_IMG_BASE+0x00AE): "IMG_ATTR_COLOR_IMAGE_REP",
    (_IMG_BASE+0x00AF): "IMG_ATTR_GENLOCK_SWITCH_CHAN",
    (_IMG_BASE+0x00B0): "IMG_ATTR_CLAMP_START",
    (_IMG_BASE+0x00B1): "IMG_ATTR_CLAMP_STOP",
    (_IMG_BASE+0x00B2): "IMG_ATTR_ZERO_START",
    (_IMG_BASE+0x00B3): "IMG_ATTR_ZERO_STOP",
    (_IMG_BASE+0x00B5): "IMG_ATTR_COLOR_HUE_OFFS_ANGLE",
    (_IMG_BASE+0x00B6): "IMG_ATTR_COLOR_IMAGE_X_SHIFT_REF",
    (_IMG_BASE+0x00BA): "IMG_ATTR_LAST_VALID_FRAME",
    (_IMG_BASE+0x00BB): "IMG_ATTR_CLOCK_FREQ",
    (_IMG_BASE+0x00BC): "IMG_ATTR_BLACK_REF_VOLT",
    (_IMG_BASE+0x00BD): "IMG_ATTR_WHITE_REF_VOLT",
    (_IMG_BASE+0x00BE): "IMG_ATTR_COLOR_LOW_REF_VOLT",
    (_IMG_BASE+0x00BF): "IMG_ATTR_COLOR_HIGH_REF_VOLT",
    (_IMG_BASE+0x00C0): "IMG_ATTR_GETSERIAL",
    (_IMG_BASE+0x00C1): "IMG_ATTR_ROWPIXELS",
    (_IMG_BASE+0x00C2): "IMG_ATTR_ACQUIRE_FIELD",
    (_IMG_BASE+0x00C3): "IMG_ATTR_PCLK_DETECT",
    (_IMG_BASE+0x00C4): "IMG_ATTR_VHA_MODE",
    (_IMG_BASE+0x00C5): "IMG_ATTR_BIN_THRESHOLD_LOW",
    (_IMG_BASE+0x00C6): "IMG_ATTR_BIN_THRESHOLD_HIGH",
    (_IMG_BASE+0x00C7): "IMG_ATTR_COLOR_LUMA_BANDWIDTH",
    (_IMG_BASE+0x00C8): "IMG_ATTR_COLOR_CHROMA_TRAP",
    (_IMG_BASE+0x00C9): "IMG_ATTR_COLOR_LUMA_COMB",
    (_IMG_BASE+0x00CA): "IMG_ATTR_COLOR_PEAKING_ENABLE",
    (_IMG_BASE+0x00CB): "IMG_ATTR_COLOR_PEAKING_LEVEL",
    (_IMG_BASE+0x00CC): "IMG_ATTR_COLOR_CHROMA_PROCESS",
    (_IMG_BASE+0x00CD): "IMG_ATTR_COLOR_CHROMA_BANDWIDTH",
    (_IMG_BASE+0x00CE): "IMG_ATTR_COLOR_CHROMA_COMB",
    (_IMG_BASE+0x00CF): "IMG_ATTR_COLOR_CHROMA_PHASE",
    (_IMG_BASE+0x00D0): "IMG_ATTR_COLOR_RGB_CORING_LEVEL",
    (_IMG_BASE+0x00D1): "IMG_ATTR_COLOR_HSL_CORING_LEVEL",
    (_IMG_BASE+0x00D2): "IMG_ATTR_COLOR_HUE_REPLACE_VALUE",
    (_IMG_BASE+0x00D3): "IMG_ATTR_COLOR_GAIN_RED",
    (_IMG_BASE+0x00D4): "IMG_ATTR_COLOR_GAIN_GREEN",
    (_IMG_BASE+0x00D5): "IMG_ATTR_COLOR_GAIN_BLUE",
    (_IMG_BASE+0x00D6): "IMG_ATTR_CALIBRATION_DATE_LV",
    (_IMG_BASE+0x00D7): "IMG_ATTR_CALIBRATION_DATE",
    (_IMG_BASE+0x00D8): "IMG_ATTR_IMAGE_TYPE",
    (_IMG_BASE+0x00D9): "IMG_ATTR_DYNAMIC_RANGE",
    (_IMG_BASE+0x011B): "IMG_ATTR_ACQUIRE_TO_SYSTEM_MEMORY",
    (_IMG_BASE+0x011C): "IMG_ATTR_ONBOARD_HOLDING_BUFFER_PTR",
    (_IMG_BASE+0x011D): "IMG_ATTR_SYNCHRONICITY",
    (_IMG_BASE+0x011E): "IMG_ATTR_LAST_ACQUIRED_BUFFER_NUM",
    (_IMG_BASE+0x011F): "IMG_ATTR_LAST_ACQUIRED_BUFFER_INDEX",
    (_IMG_BASE+0x0120): "IMG_ATTR_LAST_TRANSFERRED_BUFFER_NUM",
    (_IMG_BASE+0x0121): "IMG_ATTR_LAST_TRANSFERRED_BUFFER_INDEX",
    (_IMG_BASE+0x012C): "IMG_ATTR_SERIAL_NUM_BYTES_RECEIVED",
    (_IMG_BASE+0x013C): "IMG_ATTR_EXPOSURE_TIME_INTERNAL",
    (_IMG_BASE+0x0150): "IMG_ATTR_SERIAL_TERM_STRING",
    (_IMG_BASE+0x01A3): "IMG_ATTR_DETECT_VIDEO",
    (_IMG_BASE+0x01A4): "IMG_ATTR_ROI_LEFT",
    (_IMG_BASE+0x01A5): "IMG_ATTR_ROI_TOP",
    (_IMG_BASE+0x01A6): "IMG_ATTR_ROI_WIDTH",
    (_IMG_BASE+0x01A7): "IMG_ATTR_ROI_HEIGHT",
    (_IMG_BASE+0x01A8): "IMG_ATTR_NUM_ISO_IN_LINES",
    (_IMG_BASE+0x01A9): "IMG_ATTR_NUM_ISO_OUT_LINES",
    (_IMG_BASE+0x01AA): "IMG_ATTR_NUM_POST_TRIGGER_BUFFERS",
    (_IMG_BASE+0x01AB): "IMG_ATTR_EXT_TRIG_LINE_FILTER",
    (_IMG_BASE+0x01AC): "IMG_ATTR_RTSI_LINE_FILTER",
    (_IMG_BASE+0x01AD): "IMG_ATTR_NUM_PORTS",
    (_IMG_BASE+0x01AE): "IMG_ATTR_CURRENT_PORT_NUM",
    (_IMG_BASE+0x01AF): "IMG_ATTR_ENCODER_PHASE_A_POLARITY",
    (_IMG_BASE+0x01B0): "IMG_ATTR_ENCODER_PHASE_B_POLARITY",
    (_IMG_BASE+0x01B1): "IMG_ATTR_ENCODER_FILTER",
    (_IMG_BASE+0x01B2): "IMG_ATTR_ENCODER_DIVIDE_FACTOR",
    (_IMG_BASE+0x01B3): "IMG_ATTR_ENCODER_POSITION",
    (_IMG_BASE+0x01B4): "IMG_ATTR_TEMPERATURE",
    (_IMG_BASE+0x01B5): "IMG_ATTR_LED_PASS",
    (_IMG_BASE+0x01B6): "IMG_ATTR_LED_FAIL",
    (_IMG_BASE+0x01B7): "IMG_ATTR_SENSOR_PARTIAL_SCAN",
    (_IMG_BASE+0x01B8): "IMG_ATTR_SENSOR_BINNING",
    (_IMG_BASE+0x01B9): "IMG_ATTR_SENSOR_GAIN",
    (_IMG_BASE+0x01BB): "IMG_ATTR_LIGHTING_MODE",
    (_IMG_BASE+0x01BC): "IMG_ATTR_LIGHTING_CURRENT",
    (_IMG_BASE+0x01BD): "IMG_ATTR_LIGHTING_MAX_CURRENT",
    (_IMG_BASE+0x01BE): "IMG_ATTR_LIGHTING_EXT_STROBE_5V_TTL",
    (_IMG_BASE+0x01BF): "IMG_ATTR_LIGHTING_EXT_STROBE_24V",
    (_IMG_BASE+0x01C0): "IMG_ATTR_SENSOR_EXPOSURE",
    (_IMG_BASE+0x01C1): "IMG_ATTR_FRAME_RATE",
    (_IMG_BASE+0x01C2): "IMG_ATTR_MAX_FRAME_RATE",
    (_IMG_BASE+0x01C3): "IMG_ATTR_SEND_SOFTWARE_TRIGGER",
    (_IMG_BASE+0x01C4): "IMG_ATTR_FIXED_FRAME_RATE_MODE",
    (_IMG_BASE+0x01C5): "IMG_ATTR_UNSIGNED_16BIT_IMAGE",
    (_IMG_BASE+0x01C6): "IMG_ATTR_POCL_STATUS",
    (_IMG_BASE+0x01C7): "IMG_ATTR_ROWPIXELS_ALIGNMENT",
    (_IMG_BASE+0x01C8): "IMG_ATTR_ROWPIXELS_SUGGESTED_ALIGNMENT",
    (_IMG_BASE+0x01C9): "IMG_ATTR_SUPPORTS_PULSE_UPDATE",
    (_IMG_BASE+0x01CB): "IMG_ATTR_BAYER_PATTERN",
    (_IMG_BASE+0x01CC): "IMG_ATTR_BAYER_RED_GAIN",
    (_IMG_BASE+0x01CD): "IMG_ATTR_BAYER_GREEN_GAIN",
    (_IMG_BASE+0x01CE): "IMG_ATTR_BAYER_BLUE_GAIN",
    (_IMG_BASE+0x01CF): "IMG_ATTR_BAYER_ALGORITHM",
}
IMAQ_attrs_inv=general.invert_dict(IMAQ_attrs)


IMAQ_signal_type = {
    0xFFFFFFFF: "IMG_SIGNAL_NONE",
    0: "IMG_SIGNAL_EXTERNAL",
    1: "IMG_SIGNAL_RTSI",
    2: "IMG_SIGNAL_ISO_IN",
    3: "IMG_SIGNAL_ISO_OUT",
    4: "IMG_SIGNAL_STATUS",
    5: "IMG_SIGNAL_SCALED_ENCODER",
    6: "IMG_SIGNAL_SOFTWARE_TRIGGER"
}
IMAQ_signal_type_inv=general.invert_dict(IMAQ_signal_type)


IMAQ_int_signal = {
    8: "IMG_AQ_DONE",
    9: "IMG_FRAME_START",
    10: "IMG_FRAME_DONE",
    11: "IMG_BUF_COMPLETE",
    15: "IMG_AQ_IN_PROGRESS",
    16: "IMG_IMMEDIATE",
    17: "IMG_FIXED_FREQUENCY",
    18: "IMG_LINE_VALID",
    19: "IMG_FRAME_VALID"
}
IMAQ_int_signal_inv=general.invert_dict(IMAQ_int_signal)

IMAQ_signal_state = {
    0: "IMG_SIGNAL_STATE_RISING",
    1: "IMG_SIGNAL_STATE_FALLING",
    2: "IMG_SIGNAL_STATE_HIGH",
    3: "IMG_SIGNAL_STATE_LOW",
    4: "IMG_SIGNAL_STATE_HI_Z"
}
IMAQ_signal_state_inv=general.invert_dict(IMAQ_signal_state)

IMAQ_trig_pol = {
    0: "IMG_TRIG_POLAR_ACTIVEH",
    1: "IMG_TRIG_POLAR_ACTIVEL"
}
IMAQ_trig_pol_inv=general.invert_dict(IMAQ_trig_pol)

IMAQ_trig_action = {
    0: "IMG_TRIG_ACTION_NONE",
    1: "IMG_TRIG_ACTION_CAPTURE",
    2: "IMG_TRIG_ACTION_BUFLIST",
    3: "IMG_TRIG_ACTION_BUFFER",
    4: "IMG_TRIG_ACTION_STOP"
}
IMAQ_trig_action_inv=general.invert_dict(IMAQ_trig_action)

IMAQ_trig_drive_src = {
    0: "IMG_TRIG_DRIVE_DISABLED",
    1: "IMG_TRIG_DRIVE_AQ_IN_PROGRESS",
    2: "IMG_TRIG_DRIVE_AQ_DONE",
    3: "IMG_TRIG_DRIVE_PIXEL_CLK",
    4: "IMG_TRIG_DRIVE_UNASSERTED",
    5: "IMG_TRIG_DRIVE_ASSERTED",
    6: "IMG_TRIG_DRIVE_HSYNC",
    7: "IMG_TRIG_DRIVE_VSYNC",
    8: "IMG_TRIG_DRIVE_FRAME_START",
    9: "IMG_TRIG_DRIVE_FRAME_DONE",
    10: "IMG_TRIG_DRIVE_SCALED_ENCODER"
}
IMAQ_trig_drive_src_inv=general.invert_dict(IMAQ_trig_drive_src)

IMAQInfiniteTimout=0xFFFFFFFF