﻿!mod$ v1 sum:09fcb054ed037801
!need$ 2787e808cf50d06d n control_flags
!need$ 0ddc620bbf8949af n gvect
!need$ b248aefcc2372d39 n noncollin_module
!need$ f1b4423f2906c0b3 n kinds
module becmod
use kinds,only:dp
use kinds,only:offload_kind_acc
use kinds,only:offload_kind_cpu
use kinds,only:offload_kind_omp
use control_flags,only:gamma_only
use control_flags,only:smallmem
use control_flags,only:offload_acc
use control_flags,only:offload_cpu
use control_flags,only:offload_omp
use gvect,only:gstart
use noncollin_module,only:noncolin
use noncollin_module,only:npol
private::dp
private::offload_kind_acc
private::offload_kind_cpu
private::offload_kind_omp
private::gamma_only
private::smallmem
private::offload_acc
private::offload_cpu
private::offload_omp
private::gstart
private::noncolin
private::npol
type::bec_type
real(8),allocatable::r(:,:)
complex(8),allocatable::k(:,:)
complex(8),allocatable::nc(:,:,:)
integer(4)::nbnd
end type
type(bec_type)::becp
private::calbec_bec_type_acc
private::calbec_bec_type_cpu
private::calbec_bec_type
private::calbec_gamma_acc
private::calbec_gamma_cpu
private::calbec_gamma
private::calbec_k_acc
private::calbec_k_cpu
private::calbec_k
private::calbec_nc_acc
private::calbec_nc_cpu
private::calbec_nc
private::becscal_nck
private::becscal_gamma
private::becupdate_0d_cpu
private::becupdate_1d_cpu
private::becupdate_2d_cpu
private::becupdate_0d_acc
private::becupdate_1d_acc
private::becupdate_2d_acc
interface calbec
procedure::calbec_k_acc
procedure::calbec_gamma_acc
procedure::calbec_nc_acc
procedure::calbec_bec_type_acc
procedure::calbec_k_cpu
procedure::calbec_gamma_cpu
procedure::calbec_nc_cpu
procedure::calbec_bec_type_cpu
procedure::calbec_k
procedure::calbec_gamma
procedure::calbec_nc
procedure::calbec_bec_type
end interface
interface becscal
procedure::becscal_nck
procedure::becscal_gamma
end interface
interface becupdate
procedure::becupdate_0d_cpu
procedure::becupdate_1d_cpu
procedure::becupdate_2d_cpu
procedure::becupdate_0d_acc
procedure::becupdate_1d_acc
procedure::becupdate_2d_acc
end interface
contains
subroutine calbec_bec_type_acc(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
type(bec_type),intent(inout)::betapsi
integer(4),optional::nbnd
end
subroutine calbec_bec_type_cpu(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
type(bec_type),intent(inout)::betapsi
integer(4),optional::nbnd
end
subroutine calbec_bec_type(npw,beta,psi,betapsi,nbnd)
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
type(bec_type),intent(inout)::betapsi
integer(4),optional::nbnd
end
subroutine calbec_gamma_acc(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
real(8),intent(out)::betapsi(:,:)
integer(4),intent(in),optional::nbnd
end
subroutine calbec_gamma_cpu(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
real(8),intent(out)::betapsi(:,:)
integer(4),intent(in),optional::nbnd
end
subroutine calbec_gamma(npw,beta,psi,betapsi,nbnd)
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
real(8),intent(out)::betapsi(:,:)
integer(4),intent(in),optional::nbnd
end
subroutine calbec_k_acc(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:)
integer(4),optional::nbnd
end
subroutine calbec_k_cpu(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:)
integer(4),optional::nbnd
end
subroutine calbec_k(npw,beta,psi,betapsi,nbnd)
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:)
integer(4),optional::nbnd
end
subroutine calbec_nc_acc(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:,:)
integer(4),optional::nbnd
end
subroutine calbec_nc_cpu(offload,npw,beta,psi,betapsi,nbnd)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:,:)
integer(4),optional::nbnd
end
subroutine calbec_nc(npw,beta,psi,betapsi,nbnd)
integer(4),intent(in)::npw
complex(8),intent(in)::beta(:,:)
complex(8),intent(in)::psi(:,:)
complex(8),intent(out)::betapsi(:,:,:)
integer(4),optional::nbnd
end
function is_allocated_bec_type(bec) result(isalloc)
type(bec_type)::bec
logical(4)::isalloc
end
subroutine allocate_bec_type_acc(nkb,nbnd,bec,comm)
integer(4),intent(in)::nkb
integer(4),intent(in)::nbnd
type(bec_type)::bec
integer(4),intent(in),optional::comm
end
subroutine allocate_bec_type(nkb,nbnd,bec,comm)
integer(4),intent(in)::nkb
integer(4),intent(in)::nbnd
type(bec_type)::bec
integer(4),intent(in),optional::comm
end
subroutine deallocate_bec_type_acc(bec)
type(bec_type)::bec
end
subroutine deallocate_bec_type(bec)
type(bec_type)::bec
end
subroutine beccopy(bec,bec1,nkb,nbnd,comm)
type(bec_type),intent(in)::bec
type(bec_type)::bec1
integer(4),intent(in)::nkb
integer(4),intent(in)::nbnd
integer(4),intent(in),optional::comm
end
subroutine becscal_nck(alpha,bec,nkb,nbnd)
complex(8),intent(in)::alpha
type(bec_type),intent(inout)::bec
integer(4),intent(in)::nkb
integer(4),intent(in)::nbnd
end
subroutine becscal_gamma(alpha,bec,nkb,nbnd)
real(8),intent(in)::alpha
type(bec_type),intent(inout)::bec
integer(4),intent(in)::nkb
integer(4),intent(in)::nbnd
end
subroutine becupdate_0d_cpu(offload,bec_host,bec_device)
type(offload_kind_cpu),intent(in)::offload
type(bec_type),intent(out)::bec_host
type(bec_type),intent(in)::bec_device
end
subroutine becupdate_1d_cpu(offload,bec_host,idx,ni,bec_device)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::ni
type(bec_type),intent(out)::bec_host(1_8:int(ni,kind=8))
integer(4),intent(in)::idx
type(bec_type),intent(in)::bec_device
end
subroutine becupdate_2d_cpu(offload,bec_host,idx,ni,jdx,nj,bec_device)
type(offload_kind_cpu),intent(in)::offload
integer(4),intent(in)::ni
integer(4),intent(in)::nj
type(bec_type),intent(out)::bec_host(1_8:int(ni,kind=8),1_8:int(nj,kind=8))
integer(4),intent(in)::idx
integer(4),intent(in)::jdx
type(bec_type),intent(in)::bec_device
end
subroutine becupdate_0d_acc(offload,bec_host,bec_device)
type(offload_kind_acc),intent(in)::offload
type(bec_type),intent(out)::bec_host
type(bec_type),intent(in)::bec_device
end
subroutine becupdate_1d_acc(offload,bec_host,idx,ni,bec_device)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::ni
type(bec_type),intent(out)::bec_host(1_8:int(ni,kind=8))
integer(4),intent(in)::idx
type(bec_type),intent(in)::bec_device
end
subroutine becupdate_2d_acc(offload,bec_host,idx,ni,jdx,nj,bec_device)
type(offload_kind_acc),intent(in)::offload
integer(4),intent(in)::ni
integer(4),intent(in)::nj
type(bec_type),intent(out)::bec_host(1_8:int(ni,kind=8),1_8:int(nj,kind=8))
integer(4),intent(in)::idx
integer(4),intent(in)::jdx
type(bec_type),intent(in)::bec_device
end
end
