﻿!mod$ v1 sum:c987eeebe8d7e3ff
!need$ 538eec7669339b1f n parameters
!need$ e969ea36925aa4b7 n uspp_param
!need$ f1b4423f2906c0b3 n kinds
module ions_base
use kinds,only:dp
use parameters,only:ntypx
use uspp_param,only:nsp
integer(4)::nax
integer(4)::nat
integer(4)::na(1_8:10_8)
integer(4),allocatable::ityp(:)
real(8)::zv(1_8:10_8)
real(8)::amass(1_8:10_8)
real(8)::rcmax(1_8:10_8)
real(8),allocatable::tau(:,:)
real(8),allocatable::vel(:,:)
character(6_4,1)::atm(1_8:10_8)
character(80_4,1)::tau_format
integer(4),allocatable::if_pos(:,:)
integer(4),allocatable::iforce(:,:)
integer(4)::fixatom
integer(4)::ndofp
integer(4)::ndfrz
real(8)::fricp
real(8)::greasp
real(8),allocatable::taui(:,:)
real(8)::cdmi(1_8:3_8)
real(8)::cdm(1_8:3_8)
real(8)::cdms(1_8:3_8)
real(8),allocatable::extfor(:,:)
logical(4)::tions_base_init
logical(4),private::tdebug
contains
subroutine ions_base_init(nsp_,nat_,na_,ityp_,tau_,vel_,amass_,atm_,if_pos_,tau_format_,alat_,at_,rcmax_,extfor_)
integer(4),intent(in)::nsp_
integer(4),intent(in)::nat_
integer(4),intent(in)::na_(:)
integer(4),intent(in)::ityp_(:)
real(8),intent(in)::tau_(:,:)
real(8),intent(in)::vel_(:,:)
real(8),intent(in)::amass_(:)
character(*,1),intent(in)::atm_(:)
integer(4),intent(in)::if_pos_(:,:)
character(*,1),intent(in)::tau_format_
real(8),intent(in)::alat_
real(8),intent(in)::at_(1_8:3_8,1_8:3_8)
real(8),intent(in)::rcmax_(:)
real(8),intent(in)::extfor_(:,:)
end
subroutine deallocate_ions_base()
end
subroutine ions_vel(vel,taup,taum,dt)
real(8)::vel(:,:)
real(8)::taup(:,:)
real(8)::taum(:,:)
real(8)::dt
end
subroutine ions_cofmass(tau,pmass,nat,ityp,cdm)
real(8),intent(in)::tau(:,:)
real(8),intent(in)::pmass(:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
real(8),intent(out)::cdm(1_8:3_8)
end
subroutine randpos(tau,nat,ityp,tranp,amprp,hinv,ifor)
real(8)::tau(:,:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
logical(4),intent(in)::tranp(:)
real(8),intent(in)::amprp(:)
real(8)::hinv(1_8:3_8,1_8:3_8)
integer(4),intent(in)::ifor(:,:)
end
subroutine ions_kinene(ekinp,vels,nat,ityp,h,pmass)
real(8),intent(out)::ekinp
real(8),intent(in)::vels(:,:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
real(8),intent(in)::h(:,:)
real(8),intent(in)::pmass(:)
end
subroutine ions_temp(tempp,temps,ekinpr,vels,nsp,na,nat,ityp,h,pmass,ndega,nhpdim,atm2nhp,ekin2nhp)
real(8),intent(out)::tempp
real(8),intent(out)::temps(:)
real(8),intent(out)::ekinpr
real(8),intent(in)::vels(:,:)
integer(4),intent(in)::nsp
integer(4),intent(in)::na(:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
real(8),intent(in)::h(:,:)
real(8),intent(in)::pmass(:)
integer(4),intent(in)::ndega
integer(4),intent(in)::nhpdim
integer(4),intent(in)::atm2nhp(:)
real(8),intent(out)::ekin2nhp(:)
end
subroutine ions_thermal_stress(stress,nstress,pmass,omega,h,vels,nat,ityp)
real(8),intent(inout)::stress(1_8:3_8,1_8:3_8)
real(8),intent(inout)::nstress(1_8:3_8,1_8:3_8)
real(8),intent(in)::pmass(:)
real(8),intent(in)::omega
real(8),intent(in)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::vels(:,:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
end
subroutine randvel(tempw,tau0,taum,nat,ityp,iforce,amass,delt)
real(8),intent(in)::tempw
real(8),intent(in)::tau0(:,:)
real(8),intent(out)::taum(:,:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
integer(4),intent(in)::iforce(:,:)
real(8),intent(in)::amass(:)
real(8),intent(in)::delt
end
subroutine ions_vrescal(tcap,tempw,tempp,taup,tau0,taum,nat,ityp,fion,iforce,pmass,delt)
logical(4),intent(in)::tcap
real(8),intent(in)::tempw
real(8),intent(in)::tempp
real(8),intent(inout)::taup(:,:)
real(8),intent(in)::tau0(:,:)
real(8),intent(in)::taum(:,:)
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
real(8),intent(in)::fion(:,:)
integer(4),intent(in)::iforce(:,:)
real(8),intent(in)::pmass(:)
real(8),intent(in)::delt
end
subroutine ions_shiftvar(varp,var0,varm)
real(8),intent(in)::varp(:,:)
real(8),intent(out)::var0(:,:)
real(8),intent(out)::varm(:,:)
end
subroutine ions_reference_positions(tau)
real(8)::tau(:,:)
end
subroutine ions_displacement(dis,tau,nsp,nat,ityp)
real(8),intent(out)::dis(:)
real(8),intent(in)::tau(:,:)
integer(4),intent(in)::nsp
integer(4),intent(in)::nat
integer(4),intent(in)::ityp(:)
end
subroutine ions_cofmsub(tausp,iforce,nat,cdm,cdm0)
real(8),intent(inout)::tausp(:,:)
integer(4),intent(in)::iforce(:,:)
integer(4),intent(in)::nat
real(8),intent(in)::cdm(:)
real(8),intent(in)::cdm0(:)
end
function compute_eextfor(tau0)
real(8),intent(in),optional::tau0(:,:)
real(8)::compute_eextfor
end
end
