﻿!mod$ v1 sum:41fc845459278e9d
!need$ 2787e808cf50d06d n control_flags
!need$ af25cce29094dc19 n fft_scalar
!need$ a5e0ad180458d00e n fft_scatter
!need$ 5511003ec39af120 n fft_scatter_2d
!need$ cc98cf1d6de89639 n fft_types
!need$ f1b4423f2906c0b3 n kinds
!need$ 9c3779872f673231 n mp
!need$ 8b27f8c742f3b1de n parallel_include
module lauefft
use control_flags,only:gamma_only
use fft_scalar,only:cft_1z
use fft_scalar,only:cft_2xy
use fft_scatter,only:fft_scatter_xy
use fft_scatter,only:fft_scatter_yz
use fft_scatter_2d,only:fft_scatter2x1=>fft_scatter
use fft_types,only:fft_type_descriptor
use kinds,only:dp
use mp,only:mp_sum
use mp,only:mp_rank
use mp,only:mp_size
use parallel_include,only:mpi_comm_world
use parallel_include,only:mpi_comm_null
use parallel_include,only:mpi_comm_self
private::gamma_only
private::cft_1z
private::cft_2xy
private::fft_scatter_xy
private::fft_scatter_yz
private::fft_scatter2x1
private::fft_type_descriptor
private::dp
private::mp_sum
private::mp_rank
private::mp_size
private::mpi_comm_world
private::mpi_comm_null
private::mpi_comm_self
type::lauefft_type
type(fft_type_descriptor),pointer::dfft
integer(4)::nrz
integer(4)::nrzx
logical(4)::xright
logical(4)::xleft
real(8)::zstep
real(8)::zoffset
real(8)::zright
real(8)::zleft
integer(4)::izcell_start
integer(4)::izcell_end
integer(4)::izright_start
integer(4)::izright_end
integer(4)::izright_start0
integer(4)::izright_end0
integer(4)::izright_gedge
integer(4)::izleft_start
integer(4)::izleft_end
integer(4)::izleft_start0
integer(4)::izleft_end0
integer(4)::izleft_gedge
integer(4)::ngz
integer(4)::gzzero
integer(4),pointer::nlz(:)
real(8),pointer::gz(:)
integer(4),pointer::millz(:)
integer(4),pointer::igtoigz(:,:)
complex(8),pointer::zphase(:)
integer(4)::ngz_x
integer(4)::gzzero_x
integer(4),pointer::nlz_x(:)
real(8),pointer::gz_x(:)
integer(4),pointer::millz_x(:)
complex(8),pointer::zphase_x(:)
integer(4)::ngxy
integer(4)::ngxy_g
integer(4)::nglxy
integer(4)::gxystart
integer(4),pointer::nlxy(:)
integer(4),pointer::nlmxy(:)
real(8),pointer::gxy(:,:)
real(8),pointer::gnxy(:)
real(8),pointer::ggxy(:)
integer(4),pointer::millxy(:,:)
real(8),pointer::glxy(:)
integer(4),pointer::igtonglxy(:)
integer(4),pointer::igtoigxy(:)
end type
contains
subroutine allocate_lauefft(lauefft0,dfft_,dzright,dzleft,ngmt,ig1t,ig2t,ig3t,gt,gcutm,comm)
type(lauefft_type),intent(inout)::lauefft0
type(fft_type_descriptor),intent(in),target::dfft_
real(8),intent(in)::dzright
real(8),intent(in)::dzleft
integer(4),intent(in)::ngmt
integer(4),intent(in)::ig1t(:)
integer(4),intent(in)::ig2t(:)
integer(4),intent(in)::ig3t(:)
real(8),intent(in)::gt(:,:)
real(8),intent(in)::gcutm
integer(4),intent(in)::comm
end
subroutine deallocate_lauefft(lauefft0)
type(lauefft_type),intent(inout)::lauefft0
end
subroutine set_lauefft_offset(lauefft0,wright,wleft)
type(lauefft_type),intent(inout)::lauefft0
real(8),intent(in)::wright
real(8),intent(in)::wleft
end
subroutine set_lauefft_offset0(lauefft0,wright1,wright2,wleft1,wleft2)
type(lauefft_type),intent(inout)::lauefft0
real(8),intent(in)::wright1
real(8),intent(in)::wright2
real(8),intent(in)::wleft1
real(8),intent(in)::wleft2
end
subroutine set_lauefft_barrier(lauefft0,wright,wleft)
type(lauefft_type),intent(inout)::lauefft0
real(8),intent(in)::wright
real(8),intent(in)::wleft
end
subroutine fw_lauefft_1z(lauefft0,cl,nrz,irz_start,cg)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cl(1_8:*)
integer(4),intent(in)::nrz
integer(4),intent(in)::irz_start
complex(8),intent(out)::cg(1_8:*)
end
subroutine inv_lauefft_1z(lauefft0,cg,cl,nrz,irz_start)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cg(1_8:*)
complex(8),intent(out)::cl(1_8:*)
integer(4),intent(in)::nrz
integer(4),intent(in)::irz_start
end
subroutine fw_lauefft_1z_exp(lauefft0,cl,nrz,cg,ngz)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cl(1_8:*)
integer(4),intent(in)::nrz
complex(8),intent(out)::cg(1_8:*)
integer(4),intent(in)::ngz
end
subroutine inv_lauefft_1z_exp(lauefft0,cg,ngz,cl,nrz)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cg(1_8:*)
integer(4),intent(in)::ngz
complex(8),intent(out)::cl(1_8:*)
integer(4),intent(in)::nrz
end
subroutine fw_lauefft_2xy(lauefft0,cr,cl,nrz,irz_start,i3mask)
type(lauefft_type),intent(in)::lauefft0
real(8),intent(in)::cr(1_8:*)
complex(8),intent(out)::cl(1_8:*)
integer(4),intent(in)::nrz
integer(4),intent(in)::irz_start
logical(4),intent(in),optional::i3mask(1_8:*)
end
subroutine inv_lauefft_2xy(lauefft0,cl,nrz,irz_start,cr,i3mask)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cl(1_8:*)
integer(4),intent(in)::nrz
integer(4),intent(in)::irz_start
real(8),intent(out)::cr(1_8:*)
logical(4),intent(in),optional::i3mask(1_8:*)
end
subroutine gather_lauefft(lauefft0,cl,nrz,cltot,lall)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cl(1_8:*)
integer(4),intent(in)::nrz
complex(8),intent(out)::cltot(1_8:*)
logical(4),intent(in),optional::lall
end
subroutine gather_lauefft_to_real(lauefft0,cl,nrz,crtot)
type(lauefft_type),intent(in)::lauefft0
complex(8),intent(in)::cl(1_8:*)
integer(4),intent(in)::nrz
real(8),intent(out)::crtot(1_8:*)
end
end
