﻿!mod$ v1 sum:66ce34dad2c15d44
!need$ f1b4423f2906c0b3 n kinds
module qexsd_copy
use kinds,only:dp
private::dp
interface
subroutine copy_order_um_from_xml(dftu_obj,nsp,nat,hubbard_lmax,order_um)
use qes_types_module,only:dftu_type
type(dftu_type),intent(in)::dftu_obj
integer(4),intent(in)::nsp
integer(4),intent(in)::nat
integer(4),intent(in)::hubbard_lmax
integer(4),allocatable,intent(inout)::order_um(:,:,:)
end
end interface
contains
subroutine qexsd_copy_geninfo(geninfo_obj,qexsd_fmt,qexsd_version)
use qes_types_module,only:general_info_type
type(general_info_type),intent(in)::geninfo_obj
character(*,1),intent(out)::qexsd_fmt
character(*,1),intent(out)::qexsd_version
end
subroutine qexsd_copy_parallel_info(parinfo_obj,nproc_file,nproc_pool_file,nproc_image_file,ntask_groups_file,nproc_bgrp_file,nproc_ortho_file)
use qes_types_module,only:parallel_info_type
type(parallel_info_type),intent(in)::parinfo_obj
integer(4),intent(out)::nproc_file
integer(4),intent(out)::nproc_pool_file
integer(4),intent(out)::nproc_image_file
integer(4),intent(out)::ntask_groups_file
integer(4),intent(out)::nproc_bgrp_file
integer(4),intent(out)::nproc_ortho_file
end
subroutine qexsd_copy_atomic_species(atomic_species,nsp,atm,amass,starting_magnetization,angle1,angle2,psfile,pseudo_dir)
use qes_types_module,only:atomic_species_type
type(atomic_species_type),intent(in)::atomic_species
integer(4),intent(out)::nsp
character(*,1),intent(out)::atm(:)
real(8),intent(out)::amass(:)
real(8),intent(out),optional::starting_magnetization(:)
real(8),intent(out),optional::angle1(:)
real(8),intent(out),optional::angle2(:)
character(*,1),intent(out),optional::psfile(:)
character(*,1),intent(out),optional::pseudo_dir
end
subroutine qexsd_copy_atomic_structure(atomic_structure,nsp,atm,nat,tau,ityp,alat,a1,a2,a3,ibrav,natomwfc)
use qes_types_module,only:atomic_structure_type
type(atomic_structure_type),intent(in)::atomic_structure
integer(4),intent(in)::nsp
character(6_4,1),intent(in)::atm(:)
integer(4),intent(out)::nat
real(8),allocatable,intent(inout)::tau(:,:)
integer(4),allocatable,intent(inout)::ityp(:)
real(8),intent(out)::alat
real(8),intent(out)::a1(:)
real(8),intent(out)::a2(:)
real(8),intent(out)::a3(:)
integer(4),intent(out)::ibrav
integer(4),intent(out)::natomwfc
end
subroutine qexsd_copy_symmetry(symms_obj,spacegroup,nsym,nrot,s,ft,sname,t_rev,invsym,irt,noinv,nosym,no_t_rev,colin_mag,flags_obj)
use qes_types_module,only:symmetries_type
use qes_types_module,only:symmetry_flags_type
type(symmetries_type)::symms_obj
integer(4),intent(out)::spacegroup
integer(4),intent(out)::nsym
integer(4),intent(out)::nrot
integer(4),intent(out)::s(:,:,:)
real(8),intent(out)::ft(:,:)
character(45_4,1)::sname(:)
integer(4),intent(out)::t_rev(:)
logical(4),intent(out)::invsym
integer(4),intent(out)::irt(:,:)
logical(4),intent(out)::noinv
logical(4),intent(out)::nosym
logical(4),intent(out)::no_t_rev
integer(4),intent(out)::colin_mag
type(symmetry_flags_type),optional::flags_obj
end
subroutine qexsd_copy_basis_set(basis_set,gamma_only,ecutwfc,ecutrho,nr1s,nr2s,nr3s,nr1,nr2,nr3,nr1b,nr2b,nr3b,ngm_g,ngms_g,npw_g,b1,b2,b3)
use qes_types_module,only:basis_set_type
type(basis_set_type),intent(in)::basis_set
logical(4),intent(out)::gamma_only
real(8),intent(out)::ecutwfc
real(8),intent(out)::ecutrho
integer(4),intent(out)::nr1s
integer(4),intent(out)::nr2s
integer(4),intent(out)::nr3s
integer(4),intent(out)::nr1
integer(4),intent(out)::nr2
integer(4),intent(out)::nr3
integer(4),intent(inout)::nr1b
integer(4),intent(inout)::nr2b
integer(4),intent(inout)::nr3b
integer(4),intent(out)::ngm_g
integer(4),intent(out)::ngms_g
integer(4),intent(out)::npw_g
real(8),intent(out)::b1(:)
real(8),intent(out)::b2(:)
real(8),intent(out)::b3(:)
end
subroutine qexsd_copy_dft(dft_obj,nsp,atm,dft_name,nq1,nq2,nq3,ecutfock,exx_fraction,screening_parameter,exxdiv_treatment,x_gamma_extrapolation,ecutvcut,local_thr,lda_plus_u,apply_u,lda_plus_u_kind,u_projection,hubbard_n,hubbard_l,hubbard_lmax,hubbard_occ,hubbard_n2,hubbard_l2,hubbard_n3,hubbard_l3,backall,hubbard_lmax_back,hubbard_alpha_back,hubbard_u,hubbard_um,hubbard_u2,hubbard_j0,hubbard_alpha,hubbard_alpha_m,hubbard_beta,hubbard_j,hubbard_v,vdw_corr,dftd3_version,dftd3_3body,scal6,lon_rcut,vdw_isolated)
use qes_types_module,only:dft_type
type(dft_type),intent(in)::dft_obj
integer(4),intent(in)::nsp
character(*,1),intent(in)::atm(1_8:int(nsp,kind=8))
character(*,1),intent(out)::dft_name
integer(4),intent(inout)::nq1
integer(4),intent(inout)::nq2
integer(4),intent(inout)::nq3
real(8),intent(inout)::ecutfock
real(8),intent(inout)::exx_fraction
real(8),intent(inout)::screening_parameter
character(*,1),intent(inout)::exxdiv_treatment
logical(4),intent(inout)::x_gamma_extrapolation
real(8),intent(inout)::ecutvcut
real(8),intent(inout)::local_thr
logical(4),intent(out)::lda_plus_u
logical(4),intent(out)::apply_u
integer(4),intent(inout)::lda_plus_u_kind
character(*,1),intent(inout)::u_projection
integer(4),intent(inout)::hubbard_n(:)
integer(4),intent(inout)::hubbard_l(:)
integer(4),intent(inout)::hubbard_lmax
real(8),intent(inout)::hubbard_occ(:,:)
integer(4),intent(inout),optional::hubbard_n2(:)
integer(4),intent(inout),optional::hubbard_l2(:)
integer(4),intent(inout)::hubbard_n3(:)
integer(4),intent(inout),optional::hubbard_l3(:)
logical(4),intent(inout)::backall(:)
integer(4),intent(inout),optional::hubbard_lmax_back
real(8),intent(inout),optional::hubbard_alpha_back(:)
real(8),intent(inout)::hubbard_u(:)
real(8),intent(inout),optional::hubbard_um(:,:,:)
real(8),intent(inout),optional::hubbard_u2(:)
real(8),intent(inout)::hubbard_j0(:)
real(8),intent(inout)::hubbard_alpha(:)
real(8),intent(inout)::hubbard_alpha_m(:,:,:)
real(8),intent(inout)::hubbard_beta(:)
real(8),intent(inout)::hubbard_j(:,:)
real(8),intent(inout)::hubbard_v(:,:,:)
character(*,1),intent(out)::vdw_corr
integer(4),intent(inout)::dftd3_version
logical(4),intent(inout)::dftd3_3body
real(8),intent(inout)::scal6
real(8),intent(inout)::lon_rcut
logical(4),intent(inout)::vdw_isolated
end
subroutine qexsd_copy_band_structure(band_struct_obj,lsda,nkstot,isk,nbnd,nbnd_up,nbnd_dw,nelec,xk,wk,wg,ef,ef_up,ef_dw,et)
use qes_types_module,only:band_structure_type
type(band_structure_type)::band_struct_obj
logical(4),intent(out)::lsda
integer(4),intent(out)::nkstot
integer(4),intent(out)::isk(:)
integer(4),intent(out)::nbnd
integer(4),intent(out)::nbnd_up
integer(4),intent(out)::nbnd_dw
real(8),intent(out)::nelec
real(8),intent(out)::xk(:,:)
real(8),intent(out)::wk(:)
real(8),allocatable,intent(inout)::wg(:,:)
real(8),intent(out)::ef
real(8),intent(out)::ef_up
real(8),intent(out)::ef_dw
real(8),allocatable,intent(inout)::et(:,:)
end
subroutine qexsd_copy_efermi(band_struct_obj,nelec,ef,two_fermi_energies,ef_up,ef_dw,nbnd)
use qes_types_module,only:band_structure_type
type(band_structure_type)::band_struct_obj
real(8),intent(out)::nelec
real(8),intent(out)::ef
logical(4),intent(out)::two_fermi_energies
real(8),intent(out)::ef_up
real(8),intent(out)::ef_dw
integer(4),intent(out),optional::nbnd
end
subroutine qexsd_copy_algorithmic_info(algo_obj,real_space,tqr,okvan,okpaw)
use qes_types_module,only:algorithmic_info_type
type(algorithmic_info_type),intent(in)::algo_obj
logical(4),intent(out)::real_space
logical(4),intent(out)::tqr
logical(4),intent(out)::okvan
logical(4),intent(out)::okpaw
end
subroutine qexsd_copy_twochem(two_chem_obj,twochem,nbnd_cond,nelec_cond,degauss_cond,ef_cond)
use qes_types_module,only:two_chem_type
type(two_chem_type),intent(in)::two_chem_obj
logical(4),intent(out)::twochem
integer(4),intent(out)::nbnd_cond
real(8),intent(out)::nelec_cond
real(8),intent(out)::degauss_cond
real(8),intent(out),optional::ef_cond
end
subroutine qexsd_copy_efield(efield_obj,tefield,dipfield,edir,emaxpos,eopreg,eamp,gate,zgate,block_,block_1,block_2,block_height,relaxz)
use qes_types_module,only:electric_field_type
type(electric_field_type),intent(in),optional::efield_obj
logical(4),intent(out)::tefield
logical(4),intent(out)::dipfield
integer(4),intent(inout)::edir
real(8),intent(inout)::emaxpos
real(8),intent(inout)::eopreg
real(8),intent(inout)::eamp
logical(4),intent(inout)::gate
real(8),intent(inout)::zgate
logical(4),intent(inout)::block_
real(8),intent(inout)::block_1
real(8),intent(inout)::block_2
real(8),intent(inout)::block_height
logical(4),intent(inout)::relaxz
end
subroutine qexsd_copy_magnetization(magnetization_obj,lsda,noncolin,lspinorb,domag,tot_magnetization)
use qes_types_module,only:magnetization_type
type(magnetization_type),intent(in)::magnetization_obj
logical(4),intent(out)::lsda
logical(4),intent(out)::noncolin
logical(4),intent(out)::lspinorb
logical(4),intent(out)::domag
real(8),intent(out)::tot_magnetization
end
subroutine qexsd_copy_kpoints(band_struct_obj,nks_start,xk_start,wk_start,nk1,nk2,nk3,k1,k2,k3,occupations,smearing,degauss)
use qes_types_module,only:band_structure_type
type(band_structure_type),intent(in)::band_struct_obj
integer(4),intent(out)::nks_start
real(8),allocatable,intent(inout)::xk_start(:,:)
real(8),allocatable,intent(inout)::wk_start(:)
integer(4),intent(out)::nk1
integer(4),intent(out)::nk2
integer(4),intent(out)::nk3
integer(4),intent(out)::k1
integer(4),intent(out)::k2
integer(4),intent(out)::k3
character(*,1),intent(out)::occupations
character(*,1),intent(out)::smearing
real(8),intent(out)::degauss
end
subroutine qexsd_copy_esm(pbc_obj,bc,nfit,w,efield,a)
use qes_types_module,only:outputpbc_type
type(outputpbc_type),intent(in)::pbc_obj
character(3_4,1),intent(out)::bc
integer(4),intent(out)::nfit
real(8),intent(out)::w
real(8),intent(out)::efield
real(8),intent(out)::a
end
subroutine qexsd_copy_rism3d(rism3d_obj,pseudo_dir,nsolv,solvs,molfile,ecutsolv)
use molecule_types,only:molecule
use qes_types_module,only:rism3d_type
type(rism3d_type),intent(in)::rism3d_obj
character(*,1),intent(in)::pseudo_dir
integer(4),intent(out)::nsolv
type(molecule),allocatable,intent(inout)::solvs(:)
character(*,1),intent(out)::molfile(:)
real(8),intent(out)::ecutsolv
end
subroutine qexsd_copy_rismlaue(rismlaue_obj,both_hands,laue_nfit,ireference,qsol,starting_r,expand_r,buffer_r,buffer_ru,buffer_rv,starting_l,expand_l,buffer_l,buffer_lu,buffer_lv)
use qes_types_module,only:rismlaue_type
type(rismlaue_type),intent(in)::rismlaue_obj
logical(4),intent(out)::both_hands
integer(4),intent(out)::laue_nfit
integer(4),intent(out)::ireference
real(8),intent(out)::qsol
real(8),intent(out)::starting_r
real(8),intent(out)::expand_r
real(8),intent(out)::buffer_r
real(8),intent(out)::buffer_ru
real(8),intent(out)::buffer_rv
real(8),intent(out)::starting_l
real(8),intent(out)::expand_l
real(8),intent(out)::buffer_l
real(8),intent(out)::buffer_lu
real(8),intent(out)::buffer_lv
end
end
