﻿!mod$ v1 sum:591df85bbcb76ffb
!need$ 2ff0996d4eeece74 n constants
!need$ af25cce29094dc19 n fft_scalar
!need$ c119bb7a828c08b2 n fft_support
!need$ f1b4423f2906c0b3 n kinds
!need$ 9c3779872f673231 n mp
module radfft
use constants,only:tpi
use fft_scalar,only:cft_1z
use fft_support,only:good_fft_order
use kinds,only:dp
use mp,only:mp_sum
use mp,only:mp$mp$mp_sum_rm=>mp_sum_rm
private::tpi
private::cft_1z
private::good_fft_order
private::dp
private::mp_sum
private::mp$mp$mp_sum_rm
type::radfft_type
integer(4)::ngrid
integer(4)::mgrid
integer(4)::lgrid
integer(4)::igrid_start
integer(4)::igrid_end
integer(4)::igrid_len
integer(4)::comm
logical(4)::lmpi
real(8),pointer::rgrid(:)
real(8),pointer::ggrid(:)
real(8),pointer::singr(:,:)
end type
contains
subroutine allocate_radfft(radfft0,nr,rmax)
type(radfft_type),intent(inout)::radfft0
integer(4),intent(in)::nr
real(8),intent(in)::rmax
end
subroutine init_mpi_radfft(radfft0,comm_,igrid1,igrid2)
type(radfft_type),intent(inout)::radfft0
integer(4),intent(in)::comm_
integer(4),intent(in)::igrid1
integer(4),intent(in)::igrid2
end
subroutine deallocate_radfft(radfft0)
type(radfft_type),intent(inout)::radfft0
end
subroutine fw_radfft(radfft0,cr,cg)
type(radfft_type),intent(inout)::radfft0
real(8),intent(in)::cr(:)
real(8),intent(out)::cg(:)
end
subroutine inv_radfft(radfft0,cg,cr)
type(radfft_type),intent(inout)::radfft0
real(8),intent(in)::cg(:)
real(8),intent(out)::cr(:)
end
subroutine fw_mpi_radfft(radfft0,cr,cg,mult)
type(radfft_type),intent(in)::radfft0
real(8),intent(in)::cr(1_8:*)
real(8),intent(out)::cg(1_8:*)
integer(4),intent(in)::mult
end
subroutine inv_mpi_radfft(radfft0,cg,cr,mult)
type(radfft_type),intent(in)::radfft0
real(8),intent(in)::cg(1_8:*)
real(8),intent(out)::cr(1_8:*)
integer(4),intent(in)::mult
end
end
