﻿!mod$ v1 sum:7365b3436c25f034
!need$ 45fe7f5a8b9c5448 n cell_base
!need$ cb61175df4cb3924 n io_global
!need$ 41fc845459278e9d n lauefft
!need$ 9c3779872f673231 n mp
!need$ 8b27f8c742f3b1de n parallel_include
!need$ 2ff0996d4eeece74 n constants
!need$ cc98cf1d6de89639 n fft_types
!need$ f1b4423f2906c0b3 n kinds
module solvavg
use constants,only:bohr_radius_angs
use cell_base,only:at
use cell_base,only:alat
use fft_types,only:fft_type_descriptor
use fft_types,only:fft_index_to_3d
use io_global,only:ionode
use kinds,only:dp
use lauefft,only:lauefft_type
use mp,only:mp_sum
use parallel_include,only:mpi_comm_world
use parallel_include,only:mpi_comm_null
use parallel_include,only:mpi_comm_self
use mp,only:mp$mp$mp_sum_cv=>mp_sum_cv
use mp,only:mp$mp$mp_sum_i1=>mp_sum_i1
use mp,only:mp$mp$mp_sum_rv=>mp_sum_rv
private::bohr_radius_angs
private::at
private::alat
private::fft_type_descriptor
private::fft_index_to_3d
private::ionode
private::dp
private::lauefft_type
private::mp_sum
private::mpi_comm_world
private::mpi_comm_null
private::mpi_comm_self
private::mp$mp$mp_sum_cv
private::mp$mp$mp_sum_i1
private::mp$mp$mp_sum_rv
integer(4),parameter,private::len_label=20_4
integer(4),parameter,private::max_num_data=64_4
type(fft_type_descriptor),pointer,private::dfft
intrinsic::null
private::null
type(lauefft_type),pointer,private::lfft
integer(4),private::intra_group_comm
logical(4),private::radial
integer(4),private::ndata
character(20_4,1),allocatable,private::label(:)
real(8),allocatable,private::rdata(:,:)
private::solvavg_init_3d
private::solvavg_init_laue
private::solvavg_put_real
private::solvavg_put_laue
private::solvavg_add_real
private::solvavg_add_laue
private::open_file
private::close_file
private::write_data
interface solvavg_init
procedure::solvavg_init_3d
procedure::solvavg_init_laue
end interface
interface solvavg_put
procedure::solvavg_put_real
procedure::solvavg_put_laue
end interface
interface solvavg_add
procedure::solvavg_add_real
procedure::solvavg_add_laue
end interface
contains
function solvavg_size()
integer(4)::solvavg_size
end
subroutine solvavg_init_3d(dfft_,comm,is_radial)
type(fft_type_descriptor),intent(in),target::dfft_
integer(4),intent(in)::comm
logical(4),intent(in)::is_radial
end
subroutine solvavg_init_laue(lfft_,comm,is_radial)
type(lauefft_type),intent(in),target::lfft_
integer(4),intent(in)::comm
logical(4),intent(in)::is_radial
end
subroutine solvavg_clear()
end
subroutine solvavg_put_real(title,integrate,zuv)
character(*,1),intent(in)::title
logical(4),intent(in)::integrate
real(8),intent(in)::zuv(:)
end
subroutine solvavg_put_laue(title,integrate,zuv,nrz,expanded,igxy)
character(*,1),intent(in)::title
logical(4),intent(in)::integrate
complex(8),intent(in)::zuv(:)
integer(4),intent(in)::nrz
logical(4),intent(in)::expanded
integer(4),intent(in),optional::igxy
end
subroutine solvavg_add_real(idata,integrate,zuv)
integer(4),intent(in)::idata
logical(4),intent(in)::integrate
real(8),intent(in)::zuv(:)
end
subroutine solvavg_add_laue(idata,integrate,zuv,nrz,expanded,igxy)
integer(4),intent(in)::idata
logical(4),intent(in)::integrate
complex(8),intent(in)::zuv(:)
integer(4),intent(in)::nrz
logical(4),intent(in)::expanded
integer(4),intent(in),optional::igxy
end
subroutine solvavg_print(filename,comment,ierr)
character(*,1),intent(in)::filename
character(*,1),intent(in)::comment
integer(4),intent(out)::ierr
end
subroutine open_file(iun,filename,ierr)
integer(4),intent(out)::iun
character(*,1),intent(in)::filename
integer(4),intent(out)::ierr
end
subroutine close_file(iun)
integer(4),intent(in)::iun
end
subroutine write_data(iun)
integer(4),intent(in)::iun
end
end
