﻿!mod$ v1 sum:de9cefe834c3af14
!need$ 888d7eee8ea30ed1 n buffers
!need$ e3ba1ad8cef4e8f2 n xc_lib
!need$ 4ef1a9ac43379ffe n fft_base
!need$ f87d2291ad116153 n fft_rho
!need$ a8bc71d507344621 n gvecs
!need$ a4e4c53f604986d0 n extfield
!need$ 2b399cea54179784 n ldau
!need$ c987eeebe8d7e3ff n ions_base
!need$ f1b4423f2906c0b3 n kinds
!need$ 2787e808cf50d06d n control_flags
!need$ 0ddc620bbf8949af n gvect
!need$ 63e233f05715b372 n paw_variables
!need$ e969ea36925aa4b7 n uspp_param
!need$ c5f1c8811c453a76 n lsda_mod
module scf
use kinds,only:dp
use lsda_mod,only:nspin
use ldau,only:lda_plus_u
use ldau,only:hubbard_lmax
use ldau,only:lda_plus_u_kind
use ldau,only:ldmx
use ldau,only:ldmx_b
use ldau,only:is_hubbard_back
use ldau,only:orbital_resolved
use ions_base,only:nat
use buffers,only:open_buffer
use buffers,only:close_buffer
use buffers,only:get_buffer
use buffers,only:save_buffer
use xc_lib,only:xclib_dft_is
use fft_base,only:dfftp
use fft_rho,only:rho_g2r
use gvect,only:ngm
use gvecs,only:ngms
use ions_base,only:ntyp=>nsp
use paw_variables,only:okpaw
use uspp_param,only:nhm
use extfield,only:dipfield
use extfield,only:emaxpos
use extfield,only:eopreg
use extfield,only:edir
use control_flags,only:lxdm
use control_flags,only:sic
use fft_rho,only:fft_rho$fft_rho$rho_g2r_nspin=>rho_g2r_nspin
private::fft_rho$fft_rho$rho_g2r_nspin
type::scf_type
real(8),allocatable::of_r(:,:)
complex(8),allocatable::of_g(:,:)
real(8),allocatable::kin_r(:,:)
complex(8),allocatable::kin_g(:,:)
real(8),allocatable::ns(:,:,:,:)
real(8),allocatable::nsb(:,:,:,:)
complex(8),allocatable::ns_nc(:,:,:,:)
real(8),allocatable::bec(:,:,:)
real(8),allocatable::pol_r(:,:)
complex(8),allocatable::pol_g(:,:)
end type
type::mix_type
complex(8),allocatable::of_g(:,:)
complex(8),allocatable::kin_g(:,:)
real(8),allocatable::ns(:,:,:,:)
real(8),allocatable::nsb(:,:,:,:)
complex(8),allocatable::ns_nc(:,:,:,:)
real(8),allocatable::bec(:,:,:)
real(8)::el_dipole
complex(8),allocatable::pol_g(:,:)
end type
type(scf_type)::rho
type(scf_type)::v
type(scf_type)::vnew
real(8)::v_of_0
real(8),allocatable::vltot(:)
real(8),allocatable::vrs(:,:)
real(8),allocatable::rho_core(:)
real(8),allocatable::kedtau(:,:)
complex(8),allocatable::rhog_core(:)
integer(4),private::record_length
integer(4),private::rlen_rho
integer(4),private::rlen_kin
integer(4),private::rlen_ldau
integer(4),private::rlen_bec
integer(4),private::rlen_dip
integer(4),private::rlen_ldaub
integer(4),private::rlen_pol
integer(4),private::start_rho
integer(4),private::start_kin
integer(4),private::start_ldau
integer(4),private::start_bec
integer(4),private::start_dipole
integer(4),private::start_ldaub
integer(4),private::start_pol
integer(4)::nt
logical(4),private::lda_plus_u_co
logical(4),private::lda_plus_u_cob
logical(4),private::lda_plus_u_nc
complex(8),allocatable,private::io_buffer(:)
contains
subroutine create_scf_type(rho,do_not_allocate_becsum)
type(scf_type)::rho
logical(4),intent(in),optional::do_not_allocate_becsum
end
subroutine destroy_scf_type(rho)
type(scf_type)::rho
end
subroutine create_mix_type(rho)
type(mix_type)::rho
end
subroutine destroy_mix_type(rho)
type(mix_type)::rho
end
subroutine assign_scf_to_mix_type(rho_s,rho_m)
type(scf_type),intent(in)::rho_s
type(mix_type),intent(inout)::rho_m
end
subroutine assign_mix_to_scf_type(rho_m,rho_s)
type(mix_type),intent(in)::rho_m
type(scf_type),intent(inout)::rho_s
end
subroutine scf_type_copy(x,y)
type(scf_type),intent(in)::x
type(scf_type),intent(inout)::y
end
subroutine mix_type_axpy(a,x,y)
real(8)::a
type(mix_type),intent(in)::x
type(mix_type),intent(inout)::y
end
subroutine mix_type_copy(x,y)
type(mix_type),intent(in)::x
type(mix_type),intent(inout)::y
end
subroutine mix_type_scal(a,x)
real(8),intent(in)::a
type(mix_type),intent(inout)::x
end
subroutine high_frequency_mixing(rhoin,input_rhout,alphamix)
type(scf_type),intent(inout)::rhoin
type(scf_type),intent(in)::input_rhout
real(8),intent(in)::alphamix
end
subroutine open_mix_file(iunit,extension,exst)
integer(4),intent(in)::iunit
character(*,1),intent(in)::extension
logical(4)::exst
end
subroutine close_mix_file(iunit,stat)
integer(4),intent(in)::iunit
character(*,1),intent(in)::stat
end
subroutine davcio_mix_type(rho,iunit,record,iflag)
type(mix_type)::rho
integer(4),intent(in)::iunit
integer(4),intent(in)::record
integer(4),intent(in)::iflag
end
function rho_ddot(rho1,rho2,gf,g0)
type(mix_type),intent(in)::rho1
type(mix_type),intent(in)::rho2
integer(4),intent(in)::gf
real(8),intent(in),optional::g0
real(8)::rho_ddot
end
function tauk_ddot(rho1,rho2,gf)
type(mix_type),intent(in)::rho1
type(mix_type),intent(in)::rho2
integer(4),intent(in)::gf
real(8)::tauk_ddot
end
function ns_ddot(rho1,rho2)
type(mix_type),intent(in)::rho1
type(mix_type),intent(in)::rho2
real(8)::ns_ddot
end
function nsg_ddot(nsg1,nsg2,nspin)
use ldau,only:ldmx_tot
use ldau,only:max_num_neighbors
use ions_base,only:nat
integer(4),intent(in)::nspin
complex(8),intent(in)::nsg1(1_8:int(ldmx_tot,kind=8),1_8:int(ldmx_tot,kind=8),1_8:int(max_num_neighbors,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
complex(8),intent(in)::nsg2(1_8:int(ldmx_tot,kind=8),1_8:int(ldmx_tot,kind=8),1_8:int(max_num_neighbors,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
real(8)::nsg_ddot
end
function ns_ddot_um(rho1,rho2)
type(mix_type),intent(in)::rho1
type(mix_type),intent(in)::rho2
real(8)::ns_ddot_um
end
function ns_ddot_um_nc(rho1,rho2)
type(mix_type),intent(in)::rho1
type(mix_type),intent(in)::rho2
real(8)::ns_ddot_um_nc
end
function local_tf_ddot(rho1,rho2,ngm0,g0)
integer(4),intent(in)::ngm0
complex(8),intent(in)::rho1(1_8:int(ngm0,kind=8))
complex(8),intent(in)::rho2(1_8:int(ngm0,kind=8))
real(8),intent(in),optional::g0
real(8)::local_tf_ddot
end
subroutine bcast_scf_type(rho,root,comm)
type(scf_type),intent(inout)::rho
integer(4),intent(in)::root
integer(4),intent(in)::comm
end
subroutine rhoz_or_updw(rho,sp,dir)
type(scf_type),intent(inout)::rho
character(*,1),intent(in)::sp
character(*,1),intent(in)::dir
end
end
