﻿!mod$ v1 sum:3bc3e9b844ff876c
!need$ 7f9410f37bc92197 n upf_kinds
module radial_grids
use upf_kinds,only:dp
private::dp
integer(4),parameter::ndmx=3500_4
type::radial_grid_type
integer(4)::mesh
real(8),pointer::r(:)
real(8),pointer::r2(:)
real(8),pointer::rab(:)
real(8),pointer::sqr(:)
real(8),pointer::rm1(:)
real(8),pointer::rm2(:)
real(8),pointer::rm3(:)
real(8)::xmin
real(8)::rmax
real(8)::zmesh
real(8)::dx
end type
private::deallocate_radial_grid_s
private::deallocate_radial_grid_v
interface deallocate_radial_grid
procedure::deallocate_radial_grid_s
procedure::deallocate_radial_grid_v
end interface
contains
subroutine radial_grid_copy(x,y)
type(radial_grid_type),intent(in)::x
type(radial_grid_type),intent(inout)::y
end
subroutine allocate_radial_grid(grid,mesh)
type(radial_grid_type),intent(inout)::grid
integer(4),intent(in)::mesh
end
subroutine deallocate_radial_grid_s(grid)
type(radial_grid_type),intent(inout)::grid
end
subroutine deallocate_radial_grid_v(grid)
type(radial_grid_type),intent(inout)::grid(:)
end
subroutine nullify_radial_grid(grid)
type(radial_grid_type),intent(inout)::grid
end
subroutine do_mesh(rmax,zmesh,xmin,dx,ibound,grid)
real(8),intent(in)::rmax
real(8),intent(in)::zmesh
real(8),intent(inout)::xmin
real(8),intent(in)::dx
integer(4),intent(in)::ibound
type(radial_grid_type),intent(out)::grid
end
subroutine check_mesh(grid)
type(radial_grid_type),intent(in)::grid
end
subroutine hartree(k,nst,mesh,grid,f,vh)
integer(4),intent(in)::k
integer(4),intent(in)::nst
integer(4),intent(in)::mesh
type(radial_grid_type),intent(in)::grid
real(8),intent(in)::f(1_8:int(mesh,kind=8))
real(8),intent(out)::vh(1_8:int(mesh,kind=8))
end
subroutine series(f,r,r2,b)
real(8)::f(1_8:4_8)
real(8)::r(1_8:4_8)
real(8)::r2(1_8:4_8)
real(8)::b(0_8:3_8)
end
end
