﻿!mod$ v1 sum:1c8ba219ca52a95f
!need$ facbbf8dc372c282 n mctc_data_atomicrad
!need$ d6bdee47f6502f3f n tblite_container
!need$ a53d5fe901b7082c n tblite_cutoff
!need$ 14874dc85dd5ca88 n tblite_repulsion_type
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
module tblite_classical_halogen
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_data_atomicrad,only:get_atomic_rad
use tblite_container,only:container_cache
use tblite_cutoff,only:get_lattice_points
use tblite_repulsion_type,only:repulsion_type
use mctc_data_atomicrad,only:mctc_data_atomicrad$mctc_data_atomicrad$get_atomic_rad_number=>get_atomic_rad_number
use tblite_cutoff,only:tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff=>get_lattice_points_cutoff
private::wp
private::structure_type
private::get_atomic_rad
private::container_cache
private::get_lattice_points
private::repulsion_type
private::mctc_data_atomicrad$mctc_data_atomicrad$get_atomic_rad_number
private::tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff
type,extends(repulsion_type)::halogen_correction
real(8),allocatable::bond_strength(:)
real(8),allocatable::rad(:)
real(8)::damping
logical(4),allocatable::acceptor(:)
logical(4),allocatable::halogen(:)
real(8)::cutoff=2.e1_8
contains
procedure::get_engrad
end type
real(8),parameter,private::alp=6._8
real(8),parameter,private::lj=1.2e1_8
real(8),parameter,private::lj2=6._8
character(*,1),parameter,private::label="halogen-bond correction"
private::is_halogen
private::is_acceptor
private::get_engrad
private::get_xbond_list
private::resize
private::get_xbond_energy
private::get_xbond_derivs
contains
subroutine new_halogen_correction(self,mol,damping,rad_scale,bond_strength,rad,cutoff)
type(halogen_correction),intent(out)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::damping
real(8),intent(in)::rad_scale
real(8),intent(in)::bond_strength(:)
real(8),intent(in),optional::rad(:)
real(8),intent(in),optional::cutoff
end
elemental function is_halogen(num) result(halogen)
integer(4),intent(in)::num
logical(4)::halogen
end
elemental function is_acceptor(num) result(acceptor)
integer(4),intent(in)::num
logical(4)::acceptor
end
subroutine get_engrad(self,mol,cache,energies,gradient,sigma)
class(halogen_correction),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
real(8),intent(inout)::energies(:)
real(8),contiguous,intent(inout),optional::gradient(:,:)
real(8),contiguous,intent(inout),optional::sigma(:,:)
end
subroutine get_xbond_list(mol,trans,cutoff,halogen,acceptor,list)
type(structure_type),intent(in)::mol
real(8),intent(in)::trans(:,:)
real(8),intent(in)::cutoff
logical(4),intent(in)::halogen(:)
logical(4),intent(in)::acceptor(:)
integer(4),allocatable,intent(out)::list(:,:)
end
pure subroutine resize(var,n)
integer(4),allocatable,intent(inout)::var(:,:)
integer(4),intent(in),optional::n
end
subroutine get_xbond_energy(mol,trans,list,damping,bond_strength,rad,energies)
type(structure_type),intent(in)::mol
real(8),intent(in)::trans(:,:)
integer(4),intent(in)::list(:,:)
real(8),intent(in)::damping
real(8),intent(in)::bond_strength(:)
real(8),intent(in)::rad(:)
real(8),intent(inout)::energies(:)
end
subroutine get_xbond_derivs(mol,trans,list,damping,bond_strength,rad,energies,gradient,sigma)
type(structure_type),intent(in)::mol
real(8),intent(in)::trans(:,:)
integer(4),intent(in)::list(:,:)
real(8),intent(in)::damping
real(8),intent(in)::bond_strength(:)
real(8),intent(in)::rad(:)
real(8),intent(inout)::energies(:)
real(8),intent(inout)::gradient(:,:)
real(8),intent(inout)::sigma(:,:)
end
end
