﻿!mod$ v1 sum:3150bef61474aedb
!need$ 77d8f01b1bea75b8 n tblite_coulomb_charge
!need$ 53a0161af3d7b7e0 n tblite_coulomb_multipole
!need$ 4b1b21389a985be9 n tblite_coulomb_type
!need$ 4ba9281d3cab36d6 n tblite_scf_potential
!need$ 86e45708dff95640 n tblite_wavefunction_type
!need$ 35a78865758f9288 n tblite_container_cache
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
module tblite_coulomb_thirdorder
use mctc_env,only:wp
use mctc_io,only:structure_type
use tblite_container_cache,only:container_cache
use tblite_coulomb_charge,only:effective_coulomb
use tblite_coulomb_multipole,only:damped_multipole
use tblite_coulomb_type,only:coulomb_type
use tblite_scf_potential,only:potential_type
use tblite_wavefunction_type,only:wavefunction_type
private::wp
private::structure_type
private::container_cache
private::effective_coulomb
private::damped_multipole
private::coulomb_type
private::potential_type
private::wavefunction_type
type,extends(coulomb_type)::onsite_thirdorder
logical(4)::shell_resolved
integer(4),allocatable::nsh_at(:)
integer(4),allocatable::ish_at(:)
real(8),allocatable::hubbard_derivs(:,:)
contains
procedure::update
procedure::variable_info
procedure::get_energy
procedure::get_potential
procedure::get_potential_gradient
procedure::get_gradient
end type
character(*,1),parameter,private::label="onsite third-order electrostatics"
private::update
private::get_energy
private::get_potential
private::get_potential_gradient
private::get_gradient
private::variable_info
contains
subroutine new_onsite_thirdorder(self,mol,hubbard_derivs,nshell)
type(onsite_thirdorder),intent(out)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::hubbard_derivs(:,:)
integer(4),intent(in),optional::nshell(:)
end
subroutine update(self,mol,cache)
class(onsite_thirdorder),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
end
subroutine get_energy(self,mol,cache,wfn,energies)
class(onsite_thirdorder),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
real(8),intent(inout)::energies(:)
end
subroutine get_potential(self,mol,cache,wfn,pot)
class(onsite_thirdorder),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
type(potential_type),intent(inout)::pot
end
subroutine get_potential_gradient(self,mol,cache,wfn,pot)
class(onsite_thirdorder),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
type(potential_type),intent(inout)::pot
end
subroutine get_gradient(self,mol,cache,wfn,gradient,sigma)
class(onsite_thirdorder),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
real(8),contiguous,intent(inout)::gradient(:,:)
real(8),contiguous,intent(inout)::sigma(:,:)
end
pure function variable_info(self) result(info)
use tblite_scf_info,only:scf_info
class(onsite_thirdorder),intent(in)::self
type(scf_info)::info
end
end
