# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/ML clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "ML requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/ML build
## ---------------------------------------------------------------------------

set(ML_CXX_COMPILER "D:/a/msys64/clang64/bin/clang++.exe")

set(ML_C_COMPILER "D:/a/msys64/clang64/bin/clang.exe")

set(ML_Fortran_COMPILER "D:/a/msys64/clang64/bin/flang.exe")
# Deprecated!
set(ML_FORTRAN_COMPILER "D:/a/msys64/clang64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/ML build
## ---------------------------------------------------------------------------

## Give the build type
set(ML_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(ML_CXX_FLAGS [[ ]])

set(ML_C_FLAGS [[-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong ]])

set(ML_Fortran_FLAGS [[ ]])
# Deprecated
set(ML_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(ML_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(ML_SHARED_LIB_RPATH_COMMAND "/clang64/lib")
set(ML_BUILD_SHARED_LIBS "ON")

set(ML_LINKER D:/a/msys64/clang64/bin/ld.lld.exe)
set(ML_AR D:/a/msys64/clang64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(ML_INSTALL_DIR "/clang64")

## List of package libraries
set(ML_LIBRARIES ML::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(ML_MPI_LIBRARIES "")
set(ML_MPI_LIBRARY_DIRS "")
set(ML_MPI_INCLUDE_DIRS "")
set(ML_MPI_EXEC "")
set(ML_MPI_EXEC_MAX_NUMPROCS "")
set(ML_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(ML_ENABLE_BLAS ON)
set(ML_ENABLE_LAPACK ON)
set(ML_ENABLE_Teuchos OFF)
set(ML_ENABLE_Epetra OFF)
set(ML_ENABLE_Zoltan OFF)
set(ML_ENABLE_Galeri OFF)
set(ML_ENABLE_Amesos OFF)
set(ML_ENABLE_Ifpack OFF)
set(ML_ENABLE_AztecOO OFF)
set(ML_ENABLE_EpetraExt OFF)
set(ML_ENABLE_Isorropia OFF)
set(ML_ENABLE_MPI OFF)
set(ML_ENABLE_METIS OFF)
set(ML_ENABLE_ParMETIS OFF)
set(ML_ENABLE_PETSC OFF)
set(ML_ENABLE_SuperLU OFF)
set(ML_ENABLE_MATLAB OFF)

# Exported cache variables
set(ML_ENABLE_Aztec "OFF")
set(HAVE_ML_AZTEC "OFF")
set(ML_ENABLE_SuperLU1_0 "OFF")
set(HAVE_ML_SUPERLU1_0 "OFF")
set(ML_ENABLE_SuperLU2_0 "OFF")
set(HAVE_ML_SUPERLU2_0 "OFF")
set(ML_ENABLE_SUPERLUDIST "OFF")
set(HAVE_ML_SUPERLUDIST "OFF")
set(ML_ENABLE_Enrich "OFF")
set(HAVE_ML_ENRICH "OFF")
set(ML_ENABLE_Memory_Check "OFF")
set(HAVE_ML_MEMORY_CHECK "OFF")
set(ML_ENABLE_New_T_PE "OFF")
set(HAVE_ML_NEW_T_PE "OFF")
set(ML_ENABLE_Complex_Maxwell "OFF")
set(HAVE_ML_COMPLEX_MAXWELL "OFF")
set(ML_ENABLE_Timing "OFF")
set(HAVE_ML_TIMING "OFF")
set(ML_ENABLE_Flops "OFF")
set(HAVE_ML_FLOPS "OFF")
set(ML_ENABLE_MLapi "OFF")
set(HAVE_ML_MLAPI "OFF")
set(ML_ENABLE_Cfunc "OFF")
set(HAVE_ML_CFUNC "OFF")
set(ML_ENABLE_TekoSmoothers "OFF")
set(HAVE_ML_TekoSmoothers "OFF")

# Include configuration of dependent packages
if (NOT TARGET BLAS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/BLAS/BLASConfig.cmake")
endif()
if (NOT TARGET LAPACK::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/LAPACK/LAPACKConfig.cmake")
endif()

# Import ML targets
include("${CMAKE_CURRENT_LIST_DIR}/MLTargets.cmake")

# Standard TriBITS-compliant external package variables
set(ML_IS_TRIBITS_COMPLIANT TRUE)
set(ML_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(ML_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(ML_EXPORTED_PACKAGE_LIBS_NAMES "ml")

foreach(libname IN LISTS ML_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE ML::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'ML::${libname}', or better yet,"
      " 'ML::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'ML'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'ML_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
