#ifndef _CEGOPROCCURSORCLOSESTMT_H_INCLUDED_
#define _CEGOPROCCURSORCLOSESTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursorCloseStmt.h  
// -------------------------
// Cego procedure cursor close statement interface
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcCursorCloseStmt
// 
// Description: Stored procedure statement for cursor closing
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoProcStmt.h"
#include "CegoProcCursor.h"
#include "CegoProcBlock.h"

class CegoProcCursorCloseStmt : public CegoProcStmt  {
    
public:
    
    CegoProcCursorCloseStmt(CegoProcCursor *pCur, CegoProcBlock *pBlock);
    
    ~CegoProcCursorCloseStmt();
    
    CegoException execute();
    
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

private:

    CegoProcCursor* _pCur;
};

#endif
