﻿!mod$ v1 sum:925979f1c9e02ebc
!need$ 8d88796f9f6601c7 n types
!need$ cd85671e834d2c36 n messages
module h1basis
use types,only:dp
use types,only:vector_block_length
use messages,only:message
use messages,only:outputprefix
use messages,only:outputcaller
use messages,only:outputlevelmask
use messages,only:maxoutputlevel
use messages,only:minoutputlevel
use messages,only:outputpe
use messages,only:maxoutputpe
use messages,only:minoutputpe
use messages,only:exit_ok
use messages,only:exit_error
use messages,only:info
use messages,only:infoactive
use messages,only:warn
use messages,only:error
use messages,only:fatal
integer(4),parameter::h1basis_maxpelementedgenodes=2_4
integer(4),parameter::h1basis_maxpelementedges=12_4
integer(4),parameter::h1basis_maxpelementfacenodes=4_4
integer(4),parameter::h1basis_maxpelementfaces=6_4
contains
subroutine h1basis_getedgedirection(ecode,nedges,globalind,direction)
integer(4),intent(in)::ecode
integer(4),intent(in)::nedges
integer(4),intent(in),pointer::globalind(:)
integer(4),intent(inout)::direction(1_8:2_8,1_8:12_8)
end
subroutine h1basis_gettetraedgedirection(ttype,direction)
integer(4),intent(in)::ttype
integer(4),intent(inout),target::direction(1_8:2_8,1_8:12_8)
end
subroutine h1basis_getfacedirection(ecode,nfaces,globalind,direction)
integer(4),intent(in)::ecode
integer(4),intent(in)::nfaces
integer(4),intent(in),pointer::globalind(:)
integer(4),intent(inout)::direction(1_8:4_8,1_8:6_8)
end
subroutine h1basis_gettetrafacedirection(ttype,direction)
integer(4),intent(in)::ttype
integer(4),intent(inout),target::direction(1_8:4_8,1_8:6_8)
end
subroutine h1basis_getedgemap(ecode,map)
integer(4),intent(in)::ecode
integer(4),intent(out),target::map(1_8:2_8,1_8:12_8)
end
subroutine h1basis_getfacemap(ecode,map)
integer(4),intent(in)::ecode
integer(4),intent(out),target::map(1_8:4_8,1_8:6_8)
end
subroutine h1basis_linenodal(nvec,u,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dlinenodal(nvec,u,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
subroutine h1basis_linebubblep(nvec,u,pmax,nbasismax,fval,nbasis,invertedge)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
logical(4),optional::invertedge
end
subroutine h1basis_dlinebubblep(nvec,u,pmax,nbasismax,grad,nbasis,invertedge)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
logical(4),optional::invertedge
end
subroutine h1basis_trianglenodalp(nvec,u,v,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
function h1basis_trianglel(node,u,v) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::u
real(8),intent(in)::v
real(8)::fval
end
subroutine h1basis_dtrianglenodalp(nvec,u,v,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
function h1basis_dtrianglel(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:2_8)
end
subroutine h1basis_triangleedgep(nvec,u,v,pmax,nbasismax,fval,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_dtriangleedgep(nvec,u,v,pmax,nbasismax,grad,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_trianglebubblep(nvec,u,v,pmax,nbasismax,fval,nbasis,localnumbers)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in),optional::localnumbers(1_8:3_8)
end
subroutine h1basis_dtrianglebubblep(nvec,u,v,pmax,nbasismax,grad,nbasis,localnumbers)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in),optional::localnumbers(1_8:3_8)
end
function h1basis_powint(x,j) result(powi)
real(8),intent(in)::x
integer(4),intent(in)::j
real(8)::powi
end
subroutine h1basis_quadnodal(nvec,u,v,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dquadnodal(nvec,u,v,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
subroutine h1basis_quadedgep(nvec,u,v,pmax,nbasismax,fval,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_dquadedgep(nvec,u,v,pmax,nbasismax,grad,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_quadbubblep(nvec,u,v,pmax,nbasismax,fval,nbasis,localnumbers)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in),optional::localnumbers(1_8:4_8)
end
subroutine h1basis_dquadbubblep(nvec,u,v,pmax,nbasismax,grad,nbasis,localnumbers)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in),optional::localnumbers(1_8:4_8)
end
function h1basis_quadl(node,u,v) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::u
real(8),intent(in)::v
real(8)::fval
end
function h1basis_dquadl(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:2_8)
end
subroutine h1basis_tetranodalp(nvec,u,v,w,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
function h1basis_tetral(node,u,v,w) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::u
real(8),intent(in)::v
real(8),intent(in)::w
real(8)::fval
end
subroutine h1basis_dtetranodalp(nvec,u,v,w,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
function h1basis_dtetral(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:3_8)
end
subroutine h1basis_tetraedgep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_dtetraedgep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_tetrafacep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_dtetrafacep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_tetrabubblep(nvec,u,v,w,pmax,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dtetrabubblep(nvec,u,v,w,pmax,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
subroutine h1basis_wedgenodalp(nvec,u,v,w,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dwedgenodalp(nvec,u,v,w,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
function h1basis_wedgel(node,u,v) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::u
real(8),intent(in)::v
real(8)::fval
end
function h1basis_dwedgel(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:3_8)
end
function h1basis_wedgeh(node,w) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::w
real(8)::fval
end
function h1basis_dwedgeh(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:3_8)
end
subroutine h1basis_wedgeedgep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_dwedgeedgep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_wedgefacep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_dwedgefacep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_wedgebubblep(nvec,u,v,w,pmax,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dwedgebubblep(nvec,u,v,w,pmax,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
subroutine h1basis_bricknodal(nvec,u,v,w,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dbricknodal(nvec,u,v,w,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
function h1basis_brickl(node,u,v,w) result(fval)
integer(4),intent(in)::node
real(8),intent(in)::u
real(8),intent(in)::v
real(8),intent(in)::w
real(8)::fval
end
function h1basis_dbrickl(node) result(grad)
integer(4),intent(in)::node
real(8)::grad(1_8:3_8)
end
subroutine h1basis_brickedgel(edge,u,v,w,la,lb)
integer(4),intent(in)::edge
real(8),intent(in)::u
real(8),intent(in)::v
real(8),intent(in)::w
real(8),intent(out)::la
real(8),intent(out)::lb
end
subroutine h1basis_dbrickedgel(edge,dla,dlb)
integer(4),intent(in)::edge
real(8),intent(out)::dla(1_8:3_8)
real(8),intent(out)::dlb(1_8:3_8)
end
subroutine h1basis_brickedgep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_dbrickedgep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,edgedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::edgedir(:,:)
end
subroutine h1basis_brickfacep(nvec,u,v,w,pmax,nbasismax,fval,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_dbrickfacep(nvec,u,v,w,pmax,nbasismax,grad,nbasis,facedir)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax(:)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
integer(4),intent(in)::facedir(:,:)
end
subroutine h1basis_brickbubblep(nvec,u,v,w,pmax,nbasismax,fval,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
integer(4),intent(inout)::nbasis
end
subroutine h1basis_dbrickbubblep(nvec,u,v,w,pmax,nbasismax,grad,nbasis)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::pmax
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
integer(4),intent(inout)::nbasis
end
function h1basis_phi(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
function h1basis_dphi(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
function h1basis_varphi(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
function h1basis_dvarphi(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
function h1basis_legendrep(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
function h1basis_dlegendrep(k,x) result(fval)
integer(4),intent(in)::k
real(8),intent(in)::x
real(8)::fval
end
subroutine h1basis_trianglenodal(nvec,u,v,nbasismax,fval)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
end
subroutine h1basis_dtrianglenodal(nvec,u,v,nbasismax,grad)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
end
subroutine h1basis_tetranodal(nvec,u,v,w,nbasismax,fval)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
end
subroutine h1basis_dtetranodal(nvec,u,v,w,nbasismax,grad)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
end
subroutine h1basis_wedgenodal(nvec,u,v,w,nbasismax,fval)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::fval(1_8:128_8,1_8:int(nbasismax,kind=8))
end
subroutine h1basis_dwedgenodal(nvec,u,v,w,nbasismax,grad)
integer(4),intent(in)::nvec
real(8),intent(in)::u(1_8:128_8)
real(8),intent(in)::v(1_8:128_8)
real(8),intent(in)::w(1_8:128_8)
integer(4),intent(in)::nbasismax
real(8),intent(inout)::grad(1_8:128_8,1_8:int(nbasismax,kind=8),1_8:3_8)
end
end
