/*
 * This file is part of the libjaylink project.
 *
 * Copyright (C) 2015 Marc Schink <jaylink-dev@marcschink.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBJAYLINK_VERSION_H
#define LIBJAYLINK_VERSION_H

/**
 * @file
 *
 * Package and library version macros.
 */

/** Major version number of the libjaylink package. */
#define JAYLINK_VERSION_PACKAGE_MAJOR		0

/** Minor version number of the libjaylink package. */
#define JAYLINK_VERSION_PACKAGE_MINOR		4

/** Micro version number of the libjaylink package. */
#define JAYLINK_VERSION_PACKAGE_MICRO		0

/** Version number string of the libjaylink package. */
#define JAYLINK_VERSION_PACKAGE_STRING		"0.4.0"

/** <i>Current</i> version number of the libjaylink libtool interface. */
#define JAYLINK_VERSION_LIBRARY_CURRENT		2

/** <i>Revision</i> version number of the libjaylink libtool interface. */
#define JAYLINK_VERSION_LIBRARY_REVISION	1

/** <i>Age</i> version number of the libjaylink libtool interface. */
#define JAYLINK_VERSION_LIBRARY_AGE		2

/** Version number string of the libjaylink libtool interface. */
#define JAYLINK_VERSION_LIBRARY_STRING		"2:1:2"

#endif /* LIBJAYLINK_VERSION_H */
