﻿!mod$ v1 sum:4593a8ba00c8c44b
!need$ 627ce8bd2df1524a i iso_c_binding
!need$ e30d66a195cd7129 n mbd_version
!need$ 0dfac272ee37c993 n mbd_coulomb
!need$ 0cbce8c07d87b087 n mbd_density
!need$ 8d0d9a9d4403ab4f n mbd_methods
!need$ 2d0818d03440aaca n mbd_ts
!need$ 4d3ad4f29fa4ff76 n mbd_utils
!need$ bb381bf46e508468 i __fortran_builtins
!need$ 05082512439ea895 n mbd_dipole
!need$ 9f8aa3d6e64573f2 n mbd_matrix
!need$ 8f2d951c784e2cd4 n mbd_damping
!need$ 0d5a1a6e26bb4dcb n mbd_geom
!need$ b30b6efa3a84bd58 n mbd_gradients
!need$ 58272acdba890bc4 n mbd_constants
module mbd_c_api
use mbd_coulomb,only:dipole_energy
use mbd_coulomb,only:coulomb_energy
use mbd_damping,only:damping_t
use mbd_dipole,only:dipole_matrix
use mbd_density,only:eval_mbd_nonint_density
use mbd_density,only:eval_mbd_int_density
use mbd_geom,only:geom_t
use mbd_gradients,only:grad_t
use mbd_gradients,only:grad_request_t
use mbd_matrix,only:matrix_re_t
use mbd_matrix,only:matrix_cplx_t
use mbd_methods,only:get_mbd_energy
use mbd_methods,only:get_mbd_scs_energy
use mbd_ts,only:get_ts_energy
use mbd_utils,only:result_t
use,intrinsic::iso_c_binding,only:c_associated
use,intrinsic::iso_c_binding,only:c_funloc
use,intrinsic::iso_c_binding,only:c_funptr
use,intrinsic::iso_c_binding,only:c_f_pointer
use,intrinsic::iso_c_binding,only:c_loc
use,intrinsic::iso_c_binding,only:c_null_funptr
use,intrinsic::iso_c_binding,only:c_null_ptr
use,intrinsic::iso_c_binding,only:c_ptr
use,intrinsic::iso_c_binding,only:c_sizeof
use,intrinsic::iso_c_binding,only:operator(==)
use,intrinsic::iso_c_binding,only:operator(/=)
use,intrinsic::iso_c_binding,only:c_int8_t
use,intrinsic::iso_c_binding,only:c_int16_t
use,intrinsic::iso_c_binding,only:c_int32_t
use,intrinsic::iso_c_binding,only:c_int64_t
use,intrinsic::iso_c_binding,only:c_int128_t
use,intrinsic::iso_c_binding,only:c_int
use,intrinsic::iso_c_binding,only:c_short
use,intrinsic::iso_c_binding,only:c_long
use,intrinsic::iso_c_binding,only:c_long_long
use,intrinsic::iso_c_binding,only:c_signed_char
use,intrinsic::iso_c_binding,only:c_size_t
use,intrinsic::iso_c_binding,only:c_intmax_t
use,intrinsic::iso_c_binding,only:c_intptr_t
use,intrinsic::iso_c_binding,only:c_ptrdiff_t
use,intrinsic::iso_c_binding,only:c_int_least8_t
use,intrinsic::iso_c_binding,only:c_int_fast8_t
use,intrinsic::iso_c_binding,only:c_int_least16_t
use,intrinsic::iso_c_binding,only:c_int_fast16_t
use,intrinsic::iso_c_binding,only:c_int_least32_t
use,intrinsic::iso_c_binding,only:c_int_fast32_t
use,intrinsic::iso_c_binding,only:c_int_least64_t
use,intrinsic::iso_c_binding,only:c_int_fast64_t
use,intrinsic::iso_c_binding,only:c_int_least128_t
use,intrinsic::iso_c_binding,only:c_int_fast128_t
use,intrinsic::iso_c_binding,only:c_float
use,intrinsic::iso_c_binding,only:c_double
use,intrinsic::iso_c_binding,only:c_long_double
use,intrinsic::iso_c_binding,only:c_float_complex
use,intrinsic::iso_c_binding,only:c_double_complex
use,intrinsic::iso_c_binding,only:c_long_double_complex
use,intrinsic::iso_c_binding,only:c_bool
use,intrinsic::iso_c_binding,only:c_char
use,intrinsic::iso_c_binding,only:c_null_char
use,intrinsic::iso_c_binding,only:c_alert
use,intrinsic::iso_c_binding,only:c_backspace
use,intrinsic::iso_c_binding,only:c_form_feed
use,intrinsic::iso_c_binding,only:c_new_line
use,intrinsic::iso_c_binding,only:c_carriage_return
use,intrinsic::iso_c_binding,only:c_horizontal_tab
use,intrinsic::iso_c_binding,only:c_vertical_tab
use,intrinsic::iso_c_binding,only:c_float128
use,intrinsic::iso_c_binding,only:c_float128_complex
use,intrinsic::iso_c_binding,only:c_uint8_t
use,intrinsic::iso_c_binding,only:c_uint16_t
use,intrinsic::iso_c_binding,only:c_uint32_t
use,intrinsic::iso_c_binding,only:c_uint64_t
use,intrinsic::iso_c_binding,only:c_uint128_t
use,intrinsic::iso_c_binding,only:c_unsigned_char
use,intrinsic::iso_c_binding,only:c_unsigned_short
use,intrinsic::iso_c_binding,only:c_unsigned
use,intrinsic::iso_c_binding,only:c_unsigned_long
use,intrinsic::iso_c_binding,only:c_unsigned_long_long
use,intrinsic::iso_c_binding,only:c_uintmax_t
use,intrinsic::iso_c_binding,only:c_uint_fast8_t
use,intrinsic::iso_c_binding,only:c_uint_fast16_t
use,intrinsic::iso_c_binding,only:c_uint_fast32_t
use,intrinsic::iso_c_binding,only:c_uint_fast64_t
use,intrinsic::iso_c_binding,only:c_uint_fast128_t
use,intrinsic::iso_c_binding,only:c_uint_least8_t
use,intrinsic::iso_c_binding,only:c_uint_least16_t
use,intrinsic::iso_c_binding,only:c_uint_least32_t
use,intrinsic::iso_c_binding,only:c_uint_least64_t
use,intrinsic::iso_c_binding,only:c_uint_least128_t
use,intrinsic::iso_c_binding,only:c_f_procpointer
use mbd_constants,only:dp
use mbd_constants,only:kind
use mbd_constants,only:pi
use mbd_constants,only:acos
use mbd_constants,only:ang
use mbd_constants,only:mbd_exc_neg_eigvals
use mbd_constants,only:mbd_exc_neg_pol
use mbd_constants,only:mbd_exc_linalg
use mbd_constants,only:mbd_exc_unimpl
use mbd_constants,only:mbd_exc_damping
use mbd_constants,only:mbd_exc_input
use mbd_constants,only:mbd_log_lvl_debug
use mbd_constants,only:mbd_log_lvl_info
use mbd_constants,only:mbd_log_lvl_warn
use mbd_constants,only:mbd_log_lvl_error
use mbd_constants,only:zero_real
use mbd_constants,only:zero_complex
use mbd_constants,only:imi
use mbd_version,only:mbd_version_major
use mbd_version,only:mbd_version_minor
use mbd_version,only:mbd_version_patch
use mbd_version,only:mbd_version_suffix
use,intrinsic::__fortran_builtins,only:iso_c_binding$__fortran_builtins$c_associated_c_ptr=>c_associated_c_ptr
use mbd_dipole,only:mbd_dipole$mbd_dipole$dipole_matrix_complex=>dipole_matrix_complex
use mbd_dipole,only:mbd_dipole$mbd_dipole$dipole_matrix_real=>dipole_matrix_real
private::dipole_energy
private::coulomb_energy
private::damping_t
private::dipole_matrix
private::eval_mbd_nonint_density
private::eval_mbd_int_density
private::geom_t
private::grad_t
private::grad_request_t
private::matrix_re_t
private::matrix_cplx_t
private::get_mbd_energy
private::get_mbd_scs_energy
private::get_ts_energy
private::result_t
private::c_associated
private::c_funloc
private::c_funptr
private::c_f_pointer
private::c_loc
private::c_null_funptr
private::c_null_ptr
private::c_ptr
private::c_sizeof
private::operator(==)
private::operator(/=)
private::c_int8_t
private::c_int16_t
private::c_int32_t
private::c_int64_t
private::c_int128_t
private::c_int
private::c_short
private::c_long
private::c_long_long
private::c_signed_char
private::c_size_t
private::c_intmax_t
private::c_intptr_t
private::c_ptrdiff_t
private::c_int_least8_t
private::c_int_fast8_t
private::c_int_least16_t
private::c_int_fast16_t
private::c_int_least32_t
private::c_int_fast32_t
private::c_int_least64_t
private::c_int_fast64_t
private::c_int_least128_t
private::c_int_fast128_t
private::c_float
private::c_double
private::c_long_double
private::c_float_complex
private::c_double_complex
private::c_long_double_complex
private::c_bool
private::c_char
private::c_null_char
private::c_alert
private::c_backspace
private::c_form_feed
private::c_new_line
private::c_carriage_return
private::c_horizontal_tab
private::c_vertical_tab
private::c_float128
private::c_float128_complex
private::c_uint8_t
private::c_uint16_t
private::c_uint32_t
private::c_uint64_t
private::c_uint128_t
private::c_unsigned_char
private::c_unsigned_short
private::c_unsigned
private::c_unsigned_long
private::c_unsigned_long_long
private::c_uintmax_t
private::c_uint_fast8_t
private::c_uint_fast16_t
private::c_uint_fast32_t
private::c_uint_fast64_t
private::c_uint_fast128_t
private::c_uint_least8_t
private::c_uint_least16_t
private::c_uint_least32_t
private::c_uint_least64_t
private::c_uint_least128_t
private::c_f_procpointer
private::dp
private::kind
private::pi
private::acos
private::ang
private::mbd_exc_neg_eigvals
private::mbd_exc_neg_pol
private::mbd_exc_linalg
private::mbd_exc_unimpl
private::mbd_exc_damping
private::mbd_exc_input
private::mbd_log_lvl_debug
private::mbd_log_lvl_info
private::mbd_log_lvl_warn
private::mbd_log_lvl_error
private::zero_real
private::zero_complex
private::imi
private::mbd_version_major
private::mbd_version_minor
private::mbd_version_patch
private::mbd_version_suffix
private::iso_c_binding$__fortran_builtins$c_associated_c_ptr
private::mbd_dipole$mbd_dipole$dipole_matrix_complex
private::mbd_dipole$mbd_dipole$dipole_matrix_real
logical(1),bind(c)::cmbd_with_mpi
logical(1),bind(c)::cmbd_with_scalapack
integer(4),private::i
integer(4),bind(c)::cmbd_version_major
integer(4),bind(c)::cmbd_version_minor
integer(4),bind(c)::cmbd_version_patch
character(1_4,1),bind(c)::cmbd_version_suffix(1_8:30_8)
private::cmbd_nonint_density
private::cmbd_int_density
private::f_string
private::f_c_string
contains
function cmbd_init_geom(n_atoms,coords,lattice,k_grid,n_kpts,custom_k_pts,n_freq,do_rpa,get_spectrum,get_rpa_orders,rpa_rescale_eigs,max_atoms_per_block,ewald_cutoff_scaling) bind(c)
integer(4),intent(in),value::n_atoms
real(8),intent(in)::coords(1_8:3_8,1_8:int(n_atoms,kind=8))
real(8),intent(in),optional::lattice(1_8:3_8,1_8:3_8)
integer(4),intent(in),optional::k_grid(1_8:3_8)
integer(4),intent(in),value::n_kpts
real(8),intent(in),optional::custom_k_pts(1_8:3_8,1_8:int(n_kpts,kind=8))
integer(4),intent(in),value::n_freq
logical(1),intent(in),value::do_rpa
logical(1),intent(in),value::get_spectrum
logical(1),intent(in),value::get_rpa_orders
logical(1),intent(in),value::rpa_rescale_eigs
integer(4),intent(in),value::max_atoms_per_block
real(8),intent(in)::ewald_cutoff_scaling(1_8:2_8)
type(c_ptr)::cmbd_init_geom
end
subroutine cmbd_update_coords(geom_c,coords_c) bind(c)
type(c_ptr),intent(in),value::geom_c
type(c_ptr),intent(in),value::coords_c
end
subroutine cmbd_update_lattice(geom_c,lattice) bind(c)
type(c_ptr),intent(in),value::geom_c
real(8),intent(in)::lattice(1_8:3_8,1_8:3_8)
end
subroutine cmbd_destroy_geom(geom_c) bind(c)
type(c_ptr),intent(in),value::geom_c
end
subroutine cmbd_get_exception(geom_c,code,origin,msg) bind(c)
type(c_ptr),intent(in),value::geom_c
integer(4),intent(out)::code
character(1_8,1),intent(out)::origin(1_8:50_8)
character(1_8,1),intent(out)::msg(1_8:150_8)
end
function cmbd_init_damping(n_atoms,version_c,r_vdw,sigma,beta,a) bind(c)
integer(4),intent(in),value::n_atoms
character(1_8,1),intent(in)::version_c(1_8:*)
real(8),intent(in),optional::r_vdw(1_8:int(n_atoms,kind=8))
real(8),intent(in),optional::sigma(1_8:int(n_atoms,kind=8))
real(8),intent(in),value::beta
real(8),intent(in),value::a
type(c_ptr)::cmbd_init_damping
end
subroutine cmbd_destroy_damping(damping_c) bind(c)
type(c_ptr),intent(in),value::damping_c
end
function cmbd_ts_energy(geom_c,alpha_0_c,c6_c,damping_c,grad) bind(c)
type(c_ptr),intent(in),value::geom_c
type(c_ptr),intent(in),value::alpha_0_c
type(c_ptr),intent(in),value::c6_c
type(c_ptr),intent(in),value::damping_c
logical(1),intent(in),value::grad
type(c_ptr)::cmbd_ts_energy
end
function cmbd_mbd_energy(geom_c,alpha_0_c,c6_c,damping_c,grad) bind(c)
type(c_ptr),intent(in),value::geom_c
type(c_ptr),intent(in),value::alpha_0_c
type(c_ptr),intent(in),value::c6_c
type(c_ptr),intent(in),value::damping_c
logical(1),intent(in),value::grad
type(c_ptr)::cmbd_mbd_energy
end
function cmbd_mbd_scs_energy(geom_c,variant_c,alpha_0_c,c6_c,damping_c,grad) bind(c)
type(c_ptr),intent(in),value::geom_c
character(1_8,1),intent(in)::variant_c(1_8:*)
type(c_ptr),intent(in),value::alpha_0_c
type(c_ptr),intent(in),value::c6_c
type(c_ptr),intent(in),value::damping_c
logical(1),intent(in),value::grad
type(c_ptr)::cmbd_mbd_scs_energy
end
subroutine cmbd_get_results(res_c,energy,gradients_c,lattice_gradients_c,eigvals_c,eigvecs_c,rpa_orders_c,eigvals_k_c,eigvecs_k_c,alpha_0_c,c6_c) bind(c)
type(c_ptr),intent(in),value::res_c
real(8),intent(out)::energy
type(c_ptr),intent(in),value::gradients_c
type(c_ptr),intent(in),value::lattice_gradients_c
type(c_ptr),intent(in),value::eigvals_c
type(c_ptr),intent(in),value::eigvecs_c
type(c_ptr),intent(in),value::rpa_orders_c
type(c_ptr),intent(in),value::eigvals_k_c
type(c_ptr),intent(in),value::eigvecs_k_c
type(c_ptr),intent(in),value::alpha_0_c
type(c_ptr),intent(in),value::c6_c
end
subroutine cmbd_destroy_result(res_c) bind(c)
type(c_ptr),intent(in),value::res_c
end
subroutine cmbd_print_timing(geom_c) bind(c)
type(c_ptr),intent(in),value::geom_c
end
subroutine cmbd_dipole_matrix(geom_c,damping_c,q_point,dipmat_c) bind(c)
type(c_ptr),intent(in),value::geom_c
type(c_ptr),intent(in),value::damping_c
real(8),intent(in),optional::q_point(1_8:3_8)
type(c_ptr),intent(in),value::dipmat_c
end
function cmbd_coulomb_energy(geom_c,n_atoms,q,m,w_t,version,r_vdw,beta,a,c) bind(c)
type(c_ptr),value::geom_c
integer(4),intent(in),value::n_atoms
real(8),intent(in)::q(1_8:int(n_atoms,kind=8))
real(8),intent(in)::m(1_8:int(n_atoms,kind=8))
real(8),intent(in)::w_t(1_8:int(3_4*n_atoms,kind=8))
character(1_4,1),intent(in)::version(1_8:20_8)
real(8),intent(in)::r_vdw(1_8:int(n_atoms,kind=8))
real(8),intent(in),value::beta
real(8),intent(in),value::a
real(8),intent(in)::c(1_8:int(3_4*n_atoms,kind=8),1_8:int(3_4*n_atoms,kind=8))
real(8)::cmbd_coulomb_energy
end
function cmbd_dipole_energy(geom_c,n_atoms,a0,w,w_t,version,r_vdw,beta,a,c) bind(c)
type(c_ptr),value::geom_c
integer(4),intent(in),value::n_atoms
real(8),intent(in)::a0(1_8:int(n_atoms,kind=8))
real(8),intent(in)::w(1_8:int(n_atoms,kind=8))
real(8),intent(in)::w_t(1_8:int(3_4*n_atoms,kind=8))
character(1_4,1),intent(in)::version(1_8:20_8)
real(8),intent(in)::r_vdw(1_8:int(n_atoms,kind=8))
real(8),intent(in),value::beta
real(8),intent(in),value::a
real(8),intent(in)::c(1_8:int(3_4*n_atoms,kind=8),1_8:int(3_4*n_atoms,kind=8))
real(8)::cmbd_dipole_energy
end
subroutine cmbd_nonint_density(geom_c,n_atoms,n_pts,pts,charges,masses,omegas,rho) bind(c)
type(c_ptr),value::geom_c
integer(4),intent(in),value::n_atoms
integer(4),intent(in),value::n_pts
real(8),intent(in)::pts(1_8:3_8,1_8:int(n_pts,kind=8))
real(8),intent(in)::charges(1_8:int(n_atoms,kind=8))
real(8),intent(in)::masses(1_8:int(n_atoms,kind=8))
real(8),intent(in)::omegas(1_8:int(n_atoms,kind=8))
real(8),intent(out)::rho(1_8:int(n_pts,kind=8))
end
subroutine cmbd_int_density(geom_c,n_atoms,n_pts,pts,charges,masses,omegas,modes,rho) bind(c)
type(c_ptr),value::geom_c
integer(4),intent(in),value::n_atoms
integer(4),intent(in),value::n_pts
real(8),intent(in)::pts(1_8:3_8,1_8:int(n_pts,kind=8))
real(8),intent(in)::charges(1_8:int(n_atoms,kind=8))
real(8),intent(in)::masses(1_8:int(n_atoms,kind=8))
real(8),intent(in)::omegas(1_8:int(3_4*n_atoms,kind=8))
real(8),intent(in)::modes(1_8:int(3_4*n_atoms,kind=8),1_8:int(3_4*n_atoms,kind=8))
real(8),intent(out)::rho(1_8:int(n_pts,kind=8))
end
function f_string(str_c) result(str_f)
character(1_8,1),intent(in)::str_c(1_8:*)
character(:,1),allocatable::str_f
end
subroutine f_c_string(str_f,str_c)
character(*,1),intent(in)::str_f
character(1_8,1),intent(out)::str_c(:)
end
end
