/* livephototools.vapi generated by valac 0.56.18, do not modify. */

[CCode (gir_namespace = "LivePhotoTools", gir_version = "0.4")]
namespace LivePhotoConv {
	namespace Utils {
		/**
		 * Reads a string from an input stream.
		 *
		 * This function reads data from the provided input stream and converts it into a string.
		 * It uses a buffer to read the data in chunks and appends it to a string builder.
		 * The function continues reading until there is no more data to read from the input stream.
		 *
		 * @param input_stream The input stream to read from.
		 * @throws IOError if an error occurs while reading from the input stream.
		 * @return The string read from the input stream.
		 */
		[CCode (cheader_filename = "livephototools.h")]
		public static string get_string_from_file_input_stream (GLib.InputStream input_stream) throws GLib.IOError;
		/**
		 * Writes the contents of an input stream to an output stream.
		 *
		 * @param input_stream The input stream to read from.
		 * @param output_stream The output stream to write to.
		 *
		 * @throws IOError if an error occurs while reading from or writing to the streams.
		 */
		[CCode (cheader_filename = "livephototools.h")]
		public static void write_stream (GLib.InputStream input_stream, GLib.OutputStream output_stream) throws GLib.IOError;
		/**
		 * Writes data from an input stream to an output stream until a specified end position is reached.
		 *
		 * @param input_stream The input stream to read data from.
		 * @param output_stream The output stream to write data to.
		 * @param end The position in the input stream to stop writing data at.
		 *
		 * @throws IOError if an error occurs while reading from or writing to the streams.
		 */
		[CCode (cheader_filename = "livephototools.h")]
		public static void write_stream_before (GLib.InputStream input_stream, GLib.OutputStream output_stream, int64 end) throws GLib.IOError;
	}
	/**
	 * Live photo maker base class.
	 *
	 * Provides functionality to create a live photo by combining an optional main image 
	 * and a video file. If the main image is null, uses the first video frame.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public abstract class LiveMaker : GLib.Object {
		protected string dest;
		protected string? main_image_path;
		protected GExiv2.Metadata metadata;
		protected string video_path;
		/**
		 * Creates a new LiveMaker instance.
		 *
		 * @param video_path The path to the video file
		 * @param main_image_path The path to the main image file (optional)
		 * @param dest The destination path for output (optional)
		 */
		protected LiveMaker (string video_path, string? main_image_path = null, string? dest = null);
		/**
		 * Make a live photo.
		 *
		 * This function creates a live photo by combining an optional main image and a video file.
		 * The live photo is saved to the specified destination path.
		 * If the main image is `null`, it will use the first frame of the video as the main image.
		 *
		 * @throws Error if there is an error during the process.
		 */
		public void export () throws GLib.Error;
		protected abstract GLib.File export_main_image () throws GLib.Error;
		protected abstract int64 export_with_video_only () throws GLib.Error;
		protected static bool is_supported_main_image (GLib.File file);
		public bool export_original_metadata { get; set; }
		public GLib.FileCreateFlags file_create_flags { get; set; }
		public bool make_backup { get; set; }
	}
	/**
	 * Implementation of LiveMaker using FFmpeg.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public class LiveMakerFFmpeg : LivePhotoConv.LiveMaker {
		/**
		 * Creates a new instance.
		 *
		 * @param video_path Path to the video file
		 * @param main_image_path Path to the main image
		 * @param dest Destination path for output
		 */
		public LiveMakerFFmpeg (string video_path, string? main_image_path = null, string? dest = null);
		public override GLib.File export_main_image () throws GLib.Error;
		/**
		 * Exports live photo using video only.
		 *
		 * @return The size of the video file
		 * @throws Error If an error occurs during export
		 */
		public override int64 export_with_video_only () throws GLib.Error;
	}
	/**
	 * A class for creating live photos using GStreamer.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public class LiveMakerGst : LivePhotoConv.LiveMaker {
		/**
		 * Creates a new LiveMakerGst instance.
		 *
		 * @param video_path Path to the video file
		 * @param main_image_path Path to the main image
		 * @param dest The destination path for output
		 */
		public LiveMakerGst (string video_path, string? main_image_path = null, string? dest = null);
		public override GLib.File export_main_image () throws GLib.Error;
		/**
		 * Exports the live photo with video only.
		 *
		 * @throws Error If an error occurs during export
		 * @return The size of the video file
		 */
		public override int64 export_with_video_only () throws GLib.Error;
	}
	/**
	 * Represents a live photo.
	 *
	 * This class provides a set of functions to extract the main image and video from a live photo.
	 * Also, it can split the video into images.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public abstract class LivePhoto : GLib.Object {
		protected string basename;
		protected string basename_no_ext;
		protected string dest_dir;
		protected string extension_name;
		protected string filename;
		protected GExiv2.Metadata metadata;
		protected int64 video_offset;
		protected GLib.Tree<string?,string?> xmp_map;
		/**
		 * Creates a new instance of the LivePhoto class.
		 *
		 * The path to the **live photo** file is required.
		 * The destination directory for the converted live photo is optional.
		 * If not provided, the directory of the input file will be used.
		 * The file creation flags can be specified to control the behavior of the file creation process.
		 * By default, the destination file will be replaced if it already exists.
		 * A backup of the destination file can be created before replacing it.
		 * The original metadata of the live photo can be exported.
		 *
		 * @param filename The path to the live photo file.
		 * @param dest_dir The destination directory for the converted live photo. If not provided, the directory of the input file will be used.
		 * @throws Error if an error occurs while retrieving the offset.
		 */
		protected LivePhoto (string filename, string? dest_dir = null) throws GLib.Error;
		/**
		 * Export the main image of the live photo.
		 *
		 * The destination path for the exported main image can be specified.
		 * If not provided, a default path will be used.
		 *
		 * @param dest The destination path for the exported main image. If null, a default path will be used.
		 * @throws Error if there is an error during the export process.
		 * @return The path of the exported main image.
		 */
		public string export_main_image (string? dest = null) throws GLib.Error;
		/**
		 * Export the video of the live photo.
		 *
		 * The destination path for the exported video can be specified.
		 * If not provided, a default path will be used.
		 * The video is exported from the live photo and saved as an MP4 file.
		 *
		 * @param dest The destination path for the exported video. If not provided, a default path will be used.
		 * @throws Error if there is an error during the export process.
		 * @return The path of the exported video file.
		 */
		public string export_video (string? dest = null) throws GLib.Error;
		public abstract void generate_long_exposure (string dest_path) throws GLib.Error;
		/**
		 * Repairs the video offset metadata for the current file.
		 *
		 * This function attempts to repair the video offset metadata by either using
		 * a fallback method or the standard method to retrieve the offset. If the
		 * offset is valid (non-negative), it updates the relevant metadata tags and
		 * saves the changes to the file.
		 *
		 * @param force If true, forces the use of the fallback method to get the video offset.
		 * @param manual_video_size If greater than 0, uses this value as the video size instead of calculating it.
		 * @throws Error if there is an issue with retrieving the video offset or saving the metadata.
		 */
		public void repair_live_metadata (bool force = false, uint manual_video_size = 0) throws GLib.Error;
		public abstract void split_images_from_video (string? output_format = null, string? dest_dir = null, int threads = 0) throws GLib.Error;
		public bool export_original_metadata { get; set; }
		public GLib.FileCreateFlags file_create_flags { get; set; }
		public bool make_backup { get; set; }
	}
	/**
	 * Implementation of LivePhoto using FFmpeg.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public class LivePhotoFFmpeg : LivePhotoConv.LivePhoto {
		/**
		 * Creates a new instance of the LivePhotoFFmpeg class.
		 *
		 * The path to the **live photo** file is required.
		 * The destination directory for the converted live photo is optional.
		 * If not provided, the directory of the input file will be used.
		 * The file creation flags can be specified to control the behavior of the file creation process.
		 * By default, the destination file will be replaced if it already exists.
		 * A backup of the destination file can be created before replacing it.
		 * The original metadata of the live photo can be exported.
		 *
		 * @param filename The path to the live photo file.
		 * @param dest_dir The destination directory for the converted live photo. If not provided, the directory of the input file will be used.
		 * @throws Error if an error occurs while retrieving the offset.
		 */
		public LivePhotoFFmpeg (string filename, string? dest_dir = null) throws GLib.Error;
		public override void generate_long_exposure (string dest_path) throws GLib.Error;
		/**
		 * Split the video into images.
		 *
		 * The video of the live photo is split into images.
		 * The images are saved to the destination directory with the specified output format.
		 * If the output format is not provided, the default extension name will be used.
		 * The name of the images is generated based on the basename of the live photo.
		 *
		 * @param output_format The format of the output images. If not provided, the default extension name will be used.
		 * @param dest_dir The destination directory where the images will be saved. If not provided, the default destination directory will be used.
		 * @param threads The number of threads to run in parallel. (Ignored in this implementation)
		 *
		 * @throws Error If FFmpeg exits with an error.
		 */
		public override void split_images_from_video (string? output_format = null, string? dest_dir = null, int threads = 1) throws GLib.Error;
	}
	/**
	 * Implementation of LivePhoto using GStreamer for video processing.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	public class LivePhotoGst : LivePhotoConv.LivePhoto {
		/**
		 * Creates a new instance.
		 *
		 * @param filename The path to the live photo file
		 * @param dest_dir The destination directory for the converted live photo
		 * @throws Error If an error occurs while retrieving the offset
		 */
		public LivePhotoGst (string filename, string? dest_dir = null) throws GLib.Error;
		public override void generate_long_exposure (string dest_path) throws GLib.Error;
		/**
		 * Split the video into images.
		 *
		 * @param output_format The format of the output images
		 * @param dest_dir The destination directory for output
		 * @param threads Number of concurrent threads for processing
		 * @throws Error If an error occurs during processing
		 */
		public override void split_images_from_video (string? output_format = null, string? dest_dir = null, int threads = 0) throws GLib.Error;
	}
	/**
	 * The Reporter class provides methods to report failed commands, general messages,
	 * errors, and warnings. It supports color-coded output based on the terminal's capabilities.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	[Compact (opaque = true)]
	public class Reporter {
		/**
		 * The ProgressBar class provides a simple implementation of a progress bar that
		 * can display the progress of operations in the terminal, including counts of
		 * successes and failures.
		 */
		[Compact (opaque = true)]
		public class ProgressBar {
			/**
			 * Constructs a ProgressBar object.
			 *
			 * @param total_steps The total number of steps.
			 * @param title The title of the progress bar, defaults to "Progress".
			 * @param fill_char The character for the completed portion, defaults to '#'.
			 * @param empty_char The character for the incomplete portion, defaults to '-'.
			 */
			public ProgressBar (int total_steps, string title = "Progress", char fill_char = '#', char empty_char = '-');
			/**
			 * Prints the current progress bar to the standard error output.
			 *
			 * @param success_count The number of successes.
			 * @param failure_count The number of failures.
			 */
			public void print_progress (uint success_count, uint failure_count);
			/**
			 * Updates the progress bar state.
			 *
			 * @param success_count The number of successes.
			 * @param failure_count The number of failures.
			 * @return The current step number.
			 */
			public int update (uint success_count, uint failure_count);
			/**
			 * The current step number of the progress bar.
			 */
			public int current_step { get; set; }
			/**
			 * The total number of steps for the progress bar.
			 */
			public int total_steps { get; set; }
		}
		[CCode (has_type_id = false)]
		public enum ColorSettings {
			NEVER,
			ALWAYS,
			AUTO;
			public bool to_bool ();
		}
		[CCode (has_type_id = false)]
		public enum EscapeCode {
			RESET,
			RED,
			GREEN,
			YELLOW,
			BLUE,
			MAGENTA,
			CYAN,
			WHITE,
			BOLD,
			UNDERLINE,
			BLINK,
			DIM,
			HIDDEN,
			INVERT;
			public unowned string to_string ();
			public const string ANSI_RED;
			public const string ANSI_GREEN;
			public const string ANSI_YELLOW;
			public const string ANSI_BLUE;
			public const string ANSI_MAGENTA;
			public const string ANSI_CYAN;
			public const string ANSI_WHITE;
			public const string ANSI_BOLD;
			public const string ANSI_UNDERLINE;
			public const string ANSI_BLINK;
			public const string ANSI_DIM;
			public const string ANSI_HIDDEN;
			public const string ANSI_INVERT;
			public const string ANSI_RESET;
		}
		public static LivePhotoConv.Reporter.ColorSettings color_setting;
		public Reporter ();
		/**
		 * Clears the standard error output and prints a message.
		 *
		 * @param msg The message to be printed.
		 * @param show_progress_bar Whether to show a progress bar or not. Default is true.
		 */
		public static void clear_putserr (string msg, bool show_progress_bar = true);
		/**
		 * Reports an error with the specified error name and message. (with printf-style arguments)
		 *
		 * @param error_name The name of the error.
		 * @param msg The error message.
		 * @param ... Additional arguments for the error message.
		 */
		[PrintfFormat]
		public static void error (string error_name, string msg, ...);
		/**
		 * Reports an error with the specified error name and message. (no printf-style arguments)
		 *
		 * @param error_name The name of the error.
		 * @param msg The error message.
		 * @param ... Additional arguments for the error message.
		 */
		public static void error_puts (string error_name, string msg);
		[CCode (cname = "get_console_width")]
		public static int get_console_width ();
		/**
		 * Print an informational message.
		 *
		 * @param info_name The name of the information.
		 * @param msg The message to be printed.
		 * @param ... Additional arguments to be formatted.
		 */
		[PrintfFormat]
		public static void info (string info_name, string msg, ...);
		/**
		 * Print an informational message. (no printf-style arguments)
		 *
		 * @param info_name The name of the information.
		 * @param msg The message to be printed.
		 */
		public static void info_puts (string info_name, string msg);
		[CCode (cname = "is_a_tty")]
		public static bool isatty (int fd);
		/**
		 * Reports a message with optional color code and domain name. (with printf-style arguments)
		 *
		 * @param color_code The color code to apply to the message. Can be null.
		 * @param domain_name The domain name associated with the message.
		 * @param msg The message to report.
		 * @param args The arguments to format the message.
		 */
		public static void report (string color_code, string domain_name, string msg, va_list args);
		/**
		 * Reports a failed command with its status.
		 *
		 * @param command The command that failed.
		 * @param status The status code of the failed command.
		 */
		public static void report_failed_command (string command, int status);
		public static void report_puts (string color_code, string domain_name, string msg);
		/**
		 * Prints a warning message with the specified warning name and message. (with printf-style arguments)
		 *
		 * @param warning_name The name of the warning.
		 * @param msg The warning message.
		 * @param ... Additional arguments for the message format.
		 */
		[PrintfFormat]
		public static void warning (string warning_name, string msg, ...);
		/**
		 * Prints a warning message with the specified warning name and message. (no printf-style arguments)
		 *
		 * @param warning_name The name of the warning.
		 * @param msg The warning message.
		 * @param ... Additional arguments for the message format.
		 */
		public static void warning_puts (string warning_name, string msg);
	}
	/**
	 * Represents a class for converting a GStreamer sample to an image file.
	 */
	[CCode (cheader_filename = "livephototools.h")]
	[Compact (opaque = true)]
	public class Sample2Img {
		/**
		 * Constructor for the Sample2Img class.
		 *
		 * @param sample The Gst.Sample object to be processed.
		 * @param filename The name of the output file.
		 * @param output_format The format of the output file.
		 */
		public Sample2Img (Gst.Sample sample, string filename, string output_format);
		/**
		 * Export the sample as an image.
		 *
		 * @param metadata The metadata to be saved along with the image. (optional)
		 * @throws Error if an error occurs during the export process.
		 */
		public void export (GExiv2.Metadata? metadata = null) throws GLib.Error;
		public void save_to_stream (GLib.OutputStream stream) throws GLib.Error;
		public string filename { get; set; }
		public string output_format { get; set; }
		public Gdk.Pixbuf pixbuf { get; private set; }
	}
	[CCode (cheader_filename = "livephototools.h")]
	public errordomain ExportError {
		FFMPEG_EXIED_WITH_ERROR,
		METADATA_EXPORT_ERROR,
		FILE_PUSH_ERROR,
		GST_ERROR
	}
	[CCode (cheader_filename = "livephototools.h")]
	public errordomain NotLivePhotosError {
		OFFSET_NOT_FOUND_ERROR
	}
	[CCode (cheader_filename = "livephototools.h")]
	public const string VERSION;
}
