# Copyright (c) 2010-2025, Lawrence Livermore National Security, LLC. Produced
# at the Lawrence Livermore National Laboratory. All Rights reserved. See files
# LICENSE and NOTICE for details. LLNL-CODE-806117.
#
# This file is part of the MFEM library. For more information and source code
# availability visit https://mfem.org.
#
# MFEM is free software; you can redistribute it and/or modify it under the
# terms of the BSD-3 license. We welcome feedback and contributions, see file
# CONTRIBUTING.md for details.

# Variables corresponding to defines in config.hpp (YES, NO, or value)
MFEM_VERSION           = 40900
MFEM_VERSION_STRING    = 4.9.0
MFEM_SOURCE_DIR        = C:/W/B/src/mfem-4.9
MFEM_INSTALL_DIR       = /clangarm64
MFEM_GIT_STRING        = (unknown)
MFEM_USE_MPI           = NO
MFEM_USE_METIS         = YES
MFEM_USE_METIS_5       = YES
MFEM_USE_DOUBLE        = YES
MFEM_USE_SINGLE        = NO
MFEM_DEBUG             = NO
MFEM_USE_EXCEPTIONS    = NO
MFEM_USE_ZLIB          = YES
MFEM_USE_LIBUNWIND     = NO
MFEM_USE_LAPACK        = YES
MFEM_THREAD_SAFE       = NO
MFEM_USE_LEGACY_OPENMP = NO
MFEM_USE_OPENMP        = YES
MFEM_USE_MEMALLOC      = YES
MFEM_TIMER_TYPE        = 3
MFEM_USE_SUNDIALS      = NO
MFEM_USE_SUITESPARSE   = YES
MFEM_USE_SUPERLU       = NO
MFEM_USE_SUPERLU5      = NO
MFEM_USE_MUMPS         = NO
MFEM_USE_STRUMPACK     = NO
MFEM_USE_GINKGO        = YES
MFEM_USE_AMGX          = NO
MFEM_USE_MAGMA         = NO
MFEM_USE_GNUTLS        = NO
MFEM_USE_HDF5          = NO
MFEM_USE_NETCDF        = YES
MFEM_USE_PETSC         = NO
MFEM_USE_SLEPC         = NO
MFEM_USE_MPFR          = YES
MFEM_USE_SIDRE         = NO
MFEM_USE_FMS           = NO
MFEM_USE_CONDUIT       = NO
MFEM_USE_PUMI          = NO
MFEM_USE_HIOP          = NO
MFEM_USE_GSLIB         = NO
MFEM_USE_CUDA          = NO
MFEM_USE_HIP           = NO
MFEM_USE_RAJA          = NO
MFEM_USE_OCCA          = NO
MFEM_USE_CEED          = NO
MFEM_USE_CALIPER       = NO
MFEM_USE_UMPIRE        = NO
MFEM_USE_SIMD          = NO
MFEM_USE_ADIOS2        = NO
MFEM_USE_MKL_CPARDISO  = NO
MFEM_USE_MKL_PARDISO   = NO
MFEM_USE_MOONOLITH     = NO
MFEM_USE_ADFORWARD     = NO
MFEM_USE_CODIPACK      = NO
MFEM_USE_BENCHMARK     = NO
MFEM_USE_PARELAG       = NO
MFEM_USE_TRIBOL        = NO
MFEM_USE_ENZYME        = NO

# Compiler, compile options, and link options
MFEM_CXX       = C:/M/msys64/clangarm64/bin/clang++.exe
MFEM_HOST_CXX  = C:/M/msys64/clangarm64/bin/clang++.exe
MFEM_CPPFLAGS  = 
MFEM_CXXFLAGS  = -std=c++17 -O3 -DNDEBUG -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -fopenmp=libomp
MFEM_TPLFLAGS  =  -IC:/M/msys64/clangarm64/include -IC:/M/msys64/clangarm64/include/suitesparse
MFEM_INCFLAGS  = -I$(MFEM_INC_DIR) $(MFEM_TPLFLAGS)
MFEM_PICFLAG   = 
MFEM_FLAGS     = $(MFEM_CPPFLAGS) $(MFEM_CXXFLAGS) $(MFEM_INCFLAGS)
MFEM_EXT_LIBS  =  C:/M/msys64/clangarm64/lib/libomp.dll.a C:/M/msys64/clangarm64/lib/libumfpack.dll.a C:/M/msys64/clangarm64/lib/libklu.dll.a C:/M/msys64/clangarm64/lib/libamd.dll.a C:/M/msys64/clangarm64/lib/libbtf.dll.a C:/M/msys64/clangarm64/lib/libcholmod.dll.a C:/M/msys64/clangarm64/lib/libcolamd.dll.a C:/M/msys64/clangarm64/lib/libcamd.dll.a C:/M/msys64/clangarm64/lib/libccolamd.dll.a C:/M/msys64/clangarm64/lib/libsuitesparseconfig.dll.a C:/M/msys64/clangarm64/lib/libopenblas.dll.a C:/M/msys64/clangarm64/lib/libmetis.dll.a C:/M/msys64/clangarm64/lib/libnetcdf.dll.a C:/M/msys64/clangarm64/lib/libhdf5_hl.dll.a C:/M/msys64/clangarm64/lib/libhdf5.dll.a mpfr C:/M/msys64/clangarm64/lib/libz.dll.a
MFEM_LIBS      = -Wl,-rpath,$(MFEM_LIB_DIR) -L$(MFEM_LIB_DIR) -lmfem $(MFEM_EXT_LIBS)
MFEM_LIB_FILE  = $(MFEM_LIB_DIR)/libmfem.dll.4.9.0
MFEM_STATIC    = NO
MFEM_SHARED    = YES
MFEM_BUILD_TAG = Windows-10.0.26200
MFEM_PREFIX    = /clangarm64
MFEM_INC_DIR   = /clangarm64/include
MFEM_LIB_DIR   = /clangarm64/lib
MFEM_XLINKER   = -Xlinker; 

# Location of test.mk
MFEM_TEST_MK = /clangarm64/share/mfem/test.mk

# Command used to launch MPI jobs
MFEM_MPIEXEC    = mpirun
MFEM_MPIEXEC_NP = -np
MFEM_MPI_NP     = 4

# The NVCC compiler cannot link with -x=cu
MFEM_LINK_FLAGS := $(filter-out -x=cu -xcuda -xhip, $(MFEM_FLAGS))

# Optional extra configuration

