%define OT_SpectralModel_doc
"Spectral density model.

Notes
-----
We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
:math:`\\vect{t}\\in \\cD` is a multivariate index and
:math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
index :math:`\\vect{t} \\in \\cD` defined by
:math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
:math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
:math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
:math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

If the process is a second order process, zero-mean and weakly **stationary**, we define its *bilateral spectral density function*
:math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` with:

- :math:`\\cH^+(d) \\in \\cM^+(d)(\\Cset)` is the set of *d-dimensional* positive hermitian matrices

Using the *stationary covariance function* :math:`C^{stat}` with :math:`C^{stat} : \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` and the Fourier transform, the spectral density writes:


.. math::

   \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\int_{\\Rset^n} \\exp\\left(-2i \\pi <\\vect{f}, \\vect{\\tau}>\\right) C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}

A SpectralModel object can be created only through its derived classes:
:class:`~openturns.CauchyModel`"

%enddef
%feature("docstring") OT::SpectralModelImplementation
OT_SpectralModel_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_computeStandardRepresentative_doc
"Compute the standard representant of the spectral density function.

Parameters
----------
tau : float
    Frequency value.

Returns
-------
rho : Complex
     Standard representant factor of the spectral density function.

Notes
-----
According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

Thus,

.. math::

  \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
:math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`"
%enddef
%feature("docstring") OT::SpectralModelImplementation::computeStandardRepresentative
OT_SpectralModel_computeStandardRepresentative_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_draw_doc
"Draw a specific component of the spectral density function.

Parameters
----------
rowIndex : int, :math:`0 \\leq rowIndex < dimension`
    The row index of the component to draw. Default value is 0.
columnIndex: int, :math:`0 \\leq columnIndex < dimension`
    The column index of the component to draw. Default value is 0.
minimumFrequency : float
    The lower bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMinimumFrequency* in :class:`~openturns.ResourceMap`.
maximumFrequency : float
    The upper bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMaximumFrequency* in :class:`~openturns.ResourceMap`.
frequencyNumber : int, :math:`pointNumber \\geq 2`
    The discretization of the frequency range :math:`[minimumFrequency, maximumFrequency]` over which the model is plotted. Default value is *SpectralModel-DefaultFrequencyNumber* in  class:`~openturns.ResourceMap`.
module : bool
    Flag to tell if module has to be drawn (*True*) or if it is
    the argument to be drawn (*False*).
    Default value is *True*.

Returns
-------
graph : Graph
     Graphic of the specified component
"
%enddef
%feature("docstring") OT::SpectralModelImplementation::draw
OT_SpectralModel_draw_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_getAmplitude_doc
"Get the amplitude parameter of the spectral density function.

Returns
-------
amplitude : :class:`~openturns.Point`
    The used amplitude parameter."
%enddef
%feature("docstring") OT::SpectralModelImplementation::getAmplitude
OT_SpectralModel_getAmplitude_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_getOutputDimension_doc
"Get the dimension of the *SpectralModel*.

Returns
-------
dimension : int
    Dimension of the *SpectralModel*."
%enddef
%feature("docstring") OT::SpectralModelImplementation::getOutputDimension
OT_SpectralModel_getOutputDimension_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_getScale_doc
"Get the scale parameter of the spectral density function.

Returns
-------
scale : :class:`~openturns.Point`
    The used scale parameter."
%enddef
%feature("docstring") OT::SpectralModelImplementation::getScale
OT_SpectralModel_getScale_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_getOutputCorrelation_doc
"Get the spatial correlation matrix of the spectral density function.

Returns
-------
spatialCorrelation : :class:`~openturns.CorrelationMatrix`
    Correlation matrix :math:`\\mat{R} \\in \\mathcal{M}_{dimension \\times dimension}([-1, 1])`."
%enddef
%feature("docstring") OT::SpectralModelImplementation::getOutputCorrelation
OT_SpectralModel_getOutputCorrelation_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_getInputDimension_doc
"Get the input dimension of the spectral density function.

Returns
-------
inputDimension : int
    SpatialDimension of the *SpectralModel*."

%enddef
%feature("docstring") OT::SpectralModelImplementation::getInputDimension
OT_SpectralModel_getInputDimension_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_setAmplitude_doc
"Set the amplitude parameter of the spectral density function.

Parameters
----------
amplitude : :class:`~openturns.Point`
    The amplitude parameter to be used in the spectral density function."
%enddef
%feature("docstring") OT::SpectralModelImplementation::setAmplitude
OT_SpectralModel_setAmplitude_doc

// ---------------------------------------------------------------------


%define OT_SpectralModel_setScale_doc
"Set the scale parameter of the spectral density function.

Parameters
----------
scale : :class:`~openturns.Point`
    The scale parameter to be used in the spectral density function.
    It should be of size dimension."
%enddef
%feature("docstring") OT::SpectralModelImplementation::setScale
OT_SpectralModel_setScale_doc

// ---------------------------------------------------------------------

%define OT_SpectralModel_operator_doc
"Evaluate the spectral density function for a specific frequency.

Parameters
----------
f : float
    Frequency value.

Returns
-------
spd : HermitianMatrixs
    The evaluation of spectral density function at frequency f."

%enddef
%feature("docstring") OT::SpectralModelImplementation::operator()
OT_SpectralModel_operator_doc
