﻿!mod$ v1 sum:45fe7f5a8b9c5448
!need$ cb61175df4cb3924 n io_global
!need$ 2ff0996d4eeece74 n constants
!need$ f1b4423f2906c0b3 n kinds
module cell_base
use kinds,only:dp
use constants,only:pi
use constants,only:bohr_radius_angs
use io_global,only:stdout
integer(4)::ibrav
real(8)::celldm(1_8:6_8)
real(8)::a
real(8)::b
real(8)::c
real(8)::cosab
real(8)::cosac
real(8)::cosbc
character(80_4,1)::cell_units
real(8)::alat
real(8)::omega
real(8)::tpiba
real(8)::tpiba2
real(8)::at(1_8:3_8,1_8:3_8)
intrinsic::reshape
real(8)::bg(1_8:3_8,1_8:3_8)
real(8)::ref_tpiba2
real(8)::ref_at(1_8:3_8,1_8:3_8)
real(8)::ref_bg(1_8:3_8,1_8:3_8)
real(8)::init_tpiba2
type::boxdimensions
real(8)::a(1_8:3_8,1_8:3_8)
real(8)::m1(1_8:3_8,1_8:3_8)
real(8)::omega
real(8)::g(1_8:3_8,1_8:3_8)
real(8)::gvel(1_8:3_8,1_8:3_8)
real(8)::pail(1_8:3_8,1_8:3_8)
real(8)::paiu(1_8:3_8,1_8:3_8)
real(8)::hmat(1_8:3_8,1_8:3_8)
real(8)::hvel(1_8:3_8,1_8:3_8)
real(8)::hinv(1_8:3_8,1_8:3_8)
real(8)::deth
integer(4)::perd(1_8:3_8)
end type
real(8)::h(1_8:3_8,1_8:3_8)
real(8)::ainv(1_8:3_8,1_8:3_8)
real(8)::hold(1_8:3_8,1_8:3_8)
real(8)::hnew(1_8:3_8,1_8:3_8)
real(8)::velh(1_8:3_8,1_8:3_8)
real(8)::deth
integer(4)::iforceh(1_8:3_8,1_8:3_8)
logical(4)::enforce_ibrav
logical(4)::fix_volume
logical(4)::fix_area
logical(4)::isotropic
real(8)::wmass
real(8)::press
real(8)::frich
real(8)::greash
logical(4)::tcell_base_init
interface cell_init
procedure::cell_init_ht
procedure::cell_init_a
end interface
interface pbcs
procedure::pbcs_components
procedure::pbcs_vectors
end interface
interface s_to_r
procedure::s_to_r1
procedure::s_to_r1b
procedure::s_to_r3
end interface
interface r_to_s
procedure::r_to_s1
procedure::r_to_s1b
procedure::r_to_s3
end interface
contains
subroutine cell_base_init(ibrav_,celldm_,a_,b_,c_,cosab_,cosac_,cosbc_,trd_ht,rd_ht,cell_units_)
integer(4),intent(in)::ibrav_
real(8),intent(in)::celldm_(1_8:6_8)
real(8),intent(in)::a_
real(8),intent(in)::b_
real(8),intent(in)::c_
real(8),intent(in)::cosab_
real(8),intent(in)::cosac_
real(8),intent(in)::cosbc_
logical(4),intent(in)::trd_ht
real(8),intent(in)::rd_ht(1_8:3_8,1_8:3_8)
character(*,1),intent(in)::cell_units_
end
subroutine ref_cell_base_init(ref_alat,rd_ref_ht,ref_cell_units)
real(8),intent(inout)::ref_alat
real(8),intent(in)::rd_ref_ht(1_8:3_8,1_8:3_8)
character(*,1),intent(in)::ref_cell_units
end
subroutine cell_init_ht(what,box,hval)
character(1_8,1),intent(in)::what
type(boxdimensions)::box
real(8),intent(in)::hval(1_8:3_8,1_8:3_8)
end
subroutine cell_init_a(alat,at,box)
real(8),intent(in)::alat
real(8),intent(in)::at(1_8:3_8,1_8:3_8)
type(boxdimensions)::box
end
subroutine r_to_s1(r,s,box)
real(8),intent(in)::r(1_8:3_8)
real(8),intent(out)::s(1_8:3_8)
type(boxdimensions),intent(in)::box
end
subroutine r_to_s3(r,s,nat,hinv)
real(8),intent(in)::r(:,:)
real(8),intent(out)::s(:,:)
integer(4),intent(in)::nat
real(8),intent(in)::hinv(:,:)
end
subroutine r_to_s1b(r,s,hinv)
real(8),intent(in)::r(:)
real(8),intent(out)::s(:)
real(8),intent(in)::hinv(:,:)
end
subroutine s_to_r1(s,r,box)
real(8),intent(in)::s(1_8:3_8)
real(8),intent(out)::r(1_8:3_8)
type(boxdimensions),intent(in)::box
end
subroutine s_to_r1b(s,r,h)
real(8),intent(in)::s(1_8:3_8)
real(8),intent(out)::r(1_8:3_8)
real(8),intent(in)::h(:,:)
end
subroutine s_to_r3(s,r,nat,h)
real(8),intent(in)::s(:,:)
real(8),intent(out)::r(:,:)
integer(4),intent(in)::nat
real(8),intent(in)::h(:,:)
end
subroutine gethinv(box)
type(boxdimensions),intent(inout)::box
end
function get_volume(hmat)
real(8)::hmat(1_8:3_8,1_8:3_8)
real(8)::get_volume
end
function pbc(rin,box,nl) result(rout)
real(8)::rin(1_8:3_8)
type(boxdimensions)::box
integer(4),optional::nl(1_8:3_8)
real(8)::rout(1_8:3_8)
end
subroutine get_cell_param(box,cell,ang)
type(boxdimensions),intent(in)::box
real(8),intent(out)::cell(1_8:3_8)
real(8),intent(out),optional::ang(1_8:3_8)
end
subroutine pbcs_components(x1,y1,z1,x2,y2,z2,m)
real(8),intent(in)::x1
real(8),intent(in)::y1
real(8),intent(in)::z1
real(8),intent(out)::x2
real(8),intent(out)::y2
real(8),intent(out)::z2
integer(4),intent(in)::m
end
subroutine pbcs_vectors(v,w,m)
real(8),intent(in)::v(1_8:3_8)
real(8),intent(out)::w(1_8:3_8)
integer(4),intent(in)::m
end
subroutine set_h_ainv()
end
subroutine cell_dyn_init(trd_ht,rd_ht,wc_,total_ions_mass,press_,frich_,greash_,cell_dofree)
logical(4),intent(in)::trd_ht
real(8),intent(in)::rd_ht(1_8:3_8,1_8:3_8)
real(8),intent(in)::wc_
real(8),intent(in)::total_ions_mass
real(8),intent(in)::press_
real(8),intent(in)::frich_
real(8),intent(in)::greash_
character(*,1),intent(in)::cell_dofree
end
subroutine init_dofree(cell_dofree)
character(*,1),intent(in)::cell_dofree
end
subroutine cell_base_reinit(ht)
real(8),intent(in)::ht(1_8:3_8,1_8:3_8)
end
subroutine cell_steepest(hnew,h,delt,iforceh,fcell)
real(8),intent(out)::hnew(1_8:3_8,1_8:3_8)
real(8),intent(in)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::delt
integer(4),intent(in)::iforceh(1_8:3_8,1_8:3_8)
real(8),intent(in)::fcell(1_8:3_8,1_8:3_8)
end
subroutine cell_verlet(hnew,h,hold,delt,iforceh,fcell,frich,tnoseh,hnos)
real(8),intent(out)::hnew(1_8:3_8,1_8:3_8)
real(8),intent(in)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::hold(1_8:3_8,1_8:3_8)
real(8),intent(in)::delt
integer(4),intent(in)::iforceh(1_8:3_8,1_8:3_8)
real(8),intent(in)::fcell(1_8:3_8,1_8:3_8)
real(8),intent(in)::frich
logical(4),intent(in)::tnoseh
real(8),intent(in)::hnos(1_8:3_8,1_8:3_8)
end
subroutine cell_hmove(h,hold,delt,iforceh,fcell)
real(8),intent(out)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::hold(1_8:3_8,1_8:3_8)
real(8),intent(in)::delt
integer(4),intent(in)::iforceh(1_8:3_8,1_8:3_8)
real(8),intent(in)::fcell(1_8:3_8,1_8:3_8)
end
subroutine cell_force(fcell,ainv,stress,omega,press,wmassin)
real(8),intent(out)::fcell(1_8:3_8,1_8:3_8)
real(8),intent(in)::ainv(1_8:3_8,1_8:3_8)
real(8),intent(in)::stress(1_8:3_8,1_8:3_8)
real(8),intent(in)::omega
real(8),intent(in)::press
real(8),intent(in),optional::wmassin
end
subroutine cell_move(hnew,h,hold,delt,iforceh,fcell,frich,tnoseh,vnhh,velh,tsdc)
real(8),intent(out)::hnew(1_8:3_8,1_8:3_8)
real(8),intent(in)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::hold(1_8:3_8,1_8:3_8)
real(8),intent(in)::delt
integer(4),intent(in)::iforceh(1_8:3_8,1_8:3_8)
real(8),intent(in)::fcell(1_8:3_8,1_8:3_8)
real(8),intent(in)::frich
logical(4),intent(in)::tnoseh
real(8),intent(in)::vnhh(1_8:3_8,1_8:3_8)
real(8),intent(in)::velh(1_8:3_8,1_8:3_8)
logical(4),intent(in)::tsdc
end
subroutine cell_gamma(hgamma,ainv,h,velh)
real(8),intent(out)::hgamma(1_8:3_8,1_8:3_8)
real(8),intent(in)::ainv(1_8:3_8,1_8:3_8)
real(8),intent(in)::h(1_8:3_8,1_8:3_8)
real(8),intent(in)::velh(1_8:3_8,1_8:3_8)
end
subroutine cell_update_vel(htp,ht0,htm,delt,velh)
type(boxdimensions)::htp
type(boxdimensions)::ht0
type(boxdimensions)::htm
real(8),intent(in)::delt
real(8),intent(out)::velh(1_8:3_8,1_8:3_8)
end
subroutine cell_kinene(ekinh,temphh,velh)
real(8),intent(out)::ekinh
real(8),intent(out)::temphh(1_8:3_8,1_8:3_8)
real(8),intent(in)::velh(1_8:3_8,1_8:3_8)
end
function cell_alat()
real(8)::cell_alat
end
end
