﻿!mod$ v1 sum:f0505fd8fe6aa082
!need$ 63e233f05715b372 n paw_variables
!need$ a9893a50e0841658 n mp_images
!need$ 9c3779872f673231 n mp
!need$ f1b4423f2906c0b3 n kinds
module paw_onecenter
use kinds,only:dp
use paw_variables,only:paw_info
use paw_variables,only:rad
use paw_variables,only:radial_grad_style
use paw_variables,only:vs_rad
use mp_images,only:nproc_image
use mp_images,only:me_image
use mp_images,only:intra_image_comm
use mp,only:mp_sum
use mp,only:mp$mp$mp_sum_r1=>mp_sum_r1
use mp,only:mp$mp$mp_sum_r4d=>mp_sum_r4d
use mp,only:mp$mp$mp_sum_rt=>mp_sum_rt
private::dp
private::paw_info
private::rad
private::radial_grad_style
private::vs_rad
private::nproc_image
private::me_image
private::intra_image_comm
private::mp_sum
private::mp$mp$mp_sum_r1
private::mp$mp$mp_sum_r4d
private::mp$mp$mp_sum_rt
integer(4),private,save::paw_comm
integer(4),private,save::me_paw
integer(4),private,save::nproc_paw
integer(4),private,save::nx_loc
integer(4),private,save::ix_s
integer(4),private,save::ix_e
real(8),allocatable,private::msmall_lm(:,:,:)
real(8),allocatable,private::g_lm(:,:,:)
logical(4),private::with_small_so
logical(4),parameter,private::timing=.false._4
procedure(integer(4)),private::ldim_block
procedure(integer(4)),private::gind_block
private::paw_xc_potential
private::paw_gcxc_potential
private::paw_divergence
private::paw_gradient
private::paw_lm2rad
private::paw_rad2lm
private::paw_rad2lm3
private::paw_dxc_potential
private::paw_dgcxc_potential
private::compute_rho_spin_lm
private::compute_pot_nonc
private::compute_drho_spin_lm
private::compute_dpot_nonc
private::add_small_mag
private::compute_g
contains
subroutine paw_potential(becsum,d,energy,e_cmp)
use uspp_param,only:nhm
use ions_base,only:nat
use lsda_mod,only:nspin
real(8),intent(in)::becsum(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out)::d(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out),optional::energy
real(8),intent(out),optional::e_cmp(1_8:int(nat,kind=8),1_8:2_8,1_8:2_8)
end
function paw_ddot(bec1,bec2)
use uspp_param,only:nhm
use ions_base,only:nat
use lsda_mod,only:nspin
real(8),intent(in)::bec1(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::bec2(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin,kind=8))
real(8)::paw_ddot
end
subroutine paw_xc_potential(i,rho_lm,rho_core,v_lm,energy)
use lsda_mod,only:nspin
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::rho_core(1_8:int(i%m,kind=8))
real(8),intent(out)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out),optional::energy
end
subroutine paw_gcxc_potential(i,rho_lm,rho_core,v_lm,energy)
use lsda_mod,only:nspin
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::rho_core(1_8:int(i%m,kind=8))
real(8),intent(inout)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(inout),optional::energy
end
subroutine paw_divergence(i,f_lm,div_f_lm,lmaxq_in,lmaxq_out)
use noncollin_module,only:nspin_gga
type(paw_info),intent(in)::i
integer(4),intent(in)::lmaxq_in
real(8),intent(in)::f_lm(1_8:int(i%m,kind=8),1_8:3_8,1_8:int(lmaxq_in**2_4,kind=8),1_8:int(nspin_gga,kind=8))
integer(4),intent(in)::lmaxq_out
real(8),intent(out)::div_f_lm(1_8:int(i%m,kind=8),1_8:int(lmaxq_out**2_4,kind=8),1_8:int(nspin_gga,kind=8))
end
subroutine paw_gradient(i,rho_lm,rho_rad,rho_core,grho_rad,grho_rad2)
use noncollin_module,only:nspin_gga
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(in)::rho_rad(1_8:int(i%m*nx_loc,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(in)::rho_core(1_8:int(i%m,kind=8))
real(8),intent(out),optional::grho_rad(1_8:int(i%m*nx_loc,kind=8),1_8:3_8,1_8:int(nspin_gga,kind=8))
real(8),intent(out),optional::grho_rad2(1_8:int(i%m*nx_loc,kind=8),1_8:int(nspin_gga,kind=8))
end
subroutine paw_h_potential(i,rho_lm,v_lm,energy)
use lsda_mod,only:nspin
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8))
real(8),intent(out),optional::energy
end
subroutine paw_rho_lm(i,becsum,pfunc,rho_lm,aug)
use uspp_param,only:nhm
use ions_base,only:nat
use noncollin_module,only:nspin_mag
use uspp_param,only:upf
type(paw_info),intent(in)::i
real(8),intent(in)::becsum(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(in)::pfunc(1_8:int(i%m,kind=8),1_8:int(i%b,kind=8),1_8:int(i%b,kind=8))
real(8),intent(out)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(in),optional::aug(1_8:int(i%m,kind=8),1_8:int((i%b*(i%b+1_4))/2_4,kind=8),0_8:int(2_4*upf(int(i%t,kind=8))%lmax,kind=8))
end
subroutine paw_lm2rad(i,f_lm,f_rad,nspin)
type(paw_info),intent(in)::i
integer(4),intent(in)::nspin
real(8),intent(in)::f_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out)::f_rad(1_8:int(i%m*nx_loc,kind=8),1_8:int(nspin,kind=8))
end
subroutine paw_rad2lm(i,f_rad,f_lm,lmax_loc,nspin)
type(paw_info),intent(in)::i
integer(4),intent(in)::nspin
real(8),intent(in)::f_rad(1_8:int(i%m,kind=8),1_8:int(nx_loc,kind=8),1_8:int(nspin,kind=8))
integer(4),intent(in)::lmax_loc
real(8),intent(out)::f_lm(1_8:int(i%m,kind=8),1_8:int(lmax_loc**2_4,kind=8),1_8:int(nspin,kind=8))
end
subroutine paw_rad2lm3(i,f_rad,f_lm,lmax_loc,nspin)
type(paw_info),intent(in)::i
integer(4),intent(in)::nspin
real(8),intent(in)::f_rad(1_8:int(i%m,kind=8),1_8:3_8,1_8:int(nx_loc,kind=8),1_8:int(nspin,kind=8))
integer(4),intent(in)::lmax_loc
real(8),intent(out)::f_lm(1_8:int(i%m,kind=8),1_8:3_8,1_8:int(lmax_loc**2_4,kind=8),1_8:int(nspin,kind=8))
end
subroutine paw_dpotential(dbecsum,becsum,int3,npe)
use uspp_param,only:nhm
use ions_base,only:nat
use noncollin_module,only:nspin_mag
integer(4),intent(in)::npe
complex(8),intent(in)::dbecsum(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(npe,kind=8))
real(8),intent(in)::becsum(1_8:int(nhm*(nhm+1_4)/2_4,kind=8),1_8:int(nat,kind=8),1_8:int(nspin_mag,kind=8))
complex(8),intent(out)::int3(1_8:int(nhm,kind=8),1_8:int(nhm,kind=8),1_8:int(nat,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(npe,kind=8))
end
subroutine paw_dxc_potential(i,drho_lm,rho_lm,rho_core,v_lm)
use noncollin_module,only:nspin_mag
type(paw_info),intent(in)::i
real(8),intent(in)::drho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(in)::rho_core(1_8:int(i%m,kind=8))
real(8),intent(out)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
end
subroutine paw_dgcxc_potential(i,rho_lm,rho_core,drho_lm,v_lm)
use noncollin_module,only:nspin_mag
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(in)::rho_core(1_8:int(i%m,kind=8))
real(8),intent(in)::drho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(inout)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_mag,kind=8))
end
subroutine compute_rho_spin_lm(i,rho_lm,rhoout_lm,segni_rad)
use lsda_mod,only:nspin
use noncollin_module,only:nspin_gga
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out)::rhoout_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(out)::segni_rad(1_8:int(i%m,kind=8),1_8:int(rad(int(i%t,kind=8))%nx,kind=8))
end
subroutine compute_pot_nonc(i,vout_lm,v_lm,segni_rad,rho_lm)
use noncollin_module,only:nspin_gga
use lsda_mod,only:nspin
type(paw_info),intent(in)::i
real(8),intent(in)::vout_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(inout)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::segni_rad(1_8:int(i%m,kind=8),1_8:int(rad(int(i%t,kind=8))%nx,kind=8))
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
end
subroutine compute_drho_spin_lm(i,rho_lm,drho_lm,rhoout_lm,drhoout_lm,segni_rad)
use lsda_mod,only:nspin
use noncollin_module,only:nspin_gga
type(paw_info),intent(in)::i
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::drho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(out)::rhoout_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(out)::drhoout_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(out)::segni_rad(1_8:int(i%m,kind=8),1_8:int(rad(int(i%t,kind=8))%nx,kind=8))
end
subroutine compute_dpot_nonc(i,vout_lm,v_lm,segni_rad,rho_lm,drho_lm)
use noncollin_module,only:nspin_gga
use lsda_mod,only:nspin
type(paw_info),intent(in)::i
real(8),intent(in)::vout_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin_gga,kind=8))
real(8),intent(inout)::v_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::segni_rad(1_8:int(i%m,kind=8),1_8:int(rad(int(i%t,kind=8))%nx,kind=8))
real(8),intent(in)::rho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::drho_lm(1_8:int(i%m,kind=8),1_8:int(i%l**2_4,kind=8),1_8:int(nspin,kind=8))
end
subroutine add_small_mag(i,rho_rad)
use noncollin_module,only:nspin_mag
type(paw_info),intent(in)::i
real(8),intent(inout)::rho_rad(1_8:int(i%m*nx_loc,kind=8),1_8:int(nspin_mag,kind=8))
end
subroutine compute_g(i,v_rad,g_rad)
use noncollin_module,only:nspin_mag
type(paw_info),intent(in)::i
real(8),intent(in)::v_rad(1_8:int(i%m,kind=8),1_8:int(nx_loc,kind=8),1_8:int(nspin_mag,kind=8))
real(8),intent(inout)::g_rad(1_8:int(i%m,kind=8),1_8:int(nx_loc,kind=8),1_8:int(nspin_mag,kind=8))
end
end
