﻿!mod$ v1 sum:53a0161af3d7b7e0
!need$ 3993c955ea946ce5 n mctc_ncoord
!need$ 518a13cedaeb9881 n tblite_coulomb_cache
!need$ f19d606d1dded2bc n tblite_coulomb_ewald
!need$ 4b1b21389a985be9 n tblite_coulomb_type
!need$ a53d5fe901b7082c n tblite_cutoff
!need$ 4ba9281d3cab36d6 n tblite_scf_potential
!need$ 86e45708dff95640 n tblite_wavefunction_type
!need$ d19067f21a7bc614 n tblite_wignerseitz
!need$ 464b363a1a7599ec n tblite_blas_level2
!need$ d6b91e53bed6f38f n mctc_io_constants
!need$ c301c17a17af4c8a n mctc_io_math
!need$ 35a78865758f9288 n tblite_container_cache
!need$ 1f6fcd35e7441abe n mctc_io
!need$ ae78003ee30bd742 n mctc_env
!need$ 976c2c61ee34ace3 n tblite_blas
module tblite_coulomb_multipole
use mctc_env,only:error_type
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_math,only:matdet_3x3
use mctc_io_math,only:matinv_3x3
use mctc_io_constants,only:pi
use mctc_ncoord,only:new_ncoord
use mctc_ncoord,only:ncoord_type
use mctc_ncoord,only:cn_count
use tblite_blas,only:dot
use tblite_blas,only:gemv
use tblite_blas,only:symv
use tblite_blas,only:gemm
use tblite_container_cache,only:container_cache
use tblite_coulomb_cache,only:coulomb_cache
use tblite_coulomb_ewald,only:get_dir_cutoff
use tblite_coulomb_ewald,only:get_rec_cutoff
use tblite_coulomb_type,only:coulomb_type
use tblite_cutoff,only:get_lattice_points
use tblite_scf_potential,only:potential_type
use tblite_wavefunction_type,only:wavefunction_type
use tblite_wignerseitz,only:wignerseitz_cell
use tblite_blas_level2,only:tblite_blas$tblite_blas_level2$wrap_dgemv=>wrap_dgemv
use tblite_blas_level2,only:tblite_blas$tblite_blas_level2$wrap_dgemv312=>wrap_dgemv312
use tblite_blas_level2,only:tblite_blas$tblite_blas_level2$wrap_dgemv321=>wrap_dgemv321
use tblite_blas_level2,only:tblite_blas$tblite_blas_level2$wrap_dgemv422=>wrap_dgemv422
use tblite_cutoff,only:tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff=>get_lattice_points_cutoff
private::error_type
private::wp
private::structure_type
private::matdet_3x3
private::matinv_3x3
private::pi
private::new_ncoord
private::ncoord_type
private::cn_count
private::dot
private::gemv
private::symv
private::gemm
private::container_cache
private::coulomb_cache
private::get_dir_cutoff
private::get_rec_cutoff
private::coulomb_type
private::get_lattice_points
private::potential_type
private::wavefunction_type
private::wignerseitz_cell
private::tblite_blas$tblite_blas_level2$wrap_dgemv
private::tblite_blas$tblite_blas_level2$wrap_dgemv312
private::tblite_blas$tblite_blas_level2$wrap_dgemv321
private::tblite_blas$tblite_blas_level2$wrap_dgemv422
private::tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff
type,extends(coulomb_type)::damped_multipole
real(8)::kdmp3=0._8
real(8)::kdmp5=0._8
real(8),allocatable::dkernel(:)
real(8),allocatable::qkernel(:)
real(8)::shift=0._8
real(8)::kexp=0._8
real(8)::rmax=0._8
real(8),allocatable::rad(:)
real(8),allocatable::valence_cn(:)
class(ncoord_type),allocatable::ncoord
contains
procedure::update
procedure::variable_info
procedure::get_energy
procedure::get_potential
procedure::get_gradient
procedure::get_energy_axc
procedure::get_energy_aes
end type
real(8),parameter,private::unity(1_8:3_8,1_8:3_8)=reshape([REAL(8)::1._8,0._8,0._8,0._8,1._8,0._8,0._8,0._8,1._8],shape=[3,3])
intrinsic::reshape
private::reshape
real(8),parameter,private::twopi=6.28318530717958623199592693708837032318115234375_8
real(8),parameter,private::sqrtpi=1.772453850905515881919427556567825376987457275390625_8
intrinsic::sqrt
private::sqrt
real(8),parameter,private::eps=1.490116119384765625e-8_8
intrinsic::epsilon
private::epsilon
real(8),parameter,private::conv=1.490116119384765625e-6_8
character(*,1),parameter,private::label="anisotropic electrostatics"
private::update
private::get_energy
private::get_energy_aes
private::get_kernel_energy
private::get_potential
private::get_kernel_potential
private::get_gradient
private::get_mrad
private::get_dir_trans
private::get_rec_trans
private::get_multipole_matrix
private::get_multipole_matrix_0d
private::get_multipole_matrix_3d
private::get_amat_sdq_rec_3d
private::get_amat_sdq_dir_3d
private::get_multipole_gradient
private::get_multipole_gradient_0d
private::get_multipole_gradient_3d
private::get_damat_sdq_rec_3d
private::get_damat_sdq_dir_3d
private::variable_info
private::taint
private::view
private::get_energy_axc
contains
subroutine new_damped_multipole(self,mol,kdmp3,kdmp5,dkernel,qkernel,shift,kexp,rmax,rad,vcn,error)
type(damped_multipole),intent(out)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),intent(in)::dkernel(:)
real(8),intent(in)::qkernel(:)
real(8),intent(in)::shift
real(8),intent(in)::kexp
real(8),intent(in)::rmax
real(8),intent(in)::rad(:)
real(8),intent(in)::vcn(:)
type(error_type),allocatable,intent(out)::error
end
subroutine update(self,mol,cache)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
end
subroutine get_energy(self,mol,cache,wfn,energies)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
real(8),intent(inout)::energies(:)
end
subroutine get_energy_aes(self,mol,cache,wfn,energies)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
real(8),intent(inout)::energies(:)
end
subroutine get_kernel_energy(mol,kernel,mpat,energies)
type(structure_type),intent(in)::mol
real(8),intent(in)::kernel(:)
real(8),intent(in)::mpat(:,:)
real(8),intent(inout)::energies(:)
end
subroutine get_potential(self,mol,cache,wfn,pot)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
type(potential_type),intent(inout)::pot
end
subroutine get_kernel_potential(mol,kernel,mpat,vm)
type(structure_type),intent(in)::mol
real(8),intent(in)::kernel(:)
real(8),intent(in)::mpat(:,:)
real(8),intent(inout)::vm(:,:)
end
subroutine get_gradient(self,mol,cache,wfn,gradient,sigma)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(container_cache),intent(inout)::cache
type(wavefunction_type),intent(in)::wfn
real(8),contiguous,intent(inout)::gradient(:,:)
real(8),contiguous,intent(inout)::sigma(:,:)
end
subroutine get_mrad(mol,shift,kexp,rmax,rad,valence_cn,cn,mrad,dmrdcn)
type(structure_type),intent(in)::mol
real(8),intent(in)::shift
real(8),intent(in)::kexp
real(8),intent(in)::rmax
real(8),intent(in)::rad(:)
real(8),intent(in)::valence_cn(:)
real(8),intent(in)::cn(:)
real(8),intent(out)::mrad(:)
real(8),intent(out)::dmrdcn(:)
end
subroutine get_dir_trans(lattice,alpha,conv,trans)
real(8),intent(in)::lattice(:,:)
real(8),intent(in)::alpha
real(8),intent(in)::conv
real(8),allocatable,intent(out)::trans(:,:)
end
subroutine get_rec_trans(lattice,alpha,volume,conv,trans)
real(8),intent(in)::lattice(:,:)
real(8),intent(in)::alpha
real(8),intent(in)::volume
real(8),intent(in)::conv
real(8),allocatable,intent(out)::trans(:,:)
end
subroutine get_multipole_matrix(self,mol,cache,amat_sd,amat_dd,amat_sq)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(coulomb_cache),intent(inout)::cache
real(8),intent(inout)::amat_sd(:,:,:)
real(8),intent(inout)::amat_dd(:,:,:,:)
real(8),intent(inout)::amat_sq(:,:,:)
end
subroutine get_multipole_matrix_0d(mol,rad,kdmp3,kdmp5,amat_sd,amat_dd,amat_sq)
type(structure_type),intent(in)::mol
real(8),intent(in)::rad(:)
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),intent(inout)::amat_sd(:,:,:)
real(8),intent(inout)::amat_dd(:,:,:,:)
real(8),intent(inout)::amat_sq(:,:,:)
end
subroutine get_multipole_matrix_3d(mol,rad,kdmp3,kdmp5,wsc,alpha,amat_sd,amat_dd,amat_sq)
type(structure_type),intent(in)::mol
real(8),intent(in)::rad(:)
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
type(wignerseitz_cell),intent(in)::wsc
real(8),intent(in)::alpha
real(8),intent(inout)::amat_sd(:,:,:)
real(8),intent(inout)::amat_dd(:,:,:,:)
real(8),intent(inout)::amat_sq(:,:,:)
end
pure subroutine get_amat_sdq_rec_3d(rij,vol,alp,trans,amat_sd,amat_dd,amat_sq)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat_sd(:)
real(8),intent(out)::amat_dd(:,:)
real(8),intent(out)::amat_sq(:)
end
pure subroutine get_amat_sdq_dir_3d(rij,rr,kdmp3,kdmp5,alp,trans,amat_sd,amat_dd,amat_sq)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::rr
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat_sd(:)
real(8),intent(out)::amat_dd(:,:)
real(8),intent(out)::amat_sq(:)
end
subroutine get_multipole_gradient(self,mol,cache,qat,dpat,qpat,dedr,gradient,sigma)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(coulomb_cache),intent(inout)::cache
real(8),contiguous,intent(in)::qat(:)
real(8),contiguous,intent(in)::dpat(:,:)
real(8),contiguous,intent(in)::qpat(:,:)
real(8),contiguous,intent(inout)::dedr(:)
real(8),contiguous,intent(inout)::gradient(:,:)
real(8),contiguous,intent(inout)::sigma(:,:)
end
subroutine get_multipole_gradient_0d(mol,rad,kdmp3,kdmp5,qat,dpat,qpat,dedr,gradient,sigma)
type(structure_type),intent(in)::mol
real(8),intent(in)::rad(:)
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),contiguous,intent(in)::qat(:)
real(8),contiguous,intent(in)::dpat(:,:)
real(8),contiguous,intent(in)::qpat(:,:)
real(8),contiguous,intent(inout)::dedr(:)
real(8),contiguous,intent(inout)::gradient(:,:)
real(8),contiguous,intent(inout)::sigma(:,:)
end
subroutine get_multipole_gradient_3d(mol,rad,kdmp3,kdmp5,qat,dpat,qpat,wsc,alpha,dedr,gradient,sigma)
type(structure_type),intent(in)::mol
real(8),intent(in)::rad(:)
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),contiguous,intent(in)::qat(:)
real(8),contiguous,intent(in)::dpat(:,:)
real(8),contiguous,intent(in)::qpat(:,:)
type(wignerseitz_cell),intent(in)::wsc
real(8),intent(in)::alpha
real(8),contiguous,intent(inout)::dedr(:)
real(8),contiguous,intent(inout)::gradient(:,:)
real(8),contiguous,intent(inout)::sigma(:,:)
end
pure subroutine get_damat_sdq_rec_3d(rij,qi,qj,mi,mj,ti,tj,vol,alp,trans,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::qi
real(8),intent(in)::qj
real(8),intent(in)::mi(1_8:3_8)
real(8),intent(in)::mj(1_8:3_8)
real(8),intent(in)::ti(1_8:6_8)
real(8),intent(in)::tj(1_8:6_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
pure subroutine get_damat_sdq_dir_3d(rij,qi,qj,mi,mj,ti,tj,rr,kdmp3,kdmp5,alp,trans,de,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::qi
real(8),intent(in)::qj
real(8),intent(in)::mi(1_8:3_8)
real(8),intent(in)::mj(1_8:3_8)
real(8),intent(in)::ti(1_8:6_8)
real(8),intent(in)::tj(1_8:6_8)
real(8),intent(in)::rr
real(8),intent(in)::kdmp3
real(8),intent(in)::kdmp5
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::de
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
pure function variable_info(self) result(info)
use tblite_scf_info,only:scf_info
class(damped_multipole),intent(in)::self
type(scf_info)::info
end
subroutine taint(cache,ptr)
type(container_cache),intent(inout),target::cache
type(coulomb_cache),intent(out),pointer::ptr
end
subroutine view(cache,ptr)
type(container_cache),intent(inout),target::cache
type(coulomb_cache),intent(out),pointer::ptr
end
subroutine get_energy_axc(self,mol,wfn,energies)
class(damped_multipole),intent(in)::self
type(structure_type),intent(in)::mol
type(wavefunction_type),intent(in)::wfn
real(8),intent(inout)::energies(:)
end
end
