﻿!mod$ v1 sum:e0f07b9660d2e2b2
!need$ e96b11aedf1c65fa n tblite_scf_solver
!need$ 6ce8da455f737480 n tblite_wavefunction_fermi
!need$ 2997b2e10aa6edfd n tblite_blas_level3
!need$ 976c2c61ee34ace3 n tblite_blas
!need$ ae78003ee30bd742 n mctc_env
module tblite_scf_diag
use mctc_env,only:sp
use mctc_env,only:dp
use mctc_env,only:wp
use mctc_env,only:error_type
use tblite_blas,only:gemm
use tblite_scf_solver,only:solver_type
use tblite_wavefunction_fermi,only:get_fermi_filling
use tblite_blas_level3,only:tblite_blas$tblite_blas_level3$wrap_dgemm=>wrap_dgemm
private::sp
private::dp
private::wp
private::error_type
private::gemm
private::solver_type
private::get_fermi_filling
private::tblite_blas$tblite_blas_level3$wrap_dgemm
type,abstract,extends(solver_type)::diag_solver_type
contains
generic::solve=>solve_sp
generic::solve=>solve_dp
procedure(solve_sp),deferred::solve_sp
procedure(solve_dp),deferred::solve_dp
procedure::get_density
procedure::get_wdensity
procedure::delete
end type
private::solve_sp
abstract interface
subroutine solve_sp(self,hmat,smat,eval,error)
import::diag_solver_type
import::error_type
class(diag_solver_type),intent(inout)::self
real(4),contiguous,intent(inout)::hmat(:,:)
real(4),contiguous,intent(in)::smat(:,:)
real(4),contiguous,intent(inout)::eval(:)
type(error_type),allocatable,intent(out)::error
end
end interface
private::solve_dp
abstract interface
subroutine solve_dp(self,hmat,smat,eval,error)
import::diag_solver_type
import::error_type
class(diag_solver_type),intent(inout)::self
real(8),contiguous,intent(inout)::hmat(:,:)
real(8),contiguous,intent(in)::smat(:,:)
real(8),contiguous,intent(inout)::eval(:)
type(error_type),allocatable,intent(out)::error
end
end interface
private::get_density
private::get_wdensity
private::get_density_matrix
private::delete
contains
subroutine get_density(self,hmat,smat,eval,focc,density,error)
class(diag_solver_type),intent(inout)::self
real(8),contiguous,intent(inout)::hmat(:,:,:)
real(8),contiguous,intent(in)::smat(:,:)
real(8),contiguous,intent(inout)::eval(:,:)
real(8),contiguous,intent(inout)::focc(:,:)
real(8),contiguous,intent(inout)::density(:,:,:)
type(error_type),allocatable,intent(out)::error
end
subroutine get_wdensity(self,hmat,smat,eval,focc,density,error)
class(diag_solver_type),intent(inout)::self
real(8),contiguous,intent(inout)::hmat(:,:,:)
real(8),contiguous,intent(in)::smat(:,:)
real(8),contiguous,intent(inout)::eval(:,:)
real(8),contiguous,intent(inout)::focc(:,:)
real(8),contiguous,intent(inout)::density(:,:,:)
type(error_type),allocatable,intent(out)::error
end
subroutine get_density_matrix(focc,coeff,pmat)
real(8),intent(in)::focc(:)
real(8),contiguous,intent(in)::coeff(:,:)
real(8),contiguous,intent(out)::pmat(:,:)
end
subroutine delete(self)
class(diag_solver_type),intent(inout)::self
end
end
