﻿!mod$ v1 sum:d9ab01ee44899d6d
!need$ 310e9e822c000770 n tomlf_de_abc
!need$ 01fae1d6ef5e309e n tomlf_de_context
!need$ 975a84e6d91d739d n tomlf_de_token
!need$ e011eea57ef996e6 n tomlf_error
!need$ 6ff6e8a62f612d77 n tomlf_utils
!need$ a1c334c6b7cad11d n tomlf_datetime
!need$ 1f97a7e5909a9008 n tomlf_constants
module tomlf_de_lexer
use tomlf_constants,only:tfc
use tomlf_constants,only:tfi
use tomlf_constants,only:tfr
use tomlf_constants,only:toml_backspace
use tomlf_constants,only:toml_tabulator
use tomlf_constants,only:toml_newline
use tomlf_constants,only:toml_carriage_return
use tomlf_constants,only:toml_formfeed
use tomlf_datetime,only:toml_datetime
use tomlf_datetime,only:toml_date
use tomlf_datetime,only:toml_time
use tomlf_de_abc,only:abstract_lexer
use tomlf_de_context,only:toml_context
use tomlf_de_token,only:toml_token
use tomlf_de_token,only:stringify
use tomlf_de_token,only:token_kind
use tomlf_error,only:toml_error
use tomlf_error,only:toml_stat
use tomlf_error,only:make_error
use tomlf_utils,only:read_whole_file
use tomlf_utils,only:read_whole_line
use tomlf_datetime,only:tomlf_datetime$tomlf_datetime$new_datetime_from_string=>new_datetime_from_string
use tomlf_de_token,only:resize
private::tfc
private::tfi
private::tfr
private::toml_backspace
private::toml_tabulator
private::toml_newline
private::toml_carriage_return
private::toml_formfeed
private::toml_datetime
private::toml_date
private::toml_time
private::abstract_lexer
private::toml_context
private::toml_error
private::toml_stat
private::make_error
private::read_whole_file
private::read_whole_line
private::tomlf_datetime$tomlf_datetime$new_datetime_from_string
type,private::enum_char
character(1_4,1)::space=" "
character(1_4,1)::hash="#"
character(1_4,1)::squote="'"
character(3_4,1)::squote3="'''"
character(1_4,1)::dquote=""""
character(3_4,1)::dquote3=""""""""
character(1_4,1)::backslash="\\"
character(1_4,1)::dot="."
character(1_4,1)::comma=","
character(1_4,1)::equal="="
character(1_4,1)::lbrace="{"
character(1_4,1)::rbrace="}"
character(1_4,1)::lbracket="["
character(1_4,1)::rbracket="]"
character(1_4,1)::newline="\n"
character(1_4,1)::formfeed="\f"
character(1_4,1)::carriage_return="\r"
character(1_4,1)::bspace="\b"
character(1_4,1)::tab="\t"
character(1_4,1)::plus="+"
character(1_4,1)::minus="-"
character(12_4,1)::literal="0123456789-_"
end type
intrinsic::repeat
private::repeat
intrinsic::achar
private::achar
type(enum_char),parameter,private::char_kind=enum_char(space=" ",hash="#",squote="'",squote3="'''",dquote="""",dquote3="""""""",backslash="\\",dot=".",comma=",",equal="=",lbrace="{",rbrace="}",lbracket="[",rbracket="]",newline="\n",formfeed="\f",carriage_return="\r",bspace="\b",tab="\t",plus="+",minus="-",literal="0123456789-_")
character(*,1),parameter,private::terminated=" \t\n\r#}],="
type,private::enum_scope
integer(4)::table=1_4
integer(4)::equal=2_4
integer(4)::array=3_4
end type
type(enum_scope),parameter,private::lexer_scope=enum_scope(table=1_4,equal=2_4,array=3_4)
type,private::stack_item
integer(4)::scope
integer(4)::token
end type
type,extends(abstract_lexer)::toml_lexer
character(:,1),allocatable::filename
integer(4)::pos=0_4
character(:,1),allocatable::chunk
integer(4)::top=0_4
type(stack_item),allocatable::stack(:)
integer(4)::buffer=0_4
type(toml_context)::context
contains
procedure::next
procedure::extract_string
procedure::extract_integer
procedure::extract_float
procedure::extract_bool
procedure::extract_datetime
procedure::get_info
end type
private::next
private::fill_buffer
private::next_token
private::next_sstring
private::next_dstring
private::valid_string
private::next_keypath
private::next_literal
private::next_integer
private::next_float
private::next_datetime
private::valid_date
private::valid_time
private::valid_local
private::peek
private::match
private::match_all
private::strstr
private::extract_string
private::extract_integer
private::extract_float
private::extract_bool
private::extract_datetime
private::push_back
private::pop
private::view_scope
private::resize_scope
private::get_info
private::hex_to_int
private::verify_ucs
private::convert_ucs
interface resize
procedure::resize_scope
end interface
private::resize
contains
subroutine new_lexer_from_file(lexer,filename,error)
type(toml_lexer),intent(out)::lexer
character(*,1),intent(in)::filename
type(toml_error),allocatable,intent(out)::error
end
subroutine new_lexer_from_unit(lexer,io,error)
type(toml_lexer),intent(out)::lexer
integer(4),intent(in)::io
type(toml_error),allocatable,intent(out)::error
end
subroutine new_lexer_from_string(lexer,string)
type(toml_lexer),intent(out)::lexer
character(*,1),intent(in)::string
end
subroutine next(lexer,token)
class(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine fill_buffer(lexer)
class(toml_lexer),intent(inout)::lexer
end
subroutine next_token(lexer,token)
class(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_sstring(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_dstring(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
pure function valid_string(ch) result(valid)
character(1_4,1),intent(in)::ch
logical(4)::valid
end
subroutine next_keypath(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_literal(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_integer(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_float(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
subroutine next_datetime(lexer,token)
type(toml_lexer),intent(inout)::lexer
type(toml_token),intent(inout)::token
end
pure function valid_date(string) result(valid)
character(1_4,1),intent(in)::string(:)
logical(4)::valid
end
function valid_time(string) result(valid)
character(1_4,1),intent(in)::string(:)
logical(4)::valid
end
function valid_local(string) result(valid)
character(1_4,1),intent(in)::string(:)
logical(4)::valid
end
elemental function peek(lexer,pos) result(ch)
type(toml_lexer),intent(in)::lexer
integer(4),intent(in)::pos
character(1_4,1)::ch
end
elemental function match(lexer,pos,kind)
type(toml_lexer),intent(in)::lexer
integer(4),intent(in)::pos
character(1_4,1),intent(in)::kind
logical(4)::match
end
pure function match_all(lexer,pos,kind) result(match)
type(toml_lexer),intent(in)::lexer
integer(4),intent(in)::pos(:)
character(1_4,1),intent(in)::kind(:)
logical(4)::match
end
pure function strstr(string,pattern) result(res)
character(*,1),intent(in)::string
character(*,1),intent(in)::pattern
integer(4)::res
end
subroutine extract_string(lexer,token,string)
class(toml_lexer),intent(in)::lexer
type(toml_token),intent(in)::token
character(:,1),allocatable,intent(out)::string
end
subroutine extract_integer(lexer,token,val)
class(toml_lexer),intent(in)::lexer
type(toml_token),intent(in)::token
integer(8),intent(out)::val
end
subroutine extract_float(lexer,token,val)
class(toml_lexer),intent(in)::lexer
type(toml_token),intent(in)::token
real(8),intent(out)::val
end
subroutine extract_bool(lexer,token,val)
class(toml_lexer),intent(in)::lexer
type(toml_token),intent(in)::token
logical(4),intent(out)::val
end
subroutine extract_datetime(lexer,token,val)
class(toml_lexer),intent(in)::lexer
type(toml_token),intent(in)::token
type(toml_datetime),intent(out)::val
end
pure subroutine push_back(lexer,scope,token)
type(toml_lexer),intent(inout)::lexer
integer(4),intent(in)::scope
integer(4),intent(in)::token
end
subroutine pop(lexer,scope)
type(toml_lexer),intent(inout)::lexer
integer(4),intent(in)::scope
end
pure function view_scope(lexer) result(scope)
type(toml_lexer),intent(in)::lexer
integer(4)::scope
end
pure subroutine resize_scope(var,n)
type(stack_item),allocatable,intent(inout)::var(:)
integer(4),intent(in),optional::n
end
subroutine get_info(lexer,meta,output)
class(toml_lexer),intent(in)::lexer
character(*,1),intent(in)::meta
character(:,1),allocatable,intent(out)::output
end
function hex_to_int(hex) result(val)
character(*,1),intent(in)::hex
integer(8)::val
end
function verify_ucs(escape) result(valid)
character(*,1),intent(in)::escape
logical(4)::valid
end
function convert_ucs(escape) result(str)
character(*,1),intent(in)::escape
character(:,1),allocatable::str
end
end
