# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_uu_coreutils_global_optspecs
	string join \n h/help
end

function __fish_uu_coreutils_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_uu_coreutils_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_uu_coreutils_using_subcommand
	set -l cmd (__fish_uu_coreutils_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "arch" -d 'arch-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "base32" -d 'base32-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "base64" -d 'base64-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "basename" -d 'basename-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "basenc" -d 'basenc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cat" -d 'cat-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cksum" -d 'cksum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "comm" -d 'comm-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cp" -d 'cp-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "csplit" -d 'csplit-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cut" -d 'cut-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "date" -d 'date-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dd" -d 'dd-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "df" -d 'df-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dir" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dircolors" -d 'dircolors-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dirname" -d 'dirname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "du" -d 'du-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "echo" -d 'echo-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "env" -d 'env-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "expand" -d 'expand-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "expr" -d 'expr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "factor" -d 'factor-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "false" -d 'false-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "fmt" -d 'fmt-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "fold" -d 'fold-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "hashsum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "md5sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha1sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha224sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha256sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha384sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha512sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "b2sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "head" -d 'head-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "hostname" -d 'hostname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "join" -d 'join-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "link" -d 'link-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ln" -d 'ln-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ls" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mkdir" -d 'mkdir-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mktemp" -d 'mktemp-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "more" -d 'more-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mv" -d 'mv-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nl" -d 'nl-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nproc" -d 'nproc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "numfmt" -d 'numfmt-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "od" -d 'od-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "paste" -d 'paste-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pr" -d 'pr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "printenv" -d 'printenv-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "printf" -d 'printf-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ptx" -d 'ptx-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pwd" -d 'pwd-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "readlink" -d 'readlink-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "realpath" -d 'realpath-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "rm" -d 'rm-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "rmdir" -d 'rmdir-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "seq" -d 'seq-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shred" -d 'shred-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shuf" -d 'shuf-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sleep" -d 'sleep-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sort" -d 'sort-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "split" -d 'split-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sum" -d 'sum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sync" -d 'sync-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tac" -d 'tac-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tail" -d 'tail-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tee" -d 'tee-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "touch" -d 'touch-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tr" -d 'tr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "true" -d 'true-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "truncate" -d 'truncate-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tsort" -d 'tsort-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "uname" -d 'uname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "unexpand" -d 'unexpand-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "uniq" -d 'uniq-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "unlink" -d 'unlink-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "test" -d 'test-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "[" -d 'test-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "vdir" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "wc" -d 'wc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "whoami" -d 'whoami-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "yes" -d 'yes-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand arch" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand base32" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand base64" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand basename" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand basenc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cat" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cksum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand comm" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cp" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand csplit" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cut" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand date" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dd" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand df" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dircolors" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dirname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand du" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand echo" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand env" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand expand" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand expr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand factor" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand false" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand fmt" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand fold" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand hashsum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand md5sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha1sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha224sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha256sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha384sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha512sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand b2sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand head" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand hostname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand join" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand link" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ln" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ls" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mkdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mktemp" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand more" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mv" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nl" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nproc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand numfmt" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand od" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand paste" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand printenv" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand printf" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ptx" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pwd" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand readlink" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand realpath" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand rm" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand rmdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand seq" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shred" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shuf" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sleep" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sort" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand split" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sync" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tac" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tail" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tee" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand touch" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand true" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand truncate" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tsort" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand uname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand unexpand" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand uniq" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand unlink" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand test" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand [" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand vdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand wc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand whoami" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand yes" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "arch" -d 'arch-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "base32" -d 'base32-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "base64" -d 'base64-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "basename" -d 'basename-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "basenc" -d 'basenc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "cat" -d 'cat-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "cksum" -d 'cksum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "comm" -d 'comm-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "cp" -d 'cp-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "csplit" -d 'csplit-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "cut" -d 'cut-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "date" -d 'date-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "dd" -d 'dd-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "df" -d 'df-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "dir" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "dircolors" -d 'dircolors-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "dirname" -d 'dirname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "du" -d 'du-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "echo" -d 'echo-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "env" -d 'env-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "expand" -d 'expand-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "expr" -d 'expr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "factor" -d 'factor-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "false" -d 'false-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "fmt" -d 'fmt-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "fold" -d 'fold-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "hashsum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "md5sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sha1sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sha224sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sha256sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sha384sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sha512sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "b2sum" -d 'hashsum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "head" -d 'head-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "hostname" -d 'hostname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "join" -d 'join-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "link" -d 'link-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "ln" -d 'ln-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "ls" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "mkdir" -d 'mkdir-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "mktemp" -d 'mktemp-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "more" -d 'more-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "mv" -d 'mv-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "nl" -d 'nl-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "nproc" -d 'nproc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "numfmt" -d 'numfmt-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "od" -d 'od-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "paste" -d 'paste-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "pr" -d 'pr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "printenv" -d 'printenv-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "printf" -d 'printf-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "ptx" -d 'ptx-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "pwd" -d 'pwd-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "readlink" -d 'readlink-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "realpath" -d 'realpath-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "rm" -d 'rm-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "rmdir" -d 'rmdir-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "seq" -d 'seq-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "shred" -d 'shred-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "shuf" -d 'shuf-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sleep" -d 'sleep-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sort" -d 'sort-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "split" -d 'split-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sum" -d 'sum-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "sync" -d 'sync-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "tac" -d 'tac-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "tail" -d 'tail-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "tee" -d 'tee-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "touch" -d 'touch-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "tr" -d 'tr-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "true" -d 'true-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "truncate" -d 'truncate-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "tsort" -d 'tsort-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "uname" -d 'uname-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "unexpand" -d 'unexpand-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "uniq" -d 'uniq-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "unlink" -d 'unlink-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "test" -d 'test-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "[" -d 'test-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "vdir" -d 'ls-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "wc" -d 'wc-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "whoami" -d 'whoami-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "yes" -d 'yes-about'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum b2sum head hostname join link ln ls mkdir mktemp more mv nl nproc numfmt od paste pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split sum sync tac tail tee touch tr true truncate tsort uname unexpand uniq unlink test [ vdir wc whoami yes help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
