Object.assign(window.search, {"doc_urls":["introduction.html#introduction","examples/index.html#examples-of-using-wasm-bindgen-js-sys-and-web-sys","examples/hello-world.html#hello-world","examples/hello-world.html#cargotoml","examples/hello-world.html#srclibrs","examples/hello-world.html#indexjs","examples/hello-world.html#webpack-specific-files","examples/console-log.html#consolelog","examples/console-log.html#srclibrs","examples/add.html#small-wasm-files","examples/without-a-bundler.html#without-a-bundler","examples/without-a-bundler.html#using-the-older---target-no-modules","examples/synchronous-instantiation.html#synchronous-instantiation","examples/import-js.html#importing-non-browser-js","examples/char.html#working-with-the-char-type","examples/char.html#srclibrs","examples/char.html#indexjs","examples/wasm-in-wasm.html#js-sys-webassembly-in-webassembly","examples/wasm-in-wasm.html#srclibrs","examples/dom.html#web-sys-dom-hello-world","examples/dom.html#cargotoml","examples/dom.html#srclibrs","examples/closures.html#web-sys-closures","examples/closures.html#srclibrs","examples/performance.html#web-sys-performancenow","examples/performance.html#srclibrs","examples/fetch.html#the-fetch-api","examples/fetch.html#cargotoml","examples/fetch.html#srclibrs","examples/weather_report.html#web-sys-weather-report","examples/weather_report.html#srclibrs","examples/2d-canvas.html#2d-canvas","examples/2d-canvas.html#cargotoml","examples/2d-canvas.html#srclibrs","examples/julia.html#julia-set","examples/julia.html#indexjs","examples/julia.html#srclibrs","examples/web-audio.html#webaudio","examples/web-audio.html#cargotoml","examples/web-audio.html#srclibrs","examples/web-audio.html#indexjs","examples/webgl.html#webgl-example","examples/webgl.html#cargotoml","examples/webgl.html#srclibrs","examples/websockets.html#websockets-example","examples/websockets.html#cargotoml","examples/websockets.html#srclibrs","examples/webrtc_datachannel.html#webrtc-datachannel-example","examples/webrtc_datachannel.html#cargotoml","examples/webrtc_datachannel.html#srclibrs","examples/request-animation-frame.html#web-sys-a-requestanimationframe-loop","examples/request-animation-frame.html#cargotoml","examples/request-animation-frame.html#srclibrs","examples/paint.html#paint-example","examples/paint.html#cargotoml","examples/paint.html#srclibrs","examples/wasm-in-web-worker.html#wasm-in-web-worker","examples/wasm-in-web-worker.html#building--compatibility","examples/wasm-in-web-worker.html#cargotoml","examples/wasm-in-web-worker.html#srclibrs","examples/wasm-in-web-worker.html#indexhtml","examples/wasm-in-web-worker.html#indexjs","examples/wasm-in-web-worker.html#workerjs","examples/raytrace.html#parallel-raytracing","examples/raytrace.html#building-the-demo","examples/raytrace.html#running-the-demo","examples/raytrace.html#caveats","examples/raytrace.html#browser-requirements","examples/wasm-audio-worklet.html#wasm-audio-worklet","examples/wasm-audio-worklet.html#building-the-demo","examples/wasm-audio-worklet.html#caveats","examples/wasm-audio-worklet.html#browser-requirements","examples/todomvc.html#todo-mvc-using-wasm-bingen-and-web-sys","examples/todomvc.html#size","reference/index.html#reference","reference/deployment.html#deploying-rust-and-webassembly","reference/deployment.html#bundlers","reference/deployment.html#without-a-bundler","reference/deployment.html#nodejs","reference/deployment.html#nodejs-module","reference/deployment.html#deno","reference/deployment.html#npm","reference/js-snippets.html#js-snippets","reference/js-snippets.html#using-inline_js","reference/js-snippets.html#caveats","reference/static-js-objects.html#use-of-static-to-access-js-objects","reference/static-js-objects.html#static-strings","reference/passing-rust-closures-to-js.html#passing-rust-closures-to-imported-javascript-functions","reference/passing-rust-closures-to-js.html#stack-lifetime-closures","reference/passing-rust-closures-to-js.html#heap-allocated-closures","reference/receiving-js-closures-in-rust.html#receiving-javascript-closures-in-exported-rust-functions","reference/js-promises-and-rust-futures.html#working-with-a-js-promise-and-a-rust-future","reference/js-promises-and-rust-futures.html#return-values-of-async-fn","reference/js-promises-and-rust-futures.html#using-wasm-bindgen-futures","reference/js-promises-and-rust-futures.html#compatibility-with-versions-of-future","reference/iterating-over-js-values.html#iterating-over-javascript-values","reference/iterating-over-js-values.html#methods-that-return-js_sysiterator","reference/iterating-over-js-values.html#iterating-over-any-javascript-object-that-implements-the-iterator-protocol","reference/arbitrary-data-with-serde.html#serializing-and-deserializing-arbitrary-data-into-and-from-jsvalue-with-serde","reference/arbitrary-data-with-serde.html#add-dependencies","reference/arbitrary-data-with-serde.html#derive-the-serialize-and-deserialize-traits","reference/arbitrary-data-with-serde.html#send-it-to-javascript-with-serde_wasm_bindgento_value","reference/arbitrary-data-with-serde.html#receive-it-from-javascript-with-serde_wasm_bindgenfrom_value","reference/arbitrary-data-with-serde.html#javascript-usage","reference/arbitrary-data-with-serde.html#an-alternative-approach---using-json","reference/arbitrary-data-with-serde.html#history","reference/accessing-properties-of-untyped-js-values.html#accessing-properties-of-untyped-javascript-values","reference/accessing-properties-of-untyped-js-values.html#reading-properties-with-js_sysreflectget","reference/accessing-properties-of-untyped-js-values.html#writing-properties-with-js_sysreflectset","reference/accessing-properties-of-untyped-js-values.html#determining-if-a-property-exists-with-js_sysreflecthas","reference/accessing-properties-of-untyped-js-values.html#but-wait--theres-more","reference/working-with-duck-typed-interfaces.html#working-with-duck-typed-interfaces","reference/working-with-duck-typed-interfaces.html#defining-a-duck-typed-interface-in-rust","reference/working-with-duck-typed-interfaces.html#javascript-usage","reference/cli.html#the-wasm-bindgen-command-line-interface","reference/cli.html#installation","reference/cli.html#usage","reference/cli.html#options","reference/cli.html#--out-dir-dir","reference/cli.html#--target","reference/cli.html#--no-modules-global-var","reference/cli.html#--typescript","reference/cli.html#--no-typescript","reference/cli.html#--omit-imports","reference/cli.html#--debug","reference/cli.html#--no-demangle","reference/cli.html#--keep-lld-exports","reference/cli.html#--keep-debug","reference/cli.html#--browser","reference/cli.html#--omit-default-module-path","reference/cli.html#--split-linked-modules","reference/optimize-size.html#optimizing-for-size-with-wasm-bindgen","reference/optimize-size.html#what-to-profile","reference/optimize-size.html#example","reference/rust-targets.html#supported-rust-targets","reference/rust-targets.html#non-wasm-targets","reference/rust-targets.html#other-web-targets","reference/browser-support.html#supported-browsers","reference/browser-support.html#caveats","reference/weak-references.html#support-for-weak-references","reference/reference-types.html#support-for-reference-types","reference/types.html#supported-rust-types-and-their-javascript-representations","reference/types/imported-js-types.html#imported-extern-whatever-javascript-types","reference/types/imported-js-types.html#example-rust-usage","reference/types/imported-js-types.html#example-javascript-usage","reference/types/exported-rust-types.html#exported-struct-whatever-rust-types","reference/types/exported-rust-types.html#example-rust-usage","reference/types/exported-rust-types.html#example-javascript-usage","reference/types/jsvalue.html#jsvalue","reference/types/jsvalue.html#example-rust-usage","reference/types/jsvalue.html#example-javascript-usage","reference/types/boxed-slices.html#box-and-vec","reference/types/boxed-slices.html#example-rust-usage","reference/types/boxed-slices.html#example-javascript-usage","reference/types/pointers.html#const-t-and-mut-t","reference/types/pointers.html#example-rust-usage","reference/types/pointers.html#example-javascript-usage","reference/types/non-null.html#nonnull","reference/types/non-null.html#example-rust-usage","reference/types/non-null.html#example-javascript-usage","reference/types/numbers.html#numbers-u8-i8-u16-i16-u32-i32-u64-i64-u128-i128-isize-usize-f32-and-f64","reference/types/numbers.html#converting-from-javascript-to-rust","reference/types/numbers.html#number-to-u8-i8-u16-i16-u32-i32-isize-and-usize","reference/types/numbers.html#bigint-to-u64-i64-u128-and-i128","reference/types/numbers.html#number-to-f32","reference/types/numbers.html#number-to-f64","reference/types/numbers.html#example-rust-usage","reference/types/numbers.html#example-javascript-usage","reference/types/bool.html#bool","reference/types/bool.html#example-rust-usage","reference/types/bool.html#example-javascript-usage","reference/types/char.html#char","reference/types/char.html#example-rust-usage","reference/types/char.html#example-javascript-usage","reference/types/str.html#str","reference/types/str.html#example-rust-usage","reference/types/str.html#example-javascript-usage","reference/types/str.html#utf-16-vs-utf-8","reference/types/string.html#string","reference/types/string.html#example-rust-usage","reference/types/string.html#example-javascript-usage","reference/types/number-slices.html#number-slices-u8-i8-u16-i16-u32-i32-u64-i64-f32-and-f64","reference/types/number-slices.html#example-rust-usage","reference/types/number-slices.html#example-javascript-usage","reference/types/boxed-number-slices.html#boxed-number-slices-box-box-box-box-box-box-box-box-box-and-box","reference/types/boxed-number-slices.html#example-rust-usage","reference/types/boxed-number-slices.html#example-javascript-usage","reference/types/result.html#result","reference/attributes/index.html#wasm_bindgen-attributes","reference/attributes/on-js-imports/index.html#wasm_bindgen-on-javascript-imports","reference/attributes/on-js-imports/catch.html#catch","reference/attributes/on-js-imports/constructor.html#constructor","reference/attributes/on-js-imports/extends.html#extends--class","reference/attributes/on-js-imports/getter-and-setter.html#getter-and-setter","reference/attributes/on-js-imports/final.html#final","reference/attributes/on-js-imports/final.html#interaction-with-future-proposals","reference/attributes/on-js-imports/indexing-getter-setter-deleter.html#indexing_getter-indexing_setter-and-indexing_deleter","reference/attributes/on-js-imports/js_class.html#js_class--blah","reference/attributes/on-js-imports/js_name.html#js_name--blah","reference/attributes/on-js-imports/js_namespace.html#js_namespace--blah","reference/attributes/on-js-imports/method.html#method","reference/attributes/on-js-imports/module.html#module--blah","reference/attributes/on-js-imports/raw_module.html#raw_module--blah","reference/attributes/on-js-imports/no_deref.html#no_deref","reference/attributes/on-js-imports/static_method_of.html#static_method_of--blah","reference/attributes/on-js-imports/structural.html#structural","reference/attributes/on-js-imports/typescript_type.html#typescript_type","reference/attributes/on-js-imports/variadic.html#variadic-parameters","reference/attributes/on-js-imports/vendor_prefix.html#vendor-prefixed-apis","reference/attributes/on-rust-exports/index.html#wasm_bindgen-on-rust-exports","reference/attributes/on-rust-exports/constructor.html#constructor","reference/attributes/on-rust-exports/constructor.html#caveats","reference/attributes/on-rust-exports/js_name.html#js_name--blah","reference/attributes/on-rust-exports/js_class.html#js_class--blah","reference/attributes/on-rust-exports/readonly.html#readonly","reference/attributes/on-rust-exports/skip.html#skip","reference/attributes/on-rust-exports/skip_jsdoc.html#skip_jsdoc","reference/attributes/on-rust-exports/start.html#start","reference/attributes/on-rust-exports/main.html#main","reference/attributes/on-rust-exports/typescript_custom_section.html#typescript_custom_section","reference/attributes/on-rust-exports/getter-and-setter.html#getter-and-setter","reference/attributes/on-rust-exports/inspectable.html#inspectable","reference/attributes/on-rust-exports/inspectable.html#inspectable-classes-in-nodejs","reference/attributes/on-rust-exports/skip_typescript.html#skip_typescript","reference/attributes/on-rust-exports/getter_with_clone.html#getter_with_clone","web-sys/index.html#the-web-sys-crate","web-sys/index.html#api-documentation","web-sys/using-web-sys.html#using-web-sys","web-sys/using-web-sys.html#add-web-sys-as-a-dependency-to-your-cargotoml","web-sys/using-web-sys.html#enable-the-cargo-features-for-the-apis-youre-using","web-sys/using-web-sys.html#call-the-method","web-sys/cargo-features.html#cargo-features-in-web-sys","web-sys/function-overloads.html#function-overloads","web-sys/type-translations.html#type-translations-in-web-sys","web-sys/inheritance.html#inheritance-in-web-sys","web-sys/inheritance.html#accessing-parent-classes-using-deref","web-sys/inheritance.html#accessing-parent-classes-using-asref","web-sys/inheritance.html#accessing-child-classes-using-jscast","web-sys/unstable-apis.html#unstable-apis","wasm-bindgen-test/index.html#testing-on-wasm32-unknown-unknown-with-wasm-bindgen-test","wasm-bindgen-test/index.html#goals","wasm-bindgen-test/usage.html#using-wasm-bindgen-test","wasm-bindgen-test/usage.html#add-wasm-bindgen-test-to-your-cargotomls-dev-dependencies","wasm-bindgen-test/usage.html#write-some-tests","wasm-bindgen-test/usage.html#execute-your-tests","wasm-bindgen-test/usage.html#appendix-using-wasm-bindgen-test-without-wasm-pack","wasm-bindgen-test/usage.html#install-the-test-runner","wasm-bindgen-test/usage.html#configure-cargoconfig-to-use-the-test-runner","wasm-bindgen-test/usage.html#run-the-tests","wasm-bindgen-test/asynchronous-tests.html#writing-asynchronous-tests","wasm-bindgen-test/asynchronous-tests.html#rust-compiler-compatibility","wasm-bindgen-test/browsers.html#testing-in-headless-browsers","wasm-bindgen-test/browsers.html#configure-via-environment-variables","wasm-bindgen-test/browsers.html#force-configuration","wasm-bindgen-test/browsers.html#configuring-which-browser-is-used","wasm-bindgen-test/browsers.html#running-the-tests-in-the-headless-browser","wasm-bindgen-test/browsers.html#configuring-headless-browser-capabilities","wasm-bindgen-test/browsers.html#debugging-headless-browser-tests","wasm-bindgen-test/browsers.html#appendix-testing-in-headless-browsers-without-wasm-pack","wasm-bindgen-test/browsers.html#configuring-which-browser-is-used-1","wasm-bindgen-test/browsers.html#running-the-tests-in-the-remote-headless-browser","wasm-bindgen-test/browsers.html#running-the-tests-in-the-headless-browser-1","wasm-bindgen-test/continuous-integration.html#setting-up-continuous-integration-with-wasm-bindgen-test","wasm-bindgen-test/continuous-integration.html#travis-ci","wasm-bindgen-test/continuous-integration.html#appveyor","wasm-bindgen-test/continuous-integration.html#github-actions","wasm-bindgen-test/coverage.html#generating-coverage-data","wasm-bindgen-test/coverage.html#enabling-the-feature","wasm-bindgen-test/coverage.html#generating-the-data","wasm-bindgen-test/coverage.html#rustflags-that-need-to-be-present","wasm-bindgen-test/coverage.html#arguments-to-the-test-runner","wasm-bindgen-test/coverage.html#target-features","wasm-bindgen-test/coverage.html#example","wasm-bindgen-test/coverage.html#attribution","contributing/index.html#contributing-to-wasm-bindgen","contributing/index.html#prerequisites","contributing/index.html#code-formatting","contributing/testing.html#running-wasm-bindgens-tests","contributing/testing.html#wasm-tests-on-node-and-headless-browsers","contributing/testing.html#sanity-tests-for-wasm-bindgen-on-the-native-host-target","contributing/testing.html#the-web-idl-frontends-tests","contributing/testing.html#the-macro-ui-tests","contributing/testing.html#the-js-sys-tests","contributing/testing.html#the-web-sys-tests","contributing/design/index.html#design-of-wasm-bindgen","contributing/design/index.html#foundation-es-modules","contributing/design/index.html#foundation-2-unintrusive-in-rust","contributing/design/js-objects-in-rust.html#polyfill-for-js-objects-in-wasm","contributing/design/js-objects-in-rust.html#temporary-js-objects-on-the-stack","contributing/design/js-objects-in-rust.html#long-lived-js-objects","contributing/design/js-objects-in-rust.html#anatomy-of-jsvalue","contributing/design/js-objects-in-rust.html#working-with-heap-in-reality","contributing/design/exporting-rust.html#exporting-a-function-to-js","contributing/design/exporting-rust-struct.html#exporting-a-struct-to-js","contributing/design/importing-js.html#importing-a-function-from-js","contributing/design/importing-js-struct.html#importing-a-class-from-js","contributing/design/rust-type-conversions.html#rust-type-conversions","contributing/design/rust-type-conversions.html#from-rust-to-js","contributing/design/rust-type-conversions.html#from-js-to-rust","contributing/design/describe.html#communicating-types-to-wasm-bindgen","contributing/js-sys/index.html#js-sys","contributing/js-sys/testing.html#testing","contributing/js-sys/adding-more-apis.html#adding-support-for-more-javascript-global-apis","contributing/js-sys/adding-more-apis.html#instructions-for-adding-an-api","contributing/web-sys/index.html#web-sys","contributing/web-sys/overview.html#web-sys-overview","contributing/web-sys/overview.html#webidlsenabledwebidl","contributing/web-sys/overview.html#buildrs","contributing/web-sys/overview.html#srclibrs","contributing/web-sys/overview.html#cargo-features","contributing/web-sys/testing.html#testing","contributing/web-sys/logging.html#logging","contributing/web-sys/supporting-more-web-apis.html#supporting-more-web-apis-in-web-sys","contributing/publishing.html#publishing-new-wasm-bindgen-releases","contributing/team.html#team","contributing/team.html#members"],"index":{"documentStore":{"docInfo":{"0":{"body":177,"breadcrumbs":2,"title":1},"1":{"body":82,"breadcrumbs":9,"title":8},"10":{"body":323,"breadcrumbs":5,"title":2},"100":{"body":67,"breadcrumbs":8,"title":4},"101":{"body":31,"breadcrumbs":7,"title":3},"102":{"body":16,"breadcrumbs":7,"title":3},"103":{"body":38,"breadcrumbs":6,"title":2},"104":{"body":136,"breadcrumbs":8,"title":4},"105":{"body":48,"breadcrumbs":5,"title":1},"106":{"body":30,"breadcrumbs":11,"title":5},"107":{"body":16,"breadcrumbs":9,"title":3},"108":{"body":21,"breadcrumbs":9,"title":3},"109":{"body":22,"breadcrumbs":10,"title":4},"11":{"body":130,"breadcrumbs":7,"title":4},"110":{"body":11,"breadcrumbs":9,"title":3},"111":{"body":35,"breadcrumbs":9,"title":4},"112":{"body":50,"breadcrumbs":10,"title":5},"113":{"body":33,"breadcrumbs":7,"title":2},"114":{"body":21,"breadcrumbs":9,"title":5},"115":{"body":6,"breadcrumbs":5,"title":1},"116":{"body":6,"breadcrumbs":5,"title":1},"117":{"body":0,"breadcrumbs":5,"title":1},"118":{"body":11,"breadcrumbs":7,"title":3},"119":{"body":25,"breadcrumbs":5,"title":1},"12":{"body":252,"breadcrumbs":5,"title":2},"120":{"body":15,"breadcrumbs":7,"title":3},"121":{"body":8,"breadcrumbs":5,"title":1},"122":{"body":11,"breadcrumbs":5,"title":1},"123":{"body":42,"breadcrumbs":6,"title":2},"124":{"body":16,"breadcrumbs":5,"title":1},"125":{"body":10,"breadcrumbs":5,"title":1},"126":{"body":10,"breadcrumbs":7,"title":3},"127":{"body":10,"breadcrumbs":6,"title":2},"128":{"body":18,"breadcrumbs":5,"title":1},"129":{"body":7,"breadcrumbs":8,"title":4},"13":{"body":123,"breadcrumbs":8,"title":4},"130":{"body":107,"breadcrumbs":7,"title":3},"131":{"body":46,"breadcrumbs":7,"title":4},"132":{"body":136,"breadcrumbs":4,"title":1},"133":{"body":18,"breadcrumbs":4,"title":1},"134":{"body":40,"breadcrumbs":7,"title":3},"135":{"body":93,"breadcrumbs":7,"title":3},"136":{"body":25,"breadcrumbs":6,"title":2},"137":{"body":56,"breadcrumbs":5,"title":2},"138":{"body":44,"breadcrumbs":4,"title":1},"139":{"body":83,"breadcrumbs":7,"title":3},"14":{"body":76,"breadcrumbs":6,"title":3},"140":{"body":150,"breadcrumbs":7,"title":3},"141":{"body":13,"breadcrumbs":8,"title":5},"142":{"body":29,"breadcrumbs":11,"title":5},"143":{"body":71,"breadcrumbs":9,"title":3},"144":{"body":29,"breadcrumbs":9,"title":3},"145":{"body":50,"breadcrumbs":11,"title":5},"146":{"body":82,"breadcrumbs":9,"title":3},"147":{"body":36,"breadcrumbs":9,"title":3},"148":{"body":22,"breadcrumbs":5,"title":1},"149":{"body":18,"breadcrumbs":7,"title":3},"15":{"body":65,"breadcrumbs":4,"title":1},"150":{"body":9,"breadcrumbs":7,"title":3},"151":{"body":56,"breadcrumbs":7,"title":2},"152":{"body":25,"breadcrumbs":8,"title":3},"153":{"body":28,"breadcrumbs":8,"title":3},"154":{"body":24,"breadcrumbs":11,"title":4},"155":{"body":17,"breadcrumbs":10,"title":3},"156":{"body":20,"breadcrumbs":10,"title":3},"157":{"body":24,"breadcrumbs":5,"title":1},"158":{"body":19,"breadcrumbs":7,"title":3},"159":{"body":20,"breadcrumbs":7,"title":3},"16":{"body":130,"breadcrumbs":4,"title":1},"160":{"body":94,"breadcrumbs":19,"title":15},"161":{"body":13,"breadcrumbs":7,"title":3},"162":{"body":93,"breadcrumbs":13,"title":9},"163":{"body":24,"breadcrumbs":9,"title":5},"164":{"body":26,"breadcrumbs":6,"title":2},"165":{"body":13,"breadcrumbs":6,"title":2},"166":{"body":24,"breadcrumbs":7,"title":3},"167":{"body":22,"breadcrumbs":7,"title":3},"168":{"body":57,"breadcrumbs":5,"title":1},"169":{"body":24,"breadcrumbs":7,"title":3},"17":{"body":20,"breadcrumbs":9,"title":4},"170":{"body":22,"breadcrumbs":7,"title":3},"171":{"body":86,"breadcrumbs":5,"title":1},"172":{"body":12,"breadcrumbs":7,"title":3},"173":{"body":10,"breadcrumbs":7,"title":3},"174":{"body":48,"breadcrumbs":5,"title":1},"175":{"body":7,"breadcrumbs":7,"title":3},"176":{"body":4,"breadcrumbs":7,"title":3},"177":{"body":117,"breadcrumbs":9,"title":5},"178":{"body":52,"breadcrumbs":5,"title":1},"179":{"body":24,"breadcrumbs":7,"title":3},"18":{"body":93,"breadcrumbs":6,"title":1},"180":{"body":22,"breadcrumbs":7,"title":3},"181":{"body":31,"breadcrumbs":17,"title":12},"182":{"body":13,"breadcrumbs":8,"title":3},"183":{"body":8,"breadcrumbs":8,"title":3},"184":{"body":49,"breadcrumbs":19,"title":13},"185":{"body":24,"breadcrumbs":9,"title":3},"186":{"body":26,"breadcrumbs":9,"title":3},"187":{"body":92,"breadcrumbs":7,"title":2},"188":{"body":22,"breadcrumbs":5,"title":2},"189":{"body":15,"breadcrumbs":8,"title":3},"19":{"body":33,"breadcrumbs":11,"title":5},"190":{"body":95,"breadcrumbs":7,"title":1},"191":{"body":51,"breadcrumbs":7,"title":1},"192":{"body":92,"breadcrumbs":8,"title":2},"193":{"body":178,"breadcrumbs":9,"title":2},"194":{"body":241,"breadcrumbs":7,"title":1},"195":{"body":228,"breadcrumbs":9,"title":3},"196":{"body":188,"breadcrumbs":11,"title":3},"197":{"body":52,"breadcrumbs":9,"title":2},"198":{"body":178,"breadcrumbs":8,"title":2},"199":{"body":144,"breadcrumbs":8,"title":2},"2":{"body":25,"breadcrumbs":5,"title":2},"20":{"body":46,"breadcrumbs":7,"title":1},"200":{"body":42,"breadcrumbs":7,"title":1},"201":{"body":58,"breadcrumbs":9,"title":2},"202":{"body":58,"breadcrumbs":9,"title":2},"203":{"body":41,"breadcrumbs":7,"title":1},"204":{"body":76,"breadcrumbs":9,"title":2},"205":{"body":119,"breadcrumbs":7,"title":1},"206":{"body":91,"breadcrumbs":7,"title":1},"207":{"body":105,"breadcrumbs":8,"title":2},"208":{"body":64,"breadcrumbs":9,"title":3},"209":{"body":11,"breadcrumbs":8,"title":3},"21":{"body":45,"breadcrumbs":7,"title":1},"210":{"body":49,"breadcrumbs":7,"title":1},"211":{"body":65,"breadcrumbs":7,"title":1},"212":{"body":79,"breadcrumbs":9,"title":2},"213":{"body":51,"breadcrumbs":9,"title":2},"214":{"body":66,"breadcrumbs":7,"title":1},"215":{"body":75,"breadcrumbs":7,"title":1},"216":{"body":109,"breadcrumbs":7,"title":1},"217":{"body":102,"breadcrumbs":7,"title":1},"218":{"body":72,"breadcrumbs":7,"title":1},"219":{"body":83,"breadcrumbs":7,"title":1},"22":{"body":28,"breadcrumbs":7,"title":3},"220":{"body":128,"breadcrumbs":9,"title":2},"221":{"body":125,"breadcrumbs":7,"title":1},"222":{"body":20,"breadcrumbs":9,"title":3},"223":{"body":80,"breadcrumbs":7,"title":1},"224":{"body":44,"breadcrumbs":7,"title":1},"225":{"body":41,"breadcrumbs":5,"title":3},"226":{"body":6,"breadcrumbs":4,"title":2},"227":{"body":0,"breadcrumbs":8,"title":3},"228":{"body":9,"breadcrumbs":10,"title":5},"229":{"body":53,"breadcrumbs":11,"title":6},"23":{"body":278,"breadcrumbs":5,"title":1},"230":{"body":19,"breadcrumbs":7,"title":2},"231":{"body":46,"breadcrumbs":8,"title":4},"232":{"body":63,"breadcrumbs":6,"title":2},"233":{"body":100,"breadcrumbs":8,"title":4},"234":{"body":28,"breadcrumbs":6,"title":3},"235":{"body":48,"breadcrumbs":8,"title":5},"236":{"body":51,"breadcrumbs":8,"title":5},"237":{"body":29,"breadcrumbs":8,"title":5},"238":{"body":123,"breadcrumbs":6,"title":2},"239":{"body":18,"breadcrumbs":11,"title":7},"24":{"body":24,"breadcrumbs":7,"title":3},"240":{"body":28,"breadcrumbs":5,"title":1},"241":{"body":0,"breadcrumbs":9,"title":4},"242":{"body":31,"breadcrumbs":12,"title":7},"243":{"body":56,"breadcrumbs":7,"title":2},"244":{"body":114,"breadcrumbs":7,"title":2},"245":{"body":31,"breadcrumbs":13,"title":8},"246":{"body":26,"breadcrumbs":8,"title":3},"247":{"body":10,"breadcrumbs":10,"title":5},"248":{"body":15,"breadcrumbs":7,"title":2},"249":{"body":69,"breadcrumbs":10,"title":3},"25":{"body":65,"breadcrumbs":5,"title":1},"250":{"body":49,"breadcrumbs":10,"title":3},"251":{"body":0,"breadcrumbs":10,"title":3},"252":{"body":35,"breadcrumbs":11,"title":4},"253":{"body":35,"breadcrumbs":9,"title":2},"254":{"body":50,"breadcrumbs":10,"title":3},"255":{"body":21,"breadcrumbs":11,"title":4},"256":{"body":45,"breadcrumbs":11,"title":4},"257":{"body":12,"breadcrumbs":11,"title":4},"258":{"body":27,"breadcrumbs":14,"title":7},"259":{"body":60,"breadcrumbs":10,"title":3},"26":{"body":20,"breadcrumbs":7,"title":2},"260":{"body":13,"breadcrumbs":12,"title":5},"261":{"body":51,"breadcrumbs":11,"title":4},"262":{"body":20,"breadcrumbs":13,"title":7},"263":{"body":37,"breadcrumbs":8,"title":2},"264":{"body":75,"breadcrumbs":7,"title":1},"265":{"body":33,"breadcrumbs":8,"title":2},"266":{"body":22,"breadcrumbs":9,"title":3},"267":{"body":5,"breadcrumbs":8,"title":2},"268":{"body":0,"breadcrumbs":8,"title":2},"269":{"body":38,"breadcrumbs":9,"title":3},"27":{"body":58,"breadcrumbs":6,"title":1},"270":{"body":37,"breadcrumbs":9,"title":3},"271":{"body":27,"breadcrumbs":8,"title":2},"272":{"body":164,"breadcrumbs":7,"title":1},"273":{"body":8,"breadcrumbs":7,"title":1},"274":{"body":19,"breadcrumbs":6,"title":3},"275":{"body":27,"breadcrumbs":4,"title":1},"276":{"body":26,"breadcrumbs":5,"title":2},"277":{"body":0,"breadcrumbs":8,"title":4},"278":{"body":38,"breadcrumbs":9,"title":5},"279":{"body":15,"breadcrumbs":11,"title":7},"28":{"body":54,"breadcrumbs":6,"title":1},"280":{"body":9,"breadcrumbs":8,"title":4},"281":{"body":28,"breadcrumbs":7,"title":3},"282":{"body":5,"breadcrumbs":7,"title":3},"283":{"body":5,"breadcrumbs":7,"title":3},"284":{"body":27,"breadcrumbs":8,"title":3},"285":{"body":156,"breadcrumbs":8,"title":3},"286":{"body":91,"breadcrumbs":9,"title":4},"287":{"body":39,"breadcrumbs":12,"title":4},"288":{"body":280,"breadcrumbs":12,"title":4},"289":{"body":262,"breadcrumbs":12,"title":4},"29":{"body":31,"breadcrumbs":9,"title":4},"290":{"body":69,"breadcrumbs":10,"title":2},"291":{"body":28,"breadcrumbs":11,"title":3},"292":{"body":380,"breadcrumbs":11,"title":3},"293":{"body":425,"breadcrumbs":11,"title":3},"294":{"body":213,"breadcrumbs":11,"title":3},"295":{"body":508,"breadcrumbs":11,"title":3},"296":{"body":30,"breadcrumbs":11,"title":3},"297":{"body":216,"breadcrumbs":10,"title":2},"298":{"body":146,"breadcrumbs":10,"title":2},"299":{"body":180,"breadcrumbs":12,"title":4},"3":{"body":40,"breadcrumbs":4,"title":1},"30":{"body":500,"breadcrumbs":6,"title":1},"300":{"body":89,"breadcrumbs":7,"title":2},"301":{"body":39,"breadcrumbs":7,"title":1},"302":{"body":41,"breadcrumbs":14,"title":6},"303":{"body":56,"breadcrumbs":11,"title":3},"304":{"body":63,"breadcrumbs":7,"title":2},"305":{"body":13,"breadcrumbs":9,"title":3},"306":{"body":9,"breadcrumbs":7,"title":1},"307":{"body":16,"breadcrumbs":7,"title":1},"308":{"body":115,"breadcrumbs":7,"title":1},"309":{"body":39,"breadcrumbs":8,"title":2},"31":{"body":22,"breadcrumbs":8,"title":2},"310":{"body":42,"breadcrumbs":7,"title":1},"311":{"body":65,"breadcrumbs":7,"title":1},"312":{"body":111,"breadcrumbs":15,"title":6},"313":{"body":49,"breadcrumbs":9,"title":5},"314":{"body":33,"breadcrumbs":5,"title":1},"315":{"body":9,"breadcrumbs":5,"title":1},"32":{"body":49,"breadcrumbs":7,"title":1},"33":{"body":82,"breadcrumbs":7,"title":1},"34":{"body":19,"breadcrumbs":8,"title":2},"35":{"body":42,"breadcrumbs":7,"title":1},"36":{"body":171,"breadcrumbs":7,"title":1},"37":{"body":17,"breadcrumbs":5,"title":1},"38":{"body":46,"breadcrumbs":5,"title":1},"39":{"body":269,"breadcrumbs":5,"title":1},"4":{"body":24,"breadcrumbs":4,"title":1},"40":{"body":56,"breadcrumbs":5,"title":1},"41":{"body":15,"breadcrumbs":6,"title":2},"42":{"body":53,"breadcrumbs":5,"title":1},"43":{"body":255,"breadcrumbs":5,"title":1},"44":{"body":18,"breadcrumbs":6,"title":2},"45":{"body":54,"breadcrumbs":5,"title":1},"46":{"body":244,"breadcrumbs":5,"title":1},"47":{"body":24,"breadcrumbs":8,"title":3},"48":{"body":57,"breadcrumbs":6,"title":1},"49":{"body":237,"breadcrumbs":6,"title":1},"5":{"body":9,"breadcrumbs":4,"title":1},"50":{"body":28,"breadcrumbs":8,"title":4},"51":{"body":48,"breadcrumbs":5,"title":1},"52":{"body":152,"breadcrumbs":5,"title":1},"53":{"body":11,"breadcrumbs":8,"title":2},"54":{"body":56,"breadcrumbs":7,"title":1},"55":{"body":102,"breadcrumbs":7,"title":1},"56":{"body":22,"breadcrumbs":9,"title":3},"57":{"body":28,"breadcrumbs":8,"title":2},"58":{"body":59,"breadcrumbs":7,"title":1},"59":{"body":332,"breadcrumbs":7,"title":1},"6":{"body":84,"breadcrumbs":6,"title":3},"60":{"body":68,"breadcrumbs":7,"title":1},"61":{"body":59,"breadcrumbs":7,"title":1},"62":{"body":105,"breadcrumbs":7,"title":1},"63":{"body":41,"breadcrumbs":5,"title":2},"64":{"body":117,"breadcrumbs":5,"title":2},"65":{"body":73,"breadcrumbs":5,"title":2},"66":{"body":271,"breadcrumbs":4,"title":1},"67":{"body":45,"breadcrumbs":5,"title":2},"68":{"body":35,"breadcrumbs":7,"title":3},"69":{"body":42,"breadcrumbs":6,"title":2},"7":{"body":21,"breadcrumbs":4,"title":1},"70":{"body":19,"breadcrumbs":5,"title":1},"71":{"body":16,"breadcrumbs":6,"title":2},"72":{"body":42,"breadcrumbs":13,"title":7},"73":{"body":17,"breadcrumbs":7,"title":1},"74":{"body":36,"breadcrumbs":2,"title":1},"75":{"body":74,"breadcrumbs":5,"title":3},"76":{"body":77,"breadcrumbs":3,"title":1},"77":{"body":96,"breadcrumbs":4,"title":2},"78":{"body":52,"breadcrumbs":3,"title":1},"79":{"body":52,"breadcrumbs":4,"title":2},"8":{"body":164,"breadcrumbs":4,"title":1},"80":{"body":19,"breadcrumbs":3,"title":1},"81":{"body":13,"breadcrumbs":3,"title":1},"82":{"body":108,"breadcrumbs":5,"title":2},"83":{"body":58,"breadcrumbs":5,"title":2},"84":{"body":96,"breadcrumbs":4,"title":1},"85":{"body":119,"breadcrumbs":9,"title":5},"86":{"body":25,"breadcrumbs":6,"title":2},"87":{"body":31,"breadcrumbs":11,"title":6},"88":{"body":73,"breadcrumbs":8,"title":3},"89":{"body":156,"breadcrumbs":8,"title":3},"9":{"body":186,"breadcrumbs":7,"title":3},"90":{"body":63,"breadcrumbs":11,"title":6},"91":{"body":176,"breadcrumbs":8,"title":5},"92":{"body":107,"breadcrumbs":7,"title":4},"93":{"body":40,"breadcrumbs":7,"title":4},"94":{"body":39,"breadcrumbs":6,"title":3},"95":{"body":0,"breadcrumbs":9,"title":4},"96":{"body":129,"breadcrumbs":8,"title":3},"97":{"body":69,"breadcrumbs":12,"title":7},"98":{"body":15,"breadcrumbs":10,"title":6},"99":{"body":29,"breadcrumbs":6,"title":2}},"docs":{"0":{"body":"This book is about wasm-bindgen, a Rust library and CLI tool that facilitate high-level interactions between Wasm modules and JavaScript. The wasm-bindgen tool and crate are only one part of the Rust and WebAssembly ecosystem . If you're not familiar already with wasm-bindgen it's recommended to start by reading the Game of Life tutorial . If you're curious about wasm-pack, you can find that documentation here . The wasm-bindgen tool is sort of half polyfill for features like the component model proposal and half features for empowering high-level interactions between JS and wasm-compiled code (currently mostly from Rust). More specifically this project allows JS/wasm to communicate with strings, JS objects, classes, etc, as opposed to purely integers and floats. Using wasm-bindgen for example you can define a JS class in Rust or take a string from JS or return one. The functionality is growing as well! Currently this tool is Rust-focused but the underlying foundation is language-independent, and it's hoping that over time as this tool stabilizes that it can be used for languages like C/C++! Notable features of this project includes: Importing JS functionality in to Rust such as DOM manipulation , console logging , or performance monitoring . Exporting Rust functionality to JS such as classes, functions, etc. Working with rich types like strings, numbers, classes, closures, and objects rather than simply u32 and floats. Automatically generating TypeScript bindings for Rust code being consumed by JS. With the addition of wasm-pack you can run the gamut from running Rust on the web locally, publishing it as part of a larger application, or even publishing Rust-compiled-to-WebAssembly on NPM!","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"This subsection contains examples of using the wasm-bindgen, js-sys, and web-sys crates. Each example should have more information about what it's doing. These examples all assume familiarity with wasm-bindgen, wasm-pack, and building a Rust and WebAssembly project. If you're unfamiliar with these check out the Game of Life tutorial or wasm pack tutorials to help you get started. The source code for all examples can also be found online to download and run locally. Most examples are configured with Webpack/wasm-pack and can be built with npm run serve. Other examples which don't use Webpack are accompanied with instructions or a build.sh showing how to build it. Note that most examples currently use Webpack to assemble the final output artifact, but this is not required! You can review the deployment documentation for other options of how to deploy Rust and WebAssembly.","breadcrumbs":"Examples » Examples of using wasm-bindgen, js-sys, and web-sys","id":"1","title":"Examples of using wasm-bindgen, js-sys, and web-sys"},"10":{"body":"View full source code This example shows how the --target web flag can be used load code in a browser directly. For this deployment strategy bundlers like Webpack are not required. For more information on deployment see the dedicated documentation . First, you'll need to add web-sys to your Cargo.toml. [dependencies.web-sys]\nversion = \"0.3.4\"\nfeatures = [ 'Document', 'Element', 'HtmlElement', 'Node', 'Window',\n] Then, let's take a look at the code and see how when we're using --target web we're not actually losing any functionality! use wasm_bindgen::prelude::*; // Called when the Wasm module is instantiated\n#[wasm_bindgen(start)]\nfn main() -> Result<(), JsValue> { // Use `web_sys`'s global `window` function to get a handle on the global // window object. let window = web_sys::window().expect(\"no global `window` exists\"); let document = window.document().expect(\"should have a document on window\"); let body = document.body().expect(\"document should have a body\"); // Manufacture the element we're gonna append let val = document.create_element(\"p\")?; val.set_inner_html(\"Hello from Rust!\"); body.append_child(&val)?; Ok(())\n} #[wasm_bindgen]\npub fn add(a: u32, b: u32) -> u32 { a + b\n} Otherwise the rest of the deployment magic happens in index.html: <html> <head> <meta content=\"text/html;charset=utf-8\" http-equiv=\"Content-Type\"/> </head> <body> <!-- Note the usage of `type=module` here as this is an ES6 module --> <script type=\"module\"> // Use ES module import syntax to import functionality from the module // that we have compiled. // // Note that the `default` import is an initialization function which // will \"boot\" the module and make it ready to use. Currently browsers // don't support natively imported WebAssembly as an ES module, but // eventually the manual initialization won't be required! import init, { add } from './pkg/without_a_bundler.js'; async function run() { // First up we need to actually load the Wasm file, so we use the // default export to inform it where the Wasm file is located on the // server, and then we wait on the returned promise to wait for the // Wasm to be loaded. // // It may look like this: `await init('./pkg/without_a_bundler_bg.wasm');`, // but there is also a handy default inside `init` function, which uses // `import.meta` to locate the Wasm file relatively to js file. // // Note that instead of a string you can also pass in any of the // following things: // // * `WebAssembly.Module` // // * `ArrayBuffer` // // * `Response` // // * `Promise` which returns any of the above, e.g. `fetch(\"./path/to/wasm\")` // // This gives you complete control over how the module is loaded // and compiled. // // Also note that the promise, when resolved, yields the Wasm module's // exports which is the same as importing the `*_bg` module in other // modes await init(); // And afterwards we can use all the functionality defined in wasm. const result = add(1, 2); console.log(`1 + 2 = ${result}`); if (result !== 3) throw new Error(\"wasm addition doesn't work!\"); } run(); </script> </body>\n</html> Note : You cannot directly open index.html in your web browser due to CORS limitations. Instead, you can set up a quick development environment using Python's built-in HTTP server: wasm-pack build --target web\npython3 -m http.server 8080 If you don't have Python installed, you can also use miniserve which is installable via Cargo: cargo install miniserve\nminiserve . --index \"index.html\" -p 8080 And that's it! Be sure to read up on the deployment options to see what it means to deploy without a bundler.","breadcrumbs":"Examples » Without a Bundler » Without a Bundler","id":"10","title":"Without a Bundler"},"100":{"body":"Add #[derive(Serialize, Deserialize)] to your type. All of your type's members must also be supported by Serde, i.e. their types must also implement the Serialize and Deserialize traits. For example, let's say we'd like to pass this struct to JavaScript; doing so is not possible in wasm-bindgen normally due to the use of HashMaps, arrays, and nested Vecs. None of those types are supported for sending across the wasm ABI naively, but all of them implement Serde's Serialize and Deserialize. Note that we do not need to use the #[wasm_bindgen] macro. use serde::{Serialize, Deserialize}; #[derive(Serialize, Deserialize)]\npub struct Example { pub field1: HashMap<u32, String>, pub field2: Vec<Vec<f32>>, pub field3: [f32; 4],\n}","breadcrumbs":"Reference » Arbitrary Data with Serde » Derive the Serialize and Deserialize Traits","id":"100","title":"Derive the Serialize and Deserialize Traits"},"101":{"body":"Here's a function that will pass an Example to JavaScript by serializing it to JsValue: #[wasm_bindgen]\npub fn send_example_to_js() -> JsValue { let mut field1 = HashMap::new(); field1.insert(0, String::from(\"ex\")); let example = Example { field1, field2: vec![vec![1., 2.], vec![3., 4.]], field3: [1., 2., 3., 4.] }; serde_wasm_bindgen::to_value(&example).unwrap()\n}","breadcrumbs":"Reference » Arbitrary Data with Serde » Send it to JavaScript with serde_wasm_bindgen::to_value","id":"101","title":"Send it to JavaScript with serde_wasm_bindgen::to_value"},"102":{"body":"Here's a function that will receive a JsValue parameter from JavaScript and then deserialize an Example from it: #[wasm_bindgen]\npub fn receive_example_from_js(val: JsValue) { let example: Example = serde_wasm_bindgen::from_value(val).unwrap(); ...\n}","breadcrumbs":"Reference » Arbitrary Data with Serde » Receive it from JavaScript with serde_wasm_bindgen::from_value","id":"102","title":"Receive it from JavaScript with serde_wasm_bindgen::from_value"},"103":{"body":"In the JsValue that JavaScript gets, field1 will be a Map, field2 will be a JavaScript Array whose members are Arrays of numbers, and field3 will be an Array of numbers. import { send_example_to_js, receive_example_from_js } from \"example\"; // Get the example object from wasm.\nlet example = send_example_to_js(); // Add another \"Vec\" element to the end of the \"Vec<Vec<f32>>\"\nexample.field2.push([5, 6]); // Send the example object back to wasm.\nreceive_example_from_js(example);","breadcrumbs":"Reference » Arbitrary Data with Serde » JavaScript Usage","id":"103","title":"JavaScript Usage"},"104":{"body":"serde-wasm-bindgen works by directly manipulating JavaScript values. This requires a lot of calls back and forth between Rust and JavaScript, which can sometimes be slow. An alternative way of doing this is to serialize values to JSON, and then parse them on the other end. Browsers' JSON implementations are usually quite fast, and so this approach can outstrip serde-wasm-bindgen's performance in some cases. But this approach supports only types that can be serialized as JSON, leaving out some important types that serde-wasm-bindgen supports such as Map, Set, and array buffers. That's not to say that using JSON is always faster, though - the JSON approach can be anywhere from 2x to 0.2x the speed of serde-wasm-bindgen, depending on the JS runtime and the values being passed. It also leads to larger code size than serde-wasm-bindgen. So, make sure to profile each for your own use cases. This approach is implemented in gloo_utils::format::JsValueSerdeExt : # Cargo.toml\n[dependencies]\ngloo-utils = { version = \"0.1\", features = [\"serde\"] } use gloo_utils::format::JsValueSerdeExt; #[wasm_bindgen]\npub fn send_example_to_js() -> JsValue { let mut field1 = HashMap::new(); field1.insert(0, String::from(\"ex\")); let example = Example { field1, field2: vec![vec![1., 2.], vec![3., 4.]], field3: [1., 2., 3., 4.] }; JsValue::from_serde(&example).unwrap()\n} #[wasm_bindgen]\npub fn receive_example_from_js(val: JsValue) { let example: Example = val.into_serde().unwrap(); ...\n}","breadcrumbs":"Reference » Arbitrary Data with Serde » An alternative approach - using JSON","id":"104","title":"An alternative approach - using JSON"},"105":{"body":"In previous versions of wasm-bindgen, gloo-utils's JSON-based Serde support (JsValue::from_serde and JsValue::into_serde) was built into wasm-bindgen itself. However, this required a dependency on serde_json, which had a problem: with certain features of serde_json and other crates enabled, serde_json would end up with a circular dependency on wasm-bindgen, which is illegal in Rust and caused people's code to fail to compile. So, these methods were extracted out into gloo-utils with an extension trait and the originals were deprecated.","breadcrumbs":"Reference » Arbitrary Data with Serde » History","id":"105","title":"History"},"106":{"body":"To read and write arbitrary properties from any untyped JavaScript value regardless if it is an instanceof some JavaScript class or not, use the js_sys::Reflect APIs . These APIs are bindings to the JavaScript builtin Reflect object and its methods. You might also benefit from using duck-typed interfaces instead of working with untyped values.","breadcrumbs":"Reference » Accessing Properties of Untyped JS Values » Accessing Properties of Untyped JavaScript Values","id":"106","title":"Accessing Properties of Untyped JavaScript Values"},"107":{"body":"API documentation for js_sys::Reflect::get. A function that returns the value of a property. Rust Usage let value = js_sys::Reflect::get(&target, &property_key)?; JavaScript Equivalent let value = target[property_key];","breadcrumbs":"Reference » Accessing Properties of Untyped JS Values » Reading Properties with js_sys::Reflect::get","id":"107","title":"Reading Properties with js_sys::Reflect::get"},"108":{"body":"API documentation for js_sys::Reflect::set. A function that assigns a value to a property. Returns a boolean that is true if the update was successful. Rust Usage js_sys::Reflect::set(&target, &property_key, &value)?; JavaScript Equivalent target[property_key] = value;","breadcrumbs":"Reference » Accessing Properties of Untyped JS Values » Writing Properties with js_sys::Reflect::set","id":"108","title":"Writing Properties with js_sys::Reflect::set"},"109":{"body":"API documentation for js_sys::Reflect::has. The JavaScript in operator as function. Returns a boolean indicating whether an own or inherited property exists on the target. Rust Usage if js_sys::Reflect::has(&target, &property_key)? { // ...\n} else { // ...\n} JavaScript Equivalent if (property_key in target) { // ...\n} else { // ...\n}","breadcrumbs":"Reference » Accessing Properties of Untyped JS Values » Determining if a Property Exists with js_sys::Reflect::has","id":"109","title":"Determining if a Property Exists with js_sys::Reflect::has"},"11":{"body":"View full source code The older version of using wasm-bindgen without a bundler is to use the --target no-modules flag to the wasm-bindgen CLI. While similar to the newer --target web, the --target no-modules flag has a few caveats: It does not support local JS snippets It does not generate an ES module It does not support --split-linked-modules outside of a document, e.g. inside a worker With that in mind the main difference is how the wasm/JS code is loaded, and here's an example of loading the output of wasm-pack for the same module as above. <html> <head> <meta content=\"text/html;charset=utf-8\" http-equiv=\"Content-Type\"/> </head> <body> <!-- Include the JS generated by `wasm-pack build` --> <script src='pkg/without_a_bundler_no_modules.js'></script> <script> // Like with the `--target web` output the exports are immediately // available but they won't work until we initialize the module. Unlike // `--target web`, however, the globals are all stored on a // `wasm_bindgen` global. The global itself is the initialization // function and then the properties of the global are all the exported // functions. // // Note that the name `wasm_bindgen` can be configured with the // `--no-modules-global` CLI flag const { add } = wasm_bindgen; async function run() { await wasm_bindgen(); const result = add(1, 2); console.log(`1 + 2 = ${result}`); } run(); </script> </body>\n</html>","breadcrumbs":"Examples » Without a Bundler » Using the older --target no-modules","id":"11","title":"Using the older --target no-modules"},"110":{"body":"See the js_sys::Reflect API documentation for the full listing of JavaScript value reflection and introspection capabilities.","breadcrumbs":"Reference » Accessing Properties of Untyped JS Values » But wait — there's more!","id":"110","title":"But wait — there's more!"},"111":{"body":"Liberal use of the structural attribute on imported methods, getters, and setters allows you to define duck-typed interfaces. A duck-typed interface is one where many different JavaScript objects that don't share the same base class in their prototype chain and therefore are not instanceof the same base can be used the same way.","breadcrumbs":"Reference » Working with Duck-Typed Interfaces » Working with Duck-Typed Interfaces","id":"111","title":"Working with Duck-Typed Interfaces"},"112":{"body":"use wasm_bindgen::prelude::*; /// Here is a duck-typed interface for any JavaScript object that has a `quack`\n/// method.\n///\n/// Note that any attempts to check if an object is a `Quacks` with\n/// `JsCast::is_instance_of` (i.e. the `instanceof` operator) will fail because\n/// there is no JS class named `Quacks`.\n#[wasm_bindgen]\nextern \"C\" { pub type Quacks; #[wasm_bindgen(structural, method)] pub fn quack(this: &Quacks) -> String;\n} /// Next, we can export a function that takes any object that quacks:\n#[wasm_bindgen]\npub fn make_em_quack_to_this(duck: &Quacks) { let _s = duck.quack(); // ...\n}","breadcrumbs":"Reference » Working with Duck-Typed Interfaces » Defining a Duck-Typed Interface in Rust","id":"112","title":"Defining a Duck-Typed Interface in Rust"},"113":{"body":"import { make_em_quack_to_this } from \"./rust_duck_typed_interfaces\"; // All of these objects implement the `Quacks` interface! const alex = { quack: () => \"you're not wrong...\"\n}; const ashley = { quack: () => \"<corgi.gif>\"\n}; const nick = { quack: () => \"rappers I monkey-flip em with the funky rhythm I be kickin\"\n}; // Get all our ducks in a row and call into wasm! make_em_quack_to_this(alex);\nmake_em_quack_to_this(ashley);\nmake_em_quack_to_this(nick);","breadcrumbs":"Reference » Working with Duck-Typed Interfaces » JavaScript Usage","id":"113","title":"JavaScript Usage"},"114":{"body":"The wasm-bindgen command line tool has a number of options available to it to tweak the JavaScript that is generated. The most up-to-date set of flags can always be listed via wasm-bindgen --help.","breadcrumbs":"Reference » Command Line Interface » The wasm-bindgen Command Line Interface","id":"114","title":"The wasm-bindgen Command Line Interface"},"115":{"body":"cargo install -f wasm-bindgen-cli","breadcrumbs":"Reference » Command Line Interface » Installation","id":"115","title":"Installation"},"116":{"body":"wasm-bindgen [options] ./target/wasm32-unknown-unknown/release/crate.wasm","breadcrumbs":"Reference » Command Line Interface » Usage","id":"116","title":"Usage"},"117":{"body":"","breadcrumbs":"Reference » Command Line Interface » Options","id":"117","title":"Options"},"118":{"body":"The target directory to emit the JavaScript bindings, TypeScript definitions, processed .wasm binary, etc...","breadcrumbs":"Reference » Command Line Interface » --out-dir DIR","id":"118","title":"--out-dir DIR"},"119":{"body":"This flag indicates what flavor of output what wasm-bindgen should generate. For example it could generate code to be loaded in a bundler like Webpack, a native web page, or Node.js. For a full list of options to pass this flag, see the section on deployment","breadcrumbs":"Reference » Command Line Interface » --target","id":"119","title":"--target"},"12":{"body":"View full source code This example shows how to synchronously initialize a WebAssembly module as opposed to asynchronously . In most cases, the default way of asynchronously initializing a module will suffice. However, there might be use cases where you'd like to lazy load a module on demand and synchronously compile and instantiate it. Note that this only works off the main thread and since compilation and instantiation of large modules can be expensive you should only use this method if it's absolutely required in your use case. Otherwise you should use the default method . For this deployment strategy bundlers like Webpack are not required. For more information on deployment see the dedicated documentation . First let's take a look at our tiny lib: use wasm_bindgen::prelude::*; #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(value: &str);\n} #[wasm_bindgen]\npub fn greet(name: &str) { log(&format!(\"Hello, {}!\", name));\n} Next, let's have a look at the index.html: <!DOCTYPE html>\n<html lang=\"en\"> <head> <meta charset=\"UTF-8\" /> <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" /> <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" /> <title>Document</title> </head> <body> <script> /** * First off we spawn a Web Worker. That's where our lib will be used. Note that * we set the `type` to `module` to enable support for ES modules. */ const worker = new Worker(\"/worker.js\", { type: \"module\" }); /** * Here we listen for messages from the worker. */ worker.onmessage = ({ data }) => { const { type } = data; switch (type) { case \"FETCH_WASM\": { /** * The worker wants to fetch the bytes for the module and for that we can use the `fetch` API. * Then we convert the response into an `ArrayBuffer` and transfer the bytes back to the worker. * * @see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API * @see https://developer.mozilla.org/en-US/docs/Glossary/Transferable_objects */ fetch(\"/pkg/synchronous_instantiation_bg.wasm\") .then((response) => response.arrayBuffer()) .then((bytes) => { worker.postMessage(bytes, [bytes]); }); break; } default: { break; } } }; </script> </body>\n</html> Otherwise the rest of the magic happens in worker.js: import * as wasm from \"./pkg/synchronous_instantiation.js\"; self.onmessage = ({ data: bytes }) => { /** * When we receive the bytes as an `ArrayBuffer` we can use that to * synchronously initialize the module as opposed to asynchronously * via the default export. The synchronous method internally uses * `new WebAssembly.Module()` and `new WebAssembly.Instance()`. */ wasm.initSync({ module: bytes }); /** * Once initialized we can call our exported `greet()` functions. */ wasm.greet(\"Dominic\");\n}; /** * Once the Web Worker was spawned we ask the main thread to fetch the bytes * for the WebAssembly module. Once fetched it will send the bytes back via * a `postMessage` (see above). */\nself.postMessage({ type: \"FETCH_WASM\" }); And that's it! Be sure to read up on the deployment options to see what it means to deploy without a bundler.","breadcrumbs":"Examples » Synchronous Instantiation » Synchronous Instantiation","id":"12","title":"Synchronous Instantiation"},"120":{"body":"When --target no-modules is used this flag can indicate what the name of the global to assign generated bindings to. For more information about this see the section on deployment","breadcrumbs":"Reference » Command Line Interface » --no-modules-global VAR","id":"120","title":"--no-modules-global VAR"},"121":{"body":"Output a TypeScript declaration file for the generated JavaScript bindings. This is on by default.","breadcrumbs":"Reference » Command Line Interface » --typescript","id":"121","title":"--typescript"},"122":{"body":"By default, a *.d.ts TypeScript declaration file is generated for the generated JavaScript bindings, but this flag will disable that.","breadcrumbs":"Reference » Command Line Interface » --no-typescript","id":"122","title":"--no-typescript"},"123":{"body":"When the module attribute is used with the wasm-bindgen macro, the code generator will emit corresponding import or require statements in the header section of the generated javascript. This flag causes those import statements to be omitted. This is necessary for some use cases, such as generating javascript which is intended to be used with Electron (with node integration disabled), where the imports are instead handled through a separate preload script.","breadcrumbs":"Reference » Command Line Interface » --omit-imports","id":"123","title":"--omit-imports"},"124":{"body":"Generates a bit more JS and Wasm in \"debug mode\" to help catch programmer errors, but this output isn't intended to be shipped to production.","breadcrumbs":"Reference » Command Line Interface » --debug","id":"124","title":"--debug"},"125":{"body":"When post-processing the .wasm binary, do not demangle Rust symbols in the \"names\" custom section.","breadcrumbs":"Reference » Command Line Interface » --no-demangle","id":"125","title":"--no-demangle"},"126":{"body":"When post-processing the .wasm binary, do not remove exports that are synthesized by Rust's linker, LLD.","breadcrumbs":"Reference » Command Line Interface » --keep-lld-exports","id":"126","title":"--keep-lld-exports"},"127":{"body":"When post-processing the .wasm binary, do not strip DWARF debug info custom sections.","breadcrumbs":"Reference » Command Line Interface » --keep-debug","id":"127","title":"--keep-debug"},"128":{"body":"When generating bundler-compatible code (see the section on deployment ) this indicates that the bundled code is always intended to go into a browser so a few checks for Node.js can be elided.","breadcrumbs":"Reference » Command Line Interface » --browser","id":"128","title":"--browser"},"129":{"body":"Don't add WebAssembly fallback imports in generated JavaScript.","breadcrumbs":"Reference » Command Line Interface » --omit-default-module-path","id":"129","title":"--omit-default-module-path"},"13":{"body":"View full source code or view the compiled example online The #[wasm_bindgen] attribute can be used on extern \"C\" { .. } blocks to import functionality from JS. This is how the js-sys and the web-sys crates are built, but you can also use it in your own crate! For example if you're working with this JS file: // defined-in-js.js\nexport function name() { return 'Rust';\n} export class MyClass { constructor() { this._number = 42; } get number() { return this._number; } set number(n) { return this._number = n; } render() { return `My number is: ${this.number}`; }\n} you can use it in Rust with: use wasm_bindgen::prelude::*; #[wasm_bindgen(module = \"/defined-in-js.js\")]\nextern \"C\" { fn name() -> String; type MyClass; #[wasm_bindgen(constructor)] fn new() -> MyClass; #[wasm_bindgen(method, getter)] fn number(this: &MyClass) -> u32; #[wasm_bindgen(method, setter)] fn set_number(this: &MyClass, number: u32) -> MyClass; #[wasm_bindgen(method)] fn render(this: &MyClass) -> String;\n} // lifted from the `console_log` example\n#[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str);\n} #[wasm_bindgen(start)]\nfn run() { log(&format!(\"Hello from {}!\", name())); // should output \"Hello from Rust!\" let x = MyClass::new(); assert_eq!(x.number(), 42); x.set_number(10); log(&x.render());\n} You can also explore the full list of ways to configure imports","breadcrumbs":"Examples » Importing functions from JS » Importing non-browser JS","id":"13","title":"Importing non-browser JS"},"130":{"body":"Controls whether wasm-bindgen will split linked modules out into their own files. Enabling this is recommended, because it allows lazy-loading the linked modules and setting a stricter Content Security Policy. wasm-bindgen uses the new URL('…', import.meta.url) syntax to resolve the links to such split out files. This breaks with most bundlers, since the bundler doesn't know to include the linked module in its output. That's why this option is disabled by default. Webpack 5 is an exception, which has special treatment for that syntax. For other bundlers, you'll need to take extra steps to get it to work, likely by using a plugin. Alternatively, you can leave the syntax as is and instead manually configure the bundler to copy all files in snippets/ to the output directory, preserving their paths relative to whichever bundled file ends up containing the JS shim. On the no-modules target, link_to! won't work if used outside of a document, e.g. inside a worker. This is because it's impossible to figure out what the URL of the linked module is without a reference point like import.meta.url.","breadcrumbs":"Reference » Command Line Interface » --split-linked-modules","id":"130","title":"--split-linked-modules"},"131":{"body":"The Rust and WebAssembly Working Group's Game of Life tutorial has an excellent section on shrinking Wasm code size , but there's a few wasm-bindgen-specific items to mention as well! First and foremost, wasm-bindgen is designed to be lightweight and a \"pay only for what you use\" mentality. If you suspect that wasm-bindgen is bloating your program that is a bug and we'd like to know about it! Please feel free to file an issue , even if it's a question!","breadcrumbs":"Reference » Optimizing for Size » Optimizing for Size with wasm-bindgen","id":"131","title":"Optimizing for Size with wasm-bindgen"},"132":{"body":"With wasm-bindgen there's a few different files to be measuring the size of. The first of which is the output of the compiler itself, typically at target/wasm32-unknown-unknown/release/foo.wasm. This file is not optimized for size and you should not measure it. The output of the compiler when linking with wasm-bindgen is by design larger than it needs to be, the wasm-bindgen CLI tool will automatically strip all unneeded functionality out of the binary. This leaves us with two primary generated files to measure the size of: Generated wasm - after running the wasm-bindgen CLI tool you'll get a file in --out-dir that looks like foo_bg.wasm. This file is the final fully-finished artifact from wasm-bindgen, and it reflects the size of the app you'll be publishing. All the optimizations mentioned in the code size tutorial will help reduce the size of this binary, so feel free to go crazy! Generated JS - the other file after running wasm-bindgen is a foo.js file which is what's actually imported by other JS code. This file is already generated to be as small as possible (not including unneeded functionality). The JS, however, is not uglified or minified, but rather still human readable and debuggable. It's expected that you'll run an uglifier or bundler of the JS output to minimize it further in your application. If you spot a way we could reduce the output JS size further (or make it more amenable to bundler minification), please let us know!","breadcrumbs":"Reference » Optimizing for Size » What to profile","id":"132","title":"What to profile"},"133":{"body":"As an example, the wasm-bindgen repository contains an example about generating small Wasm binaries and shows off how to generate a small wasm file for adding two numbers.","breadcrumbs":"Reference » Optimizing for Size » Example","id":"133","title":"Example"},"134":{"body":"Note : This section is about Rust target triples, not targets like node/web workers/browsers. More information on that coming soon! The wasm-bindgen project is designed to target the wasm32-unknown-unknown target in Rust. This target is a \"bare bones\" target for Rust which emits WebAssembly as output. The standard library is largely inert as modules like std::fs and std::net will simply return errors.","breadcrumbs":"Reference » Supported Rust Targets » Supported Rust Targets","id":"134","title":"Supported Rust Targets"},"135":{"body":"Note that wasm-bindgen also aims to compile on all targets. This means that it should be safe, if you like, to use #[wasm_bindgen] even when compiling for Windows (for example). For example: #[wasm_bindgen]\npub fn add(a: u32, b: u32) -> u32 { a + b\n} #[cfg(not(target_arch = \"wasm32\"))]\nfn main() { println!(\"1 + 2 = {}\", add(1, 2));\n} This program will compile and work on all platforms, not just wasm32-unknown-unknown. Note that imported functions with #[wasm_bindgen] will unconditionally panic on non-wasm targets. For example: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str);\n} fn main() { log(\"hello!\");\n} This program will unconditionally panic on all platforms other than wasm32-unknown-unknown. For better compile times, however, you likely want to only use #[wasm_bindgen] on the wasm32-unknown-unknown target. You can have a target-specific dependency like so: [target.'cfg(target_arch = \"wasm32\")'.dependencies]\nwasm-bindgen = \"0.2\" And in your code you can use: #[cfg(target_arch = \"wasm32\")]\n#[wasm_bindgen]\npub fn only_on_the_wasm_target() { // ...\n}","breadcrumbs":"Reference » Supported Rust Targets » Non-wasm targets","id":"135","title":"Non-wasm targets"},"136":{"body":"The wasm-bindgen target does not support the wasm32-unknown-emscripten nor the asmjs-unknown-emscripten targets. There are currently no plans to support these targets either. All annotations work like other platforms on the targets, retaining exported functions and causing all imports to panic.","breadcrumbs":"Reference » Supported Rust Targets » Other Web Targets","id":"136","title":"Other Web Targets"},"137":{"body":"The output of wasm-bindgen includes a JS file, and as a result it's good to know what browsers that file is expected to be used in! By default the output uses ES modules with Wasm imports which isn't implemented in browsers today, but when using a bundler (like Webpack) or --target web you should be able to produce output suitable for all browsers. Firefox, Chrome, Safari, and Edge browsers are all supported by wasm-bindgen. If you find a problem in one of these browsers please report it as we'd like to fix the bug! If you find a bug in another browser we would also like to be aware of it!","breadcrumbs":"Reference » Supported Browsers » Supported Browsers","id":"137","title":"Supported Browsers"},"138":{"body":"IE 11 - wasm-bindgen by default requires support for WebAssembly, but no version of IE currently supports WebAssembly. You can support IE by compiling Wasm files to JS using wasm2js . Note that at this time no bundler will do this by default, but we'd love to document plugins which do this if you are aware of one! If you find other incompatibilities please report them to us! We'd love to either keep this list up-to-date or fix the underlying bugs :)","breadcrumbs":"Reference » Supported Browsers » Caveats","id":"138","title":"Caveats"},"139":{"body":"By default wasm-bindgen does use the TC39 weak references proposal if support is detected. At the time of this writing all major browsers do support it. Without weak references your JS integration may be susceptible to memory leaks in Rust, for example: You could forget to call .free() on a JS object, leaving the Rust memory allocated. Rust closures converted to JS values (the Closure type) may not be executed and cleaned up. Rust closures have Closure::{into_js_value,forget} methods which explicitly do not free the underlying memory. These issues are all solved with the weak references proposal in JS. FinalizationRegistry will ensure that all memory is cleaned up, regardless of whether it's explicitly deallocated or not. Note that explicit deallocation is always a possibility and supported, but if it's not called then memory will still be automatically deallocated if FinalizationRegistry support is detected.","breadcrumbs":"Reference » Support for Weak References » Support for Weak References","id":"139","title":"Support for Weak References"},"14":{"body":"View full source code or view the compiled example online The #[wasm_bindgen] macro will convert the rust char type to a single code-point js string, and this example shows how to work with this. Opening this example should display a single counter with a random character for it's key and 0 for its count. You can click the + button to increase a counter's count. By clicking on the \"add counter\" button you should see a new counter added to the list with a different random character for it's key. Under the hood javascript is choosing a random character from an Array of characters and passing that to the rust Counter struct's constructor so the character you are seeing on the page has made the full round trip from js to rust and back to js.","breadcrumbs":"Examples » Working with char » Working with the char type","id":"14","title":"Working with the char type"},"140":{"body":"WebAssembly recently has gained support for a new value type called externref. Proposed in the WebAssembly reference types repo this feature of WebAssembly is hoped to enable more efficient communication between the host (JS) and the Wasm module. This feature removes the need for much of the JS glue generated by wasm-bindgen because it can natively call APIs with JS values. For example, this Rust function: #[wasm_bindgen]\npub fn takes_js_value(a: &JsValue) { // ...\n} generates this JS glue without reference types support: const heap = new Array(32).fill(undefined); heap.push(undefined, null, true, false); let stack_pointer = 32; function addBorrowedObject(obj) { if (stack_pointer == 1) throw new Error('out of js stack'); heap[--stack_pointer] = obj; return stack_pointer;\n} export function takes_js_value(a) { try { wasm.takes_js_value(addBorrowedObject(a)); } finally { heap[stack_pointer++] = undefined; }\n} We can see here how under the hood the JS is managing a table of JS values which are passed to the Wasm binary, so Wasm actually only works in indices. If we compile with -Ctarget-feature=+reference-types (by default since Rust v1.82), however, the generated JS looks like: export function takes_js_value(a) { wasm.takes_js_value(a);\n} And that's it! The WebAssembly binary takes the JS value directly and manages it internally. Currently this feature is supported in Firefox 79+ and Chrome. Support in other browsers is likely coming soon! In Node.js this feature is behind the --experimental-wasm-anyref flag, although the support does not currently align with the upstream specification as of 14.6.0.","breadcrumbs":"Reference » Support for Reference Types » Support for Reference Types","id":"140","title":"Support for Reference Types"},"141":{"body":"This section provides an overview of all the types that wasm-bindgen can send and receive across the WebAssembly ABI boundary, and how they translate into JavaScript.","breadcrumbs":"Reference » Supported Types » Supported Rust Types and their JavaScript Representations","id":"141","title":"Supported Rust Types and their JavaScript Representations"},"142":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes Yes No Yes Yes Yes Instances of the extern Whatever JavaScript class / prototype constructor","breadcrumbs":"Reference » Supported Types » Imported JavaScript Types » Imported extern Whatever; JavaScript Types","id":"142","title":"Imported extern Whatever; JavaScript Types"},"143":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\n#[derive(Copy, Clone, Debug)]\npub enum NumberEnum { Foo = 0, Bar = 1, Qux = 2,\n} #[wasm_bindgen]\n#[derive(Copy, Clone, Debug)]\npub enum StringEnum { Foo = \"foo\", Bar = \"bar\", Qux = \"qux\",\n} #[wasm_bindgen]\npub struct Struct { pub number: NumberEnum, pub string: StringEnum,\n} #[wasm_bindgen]\nextern \"C\" { pub type SomeJsType;\n} #[wasm_bindgen]\npub fn imported_type_by_value(x: SomeJsType) { /* ... */\n} #[wasm_bindgen]\npub fn imported_type_by_shared_ref(x: &SomeJsType) { /* ... */\n} #[wasm_bindgen]\npub fn return_imported_type() -> SomeJsType { unimplemented!()\n} #[wasm_bindgen]\npub fn take_option_imported_type(x: Option<SomeJsType>) { /* ... */\n} #[wasm_bindgen]\npub fn return_option_imported_type() -> Option<SomeJsType> { unimplemented!()\n}","breadcrumbs":"Reference » Supported Types » Imported JavaScript Types » Example Rust Usage","id":"143","title":"Example Rust Usage"},"144":{"body":"import { imported_type_by_value, imported_type_by_shared_ref, return_imported_type, take_option_imported_type, return_option_imported_type,\n} from './guide_supported_types_examples'; imported_type_by_value(new SomeJsType());\nimported_type_by_shared_ref(new SomeJsType()); let x = return_imported_type();\nconsole.log(x instanceof SomeJsType); // true take_option_imported_type(null);\ntake_option_imported_type(undefined);\ntake_option_imported_type(new SomeJsType()); let y = return_option_imported_type();\nif (y == null) { // ...\n} else { console.log(y instanceof SomeJsType); // true\n}","breadcrumbs":"Reference » Supported Types » Imported JavaScript Types » Example JavaScript Usage","id":"144","title":"Example JavaScript Usage"},"145":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes Yes Yes Yes Yes Yes Instances of a wasm-bindgen-generated JavaScript class Whatever { ... } Note : Public fields implementing Copy have automatically generated getters/setters. To generate getters/setters for non-Copy public fields, use #[wasm_bindgen(getter_with_clone)] for the struct or implement getters/setters manually .","breadcrumbs":"Reference » Supported Types » Exported Rust Types » Exported struct Whatever Rust Types","id":"145","title":"Exported struct Whatever Rust Types"},"146":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub struct ExportedNamedStruct { // pub value: String, // This won't work. See working example below. pub inner: u32,\n} #[wasm_bindgen(getter_with_clone)]\npub struct ExportedNamedStructNonCopy { pub non_copy_value: String, pub copy_value: u32,\n} #[wasm_bindgen]\npub fn named_struct_by_value(x: ExportedNamedStruct) {} #[wasm_bindgen]\npub fn named_struct_by_shared_ref(x: &ExportedNamedStruct) {} #[wasm_bindgen]\npub fn named_struct_by_exclusive_ref(x: &mut ExportedNamedStruct) {} #[wasm_bindgen]\npub fn return_named_struct(inner: u32) -> ExportedNamedStruct { ExportedNamedStruct { inner }\n} #[wasm_bindgen]\npub fn named_struct_by_optional_value(x: Option<ExportedNamedStruct>) {} #[wasm_bindgen]\npub fn return_optional_named_struct(inner: u32) -> Option<ExportedNamedStruct> { Some(ExportedNamedStruct { inner })\n} #[wasm_bindgen]\npub struct ExportedTupleStruct(pub u32, pub u32); #[wasm_bindgen]\npub fn return_tuple_struct(x: u32, y: u32) -> ExportedTupleStruct { ExportedTupleStruct(x, y)\n}","breadcrumbs":"Reference » Supported Types » Exported Rust Types » Example Rust Usage","id":"146","title":"Example Rust Usage"},"147":{"body":"import { ExportedNamedStruct, named_struct_by_value, named_struct_by_shared_ref, named_struct_by_exclusive_ref, return_named_struct, named_struct_by_optional_value, return_optional_named_struct, ExportedTupleStruct, return_tuple_struct\n} from './guide_supported_types_examples'; let namedStruct = return_named_struct(42);\nconsole.log(namedStruct instanceof ExportedNamedStruct); // true\nconsole.log(namedStruct.inner); // 42 named_struct_by_shared_ref(namedStruct);\nnamed_struct_by_exclusive_ref(namedStruct);\nnamed_struct_by_value(namedStruct); let optionalNamedStruct = return_optional_named_struct(42);\nnamed_struct_by_optional_value(optionalNamedStruct); let tupleStruct = return_tuple_struct(10, 20);\nconsole.log(tupleStruct instanceof ExportedTupleStruct); // true\nconsole.log(tupleStruct[0], tupleStruct[1]); // 10, 20","breadcrumbs":"Reference » Supported Types » Exported Rust Types » Example JavaScript Usage","id":"147","title":"Example JavaScript Usage"},"148":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes Yes No Yes No No Any JavaScript value","breadcrumbs":"Reference » Supported Types » JsValue » JsValue","id":"148","title":"JsValue"},"149":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_js_value_by_value(x: JsValue) {} #[wasm_bindgen]\npub fn take_js_value_by_shared_ref(x: &JsValue) {} #[wasm_bindgen]\npub fn return_js_value() -> JsValue { JsValue::NULL\n}","breadcrumbs":"Reference » Supported Types » JsValue » Example Rust Usage","id":"149","title":"Example Rust Usage"},"15":{"body":"use wasm_bindgen::prelude::*; // lifted from the `console_log` example\n#[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str);\n} #[wasm_bindgen]\n#[derive(Debug)]\npub struct Counter { key: char, count: i32,\n} #[wasm_bindgen]\nimpl Counter { pub fn new(key: char, count: i32) -> Counter { log(&format!(\"Counter::new({}, {})\", key, count)); Counter { key, count } } pub fn key(&self) -> char { log(\"Counter.key()\"); self.key } pub fn count(&self) -> i32 { log(\"Counter.count\"); self.count } pub fn increment(&mut self) { log(\"Counter.increment\"); self.count += 1; } pub fn update_key(&mut self, key: char) { self.key = key; }\n}","breadcrumbs":"Examples » Working with char » src/lib.rs","id":"15","title":"src/lib.rs"},"150":{"body":"import { take_js_value_by_value, take_js_value_by_shared_ref, return_js_value,\n} from './guide_supported_types_examples'; take_js_value_by_value(42);\ntake_js_value_by_shared_ref('hello'); let v = return_js_value();","breadcrumbs":"Reference » Supported Types » JsValue » Example JavaScript Usage","id":"150","title":"Example JavaScript Usage"},"151":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript Array object You can pass boxed slices and Vecs of several different types to and from JS: JsValues. Imported JavaScript types. Exported Rust types. Strings. You can also pass boxed slices of numbers to JS , except that they're converted to typed arrays (Uint8Array, Int32Array, etc.) instead of regular arrays.","breadcrumbs":"Reference » Supported Types » Box<[T]> and Vec<T> » Box<[T]> and Vec<T>","id":"151","title":"Box<[T]> and Vec<T>"},"152":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_boxed_js_value_slice_by_value(x: Box<[JsValue]>) {} #[wasm_bindgen]\npub fn return_boxed_js_value_slice() -> Box<[JsValue]> { vec![JsValue::NULL, JsValue::UNDEFINED].into_boxed_slice()\n} #[wasm_bindgen]\npub fn take_option_boxed_js_value_slice(x: Option<Box<[JsValue]>>) {} #[wasm_bindgen]\npub fn return_option_boxed_js_value_slice() -> Option<Box<[JsValue]>> { None\n}","breadcrumbs":"Reference » Supported Types » Box<[T]> and Vec<T> » Example Rust Usage","id":"152","title":"Example Rust Usage"},"153":{"body":"import { take_boxed_js_value_slice_by_value, return_boxed_js_value_slice, take_option_boxed_js_value_slice, return_option_boxed_js_value_slice,\n} from './guide_supported_types_examples'; take_boxed_js_value_slice_by_value([null, true, 2, {}, []]); let values = return_boxed_js_value_slice();\nconsole.log(values instanceof Array); // true take_option_boxed_js_value_slice(null);\ntake_option_boxed_js_value_slice(undefined);\ntake_option_boxed_js_value_slice([1, 2, 3]); let maybeValues = return_option_boxed_js_value_slice();\nif (maybeValues == null) { // ...\n} else { console.log(maybeValues instanceof Array); // true\n}","breadcrumbs":"Reference » Supported Types » Box<[T]> and Vec<T> » Example JavaScript Usage","id":"153","title":"Example JavaScript Usage"},"154":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript number value","breadcrumbs":"Reference » Supported Types » *const T and *mut T » *const T and *mut T","id":"154","title":"*const T and *mut T"},"155":{"body":"use std::ptr;\nuse wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_pointer_by_value(x: *mut u8) {} #[wasm_bindgen]\npub fn return_pointer() -> *mut u8 { ptr::null_mut()\n}","breadcrumbs":"Reference » Supported Types » *const T and *mut T » Example Rust Usage","id":"155","title":"Example Rust Usage"},"156":{"body":"import { take_pointer_by_value, return_pointer,\n} from './guide_supported_types_examples';\nimport { memory } from './guide_supported_types_examples_bg'; let ptr = return_pointer();\nlet buf = new Uint8Array(memory.buffer);\nlet value = buf[ptr];\nconsole.log(`The byte at the ${ptr} address is ${value}`); take_pointer_by_value(ptr);","breadcrumbs":"Reference » Supported Types » *const T and *mut T » Example JavaScript Usage","id":"156","title":"Example JavaScript Usage"},"157":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript number value","breadcrumbs":"Reference » Supported Types » NonNull<T> » NonNull<T>","id":"157","title":"NonNull<T>"},"158":{"body":"use std::ptr;\nuse std::ptr::NonNull;\nuse wasm_bindgen::prelude::*; #[wasm_bindgen]\npub unsafe fn take_pointer_by_value(x: Option<NonNull<u8>>) { Box::from_raw(x.unwrap().as_ptr());\n} #[wasm_bindgen]\npub fn return_pointer() -> Option<NonNull<u8>> { Some(NonNull::from(Box::leak(Box::new(42))))\n}","breadcrumbs":"Reference » Supported Types » NonNull<T> » Example Rust Usage","id":"158","title":"Example Rust Usage"},"159":{"body":"import { take_pointer_by_value, return_pointer,\n} from './guide_supported_types_examples';\nimport { memory } from './guide_supported_types_examples_bg'; let ptr = return_pointer();\nlet buf = new Uint8Array(memory.buffer);\nlet value = buf[ptr];\nconsole.log(`The byte at the ${ptr} address is ${value}`); take_pointer_by_value(ptr);","breadcrumbs":"Reference » Supported Types » NonNull<T> » Example JavaScript Usage","id":"159","title":"Example JavaScript Usage"},"16":{"body":"/* eslint-disable no-unused-vars */\nimport { chars } from './chars-list.js';\nlet imp = import('./pkg');\nlet mod; let counters = [];\nimp .then(wasm => { mod = wasm; addCounter(); let b = document.getElementById('add-counter'); if (!b) throw new Error('Unable to find #add-counter'); b.addEventListener('click', ev => addCounter()); }) .catch(console.error); function addCounter() { let ctr = mod.Counter.new(randomChar(), 0); counters.push(ctr); update();\n} function update() { let container = document.getElementById('container'); if (!container) throw new Error('Unable to find #container in dom'); while (container.hasChildNodes()) { if (container.lastChild.id == 'add-counter') break; container.removeChild(container.lastChild); } for (var i = 0; i < counters.length; i++) { let counter = counters[i]; container.appendChild(newCounter(counter.key(), counter.count(), ev => { counter.increment(); update(); })); }\n} function randomChar() { console.log('randomChar'); let idx = Math.floor(Math.random() * (chars.length - 1)); console.log('index', idx); let ret = chars.splice(idx, 1)[0]; console.log('char', ret); return ret;\n} function newCounter(key, value, cb) { let container = document.createElement('div'); container.setAttribute('class', 'counter'); let title = document.createElement('h1'); title.appendChild(document.createTextNode('Counter ' + key)); container.appendChild(title); container.appendChild(newField('Count', value)); let plus = document.createElement('button'); plus.setAttribute('type', 'button'); plus.setAttribute('class', 'plus-button'); plus.appendChild(document.createTextNode('+')); plus.addEventListener('click', cb); container.appendChild(plus); return container;\n} function newField(key, value) { let ret = document.createElement('div'); ret.setAttribute('class', 'field'); let name = document.createElement('span'); name.setAttribute('class', 'name'); name.appendChild(document.createTextNode(key)); ret.appendChild(name); let val = document.createElement('span'); val.setAttribute('class', 'value'); val.appendChild(document.createTextNode(value)); ret.appendChild(val); return ret;\n}","breadcrumbs":"Examples » Working with char » index.js","id":"16","title":"index.js"},"160":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript number or bigint value JavaScript Numbers are 64-bit floating point value under the hood and cannot accurately represent all of Rust's numeric types. wasm-bindgen will automatically use either BigInt or Number to accurately represent Rust's numeric types in JavaScript: u8, i8, u16, i16, u32, i32, isize, usize, f32, and f64 will be represented as Number in JavaScript. u64, i64, u128, and i128 will be represented as BigInt in JavaScript. Note : Wasm is currently a 32-bit architecture, so isize and usize are 32-bit integers and \"fit\" into a JavaScript Number. Note : u128 and i128 require wasm-bindgen version 0.2.96 or later.","breadcrumbs":"Reference » Supported Types » Numbers » Numbers: u8, i8, u16, i16, u32, i32, u64, i64, u128, i128, isize, usize, f32, and f64","id":"160","title":"Numbers: u8, i8, u16, i16, u32, i32, u64, i64, u128, i128, isize, usize, f32, and f64"},"161":{"body":"wasm-bindgen will automatically handle the conversion of JavaScript numbers to Rust numeric types. The conversion rules are as follows:","breadcrumbs":"Reference » Supported Types » Numbers » Converting from JavaScript to Rust","id":"161","title":"Converting from JavaScript to Rust"},"162":{"body":"If the JavaScript number is Infinity, -Infinity, or NaN, then the Rust value will be 0. Otherwise, the JavaScript number will rounded towards zero (see Math.trunc or f64::trunc ). If the rounded number is too large or too small for the target integer type, it will wrap around. For example, if the target type is i8, Rust will see the following values for the following inputs: JS input number Rust value (i8) 42 42 -42 -42 1.999 1 -1.999 -1 127 127 128 -128 255 -1 256 0 -0 0 ±Infinity 0 NaN 0 This is the same behavior as assigning the JavaScript Number to a typed array of the appropriate integer type in JavaScript, i.e. new Uint8Array([value])[0]. Except for the handling of Infinity and -Infinity, this is the same behavior as casting f64 to the appropriate integer type in Rust, i.e. value_f64 as u32.","breadcrumbs":"Reference » Supported Types » Numbers » Number to u8, i8, u16, i16, u32, i32, isize, and usize","id":"162","title":"Number to u8, i8, u16, i16, u32, i32, isize, and usize"},"163":{"body":"If the JavaScript BigInt is too large or too small for the target integer type, it will wrap around. This is the same behavior as assigning the JavaScript BigInt to a typed array for 64-bit integer types in JavaScript, i.e. new Int64Array([value])[0].","breadcrumbs":"Reference » Supported Types » Numbers » BigInt to u64, i64, u128, and i128","id":"163","title":"BigInt to u64, i64, u128, and i128"},"164":{"body":"The JavaScript Number is converted to a Rust f32 using the same rules as casting f64 to f32 in Rust, i.e. value_f64 as f32. This is the same behavior as Math.fround or assigning the JavaScript Number to a Float32Array in JavaScript, i.e. new Float32Array([value])[0].","breadcrumbs":"Reference » Supported Types » Numbers » Number to f32","id":"164","title":"Number to f32"},"165":{"body":"Since JavaScript numbers are 64-bit floating point values, converting a JavaScript Number to a Rust f64 is a no-op.","breadcrumbs":"Reference » Supported Types » Numbers » Number to f64","id":"165","title":"Number to f64"},"166":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_number_by_value(x: u32) {} #[wasm_bindgen]\npub fn return_number() -> f64 { 42.0\n} #[wasm_bindgen]\npub fn take_option_number(x: Option<u8>) {} #[wasm_bindgen]\npub fn return_option_number() -> Option<i16> { Some(-300)\n}","breadcrumbs":"Reference » Supported Types » Numbers » Example Rust Usage","id":"166","title":"Example Rust Usage"},"167":{"body":"import { take_number_by_value, return_number, take_option_number, return_option_number,\n} from './guide_supported_types_examples'; take_number_by_value(42); let x = return_number();\nconsole.log(typeof x); // \"number\" take_option_number(null);\ntake_option_number(undefined);\ntake_option_number(13); let y = return_option_number();\nif (y == null) { // ...\n} else { console.log(typeof y); // \"number\"\n}","breadcrumbs":"Reference » Supported Types » Numbers » Example JavaScript Usage","id":"167","title":"Example JavaScript Usage"},"168":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript boolean value Note : Only JavaScript Boolean values (true or false) are supported when calling into Rust. If you want to pass truthy or falsy values to Rust, convert them to a boolean using Boolean(value) first. If you are using TypeScript, you don't have to worry about this, as TypeScript will emit a compiler error if you try to pass a non-boolean value.","breadcrumbs":"Reference » Supported Types » bool » bool","id":"168","title":"bool"},"169":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_bool_by_value(x: bool) {} #[wasm_bindgen]\npub fn return_bool() -> bool { true\n} #[wasm_bindgen]\npub fn take_option_bool(x: Option<bool>) {} #[wasm_bindgen]\npub fn return_option_bool() -> Option<bool> { Some(false)\n}","breadcrumbs":"Reference » Supported Types » bool » Example Rust Usage","id":"169","title":"Example Rust Usage"},"17":{"body":"View full source code or view the compiled example online Using the js-sys crate we can get pretty meta and instantiate WebAssembly modules from inside WebAssembly modules!","breadcrumbs":"Examples » js-sys: WebAssembly in WebAssembly » js-sys: WebAssembly in WebAssembly","id":"17","title":"js-sys: WebAssembly in WebAssembly"},"170":{"body":"import { take_char_by_value, return_char, take_option_bool, return_option_bool,\n} from './guide_supported_types_examples'; take_bool_by_value(true); let b = return_bool();\nconsole.log(typeof b); // \"boolean\" take_option_bool(null);\ntake_option_bool(undefined);\ntake_option_bool(true); let c = return_option_bool();\nif (c == null) { // ...\n} else { console.log(typeof c); // \"boolean\"\n}","breadcrumbs":"Reference » Supported Types » bool » Example JavaScript Usage","id":"170","title":"Example JavaScript Usage"},"171":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript string value Since JavaScript doesn't have a character type, char is represented as a JavaScript string with one Unicode code point. Note : JavaScript strings uses UTF-16 encoding . This means that a single char may be represented by a string of length 1 or 2 in JavaScript, depending on the Unicode code point. See String.fromCodePoint for more information. When passed into Rust, the char value of a JavaScript string is determined using codePointAt(0) . If the JavaScript string is empty or starts with an unpaired surrogate, a runtime error will be thrown. Note : For more information about unpaired surrogates, see the documentation for str .","breadcrumbs":"Reference » Supported Types » char » char","id":"171","title":"char"},"172":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_char_by_value(x: char) {} #[wasm_bindgen]\npub fn return_char() -> char { '🚀'\n}","breadcrumbs":"Reference » Supported Types » char » Example Rust Usage","id":"172","title":"Example Rust Usage"},"173":{"body":"import { take_char_by_value, return_char,\n} from './guide_supported_types_examples'; take_char_by_value('a'); let c = return_char();\nconsole.log(typeof c); // \"string\"","breadcrumbs":"Reference » Supported Types » char » Example JavaScript Usage","id":"173","title":"Example JavaScript Usage"},"174":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation No Yes No No No No JavaScript string value Copies the string's contents back and forth between the JavaScript garbage-collected heap and the Wasm linear memory with TextDecoder and TextEncoder. If you don't want to perform this copy, and would rather work with handles to JavaScript string values, use the js_sys::JsString type.","breadcrumbs":"Reference » Supported Types » str » str","id":"174","title":"str"},"175":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_str_by_shared_ref(x: &str) {}","breadcrumbs":"Reference » Supported Types » str » Example Rust Usage","id":"175","title":"Example Rust Usage"},"176":{"body":"import { take_str_by_shared_ref,\n} from './guide_supported_types_examples'; take_str_by_shared_ref('hello');","breadcrumbs":"Reference » Supported Types » str » Example JavaScript Usage","id":"176","title":"Example JavaScript Usage"},"177":{"body":"Strings in JavaScript are encoded as UTF-16, but with one major exception: they can contain unpaired surrogates. For some Unicode characters UTF-16 uses two 16-bit values. These are called \"surrogate pairs\" because they always come in pairs. In JavaScript, it is possible for these surrogate pairs to be missing the other half, creating an \"unpaired surrogate\". When passing a string from JavaScript to Rust, it uses the TextEncoder API to convert from UTF-16 to UTF-8. This is normally perfectly fine... unless there are unpaired surrogates. In that case it will replace the unpaired surrogates with U+FFFD (�, the replacement character). That means the string in Rust is now different from the string in JavaScript! If you want to guarantee that the Rust string is the same as the JavaScript string, you should instead use js_sys::JsString (which keeps the string in JavaScript and doesn't copy it into Rust). If you want to access the raw value of a JS string, you can use JsString::iter, which returns an Iterator<Item = u16>. This perfectly preserves everything (including unpaired surrogates), but it does not do any encoding (so you have to do that yourself!). If you simply want to ignore strings which contain unpaired surrogates, you can use JsString::is_valid_utf16 to test whether the string contains unpaired surrogates or not.","breadcrumbs":"Reference » Supported Types » str » UTF-16 vs UTF-8","id":"177","title":"UTF-16 vs UTF-8"},"178":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes JavaScript string value Copies the string's contents back and forth between the JavaScript garbage-collected heap and the Wasm linear memory with TextDecoder and TextEncoder Note : Be sure to check out the documentation for str to learn about some caveats when working with strings between JS and Rust.","breadcrumbs":"Reference » Supported Types » String » String","id":"178","title":"String"},"179":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_string_by_value(x: String) {} #[wasm_bindgen]\npub fn return_string() -> String { \"hello\".into()\n} #[wasm_bindgen]\npub fn take_option_string(x: Option<String>) {} #[wasm_bindgen]\npub fn return_option_string() -> Option<String> { None\n}","breadcrumbs":"Reference » Supported Types » String » Example Rust Usage","id":"179","title":"Example Rust Usage"},"18":{"body":"use js_sys::{Function, Object, Reflect, WebAssembly};\nuse wasm_bindgen::prelude::*;\nuse wasm_bindgen_futures::{spawn_local, JsFuture}; // lifted from the `console_log` example\n#[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(a: &str);\n} macro_rules! console_log { ($($t:tt)*) => (log(&format_args!($($t)*).to_string()))\n} const WASM: &[u8] = include_bytes!(\"add.wasm\"); async fn run_async() -> Result<(), JsValue> { console_log!(\"instantiating a new Wasm module directly\"); let a = JsFuture::from(WebAssembly::instantiate_buffer(WASM, &Object::new())).await?; let b: WebAssembly::Instance = Reflect::get(&a, &\"instance\".into())?.dyn_into()?; let c = b.exports(); let add = Reflect::get(c.as_ref(), &\"add\".into())? .dyn_into::<Function>() .expect(\"add export wasn't a function\"); let three = add.call2(&JsValue::undefined(), &1.into(), &2.into())?; console_log!(\"1 + 2 = {:?}\", three); let mem = Reflect::get(c.as_ref(), &\"memory\".into())? .dyn_into::<WebAssembly::Memory>() .expect(\"memory export wasn't a `WebAssembly.Memory`\"); console_log!(\"created module has {} pages of memory\", mem.grow(0)); console_log!(\"giving the module 4 more pages of memory\"); mem.grow(4); console_log!(\"now the module has {} pages of memory\", mem.grow(0)); Ok(())\n} #[wasm_bindgen(start)]\nfn run() { spawn_local(async { run_async().await.unwrap_throw(); });\n}","breadcrumbs":"Examples » js-sys: WebAssembly in WebAssembly » src/lib.rs","id":"18","title":"src/lib.rs"},"180":{"body":"import { take_string_by_value, return_string, take_option_string, return_option_string,\n} from './guide_supported_types_examples'; take_string_by_value('hello'); let s = return_string();\nconsole.log(typeof s); // \"string\" take_option_string(null);\ntake_option_string(undefined);\ntake_option_string('hello'); let t = return_option_string();\nif (t == null) { // ...\n} else { console.log(typeof s); // \"string\"\n}","breadcrumbs":"Reference » Supported Types » String » Example JavaScript Usage","id":"180","title":"Example JavaScript Usage"},"181":{"body":"T parameter &T parameter &mut T parameter T return value Option<&T> parameter Option<T> return value JavaScript representation No Yes Yes No No No A JavaScript TypedArray view of the Wasm memory for the boxed slice of the appropriate type (Int32Array, Uint8Array, etc)","breadcrumbs":"Reference » Supported Types » Number Slices » Number Slices: [u8], [i8], [u16], [i16], [u32], [i32], [u64], [i64], [f32], and [f64]","id":"181","title":"Number Slices: [u8], [i8], [u16], [i16], [u32], [i32], [u64], [i64], [f32], and [f64]"},"182":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_number_slice_by_shared_ref(x: &[f64]) {} #[wasm_bindgen]\npub fn take_number_slice_by_exclusive_ref(x: &mut [u8]) {}","breadcrumbs":"Reference » Supported Types » Number Slices » Example Rust Usage","id":"182","title":"Example Rust Usage"},"183":{"body":"import { take_number_slice_by_shared_ref, take_number_slice_by_exclusive_ref,\n} from './guide_supported_types_examples'; take_number_slice_by_shared_ref(new Float64Array(100));\ntake_number_slice_by_exclusive_ref(new Uint8Array(100));","breadcrumbs":"Reference » Supported Types » Number Slices » Example JavaScript Usage","id":"183","title":"Example JavaScript Usage"},"184":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation Yes No No Yes Yes Yes A JavaScript TypedArray of the appropriate type (Int32Array, Uint8Array, etc...) Note: The contents of the slice are copied into a JavaScript TypedArray from the Wasm linear memory when returning a boxed slice to JavaScript, and vice versa when receiving a JavaScript TypedArray as a boxed slice in Rust.","breadcrumbs":"Reference » Supported Types » Boxed Number Slices » Boxed Number Slices: Box<[u8]>, Box<[i8]>, Box<[u16]>, Box<[i16]>, Box<[u32]>, Box<[i32]>, Box<[u64]>, Box<[i64]>, Box<[f32]>, and Box<[f64]>","id":"184","title":"Boxed Number Slices: Box<[u8]>, Box<[i8]>, Box<[u16]>, Box<[i16]>, Box<[u32]>, Box<[i32]>, Box<[u64]>, Box<[i64]>, Box<[f32]>, and Box<[f64]>"},"185":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn take_boxed_number_slice_by_value(x: Box<[f64]>) {} #[wasm_bindgen]\npub fn return_boxed_number_slice() -> Box<[u32]> { (0..42).collect::<Vec<u32>>().into_boxed_slice()\n} #[wasm_bindgen]\npub fn take_option_boxed_number_slice(x: Option<Box<[u8]>>) {} #[wasm_bindgen]\npub fn return_option_boxed_number_slice() -> Option<Box<[i32]>> { None\n}","breadcrumbs":"Reference » Supported Types » Boxed Number Slices » Example Rust Usage","id":"185","title":"Example Rust Usage"},"186":{"body":"import { take_boxed_number_slice_by_value, return_boxed_number_slice, take_option_boxed_number_slice, return_option_boxed_number_slice,\n} from './guide_supported_types_examples'; take_boxed_number_slice_by_value(new Uint8Array(100)); let x = return_boxed_number_slice();\nconsole.log(x instanceof Uint32Array); // true take_option_boxed_number_slice(null);\ntake_option_boxed_number_slice(undefined);\ntake_option_boxed_number_slice(new Int16Array(256)); let y = return_option_boxed_number_slice();\nif (y == null) { // ...\n} else { console.log(x instanceof Int32Array); // true\n}","breadcrumbs":"Reference » Supported Types » Boxed Number Slices » Example JavaScript Usage","id":"186","title":"Example JavaScript Usage"},"187":{"body":"T parameter &T parameter &mut T parameter T return value Option<T> parameter Option<T> return value JavaScript representation No No No Yes No No Same as T, or an exception The Result type can be returned from functions exported to JS as well as closures in Rust. The Ok type must be able to be converted to JS, and the Err type must implement Into<JsValue>. Whenever Ok(val) is encountered it's converted to JS and handed off, and whenever Err(error) is encountered an exception is thrown in JS with error. You can use Result to enable handling of JS exceptions with ? in Rust, naturally propagating it upwards to the Wasm boundary. Furthermore you can also return custom types in Rust so long as they're all convertible to JsValue. Note that if you import a JS function with Result you need #[wasm_bindgen(catch)] to be annotated on the import (unlike exported functions, which require no extra annotation). This may not be necessary in the future though and it may work \"as is\"!.","breadcrumbs":"Reference » Supported Types » Result<T, E> » Result<T, E>","id":"187","title":"Result<T, E>"},"188":{"body":"The #[wasm_bindgen] macro supports a good amount of configuration for controlling precisely how exports are exported, how imports are imported, and what the generated JavaScript glue ends up looking like. This section is an exhaustive reference of the possibilities!","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » #[wasm_bindgen] Attributes","id":"188","title":"#[wasm_bindgen] Attributes"},"189":{"body":"This section enumerates the attributes available for customizing bindings for JavaScript functions and classes imported into Rust within an extern \"C\" { ... } block.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » #[wasm_bindgen] on JavaScript Imports","id":"189","title":"#[wasm_bindgen] on JavaScript Imports"},"19":{"body":"View full source code or view the compiled example online Using web-sys we're able to interact with all the standard web platform methods, including those of the DOM! Here we take a look at a simple \"Hello, world!\" which manufactures a DOM element in Rust, customizes it, and then appends it to the page.","breadcrumbs":"Examples » web-sys: DOM hello world » web-sys: DOM hello world","id":"19","title":"web-sys: DOM hello world"},"190":{"body":"The catch attribute allows catching a JavaScript exception. This can be attached to any imported function or method, and the function must return a Result where the Err payload is a JsValue: #[wasm_bindgen]\nextern \"C\" { // `catch` on a standalone function. #[wasm_bindgen(catch)] fn foo() -> Result<(), JsValue>; // `catch` on a method. type Zoidberg; #[wasm_bindgen(catch, method)] fn woop_woop_woop(this: &Zoidberg) -> Result<u32, JsValue>;\n} If calling the imported function throws an exception, then Err will be returned with the exception that was raised. Otherwise, Ok is returned with the result of the function. By default wasm-bindgen will take no action when Wasm calls a JS function which ends up throwing an exception. The Wasm spec right now doesn't support stack unwinding and as a result Rust code will not execute destructors . This can unfortunately cause memory leaks in Rust right now, but as soon as Wasm implements catching exceptions we'll be sure to add support as well!","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » catch » catch","id":"190","title":"catch"},"191":{"body":"The constructor attribute is used to indicate that the function being bound should actually translate to calling the new operator in JavaScript. The final argument must be a type that's imported from JavaScript, and it's what will get used in the generated glue: #[wasm_bindgen]\nextern \"C\" { type Shoes; #[wasm_bindgen(constructor)] fn new() -> Shoes;\n} This will attach a new static method to the Shoes type, and in JavaScript when this method is called, it will be equivalent to new Shoes(). // Become a cobbler; construct `new Shoes()`\nlet shoes = Shoes::new();","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » constructor » constructor","id":"191","title":"constructor"},"192":{"body":"The extends attribute can be used to say that an imported type extends (in the JS class hierarchy sense) another type. This will generate AsRef, AsMut, and From impls for converting a type into another given that we statically know the inheritance hierarchy: #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(extends = Foo)] type Bar;\n} let x: &Bar = ...;\nlet y: &Foo = x.as_ref(); // zero cost cast The trait implementations generated for the above block are: impl From<Bar> for Foo { ... }\nimpl AsRef<Foo> for Bar { ... }\nimpl AsMut<Foo> for Bar { ... } The extends = ... attribute can be specified multiple times for longer inheritance chains, and AsRef and such impls will be generated for each of the types. #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(extends = Foo)] type Bar; #[wasm_bindgen(extends = Foo, extends = Bar)] type Baz;\n} let x: &Baz = ...;\nlet y1: &Bar = x.as_ref();\nlet y2: &Foo = y1.as_ref();","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » extends » extends = Class","id":"192","title":"extends = Class"},"193":{"body":"These two attributes can be combined with method to indicate that this is a getter or setter method. A getter-tagged function by default accesses the JavaScript property with the same name as the getter function. A setter's function name is currently required to start with set_ and the property it accesses is the suffix after set\\_. Consider the following JavaScript class that has a getter and setter for the white_russians property: class TheDude { get white_russians() { ... } set white_russians(val) { ... }\n} We would import this with the following #[wasm_bindgen] attributes: #[wasm_bindgen]\nextern \"C\" { type TheDude; #[wasm_bindgen(method, getter)] fn white_russians(this: &TheDude) -> u32; #[wasm_bindgen(method, setter)] fn set_white_russians(this: &TheDude, val: u32);\n} Here we're importing the TheDude type and defining the ability to access each object's white_russians property. The first function here is a getter and will be available in Rust as the_dude.white_russians(), and the latter is the setter which is accessible as the_dude.set_white_russians(2). Note that both functions have a this argument as they're tagged with method. Finally, you can also pass an argument to the getter and setter properties to configure what property is accessed. When the property is explicitly specified then there is no restriction on the method name. For example the below is equivalent to the above: #[wasm_bindgen]\nextern \"C\" { type TheDude; #[wasm_bindgen(method, getter = white_russians)] fn my_custom_getter_name(this: &TheDude) -> u32; #[wasm_bindgen(method, setter = white_russians)] fn my_custom_setter_name(this: &TheDude, val: u32);\n} Heads up! getter and setter functions are found on the constructor's prototype chain once at load time, cached, and then the cached accessor is invoked on each access. If you need to dynamically walk the prototype chain on every access, add the structural attribute! // This is the default function Rust will invoke on `the_dude.white_russians()`:\nconst white_russians = Object.getOwnPropertyDescriptor( TheDude.prototype, \"white_russians\"\n).get; // This is what you get by adding `structural`:\nconst white_russians = function(the_dude) { return the_dude.white_russians;\n};","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » getter and setter » getter and setter","id":"193","title":"getter and setter"},"194":{"body":"The final attribute is the converse of the structural attribute . It configures how wasm-bindgen will generate JS imports to call the imported function. Notably a function imported by final never changes after it was imported, whereas a function imported by default (or with structural) is subject to runtime lookup rules such as walking the prototype chain of an object. Note that final is not suitable for accessing data descriptor properties of JS objects; to accomplish this, use the structural attribute. The final attribute is intended to be purely related to performance. It ideally has no user-visible effect, and structural imports (the default) should be able to transparently switch to final eventually. The eventual performance aspect is that with the component model proposal then wasm-bindgen will need to generate far fewer JS function shims to import than it does today. For example, consider this import today: #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(method)] fn bar(this: &Foo, argument: &str) -> JsValue;\n} Without the final attribute the generated JS looks like this: // without `final`\nexport function __wbg_bar_a81456386e6b526f(arg0, arg1, arg2) { let varg1 = getStringFromWasm(arg1, arg2); return addHeapObject(getObject(arg0).bar(varg1));\n} We can see here that this JS function shim is required, but it's all relatively self-contained. It does, however, execute the bar method in a duck-type-y fashion in the sense that it never validates getObject(arg0) is of type Foo to actually call the Foo.prototype.bar method. If we instead, however, write this: #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(method, final)] // note the change here fn bar(this: &Foo, argument: &str) -> JsValue;\n} it generates this JS glue (roughly): const __wbg_bar_target = Foo.prototype.bar; export function __wbg_bar_a81456386e6b526f(arg0, arg1, arg2) { let varg1 = getStringFromWasm(arg1, arg2); return addHeapObject(__wbg_bar_target.call(getObject(arg0), varg1));\n} The difference here is pretty subtle, but we can see how the function being called is hoisted out of the generated shim and is bound to always be Foo.prototype.bar. This then uses the Function.call method to invoke that function with getObject(arg0) as the receiver. But wait, there's still a JS function shim here even with final! That's true, and this is simply a fact of future WebAssembly proposals not being implemented yet. The semantics, though, match the future component model proposal because the method being called is determined exactly once, and it's located on the prototype chain rather than being resolved at runtime when the function is called.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » final » final","id":"194","title":"final"},"195":{"body":"If you're curious to see how our JS function shim will be eliminated entirely, let's take a look at the generated bindings. We're starting off with this: const __wbg_bar_target = Foo.prototype.bar; export function __wbg_bar_a81456386e6b526f(arg0, arg1, arg2) { let varg1 = getStringFromWasm(arg1, arg2); return addHeapObject(__wbg_bar_target.call(getObject(arg0), varg1));\n} ... and once the reference types proposal is implemented then we won't need some of these pesky functions. That'll transform our generated JS shim to look like: const __wbg_bar_target = Foo.prototype.bar; export function __wbg_bar_a81456386e6b526f(arg0, arg1, arg2) { let varg1 = getStringFromWasm(arg1, arg2); return __wbg_bar_target.call(arg0, varg1);\n} Getting better! Next up we need the component model proposal. Note that the proposal is undergoing some changes right now so it's tough to link to reference documentation, but it suffices to say that it'll empower us with at least two different features. First, component model promises to provide the concept of \"argument conversions\". The arg1 and arg2 values here are actually a pointer and a length to a utf-8 encoded string, and with component model we'll be able to annotate that this import should take those two arguments and convert them to a JS string (that is, the host should do this, the WebAssembly engine). Using that feature we can further trim this down to: const __wbg_bar_target = Foo.prototype.bar; export function __wbg_bar_a81456386e6b526f(arg0, varg1) { return __wbg_bar_target.call(arg0, varg1);\n} And finally, the second promise of the component model proposal is that we can flag a function call to indicate the first argument is the this binding of the function call. Today the this value of all called imported functions is undefined, and this flag (configured with component model) will indicate the first argument here is actually the this. With that in mind we can further transform this to: export const __wbg_bar_a81456386e6b526f = Foo.prototype.bar; and voila! We, with reference types and component model , now have no JS function shim at all necessary to call the imported function. Additionally future Wasm proposals to the ES module system may also mean that don't even need the export const ... here too. It's also worth pointing out that with all these Wasm proposals implemented the default way to import the bar function (aka structural) would generate a JS function shim that looks like: export function __wbg_bar_a81456386e6b526f(varg1) { return this.bar(varg1);\n} where this import is still subject to runtime prototype chain lookups and such.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » final » Interaction with future proposals","id":"195","title":"Interaction with future proposals"},"196":{"body":"These three attributes indicate that a method is an dynamically intercepted getter, setter, or deleter on the receiver object itself, rather than a direct access of the receiver's properties. It is equivalent calling the Proxy handler for the obj[prop] operation with some dynamic prop variable in JavaScript, rather than a normal static property access like obj.prop on a normal JavaScript Object. This is useful for binding to Proxys and some builtin DOM types that dynamically intercept property accesses. indexing_getter corresponds to obj[prop] operation in JavaScript. The function annotated must have a this receiver parameter, a single parameter that is used for indexing into the receiver (prop), and a return type. indexing_setter corresponds to the obj[prop] = val operation in JavaScript. The function annotated must have a this receiver parameter, a parameter for indexing into the receiver (prop), and a value parameter (val). indexing_deleter corresponds to delete obj[prop] operation in JavaScript. The function annotated must have a this receiver and a single parameter for indexing into the receiver (prop). These must always be used in conjunction with the structural and method flags. For example, consider this JavaScript snippet that uses Proxy: const foo = new Proxy({}, { get(obj, prop) { return prop in obj ? obj[prop] : prop.length; }, set(obj, prop, value) { obj[prop] = value; }, deleteProperty(obj, prop) { delete obj[prop]; },\n}); foo.ten;\n// 3 foo.ten = 10;\nfoo.ten;\n// 10 delete foo.ten;\nfoo.ten;\n// 3 To bind that in wasm-bindgen in Rust, we would use the indexing_* attributes on methods: #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(thread_local_v2)] static FOO: Foo; #[wasm_bindgen(method, structural, indexing_getter)] fn get(this: &Foo, prop: &str) -> u32; #[wasm_bindgen(method, structural, indexing_setter)] fn set(this: &Foo, prop: &str, val: u32); #[wasm_bindgen(method, structural, indexing_deleter)] fn delete(this: &Foo, prop: &str);\n} FOO.with(|foo| { assert_eq!(foo.get(\"ten\"), 3); foo.set(\"ten\", 10); assert_eq!(foo.get(\"ten\"), 10); foo.delete(\"ten\"); assert_eq!(foo.get(\"ten\"), 3);\n});","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » indexing_getter, indexing_setter, and indexing_deleter » indexing_getter, indexing_setter, and indexing_deleter","id":"196","title":"indexing_getter, indexing_setter, and indexing_deleter"},"197":{"body":"The js_class attribute can be used in conjunction with the method attribute to bind methods of imported JavaScript classes that have been renamed on the Rust side. #[wasm_bindgen]\nextern \"C\" { // We don't want to import JS strings as `String`, since Rust already has a // `String` type in its prelude, so rename it as `JsString`. #[wasm_bindgen(js_name = String)] type JsString; // This is a method on the JavaScript \"String\" class, so specify that with // the `js_class` attribute. #[wasm_bindgen(method, js_class = \"String\", js_name = charAt)] fn char_at(this: &JsString, index: u32) -> JsString;\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » js_class = \"Blah\" » js_class = \"Blah\"","id":"197","title":"js_class = \"Blah\""},"198":{"body":"The js_name attribute can be used to bind to a different function in JavaScript than the identifier that's defined in Rust. Most often, this is used to convert a camel-cased JavaScript identifier into a snake-cased Rust identifier: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_name = jsOftenUsesCamelCase)] fn js_often_uses_camel_case() -> u32;\n} Sometimes, it is used to bind to JavaScript identifiers that are not valid Rust identifiers, in which case js_name = \"some string\" is used instead of js_name = ident: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_name = \"$$$\")] fn cash_money() -> u32;\n} However, you can also use js_name to define multiple signatures for polymorphic JavaScript functions: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console, js_name = log)] fn console_log_str(s: &str); #[wasm_bindgen(js_namespace = console, js_name = log)] fn console_log_u32(n: u32); #[wasm_bindgen(js_namespace = console, js_name = log)] fn console_log_many(a: u32, b: &JsValue);\n} All of these functions will call console.log in JavaScript, but each identifier will have only one signature in Rust. Note that if you use js_name when importing a type you'll also need to use the js_class attribute when defining methods on the type: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_name = String)] type JsString; #[wasm_bindgen(method, getter, js_class = \"String\")] pub fn length(this: &JsString) -> u32;\n} The js_name attribute can also be used in situations where a JavaScript module uses export default. In this case, setting the js_name attribute to \"default\" on the type declaration, and the js_class attribute to \"default\" on any methods on the exported object will generate the correct imports. For example, a module that would be imported directly in JavaScript: import Foo from \"bar\"; let f = new Foo(); Could be accessed using this definition in Rust: #[wasm_bindgen(module = \"bar\")]\nextern \"C\" { #[wasm_bindgen(js_name = default)] type Foo; #[wasm_bindgen(constructor, js_class = default)] pub fn new() -> Foo;\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » js_name » js_name = blah","id":"198","title":"js_name = blah"},"199":{"body":"This attribute indicates that the JavaScript type is accessed through the given namespace. For example, the WebAssembly.Module APIs are all accessed through the WebAssembly namespace. js_namespace can be applied to any import (function or type) and whenever the generated JavaScript attempts to reference a name (like a class or function name) it'll be accessed through this namespace. #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str); type Foo; #[wasm_bindgen(constructor, js_namespace = Bar)] fn new() -> Foo;\n} log(\"hello, console!\");\nFoo::new(); This is an example of how to bind namespaced items in Rust. The log and Foo::new functions will be available in the Rust module and will be invoked as console.log and new Bar.Foo in JavaScript. It is also possible to access the JavaScript object under the nested namespace. js_namespace also accepts the array of the string to specify the namespace. #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = [\"window\", \"document\"])] fn write(s: &str);\n} write(\"hello, document!\"); This example shows how to bind window.document.write in Rust. If all items in the extern \"C\" { … } block have the same js_namespace = …: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = Math)] fn random() -> f64; #[wasm_bindgen(js_namespace = Math)] fn log(a: f64) -> f64; // ...\n} Then that macro argument can also be moved to the outer block: #[wasm_bindgen(js_namespace = Math)]\nextern \"C\" { #[wasm_bindgen] fn random() -> f64; #[wasm_bindgen] fn log(a: f64) -> f64; // ...\n} js_namespace = … on an individual item takes precedence over the outer block's js_namespace = ….","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » js_namespace » js_namespace = blah","id":"199","title":"js_namespace = blah"},"2":{"body":"View full source code or view the compiled example online This is the \"Hello, world!\" example of #[wasm_bindgen] showing how to set up a project, export a function to JS, call it from JS, and then call the alert function in Rust.","breadcrumbs":"Examples » Hello, World! » Hello, World!","id":"2","title":"Hello, World!"},"20":{"body":"You can see here how we depend on web-sys and activate associated features to enable all the various APIs: [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"dom\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = ['Document', 'Element', 'HtmlElement', 'Node', 'Window']\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: DOM hello world » Cargo.toml","id":"20","title":"Cargo.toml"},"200":{"body":"The method attribute allows you to describe methods of imported JavaScript objects. It is applied on a function that has this as its first parameter, which is a shared reference to an imported JavaScript type. #[wasm_bindgen]\nextern \"C\" { type Set; #[wasm_bindgen(method)] fn has(this: &Set, element: &JsValue) -> bool;\n} This generates a has method on Set in Rust, which invokes the Set.prototype.has method in JavaScript. let set: Set = ...;\nlet elem: JsValue = ...;\nif set.has(&elem) { ...\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » method » method","id":"200","title":"method"},"201":{"body":"The module attributes configures the module from which items are imported. For example, #[wasm_bindgen(module = \"wu/tang/clan\")]\nextern \"C\" { type ThirtySixChambers;\n} generates JavaScript import glue like: import { ThirtySixChambers } from \"wu/tang/clan\"; If a module attribute is not present, then the global scope is used instead. For example, #[wasm_bindgen]\nextern \"C\" { fn illmatic() -> u32;\n} generates JavaScript import glue like: let illmatic = this.illmatic; Note that if the string specified with module starts with ./, ../, or / then it's interpreted as a path to a local JS snippet . If this doesn't work for your use case you might be interested in the raw_module attribute","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » module = \"blah\" » module = \"blah\"","id":"201","title":"module = \"blah\""},"202":{"body":"This attribute performs exactly the same purpose as the module attribute on JS imports, but it does not attempt to interpret paths starting with ./, ../, or / as JS snippets. For example: #[wasm_bindgen(raw_module = \"./some/js/file.js\")]\nextern \"C\" { fn the_function();\n} Note that if you use this attribute with a relative or absolute path, it's likely up to the final bundler or project to assign meaning to that path. This typically means that the JS file or module will be resolved relative to the final location of the Wasm file itself. That means that raw_module is likely unsuitable for libraries on crates.io, but may be usable within end-user applications.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » raw_module = \"blah\" » raw_module = \"blah\"","id":"202","title":"raw_module = \"blah\""},"203":{"body":"The no_deref attribute can be used to say that no Deref impl should be generated for an imported type. If this attribute is not present, a Deref impl will be generated with a Target of the type's first extends attribute, or Target = JsValue if there are no extends attributes. #[wasm_bindgen]\nextern \"C\" { type Foo; #[wasm_bindgen(method)] fn baz(this: &Foo) #[wasm_bindgen(extends = Foo, no_deref)] type Bar;\n} fn do_stuff(bar: &Bar) { bar.baz() // Does not compile\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » no_deref » no_deref","id":"203","title":"no_deref"},"204":{"body":"The static_method_of attribute allows one to specify that an imported function is a static method of the given imported JavaScript class. For example, to bind to JavaScript's Date.now() static method, one would use this attribute: #[wasm_bindgen]\nextern \"C\" { type Date; #[wasm_bindgen(static_method_of = Date)] pub fn now() -> f64;\n} The now function becomes a static method of the imported type in the Rust bindings as well: let instant = Date::now(); This is similar to the js_namespace attribute, but the usage from within Rust is different since the method also becomes a static method of the imported type. Additionally this attribute also specifies that the this parameter when invoking the method is expected to be the JS class, e.g. always invoked as Date.now() instead of const x = Date.now; x().","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » static_method_of = Blah » static_method_of = Blah","id":"204","title":"static_method_of = Blah"},"205":{"body":"Note : As of RFC 5 this attribute is the default for all imported functions. This attribute is largely ignored today and is only retained for backwards compatibility and learning purposes. The inverse of this attribute, the final attribute is more functionally interesting than structural (as structural is simply the default) The structural flag can be added to method annotations, indicating that the method being accessed (or property with getters/setters) should be accessed in a structural, duck-type-y fashion. Rather than walking the constructor's prototype chain once at load time and caching the property result, the prototype chain is dynamically walked on every access. #[wasm_bindgen]\nextern \"C\" { type Duck; #[wasm_bindgen(method, structural)] fn quack(this: &Duck); #[wasm_bindgen(method, getter, structural)] fn is_swimming(this: &Duck) -> bool;\n} The constructor for the type here, Duck, is not required to exist in JavaScript (it's not referenced). Instead wasm-bindgen will generate shims that will access the passed in JavaScript value's quack method or its is_swimming property. // Without `structural`, get the method directly off the prototype at load time:\nconst Duck_prototype_quack = Duck.prototype.quack;\nfunction quack(duck) { Duck_prototype_quack.call(duck);\n} // With `structural`, walk the prototype chain on every access:\nfunction quack(duck) { duck.quack();\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » structural » structural","id":"205","title":"structural"},"206":{"body":"The typescript_type allows us to use typescript declarations in typescript_custom_section as arguments for rust functions! For example: #[wasm_bindgen(typescript_custom_section)]\nconst ITEXT_STYLE: &'static str = r#\"\ninterface ITextStyle { bold: boolean; italic: boolean; size: number;\n}\n\"#; #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(typescript_type = \"ITextStyle\")] pub type ITextStyle;\n} #[wasm_bindgen]\n#[derive(Default)]\npub struct TextStyle { pub bold: bool, pub italic: bool, pub size: i32,\n} #[wasm_bindgen]\nimpl TextStyle { #[wasm_bindgen(constructor)] pub fn new(i: ITextStyle) -> TextStyle { let _js_value: JsValue = i.into(); // parse JsValue TextStyle::default() } pub fn optional_new(_i: Option<ITextStyle>) -> TextStyle { // parse JsValue TextStyle::default() }\n} We can write our typescript code like: import { ITextStyle, TextStyle } from \"./my_awesome_module\"; const style: TextStyle = new TextStyle({ bold: true, italic: true, size: 42,\n}); const optional_style: TextStyle = TextStyle.optional_new();","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » typescript_type » typescript_type","id":"206","title":"typescript_type"},"207":{"body":"In javascript, both the types of function arguments, and the number of function arguments are dynamic. For example function sum(...rest) { let i; // the old way let old_way = 0; for (i=0; i<arguments.length; i++) { old_way += arguments[i]; } // the new way let new_way = 0; for (i=0; i<rest.length; i++) { new_way += rest[i]; } // both give the same answer assert(old_way === new_way); return new_way;\n} This function doesn't translate directly into rust, since we don't currently support variadic arguments on the Wasm target. To bind to it, we use a slice as the last argument, and annotate the function as variadic: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(variadic)] fn sum(args: &[i32]) -> i32;\n} when we call this function, the last argument will be expanded as the javascript expects. To export a rust function to javascript with a variadic argument, we will use the same bindgen variadic attribute and assume that the last argument will be the variadic array. For example the following rust function: #[wasm_bindgen(variadic)]\npub fn variadic_function(arr: &JsValue) -> JsValue { arr.into()\n} will generate the following TS interface export function variadic_function(...arr: any): any;","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » variadic » Variadic Parameters","id":"207","title":"Variadic Parameters"},"208":{"body":"On the web new APIs often have vendor prefixes while they're in an experimental state. For example the AudioContext API is known as webkitAudioContext in Safari at the time of this writing. The vendor_prefix attribute indicates these alternative names, which are used if the normal name isn't defined. For example to use AudioContext you might do: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(vendor_prefix = webkit)] type AudioContext; // methods on `AudioContext` ...\n} Whenever AudioContext is used it'll use AudioContext if the global namespace defines it or alternatively it'll fall back to webkitAudioContext. Note that vendor_prefix cannot be used with module = \"...\" or js_namespace = ..., so it's basically limited to web-platform APIs today.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On JavaScript Imports » vendor_prefix » Vendor-prefixed APIs","id":"208","title":"Vendor-prefixed APIs"},"209":{"body":"This section enumerates the attributes available for customizing bindings for Rust functions and structs exported to JavaScript.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » #[wasm_bindgen] on Rust Exports","id":"209","title":"#[wasm_bindgen] on Rust Exports"},"21":{"body":"use wasm_bindgen::prelude::*; // Called by our JS entry point to run the example\n#[wasm_bindgen(start)]\nfn run() -> Result<(), JsValue> { // Use `web_sys`'s global `window` function to get a handle on the global // window object. let window = web_sys::window().expect(\"no global `window` exists\"); let document = window.document().expect(\"should have a document on window\"); let body = document.body().expect(\"document should have a body\"); // Manufacture the element we're gonna append let val = document.create_element(\"p\")?; val.set_text_content(Some(\"Hello from Rust!\")); body.append_child(&val)?; Ok(())\n}","breadcrumbs":"Examples » web-sys: DOM hello world » src/lib.rs","id":"21","title":"src/lib.rs"},"210":{"body":"When attached to a Rust \"constructor\" it will make the generated JavaScript bindings callable as new Foo(). For example, consider this exported Rust type and constructor annotation: #[wasm_bindgen]\npub struct Foo { contents: u32,\n} #[wasm_bindgen]\nimpl Foo { #[wasm_bindgen(constructor)] pub fn new() -> Foo { Foo { contents: 0 } } pub fn get_contents(&self) -> u32 { self.contents }\n} This can be used in JavaScript as: import { Foo } from './my_module'; const f = new Foo();\nconsole.log(f.get_contents());","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » constructor » constructor","id":"210","title":"constructor"},"211":{"body":"In versions >=v0.2.48, <0.2.88 of wasm-bindgen, there is a bug which breaks inheritance of exported Rust structs from JavaScript side (see #3213 ). If you want to inherit from a Rust struct such as: use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub struct Parent { msg: String,\n} #[wasm_bindgen]\nimpl Parent { #[wasm_bindgen(constructor)] fn new() -> Self { Parent { msg: String::from(\"Hello from Parent!\"), } }\n} You will need to reset the prototype of this back to the Child class prototype after calling the Parent's constructor via super. import { Parent } from './my_module'; class Child extends Parent { constructor() { super(); Object.setPrototypeOf(this, Child.prototype); }\n} This is no longer required as of v0.2.88.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » constructor » Caveats","id":"211","title":"Caveats"},"212":{"body":"The js_name attribute can be used to export a different name in JS than what something is named in Rust. It can be applied to both exported Rust functions and types. For example, this is often used to convert between Rust's snake-cased identifiers into JavaScript's camel-cased identifiers: #[wasm_bindgen(js_name = doTheThing)]\npub fn do_the_thing() -> u32 { 42\n} This can be used in JavaScript as: import { doTheThing } from './my_module'; const x = doTheThing();\nconsole.log(x); Like imports, js_name can also be used to rename types exported to JS: #[wasm_bindgen(js_name = Foo)]\npub struct JsFoo { // ..\n} to be accessed like: import { Foo } from './my_module'; // ... Note that attaching methods to the JS class Foo should be done via the js_class attribute : #[wasm_bindgen(js_name = Foo)]\npub struct JsFoo { /* ... */ } #[wasm_bindgen(js_class = Foo)]\nimpl JsFoo { // ...\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » js_name = Blah » js_name = Blah","id":"212","title":"js_name = Blah"},"213":{"body":"The js_class attribute is used to indicate that all the methods inside an impl block should be attached to the specified JS class instead of inferring it from the self type in the impl block. The js_class attribute is most frequently paired with the js_name attribute on structs: #[wasm_bindgen(js_name = Foo)]\npub struct JsFoo { /* ... */ } #[wasm_bindgen(js_class = Foo)]\nimpl JsFoo { #[wasm_bindgen(constructor)] pub fn new() -> JsFoo { /* ... */ } pub fn foo(&self) { /* ... */ }\n} which is accessed like: import { Foo } from './my_module'; const x = new Foo();\nx.foo();","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » js_class = Blah » js_class = Blah","id":"213","title":"js_class = Blah"},"214":{"body":"When attached to a pub struct field this indicates that it's read-only from JavaScript, and a setter will not be generated and exported to JavaScript. #[wasm_bindgen]\npub fn make_foo() -> Foo { Foo { first: 10, second: 20, }\n} #[wasm_bindgen]\npub struct Foo { pub first: u32, #[wasm_bindgen(readonly)] pub second: u32,\n} Here the first field will be both readable and writable from JS, but the second field will be a readonly field in JS where the setter isn't implemented and attempting to set it will throw an exception. import { make_foo } from \"./my_module\"; const foo = make_foo(); // Can both get and set `first`.\nfoo.first = 99;\nconsole.log(foo.first); // Can only get `second`.\nconsole.log(foo.second);","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » readonly » readonly","id":"214","title":"readonly"},"215":{"body":"When attached to a pub struct field this indicates that field will not be exposed to JavaScript, and neither getter nor setter will be generated in ES6 class. use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub struct Foo { pub bar: u32, #[wasm_bindgen(skip)] pub baz: u32,\n} #[wasm_bindgen]\nimpl Foo { pub fn new() -> Self { Foo { bar: 1, baz: 2 } }\n} Here the bar field will be both readable and writable from JS, but the baz field will be undefined in JS. import('./pkg/').then(rust => { let foo = rust.Foo.new(); // bar is accessible by getter console.log(foo.bar); // field marked with `skip` is undefined console.log(foo.baz); // you can shadow it foo.baz = 45; // so accessing by getter will return `45` // but it won't affect real value in rust memory console.log(foo.baz);\n});","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » skip » skip","id":"215","title":"skip"},"216":{"body":"When attached to a function or a method, prevents wasm-bindgen from auto-generating JSDoc-style doc comments. By default, wasm-bindgen adds @param and @returns annotations to doc comments in the generated JS files. A skip_jsdoc annotation prevents this, allowing you to supply your own doc comments. The following rust uses skip_jsdoc to omit one of the auto-generated doc comments. use wasm_bindgen::prelude::*; /// Autogenerated docs.\n#[wasm_bindgen]\npub fn foo(arg: u32) -> u32 { arg + 1 } /// Manually written docs.\n///\n/// @param {number} arg - A descriptive description.\n/// @returns {number} Something a bit bigger.\n#[wasm_bindgen(skip_jsdoc)]\npub fn bar(arg: u32) -> u32 { arg + 2 } The wasm-bindgen-generated JS interface of the above code will look something like this: /**\n* Autogenerated docs.\n*\n* @param {number} arg\n* @returns {number}\n*/\nexport function foo(arg) { /* ... */ } /**\n* Manually written docs.\n*\n* @param {number} arg - A descriptive description.\n* @returns {number} Something a bit bigger.\n*/\nexport function bar(arg) { /* ... */ }","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » skip_jsdoc » skip_jsdoc","id":"216","title":"skip_jsdoc"},"217":{"body":"When attached to a function this attribute will configure the start section of the Wasm executable to be emitted, executing the tagged function as soon as the Wasm module is instantiated. #[wasm_bindgen(start)]\nfn start() { // executed automatically ...\n} The start section of the Wasm executable will be configured to execute the start function here as soon as it can. Note that due to various practical limitations today the start section of the executable may not literally point to start, but the start function here should be started up automatically when the wasm module is loaded. There's a few caveats to be aware of when using the start attribute: The start function must take no arguments and must either return () or Result<(), JsValue> Only one start function can be placed into a module, including its dependencies. If more than one is specified then wasm-bindgen will fail when the CLI is run. It's recommended that only applications use this attribute. The start function will not be executed when testing. Note that the start function is relatively new, so if you find any bugs with it, please feel free to report an issue!","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » start » start","id":"217","title":"start"},"218":{"body":"When attached to the main function this attribute will adjust it to properly throw errors if they can be. #[wasm_bindgen(main)]\nfn main() -> Result<(), JsValue> { Err(JsValue::from(\"this error message will be thrown\"))\n} The attribute also allows using async fn main() in Cargo binaries. #[wasm_bindgen(main)]\nasync fn main() { // ... future.await;\n} This attribute is only intended to be used on the main function of binaries or examples. Unlike #[wasm_bindgen(start)], it will not cause an arbitrary function to be executed on start in a library. The return type support is modeled after Termination . () and Infallible are supported, but Termination itself is not. In order, wasm-bindgen will first detect a Result<(), impl Into<JsValue>> and will throw proper JsValues, Result<(), impl Debug> will convert an error to a string and throw that.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » main » main","id":"218","title":"main"},"219":{"body":"When added to a const &'static str, it will append the contents of the string to the .d.ts file exported by wasm-bindgen-cli (when the --typescript flag is enabled). #[wasm_bindgen(typescript_custom_section)]\nconst TS_APPEND_CONTENT: &'static str = r#\" export type Coords = { \"latitude\": number, \"longitude\": number, }; \"#; The primary target for this feature is for code generation. For example, you can author a macro that allows you to export a TypeScript definition alongside the definition of a struct or Rust type. #[derive(MyTypescriptExport)]\nstruct Coords { latitude: u32, longitude: u32,\n} The proc_derive_macro \"MyTypescriptExport\" can export its own #[wasm_bindgen(typescript_custom_section)] section, which would then be picked up by wasm-bindgen-cli. This would be equivalent to the contents of the TS_APPEND_CONTENT string in the first example. This feature allows plain data objects to be typechecked in Rust and in TypeScript by outputting a type definition generated at compile time.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » typescript_custom_section » typescript_custom_section","id":"219","title":"typescript_custom_section"},"22":{"body":"View full source code or view the compiled example online One of the features of #[wasm_bindgen] is that you can pass closures defined in Rust off to JS. This can be a bit tricky at times, though, so the example here shows how to interact with some standard web APIs with closures.","breadcrumbs":"Examples » web-sys: Closures » web-sys: Closures","id":"22","title":"web-sys: Closures"},"220":{"body":"The getter and setter attributes can be used in Rust impl blocks to define properties in JS that act like getters and setters of a field. For example: #[wasm_bindgen]\npub struct Baz { field: i32,\n} #[wasm_bindgen]\nimpl Baz { #[wasm_bindgen(constructor)] pub fn new(field: i32) -> Baz { Baz { field } } #[wasm_bindgen(getter)] pub fn field(&self) -> i32 { self.field } #[wasm_bindgen(setter)] pub fn set_field(&mut self, field: i32) { self.field = field; }\n} Can be combined in JavaScript like in this snippet: const obj = new Baz(3);\nassert.equal(obj.field, 3);\nobj.field = 4;\nassert.equal(obj.field, 4); You can also configure the name of the property that is exported in JS like so: #[wasm_bindgen]\nimpl Baz { #[wasm_bindgen(getter = anotherName)] pub fn field(&self) -> i32 { self.field } #[wasm_bindgen(setter = anotherName)] pub fn set_field(&mut self, field: i32) { self.field = field; }\n} Getters are expected to take no arguments other than &self and return the field's type. Setters are expected to take one argument other than &mut self (or &self) and return no values. The name for a getter is by default inferred from the function name it's attached to. The default name for a setter is the function's name minus the set_ prefix, and if set_ isn't a prefix of the function it's an error to not provide the name explicitly.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » getter and setter » getter and setter","id":"220","title":"getter and setter"},"221":{"body":"By default, structs exported from Rust become JavaScript classes with a single ptr property. All other properties are implemented as getters, which are not displayed when calling toJSON. The inspectable attribute can be used on Rust structs to provide a toJSON and toString implementation that display all readable fields. For example: #[wasm_bindgen(inspectable)]\npub struct Baz { pub field: i32, private: i32,\n} #[wasm_bindgen]\nimpl Baz { #[wasm_bindgen(constructor)] pub fn new(field: i32) -> Baz { Baz { field, private: 13 } }\n} Provides the following behavior as in this JavaScript snippet: const obj = new Baz(3);\nassert.deepStrictEqual(obj.toJSON(), { field: 3 });\nobj.field = 4;\nassert.strictEqual(obj.toString(), '{\"field\":4}'); One or both of these implementations can be overridden as desired. Note that the generated toString calls toJSON internally, so overriding toJSON will affect its output as a side effect. #[wasm_bindgen]\nimpl Baz { #[wasm_bindgen(js_name = toJSON)] pub fn to_json(&self) -> i32 { self.field } #[wasm_bindgen(js_name = toString)] pub fn to_string(&self) -> String { format!(\"Baz: {}\", self.field) }\n} Note that the output of console.log will remain unchanged and display only the ptr field in browsers. It is recommended to call toJSON or JSON.stringify in these situations to aid with logging or debugging. Node.js does not suffer from this limitation, see the section below.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » inspectable » inspectable","id":"221","title":"inspectable"},"222":{"body":"When the nodejs target is used, an additional [util.inspect.custom] implementation is provided which calls toJSON internally. This method is used for console.log and similar functions to display all readable fields of the Rust struct.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » inspectable » inspectable Classes in Node.js","id":"222","title":"inspectable Classes in Node.js"},"223":{"body":"By default, Rust exports exposed to JavaScript will generate TypeScript definitions (unless --no-typescript is used). The skip_typescript attribute can be used to disable type generation per function, enum, struct, or field. For example: #[wasm_bindgen(skip_typescript)]\npub enum MyHiddenEnum { One, Two, Three\n} #[wasm_bindgen]\npub struct MyPoint { pub x: u32, #[wasm_bindgen(skip_typescript)] pub y: u32,\n} #[wasm_bindgen]\nimpl MyPoint { #[wasm_bindgen(skip_typescript)] pub fn stringify(&self) -> String { format!(\"({}, {})\", self.x, self.y) }\n} Will generate the following .d.ts file: /* tslint:disable */\n/* eslint-disable */\nexport class MyPoint { free(): void; x: number;\n} When combined with the typescript_custom_section attribute , this can be used to manually specify more specific function types instead of using the generated definitions.","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » skip_typescript » skip_typescript","id":"223","title":"skip_typescript"},"224":{"body":"By default, Rust exports exposed to JavaScript will generate getters that require fields to implement Copy. The getter_with_clone attribute can be used to generate getters that require Clone instead. This attribute can be applied per struct or per field. For example: #[wasm_bindgen]\npub struct Foo { #[wasm_bindgen(getter_with_clone)] pub bar: String,\n} #[wasm_bindgen(getter_with_clone)]\npub struct Foo { pub bar: String, pub baz: String,\n}","breadcrumbs":"Reference » #[wasm_bindgen] Attributes » On Rust Exports » getter_with_clone » getter_with_clone","id":"224","title":"getter_with_clone"},"225":{"body":"The web-sys crate provides raw wasm-bindgen imports for all of the Web's APIs. This includes: window.fetch Node.prototype.appendChild WebGL WebAudio and many more! It's sort of like the libc crate, but for the Web. It does not include the JavaScript APIs that are guaranteed to exist in all standards-compliant ECMAScript environments, such as Array, Date, and eval. Bindings for these APIs can be found in the js-sys crate .","breadcrumbs":"web-sys » The web-sys Crate","id":"225","title":"The web-sys Crate"},"226":{"body":"Read the web-sys API documentation here!","breadcrumbs":"web-sys » API Documentation","id":"226","title":"API Documentation"},"227":{"body":"","breadcrumbs":"web-sys » Using web-sys » Using web-sys","id":"227","title":"Using web-sys"},"228":{"body":"[dependencies]\nwasm-bindgen = \"0.2\" [dependencies.web-sys]\nversion = \"0.3\"\nfeatures = [\n]","breadcrumbs":"web-sys » Using web-sys » Add web-sys as a dependency to your Cargo.toml","id":"228","title":"Add web-sys as a dependency to your Cargo.toml"},"229":{"body":"To keep build times super speedy, web-sys gates each Web interface behind a cargo feature . Find the type or method you want to use in the API documentation ; it will list the features that must be enabled to access that API. For example, if we're looking for the window.resizeTo function , we would search for resizeTo in the API documentation . We would find the web_sys::Window::resize_to function , which requires the Window feature. To get access to that function, we enable the Window feature in Cargo.toml: [dependencies.web-sys]\nversion = \"0.3\"\nfeatures = [ \"Window\"\n]","breadcrumbs":"web-sys » Using web-sys » Enable the cargo features for the APIs you're using","id":"229","title":"Enable the cargo features for the APIs you're using"},"23":{"body":"use js_sys::{Array, Date};\nuse wasm_bindgen::prelude::*;\nuse web_sys::{Document, Element, HtmlElement, Window}; #[wasm_bindgen(start)]\nfn run() -> Result<(), JsValue> { let window = web_sys::window().expect(\"should have a window in this context\"); let document = window.document().expect(\"window should have a document\"); // One of the first interesting things we can do with closures is simply // access stack data in Rust! let array = Array::new(); array.push(&\"Hello\".into()); array.push(&1.into()); let mut first_item = None; array.for_each(&mut |obj, idx, _arr| match idx { 0 => { assert_eq!(obj, \"Hello\"); first_item = obj.as_string(); } 1 => assert_eq!(obj, 1), _ => panic!(\"unknown index: {}\", idx), }); assert_eq!(first_item, Some(\"Hello\".to_string())); // Below are some more advanced usages of the `Closure` type for closures // that need to live beyond our function call. setup_clock(&window, &document)?; setup_clicker(&document); // And now that our demo is ready to go let's switch things up so // everything is displayed and our loading prompt is hidden. document .get_element_by_id(\"loading\") .expect(\"should have #loading on the page\") .dyn_ref::<HtmlElement>() .expect(\"#loading should be an `HtmlElement`\") .style() .set_property(\"display\", \"none\")?; document .get_element_by_id(\"script\") .expect(\"should have #script on the page\") .dyn_ref::<HtmlElement>() .expect(\"#script should be an `HtmlElement`\") .style() .set_property(\"display\", \"block\")?; Ok(())\n} // Set up a clock on our page and update it each second to ensure it's got\n// an accurate date.\n//\n// Note the usage of `Closure` here because the closure is \"long lived\",\n// basically meaning it has to persist beyond the call to this one function.\n// Also of note here is the `.as_ref().unchecked_ref()` chain, which is how\n// you can extract `&Function`, what `web-sys` expects, from a `Closure`\n// which only hands you `&JsValue` via `AsRef`.\nfn setup_clock(window: &Window, document: &Document) -> Result<(), JsValue> { let current_time = document .get_element_by_id(\"current-time\") .expect(\"should have #current-time on the page\"); update_time(&current_time); let a = Closure::<dyn Fn()>::new(move || update_time(&current_time)); window .set_interval_with_callback_and_timeout_and_arguments_0(a.as_ref().unchecked_ref(), 1000)?; fn update_time(current_time: &Element) { current_time.set_inner_html(&String::from( Date::new_0().to_locale_string(\"en-GB\", &JsValue::undefined()), )); } // The instance of `Closure` that we created will invalidate its // corresponding JS callback whenever it is dropped, so if we were to // normally return from `setup_clock` then our registered closure will // raise an exception when invoked. // // Normally we'd store the handle to later get dropped at an appropriate // time but for now we want it to be a global handler so we use the // `forget` method to drop it without invalidating the closure. Note that // this is leaking memory in Rust, so this should be done judiciously! a.forget(); Ok(())\n} // We also want to count the number of times that our green square has been\n// clicked. Our callback will update the `#num-clicks` div.\n//\n// This is pretty similar above, but showing how closures can also implement\n// `FnMut()`.\nfn setup_clicker(document: &Document) { let num_clicks = document .get_element_by_id(\"num-clicks\") .expect(\"should have #num-clicks on the page\"); let mut clicks = 0; let a = Closure::<dyn FnMut()>::new(move || { clicks += 1; num_clicks.set_inner_html(&clicks.to_string()); }); document .get_element_by_id(\"green-square\") .expect(\"should have #green-square on the page\") .dyn_ref::<HtmlElement>() .expect(\"#green-square be an `HtmlElement`\") .set_onclick(Some(a.as_ref().unchecked_ref())); // See comments in `setup_clock` above for why we use `a.forget()`. a.forget();\n}","breadcrumbs":"Examples » web-sys: Closures » src/lib.rs","id":"23","title":"src/lib.rs"},"230":{"body":"use wasm_bindgen::prelude::*;\nuse web_sys::Window; #[wasm_bindgen]\npub fn make_the_window_small() { // Resize the window to 500px by 500px. let window = web_sys::window().unwrap(); window.resize_to(500, 500) .expect(\"could not resize the window\");\n}","breadcrumbs":"web-sys » Using web-sys » Call the method!","id":"230","title":"Call the method!"},"231":{"body":"To keep web-sys building as fast as possible, there is a cargo feature for every type defined in web-sys. To access that type, you must enable its feature. To access a method, you must enable the feature for its self type and the features for each of its argument types. In the API documentation , every method lists the features that are required to enable it. For example, the WebGlRenderingContext::compile_shader function requires these features: WebGlRenderingContext, because that is the method's self type WebGlShader, because it takes an argument of that type","breadcrumbs":"web-sys » Cargo Features » Cargo Features in web-sys","id":"231","title":"Cargo Features in web-sys"},"232":{"body":"Many Web APIs are overloaded to take different types of arguments or to skip arguments completely. web-sys contains multiple bindings for these functions that each specialize to a particular overload and set of argument types. For example, the fetch API can be given a URL string, or a Request object, and it might also optionally be given a RequestInit options object. Therefore, we end up with these web-sys functions that all bind to the window.fetch function: Window::fetch_with_str Window::fetch_with_request Window::fetch_with_str_and_init Window::fetch_with_request_and_init Note that different overloads can use different interfaces, and therefore can require different sets of cargo features to be enabled.","breadcrumbs":"web-sys » Function Overloads » Function Overloads","id":"232","title":"Function Overloads"},"233":{"body":"Most of the types specified in WebIDL (the interface definition language for all Web APIs) have relatively straightforward translations into web-sys, but it's worth calling out a few in particular: BufferSource and ArrayBufferView - these two types show up in a number of APIs that generally deal with a buffer of bytes. We bind them in web-sys with two different types, js_sys::Object and &mut [u8]. Using js_sys::Object allows passing in arbitrary JS values which represent a view of bytes (like any typed array object), and &mut [u8] allows using a raw slice in Rust. Unfortunately we must pessimistically assume that JS will modify all slices as we don't currently have information of whether they're modified or not. Callbacks are all represented as js_sys::Function. This means that all callbacks going through web-sys are a raw JS value. You can work with this by either juggling actual js_sys::Function instances or you can create a Closure<dyn FnMut(...)>, extract the underlying JsValue with as_ref, and then use JsCast::unchecked_ref to convert it to a js_sys::Function.","breadcrumbs":"web-sys » Type Translations » Type Translations in web-sys","id":"233","title":"Type Translations in web-sys"},"234":{"body":"Inheritance between JS classes is the bread and butter of how the DOM works on the web, and as a result it's quite important for web-sys to provide access to this inheritance hierarchy as well! There are few ways you can access the inheritance hierarchy when using web-sys.","breadcrumbs":"web-sys » Inheritance » Inheritance in web-sys","id":"234","title":"Inheritance in web-sys"},"235":{"body":"Like smart pointers in Rust, all types in web_sys implement Deref to their parent JS class. This means, for example, if you have a web_sys::Element you can create a web_sys::Node from that implicitly: let element: &Element = ...; element.append_child(..); // call a method on `Node` method_expecting_a_node(&element); // coerce to `&Node` implicitly let node: &Node = &element; // explicitly coerce to `&Node` Using Deref allows ergonomic transitioning up the inheritance hierarchy to the parent class and beyond, giving you access to all the methods using the . operator.","breadcrumbs":"web-sys » Inheritance » Accessing parent classes using Deref","id":"235","title":"Accessing parent classes using Deref"},"236":{"body":"In addition to Deref, the AsRef trait is implemented for all types in web_sys for all types in the inheritance hierarchy. For example for the HtmlAnchorElement type you'll find: impl AsRef<HtmlElement> for HtmlAnchorElement\nimpl AsRef<Element> for HtmlAnchorElement\nimpl AsRef<Node> for HtmlAnchorElement\nimpl AsRef<EventTarget> for HtmlAnchorElement\nimpl AsRef<Object> for HtmlAnchorElement\nimpl AsRef<JsValue> for HtmlAnchorElement You can use .as_ref() to explicitly get a reference to any parent class from from a type in web_sys. Note that because of the number of AsRef implementations you'll likely need to have type inference guidance as well.","breadcrumbs":"web-sys » Inheritance » Accessing parent classes using AsRef","id":"236","title":"Accessing parent classes using AsRef"},"237":{"body":"Finally the wasm_bindgen::JsCast trait can be used to implement all manner of casts between types. It supports static unchecked casts between types as well as dynamic runtime-checked casts (using instanceof) between types. More documentation about this can be found on the trait itself","breadcrumbs":"web-sys » Inheritance » Accessing child classes using JsCast","id":"237","title":"Accessing child classes using JsCast"},"238":{"body":"It's common for browsers to implement parts of a web API while the specification for that API is still being written. The API may require frequent changes as the specification continues to be developed, so the WebIDL is relatively unstable. This causes some challenges for web-sys because it means web-sys would have to make breaking API changes whenever the WebIDL changes. It also means that previously published web-sys versions would be invalid, because the browser API may have been changed to match the updated WebIDL. To avoid frequent breaking changes for unstable APIs, web-sys hides all unstable APIs through an attribute that looks like: #[cfg(web_sys_unstable_apis)]\npub struct Foo; By hiding unstable APIs through an attribute, it's necessary for crates to explicitly opt-in to these reduced stability guarantees in order to use these APIs. Specifically, these APIs do not follow semver and may break whenever the WebIDL changes. Crates can opt-in to unstable APIs at compile-time by passing the cfg flag web_sys_unstable_apis. Typically the RUSTFLAGS environment variable is used to do this. For example: RUSTFLAGS=--cfg=web_sys_unstable_apis cargo run Alternatively, you can create a cargo config file to set its rustflags : Within ./.cargo/config.toml: [build]\nrustflags = [\"--cfg=web_sys_unstable_apis\"]","breadcrumbs":"web-sys » Unstable APIs » Unstable APIs","id":"238","title":"Unstable APIs"},"239":{"body":"The wasm-bindgen-test crate is an experimental test harness for Rust programs compiled to Wasm using wasm-bindgen and the wasm32-unknown-unknown target.","breadcrumbs":"Testing with wasm-bindgen-test » Testing on wasm32-unknown-unknown with wasm-bindgen-test","id":"239","title":"Testing on wasm32-unknown-unknown with wasm-bindgen-test"},"24":{"body":"View full source code or view the compiled example online Want to profile some Rust code in the browser? No problem! You can use the performance.now() API and friends to get timing information to see how long things take.","breadcrumbs":"Examples » web-sys: performance.now » web-sys: performance.now","id":"24","title":"web-sys: performance.now"},"240":{"body":"Write tests for Wasm as similar as possible to how you normally would write #[test]-style unit tests for native targets. Run the tests with the usual cargo test command but with an explicit wasm target: cargo test --target wasm32-unknown-unknown","breadcrumbs":"Testing with wasm-bindgen-test » Goals","id":"240","title":"Goals"},"241":{"body":"","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Using wasm-bindgen-test","id":"241","title":"Using wasm-bindgen-test"},"242":{"body":"[dev-dependencies]\nwasm-bindgen-test = \"0.3.0\" Note that the 0.3.0 track of wasm-bindgen-test supports Rust 1.39.0+, which is currently the nightly channel (as of 2019-09-05). If you want support for older compilers use the 0.2.* track of wasm-bindgen-test.","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Add wasm-bindgen-test to Your Cargo.toml's [dev-dependencies]","id":"242","title":"Add wasm-bindgen-test to Your Cargo.toml's [dev-dependencies]"},"243":{"body":"Create a $MY_CRATE/tests/wasm.rs file: use wasm_bindgen_test::*; #[wasm_bindgen_test]\nfn pass() { assert_eq!(1, 1);\n} #[wasm_bindgen_test]\nfn fail() { assert_eq!(1, 2);\n} // On a target other then `wasm32-unknown-unknown`, the `#[test]` attribute\n// will be used instead, allowing this test to run on any target.\n#[wasm_bindgen_test(unsupported = test)]\nfn all_targets() { assert_eq!(1, 2);\n} Writing tests is the same as normal Rust #[test]s, except we are using the #[wasm_bindgen_test] attribute. One other difference is that the tests must be in the root of the crate, or within a pub mod. Putting them inside a private module will not work.","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Write Some Tests","id":"243","title":"Write Some Tests"},"244":{"body":"Run the tests with wasm-pack test. By default, the tests are generated to target Node.js, but you can configure tests to run inside headless browsers as well. $ wasm-pack test --node Finished dev [unoptimized + debuginfo] target(s) in 0.11s Running /home/.../target/wasm32-unknown-unknown/debug/deps/wasm-4a309ffe6ad80503.wasm\nrunning 2 tests test wasm::pass ... ok\ntest wasm::fail ... FAILED failures: ---- wasm::fail output ---- error output: panicked at 'assertion failed: `(left == right)` left: `1`, right: `2`', crates/test/tests/wasm.rs:14:5 JS exception that was thrown: RuntimeError: unreachable at __rust_start_panic (wasm-function[1362]:33) at rust_panic (wasm-function[1357]:30) at std::panicking::rust_panic_with_hook::h56e5e464b0e7fc22 (wasm-function[1352]:444) at std::panicking::continue_panic_fmt::had70ba48785b9a8f (wasm-function[1350]:122) at std::panicking::begin_panic_fmt::h991e7d1ca9bf9c0c (wasm-function[1351]:95) at wasm::fail::ha4c23c69dfa0eea9 (wasm-function[88]:477) at core::ops::function::FnOnce::call_once::h633718dad359559a (wasm-function[21]:22) at wasm_bindgen_test::__rt::Context::execute::h2f669104986475eb (wasm-function[13]:291) at __wbg_test_fail_1 (wasm-function[87]:57) at module.exports.__wbg_apply_2ba774592c5223a7 (/home/alex/code/wasm-bindgen/target/wasm32-unknown-unknown/wbg-tmp/wasm-4a309ffe6ad80503.js:61:66) failures: wasm::fail test result: FAILED. 1 passed; 1 failed; 0 ignored error: test failed, to rerun pass '--test wasm' That's it!","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Execute Your Tests","id":"244","title":"Execute Your Tests"},"245":{"body":"⚠️ The recommended way to use wasm-bindgen-test is with wasm-pack, since it will handle installing the test runner, installing a WebDriver client for your browser, and informing cargo how to use the custom test runner. However, you can also manage those tasks yourself, if you wish. In addition to the steps above, you must also do the following.","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Appendix: Using wasm-bindgen-test without wasm-pack","id":"245","title":"Appendix: Using wasm-bindgen-test without wasm-pack"},"246":{"body":"The test runner comes along with the main wasm-bindgen CLI tool. Make sure to replace \"X.Y.Z\" with the same version of wasm-bindgen that you already have in Cargo.toml! cargo install wasm-bindgen-cli --vers \"X.Y.Z\"","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Install the Test Runner","id":"246","title":"Install the Test Runner"},"247":{"body":"Add this to $MY_CRATE/.cargo/config: [target.wasm32-unknown-unknown]\nrunner = 'wasm-bindgen-test-runner'","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Configure .cargo/config to use the Test Runner","id":"247","title":"Configure .cargo/config to use the Test Runner"},"248":{"body":"Run the tests by passing --target wasm32-unknown-unknown to cargo test: cargo test --target wasm32-unknown-unknown","breadcrumbs":"Testing with wasm-bindgen-test » Usage » Run the Tests","id":"248","title":"Run the Tests"},"249":{"body":"Not all tests can execute immediately and some may need to do \"blocking\" work like fetching resources and/or other bits and pieces. To accommodate this asynchronous tests are also supported through the futures and wasm-bindgen-futures crates. Writing an asynchronous test is pretty simple, just use an async function! You'll also likely want to use the wasm-bindgen-futures crate to convert JS promises to Rust futures. use wasm_bindgen::prelude::*;\nuse wasm_bindgen_futures::JsFuture; #[wasm_bindgen_test]\nasync fn my_async_test() { // Create a promise that is ready on the next tick of the micro task queue. let promise = js_sys::Promise::resolve(&JsValue::from(42)); // Convert that promise into a future and make the test wait on it. let x = JsFuture::from(promise).await.unwrap(); assert_eq!(x, 42);\n}","breadcrumbs":"Testing with wasm-bindgen-test » Writing Asynchronous Tests » Writing Asynchronous Tests","id":"249","title":"Writing Asynchronous Tests"},"25":{"body":"use std::time::{Duration, SystemTime, UNIX_EPOCH}; use wasm_bindgen::prelude::*; // lifted from the `console_log` example\n#[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(a: &str);\n} macro_rules! console_log { ($($t:tt)*) => (log(&format_args!($($t)*).to_string()))\n} #[wasm_bindgen(start)]\nfn run() { let window = web_sys::window().expect(\"should have a window in this context\"); let performance = window .performance() .expect(\"performance should be available\"); console_log!(\"the current time (in ms) is {}\", performance.now()); let start = perf_to_system(performance.timing().request_start()); let end = perf_to_system(performance.timing().response_end()); console_log!(\"request started at {}\", humantime::format_rfc3339(start)); console_log!(\"request ended at {}\", humantime::format_rfc3339(end));\n} fn perf_to_system(amt: f64) -> SystemTime { let secs = (amt as u64) / 1_000; let nanos = (((amt as u64) % 1_000) as u32) * 1_000_000; UNIX_EPOCH + Duration::new(secs, nanos)\n}","breadcrumbs":"Examples » web-sys: performance.now » src/lib.rs","id":"25","title":"src/lib.rs"},"250":{"body":"Note that async functions are only supported in stable from Rust 1.39.0 and beyond. If you're using the futures crate from crates.io in its 0.1 version then you'll want to use the 0.3.* version of wasm-bindgen-futures and the 0.2.8 version of wasm-bindgen-test. In those modes you'll also need to use #[wasm_bindgen_test(async)] instead of using an async function. In general we'd recommend using the nightly version with async since the user experience is much improved!","breadcrumbs":"Testing with wasm-bindgen-test » Writing Asynchronous Tests » Rust compiler compatibility","id":"250","title":"Rust compiler compatibility"},"251":{"body":"","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Testing in Headless Browsers","id":"251","title":"Testing in Headless Browsers"},"252":{"body":"By default tests run on Node.js. To target browsers you can use the WASM_BINDGEN_USE_BROWSER environment variable: WASM_BINDGEN_USE_BROWSER=1 cargo test --target wasm32-unknown-unknown The following configurations are available: WASM_BINDGEN_USE_DEDICATED_WORKER: for dedicated workers WASM_BINDGEN_USE_SHARED_WORKER: for shared workers WASM_BINDGEN_USE_SERVICE_WORKER: for service workers WASM_BINDGEN_USE_DENO: for Deno WASM_BINDGEN_USE_NODE_EXPERIMENTAL: for Node.js but as an ES module","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Configure via Environment Variables","id":"252","title":"Configure via Environment Variables"},"253":{"body":"Tests can also be forced to run in a certain environment by using the wasm_bindgen_test_configure! macro: use wasm_bindgen_test::wasm_bindgen_test_configure; // Run in a browser.\nwasm_bindgen_test_configure!(run_in_browser);\n// Or run in a dedicated worker.\nwasm_bindgen_test_configure!(run_in_dedicated_worker);\n// Or run in a shared worker.\nwasm_bindgen_test_configure!(run_in_shared_worker);\n// Or run in a service worker.\nwasm_bindgen_test_configure!(run_in_service_worker);\n// Or run in Node.js but as an ES module.\nwasm_bindgen_test_configure!(run_in_node_experimental); Note that this will ignore any environment variable set.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Force Configuration","id":"253","title":"Force Configuration"},"254":{"body":"To control which browser is used for headless testing, use the appropriate flag with wasm-pack test: wasm-pack test --chrome — Run the tests in Chrome. This machine must have Chrome installed. wasm-pack test --firefox — Run the tests in Firefox. This machine must have Firefox installed. wasm-pack test --safari — Run the tests in Safari. This machine must have Safari installed. If multiple browser flags are passed, the tests will be run under each browser.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Configuring Which Browser is Used","id":"254","title":"Configuring Which Browser is Used"},"255":{"body":"Once the tests are configured to run in a headless browser, just run wasm-pack test with the appropriate browser flags and --headless: wasm-pack test --headless --chrome --firefox --safari","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Running the Tests in the Headless Browser","id":"255","title":"Running the Tests in the Headless Browser"},"256":{"body":"Add the file webdriver.json to the root of your crate. Each browser has own section for capabilities. For example: { \"moz:firefoxOptions\": { \"prefs\": { \"media.navigator.streams.fake\": true, \"media.navigator.permission.disabled\": true }, \"args\": [] }, \"goog:chromeOptions\": { \"args\": [ \"--use-fake-device-for-media-stream\", \"--use-fake-ui-for-media-stream\" ] }\n} Full list supported capabilities can be found: for Chrome - here for Firefox - here Note that the headless argument is always enabled for both browsers.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Configuring Headless Browser capabilities","id":"256","title":"Configuring Headless Browser capabilities"},"257":{"body":"Omitting the --headless flag will disable headless mode, and allow you to debug failing tests in your browser's devtools.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Debugging Headless Browser Tests","id":"257","title":"Debugging Headless Browser Tests"},"258":{"body":"⚠️ The recommended way to use wasm-bindgen-test is with wasm-pack, since it will handle installing the test runner, installing a WebDriver client for your browser, and informing cargo how to use the custom test runner. However, you can also manage those tasks yourself, if you wish.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Appendix: Testing in headless browsers without wasm-pack","id":"258","title":"Appendix: Testing in headless browsers without wasm-pack"},"259":{"body":"If one of the following environment variables is set, then the corresponding WebDriver and browser will be used. If none of these environment variables are set, then the $PATH is searched for a suitable WebDriver implementation. GECKODRIVER=path/to/geckodriver Use Firefox for headless browser testing, and geckodriver as its WebDriver. The firefox binary must be on your $PATH. Get geckodriver here CHROMEDRIVER=path/to/chromedriver Use Chrome for headless browser testing, and chromedriver as its WebDriver. The chrome binary must be on your $PATH. Get chromedriver here SAFARIDRIVER=path/to/safaridriver Use Safari for headless browser testing, and safaridriver as its WebDriver. This is installed by default on Mac OS. It should be able to find your Safari installation by default.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Configuring Which Browser is Used","id":"259","title":"Configuring Which Browser is Used"},"26":{"body":"View full source code or view the compiled example online This example uses the fetch API to make an HTTP request to the GitHub API and then parses the resulting JSON.","breadcrumbs":"Examples » web-sys: using fetch » The fetch API","id":"26","title":"The fetch API"},"260":{"body":"Tests can be run on a remote webdriver. To do this, the above environment variables must be set as URL to the remote webdriver. For example: CHROMEDRIVER_REMOTE=http://remote.host/","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Running the Tests in the Remote Headless Browser","id":"260","title":"Running the Tests in the Remote Headless Browser"},"261":{"body":"Once the tests are configured to run in a headless browser and the appropriate environment variables are set, executing the tests for headless browsers is the same as executing them for Node.js: cargo test --target wasm32-unknown-unknown Debugging Headless Browser Tests Set the NO_HEADLESS=1 environment variable and the browser tests will not run headless. Instead, the tests will start a local server that you can visit in your Web browser of choices, and headless testing should not be used. You can then use your browser's devtools to debug.","breadcrumbs":"Testing with wasm-bindgen-test » Testing in Headless Browsers » Running the Tests in the Headless Browser","id":"261","title":"Running the Tests in the Headless Browser"},"262":{"body":"This page contains example configurations for running wasm-bindgen-test-based tests in various CI services. Is your favorite CI service missing? Send us a pull request!","breadcrumbs":"Testing with wasm-bindgen-test » Continuous Integration » Setting Up Continuous Integration with wasm-bindgen-test","id":"262","title":"Setting Up Continuous Integration with wasm-bindgen-test"},"263":{"body":"language: rust\nrust : nightly addons: firefox: latest chrome : stable install: - curl https://rustwasm.github.io/wasm-pack/installer/init.sh -sSf | sh script: # this will test the non Wasm targets if your crate has those, otherwise remove this line. # - cargo test - wasm-pack test --firefox --headless - wasm-pack test --chrome --headless","breadcrumbs":"Testing with wasm-bindgen-test » Continuous Integration » Travis CI","id":"263","title":"Travis CI"},"264":{"body":"install: - ps: Install-Product node 10 - appveyor-retry appveyor DownloadFile https://win.rustup.rs/ -FileName rustup-init.exe - rustup-init.exe -y --default-host x86_64-pc-windows-msvc --default-toolchain nightly - set PATH=%PATH%;C:\\Users\\appveyor\\.cargo\\bin - rustc -V - cargo -V - rustup target add wasm32-unknown-unknown - cargo install wasm-bindgen-cli build: false test_script: # Test in Chrome. chromedriver is installed by default in appveyor. - set CHROMEDRIVER=C:\\Tools\\WebDriver\\chromedriver.exe - cargo test --target wasm32-unknown-unknown - set CHROMEDRIVER= # Test in Firefox. geckodriver is also installed by default. - set GECKODRIVER=C:\\Tools\\WebDriver\\geckodriver.exe - cargo test --target wasm32-unknown-unknown","breadcrumbs":"Testing with wasm-bindgen-test » Continuous Integration » AppVeyor","id":"264","title":"AppVeyor"},"265":{"body":"on: [push, pull_request] jobs: test: runs-on: ubuntu-latest steps: - uses: actions/checkout@v2 - name: Install run: curl https://rustwasm.github.io/wasm-pack/installer/init.sh -sSf | sh - run: cargo test - run: wasm-pack test --headless --chrome - run: wasm-pack test --headless --firefox","breadcrumbs":"Testing with wasm-bindgen-test » Continuous Integration » GitHub Actions","id":"265","title":"GitHub Actions"},"266":{"body":"You can ask the runner to generate coverage data from functions marked as #[wasm_bindgen_test] in the .profraw format. Coverage is still in an experimental state, requires Rust Nightly, may be unreliable and could experience breaking changes at any time.","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Generating Coverage Data","id":"266","title":"Generating Coverage Data"},"267":{"body":"To enable this feature, you need to enable cfg(wasm_bindgen_unstable_test_coverage).","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Enabling the feature","id":"267","title":"Enabling the feature"},"268":{"body":"","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Generating the data","id":"268","title":"Generating the data"},"269":{"body":"Make sure you are using RUSTFLAGS=-Cinstrument-coverage -Zno-profiler-runtime. Due to the current limitation of llvm-cov, we can't collect profiling symbols from the generated .wasm files. Instead, we can grab them from the LLVM IR with --emit=llvm-ir by using Clang. Usage of Clang or any LLVM tools must match the LLVM version used by Rust.","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » RUSTFLAGS that need to be present","id":"269","title":"RUSTFLAGS that need to be present"},"27":{"body":"The Cargo.toml enables a number of features related to the fetch API and types used: Headers, Request, etc. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"fetch\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" }\nwasm-bindgen-futures = { path = \"../../crates/futures\" } [dependencies.web-sys]\nfeatures = ['Headers', 'Request', 'RequestInit', 'RequestMode', 'Response', 'Window']\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: using fetch » Cargo.toml","id":"27","title":"Cargo.toml"},"270":{"body":"The following environment variables can be used to control the coverage output when executing the test runner : WASM_BINDGEN_UNSTABLE_TEST_PROFRAW_OUT to control the file name of the profraw or the directory in which it is placed. It might be necessary to provide the full path if e.g. running tests in a workspace. WASM_BINDGEN_UNSTABLE_TEST_PROFRAW_PREFIX to add a custom prefix to the profraw files. This can be useful if you're running the tests automatically in succession.","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Arguments to the test runner","id":"270","title":"Arguments to the test runner"},"271":{"body":"This feature relies on the minicov crate, which provides a profiling runtime for WebAssembly. It in turn uses cc to compile the runtime to Wasm, which currently doesn't support accounting for target feature . Use e.g. CFLAGS_wasm32_unknown_unknown=\"-matomics -mbulk-memory\" to account for that.","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Target features","id":"271","title":"Target features"},"272":{"body":"This adapts code taken from the Rustc book , see that for more examples and general information on test coverage as well. # Run the tests:\n# `--tests` to not run documentation tests, which is currently not supported.\nRUSTFLAGS=\"-Cinstrument-coverage -Zno-profiler-runtime --emit=llvm-ir --cfg=wasm_bindgen_unstable_test_coverage\" \\\nCARGO_TARGET_WASM32_UNKNOWN_UNKNOWN_RUNNER=wasm-bindgen-test-runner \\\ncargo +nightly test --tests\n# Compile to object files:\n# - Extract a list of compiled artifacts from Cargo and filter them with `jq`.\n# - Figure out the path to the LLVM IR file corresponding to an artifact.\n# - Compile to object file with Clang and store for later usage with `llvm-cov`.\ncrate_name=name_of_the_tested_crate_in_snake_case\nobjects=()\nIFS=$'\\n'\nfor file in $( RUSTFLAGS=\"-Cinstrument-coverage -Zno-profiler-runtime --emit=llvm-ir --cfg=wasm_bindgen_unstable_test_coverage\" \\ cargo +nightly test --tests --no-run --message-format=json | \\ jq -r \"select(.reason == \\\"compiler-artifact\\\") | (select(.target.kind == [\\\"test\\\"]) // select(.target.name == \\\"$crate_name\\\")) | .filenames[0]\"\n)\ndo if [[ ${file##*.} == \"rlib\" ]]; then base=$(basename $file .rlib) file=$(dirname $file)/${base#\"lib\"}.ll else file=$(dirname $file)/$(basename $file .wasm).ll fi output = $(basename $file .ll).o clang-19 $file -Wno-override-module -c -o $output objects+=(-object $output)\ndone\n# Merge all generated raw profiling data.\nllvm-profdata-19 merge -sparse *.profraw -o coverage.profdata\n# Produce test coverage data in the HTML format and pass the object files we generated earlier.\nllvm-cov-19 show -show-instantiations=false -Xdemangler=rustfilt -output-dir coverage -format=html -instr-profile=coverage.profdata ${objects[@]} -sources src","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Example","id":"272","title":"Example"},"273":{"body":"These methods have originally been pioneered by Hacken OÜ , see their guide as well.","breadcrumbs":"Testing with wasm-bindgen-test » Coverage (Experimental) » Attribution","id":"273","title":"Attribution"},"274":{"body":"This section contains instructions on how to get this project up and running for development. You may want to browse the [unpublished guide documentation] for wasm-bindgen as well as it may have more up-to-date information.","breadcrumbs":"Contributing to wasm-bindgen » Contributing to wasm-bindgen","id":"274","title":"Contributing to wasm-bindgen"},"275":{"body":"Rust. Install Rust . Once Rust is installed, run rustup target add wasm32-unknown-unknown The tests for this project use Node. Make sure you have node >= 10 installed, as that is when WebAssembly support was introduced. Install Node .","breadcrumbs":"Contributing to wasm-bindgen » Prerequisites","id":"275","title":"Prerequisites"},"276":{"body":"Although formatting rules are not mandatory, it is encouraged to run cargo fmt (rustfmt) with its default rules within a PR to maintain a more organized code base. If necessary, a PR with a single commit that formats the entire project is also welcome.","breadcrumbs":"Contributing to wasm-bindgen » Code Formatting","id":"276","title":"Code Formatting"},"277":{"body":"","breadcrumbs":"Contributing to wasm-bindgen » Testing » Running wasm-bindgen's Tests","id":"277","title":"Running wasm-bindgen's Tests"},"278":{"body":"These are the largest test suites, and most common to run in day to day wasm-bindgen development. These tests are compiled to Wasm and then run in Node.js or a headless browser via the WebDriver protocol. WASM_BINDGEN_SPLIT_LINKED_MODULES=1 cargo test --target wasm32-unknown-unknown See the wasm-bindgen-test crate's README.md for details and configuring which headless browser is used.","breadcrumbs":"Contributing to wasm-bindgen » Testing » Wasm Tests on Node and Headless Browsers","id":"278","title":"Wasm Tests on Node and Headless Browsers"},"279":{"body":"This small test suite just verifies that exported wasm-bindgen methods can still be used on the native host's target. cargo test","breadcrumbs":"Contributing to wasm-bindgen » Testing » Sanity Tests for wasm-bindgen on the Native Host Target","id":"279","title":"Sanity Tests for wasm-bindgen on the Native Host Target"},"28":{"body":"use wasm_bindgen::prelude::*;\nuse wasm_bindgen_futures::JsFuture;\nuse web_sys::{Request, RequestInit, RequestMode, Response}; #[wasm_bindgen]\npub async fn run(repo: String) -> Result<JsValue, JsValue> { let opts = RequestInit::new(); opts.set_method(\"GET\"); opts.set_mode(RequestMode::Cors); let url = format!(\"https://api.github.com/repos/{}/branches/master\", repo); let request = Request::new_with_str_and_init(&url, &opts)?; request .headers() .set(\"Accept\", \"application/vnd.github.v3+json\")?; let window = web_sys::window().unwrap(); let resp_value = JsFuture::from(window.fetch_with_request(&request)).await?; // `resp_value` is a `Response` object. assert!(resp_value.is_instance_of::<Response>()); let resp: Response = resp_value.dyn_into().unwrap(); // Convert this other `Promise` into a rust `Future`. let json = JsFuture::from(resp.json()?).await?; // Send the JSON response back to JS. Ok(json)\n}","breadcrumbs":"Examples » web-sys: using fetch » src/lib.rs","id":"28","title":"src/lib.rs"},"280":{"body":"cargo test -p webidl-tests --target wasm32-unknown-unknown","breadcrumbs":"Contributing to wasm-bindgen » Testing » The Web IDL Frontend's Tests","id":"280","title":"The Web IDL Frontend's Tests"},"281":{"body":"These tests assert that we have reasonable error messages that point to the right source spans when the #[wasm_bindgen] proc-macro is misused. You can run these tests by running cargo test for the wasm-bindgen-macro crate: cargo test -p wasm-bindgen-macro","breadcrumbs":"Contributing to wasm-bindgen » Testing » The Macro UI Tests","id":"281","title":"The Macro UI Tests"},"282":{"body":"See the js-sys testing page .","breadcrumbs":"Contributing to wasm-bindgen » Testing » The js-sys Tests","id":"282","title":"The js-sys Tests"},"283":{"body":"See the web-sys testing page .","breadcrumbs":"Contributing to wasm-bindgen » Testing » The web-sys Tests","id":"283","title":"The web-sys Tests"},"284":{"body":"This section is intended to be a deep-dive into how wasm-bindgen internally works today, specifically for Rust. If you're reading this far in the future it may no longer be up to date, but feel free to open an issue and we can try to answer questions and/or update this!","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Design of wasm-bindgen","id":"284","title":"Design of wasm-bindgen"},"285":{"body":"The first thing to know about wasm-bindgen is that it's fundamentally built on the idea of ES Modules. In other words this tool takes an opinionated stance that Wasm files should be viewed as ES modules . This means that you can import from a Wasm file, use its export-ed functionality, etc, from normal JS files. Now unfortunately at the time of this writing the interface of Wasm interop isn't very rich. Wasm modules can only call functions or export functions that deal exclusively with i32, i64, f32, and f64. Bummer! That's where this project comes in. The goal of wasm-bindgen is to enhance the \"ABI\" of Wasm modules with richer types like classes, JS objects, Rust structs, strings, etc. Keep in mind, though, that everything is based on ES Modules! This means that the compiler is actually producing a \"broken\" Wasm file of sorts. The wasm file emitted by rustc, for example, does not have the interface we would like to have. Instead it requires the wasm-bindgen tool to postprocess the file, generating a foo.js and foo_bg.wasm file. The foo.js file is the desired interface expressed in JS (classes, types, strings, etc) and the foo_bg.wasm module is simply used as an implementation detail (it was lightly modified from the original foo.wasm file). As more features are stabilized in WebAssembly over time (like component model) the JS file is expected to get smaller and smaller. It's unlikely to ever disappear, but wasm-bindgen is designed to follow the WebAssembly spec and proposals closely to optimize JS/Rust as much as possible.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Foundation: ES Modules","id":"285","title":"Foundation: ES Modules"},"286":{"body":"On the more Rust-y side of things the wasm-bindgen crate is designed to ideally have as minimal impact on a Rust crate as possible. Ideally a few #[wasm_bindgen] attributes are annotated in key locations and otherwise you're off to the races. The attribute strives to both not invent new syntax and work with existing idioms today. For example a library might exposed a function in normal Rust that looks like: pub fn greet(name: &str) -> String { // ...\n} And with #[wasm_bindgen] all you need to do in exporting it to JS is: #[wasm_bindgen]\npub fn greet(name: &str) -> String { // ...\n} Additionally the design here with minimal intervention in Rust should allow us to easily take advantage of the upcoming component model proposal. Ideally you'd simply upgrade wasm-bindgen-the-crate as well as your toolchain and you're immediately getting raw access to component model! (this is still a bit of a ways off though...)","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Foundation #2: Unintrusive in Rust","id":"286","title":"Foundation #2: Unintrusive in Rust"},"287":{"body":"One of the main goals of wasm-bindgen is to allow working with and passing around JS objects in wasm, but that's not allowed today! While indeed true, that's where the polyfill comes in. The question here is how we shoehorn JS objects into a u32 for Wasm to use. The current strategy for this approach is to maintain a module-local variable in the generated foo.js file: a heap.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » JS Objects in Rust » Polyfill for \"JS objects in wasm\"","id":"287","title":"Polyfill for \"JS objects in wasm\""},"288":{"body":"The first slots in the heap in foo.js are considered a stack. This stack, like typical program execution stacks, grows down. JS objects are pushed on the bottom of the stack, and their index in the stack is the identifier that's passed to wasm. A stack pointer is maintained to figure out where the next item is pushed. JS objects are then only removed from the bottom of the stack as well. Removal is simply storing null then incrementing a counter. Because of the \"stack-y\" nature of this scheme it only works for when Wasm doesn't hold onto a JS object (aka it only gets a \"reference\" in Rust parlance). Let's take a look at an example. // foo.rs\n#[wasm_bindgen]\npub fn foo(a: &JsValue) { // ...\n} Here we're using the special JsValue type from the wasm-bindgen library itself. Our exported function, foo, takes a reference to an object. This notably means that it can't persist the object past the lifetime of this function call. Now what we actually want to generate is a JS module that looks like (in TypeScript parlance) // foo.d.ts\nexport function foo(a: any); and what we actually generate looks something like: // foo.js\nimport * as wasm from './foo_bg'; const heap = new Array(32);\nheap.push(undefined, null, true, false);\nlet stack_pointer = 32; function addBorrowedObject(obj) { stack_pointer -= 1; heap[stack_pointer] = obj; return stack_pointer;\n} export function foo(arg0) { const idx0 = addBorrowedObject(arg0); try { wasm.foo(idx0); } finally { heap[stack_pointer++] = undefined; }\n} Here we can see a few notable points of action: The Wasm file was renamed to foo_bg.wasm, and we can see how the JS module generated here is importing from the Wasm file. Next we can see our heap module variable which is to store all JS values reference-able from wasm. Our exported function foo, takes an arbitrary argument, arg0, which is converted to an index with the addBorrowedObject object function. The index is then passed to Wasm so Wasm can operate with it. Finally, we have a finally which frees the stack slot as it's no longer used, popping the value that was pushed at the start of the function. It's also helpful to dig into the Rust side of things to see what's going on there! Let's take a look at the code that #[wasm_bindgen] generates in Rust: // what the user wrote\npub fn foo(a: &JsValue) { // ...\n} #[export_name = \"foo\"]\npub extern \"C\" fn __wasm_bindgen_generated_foo(arg0: u32) { let arg0 = unsafe { ManuallyDrop::new(JsValue::__from_idx(arg0)) }; let arg0 = &*arg0; foo(arg0);\n} And as with the JS, the notable points here are: The original function, foo, is unmodified in the output A generated function here (with a unique name) is the one that's actually exported from the Wasm module Our generated function takes an integer argument (our index) and then wraps it in a JsValue. There's some trickery here that's not worth going into just yet, but we'll see in a bit what's happening under the hood.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » JS Objects in Rust » Temporary JS objects on the \"stack\"","id":"288","title":"Temporary JS objects on the \"stack\""},"289":{"body":"The above strategy is useful when JS objects are only temporarily used in Rust, for example only during one function call. Sometimes, though, objects may have a dynamic lifetime or otherwise need to be stored on Rust's heap. To cope with this there's a second half of management of JS objects, naturally corresponding to the other side of the JS heap array. JS Objects passed to Wasm that are not references are assumed to have a dynamic lifetime inside of the Wasm module. As a result the strict push/pop of the stack won't work and we need more permanent storage for the JS objects. To cope with this we build our own \"slab allocator\" of sorts. A picture (or code) is worth a thousand words so let's show what happens with an example. // foo.rs\n#[wasm_bindgen]\npub fn foo(a: JsValue) { // ...\n} Note that the & is missing in front of the JsValue we had before, and in Rust parlance this means it's taking ownership of the JS value. The exported ES module interface is the same as before, but the ownership mechanics are slightly different. Let's see the generated JS's slab in action: import * as wasm from './foo_bg'; // imports from Wasm file const heap = new Array(32);\nheap.push(undefined, null, true, false);\nlet heap_next = 36; function addHeapObject(obj) { if (heap_next === heap.length) heap.push(heap.length + 1); const idx = heap_next; heap_next = heap[idx]; heap[idx] = obj; return idx;\n} export function foo(arg0) { const idx0 = addHeapObject(arg0); wasm.foo(idx0);\n} export function __wbindgen_object_drop_ref(idx) { heap[idx ] = heap_next; heap_next = idx;\n} Unlike before we're now calling addHeapObject on the argument to foo rather than addBorrowedObject. This function will use heap and heap_next as a slab allocator to acquire a slot to store the object, placing a structure there once it's found. Note that this is going on the right-half of the array, unlike the stack which resides on the left half. This discipline mirrors the stack/heap in normal programs, roughly. Another curious aspect of this generated module is the __wbindgen_object_drop_ref function. This is one that's actually imported to wasm rather than used in this module! This function is used to signal the end of the lifetime of a JsValue in Rust, or in other words when it goes out of scope. Otherwise though this function is largely just a general \"slab free\" implementation. And finally, let's take a look at the Rust generated again too: // what the user wrote\npub fn foo(a: JsValue) { // ...\n} #[export_name = \"foo\"]\npub extern \"C\" fn __wasm_bindgen_generated_foo(arg0: u32) { let arg0 = unsafe { JsValue::__from_idx(arg0) }; foo(arg0);\n} Ah that looks much more familiar! Not much interesting is happening here, so let's move on to...","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » JS Objects in Rust » Long-lived JS objects","id":"289","title":"Long-lived JS objects"},"29":{"body":"View full source code This example makes an HTTP request to OpenWeather API , parses response in JSON and render UI from that JSON. It also shows the usage of spawn_local function for handling asynchronous tasks. Please add your api key in get_response() before running this application.","breadcrumbs":"Examples » web-sys: Weather report » web-sys: Weather report","id":"29","title":"web-sys: Weather report"},"290":{"body":"Currently the JsValue struct is actually quite simple in Rust, it's: pub struct JsValue { idx: u32,\n} // \"private\" constructors impl Drop for JsValue { fn drop(&mut self) { unsafe { __wbindgen_object_drop_ref(self.idx); } }\n} Or in other words it's a newtype wrapper around a u32, the index that we're passed from wasm. The destructor here is where the __wbindgen_object_drop_ref function is called to relinquish our reference count of the JS object, freeing up our slot in the slab that we saw above. If you'll recall as well, when we took &JsValue above we generated a wrapper of ManuallyDrop around the local binding, and that's because we wanted to avoid invoking this destructor when the object comes from the stack.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » JS Objects in Rust » Anatomy of JsValue","id":"290","title":"Anatomy of JsValue"},"291":{"body":"The above explanations are pretty close to what happens today, but in reality there's a few differences especially around handling constant values like undefined, null, etc. Be sure to check out the actual generated JS and the generation code for the full details!","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » JS Objects in Rust » Working with heap in reality","id":"291","title":"Working with heap in reality"},"292":{"body":"Alright now that we've got a good grasp on JS objects and how they're working, let's take a look at another feature of wasm-bindgen: exporting functionality with types that are richer than just numbers. The basic idea around exporting functionality with more flavorful types is that the Wasm exports won't actually be called directly. Instead the generated foo.js module will have shims for all exported functions in the Wasm module. The most interesting conversion here happens with strings so let's take a look at that. #[wasm_bindgen]\npub fn greet(a: &str) -> String { format!(\"Hello, {}!\", a)\n} Here we'd like to define an ES module that looks like // foo.d.ts\nexport function greet(a: string): string; To see what's going on, let's take a look at the generated shim import * as wasm from './foo_bg'; function passStringToWasm(arg) { const buf = new TextEncoder('utf-8').encode(arg); const len = buf.length; const ptr = wasm.__wbindgen_malloc(len, 1); let array = new Uint8Array(wasm.memory.buffer); array.set(buf, ptr); return [ptr, len];\n} function getStringFromWasm(ptr, len) { const mem = new Uint8Array(wasm.memory.buffer); const slice = mem.slice(ptr, ptr + len); const ret = new TextDecoder('utf-8').decode(slice); return ret;\n} export function greet(arg0) { const [ptr0, len0] = passStringToWasm(arg0); try { const ret = wasm.greet(ptr0, len0); const ptr = wasm.__wbindgen_boxed_str_ptr(ret); const len = wasm.__wbindgen_boxed_str_len(ret); const realRet = getStringFromWasm(ptr, len); wasm.__wbindgen_boxed_str_free(ret); return realRet; } finally { wasm.__wbindgen_free(ptr0, len0, 1); }\n} Phew, that's quite a lot! We can sort of see though if we look closely what's happening: Strings are passed to Wasm via two arguments, a pointer and a length. Right now we have to copy the string onto the Wasm heap which means we'll be using TextEncoder to actually do the encoding. Once this is done we use an internal function in wasm-bindgen to allocate space for the string to go, and then we'll pass that ptr/length to Wasm later on. Returning strings from Wasm is a little tricky as we need to return a ptr/len pair, but Wasm currently only supports one return value (multiple return values is being standardized ). To work around this in the meantime, we're actually returning a pointer to a ptr/len pair, and then using functions to access the various fields. Some cleanup ends up happening in wasm. The __wbindgen_boxed_str_free function is used to free the return value of greet after it's been decoded onto the JS heap (using TextDecoder). The __wbindgen_free is then used to free the space we allocated to pass the string argument once the function call is done. Next let's take a look at the Rust side of things as well. Here we'll be looking at a mostly abbreviated and/or \"simplified\" in the sense of this is what it compiles down to: pub extern \"C\" fn greet(a: &str) -> String { format!(\"Hello, {}!\", a)\n} #[export_name = \"greet\"]\npub extern \"C\" fn __wasm_bindgen_generated_greet( arg0_ptr: *const u8, arg0_len: usize,\n) -> *mut String { let arg0 = unsafe { let slice = ::std::slice::from_raw_parts(arg0_ptr, arg0_len); ::std::str::from_utf8_unchecked(slice) }; let _ret = greet(arg0); Box::into_raw(Box::new(_ret))\n} Here we can see again that our greet function is unmodified and has a wrapper to call it. This wrapper will take the ptr/len argument and convert it to a string slice, while the return value is boxed up into just a pointer and is then returned up to was for reading via the __wbindgen_boxed_str_* functions. So in general exporting a function involves a shim both in JS and in Rust with each side translating to or from Wasm arguments to the native types of each language. The wasm-bindgen tool manages hooking up all these shims while the #[wasm_bindgen] macro takes care of the Rust shim as well. Most arguments have a relatively clear way to convert them, bit if you've got any questions just let me know!","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Exporting a function to JS » Exporting a function to JS","id":"292","title":"Exporting a function to JS"},"293":{"body":"So far we've covered JS objects, importing functions, and exporting functions. This has given us quite a rich base to build on so far, and that's great! We sometimes, though, want to go even further and define a JS class in Rust. Or in other words, we want to expose an object with methods from Rust to JS rather than just importing/exporting free functions. The #[wasm_bindgen] attribute can annotate both a struct and impl blocks to allow: #[wasm_bindgen]\npub struct Foo { internal: i32,\n} #[wasm_bindgen]\nimpl Foo { #[wasm_bindgen(constructor)] pub fn new(val: i32) -> Foo { Foo { internal: val } } pub fn get(&self) -> i32 { self.internal } pub fn set(&mut self, val: i32) { self.internal = val; }\n} This is a typical Rust struct definition for a type with a constructor and a few methods. Annotating the struct with #[wasm_bindgen] means that we'll generate necessary trait impls to convert this type to/from the JS boundary. The annotated impl block here means that the functions inside will also be made available to JS through generated shims. If we take a look at the generated JS code for this we'll see: import * as wasm from './js_hello_world_bg'; export class Foo { static __construct(ptr) { return new Foo(ptr); } constructor(ptr) { this.ptr = ptr; } free() { const ptr = this.ptr; this.ptr = 0; wasm.__wbg_foo_free(ptr); } static new(arg0) { const ret = wasm.foo_new(arg0); return Foo.__construct(ret) } get() { const ret = wasm.foo_get(this.ptr); return ret; } set(arg0) { const ret = wasm.foo_set(this.ptr, arg0); return ret; }\n} That's actually not much! We can see here though how we've translated from Rust to JS: Associated functions in Rust (those without self) turn into static functions in JS. Methods in Rust turn into methods in wasm. Manual memory management is exposed in JS as well. The free function is required to be invoked to deallocate resources on the Rust side of things. To be able to use new Foo(), you'd need to annotate new as #[wasm_bindgen(constructor)]. One important aspect to note here, though, is that once free is called the JS object is \"neutered\" in that its internal pointer is nulled out. This means that future usage of this object should trigger a panic in Rust. The real trickery with these bindings ends up happening in Rust, however, so let's take a look at that. // original input to `#[wasm_bindgen]` omitted ... #[export_name = \"foo_new\"]\npub extern \"C\" fn __wasm_bindgen_generated_Foo_new(arg0: i32) -> u32 { let ret = Foo::new(arg0); Box::into_raw(Box::new(WasmRefCell::new(ret))) as u32\n} #[export_name = \"foo_get\"]\npub extern \"C\" fn __wasm_bindgen_generated_Foo_get(me: u32) -> i32 { let me = me as *mut WasmRefCell<Foo>; wasm_bindgen::__rt::assert_not_null(me); let me = unsafe { &*me }; return me.borrow().get();\n} #[export_name = \"foo_set\"]\npub extern \"C\" fn __wasm_bindgen_generated_Foo_set(me: u32, arg1: i32) { let me = me as *mut WasmRefCell<Foo>; wasm_bindgen::__rt::assert_not_null(me); let me = unsafe { &*me }; me.borrow_mut().set(arg1);\n} #[no_mangle]\npub unsafe extern \"C\" fn __wbindgen_foo_free(me: u32) { let me = me as *mut WasmRefCell<Foo>; wasm_bindgen::__rt::assert_not_null(me); (*me).borrow_mut(); // ensure no active borrows drop(Box::from_raw(me));\n} As with before this is cleaned up from the actual output but it's the same idea as to what's going on! Here we can see a shim for each function as well as a shim for deallocating an instance of Foo. Recall that the only valid wasm types today are numbers, so we're required to shoehorn all of Foo into a u32, which is currently done via Box (like std::unique_ptr in C++). Note, though, that there's an extra layer here, WasmRefCell. This type is the same as RefCell and can be mostly glossed over. The purpose for this type, if you're interested though, is to uphold Rust's guarantees about aliasing in a world where aliasing is rampant (JS). Specifically the &Foo type means that there can be as much aliasing as you'd like, but crucially &mut Foo means that it is the sole pointer to the data (no other &Foo to the same instance exists). The RefCell type in libstd is a way of dynamically enforcing this at runtime (as opposed to compile time where it usually happens). Baking in WasmRefCell is the same idea here, adding runtime checks for aliasing which are typically happening at compile time. This is currently a Rust-specific feature which isn't actually in the wasm-bindgen tool itself, it's just in the Rust-generated code (aka the #[wasm_bindgen] attribute).","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Exporting a struct to JS » Exporting a struct to JS","id":"293","title":"Exporting a struct to JS"},"294":{"body":"Now that we've exported some rich functionality to JS it's also time to import some! The goal here is to basically implement JS import statements in Rust, with fancy types and all. First up, let's say we invert the function above and instead want to generate greetings in JS but call it from Rust. We might have, for example: #[wasm_bindgen(module = \"./greet\")]\nextern \"C\" { fn greet(a: &str) -> String;\n} fn other_code() { let greeting = greet(\"foo\"); // ...\n} The basic idea of imports is the same as exports in that we'll have shims in both JS and Rust doing the necessary translation. Let's first see the JS shim in action: import * as wasm from './foo_bg'; import { greet } from './greet'; // ... export function __wbg_f_greet(ptr0, len0, wasmretptr) { const [retptr, retlen] = passStringToWasm(greet(getStringFromWasm(ptr0, len0))); (new Uint32Array(wasm.memory.buffer))[wasmretptr / 4] = retlen; return retptr;\n} The getStringFromWasm and passStringToWasm are the same as we saw before, and like with __wbindgen_object_drop_ref far above we've got this weird export from our module now! The __wbg_f_greet function is what's generated by wasm-bindgen to actually get imported in the foo.wasm module. The generated foo.js we see imports from the ./greet module with the greet name (was the function import in Rust said) and then the __wbg_f_greet function is shimming that import. There's some tricky ABI business going on here so let's take a look at the generated Rust as well. Like before this is simplified from what's actually generated. extern \"C\" fn greet(a: &str) -> String { extern \"C\" { fn __wbg_f_greet(a_ptr: *const u8, a_len: usize, ret_len: *mut usize) -> *mut u8; } unsafe { let a_ptr = a.as_ptr(); let a_len = a.len(); let mut __ret_strlen = 0; let mut __ret_strlen_ptr = &mut __ret_strlen as *mut usize; let _ret = __wbg_f_greet(a_ptr, a_len, __ret_strlen_ptr); String::from_utf8_unchecked( Vec::from_raw_parts(_ret, __ret_strlen, __ret_strlen) ) }\n} Here we can see that the greet function was generated but it's largely just a shim around the __wbg_f_greet function that we're calling. The ptr/len pair for the argument is passed as two arguments and for the return value we're receiving one value (the length) indirectly while directly receiving the returned pointer.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Importing a function from JS » Importing a function from JS","id":"294","title":"Importing a function from JS"},"295":{"body":"Just like with functions after we've started exporting we'll also want to import! Now that we've exported a class to JS we'll want to also be able to import classes in Rust as well to invoke methods and such. Since JS classes are in general just JS objects the bindings here will look pretty similar to the JS object bindings describe above. As usual though, let's dive into an example! #[wasm_bindgen(module = \"./bar\")]\nextern \"C\" { type Bar; #[wasm_bindgen(constructor)] fn new(arg: i32) -> Bar; #[wasm_bindgen(js_namespace = Bar)] fn another_function() -> i32; #[wasm_bindgen(method)] fn get(this: &Bar) -> i32; #[wasm_bindgen(method)] fn set(this: &Bar, val: i32); #[wasm_bindgen(method, getter)] fn property(this: &Bar) -> i32; #[wasm_bindgen(method, setter)] fn set_property(this: &Bar, val: i32);\n} fn run() { let bar = Bar::new(Bar::another_function()); let x = bar.get(); bar.set(x + 3); bar.set_property(bar.property() + 6);\n} Unlike our previous imports, this one's a bit more chatty! Remember that one of the goals of wasm-bindgen is to use native Rust syntax wherever possible, so this is mostly intended to use the #[wasm_bindgen] attribute to interpret what's written down in Rust. Now there's a few attribute annotations here, so let's go through one-by-one: #[wasm_bindgen(module = \"./bar\")] - seen before with imports this is declare where all the subsequent functionality is imported from. For example the Bar type is going to be imported from the ./bar module. type Bar - this is a declaration of JS class as a new type in Rust. This means that a new type Bar is generated which is \"opaque\" but is represented as internally containing a JsValue. We'll see more on this later. #[wasm_bindgen(constructor)] - this indicates that the binding's name isn't actually used in JS but rather translates to new Bar(). The return value of this function must be a bare type, like Bar. #[wasm_bindgen(js_namespace = Bar)] - this attribute indicates that the function declaration is namespaced through the Bar class in JS. #[wasm_bindgen(static_method_of = SomeJsClass)] - this attribute is similar to js_namespace, but instead of producing a free function, produces a static method of SomeJsClass. #[wasm_bindgen(method)] - and finally, this attribute indicates that a method call is going to happen. The first argument must be a JS struct, like Bar, and the call in JS looks like Bar.prototype.set.call(...). With all that in mind, let's take a look at the JS generated. import * as wasm from './foo_bg'; import { Bar } from './bar'; // other support functions omitted... export function __wbg_s_Bar_new() { return addHeapObject(new Bar());\n} const another_function_shim = Bar.another_function;\nexport function __wbg_s_Bar_another_function() { return another_function_shim();\n} const get_shim = Bar.prototype.get;\nexport function __wbg_s_Bar_get(ptr) { return shim.call(getObject(ptr));\n} const set_shim = Bar.prototype.set;\nexport function __wbg_s_Bar_set(ptr, arg0) { set_shim.call(getObject(ptr), arg0)\n} const property_shim = Object.getOwnPropertyDescriptor(Bar.prototype, 'property').get;\nexport function __wbg_s_Bar_property(ptr) { return property_shim.call(getObject(ptr));\n} const set_property_shim = Object.getOwnPropertyDescriptor(Bar.prototype, 'property').set;\nexport function __wbg_s_Bar_set_property(ptr, arg0) { set_property_shim.call(getObject(ptr), arg0)\n} Like when importing functions from JS we can see a bunch of shims are generated for all the relevant functions. The new static function has the #[wasm_bindgen(constructor)] attribute which means that instead of any particular method it should actually invoke the new constructor instead (as we see here). The static function another_function, however, is dispatched as Bar.another_function. The get and set functions are methods so they go through Bar.prototype, and otherwise their first argument is implicitly the JS object itself which is loaded through getObject like we saw earlier. Some real meat starts to show up though on the Rust side of things, so let's take a look: pub struct Bar { obj: JsValue,\n} impl Bar { fn new() -> Bar { extern \"C\" { fn __wbg_s_Bar_new() -> u32; } unsafe { let ret = __wbg_s_Bar_new(); Bar { obj: JsValue::__from_idx(ret) } } } fn another_function() -> i32 { extern \"C\" { fn __wbg_s_Bar_another_function() -> i32; } unsafe { __wbg_s_Bar_another_function() } } fn get(&self) -> i32 { extern \"C\" { fn __wbg_s_Bar_get(ptr: u32) -> i32; } unsafe { let ptr = self.obj.__get_idx(); let ret = __wbg_s_Bar_get(ptr); return ret } } fn set(&self, val: i32) { extern \"C\" { fn __wbg_s_Bar_set(ptr: u32, val: i32); } unsafe { let ptr = self.obj.__get_idx(); __wbg_s_Bar_set(ptr, val); } } fn property(&self) -> i32 { extern \"C\" { fn __wbg_s_Bar_property(ptr: u32) -> i32; } unsafe { let ptr = self.obj.__get_idx(); let ret = __wbg_s_Bar_property(ptr); return ret } } fn set_property(&self, val: i32) { extern \"C\" { fn __wbg_s_Bar_set_property(ptr: u32, val: i32); } unsafe { let ptr = self.obj.__get_idx(); __wbg_s_Bar_set_property(ptr, val); } }\n} impl WasmBoundary for Bar { // ...\n} impl ToRefWasmBoundary for Bar { // ...\n} In Rust we're seeing that a new type, Bar, is generated for this import of a class. The type Bar internally contains a JsValue as an instance of Bar is meant to represent a JS object stored in our module's stack/slab. This then works mostly the same way that we saw JS objects work in the beginning. When calling Bar::new we'll get an index back which is wrapped up in Bar (which is itself just a u32 in memory when stripped down). Each function then passes the index as the first argument and otherwise forwards everything along in Rust.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Importing a class from JS » Importing a class from JS","id":"295","title":"Importing a class from JS"},"296":{"body":"Previously we've been seeing mostly abridged versions of type conversions when values enter Rust. Here we'll go into some more depth about how this is implemented. There are two categories of traits for converting values, traits for converting values from Rust to JS and traits for the other way around.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Rust Type conversions » Rust Type conversions","id":"296","title":"Rust Type conversions"},"297":{"body":"First up let's take a look at going from Rust to JS: pub trait IntoWasmAbi: WasmDescribe { type Abi: WasmAbi; fn into_abi(self) -> Self::Abi;\n} And that's it! This is actually the only trait needed currently for translating a Rust value to a JS one. There's a few points here: We'll get to WasmDescribe later in this section. The associated type Abi is the type of the raw data that we actually want to pass to JS. The bound WasmAbi is implemented for primitive types like u32 and f64, which can be represented directly as WebAssembly values, as well of a couple of other types like WasmSlice: pub struct WasmSlice { pub ptr: u32, pub len: u32,\n} This struct, which is how things like strings are represented in FFI, isn't a WebAssembly primitive type, and so it can't be mapped directly to a WebAssembly parameter / return value. This is why WasmAbi lets types specify how they can be split up into multiple WebAssembly parameters: impl WasmAbi for WasmSlice { fn split(self) -> (u32, u32, (), ()) { (self.ptr, self.len, (), ()) } // some other details to specify return type of `split`, go in the other direction\n} This means that a WasmSlice gets split up into two u32 parameters. The extra unit types on the end are there because Rust doesn't let us make WasmAbi generic over variable-length tuples, so we just take tuples of 4 elements. The unit types still end up getting passed to/from JS, but the C ABI just completely ignores them and doesn't generate any arguments. Since we can't return multiple values, when returning a WasmSlice we instead put the two u32s into a #[repr(C)] struct and return that. And finally we have the into_abi function, returning the Abi associated type which will be actually passed to JS. This trait is implemented for all types that can be converted to JS and is unconditionally used during codegen. For example you'll often see IntoWasmAbi for Foo but also IntoWasmAbi for &'a Foo. The IntoWasmAbi trait is used in two locations. First it's used to convert return values of Rust exported functions to JS. Second it's used to convert the Rust arguments of JS functions imported to Rust.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Rust Type conversions » From Rust to JS","id":"297","title":"From Rust to JS"},"298":{"body":"Unfortunately the opposite direction from above, going from JS to Rust, is a bit more complicated. Here we've got three traits: pub trait FromWasmAbi: WasmDescribe { type Abi: WasmAbi; unsafe fn from_abi(js: Self::Abi) -> Self;\n} pub trait RefFromWasmAbi: WasmDescribe { type Abi: WasmAbi; type Anchor: Deref<Target=Self>; unsafe fn ref_from_abi(js: Self::Abi) -> Self::Anchor;\n} pub trait RefMutFromWasmAbi: WasmDescribe { type Abi: WasmAbi; type Anchor: DerefMut<Target=Self>; unsafe fn ref_mut_from_abi(js: Self::Abi) -> Self::Anchor;\n} The FromWasmAbi is relatively straightforward, basically the opposite of IntoWasmAbi. It takes the ABI argument (typically the same as IntoWasmAbi::Abi) to produce an instance of Self. This trait is implemented primarily for types that don't have internal lifetimes or are references. The latter two traits here are mostly the same, and are intended for generating references (both shared and mutable references). They look almost the same as FromWasmAbi except that they return an Anchor type which implements a Deref trait rather than Self. The Ref* traits allow having arguments in functions that are references rather than bare types, for example &str, &JsValue, or &[u8]. The Anchor here is required to ensure that the lifetimes don't persist beyond one function call and remain anonymous. The From* family of traits are used for converting the Rust arguments in Rust exported functions to JS. They are also used for the return value in JS functions imported into Rust.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Rust Type conversions » From JS to Rust","id":"298","title":"From JS to Rust"},"299":{"body":"The last aspect to talk about when converting Rust/JS types amongst one another is how this information is actually communicated. The #[wasm_bindgen] macro is running over the syntactical (unresolved) structure of the Rust code and is then responsible for generating information that wasm-bindgen the CLI tool later reads. To accomplish this a slightly unconventional approach is taken. Static information about the structure of the Rust code is serialized via JSON (currently) to a custom section of the Wasm executable. Other information, like what the types actually are, unfortunately isn't known until later in the compiler due to things like associated type projections and typedefs. It also turns out that we want to convey \"rich\" types like FnMut(String, Foo, &JsValue) to the wasm-bindgen CLI, and handling all this is pretty tricky! To solve this issue the #[wasm_bindgen] macro generates executable functions which \"describe the type signature of an import or export\". These executable functions are what the WasmDescribe trait is all about: pub trait WasmDescribe { fn describe();\n} While deceptively simple this trait is actually quite important. When you write, an export like this: #[wasm_bindgen]\nfn greet(a: &str) { // ...\n} In addition to the shims we talked about above which JS generates the macro also generates something like: #[no_mangle]\npub extern \"C\" fn __wbindgen_describe_greet() { <dyn Fn(&str)>::describe();\n} Or in other words it generates invocations of describe functions. In doing so the __wbindgen_describe_greet shim is a programmatic description of the type layouts of an import/export. These are then executed when wasm-bindgen runs! These executions rely on an import called __wbindgen_describe which passes one u32 to the host, and when called multiple times gives a Vec<u32> effectively. This Vec<u32> can then be reparsed into an enum Descriptor which fully describes a type. All in all this is a bit roundabout but shouldn't have any impact on the generated code or runtime at all. All these descriptor functions are pruned from the emitted Wasm file.","breadcrumbs":"Contributing to wasm-bindgen » Internal Design » Types in wasm-bindgen » Communicating types to wasm-bindgen","id":"299","title":"Communicating types to wasm-bindgen"},"3":{"body":"The Cargo.toml lists the wasm-bindgen crate as a dependency. Also of note is the crate-type = [\"cdylib\"] which is largely used for wasm final artifacts today. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"hello_world\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\nwasm-bindgen = { path = \"../../\" } [lints]\nworkspace = true","breadcrumbs":"Examples » Hello, World! » Cargo.toml","id":"3","title":"Cargo.toml"},"30":{"body":"extern crate chrono;\nextern crate reqwest; use chrono::prelude::DateTime;\nuse chrono::Utc;\nuse std::time::{Duration, UNIX_EPOCH}; use gloo::events::EventListener;\nuse json::JsonValue;\nuse wasm_bindgen::prelude::*;\nuse wasm_bindgen_futures::spawn_local;\nuse web_sys::Document;\nuse web_sys::Element;\nuse web_sys::HtmlInputElement; #[wasm_bindgen(module = \"/util.js\")]\nextern \"C\" { fn initialize(lat: f64, lon: f64);\n} #[wasm_bindgen(start)]\nfn run() -> Result<(), JsValue> { let window = web_sys::window().expect(\"no global `window` exists\"); let document = window.document().expect(\"should have a document on window\"); let body = document.body().expect(\"document should have a body\"); // Manufacture the element we're gonna append let search_div = create_div(&document, \"search\", \"ReportStyles-secondDiv col-md-12\"); let input_box = create_input_box(&document); search_div.append_child(&input_box)?; let submit_box = create_submit_box(&document); let temp_div = create_div( &document, \"tempDetail\", \"ReportStyles-mainContainer col-md-12 maincontainer\", ); let first_div = document.create_element(\"div\")?; let second_div = create_div(&document, \"second_div\", \"col-md-6\"); let third_div = create_div(&document, \"third_div\", \"ReportStyles-innerDiv\"); let fourth_div = create_div(&document, \"cityName\", \"ReportStyles-city\"); let table_div = document.create_element(\"table\")?; table_div.set_class_name(\"ReportStyles-table table-bordered table-striped\"); let tbody_div = document.create_element(\"tbody\")?; let ftr_div = document.create_element(\"tr\")?; let ftd_div = document.create_element(\"td\")?; ftd_div.set_class_name(\" ReportStyles-firstTd\"); let img_div = document.create_element(\"div\")?; img_div.set_id(\"temp\"); let std_div = document.create_element(\"td\")?; std_div.set_class_name(\" ReportStyles-secondTd\"); let weather_div = document.create_element(\"div\")?; weather_div.set_id(\"weather\"); ftr_div.append_child(&ftd_div)?; ftd_div.append_child(&img_div)?; ftr_div.append_child(&std_div)?; std_div.append_child(&weather_div)?; let str_div = document.create_element(\"tr\")?; let ptd_div = document.create_element(\"td\")?; ptd_div.set_class_name(\" ReportStyles-td\"); ptd_div.set_inner_html(\"Pressure\"); let sptd_div = document.create_element(\"td\")?; sptd_div.set_id(\"pressure\"); str_div.append_child(&ptd_div)?; str_div.append_child(&sptd_div)?; let ttr_div = document.create_element(\"tr\")?; let htd_div = document.create_element(\"td\")?; htd_div.set_class_name(\" ReportStyles-td\"); htd_div.set_inner_html(\"Humidity\"); let shtd_div = document.create_element(\"td\")?; shtd_div.set_id(\"humidity\"); ttr_div.append_child(&htd_div)?; ttr_div.append_child(&shtd_div)?; let sunr_tr_div = document.create_element(\"tr\")?; let sunr_td_div = document.create_element(\"td\")?; sunr_td_div.set_class_name(\" ReportStyles-td\"); sunr_td_div.set_inner_html(\"Sunrise[UTC]\"); let sunr_s_td_div = document.create_element(\"td\")?; sunr_s_td_div.set_id(\"sunrise\"); sunr_tr_div.append_child(&sunr_td_div)?; sunr_tr_div.append_child(&sunr_s_td_div)?; let suns_tr_div = document.create_element(\"tr\")?; let suns_td_div = document.create_element(\"td\")?; suns_td_div.set_class_name(\" ReportStyles-td\"); suns_td_div.set_inner_html(\"Sunset[UTC]\"); let suns_s_td_div = document.create_element(\"td\")?; suns_s_td_div.set_id(\"sunset\"); suns_tr_div.append_child(&suns_td_div)?; suns_tr_div.append_child(&suns_s_td_div)?; let geo_tr_div = document.create_element(\"tr\")?; let geo_htd_div = document.create_element(\"td\")?; geo_htd_div.set_class_name(\" ReportStyles-td\"); geo_htd_div.set_inner_html(\"Geo coords\"); let geo_shtd_div = document.create_element(\"td\")?; geo_shtd_div.set_id(\"geocoords\"); geo_tr_div.append_child(&geo_htd_div)?; geo_tr_div.append_child(&geo_shtd_div)?; tbody_div.append_child(&ftr_div)?; tbody_div.append_child(&str_div)?; tbody_div.append_child(&ttr_div)?; tbody_div.append_child(&sunr_tr_div)?; tbody_div.append_child(&suns_tr_div)?; tbody_div.append_child(&geo_tr_div)?; table_div.append_child(&tbody_div)?; third_div.append_child(&fourth_div)?; third_div.append_child(&table_div)?; let map_div = document.create_element(\"div\")?; map_div.set_class_name(\"col-md-6\"); let map_canvas_div = document.create_element(\"div\")?; map_canvas_div.set_class_name(\" ReportStyles-mapCanvas\"); map_canvas_div.set_id(\"map_canvas\"); map_div.append_child(&map_canvas_div)?; second_div.append_child(&third_div)?; first_div.append_child(&second_div)?; first_div.append_child(&map_div)?; temp_div.append_child(&first_div)?; search_div.append_child(&submit_box)?; body.append_child(&search_div)?; body.append_child(&temp_div)?; let on_click = EventListener::new(&submit_box, \"click\", move |_event| { let input_value = document .get_element_by_id(\"name\") .unwrap() .dyn_into::<HtmlInputElement>() .unwrap() .value(); let temp_d = temp_div.clone(); let city = fourth_div.clone(); let image = img_div.clone(); let weather = weather_div.clone(); let pressure = sptd_div.clone(); let humidity = shtd_div.clone(); let sunrise = sunr_s_td_div.clone(); let sunset = suns_s_td_div.clone(); let geo = geo_shtd_div.clone(); let input_value: &'static _ = Box::leak(Box::new(input_value)); let response = get_response(input_value); spawn_local(async move { let parsed = response.await; let lon = parsed[\"coord\"][\"lon\"].to_owned().as_f64().unwrap(); let lat = parsed[\"coord\"][\"lat\"].to_owned().as_f64().unwrap(); initialize(lat, lon); let city_name: &str = &parsed[\"name\"].to_owned().to_string(); let country_name: &str = &parsed[\"sys\"][\"country\"].to_owned().to_string(); let place = [city_name, \",\", country_name].concat(); let icon = &parsed[\"weather\"][0][\"icon\"].to_owned().to_string(); let src = [ \"<img src='http://openweathermap.org/img/w/\", icon, \".png'>\", \" \", ] .concat(); let temp = (parsed[\"main\"][\"temp\"].to_owned().as_f64().unwrap() - 273.15) as i64; let content = [src, temp.to_string()].concat(); let p: &str = &parsed[\"main\"][\"pressure\"].to_owned().to_string(); let h: &str = &parsed[\"main\"][\"humidity\"].to_owned().to_string(); let sun_r = (parsed[\"sys\"][\"sunrise\"].to_owned().as_f64().unwrap()) as u64; let sun_s = (parsed[\"sys\"][\"sunset\"].to_owned().as_f64().unwrap()) as u64; temp_d .set_attribute(\"style\", \"display: block\") .expect(\"failed to set attr style\"); city.set_inner_html(&place); image.set_inner_html(&content); weather.set_inner_html(&parsed[\"weather\"][0][\"main\"].to_owned().to_string()); pressure.set_inner_html(&([p, \" hpa\"].concat())); humidity.set_inner_html(&([h, \"%\"].concat())); sunrise.set_inner_html(&get_time(sun_r)); sunset.set_inner_html(&get_time(sun_s)); geo.set_inner_html(&([\"[\", &lon.to_string(), \",\", &lat.to_string(), \"]\"].concat())); }); }); // When a Closure is dropped it will invalidate the associated JS closure. // Here we want JS callback to be alive for the entire duration of the program. // So we used `forget` leak this instance of Closure. // It should be used sparingly to ensure the memory leak doesn't affect the program too much. on_click.forget(); Ok(())\n} fn create_div(document: &Document, id: &str, class: &str) -> Element { let div = document.create_element(\"div\").unwrap(); div.set_id(id); div.set_class_name(class); div\n} fn create_submit_box(document: &Document) -> Element { let submit_box: Element = document.create_element(\"input\").unwrap(); submit_box .set_attribute(\"type\", \"button\") .expect(\"failed to set attr type to button\"); submit_box .set_attribute(\"value\", \"Search\") .expect(\"failed to set attr value to Search\"); submit_box .set_attribute(\"name\", \"submit\") .expect(\"failed to set attr name to submit\"); submit_box.set_id(\"submit\"); submit_box.set_class_name(\" ReportStyles-bootstrapButton btn btn-info\"); submit_box\n} fn create_input_box(document: &Document) -> Element { let input_box = document.create_element(\"input\").unwrap(); input_box .set_attribute(\"name\", \"name\") .expect(\"failed to set attr name to name\"); input_box.set_attribute(\"value\", \"Delhi\").expect( \" failed to set attr value to Delhi\", ); input_box .set_attribute(\"type\", \"text\") .expect(\"failed to set attr type to text\"); input_box .set_attribute(\"placeholder\", \"Type city name here\") .expect(\"Failed to set attr placeholder to Type city name here\"); input_box.set_id(\"name\"); input_box.set_class_name(\"ReportStyles-search\"); input_box\n} // Get response from weather api\nasync fn get_response(location: &str) -> JsonValue { let url1 = \"http://api.openweathermap.org/data/2.5/weather?q=\"; let url2 = \"&appid=<apiKey>\"; let url = [url1, location, url2].concat(); let resp = reqwest::get(&url).await.unwrap().text().await.unwrap(); json::parse(&resp).unwrap()\n} // Convert millisecond into UTC date\nfn get_time(millis: u64) -> String { let d = UNIX_EPOCH + Duration::from_secs(millis); // Create DateTime from SystemTime let datetime = DateTime::<Utc>::from(d); // Formats the combined date and time with the specified format string. datetime.format(\"%H:%M:%S\").to_string()\n}","breadcrumbs":"Examples » web-sys: Weather report » src/lib.rs","id":"30","title":"src/lib.rs"},"300":{"body":"The js-sys crate provides raw bindings to all the global APIs guaranteed to exist in every JavaScript environment by the ECMAScript standard, and its source lives at wasm-bindgen/crates/js-sys . With the js-sys crate, we can work with Objects, Arrays, Functions, Maps, Sets, etc... without writing the #[wasm_bindgen] imports by hand. Documentation for the published version of this crate is available on docs.rs but you can also check out the master branch documentation for the crate. For example, we can invoke JavaScript Function callbacks and time how long they take to execute with Date.now() , and we don't need to write any JS imports ourselves: use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn timed(callback: &js_sys::Function) -> f64 { let then = js_sys::Date::now(); callback.apply(JsValue::null(), &js_sys::Array::new()).unwrap(); let now = js_sys::Date::now(); now - then\n} The js-sys crate doesn't contain bindings to any Web APIs like document.querySelectorAll . These will be part of the web-sys crate.","breadcrumbs":"Contributing to wasm-bindgen » js-sys » js-sys","id":"300","title":"js-sys"},"301":{"body":"You can test the js-sys crate by running cargo test --target wasm32-unknown-unknown within the crates/js-sys directory in the wasm-bindgen repository: cd wasm-bindgen/crates/js-sys\ncargo test --target wasm32-unknown-unknown These tests are largely executed in Node.js right now via the wasm-bindgen-test framework","breadcrumbs":"Contributing to wasm-bindgen » js-sys » Testing » Testing","id":"301","title":"Testing"},"302":{"body":"As of 2018-09-24 we've added all APIs in the current ECMAScript standard (yay!). To that end you'll hopefully not find a missing API, but if you do please feel free to file an issue! We currently add new APIs added to ECMAScript that are in TC39 stage 4 to this crate. If there's a new API in stage 4, feel free to file an issue as well!","breadcrumbs":"Contributing to wasm-bindgen » js-sys » Adding More APIs » Adding Support for More JavaScript Global APIs","id":"302","title":"Adding Support for More JavaScript Global APIs"},"303":{"body":"Find the wasm-bindgen issue for the API you'd like to add. If this doesn't exist, feel free to open one! Afterwards be sure to comment on the issue to avoid duplication of work. Open the MDN page for the relevant JS API. Open crates/js-sys/src/lib.rs in your editor; this is the file where we are implementing the bindings. Follow the instructions in the top of crates/js-sys/src/lib.rs about how to add new bindings. Add a test for the new binding to crates/js-sys/tests/wasm/MyType.rs Run the JS global API bindings tests Send a pull request!","breadcrumbs":"Contributing to wasm-bindgen » js-sys » Adding More APIs » Instructions for adding an API","id":"303","title":"Instructions for adding an API"},"304":{"body":"The web-sys crate provides raw bindings to all of the Web's APIs, and its source lives at wasm-bindgen/crates/web-sys. The web-sys crate is entirely mechanically generated inside build.rs using wasm-bindgen's WebIDL frontend and the WebIDL interface definitions for Web APIs. This means that web-sys isn't always the most ergonomic crate to use, but it's intended to provide verified and correct bindings to the web platform, and then better interfaces can be iterated on crates.io! Documentation for the published version of this crate is available on docs.rs but you can also check out the master branch documentation for the crate.","breadcrumbs":"Contributing to wasm-bindgen » web-sys » web-sys","id":"304","title":"web-sys"},"305":{"body":"The web-sys crate has this file and directory layout: .\n├── build.rs\n├── Cargo.toml\n├── README.md\n├── src\n│ └── lib.rs\n└── webidls └── enabled └── ...","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Overview » web-sys Overview","id":"305","title":"web-sys Overview"},"306":{"body":"These are the WebIDL interfaces that we will actually generate bindings for (or at least bindings for some of the things defined in these files).","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Overview » webidls/enabled/*.webidl","id":"306","title":"webidls/enabled/*.webidl"},"307":{"body":"The build.rs invokes wasm-bindgen's WebIDL frontend on all the WebIDL files in webidls/enabled. It writes the resulting bindings into the cargo build's out directory.","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Overview » build.rs","id":"307","title":"build.rs"},"308":{"body":"The only thing src/lib.rs does is include the bindings generated at compile time in build.rs. Here is the whole src/lib.rs file: //! Raw API bindings for Web APIs\n//!\n//! This is a procedurally generated crate from browser WebIDL which provides a\n//! binding to all APIs that browsers provide on the web.\n//!\n//! This crate by default contains very little when compiled as almost all of\n//! its exposed APIs are gated by Cargo features. The exhaustive list of\n//! features can be found in `crates/web-sys/Cargo.toml`, but the rule of thumb\n//! for `web-sys` is that each type has its own cargo feature (named after the\n//! type). Using an API requires enabling the features for all types used in the\n//! API, and APIs should mention in the documentation what features they\n//! require. #![doc(html_root_url = \"https://docs.rs/web-sys/0.3\")]\n#![cfg_attr(not(feature = \"std\"), no_std)]\n#![allow(deprecated)] extern crate alloc; mod features;\n#[allow(unused_imports)]\npub use features::*; pub use js_sys;\npub use wasm_bindgen; /// Getter for the `Window` object\n///\n/// [MDN Documentation]\n///\n/// *This API requires the following crate features to be activated: `Window`*\n///\n/// [MDN Documentation]: https://developer.mozilla.org/en-US/docs/Web/API/Window\n#[cfg(feature = \"Window\")]\npub fn window() -> Option<Window> { use wasm_bindgen::JsCast; js_sys::global().dyn_into::<Window>().ok()\n}","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Overview » src/lib.rs","id":"308","title":"src/lib.rs"},"309":{"body":"When compiled the crate is almost empty by default, which probably isn't what you want! Due to the very large number of APIs, this crate uses features to enable portions of its API to reduce compile times. The list of features in Cargo.toml all correspond to types in the generated functions. Enabling a feature enables that type. All methods should indicate what features need to be activated to use the method.","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Overview » Cargo features","id":"309","title":"Cargo features"},"31":{"body":"View full source code or view the compiled example online Drawing a smiley face with the 2D canvas API. This is a port of part of this MDN tutorial to web-sys. A smiley face","breadcrumbs":"Examples » web-sys: canvas hello world » 2D Canvas","id":"31","title":"2D Canvas"},"310":{"body":"You can test the web-sys crate by running cargo test within the crates/web-sys directory in the wasm-bindgen repository: cd wasm-bindgen/crates/web-sys\ncargo test --target wasm32-unknown-unknown --all-features The Wasm tests all run within a headless browser. See the wasm-bindgen-test crate's README.md for details and configuring which headless browser is used.","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Testing » Testing","id":"310","title":"Testing"},"311":{"body":"The wasm_bindgen_webidl crate (used by web-sys's build.rs) uses env_logger for logging, which can be enabled by setting the RUST_LOG=wasm_bindgen_webidl environment variable while building the web-sys crate. Make sure to enable \"very verbose\" output during cargo build to see these logs within web-sys's build script output. cd crates/web-sys\nRUST_LOG=wasm_bindgen_webidl cargo build -vv If wasm_bindgen_webidl encounters WebIDL constructs that it doesn't know how to translate into wasm-bindgen AST items, it will emit warn-level logs. WARN 2018-07-06T18:21:49Z: wasm_bindgen_webidl: Unsupported WebIDL interface: ...","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Logging » Logging","id":"311","title":"Logging"},"312":{"body":"Ensure that the .webidl file describing the interface exists somewhere within the crates/web-sys/webidls/enabled directory. First, check to see whether we have the WebIDL definition file for your API: grep -rn MyWebApi crates/web-sys/webidls If your interface is defined in a .webidl file that is inside the crates/web-sys/webidls/enabled directory, skip to step (3). If your interface isn't defined in any file yet, find the WebIDL definition in the relevant standard and add it as a new .webidl file in crates/web-sys/webidls/enabled. Make sure that it is a standard Web API! We don't want to add non-standard APIs to this crate. If your interface is defined in a .webidl file within any of the crates/web-sys/webidls/unavailable_* directories, you need to move it into crates/web-sys/webidls/enabled, e.g.: cd crates/web-sys\ngit mv webidls/unavailable_enum_ident/MyWebApi.webidl webidls/enabled/MyWebApi.webidl Regenerate the web-sys crate auto-generated bindings, which you can do with the following commands: cd crates/web-sys\ncargo run --release --package wasm-bindgen-webidl -- webidls src/features ./Cargo.toml You can then use git diff to ensure the bindings look correct.","breadcrumbs":"Contributing to wasm-bindgen » web-sys » Supporting More Web APIs » Supporting More Web APIs in web-sys","id":"312","title":"Supporting More Web APIs in web-sys"},"313":{"body":"Compile the publish.rs script: rustc publish.rs Bump every crate's minor version: # Make sure you are in the root of the wasm-bindgen repo!\n./publish bump Update CHANGELOG.md to add the to-be-released version number, compare URL and release date. See this example Send a pull request for the version bump. After the pull request's CI is green and it has been merged, publish to cargo: # Make sure you are in the root of the wasm-bindgen repo!\n./publish publish","breadcrumbs":"Contributing to wasm-bindgen » Publishing » Publishing New wasm-bindgen Releases","id":"313","title":"Publishing New wasm-bindgen Releases"},"314":{"body":"wasm-bindgen follows the rustwasm organization's governance described here : All pull requests (including those made by a team member) must be approved by at least one other team member. Larger, more nuanced decisions about design, architecture, breaking changes, trade offs, etc are made by team consensus.","breadcrumbs":"Contributing to wasm-bindgen » Team » Team","id":"314","title":"Team"},"315":{"body":"| | | | | | |:---:|:---:|:---:|:---:| | alexcrichton | fitzgen | spastorino | ohanar | jonathan-s | | | | | | | | sendilkumarn | belfz | afdw | | |","breadcrumbs":"Contributing to wasm-bindgen » Team » Members","id":"315","title":"Members"},"32":{"body":"The Cargo.toml enables features necessary to query the DOM and work with 2D canvas. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"canvas\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = ['CanvasRenderingContext2d', 'Document', 'Element', 'HtmlCanvasElement', 'Window']\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: canvas hello world » Cargo.toml","id":"32","title":"Cargo.toml"},"33":{"body":"Gets the <canvas> element, creates a 2D rendering context, and draws the smiley face. use std::f64;\nuse wasm_bindgen::prelude::*; #[wasm_bindgen(start)]\nfn start() { let document = web_sys::window().unwrap().document().unwrap(); let canvas = document.get_element_by_id(\"canvas\").unwrap(); let canvas: web_sys::HtmlCanvasElement = canvas .dyn_into::<web_sys::HtmlCanvasElement>() .map_err(|_| ()) .unwrap(); let context = canvas .get_context(\"2d\") .unwrap() .unwrap() .dyn_into::<web_sys::CanvasRenderingContext2d>() .unwrap(); context.begin_path(); // Draw the outer circle. context .arc(75.0, 75.0, 50.0, 0.0, f64::consts::PI * 2.0) .unwrap(); // Draw the mouth. context.move_to(110.0, 75.0); context.arc(75.0, 75.0, 35.0, 0.0, f64::consts::PI).unwrap(); // Draw the left eye. context.move_to(65.0, 65.0); context .arc(60.0, 65.0, 5.0, 0.0, f64::consts::PI * 2.0) .unwrap(); // Draw the right eye. context.move_to(95.0, 65.0); context .arc(90.0, 65.0, 5.0, 0.0, f64::consts::PI * 2.0) .unwrap(); context.stroke();\n}","breadcrumbs":"Examples » web-sys: canvas hello world » src/lib.rs","id":"33","title":"src/lib.rs"},"34":{"body":"View full source code or view the compiled example online While not showing off a lot of web_sys API surface area, this example shows a neat fractal that you can make!","breadcrumbs":"Examples » web-sys: canvas Julia set » Julia Set","id":"34","title":"Julia Set"},"35":{"body":"A small bit of glue is added for this example import('./pkg') .then(wasm => { const canvas = document.getElementById('drawing'); const ctx = canvas.getContext('2d'); const realInput = document.getElementById('real'); const imaginaryInput = document.getElementById('imaginary'); const renderBtn = document.getElementById('render'); renderBtn.addEventListener('click', () => { const real = parseFloat(realInput.value) || 0; const imaginary = parseFloat(imaginaryInput.value) || 0; wasm.draw(ctx, 600, 600, real, imaginary); }); wasm.draw(ctx, 600, 600, -0.15, 0.65); }) .catch(console.error);","breadcrumbs":"Examples » web-sys: canvas Julia set » index.js","id":"35","title":"index.js"},"36":{"body":"The bulk of the logic is in the generation of the fractal use std::ops::Add;\nuse wasm_bindgen::prelude::*;\nuse wasm_bindgen::Clamped;\nuse web_sys::{CanvasRenderingContext2d, ImageData}; #[wasm_bindgen]\npub fn draw( ctx: &CanvasRenderingContext2d, width: u32, height: u32, real: f64, imaginary: f64,\n) -> Result<(), JsValue> { // The real workhorse of this algorithm, generating pixel data let c = Complex { real, imaginary }; let data = get_julia_set(width, height, c); let data = ImageData::new_with_u8_clamped_array_and_sh(Clamped(&data), width, height)?; ctx.put_image_data(&data, 0.0, 0.0)\n} fn get_julia_set(width: u32, height: u32, c: Complex) -> Vec<u8> { let mut data = Vec::new(); let param_i = 1.5; let param_r = 1.5; let scale = 0.005; for x in 0..width { for y in 0..height { let z = Complex { real: y as f64 * scale - param_r, imaginary: x as f64 * scale - param_i, }; let iter_index = get_iter_index(z, c); data.push((iter_index / 4) as u8); data.push((iter_index / 2) as u8); data.push(iter_index as u8); data.push(255); } } data\n} fn get_iter_index(z: Complex, c: Complex) -> u32 { let mut iter_index: u32 = 0; let mut z = z; while iter_index < 900 { if z.norm() > 2.0 { break; } z = z.square() + c; iter_index += 1; } iter_index\n} #[derive(Clone, Copy, Debug)]\nstruct Complex { real: f64, imaginary: f64,\n} impl Complex { fn square(self) -> Complex { let real = (self.real * self.real) - (self.imaginary * self.imaginary); let imaginary = 2.0 * self.real * self.imaginary; Complex { real, imaginary } } fn norm(&self) -> f64 { (self.real * self.real) + (self.imaginary * self.imaginary) }\n} impl Add<Complex> for Complex { type Output = Complex; fn add(self, rhs: Complex) -> Complex { Complex { real: self.real + rhs.real, imaginary: self.imaginary + rhs.imaginary, } }\n}","breadcrumbs":"Examples » web-sys: canvas Julia set » src/lib.rs","id":"36","title":"src/lib.rs"},"37":{"body":"View full source code or view the compiled example online This example creates an FM oscillator using the WebAudio API and web-sys.","breadcrumbs":"Examples » web-sys: WebAudio » WebAudio","id":"37","title":"WebAudio"},"38":{"body":"The Cargo.toml enables the types needed to use the relevant bits of the WebAudio API. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"webaudio\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = [ 'AudioContext', 'AudioDestinationNode', 'AudioNode', 'AudioParam', 'GainNode', 'OscillatorNode', 'OscillatorType',\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: WebAudio » Cargo.toml","id":"38","title":"Cargo.toml"},"39":{"body":"The Rust code implements the FM oscillator. use wasm_bindgen::prelude::*;\nuse web_sys::{AudioContext, OscillatorType}; /// Converts a midi note to frequency\n///\n/// A midi note is an integer, generally in the range of 21 to 108\npub fn midi_to_freq(note: u8) -> f32 { 27.5 * 2f32.powf((note as f32 - 21.0) / 12.0)\n} #[wasm_bindgen]\npub struct FmOsc { ctx: AudioContext, /// The primary oscillator. This will be the fundamental frequency primary: web_sys::OscillatorNode, /// Overall gain (volume) control gain: web_sys::GainNode, /// Amount of frequency modulation fm_gain: web_sys::GainNode, /// The oscillator that will modulate the primary oscillator's frequency fm_osc: web_sys::OscillatorNode, /// The ratio between the primary frequency and the fm_osc frequency. /// /// Generally fractional values like 1/2 or 1/4 sound best fm_freq_ratio: f32, fm_gain_ratio: f32,\n} impl Drop for FmOsc { fn drop(&mut self) { let _ = self.ctx.close(); }\n} #[wasm_bindgen]\nimpl FmOsc { #[wasm_bindgen(constructor)] pub fn new() -> Result<FmOsc, JsValue> { let ctx = web_sys::AudioContext::new()?; // Create our web audio objects. let primary = ctx.create_oscillator()?; let fm_osc = ctx.create_oscillator()?; let gain = ctx.create_gain()?; let fm_gain = ctx.create_gain()?; // Some initial settings: primary.set_type(OscillatorType::Sine); primary.frequency().set_value(440.0); // A4 note gain.gain().set_value(0.0); // starts muted fm_gain.gain().set_value(0.0); // no initial frequency modulation fm_osc.set_type(OscillatorType::Sine); fm_osc.frequency().set_value(0.0); // Connect the nodes up! // The primary oscillator is routed through the gain node, so that // it can control the overall output volume. primary.connect_with_audio_node(&gain)?; // Then connect the gain node to the AudioContext destination (aka // your speakers). gain.connect_with_audio_node(&ctx.destination())?; // The FM oscillator is connected to its own gain node, so it can // control the amount of modulation. fm_osc.connect_with_audio_node(&fm_gain)?; // Connect the FM oscillator to the frequency parameter of the main // oscillator, so that the FM node can modulate its frequency. fm_gain.connect_with_audio_param(&primary.frequency())?; // Start the oscillators! primary.start()?; fm_osc.start()?; Ok(FmOsc { ctx, primary, gain, fm_gain, fm_osc, fm_freq_ratio: 0.0, fm_gain_ratio: 0.0, }) } /// Sets the gain for this oscillator, between 0.0 and 1.0. #[wasm_bindgen] pub fn set_gain(&self, mut gain: f32) { gain = gain.clamp(0.0, 1.0); self.gain.gain().set_value(gain); } #[wasm_bindgen] pub fn set_primary_frequency(&self, freq: f32) { self.primary.frequency().set_value(freq); // The frequency of the FM oscillator depends on the frequency of the // primary oscillator, so we update the frequency of both in this method. self.fm_osc.frequency().set_value(self.fm_freq_ratio * freq); self.fm_gain.gain().set_value(self.fm_gain_ratio * freq); } #[wasm_bindgen] pub fn set_note(&self, note: u8) { let freq = midi_to_freq(note); self.set_primary_frequency(freq); } /// This should be between 0 and 1, though higher values are accepted. #[wasm_bindgen] pub fn set_fm_amount(&mut self, amt: f32) { self.fm_gain_ratio = amt; self.fm_gain .gain() .set_value(self.fm_gain_ratio * self.primary.frequency().value()); } /// This should be between 0 and 1, though higher values are accepted. #[wasm_bindgen] pub fn set_fm_frequency(&mut self, amt: f32) { self.fm_freq_ratio = amt; self.fm_osc .frequency() .set_value(self.fm_freq_ratio * self.primary.frequency().value()); }\n}","breadcrumbs":"Examples » web-sys: WebAudio » src/lib.rs","id":"39","title":"src/lib.rs"},"4":{"body":"Here we define our Rust entry point along with calling the alert function. use wasm_bindgen::prelude::*; #[wasm_bindgen]\nextern \"C\" { fn alert(s: &str);\n} #[wasm_bindgen]\npub fn greet(name: &str) { alert(&format!(\"Hello, {}!\", name));\n}","breadcrumbs":"Examples » Hello, World! » src/lib.rs","id":"4","title":"src/lib.rs"},"40":{"body":"A small bit of JavaScript glues the rust module to input widgets and translates events into calls into Wasm code. import('./pkg') .then(rust_module => { let fm = null; const play_button = document.getElementById(\"play\"); play_button.addEventListener(\"click\", event => { if (fm === null) { fm = new rust_module.FmOsc(); fm.set_note(50); fm.set_fm_frequency(0); fm.set_fm_amount(0); fm.set_gain(0.8); } else { fm.free(); fm = null; } }); const primary_slider = document.getElementById(\"primary_input\"); primary_slider.addEventListener(\"input\", event => { if (fm) { fm.set_note(parseInt(event.target.value)); } }); const fm_freq = document.getElementById(\"fm_freq\"); fm_freq.addEventListener(\"input\", event => { if (fm) { fm.set_fm_frequency(parseFloat(event.target.value)); } }); const fm_amount = document.getElementById(\"fm_amount\"); fm_amount.addEventListener(\"input\", event => { if (fm) { fm.set_fm_amount(parseFloat(event.target.value)); } }); }) .catch(console.error);","breadcrumbs":"Examples » web-sys: WebAudio » index.js","id":"40","title":"index.js"},"41":{"body":"View full source code or view the compiled example online This example draws a triangle to the screen using the WebGL API.","breadcrumbs":"Examples » web-sys: WebGL » WebGL Example","id":"41","title":"WebGL Example"},"42":{"body":"The Cargo.toml enables features necessary to obtain and use a WebGL rendering context. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"webgl\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = [ 'Document', 'Element', 'HtmlCanvasElement', 'WebGlBuffer', 'WebGlVertexArrayObject', 'WebGl2RenderingContext', 'WebGlProgram', 'WebGlShader', 'Window',\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: WebGL » Cargo.toml","id":"42","title":"Cargo.toml"},"43":{"body":"This source file handles all of the necessary logic to obtain a rendering context, compile shaders, fill a buffer with vertex coordinates, and draw a triangle to the screen. use wasm_bindgen::prelude::*;\nuse web_sys::{WebGl2RenderingContext, WebGlProgram, WebGlShader}; #[wasm_bindgen(start)]\nfn start() -> Result<(), JsValue> { let document = web_sys::window().unwrap().document().unwrap(); let canvas = document.get_element_by_id(\"canvas\").unwrap(); let canvas: web_sys::HtmlCanvasElement = canvas.dyn_into::<web_sys::HtmlCanvasElement>()?; let context = canvas .get_context(\"webgl2\")? .unwrap() .dyn_into::<WebGl2RenderingContext>()?; let vert_shader = compile_shader( &context, WebGl2RenderingContext::VERTEX_SHADER, r##\"#version 300 es in vec4 position; void main() { gl_Position = position; } \"##, )?; let frag_shader = compile_shader( &context, WebGl2RenderingContext::FRAGMENT_SHADER, r##\"#version 300 es precision highp float; out vec4 outColor; void main() { outColor = vec4(1, 1, 1, 1); } \"##, )?; let program = link_program(&context, &vert_shader, &frag_shader)?; context.use_program(Some(&program)); let vertices: [f32; 9] = [-0.7, -0.7, 0.0, 0.7, -0.7, 0.0, 0.0, 0.7, 0.0]; let position_attribute_location = context.get_attrib_location(&program, \"position\"); let buffer = context.create_buffer().ok_or(\"Failed to create buffer\")?; context.bind_buffer(WebGl2RenderingContext::ARRAY_BUFFER, Some(&buffer)); // Note that `Float32Array::view` is somewhat dangerous (hence the // `unsafe`!). This is creating a raw view into our module's // `WebAssembly.Memory` buffer, but if we allocate more pages for ourself // (aka do a memory allocation in Rust) it'll cause the buffer to change, // causing the `Float32Array` to be invalid. // // As a result, after `Float32Array::view` we have to be very careful not to // do any memory allocations before it's dropped. unsafe { let positions_array_buf_view = js_sys::Float32Array::view(&vertices); context.buffer_data_with_array_buffer_view( WebGl2RenderingContext::ARRAY_BUFFER, &positions_array_buf_view, WebGl2RenderingContext::STATIC_DRAW, ); } let vao = context .create_vertex_array() .ok_or(\"Could not create vertex array object\")?; context.bind_vertex_array(Some(&vao)); context.vertex_attrib_pointer_with_i32( position_attribute_location as u32, 3, WebGl2RenderingContext::FLOAT, false, 0, 0, ); context.enable_vertex_attrib_array(position_attribute_location as u32); context.bind_vertex_array(Some(&vao)); let vert_count = (vertices.len() / 3) as i32; draw(&context, vert_count); Ok(())\n} fn draw(context: &WebGl2RenderingContext, vert_count: i32) { context.clear_color(0.0, 0.0, 0.0, 1.0); context.clear(WebGl2RenderingContext::COLOR_BUFFER_BIT); context.draw_arrays(WebGl2RenderingContext::TRIANGLES, 0, vert_count);\n} pub fn compile_shader( context: &WebGl2RenderingContext, shader_type: u32, source: &str,\n) -> Result<WebGlShader, String> { let shader = context .create_shader(shader_type) .ok_or_else(|| String::from(\"Unable to create shader object\"))?; context.shader_source(&shader, source); context.compile_shader(&shader); if context .get_shader_parameter(&shader, WebGl2RenderingContext::COMPILE_STATUS) .as_bool() .unwrap_or(false) { Ok(shader) } else { Err(context .get_shader_info_log(&shader) .unwrap_or_else(|| String::from(\"Unknown error creating shader\"))) }\n} pub fn link_program( context: &WebGl2RenderingContext, vert_shader: &WebGlShader, frag_shader: &WebGlShader,\n) -> Result<WebGlProgram, String> { let program = context .create_program() .ok_or_else(|| String::from(\"Unable to create shader object\"))?; context.attach_shader(&program, vert_shader); context.attach_shader(&program, frag_shader); context.link_program(&program); if context .get_program_parameter(&program, WebGl2RenderingContext::LINK_STATUS) .as_bool() .unwrap_or(false) { Ok(program) } else { Err(context .get_program_info_log(&program) .unwrap_or_else(|| String::from(\"Unknown error creating program object\"))) }\n}","breadcrumbs":"Examples » web-sys: WebGL » src/lib.rs","id":"43","title":"src/lib.rs"},"44":{"body":"View full source code or view the compiled example online This example connects to an echo server on wss://echo.websocket.org, sends a ping message, and receives the response.","breadcrumbs":"Examples » web-sys: WebSockets » WebSockets Example","id":"44","title":"WebSockets Example"},"45":{"body":"The Cargo.toml enables features necessary to create a WebSocket object and to access events such as MessageEvent or ErrorEvent. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"websockets\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = [ \"BinaryType\", \"Blob\", \"ErrorEvent\", \"FileReader\", \"MessageEvent\", \"ProgressEvent\", \"WebSocket\",\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: WebSockets » Cargo.toml","id":"45","title":"Cargo.toml"},"46":{"body":"This code shows the basic steps required to work with a WebSocket. At first it opens the connection, then subscribes to events onmessage, onerror, onopen. After the socket is opened it sends a ping message, receives an echoed response and prints it to the browser console. use wasm_bindgen::prelude::*;\nuse web_sys::{ErrorEvent, MessageEvent, WebSocket}; macro_rules! console_log { ($($t:tt)*) => (log(&format_args!($($t)*).to_string()))\n} #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str);\n} #[wasm_bindgen(start)]\nfn start_websocket() -> Result<(), JsValue> { // Connect to an echo server let ws = WebSocket::new(\"wss://echo.websocket.events\")?; // For small binary messages, like CBOR, Arraybuffer is more efficient than Blob handling ws.set_binary_type(web_sys::BinaryType::Arraybuffer); // create callback let cloned_ws = ws.clone(); let onmessage_callback = Closure::<dyn FnMut(_)>::new(move |e: MessageEvent| { // Handle difference Text/Binary,... if let Ok(abuf) = e.data().dyn_into::<js_sys::ArrayBuffer>() { console_log!(\"message event, received arraybuffer: {:?}\", abuf); let array = js_sys::Uint8Array::new(&abuf); let len = array.byte_length() as usize; console_log!(\"Arraybuffer received {}bytes: {:?}\", len, array.to_vec()); // here you can for example use Serde Deserialize decode the message // for demo purposes we switch back to Blob-type and send off another binary message cloned_ws.set_binary_type(web_sys::BinaryType::Blob); match cloned_ws.send_with_u8_array(&[5, 6, 7, 8]) { Ok(_) => console_log!(\"binary message successfully sent\"), Err(err) => console_log!(\"error sending message: {:?}\", err), } } else if let Ok(blob) = e.data().dyn_into::<web_sys::Blob>() { console_log!(\"message event, received blob: {:?}\", blob); // better alternative to juggling with FileReader is to use https://crates.io/crates/gloo-file let fr = web_sys::FileReader::new().unwrap(); let fr_c = fr.clone(); // create onLoadEnd callback let onloadend_cb = Closure::<dyn FnMut(_)>::new(move |_e: web_sys::ProgressEvent| { let array = js_sys::Uint8Array::new(&fr_c.result().unwrap()); let len = array.byte_length() as usize; console_log!(\"Blob received {}bytes: {:?}\", len, array.to_vec()); // here you can for example use the received image/png data }); fr.set_onloadend(Some(onloadend_cb.as_ref().unchecked_ref())); fr.read_as_array_buffer(&blob).expect(\"blob not readable\"); onloadend_cb.forget(); } else if let Ok(txt) = e.data().dyn_into::<js_sys::JsString>() { console_log!(\"message event, received Text: {:?}\", txt); } else { console_log!(\"message event, received Unknown: {:?}\", e.data()); } }); // set message event handler on WebSocket ws.set_onmessage(Some(onmessage_callback.as_ref().unchecked_ref())); // forget the callback to keep it alive onmessage_callback.forget(); let onerror_callback = Closure::<dyn FnMut(_)>::new(move |e: ErrorEvent| { console_log!(\"error event: {:?}\", e); }); ws.set_onerror(Some(onerror_callback.as_ref().unchecked_ref())); onerror_callback.forget(); let cloned_ws = ws.clone(); let onopen_callback = Closure::<dyn FnMut()>::new(move || { console_log!(\"socket opened\"); match cloned_ws.send_with_str(\"ping\") { Ok(_) => console_log!(\"message successfully sent\"), Err(err) => console_log!(\"error sending message: {:?}\", err), } // send off binary message match cloned_ws.send_with_u8_array(&[0, 1, 2, 3]) { Ok(_) => console_log!(\"binary message successfully sent\"), Err(err) => console_log!(\"error sending message: {:?}\", err), } }); ws.set_onopen(Some(onopen_callback.as_ref().unchecked_ref())); onopen_callback.forget(); Ok(())\n}","breadcrumbs":"Examples » web-sys: WebSockets » src/lib.rs","id":"46","title":"src/lib.rs"},"47":{"body":"View full source code or view the compiled example online This example creates 2 peer connections and 2 data channels in single browser tab. Send ping/pong between peer1.dc and peer2.dc.","breadcrumbs":"Examples » web-sys: WebRTC DataChannel » WebRTC DataChannel Example","id":"47","title":"WebRTC DataChannel Example"},"48":{"body":"The Cargo.toml enables features necessary to use WebRTC DataChannel and its negotiation. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"webrtc_datachannel\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" }\nwasm-bindgen-futures = { path = \"../../crates/futures\" } [dependencies.web-sys]\nfeatures = [ \"MessageEvent\", \"RtcPeerConnection\", \"RtcSignalingState\", \"RtcSdpType\", \"RtcSessionDescriptionInit\", \"RtcPeerConnectionIceEvent\", \"RtcIceCandidate\", \"RtcDataChannel\", \"RtcDataChannelEvent\",\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: WebRTC DataChannel » Cargo.toml","id":"48","title":"Cargo.toml"},"49":{"body":"The Rust code connects WebRTC data channel. use js_sys::Reflect;\nuse wasm_bindgen::prelude::*;\nuse wasm_bindgen_futures::JsFuture;\nuse web_sys::{ MessageEvent, RtcDataChannelEvent, RtcPeerConnection, RtcPeerConnectionIceEvent, RtcSdpType, RtcSessionDescriptionInit,\n}; macro_rules! console_log { ($($t:tt)*) => (log(&format_args!($($t)*).to_string()))\n}\nmacro_rules! console_warn { ($($t:tt)*) => (warn(&format_args!($($t)*).to_string()))\n} #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(js_namespace = console)] fn log(s: &str); #[wasm_bindgen(js_namespace = console)] fn warn(s: &str);\n} #[wasm_bindgen(start)]\nasync fn start() -> Result<(), JsValue> { /* * Set up PeerConnections * pc1 <=> pc2 * */ let pc1 = RtcPeerConnection::new()?; console_log!(\"pc1 created: state {:?}\", pc1.signaling_state()); let pc2 = RtcPeerConnection::new()?; console_log!(\"pc2 created: state {:?}\", pc2.signaling_state()); /* * Create DataChannel on pc1 to negotiate * Message will be shown here after connection established * */ let dc1 = pc1.create_data_channel(\"my-data-channel\"); console_log!(\"dc1 created: label {:?}\", dc1.label()); let dc1_clone = dc1.clone(); let onmessage_callback = Closure::<dyn FnMut(_)>::new(move |ev: MessageEvent| { if let Some(message) = ev.data().as_string() { console_warn!(\"{:?}\", message); dc1_clone.send_with_str(\"Pong from pc1.dc!\").unwrap(); } }); dc1.set_onmessage(Some(onmessage_callback.as_ref().unchecked_ref())); onmessage_callback.forget(); /* * If negotiation has done, this closure will be called * */ let ondatachannel_callback = Closure::<dyn FnMut(_)>::new(move |ev: RtcDataChannelEvent| { let dc2 = ev.channel(); console_log!(\"pc2.ondatachannel!: {:?}\", dc2.label()); let onmessage_callback = Closure::<dyn FnMut(_)>::new(move |ev: MessageEvent| { if let Some(message) = ev.data().as_string() { console_warn!(\"{:?}\", message); } }); dc2.set_onmessage(Some(onmessage_callback.as_ref().unchecked_ref())); onmessage_callback.forget(); let dc2_clone = dc2.clone(); let onopen_callback = Closure::<dyn FnMut()>::new(move || { dc2_clone.send_with_str(\"Ping from pc2.dc!\").unwrap(); }); dc2.set_onopen(Some(onopen_callback.as_ref().unchecked_ref())); onopen_callback.forget(); }); pc2.set_ondatachannel(Some(ondatachannel_callback.as_ref().unchecked_ref())); ondatachannel_callback.forget(); /* * Handle ICE candidate each other * */ let pc2_clone = pc2.clone(); let onicecandidate_callback1 = Closure::<dyn FnMut(_)>::new(move |ev: RtcPeerConnectionIceEvent| { if let Some(candidate) = ev.candidate() { console_log!(\"pc1.onicecandidate: {:#?}\", candidate.candidate()); let _ = pc2_clone.add_ice_candidate_with_opt_rtc_ice_candidate(Some(&candidate)); } }); pc1.set_onicecandidate(Some(onicecandidate_callback1.as_ref().unchecked_ref())); onicecandidate_callback1.forget(); let pc1_clone = pc1.clone(); let onicecandidate_callback2 = Closure::<dyn FnMut(_)>::new(move |ev: RtcPeerConnectionIceEvent| { if let Some(candidate) = ev.candidate() { console_log!(\"pc2.onicecandidate: {:#?}\", candidate.candidate()); let _ = pc1_clone.add_ice_candidate_with_opt_rtc_ice_candidate(Some(&candidate)); } }); pc2.set_onicecandidate(Some(onicecandidate_callback2.as_ref().unchecked_ref())); onicecandidate_callback2.forget(); /* * Send OFFER from pc1 to pc2 * */ let offer = JsFuture::from(pc1.create_offer()).await?; let offer_sdp = Reflect::get(&offer, &JsValue::from_str(\"sdp\"))? .as_string() .unwrap(); console_log!(\"pc1: offer {:?}\", offer_sdp); let offer_obj = RtcSessionDescriptionInit::new(RtcSdpType::Offer); offer_obj.set_sdp(&offer_sdp); let sld_promise = pc1.set_local_description(&offer_obj); JsFuture::from(sld_promise).await?; console_log!(\"pc1: state {:?}\", pc1.signaling_state()); /* * Receive OFFER from pc1 * Create and send ANSWER from pc2 to pc1 * */ let offer_obj = RtcSessionDescriptionInit::new(RtcSdpType::Offer); offer_obj.set_sdp(&offer_sdp); let srd_promise = pc2.set_remote_description(&offer_obj); JsFuture::from(srd_promise).await?; console_log!(\"pc2: state {:?}\", pc2.signaling_state()); let answer = JsFuture::from(pc2.create_answer()).await?; let answer_sdp = Reflect::get(&answer, &JsValue::from_str(\"sdp\"))? .as_string() .unwrap(); console_log!(\"pc2: answer {:?}\", answer_sdp); let answer_obj = RtcSessionDescriptionInit::new(RtcSdpType::Answer); answer_obj.set_sdp(&answer_sdp); let sld_promise = pc2.set_local_description(&answer_obj); JsFuture::from(sld_promise).await?; console_log!(\"pc2: state {:?}\", pc2.signaling_state()); /* * Receive ANSWER from pc2 * */ let answer_obj = RtcSessionDescriptionInit::new(RtcSdpType::Answer); answer_obj.set_sdp(&answer_sdp); let srd_promise = pc1.set_remote_description(&answer_obj); JsFuture::from(srd_promise).await?; console_log!(\"pc1: state {:?}\", pc1.signaling_state()); Ok(())\n}","breadcrumbs":"Examples » web-sys: WebRTC DataChannel » src/lib.rs","id":"49","title":"src/lib.rs"},"5":{"body":"Our JS entry point is quite small! import { greet } from './pkg'; greet('World');","breadcrumbs":"Examples » Hello, World! » index.js","id":"5","title":"index.js"},"50":{"body":"View full source code or view the compiled example online This is an example of a requestAnimationFrame loop using the web-sys crate! It renders a count of how many times a requestAnimationFrame callback has been invoked and then it breaks out of the requestAnimationFrame loop after 300 iterations.","breadcrumbs":"Examples » web-sys: requestAnimationFrame » web-sys: A requestAnimationFrame Loop","id":"50","title":"web-sys: A requestAnimationFrame Loop"},"51":{"body":"You can see here how we depend on web-sys and activate associated features to enable all the various APIs: [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"request-animation-frame\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = ['Document', 'Element', 'HtmlElement', 'Node', 'Window']\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: requestAnimationFrame » Cargo.toml","id":"51","title":"Cargo.toml"},"52":{"body":"use std::cell::RefCell;\nuse std::rc::Rc;\nuse wasm_bindgen::prelude::*; fn window() -> web_sys::Window { web_sys::window().expect(\"no global `window` exists\")\n} fn request_animation_frame(f: &Closure<dyn FnMut()>) { window() .request_animation_frame(f.as_ref().unchecked_ref()) .expect(\"should register `requestAnimationFrame` OK\");\n} fn document() -> web_sys::Document { window() .document() .expect(\"should have a document on window\")\n} fn body() -> web_sys::HtmlElement { document().body().expect(\"document should have a body\")\n} // This function is automatically invoked after the Wasm module is instantiated.\n#[wasm_bindgen(start)]\nfn run() -> Result<(), JsValue> { // Here we want to call `requestAnimationFrame` in a loop, but only a fixed // number of times. After it's done we want all our resources cleaned up. To // achieve this we're using an `Rc`. The `Rc` will eventually store the // closure we want to execute on each frame, but to start out it contains // `None`. // // After the `Rc` is made we'll actually create the closure, and the closure // will reference one of the `Rc` instances. The other `Rc` reference is // used to store the closure, request the first frame, and then is dropped // by this function. // // Inside the closure we've got a persistent `Rc` reference, which we use // for all future iterations of the loop let f = Rc::new(RefCell::new(None)); let g = f.clone(); let mut i = 0; *g.borrow_mut() = Some(Closure::new(move || { if i > 300 { body().set_text_content(Some(\"All done!\")); // Drop our handle to this closure so that it will get cleaned // up once we return. let _ = f.borrow_mut().take(); return; } // Set the body's text content to how many times this // requestAnimationFrame callback has fired. i += 1; let text = format!(\"requestAnimationFrame has been called {} times.\", i); body().set_text_content(Some(&text)); // Schedule ourself for another requestAnimationFrame callback. request_animation_frame(f.borrow().as_ref().unwrap()); })); request_animation_frame(g.borrow().as_ref().unwrap()); Ok(())\n}","breadcrumbs":"Examples » web-sys: requestAnimationFrame » src/lib.rs","id":"52","title":"src/lib.rs"},"53":{"body":"View full source code or view the compiled example online A simple painting program.","breadcrumbs":"Examples » web-sys: A Simple Paint Program » Paint Example","id":"53","title":"Paint Example"},"54":{"body":"The Cargo.toml enables features necessary to work with the DOM, events and 2D canvas. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"wasm-bindgen-paint\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\njs-sys = { path = \"../../crates/js-sys\" }\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = [ 'CanvasRenderingContext2d', 'CssStyleDeclaration', 'Document', 'Element', 'EventTarget', 'HtmlCanvasElement', 'HtmlElement', 'MouseEvent', 'Node', 'Window',\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: A Simple Paint Program » Cargo.toml","id":"54","title":"Cargo.toml"},"55":{"body":"Creates the <canvas> element, applies a CSS style to it, adds it to the document, get a 2D rendering context and adds listeners for mouse events. use std::cell::Cell;\nuse std::rc::Rc;\nuse wasm_bindgen::prelude::*; #[wasm_bindgen(start)]\nfn start() -> Result<(), JsValue> { let document = web_sys::window().unwrap().document().unwrap(); let canvas = document .create_element(\"canvas\")? .dyn_into::<web_sys::HtmlCanvasElement>()?; document.body().unwrap().append_child(&canvas)?; canvas.set_width(640); canvas.set_height(480); canvas.style().set_property(\"border\", \"solid\")?; let context = canvas .get_context(\"2d\")? .unwrap() .dyn_into::<web_sys::CanvasRenderingContext2d>()?; let context = Rc::new(context); let pressed = Rc::new(Cell::new(false)); { let context = context.clone(); let pressed = pressed.clone(); let closure = Closure::<dyn FnMut(_)>::new(move |event: web_sys::MouseEvent| { context.begin_path(); context.move_to(event.offset_x() as f64, event.offset_y() as f64); pressed.set(true); }); canvas.add_event_listener_with_callback(\"mousedown\", closure.as_ref().unchecked_ref())?; closure.forget(); } { let context = context.clone(); let pressed = pressed.clone(); let closure = Closure::<dyn FnMut(_)>::new(move |event: web_sys::MouseEvent| { if pressed.get() { context.line_to(event.offset_x() as f64, event.offset_y() as f64); context.stroke(); context.begin_path(); context.move_to(event.offset_x() as f64, event.offset_y() as f64); } }); canvas.add_event_listener_with_callback(\"mousemove\", closure.as_ref().unchecked_ref())?; closure.forget(); } { let closure = Closure::<dyn FnMut(_)>::new(move |event: web_sys::MouseEvent| { pressed.set(false); context.line_to(event.offset_x() as f64, event.offset_y() as f64); context.stroke(); }); canvas.add_event_listener_with_callback(\"mouseup\", closure.as_ref().unchecked_ref())?; closure.forget(); } Ok(())\n}","breadcrumbs":"Examples » web-sys: A Simple Paint Program » src/lib.rs","id":"55","title":"src/lib.rs"},"56":{"body":"View full source code A simple example of parallel execution by spawning a web worker with web_sys, loading Wasm code in the web worker and interacting between the main thread and the worker.","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » Wasm in Web Worker","id":"56","title":"Wasm in Web Worker"},"57":{"body":"At the time of this writing, only Chrome supports modules in web workers, e.g. Firefox does not. To have compatibility across browsers, the whole example is set up without relying on ES modules as target. Therefore we have to build with --target no-modules. The full command can be found in build.sh.","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » Building & compatibility","id":"57","title":"Building & compatibility"},"58":{"body":"The Cargo.toml enables features necessary to work with the DOM, log output to the JS console, creating a worker and reacting to message events. [package]\nauthors = [\"The wasm-bindgen Developers\"]\nedition = \"2021\"\nname = \"wasm-in-web-worker\"\npublish = false\nversion = \"0.0.0\" [lib]\ncrate-type = [\"cdylib\"] [dependencies]\nconsole_error_panic_hook = { version = \"0.1.6\", optional = true }\nwasm-bindgen = { path = \"../../\" } [dependencies.web-sys]\nfeatures = [ 'console', 'Document', 'HtmlElement', 'HtmlInputElement', 'MessageEvent', 'Window', 'Worker',\n]\npath = \"../../crates/web-sys\" [lints]\nworkspace = true","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » Cargo.toml","id":"58","title":"Cargo.toml"},"59":{"body":"Creates a struct NumberEval with methods to act as stateful object in the worker and function startup to be launched in the main thread. Also includes internal helper functions setup_input_oninput_callback to attach a wasm_bindgen::Closure as callback to the oninput event of the input field and get_on_msg_callback to create a wasm_bindgen::Closure which is triggered when the worker returns a message. use std::cell::RefCell;\nuse std::rc::Rc;\nuse wasm_bindgen::prelude::*;\nuse web_sys::{console, HtmlElement, HtmlInputElement, MessageEvent, Worker}; /// A number evaluation struct\n///\n/// This struct will be the main object which responds to messages passed to the\n/// worker. It stores the last number which it was passed to have a state. The\n/// statefulness is not required in this example but should show how\n/// larger, more complex scenarios with statefulness can be set up.\n#[wasm_bindgen]\npub struct NumberEval { number: i32,\n} #[wasm_bindgen]\nimpl NumberEval { /// Create new instance. pub fn new() -> NumberEval { NumberEval { number: 0 } } /// Check if a number is even and store it as last processed number. /// /// # Arguments /// /// * `number` - The number to be checked for being even/odd. pub fn is_even(&mut self, number: i32) -> bool { self.number = number; self.number % 2 == 0 } /// Get last number that was checked - this method is added to work with /// statefulness. pub fn get_last_number(&self) -> i32 { self.number }\n} /// Run entry point for the main thread.\n#[wasm_bindgen]\npub fn startup() { // Here, we create our worker. In a larger app, multiple callbacks should be // able to interact with the code in the worker. Therefore, we wrap it in // `Rc<RefCell>` following the interior mutability pattern. Here, it would // not be needed but we include the wrapping anyway as example. let worker_handle = Rc::new(RefCell::new(Worker::new(\"./worker.js\").unwrap())); console::log_1(&\"Created a new worker from within Wasm\".into()); // Pass the worker to the function which sets up the `oninput` callback. setup_input_oninput_callback(worker_handle);\n} fn setup_input_oninput_callback(worker: Rc<RefCell<web_sys::Worker>>) { let document = web_sys::window().unwrap().document().unwrap(); // If our `onmessage` callback should stay valid after exiting from the // `oninput` closure scope, we need to either forget it (so it is not // destroyed) or store it somewhere. To avoid leaking memory every time we // want to receive a response from the worker, we move a handle into the // `oninput` closure to which we will always attach the last `onmessage` // callback. The initial value will not be used and we silence the warning. #[allow(unused_assignments)] let mut persistent_callback_handle = get_on_msg_callback(); let callback = Closure::new(move || { console::log_1(&\"oninput callback triggered\".into()); let document = web_sys::window().unwrap().document().unwrap(); let input_field = document .get_element_by_id(\"inputNumber\") .expect(\"#inputNumber should exist\"); let input_field = input_field .dyn_ref::<HtmlInputElement>() .expect(\"#inputNumber should be a HtmlInputElement\"); // If the value in the field can be parsed to a `i32`, send it to the // worker. Otherwise clear the result field. match input_field.value().parse::<i32>() { Ok(number) => { // Access worker behind shared handle, following the interior // mutability pattern. let worker_handle = &*worker.borrow(); let _ = worker_handle.post_message(&number.into()); persistent_callback_handle = get_on_msg_callback(); // Since the worker returns the message asynchronously, we // attach a callback to be triggered when the worker returns. worker_handle .set_onmessage(Some(persistent_callback_handle.as_ref().unchecked_ref())); } Err(_) => { document .get_element_by_id(\"resultField\") .expect(\"#resultField should exist\") .dyn_ref::<HtmlElement>() .expect(\"#resultField should be a HtmlInputElement\") .set_inner_text(\"\"); } } }); // Attach the closure as `oninput` callback to the input field. document .get_element_by_id(\"inputNumber\") .expect(\"#inputNumber should exist\") .dyn_ref::<HtmlInputElement>() .expect(\"#inputNumber should be a HtmlInputElement\") .set_oninput(Some(callback.as_ref().unchecked_ref())); // Leaks memory. callback.forget();\n} /// Create a closure to act on the message returned by the worker\nfn get_on_msg_callback() -> Closure<dyn FnMut(MessageEvent)> { Closure::new(move |event: MessageEvent| { console::log_2(&\"Received response: \".into(), &event.data()); let result = match event.data().as_bool().unwrap() { true => \"even\", false => \"odd\", }; let document = web_sys::window().unwrap().document().unwrap(); document .get_element_by_id(\"resultField\") .expect(\"#resultField should exist\") .dyn_ref::<HtmlElement>() .expect(\"#resultField should be a HtmlInputElement\") .set_inner_text(result); })\n}","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » src/lib.rs","id":"59","title":"src/lib.rs"},"6":{"body":"Note : Webpack is required for this example, and if you're interested in options that don't use a JS bundler see other examples . And finally here's the Webpack configuration and package.json for this project: webpack.config.js const path = require('path');\nconst HtmlWebpackPlugin = require('html-webpack-plugin');\nconst webpack = require('webpack');\nconst WasmPackPlugin = require(\"@wasm-tool/wasm-pack-plugin\"); module.exports = { entry: './index.js', output: { path: path.resolve(__dirname, 'dist'), filename: 'index.js', }, plugins: [ new HtmlWebpackPlugin(), new WasmPackPlugin({ crateDirectory: path.resolve(__dirname, \".\") }), ], mode: 'development', experiments: { asyncWebAssembly: true }\n}; package.json { \"scripts\": { \"build\": \"webpack\", \"serve\": \"webpack serve\" }, \"devDependencies\": { \"@wasm-tool/wasm-pack-plugin\": \"1.5.0\", \"html-webpack-plugin\": \"^5.6.0\", \"webpack\": \"github:daxpedda/webpack#externref\", \"webpack-cli\": \"^5.1.4\", \"webpack-dev-server\": \"^5.0.4\" }\n}","breadcrumbs":"Examples » Hello, World! » Webpack-specific files","id":"6","title":"Webpack-specific files"},"60":{"body":"Includes the input element #inputNumber to type a number into and a HTML element #resultField were the result of the evaluation even/odd is written to. Since we require to build with --target no-modules to be able to load Wasm code in the worker across browsers, the index.html also includes loading both wasm_in_web_worker.js and index.js. <html> <head> <meta content=\"text/html;charset=utf-8\" http-equiv=\"Content-Type\" /> <link rel=\"stylesheet\" href=\"style.css\">\n</head> <body> <div id=\"wrapper\"> <h1>Main Thread/Wasm Web Worker Interaction</h1> <input type=\"text\" id=\"inputNumber\"> <div id=\"resultField\"></div> </div> <!-- Make `wasm_bindgen` available for `index.js` --> <script src='./pkg/wasm_in_web_worker.js'></script> <!-- Note that there is no `type=\"module\"` in the script tag --> <script src=\"./index.js\"></script> </body> </html>","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » index.html","id":"60","title":"index.html"},"61":{"body":"Loads our Wasm file asynchronously and calls the entry point startup of the main thread which will create a worker. // We only need `startup` here which is the main entry point\n// In theory, we could also use all other functions/struct types from Rust which we have bound with\n// `#[wasm_bindgen]`\nconst {startup} = wasm_bindgen; async function run_wasm() { // Load the Wasm file by awaiting the Promise returned by `wasm_bindgen` // `wasm_bindgen` was imported in `index.html` await wasm_bindgen(); console.log('index.js loaded'); // Run main Wasm entry point // This will create a worker from within our Rust code compiled to Wasm startup();\n} run_wasm();","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » index.js","id":"61","title":"index.js"},"62":{"body":"Loads our Wasm file by first importing wasm_bindgen via importScripts('./pkg/wasm_in_web_worker.js') and then awaiting the Promise returned by wasm_bindgen(...). Creates a new object to do the background calculation and bind a method of the object to the onmessage callback of the worker. // The worker has its own scope and no direct access to functions/objects of the\n// global scope. We import the generated JS file to make `wasm_bindgen`\n// available which we need to initialize our Wasm code.\nimportScripts('./pkg/wasm_in_web_worker.js'); console.log('Initializing worker') // In the worker, we have a different struct that we want to use as in\n// `index.js`.\nconst {NumberEval} = wasm_bindgen; async function init_wasm_in_worker() { // Load the Wasm file by awaiting the Promise returned by `wasm_bindgen`. await wasm_bindgen('./pkg/wasm_in_web_worker_bg.wasm'); // Create a new object of the `NumberEval` struct. var num_eval = NumberEval.new(); // Set callback to handle messages passed to the worker. self.onmessage = async event => { // By using methods of a struct as reaction to messages passed to the // worker, we can preserve our state between messages. var worker_result = num_eval.is_even(event.data); // Send response back to be handled by callback in main thread. self.postMessage(worker_result); };\n}; init_wasm_in_worker();","breadcrumbs":"Examples » web-sys: Wasm in Web Worker » worker.js","id":"62","title":"worker.js"},"63":{"body":"View full source code or view the compiled example online This is an example of using threads with WebAssembly, Rust, and wasm-bindgen, culminating in a parallel raytracer demo. There's a number of moving pieces to this demo and it's unfortunately not the easiest thing to wrangle, but it's hoped that this'll give you a bit of a taste of what it's like to use threads and Wasm with Rust on the web.","breadcrumbs":"Examples » Parallel Raytracing » Parallel Raytracing","id":"63","title":"Parallel Raytracing"},"64":{"body":"One of the major gotchas with threaded WebAssembly is that Rust does not ship a precompiled target (e.g. standard library) which has threading support enabled. This means that you'll need to recompile the standard library with the appropriate rustc flags, namely -C target-feature=+atomics,+bulk-memory,+mutable-globals. Note that this requires a nightly Rust toolchain. To do this you can use the RUSTFLAGS environment variable that Cargo reads: export RUSTFLAGS='-C target-feature=+atomics,+bulk-memory,+mutable-globals' To recompile the standard library it's recommended to use Cargo's -Zbuild-std feature: cargo build --target wasm32-unknown-unknown -Z build-std=panic_abort,std Note that you can also configure this via .cargo/config.toml: [unstable]\nbuild-std = ['std', 'panic_abort'] [build]\ntarget = \"wasm32-unknown-unknown\"\nrustflags = '-Ctarget-feature=+atomics,+bulk-memory,+mutable-globals' After this cargo build should produce a WebAssembly file with threading enabled, and the standard library will be appropriately compiled as well. The final step in this is to run wasm-bindgen as usual, and wasm-bindgen needs no extra configuration to work with threads. You can continue to run it through wasm-pack, for example.","breadcrumbs":"Examples » Parallel Raytracing » Building the demo","id":"64","title":"Building the demo"},"65":{"body":"Currently it's required to use the --target no-modules or --target web flag with wasm-bindgen to run threaded code. This is because the WebAssembly file imports memory instead of exporting it, so we need to hook initialization of the wasm module at this time to provide the appropriate memory object. This demo uses --target no-modules, because Firefox does not support modules in workers. With --target no-modules you'll be able to use importScripts inside of each web worker to import the shim JS generated by wasm-bindgen as well as calling the wasm_bindgen initialization function with the shared memory instance from the main thread. The expected usage is that WebAssembly on the main thread will post its memory object to all other threads to get instantiated with.","breadcrumbs":"Examples » Parallel Raytracing » Running the demo","id":"65","title":"Running the demo"},"66":{"body":"Unfortunately at this time running Wasm on the web with threads has a number of caveats, although some are specific to just wasm-bindgen. These are some pieces to consider and watch out for, although we're always looking for improvements to be made so if you have an idea please file an issue! The main thread in a browser cannot block. This means that if you run WebAssembly code on the main thread you can never block, meaning you can't do so much as acquire a mutex. This is an extremely difficult limitation to work with on the web, although one workaround is to run Wasm exclusively in web workers and run JS on the main thread. It is possible to run the same wasm across all threads, but you need to be extremely vigilant about synchronization with the main thread. Setting up a threaded environment is a bit wonky and doesn't feel smooth today. For example --target bundler is unsupported and very specific shims are required on both the main thread and worker threads. These are possible to work with but are somewhat brittle since there's no standard way to spin up web workers as Wasm threads. There is no standard notion of a \"thread\". For example the standard library has no viable route to implement the std::thread module. As a consequence there is no concept of thread exit and TLS destructors will never run. We do expose a helper, __wbindgen_thread_destroy, that deallocates the thread stack and TLS. If you invoke it, it must be the last function you invoke from the Wasm module for a given thread. Any thread launched after the first one might attempt to block implicitly in its initialization routine. This is a constraint introduced by the way we set up the space for thread stacks and TLS. This means that if you attempt to run a Wasm module in the main thread after you are already running it in a worker, it might fail. Web Workers executing WebAssembly code cannot receive events from JS. A Web Worker has to fully return back to the browser (and ideally should do so occasionally) to receive JS messages and such. This means that common paradigms like a rayon thread pool do not apply straightforward-ly to the web. The intention of the web is that all long-term blocking happens in the browser itself, not in each thread, but many crates in the ecosystem leveraging threading are not necessarily engineered this way. These caveats are all largely inherited from the web platform itself, and they're important to consider when designing an application for threading. It's highly unlikely that you can pull a crate off the shelf and \"just use it\" due to these limitations. You'll need to be sure to carefully plan ahead and ensure that gotchas such as these don't cause issues in the future. As mentioned before though we're always trying to actively develop this support so if folks have ideas about how to improve, or if web standards change, we'll try to update this documentation!","breadcrumbs":"Examples » Parallel Raytracing » Caveats","id":"66","title":"Caveats"},"67":{"body":"This demo should work in the latest Firefox and Chrome versions at this time, and other browsers are likely to follow suit. Note that threads and SharedArrayBuffer require HTTP headers to be set to work correctly. For more information see the documentation on MDN under \"Security requirements\" as well as Firefox's rollout blog post . This means that during local development you'll need to configure your web server appropriately or enable a workaround in your browser.","breadcrumbs":"Examples » Parallel Raytracing » Browser Requirements","id":"67","title":"Browser Requirements"},"68":{"body":"View full source code or view the compiled example online This is an example of using threads inside specific worklets with WebAssembly, Rust, and wasm-bindgen, culminating in an oscillator demo. This demo should complement the parallel-raytrace example by demonstrating an alternative approach using ES modules with on-the-fly module creation.","breadcrumbs":"Examples » Wasm Audio Worklet » Wasm audio worklet","id":"68","title":"Wasm audio worklet"},"69":{"body":"One of the major gotchas with threaded WebAssembly is that Rust does not ship a precompiled target (e.g. standard library) which has threading support enabled. This means that you'll need to recompile the standard library with the appropriate rustc flags, namely -C target-feature=+atomics,+bulk-memory,+mutable-globals. Note that this requires a nightly Rust toolchain. See the more detailed instructions of the parallel-raytrace example.","breadcrumbs":"Examples » Wasm Audio Worklet » Building the demo","id":"69","title":"Building the demo"},"7":{"body":"View full source code or view the compiled example online This example shows off how to use console.log in a variety of ways, all the way from bare-bones usage to a println!-like macro with web_sys.","breadcrumbs":"Examples » Using console.log » console.log","id":"7","title":"console.log"},"70":{"body":"This example shares most of its caveats with the parallel-raytrace example. However, it tries to encapsulate worklet creation in a Rust module, so the application developer does not need to maintain custom JS code.","breadcrumbs":"Examples » Wasm Audio Worklet » Caveats","id":"70","title":"Caveats"},"71":{"body":"This demo should work in the latest Chrome, Firefox and Safari versions at this time. Note that this example requires HTTP headers to be set like in parallel-raytrace .","breadcrumbs":"Examples » Wasm Audio Worklet » Browser Requirements","id":"71","title":"Browser Requirements"},"72":{"body":"View full source code or view the compiled example online wasm-bindgen and web-sys coded TODO MVC The code was rewritten from the ES6 version . The core differences are: Having an Element wrapper that takes care of dyn and into refs in web-sys, A Scheduler that allows Controller and View to communicate to each other by emulating something similar to the JS event loop.","breadcrumbs":"Examples » web-sys: A TODO MVC App » TODO MVC using wasm-bingen and web-sys","id":"72","title":"TODO MVC using wasm-bingen and web-sys"},"73":{"body":"The size of the project hasn't undergone much work to make it optimised yet. ~96kb release build ~76kb optimised with binaryen ~28kb brotli compressed","breadcrumbs":"Examples » web-sys: A TODO MVC App » Size","id":"73","title":"Size"},"74":{"body":"This section contains reference material for using wasm-bindgen. It is not intended to be read start to finish. Instead, it aims to quickly answer questions like: Is type X supported as a parameter in a Rust function exported to JavaScript? What was that CLI flag to disable ECMAScript modules output, and instead attach the JavaScript bindings directly to window?","breadcrumbs":"Reference » Reference","id":"74","title":"Reference"},"75":{"body":"At this point in time deploying Rust and WebAssembly to the web or other locations unfortunately isn't a trivial task to do. This page hopes to serve as documentation for the various known options, and as always PRs are welcome to update this if it's out of date! The methods of deployment and integration here are primarily tied to the --target flag. Value Summary bundler Suitable for loading in bundlers like Webpack web Directly loadable in a web browser nodejs Loadable via require as a Node.js CommonJS module deno Loadable using imports from Deno modules no-modules Like web, but older and doesn't use ES modules experimental-nodejs-module Loadable via import as a Node.js ESM module.","breadcrumbs":"Reference » Deployment » Deploying Rust and WebAssembly","id":"75","title":"Deploying Rust and WebAssembly"},"76":{"body":"--target bundler The default output of wasm-bindgen, or the bundler target, assumes a model where the Wasm module itself is natively an ES module. This model, however, is not natively implemented in any JS implementation at this time. As a result, to consume the default output of wasm-bindgen you will need a bundler of some form. Note : the choice of this default output was done to reflect the trends of the JS ecosystem. While tools other than bundlers don't support Wasm files as native ES modules today they're all very much likely to in the future! Currently the only known bundler known to be fully compatible with wasm-bindgen is webpack . Most examples use webpack, and you can check out the hello world example online to see the details of webpack configuration necessary.","breadcrumbs":"Reference » Deployment » Bundlers","id":"76","title":"Bundlers"},"77":{"body":"--target web or --target no-modules If you're not using a bundler but you're still running code in a web browser, wasm-bindgen still supports this! For this use case you'll want to use the --target web flag. You can check out a full example in the documentation, but the highlights of this output are: When compiling you'll pass --target web to wasm-bindgen The output can natively be included on a web page, and doesn't require any further postprocessing. The output is included as an ES module. The --target web mode is not able to use NPM dependencies. You'll want to review the browser requirements for wasm-bindgen because no polyfills will be available. The CLI also supports an output mode called --target no-modules which is similar to the web target in that it requires manual initialization of the wasm and is intended to be included in web pages without any further postprocessing. See the without a bundler example for some more information about --target no-modules.","breadcrumbs":"Reference » Deployment » Without a Bundler","id":"77","title":"Without a Bundler"},"78":{"body":"--target nodejs If you're deploying WebAssembly into Node.js (perhaps as an alternative to a native module), then you'll want to pass the --target nodejs flag to wasm-bindgen. Like the \"without a bundler\" strategy, this method of deployment does not require any further postprocessing. The generated JS shims can be require'd just like any other Node module (even the *_bg Wasm file can be require'd as it has a JS shim generated as well). Note that this method requires a version of Node.js with WebAssembly support, which is currently Node 8 and above.","breadcrumbs":"Reference » Deployment » Node.js","id":"78","title":"Node.js"},"79":{"body":"--target experemintal-nodejs-module If you're deploying WebAssembly into Node.js as a JavaScript module, then you'll want to pass the --target experimental-nodejs-module flag to wasm-bindgen. Like the \"node\" strategy, this method of deployment does not require any further postprocessing. The generated JS shims can be imported just like any other Node module. Note that this method requires a version of Node.js with WebAssembly and module support, which is currently Node 12 and above. Currently experimental. Target is expected to be changed before stabilization.","breadcrumbs":"Reference » Deployment » Node.js Module","id":"79","title":"Node.js Module"},"8":{"body":"use wasm_bindgen::prelude::*; #[wasm_bindgen(start)]\nfn run() { bare_bones(); using_a_macro(); using_web_sys();\n} // First up let's take a look of binding `console.log` manually, without the\n// help of `web_sys`. Here we're writing the `#[wasm_bindgen]` annotations\n// manually ourselves, and the correctness of our program relies on the\n// correctness of these annotations! #[wasm_bindgen]\nextern \"C\" { // Use `js_namespace` here to bind `console.log(..)` instead of just // `log(..)` #[wasm_bindgen(js_namespace = console)] fn log(s: &str); // The `console.log` is quite polymorphic, so we can bind it with multiple // signatures. Note that we need to use `js_name` to ensure we always call // `log` in JS. #[wasm_bindgen(js_namespace = console, js_name = log)] fn log_u32(a: u32); // Multiple arguments too! #[wasm_bindgen(js_namespace = console, js_name = log)] fn log_many(a: &str, b: &str);\n} fn bare_bones() { log(\"Hello from Rust!\"); log_u32(42); log_many(\"Logging\", \"many values!\");\n} // Next let's define a macro that's like `println!`, only it works for\n// `console.log`. Note that `println!` doesn't actually work on the Wasm target\n// because the standard library currently just eats all output. To get\n// `println!`-like behavior in your app you'll likely want a macro like this. macro_rules! console_log { // Note that this is using the `log` function imported above during // `bare_bones` ($($t:tt)*) => (log(&format_args!($($t)*).to_string()))\n} fn using_a_macro() { console_log!(\"Hello {}!\", \"world\"); console_log!(\"Let's print some numbers...\"); console_log!(\"1 + 3 = {}\", 1 + 3);\n} // And finally, we don't even have to define the `log` function ourselves! The\n// `web_sys` crate already has it defined for us. fn using_web_sys() { use web_sys::console; console::log_1(&\"Hello using web-sys\".into()); let js: JsValue = 4.into(); console::log_2(&\"Logging arbitrary values looks like\".into(), &js);\n}","breadcrumbs":"Examples » Using console.log » src/lib.rs","id":"8","title":"src/lib.rs"},"80":{"body":"--target deno To deploy WebAssembly to Deno, use the --target deno flag. To then import your module inside deno, use // @deno-types=\"./out/crate_name.d.ts\"\nimport { yourFunction } from \"./out/crate_name.js\";","breadcrumbs":"Reference » Deployment » Deno","id":"80","title":"Deno"},"81":{"body":"If you'd like to deploy compiled WebAssembly to NPM, then the tool for the job is wasm-pack . More information on this coming soon!","breadcrumbs":"Reference » Deployment » NPM","id":"81","title":"NPM"},"82":{"body":"Often when developing a crate you want to run on the web you'll want to include some JS code here and there. While js-sys and web-sys cover many needs they don't cover everything, so wasm-bindgen supports the ability to write JS code next to your Rust code and have it included in the final output artifact. To include a local JS file, you'll use the #[wasm_bindgen(module)] macro: #[wasm_bindgen(module = \"/js/foo.js\")]\nextern \"C\" { fn add(a: u32, b: u32) -> u32;\n} This declaration indicates that all the functions contained in the extern block are imported from the file /js/foo.js, where the root is relative to the crate root (where Cargo.toml is located). The /js/foo.js file will make its way to the final output when wasm-bindgen executes, so you can use the module annotation in a library without having to worry users of your library! The JS file itself must be written with ES module syntax: export function add(a, b) { return a + b;\n} A full design of this feature can be found in RFC 6 as well if you're interested!","breadcrumbs":"Reference » JS snippets » JS Snippets","id":"82","title":"JS Snippets"},"83":{"body":"In addition to module = \"...\" if you're a macro author you also have the ability to use the inline_js attribute: #[wasm_bindgen(inline_js = \"export function add(a, b) { return a + b; }\")]\nextern \"C\" { fn add(a: u32, b: u32) -> u32;\n} Using inline_js indicates that the JS module is specified inline in the attribute itself, and no files are loaded from the filesystem. They have the same limitations and caveats as when using module, but can sometimes be easier to generate for macros themselves. It's not recommended for hand-written code to make use of inline_js but instead to leverage module where possible.","breadcrumbs":"Reference » JS snippets » Using inline_js","id":"83","title":"Using inline_js"},"84":{"body":"While quite useful local JS snippets currently suffer from a few caveats which are important to be aware of. Many of these are temporary though! Currently import statements are not supported in the JS file. This is a restriction we may lift in the future once we settle on a good way to support this. For now, though, js snippets must be standalone modules and can't import from anything else. Only --target web and the default bundler output mode are supported. To support --target nodejs we'd need to translate ES module syntax to CommonJS (this is planned to be done, just hasn't been done yet). Additionally to support --target no-modules we'd have to similarly translate from ES modules to something else. Paths in module = \"...\" must currently start with /, or be rooted at the crate root. It is intended to eventually support relative paths like ./ and ../, but it's currently believed that this requires more support in the Rust proc_macro crate. As above, more detail about caveats can be found in RFC 6 .","breadcrumbs":"Reference » JS snippets » Caveats","id":"84","title":"Caveats"},"85":{"body":"JavaScript modules will often export arbitrary static objects for use with their provided interfaces. These objects can be accessed from Rust by declaring a named static in the extern block with an #[wasm_bindgen(thread_local_v2)] attribute. wasm-bindgen will bind a JsThreadLocal for these objects, which can be cloned into a JsValue. For example, given the following JavaScript: let COLORS = { red: 'rgb(255, 0, 0)', green: 'rgb(0, 255, 0)', blue: 'rgb(0, 0, 255)',\n}; static can aid in the access of this object from Rust: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(thread_local_v2)] static COLORS;\n} fn get_colors() -> JsValue { COLORS.with(JsValue::clone)\n} Since COLORS is effectively a JavaScript namespace, we can use the same mechanism to refer directly to namespaces exported from JavaScript modules, and even to exported classes: let namespace = { // Members of namespace...\n}; class SomeType { // Definition of SomeType...\n}; export { SomeType, namespace }; The binding for this module: #[wasm_bindgen(module = \"/js/some-rollup.js\")]\nextern \"C\" { // Likewise with the namespace--this refers to the object directly. #[wasm_bindgen(thread_local_v2, js_name = namespace)] static NAMESPACE: JsValue; // Refer to SomeType's class #[wasm_bindgen(thread_local_v2, js_name = SomeType)] static SOME_TYPE: JsValue; // Other bindings for SomeType type SomeType; #[wasm_bindgen(constructor)] fn new() -> SomeType;\n}","breadcrumbs":"Reference » Static JS Objects » Use of static to Access JS Objects","id":"85","title":"Use of static to Access JS Objects"},"86":{"body":"Strings can be imported to avoid going through TextDecoder/Encoder when requiring just a JsString. This can be useful when dealing with environments where TextDecoder/Encoder is not available, like in audio worklets. #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(thread_local_v2, static_string)] static STRING: JsString = \"a string literal\";\n}","breadcrumbs":"Reference » Static JS Objects » Static strings","id":"86","title":"Static strings"},"87":{"body":"The #[wasm_bindgen] attribute supports Rust closures being passed to JavaScript in two variants: Stack-lifetime closures that should not be invoked by JavaScript again after the imported JavaScript function that the closure was passed to returns. Heap-allocated closures that can be invoked any number of times, but must be explicitly deallocated when finished.","breadcrumbs":"Reference » Passing Rust Closures to JS » Passing Rust Closures to Imported JavaScript Functions","id":"87","title":"Passing Rust Closures to Imported JavaScript Functions"},"88":{"body":"Closures with a stack lifetime are passed to JavaScript as either &dyn Fn or &mut dyn FnMut trait objects: // Import JS functions that take closures #[wasm_bindgen]\nextern \"C\" { fn takes_immutable_closure(f: &dyn Fn()); fn takes_mutable_closure(f: &mut dyn FnMut());\n} // Usage takes_immutable_closure(&|| { // ...\n}); let mut times_called = 0;\ntakes_mutable_closure(&mut || { times_called += 1;\n}); Once these imported functions return, the closures that were given to them will become invalidated, and any future attempts to call those closures from JavaScript will raise an exception. Closures also support arguments and return values like exports do, for example: #[wasm_bindgen]\nextern \"C\" { fn takes_closure_that_takes_int_and_returns_string(x: &dyn Fn(u32) -> String);\n} takes_closure_that_takes_int_and_returns_string(&|x: u32| -> String { format!(\"x is {}\", x)\n});","breadcrumbs":"Reference » Passing Rust Closures to JS » Stack-Lifetime Closures","id":"88","title":"Stack-Lifetime Closures"},"89":{"body":"Sometimes the discipline of stack-lifetime closures is not desired. For example, you'd like to schedule a closure to be run on the next turn of the event loop in JavaScript through setTimeout. For this, you want the imported function to return but the JavaScript closure still needs to be valid! For this scenario, you need the Closure type, which is defined in the wasm_bindgen crate, exported in wasm_bindgen::prelude, and represents a \"long lived\" closure. The validity of the JavaScript closure is tied to the lifetime of the Closure in Rust. Once a Closure is dropped, it will deallocate its internal memory and invalidate the corresponding JavaScript function so that any further attempts to invoke it raise an exception. Like stack closures a Closure supports both Fn and FnMut closures, as well as arguments and returns. #[wasm_bindgen]\nextern \"C\" { fn setInterval(closure: &Closure<dyn FnMut()>, millis: u32) -> f64; fn clearInterval(token: f64); #[wasm_bindgen(js_namespace = console)] fn log(s: &str);\n} #[wasm_bindgen]\npub struct Interval { closure: Closure<dyn FnMut()>, token: f64,\n} impl Interval { pub fn new<F: 'static>(millis: u32, f: F) -> Interval where F: FnMut() { // Construct a new closure. let closure = Closure::new(f); // Pass the closure to JS, to run every n milliseconds. let token = setInterval(&closure, millis); Interval { closure, token } }\n} // When the Interval is destroyed, clear its `setInterval` timer.\nimpl Drop for Interval { fn drop(&mut self) { clearInterval(self.token); }\n} // Keep logging \"hello\" every second until the resulting `Interval` is dropped.\n#[wasm_bindgen]\npub fn hello() -> Interval { Interval::new(1_000, || log(\"hello\"))\n}","breadcrumbs":"Reference » Passing Rust Closures to JS » Heap-Allocated Closures","id":"89","title":"Heap-Allocated Closures"},"9":{"body":"View full source code or view the compiled example online One of wasm-bindgen's core goals is a pay-only-for-what-you-use philosophy, so if we don't use much then we shouldn't be paying much! As a result #[wasm_bindgen] can generate super-small executables Currently this code... use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn add(a: u32, b: u32) -> u32 { a + b\n} generates a 710 byte Wasm binary: $ ls -l add_bg.wasm\n-rw-rw-r-- 1 alex alex 710 Sep 19 17:32 add_bg.wasm If you run wasm-opt , a C++ tool for optimize WebAssembly, you can make it even smaller too! $ wasm-opt -Os add_bg.wasm -o add.wasm\n$ ls -l add.wasm\n-rw-rw-r-- 1 alex alex 172 Sep 19 17:33 add.wasm And sure enough, using the wasm2wat tool it's quite small! $ wasm2wat add.wasm\n(module (type (;0;) (func (param i32 i32) (result i32))) (func (;0;) (type 0) (param i32 i32) (result i32) get_local 1 get_local 0 i32.add) (table (;0;) 1 1 anyfunc) (memory (;0;) 17) (global (;0;) i32 (i32.const 1049118)) (global (;1;) i32 (i32.const 1049118)) (export \"memory\" (memory 0)) (export \"__indirect_function_table\" (table 0)) (export \"__heap_base\" (global 0)) (export \"__data_end\" (global 1)) (export \"add\" (func 0)) (data (i32.const 1049096) \"invalid malloc request\")) Also don't forget to compile in release mode for the smallest binaries! For larger applications you'll likely also want to turn on LTO to generate the smallest binaries: [profile.release]\nlto = true","breadcrumbs":"Examples » Small Wasm files » Small Wasm files","id":"9","title":"Small Wasm files"},"90":{"body":"You can use the js-sys crate to access JavaScript's Function type, and invoke that function via Function.prototype.apply and Function.prototype.call. For example, we can wrap a Vec<u32> in a new type, export it to JavaScript, and invoke a JavaScript closure on each member of the Vec: use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub struct VecU32 { xs: Vec<u32>,\n} #[wasm_bindgen]\nimpl VecU32 { pub fn each(&self, f: &js_sys::Function) { let this = JsValue::null(); for &x in &self.xs { let x = JsValue::from(x); let _ = f.call1(&this, &x); } }\n} Since Rust has no function overloading, the call# method also requires a number representing the amount of arguments passed to the JavaScript closure.","breadcrumbs":"Reference » Receiving JS Closures in Rust » Receiving JavaScript Closures in Exported Rust Functions","id":"90","title":"Receiving JavaScript Closures in Exported Rust Functions"},"91":{"body":"Many APIs on the web work with a Promise, such as an async function in JS. Naturally you'll probably want to interoperate with them from Rust! To do that you can use the wasm-bindgen-futures crate as well as Rust async functions. The first thing you might encounter is the need for working with a Promise. For this you'll want to use js_sys::Promise . Once you've got one of those values you can convert that value to wasm_bindgen_futures::JsFuture. This type implements the std::future::Future trait which allows naturally using it in an async function. For example: async fn get_from_js() -> Result<JsValue, JsValue> { let promise = js_sys::Promise::resolve(&42.into()); let result = wasm_bindgen_futures::JsFuture::from(promise).await?; Ok(result)\n} Here we can see how converting a Promise to Rust creates a impl Future<Output = Result<JsValue, JsValue>>. This corresponds to then and catch in JS where a successful promise becomes Ok and an erroneous promise becomes Err. You can also import a JS async function directly with a extern \"C\" block, and the promise will be converted to a future automatically. For now the return type must be JsValue or no return at all: #[wasm_bindgen]\nextern \"C\" { async fn async_func_1_ret_number() -> JsValue; async fn async_func_2();\n} async fn get_from_js() -> f64 { async_func_1_ret_number().await.as_f64().unwrap_or(0.0)\n} The async can be combined with the catch attribute to manage errors from the JS promise: #[wasm_bindgen]\nextern \"C\" { #[wasm_bindgen(catch)] async fn async_func_3() -> Result<JsValue, JsValue>; #[wasm_bindgen(catch)] async fn async_func_4() -> Result<(), JsValue>;\n} Next up you'll probably want to export a Rust function to JS that returns a promise. To do this you can use an async function and #[wasm_bindgen]: #[wasm_bindgen]\npub async fn foo() { // ...\n} When invoked from JS the foo function here will return a Promise, so you can import this as: import { foo } from \"my-module\"; async function shim() { const result = await foo(); // ...\n}","breadcrumbs":"Reference » Promises and Futures » Working with a JS Promise and a Rust Future","id":"91","title":"Working with a JS Promise and a Rust Future"},"92":{"body":"When using an async fn in Rust and exporting it to JS there's some restrictions on the return type. The return value of an exported Rust function will eventually become Result<JsValue, JsValue> where Ok turns into a successfully resolved promise and Err is equivalent to throwing an exception. The following types are supported as return types from an async fn: () - turns into a successful undefined in JS T: Into<JsValue> - turns into a successful JS value Result<(), E: Into<JsValue>> - if Ok(()) turns into a successful undefined and otherwise turns into a failed promise with E converted to a JS value Result<T: Into<JsValue>, E: Into<JsValue>> - like the previous case except both data payloads are converted into a JsValue. Note that many types implement being converted into a JsValue, such as all imported types via #[wasm_bindgen] (aka those in js-sys or web-sys), primitives like u32, and all exported #[wasm_bindgen] types. In general, you should be able to write code without having too many explicit conversions, and the macro should take care of the rest!","breadcrumbs":"Reference » Promises and Futures » Return values of async fn","id":"92","title":"Return values of async fn"},"93":{"body":"The wasm-bindgen-futures crate bridges the gap between JavaScript Promises and Rust Futures. Its JsFuture type provides conversion from a JavaScript Promise into a Rust Future, and its future_to_promise function converts a Rust Future into a JavaScript Promise and schedules it to be driven to completion. Learn more: wasm_bindgen_futures on crates.io wasm-bindgen-futures API documentation and example usage","breadcrumbs":"Reference » Promises and Futures » Using wasm-bindgen-futures","id":"93","title":"Using wasm-bindgen-futures"},"94":{"body":"The current crate on crates.io, wasm-bindgen-futures 0.4.*, supports std::future::Future and async/await in Rust. This typically requires Rust 1.39.0+ (as of this writing on 2019-09-05 it's the nightly channel of Rust). If you're using the Future trait from the futures 0.1.* crate then you'll want to use the 0.3.* track of wasm-bindgen-futures on crates.io.","breadcrumbs":"Reference » Promises and Futures » Compatibility with versions of Future","id":"94","title":"Compatibility with versions of Future"},"95":{"body":"","breadcrumbs":"Reference » Iterating over JS Values » Iterating over JavaScript Values","id":"95","title":"Iterating over JavaScript Values"},"96":{"body":"Some JavaScript collections have methods for iterating over their values or keys: Map::values Set::keys etc... These methods return js_sys::Iterator , which is the Rust representation of a JavaScript object that has a next method that either returns the next item in the iteration, notes that iteration has completed, or throws an error. That is, js_sys::Iterator represents an object that implements the duck-typed JavaScript iteration protocol . js_sys::Iterator can be converted into a Rust iterator either by reference (into js_sys::Iter<'a> ) or by value (into js_sys::IntoIter ). The Rust iterator will yield items of type Result<JsValue>. If it yields an Ok(...), then the JS iterator protocol returned an element. If it yields an Err(...), then the JS iterator protocol threw an exception. use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn count_strings_in_set(set: &js_sys::Set) -> u32 { let mut count = 0; // Call `keys` to get an iterator over the set's elements. Because this is // in a `for ... in ...` loop, Rust will automatically call its // `IntoIterator` trait implementation to convert it into a Rust iterator. for x in set.keys() { // We know the built-in iterator for set elements won't throw // exceptions, so just unwrap the element. If this was an untrusted // iterator, we might want to explicitly handle the case where it throws // an exception instead of returning a `{ value, done }` object. let x = x.unwrap(); // If `x` is a string, increment our count of strings in the set! if x.is_string() { count += 1; } } count\n}","breadcrumbs":"Reference » Iterating over JS Values » Methods That Return js_sys::Iterator","id":"96","title":"Methods That Return js_sys::Iterator"},"97":{"body":"You could manually test for whether an object implements JS's duck-typed iterator protocol, and if so, convert it into a js_sys::Iterator that you can finally iterate over. You don't need to do this by-hand, however, since we bundled this up as the js_sys::try_iter function! For example, we can write a function that collects the numbers from any JS iterable and returns them as an Array: use wasm_bindgen::prelude::*; #[wasm_bindgen]\npub fn collect_numbers(some_iterable: &JsValue) -> Result<js_sys::Array, JsValue> { let nums = js_sys::Array::new(); let iterator = js_sys::try_iter(some_iterable)?.ok_or_else(|| { \"need to pass iterable JS values!\" })?; for x in iterator { // If the iterator's `next` method throws an error, propagate it // up to the caller. let x = x?; // If `x` is a number, add it to our array of numbers! if x.as_f64().is_some() { nums.push(&x); } } Ok(nums)\n}","breadcrumbs":"Reference » Iterating over JS Values » Iterating Over Any JavaScript Object that Implements the Iterator Protocol","id":"97","title":"Iterating Over Any JavaScript Object that Implements the Iterator Protocol"},"98":{"body":"It's possible to pass arbitrary data from Rust to JavaScript by serializing it with Serde . This can be done through the serde-wasm-bindgen crate.","breadcrumbs":"Reference » Arbitrary Data with Serde » Serializing and Deserializing Arbitrary Data Into and From JsValue with Serde","id":"98","title":"Serializing and Deserializing Arbitrary Data Into and From JsValue with Serde"},"99":{"body":"To use serde-wasm-bindgen, you first have to add it as a dependency in your Cargo.toml. You also need the serde crate, with the derive feature enabled, to allow your types to be serialized and deserialized with Serde. [dependencies]\nserde = { version = \"1.0\", features = [\"derive\"] }\nserde-wasm-bindgen = \"0.4\"","breadcrumbs":"Reference » Arbitrary Data with Serde » Add dependencies","id":"99","title":"Add dependencies"}},"length":316,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"4":{"2":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"3":{"2":{">":{">":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"0":{".":{"0":{"df":11,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"0":{"5":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"33":{"tf":2.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"43":{"tf":2.449489742783178}}},"1":{".":{"6":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"1":{"df":1,"docs":{"244":{"tf":1.0}}},"5":{"df":1,"docs":{"35":{"tf":1.0}}},"df":3,"docs":{"104":{"tf":1.0},"250":{"tf":1.0},"94":{"tf":1.0}}},"2":{".":{"8":{"8":{"df":1,"docs":{"211":{"tf":1.0}}},"df":1,"docs":{"250":{"tf":1.0}}},"9":{"6":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"135":{"tf":1.0},"228":{"tf":1.0},"242":{"tf":1.0}},"x":{"df":1,"docs":{"104":{"tf":1.0}}}},"3":{".":{"0":{"df":1,"docs":{"242":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"228":{"tf":1.0},"229":{"tf":1.0},"250":{"tf":1.0},"94":{"tf":1.0}}},"4":{"df":2,"docs":{"94":{"tf":1.0},"99":{"tf":1.0}}},"6":{"5":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"43":{"tf":2.23606797749979}}},"df":0,"docs":{}},"5":{"df":2,"docs":{"242":{"tf":1.0},"94":{"tf":1.0}}},"6":{"df":0,"docs":{},"t":{"1":{"8":{":":{"2":{"1":{":":{"4":{"9":{"df":0,"docs":{},"z":{"df":1,"docs":{"311":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{"df":1,"docs":{"311":{"tf":1.0}}},"9":{"df":3,"docs":{"242":{"tf":1.0},"302":{"tf":1.0},"94":{"tf":1.0}}},"df":20,"docs":{"14":{"tf":1.0},"143":{"tf":1.0},"16":{"tf":1.4142135623730951},"162":{"tf":2.449489742783178},"207":{"tf":1.4142135623730951},"210":{"tf":1.0},"23":{"tf":1.4142135623730951},"244":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"85":{"tf":2.0},"88":{"tf":1.0},"9":{"tf":3.3166247903554},"96":{"tf":1.0}}},"1":{")":{"[":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":3,"docs":{"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"99":{"tf":1.0}}},"3":{"9":{".":{"0":{"df":3,"docs":{"242":{"tf":1.0},"250":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.4142135623730951}}},"9":{"9":{"9":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"/":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"4":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"4":{"9":{"0":{"9":{"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"8":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":5,"docs":{"147":{"tf":1.0},"196":{"tf":2.0},"214":{"tf":1.0},"264":{"tf":1.0},"275":{"tf":1.0}}},"1":{"df":1,"docs":{"138":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}},"df":2,"docs":{"30":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"3":{"df":1,"docs":{"221":{"tf":1.0}}},"4":{".":{"6":{".":{"0":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":2,"docs":{"171":{"tf":1.0},"177":{"tf":2.23606797749979}}},"7":{"2":{"df":1,"docs":{"9":{"tf":1.0}}},":":{"3":{"2":{"df":1,"docs":{"9":{"tf":1.0}}},"3":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":2,"docs":{"272":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":25,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"140":{"tf":1.0},"143":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.7320508075688772},"171":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"23":{"tf":1.7320508075688772},"243":{"tf":1.0},"244":{"tf":1.7320508075688772},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"46":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":2.6457513110645907},"96":{"tf":1.0}}},"2":{".":{"0":{"df":2,"docs":{"33":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"0":{"1":{"8":{"df":2,"docs":{"302":{"tf":1.0},"311":{"tf":1.0}}},"9":{"df":2,"docs":{"242":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":11,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"147":{"tf":1.4142135623730951},"214":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}},"4":{"df":1,"docs":{"302":{"tf":1.0}}},"5":{"5":{"df":2,"docs":{"162":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"7":{".":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"3":{".":{"1":{"5":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":0,"docs":{},"k":{"b":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":5,"docs":{"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}},"df":18,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"143":{"tf":1.0},"153":{"tf":1.4142135623730951},"171":{"tf":1.0},"18":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"243":{"tf":1.4142135623730951},"244":{"tf":1.4142135623730951},"286":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"59":{"tf":1.0}},"f":{"3":{"2":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"f":{"(":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"104":{"tf":1.0}}}},"3":{"0":{"0":{"df":4,"docs":{"166":{"tf":1.0},"43":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"3":{"df":1,"docs":{"211":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"140":{"tf":1.0},"160":{"tf":1.4142135623730951},"288":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":1,"docs":{"289":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"153":{"tf":1.0},"196":{"tf":2.0},"220":{"tf":1.0},"221":{"tf":1.0},"295":{"tf":1.0},"312":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"4":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"2":{".":{"0":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.4142135623730951},"147":{"tf":1.0},"162":{"tf":2.0},"206":{"tf":1.0},"212":{"tf":1.0},"249":{"tf":1.0}}},"5":{"df":1,"docs":{"215":{"tf":1.4142135623730951}}},"a":{"3":{"0":{"9":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"6":{"a":{"d":{"8":{"0":{"5":{"0":{"3":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{":":{"6":{"1":{":":{"6":{"6":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"244":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"18":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"294":{"tf":1.0},"297":{"tf":1.0},"302":{"tf":1.4142135623730951},"36":{"tf":1.0}}},"5":{".":{"0":{".":{"4":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"1":{".":{"4":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"230":{"tf":1.0}},"p":{"df":0,"docs":{},"x":{"df":1,"docs":{"230":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":2,"docs":{"130":{"tf":1.0},"205":{"tf":1.0}}},"6":{"0":{"0":{"df":1,"docs":{"35":{"tf":2.0}}},"df":0,"docs":{}},"4":{"df":3,"docs":{"160":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"33":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"103":{"tf":1.0},"295":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"7":{"1":{"0":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":0,"docs":{},"k":{"b":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"df":1,"docs":{"140":{"tf":1.0}}},"df":1,"docs":{"46":{"tf":1.0}}},"8":{"'":{")":{".":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"292":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"292":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"8":{"0":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"177":{"tf":1.4142135623730951},"195":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0},"78":{"tf":1.0}}},"9":{"0":{"0":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":0,"docs":{},"k":{"b":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"df":1,"docs":{"214":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}},"_":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"294":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"294":{"tf":2.0}}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"244":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":2,"docs":{"288":{"tf":1.0},"289":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"292":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"g":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"_":{"a":{"8":{"1":{"4":{"5":{"6":{"3":{"8":{"6":{"df":0,"docs":{},"e":{"6":{"b":{"5":{"2":{"6":{"df":0,"docs":{},"f":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":2,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"195":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"195":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"195":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"194":{"tf":1.0},"195":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"a":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"294":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"0":{"df":1,"docs":{"294":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"294":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"s":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"_":{"1":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":1,"docs":{"292":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"299":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"292":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"290":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"289":{"tf":1.0},"290":{"tf":1.0},"294":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"78":{"tf":1.0}}}},"df":7,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":1,"docs":{"46":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"292":{"tf":1.0},"294":{"tf":1.0}}}}},"s":{"df":1,"docs":{"112":{"tf":1.0}}}},"a":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"4":{"df":1,"docs":{"39":{"tf":1.0}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"294":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"292":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"100":{"tf":1.0},"141":{"tf":1.0},"285":{"tf":1.0},"294":{"tf":1.0},"297":{"tf":2.0},"298":{"tf":2.0}},"l":{"df":3,"docs":{"193":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":20,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"216":{"tf":1.0},"23":{"tf":1.4142135623730951},"245":{"tf":1.0},"260":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.4142135623730951},"291":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"296":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"202":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"199":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":25,"docs":{"106":{"tf":1.0},"177":{"tf":1.0},"193":{"tf":2.6457513110645907},"194":{"tf":1.0},"196":{"tf":1.7320508075688772},"198":{"tf":1.0},"199":{"tf":2.0},"205":{"tf":2.23606797749979},"212":{"tf":1.0},"213":{"tf":1.0},"215":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"23":{"tf":1.0},"231":{"tf":1.4142135623730951},"234":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"236":{"tf":1.0},"237":{"tf":1.0},"286":{"tf":1.0},"292":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"85":{"tf":1.7320508075688772},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"193":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"249":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"194":{"tf":1.0},"299":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"271":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"160":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"289":{"tf":1.0},"66":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"220":{"tf":1.0},"59":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"190":{"tf":1.0},"265":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"294":{"tf":1.0}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"v":{"2":{"df":1,"docs":{"265":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":6,"docs":{"20":{"tf":1.0},"293":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":21,"docs":{"10":{"tf":1.4142135623730951},"132":{"tf":1.0},"140":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.4142135623730951},"233":{"tf":1.0},"285":{"tf":1.0},"288":{"tf":1.7320508075688772},"289":{"tf":1.0},"290":{"tf":1.0},"291":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.7320508075688772},"294":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"297":{"tf":1.7320508075688772},"299":{"tf":1.7320508075688772},"306":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"272":{"tf":1.0}}}}},"d":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},"(":{"1":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"135":{"tf":1.0}}},"a":{"df":5,"docs":{"10":{"tf":1.0},"135":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"2":{"(":{"&":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":2.0}}}}},"df":0,"docs":{}}},"<":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"288":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":2,"docs":{"140":{"tf":1.0},"288":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"288":{"tf":1.0},"289":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}}}}},"df":27,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"190":{"tf":1.0},"193":{"tf":1.0},"216":{"tf":1.0},"228":{"tf":1.0},"242":{"tf":1.0},"247":{"tf":1.0},"256":{"tf":1.0},"264":{"tf":1.0},"270":{"tf":1.0},"275":{"tf":1.0},"29":{"tf":1.0},"302":{"tf":1.0},"303":{"tf":1.7320508075688772},"312":{"tf":1.4142135623730951},"313":{"tf":1.0},"55":{"tf":1.4142135623730951},"9":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"_":{"_":{"df":0,"docs":{},"w":{"b":{"df":0,"docs":{},"g":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":2,"docs":{"194":{"tf":1.0},"195":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"289":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"295":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"222":{"tf":1.0},"236":{"tf":1.0},"245":{"tf":1.0},"299":{"tf":1.0},"83":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"195":{"tf":1.0},"204":{"tf":1.0},"286":{"tf":1.0},"84":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"263":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"156":{"tf":1.0},"159":{"tf":1.0}}}}}}},"df":10,"docs":{"133":{"tf":1.0},"14":{"tf":1.0},"193":{"tf":1.0},"205":{"tf":1.0},"219":{"tf":1.0},"293":{"tf":1.0},"302":{"tf":1.7320508075688772},"303":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"286":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"d":{"df":0,"docs":{},"w":{"df":1,"docs":{"315":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"215":{"tf":1.0},"221":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"303":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"289":{"tf":1.0},"292":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"h":{"df":1,"docs":{"289":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":2,"docs":{"221":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":2,"docs":{"135":{"tf":1.0},"74":{"tf":1.0}}}},"k":{"a":{"df":6,"docs":{"195":{"tf":1.0},"288":{"tf":1.0},"293":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"4":{"tf":1.0}}},"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.0}}}},"x":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"315":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"113":{"tf":1.0},"9":{"tf":2.0}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"293":{"tf":2.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"140":{"tf":1.0}}}},"v":{"df":2,"docs":{"30":{"tf":1.0},"46":{"tf":1.0}}}},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"243":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"c":{"df":7,"docs":{"139":{"tf":1.0},"289":{"tf":1.4142135623730951},"292":{"tf":1.4142135623730951},"308":{"tf":1.0},"43":{"tf":1.7320508075688772},"87":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"308":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"308":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":21,"docs":{"0":{"tf":1.0},"111":{"tf":1.0},"130":{"tf":1.0},"190":{"tf":1.0},"200":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"235":{"tf":1.0},"243":{"tf":1.0},"257":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.4142135623730951},"293":{"tf":1.0},"298":{"tf":1.0},"72":{"tf":1.0},"91":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"246":{"tf":1.0},"295":{"tf":1.0},"4":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"219":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"132":{"tf":1.0},"197":{"tf":1.0},"246":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"292":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":7,"docs":{"104":{"tf":1.4142135623730951},"130":{"tf":1.0},"208":{"tf":1.4142135623730951},"238":{"tf":1.0},"46":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"140":{"tf":1.0},"276":{"tf":1.0},"66":{"tf":1.7320508075688772}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":14,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"128":{"tf":1.0},"139":{"tf":1.0},"177":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"204":{"tf":1.0},"256":{"tf":1.0},"304":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"188":{"tf":1.0},"39":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"39":{"tf":2.0}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"290":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"298":{"tf":2.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"249":{"tf":1.0},"284":{"tf":1.0},"292":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":13,"docs":{"136":{"tf":1.0},"187":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":1.7320508075688772},"205":{"tf":1.0},"207":{"tf":1.0},"210":{"tf":1.0},"216":{"tf":1.4142135623730951},"286":{"tf":1.0},"293":{"tf":2.0},"295":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"298":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"103":{"tf":1.0},"137":{"tf":1.0},"192":{"tf":1.4142135623730951},"289":{"tf":1.0},"292":{"tf":1.0},"299":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"295":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"(":{"&":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":4,"docs":{"207":{"tf":1.0},"284":{"tf":1.0},"49":{"tf":2.0},"74":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"140":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":39,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"12":{"tf":1.0},"140":{"tf":1.0},"177":{"tf":1.0},"199":{"tf":1.0},"20":{"tf":1.0},"208":{"tf":2.0},"22":{"tf":1.0},"225":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"229":{"tf":2.0},"231":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"238":{"tf":3.4641016151377544},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":2.23606797749979},"303":{"tf":2.0},"304":{"tf":1.4142135623730951},"308":{"tf":2.8284271247461903},"309":{"tf":1.4142135623730951},"31":{"tf":1.0},"312":{"tf":2.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":3,"docs":{"132":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"219":{"tf":1.0},"30":{"tf":1.0}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"245":{"tf":1.0},"258":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"d":{"=":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"v":{"3":{"+":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"0":{"tf":1.0},"132":{"tf":1.0},"202":{"tf":1.0},"217":{"tf":1.0},"29":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0}}},"df":6,"docs":{"199":{"tf":1.0},"200":{"tf":1.0},"212":{"tf":1.0},"224":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"104":{"tf":2.23606797749979},"287":{"tf":1.0},"299":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"162":{"tf":1.4142135623730951},"181":{"tf":1.0},"184":{"tf":1.0},"23":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"261":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}}}},"v":{"df":1,"docs":{"314":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"264":{"tf":2.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"106":{"tf":1.0},"218":{"tf":1.0},"233":{"tf":1.0},"288":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"(":{"6":{"0":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"160":{"tf":1.0},"314":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"g":{"0":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"292":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"df":5,"docs":{"288":{"tf":2.0},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":2.0}}},"1":{"df":3,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"293":{"tf":1.0}}},"2":{"df":2,"docs":{"194":{"tf":2.0},"195":{"tf":2.23606797749979}}},"df":2,"docs":{"216":{"tf":2.23606797749979},"256":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"191":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":2.0},"199":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":2.6457513110645907},"217":{"tf":1.0},"220":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"256":{"tf":1.0},"270":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"292":{"tf":2.23606797749979},"294":{"tf":1.4142135623730951},"295":{"tf":1.7320508075688772},"297":{"tf":1.4142135623730951},"298":{"tf":1.7320508075688772},"59":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"s":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"207":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"162":{"tf":1.0},"163":{"tf":1.0},"287":{"tf":1.0},"290":{"tf":1.4142135623730951},"291":{"tf":1.0},"292":{"tf":1.4142135623730951},"294":{"tf":1.0},"296":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"207":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"y":{"(":{"3":{"2":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"140":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"288":{"tf":1.0},"289":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"&":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"1":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"292":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"233":{"tf":1.0}}}}}}}}}}}},"df":19,"docs":{"100":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"14":{"tf":1.0},"151":{"tf":1.7320508075688772},"153":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"199":{"tf":1.0},"207":{"tf":1.0},"225":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"289":{"tf":1.4142135623730951},"292":{"tf":1.0},"300":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"132":{"tf":1.0},"272":{"tf":1.7320508075688772},"3":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"233":{"tf":1.0},"236":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"k":{"df":2,"docs":{"12":{"tf":1.0},"266":{"tf":1.0}}},"m":{"df":0,"docs":{},"j":{"df":1,"docs":{"136":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"192":{"tf":1.0}}}}}},"df":1,"docs":{"192":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"194":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":1.0},"299":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"236":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"236":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"192":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"236":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"236":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"236":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"236":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"192":{"tf":1.4142135623730951},"23":{"tf":1.0},"236":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"207":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"1":{"df":1,"docs":{"243":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"196":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"x":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"249":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"244":{"tf":1.0},"281":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":6,"docs":{"108":{"tf":1.0},"120":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"202":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":6,"docs":{"20":{"tf":1.0},"293":{"tf":1.0},"297":{"tf":1.4142135623730951},"299":{"tf":1.0},"30":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"1":{"tf":1.0},"207":{"tf":1.0},"233":{"tf":1.0},"289":{"tf":1.0},"76":{"tf":1.0}}}}},"t":{"df":1,"docs":{"311":{"tf":1.0}}},"y":{"df":0,"docs":{},"n":{"c":{"/":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"_":{"1":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"0":{".":{"0":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"91":{"tf":1.0}}},"3":{"df":1,"docs":{"91":{"tf":1.0}}},"4":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"18":{"tf":1.0},"218":{"tf":1.4142135623730951},"249":{"tf":1.4142135623730951},"250":{"tf":1.7320508075688772},"28":{"tf":1.0},"30":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"91":{"tf":3.7416573867739413},"92":{"tf":1.7320508075688772}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"249":{"tf":1.7320508075688772},"29":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"190":{"tf":1.0},"191":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"59":{"tf":2.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"112":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"214":{"tf":1.0},"66":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"30":{"tf":2.8284271247461903}},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":41,"docs":{"111":{"tf":1.0},"123":{"tf":1.0},"13":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.7320508075688772},"194":{"tf":2.23606797749979},"196":{"tf":1.4142135623730951},"197":{"tf":1.7320508075688772},"198":{"tf":2.23606797749979},"199":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.7320508075688772},"202":{"tf":1.7320508075688772},"203":{"tf":2.0},"204":{"tf":2.0},"205":{"tf":2.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.7320508075688772},"217":{"tf":1.7320508075688772},"218":{"tf":1.7320508075688772},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"238":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"273":{"tf":1.0},"286":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"295":{"tf":2.449489742783178},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"208":{"tf":2.449489742783178},"38":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"39":{"tf":1.0},"68":{"tf":1.0},"86":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"20":{"tf":1.0},"219":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"83":{"tf":1.0}}}}},"o":{"df":2,"docs":{"216":{"tf":1.4142135623730951},"312":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"217":{"tf":1.4142135623730951},"270":{"tf":1.0},"52":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":15,"docs":{"11":{"tf":1.0},"114":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0},"199":{"tf":1.0},"209":{"tf":1.0},"25":{"tf":1.0},"252":{"tf":1.0},"293":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"238":{"tf":1.0},"290":{"tf":1.0},"303":{"tf":1.0},"59":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"91":{"tf":1.0}}}},"r":{"df":4,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"217":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"208":{"tf":1.0},"211":{"tf":1.0},"28":{"tf":1.0},"295":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"293":{"tf":1.0}}}},"r":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"216":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}}}}},".":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"199":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"295":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"295":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"295":{"tf":1.0}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"295":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"b":{"a":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":10,"docs":{"143":{"tf":1.7320508075688772},"192":{"tf":2.6457513110645907},"194":{"tf":1.0},"195":{"tf":1.0},"198":{"tf":1.4142135623730951},"199":{"tf":1.0},"203":{"tf":1.4142135623730951},"215":{"tf":2.0},"224":{"tf":1.4142135623730951},"295":{"tf":5.656854249492381}},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":4,"docs":{"134":{"tf":1.0},"295":{"tf":1.0},"298":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"=":{"$":{"(":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"105":{"tf":1.0},"111":{"tf":1.4142135623730951},"262":{"tf":1.0},"276":{"tf":1.0},"285":{"tf":1.0},"293":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"c":{"df":6,"docs":{"208":{"tf":1.0},"23":{"tf":1.0},"292":{"tf":1.0},"294":{"tf":1.4142135623730951},"298":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"(":{"3":{"df":2,"docs":{"220":{"tf":1.0},"221":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"df":5,"docs":{"192":{"tf":1.4142135623730951},"215":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"221":{"tf":2.23606797749979},"224":{"tf":1.0}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"18":{"tf":1.0},"198":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"191":{"tf":1.0},"204":{"tf":1.4142135623730951},"221":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"df":10,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":2.0},"205":{"tf":1.0},"238":{"tf":1.0},"292":{"tf":1.0},"59":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"289":{"tf":1.7320508075688772},"29":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"295":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"221":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"140":{"tf":1.0},"229":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"z":{"df":1,"docs":{"315":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"84":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"146":{"tf":1.0},"193":{"tf":1.0},"221":{"tf":1.0},"23":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"135":{"tf":1.0},"195":{"tf":1.0},"304":{"tf":1.0},"46":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"140":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.4142135623730951},"212":{"tf":1.0},"234":{"tf":1.0},"237":{"tf":1.7320508075688772},"39":{"tf":2.0},"47":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"93":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"235":{"tf":1.0},"250":{"tf":1.0},"298":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"160":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"118":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"140":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"d":{"df":33,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"189":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"198":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"207":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"290":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.4142135623730951},"300":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":1.4142135623730951},"306":{"tf":1.4142135623730951},"307":{"tf":1.0},"308":{"tf":1.7320508075688772},"312":{"tf":1.4142135623730951},"62":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":5,"docs":{"104":{"tf":1.0},"277":{"tf":1.0},"304":{"tf":1.0},"307":{"tf":1.0},"9":{"tf":1.0}}},"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"df":2,"docs":{"300":{"tf":1.0},"301":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"b":{"df":2,"docs":{"304":{"tf":1.0},"310":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":100,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":1.7320508075688772},"100":{"tf":1.0},"104":{"tf":2.0},"105":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":2.0},"132":{"tf":2.449489742783178},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.4142135623730951},"161":{"tf":1.0},"190":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.0},"20":{"tf":1.4142135623730951},"205":{"tf":1.0},"207":{"tf":1.0},"211":{"tf":1.0},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"225":{"tf":1.0},"228":{"tf":1.0},"239":{"tf":1.7320508075688772},"241":{"tf":1.0},"242":{"tf":2.0},"245":{"tf":1.4142135623730951},"246":{"tf":1.7320508075688772},"247":{"tf":1.0},"249":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"258":{"tf":1.0},"262":{"tf":1.4142135623730951},"264":{"tf":1.0},"27":{"tf":1.7320508075688772},"272":{"tf":1.0},"274":{"tf":1.4142135623730951},"278":{"tf":1.4142135623730951},"279":{"tf":1.4142135623730951},"281":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"285":{"tf":2.0},"286":{"tf":1.4142135623730951},"287":{"tf":1.0},"288":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.0},"299":{"tf":2.0},"3":{"tf":1.7320508075688772},"301":{"tf":1.4142135623730951},"303":{"tf":1.0},"310":{"tf":1.4142135623730951},"311":{"tf":1.0},"312":{"tf":1.0},"313":{"tf":1.7320508075688772},"314":{"tf":1.0},"32":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"295":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"t":{"df":19,"docs":{"124":{"tf":1.0},"160":{"tf":1.7320508075688772},"163":{"tf":1.0},"165":{"tf":1.0},"177":{"tf":1.0},"216":{"tf":1.4142135623730951},"22":{"tf":1.0},"249":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"292":{"tf":1.0},"295":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"h":{"df":8,"docs":{"197":{"tf":1.0},"198":{"tf":1.0},"199":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"b":{"df":2,"docs":{"45":{"tf":1.0},"46":{"tf":2.0}}},"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"199":{"tf":1.0}}},"df":14,"docs":{"13":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.0},"199":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"220":{"tf":1.0},"23":{"tf":1.0},"249":{"tf":1.0},"293":{"tf":1.4142135623730951},"30":{"tf":1.0},"66":{"tf":2.0},"82":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":7,"docs":{"10":{"tf":2.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"y":{"'":{"df":1,"docs":{"52":{"tf":1.0}}},"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"206":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"134":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"272":{"tf":1.0}}},"l":{"df":6,"docs":{"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"200":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.4142135623730951},"59":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"168":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"168":{"tf":2.0},"170":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":17,"docs":{"193":{"tf":1.0},"207":{"tf":1.4142135623730951},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"221":{"tf":1.0},"256":{"tf":1.0},"286":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.0},"298":{"tf":1.0},"39":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"288":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"141":{"tf":1.0},"187":{"tf":1.0},"293":{"tf":1.0}}}}},"df":4,"docs":{"191":{"tf":1.0},"194":{"tf":1.0},"297":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"[":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":2,"docs":{"184":{"tf":1.0},"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"1":{"6":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"152":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"151":{"tf":1.0}}},"u":{"1":{"6":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"3":{"2":{"df":2,"docs":{"184":{"tf":1.0},"185":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"151":{"tf":1.4142135623730951},"181":{"tf":1.0},"184":{"tf":1.7320508075688772},"292":{"tf":1.0},"293":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"300":{"tf":1.0},"304":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"234":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"130":{"tf":1.0},"16":{"tf":1.0},"211":{"tf":1.0},"238":{"tf":1.7320508075688772},"266":{"tf":1.0},"314":{"tf":1.0},"36":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"285":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"274":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"257":{"tf":1.0},"261":{"tf":1.0}}},"df":35,"docs":{"10":{"tf":1.7320508075688772},"104":{"tf":1.0},"128":{"tf":1.4142135623730951},"13":{"tf":1.0},"137":{"tf":2.6457513110645907},"139":{"tf":1.0},"140":{"tf":1.0},"221":{"tf":1.0},"238":{"tf":1.4142135623730951},"24":{"tf":1.0},"244":{"tf":1.0},"245":{"tf":1.0},"251":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":2.0},"255":{"tf":1.7320508075688772},"256":{"tf":1.7320508075688772},"257":{"tf":1.0},"258":{"tf":1.4142135623730951},"259":{"tf":2.23606797749979},"260":{"tf":1.0},"261":{"tf":2.449489742783178},"278":{"tf":1.7320508075688772},"308":{"tf":1.4142135623730951},"310":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"292":{"tf":1.0}}}}}}}}},"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"156":{"tf":1.0},"159":{"tf":1.0}}}}}},"df":3,"docs":{"156":{"tf":1.0},"159":{"tf":1.0},"292":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"104":{"tf":1.0},"233":{"tf":1.0},"43":{"tf":2.23606797749979}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"233":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"g":{"df":5,"docs":{"131":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"307":{"tf":1.0}}},".":{"df":0,"docs":{},"r":{"df":5,"docs":{"304":{"tf":1.0},"305":{"tf":1.0},"307":{"tf":1.4142135623730951},"308":{"tf":1.0},"311":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"57":{"tf":1.0}}}}},"df":16,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.0},"238":{"tf":1.0},"264":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":1.0},"311":{"tf":2.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":2.449489742783178},"69":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":1.0},"285":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"196":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"285":{"tf":1.0}}}}},"p":{"df":1,"docs":{"313":{"tf":1.7320508075688772}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"295":{"tf":1.0}}}},"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"128":{"tf":1.0},"130":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":2.0},"132":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"202":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"294":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"234":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"12":{"tf":2.8284271247461903},"156":{"tf":1.0},"159":{"tf":1.0},"233":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"c":{"/":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"193":{"tf":1.4142135623730951},"205":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"210":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"300":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}},"df":9,"docs":{"23":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"30":{"tf":1.0},"300":{"tf":1.0},"46":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":3.0},"62":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":45,"docs":{"10":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.0},"12":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"168":{"tf":1.0},"177":{"tf":1.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"194":{"tf":2.23606797749979},"195":{"tf":2.0},"196":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.4142135623730951},"207":{"tf":1.0},"21":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"23":{"tf":1.4142135623730951},"230":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.0},"285":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.4142135623730951},"290":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.7320508075688772},"298":{"tf":1.0},"299":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"198":{"tf":1.0},"212":{"tf":1.0}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"269":{"tf":1.0},"288":{"tf":1.0},"297":{"tf":1.4142135623730951},"66":{"tf":1.0},"84":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"a":{"df":7,"docs":{"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":2.23606797749979},"35":{"tf":1.0},"43":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.7320508075688772}},"s":{".":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"'":{"2":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"(":{"4":{"8":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"6":{"4":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"\"":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"2":{"d":{"df":3,"docs":{"32":{"tf":1.0},"36":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"110":{"tf":1.0},"256":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"292":{"tf":1.0},"43":{"tf":1.0},"72":{"tf":1.0},"92":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"242":{"tf":1.0}}},"df":21,"docs":{"10":{"tf":1.0},"104":{"tf":1.0},"20":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"246":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"305":{"tf":1.0},"309":{"tf":1.0},"312":{"tf":1.0},"32":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"82":{"tf":1.0},"99":{"tf":1.0}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"238":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":1,"docs":{"247":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":32,"docs":{"10":{"tf":1.4142135623730951},"115":{"tf":1.0},"218":{"tf":1.0},"229":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"232":{"tf":1.0},"238":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.4142135623730951},"252":{"tf":1.0},"258":{"tf":1.0},"261":{"tf":1.0},"263":{"tf":1.0},"264":{"tf":2.0},"265":{"tf":1.0},"272":{"tf":1.7320508075688772},"276":{"tf":1.0},"278":{"tf":1.0},"279":{"tf":1.0},"280":{"tf":1.0},"281":{"tf":1.4142135623730951},"301":{"tf":1.4142135623730951},"307":{"tf":1.0},"308":{"tf":1.4142135623730951},"309":{"tf":1.0},"310":{"tf":1.4142135623730951},"311":{"tf":1.4142135623730951},"312":{"tf":1.0},"313":{"tf":1.0},"64":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"104":{"tf":1.4142135623730951},"12":{"tf":2.0},"123":{"tf":1.0},"177":{"tf":1.0},"198":{"tf":2.0},"201":{"tf":1.0},"212":{"tf":1.4142135623730951},"77":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}}},"h":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"198":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"t":{"df":4,"docs":{"162":{"tf":1.0},"164":{"tf":1.0},"192":{"tf":1.0},"237":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"124":{"tf":1.0},"190":{"tf":2.449489742783178},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"296":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":8,"docs":{"105":{"tf":1.0},"123":{"tf":1.0},"136":{"tf":1.0},"190":{"tf":1.0},"218":{"tf":1.0},"238":{"tf":1.0},"43":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.0},"138":{"tf":1.0},"178":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0},"66":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"b":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}},"c":{"df":1,"docs":{"271":{"tf":1.0}}},"d":{"df":4,"docs":{"301":{"tf":1.0},"310":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":1.4142135623730951}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":11,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":54,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"135":{"tf":1.0},"143":{"tf":1.0},"15":{"tf":1.0},"170":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":2.23606797749979},"199":{"tf":2.23606797749979},"200":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"25":{"tf":1.0},"272":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":2.23606797749979},"294":{"tf":1.7320508075688772},"295":{"tf":2.6457513110645907},"297":{"tf":1.0},"299":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":2.449489742783178},"4":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"253":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"308":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"135":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"135":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"267":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"238":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"272":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"238":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"308":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"238":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"271":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"111":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"205":{"tf":1.7320508075688772},"23":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"238":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"238":{"tf":2.449489742783178},"266":{"tf":1.0},"314":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"313":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"242":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"r":{"_":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"197":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":2.23606797749979},"171":{"tf":1.0},"177":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"197":{"tf":1.0}}}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"171":{"tf":2.0},"172":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"128":{"tf":1.0},"178":{"tf":1.0},"237":{"tf":1.0},"291":{"tf":1.0},"293":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"312":{"tf":1.0},"59":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"211":{"tf":1.0}}}}}}}}}}},"df":2,"docs":{"211":{"tf":1.4142135623730951},"237":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"261":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"259":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"=":{"c":{":":{"\\":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"264":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"260":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":12,"docs":{"137":{"tf":1.0},"140":{"tf":1.0},"254":{"tf":1.7320508075688772},"255":{"tf":1.0},"256":{"tf":1.0},"259":{"tf":1.4142135623730951},"263":{"tf":1.4142135623730951},"264":{"tf":1.0},"265":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}}}},"i":{"df":3,"docs":{"262":{"tf":1.4142135623730951},"263":{"tf":1.0},"313":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"269":{"tf":1.0},"272":{"tf":1.4142135623730951}}}}}}}}}}},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":2.0}}},"y":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"269":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"0":{"tf":2.0},"106":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"199":{"tf":1.0},"204":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"234":{"tf":1.0},"235":{"tf":1.7320508075688772},"236":{"tf":1.4142135623730951},"237":{"tf":1.0},"285":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"295":{"tf":2.6457513110645907},"30":{"tf":1.0},"85":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"139":{"tf":1.4142135623730951},"293":{"tf":1.0},"52":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"292":{"tf":1.0}}}}},"r":{"df":3,"docs":{"292":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"23":{"tf":2.449489742783178},"30":{"tf":1.0}}}},"df":12,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"115":{"tf":1.0},"132":{"tf":1.4142135623730951},"217":{"tf":1.0},"219":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"264":{"tf":1.0},"299":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"245":{"tf":1.0},"258":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"8":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"&":{"[":{"0":{"df":1,"docs":{"46":{"tf":1.0}}},"5":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"143":{"tf":1.4142135623730951},"224":{"tf":1.0},"85":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"285":{"tf":1.0},"291":{"tf":1.0},"292":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":1.0},"139":{"tf":1.7320508075688772},"187":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":3.1622776601683795},"30":{"tf":1.7320508075688772},"49":{"tf":1.0},"52":{"tf":2.449489742783178},"55":{"tf":1.7320508075688772},"59":{"tf":2.0},"87":{"tf":2.23606797749979},"88":{"tf":2.449489742783178},"89":{"tf":4.123105625617661},"90":{"tf":1.7320508075688772}},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}}}}}}},":":{":":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"46":{"tf":2.0},"49":{"tf":2.449489742783178},"55":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"89":{"tf":1.0}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"139":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"233":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"b":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":63,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"123":{"tf":1.0},"128":{"tf":1.4142135623730951},"13":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.4142135623730951},"19":{"tf":1.0},"190":{"tf":1.0},"2":{"tf":1.0},"206":{"tf":1.0},"216":{"tf":1.0},"219":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"272":{"tf":1.0},"276":{"tf":1.4142135623730951},"288":{"tf":1.0},"289":{"tf":1.0},"29":{"tf":1.0},"291":{"tf":1.0},"293":{"tf":1.4142135623730951},"299":{"tf":1.7320508075688772},"31":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.7320508075688772},"77":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"297":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"235":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"30":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"174":{"tf":1.0},"178":{"tf":1.0},"269":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"193":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"30":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"134":{"tf":1.0},"140":{"tf":1.0},"177":{"tf":1.0},"246":{"tf":1.0},"285":{"tf":1.0},"287":{"tf":1.0},"290":{"tf":1.0},"81":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"240":{"tf":1.0},"312":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"216":{"tf":2.0},"23":{"tf":1.0},"303":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"276":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"238":{"tf":1.0},"278":{"tf":1.0},"66":{"tf":1.0}},"j":{"df":2,"docs":{"75":{"tf":1.0},"84":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"140":{"tf":1.0},"299":{"tf":1.4142135623730951},"72":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"313":{"tf":1.0}}},"t":{"df":7,"docs":{"12":{"tf":1.0},"128":{"tf":1.0},"205":{"tf":1.0},"250":{"tf":1.0},"57":{"tf":1.4142135623730951},"76":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":51,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"132":{"tf":1.4142135623730951},"135":{"tf":2.0},"138":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.0},"219":{"tf":1.0},"22":{"tf":1.0},"238":{"tf":1.0},"239":{"tf":1.0},"24":{"tf":1.0},"242":{"tf":1.0},"250":{"tf":1.0},"26":{"tf":1.0},"271":{"tf":1.0},"272":{"tf":2.0},"278":{"tf":1.0},"285":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.4142135623730951},"299":{"tf":1.0},"308":{"tf":1.4142135623730951},"309":{"tf":1.4142135623730951},"31":{"tf":1.0},"313":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"t":{"df":5,"docs":{"10":{"tf":1.0},"232":{"tf":1.0},"297":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"x":{"df":2,"docs":{"36":{"tf":3.7416573867739413},"59":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}}},"c":{"df":1,"docs":{"298":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":2.449489742783178},"285":{"tf":1.0},"286":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"195":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"238":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":27,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"188":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"201":{"tf":1.0},"217":{"tf":1.4142135623730951},"220":{"tf":1.0},"244":{"tf":1.0},"247":{"tf":1.0},"252":{"tf":1.4142135623730951},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.0},"259":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.0},"278":{"tf":1.0},"310":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.0},"76":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"196":{"tf":1.0},"197":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"39":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"314":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"193":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"210":{"tf":1.0},"288":{"tf":1.0},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"135":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"198":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"25":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"89":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"'":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"`":{"1":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"156":{"tf":1.0},"159":{"tf":1.0}}}}},"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"215":{"tf":1.0}}},"z":{"df":1,"docs":{"215":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"214":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"144":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"153":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"147":{"tf":1.0}}}}}},"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"[":{"0":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":4,"docs":{"167":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"173":{"tf":1.0},"180":{"tf":1.4142135623730951}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"153":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":3,"docs":{"144":{"tf":1.0},"186":{"tf":1.4142135623730951},"212":{"tf":1.0}}}},"df":6,"docs":{"198":{"tf":1.0},"199":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":2.0}}}}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"1":{"(":{"&":{"\"":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"(":{"&":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"!":{"(":{"\"":{"1":{"df":2,"docs":{"18":{"tf":1.0},"8":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"d":{"c":{"1":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":2.0}}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"18":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"18":{"tf":1.0}}}}},"p":{"c":{"1":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":2.0}}},"2":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"a":{"df":1,"docs":{"198":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"198":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"3":{"2":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"198":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":7,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"46":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":33,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"140":{"tf":1.0},"154":{"tf":1.0},"18":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.0},"195":{"tf":2.23606797749979},"196":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.7320508075688772},"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.7320508075688772},"292":{"tf":3.4641016151377544},"293":{"tf":2.0},"294":{"tf":1.4142135623730951},"295":{"tf":2.23606797749979},"35":{"tf":2.6457513110645907},"40":{"tf":2.0},"6":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"91":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"191":{"tf":1.0},"311":{"tf":1.0},"89":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"193":{"tf":1.0},"205":{"tf":1.0}}},"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":10,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"142":{"tf":1.0},"191":{"tf":1.4142135623730951},"205":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.4142135623730951},"290":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"76":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":15,"docs":{"1":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"16":{"tf":2.23606797749979},"177":{"tf":1.7320508075688772},"194":{"tf":1.0},"232":{"tf":1.0},"262":{"tf":1.0},"274":{"tf":1.0},"295":{"tf":1.4142135623730951},"300":{"tf":1.0},"308":{"tf":1.0},"52":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"'":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"16":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{";":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":8,"docs":{"130":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"184":{"tf":1.0},"210":{"tf":1.4142135623730951},"219":{"tf":1.4142135623730951},"30":{"tf":1.0},"52":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"c":{"(":{"7":{"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"2":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"o":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"2":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"0":{".":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"2":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"1":{"1":{"0":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"5":{".":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":6,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":2.23606797749979},"42":{"tf":1.0},"43":{"tf":3.3166247903554},"55":{"tf":2.23606797749979}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"238":{"tf":1.0},"262":{"tf":1.0},"64":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"274":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.0},"130":{"tf":1.0},"188":{"tf":1.0},"254":{"tf":1.0},"270":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"72":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":7,"docs":{"161":{"tf":1.4142135623730951},"194":{"tf":1.0},"195":{"tf":1.0},"292":{"tf":1.0},"296":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":32,"docs":{"12":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"151":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"168":{"tf":1.0},"177":{"tf":1.0},"187":{"tf":1.7320508075688772},"192":{"tf":1.0},"195":{"tf":1.0},"198":{"tf":1.0},"212":{"tf":1.0},"218":{"tf":1.0},"233":{"tf":1.0},"249":{"tf":1.4142135623730951},"28":{"tf":1.0},"288":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.0},"296":{"tf":1.4142135623730951},"297":{"tf":1.7320508075688772},"298":{"tf":1.0},"299":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"y":{"df":1,"docs":{"299":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"219":{"tf":1.4142135623730951},"30":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"289":{"tf":1.4142135623730951}}},"i":{"df":9,"docs":{"130":{"tf":1.0},"145":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.0},"184":{"tf":1.0},"224":{"tf":1.0},"292":{"tf":1.0},"36":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"146":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"10":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"h":{"6":{"3":{"3":{"7":{"1":{"8":{"d":{"a":{"d":{"3":{"5":{"9":{"5":{"5":{"9":{"a":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"72":{"tf":1.0},"9":{"tf":1.0}}},"g":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"198":{"tf":1.0},"304":{"tf":1.0},"312":{"tf":1.0},"8":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"123":{"tf":1.0},"196":{"tf":1.7320508075688772},"23":{"tf":1.0},"259":{"tf":1.0},"272":{"tf":1.0},"289":{"tf":1.0},"309":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"192":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":6,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"23":{"tf":1.0},"290":{"tf":1.0},"50":{"tf":1.0},"96":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":4,"docs":{"14":{"tf":2.0},"15":{"tf":2.0},"16":{"tf":2.449489742783178},"288":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"]":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"297":{"tf":1.0}}}}},"v":{"df":2,"docs":{"269":{"tf":1.0},"272":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"266":{"tf":1.7320508075688772},"269":{"tf":1.0},"270":{"tf":1.0},"272":{"tf":2.23606797749979}},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"272":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"293":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"278":{"tf":1.0},"310":{"tf":1.0},"313":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}},"e":{"=":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":50,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"225":{"tf":2.0},"238":{"tf":1.4142135623730951},"239":{"tf":1.0},"243":{"tf":1.0},"249":{"tf":1.4142135623730951},"250":{"tf":1.0},"256":{"tf":1.0},"263":{"tf":1.0},"27":{"tf":1.0},"271":{"tf":1.0},"281":{"tf":1.0},"286":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"300":{"tf":2.449489742783178},"301":{"tf":1.0},"302":{"tf":1.0},"304":{"tf":2.23606797749979},"305":{"tf":1.0},"308":{"tf":2.0},"309":{"tf":1.4142135623730951},"310":{"tf":1.0},"311":{"tf":1.4142135623730951},"312":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":5,"docs":{"202":{"tf":1.0},"250":{"tf":1.0},"304":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"48":{"tf":1.0}}}}}}},"j":{"df":8,"docs":{"27":{"tf":1.0},"301":{"tf":1.0},"303":{"tf":1.7320508075688772},"32":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"4":{":":{"5":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"b":{"df":14,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"308":{"tf":1.0},"310":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":2.8284271247461903},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"132":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":23,"docs":{"177":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.0},"249":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":2.6457513110645907},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":2.23606797749979},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"(":{"&":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"(":{"&":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"b":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"(":{"&":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"140":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}},"x":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"&":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"63":{"tf":1.0},"68":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"0":{"tf":1.0},"195":{"tf":1.0},"289":{"tf":1.0}}}}},"l":{"df":2,"docs":{"263":{"tf":1.0},"265":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":31,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"160":{"tf":1.0},"193":{"tf":1.0},"207":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"242":{"tf":1.0},"25":{"tf":1.0},"269":{"tf":1.0},"271":{"tf":1.0},"272":{"tf":1.0},"287":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.4142135623730951},"297":{"tf":1.0},"299":{"tf":1.0},"302":{"tf":1.4142135623730951},"65":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":2.0},"9":{"tf":1.0},"94":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":11,"docs":{"125":{"tf":1.0},"127":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0},"19":{"tf":1.0},"209":{"tf":1.0},"245":{"tf":1.0},"258":{"tf":1.0},"270":{"tf":1.0},"299":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"d":{".":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.0},"219":{"tf":1.0},"223":{"tf":1.0}}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"t":{"a":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"2":{"5":{"5":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":16,"docs":{"12":{"tf":1.7320508075688772},"194":{"tf":1.0},"219":{"tf":1.0},"23":{"tf":1.0},"266":{"tf":1.4142135623730951},"268":{"tf":1.0},"272":{"tf":1.4142135623730951},"293":{"tf":1.0},"297":{"tf":1.0},"36":{"tf":2.23606797749979},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"204":{"tf":1.7320508075688772},"300":{"tf":1.0}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"0":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"204":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":10,"docs":{"114":{"tf":1.0},"138":{"tf":1.0},"204":{"tf":1.4142135623730951},"225":{"tf":1.0},"23":{"tf":1.4142135623730951},"274":{"tf":1.0},"284":{"tf":1.0},"30":{"tf":1.4142135623730951},"313":{"tf":1.0},"75":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"(":{"\"":{"%":{"df":0,"docs":{},"h":{":":{"%":{"df":0,"docs":{},"m":{":":{"%":{"df":0,"docs":{},"s":{"\"":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"y":{"df":1,"docs":{"278":{"tf":1.4142135623730951}}}},"c":{"1":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.0}}},"2":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"233":{"tf":1.0},"285":{"tf":1.0},"86":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":5,"docs":{"139":{"tf":1.7320508075688772},"293":{"tf":1.4142135623730951},"66":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":8,"docs":{"124":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"257":{"tf":1.4142135623730951},"261":{"tf":1.4142135623730951},"36":{"tf":1.0}},"g":{"df":1,"docs":{"132":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"244":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"314":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"198":{"tf":1.0},"206":{"tf":1.0},"295":{"tf":1.7320508075688772},"82":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":2,"docs":{"292":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"284":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":30,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":2.0},"121":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"140":{"tf":1.0},"190":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"198":{"tf":2.23606797749979},"205":{"tf":1.4142135623730951},"216":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"244":{"tf":1.0},"252":{"tf":1.0},"259":{"tf":1.4142135623730951},"264":{"tf":2.0},"276":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.0},"76":{"tf":1.7320508075688772},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":1.4142135623730951},"193":{"tf":1.0},"198":{"tf":1.7320508075688772},"208":{"tf":1.4142135623730951},"22":{"tf":1.0},"220":{"tf":1.0},"231":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"306":{"tf":1.0},"312":{"tf":1.7320508075688772},"4":{"tf":1.0},"8":{"tf":1.7320508075688772},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"118":{"tf":1.0},"198":{"tf":1.0},"219":{"tf":1.7320508075688772},"223":{"tf":1.4142135623730951},"233":{"tf":1.0},"293":{"tf":1.0},"304":{"tf":1.0},"312":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":2.0}},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"196":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"h":{"df":0,"docs":{},"i":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":9,"docs":{"23":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":3,"docs":{"252":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":21,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"135":{"tf":1.0},"171":{"tf":1.0},"20":{"tf":1.4142135623730951},"217":{"tf":1.0},"228":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"58":{"tf":1.0},"77":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":13,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"119":{"tf":1.0},"12":{"tf":2.0},"120":{"tf":1.0},"128":{"tf":1.0},"75":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"296":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"298":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":4,"docs":{"203":{"tf":1.4142135623730951},"235":{"tf":1.7320508075688772},"236":{"tf":1.0},"298":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"298":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"100":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"206":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"100":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"200":{"tf":1.0},"295":{"tf":1.0},"299":{"tf":2.0},"312":{"tf":1.0},"314":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"216":{"tf":2.0},"299":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"194":{"tf":1.0},"299":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"100":{"tf":2.449489742783178},"102":{"tf":1.0},"46":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":9,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"284":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.4142135623730951},"314":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":3,"docs":{"221":{"tf":1.0},"285":{"tf":1.0},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"190":{"tf":1.0},"290":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"278":{"tf":1.0},"285":{"tf":1.0},"291":{"tf":1.0},"297":{"tf":1.0},"310":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"139":{"tf":1.4142135623730951},"218":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"109":{"tf":1.0},"171":{"tf":1.0},"194":{"tf":1.0}}}}}}}},"v":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"242":{"tf":1.4142135623730951},"244":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":20,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"238":{"tf":1.0},"27":{"tf":1.0},"274":{"tf":1.0},"278":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0}}}}}},"i":{"c":{"df":1,"docs":{"256":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"257":{"tf":1.0},"261":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"312":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"11":{"tf":1.0},"111":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"151":{"tf":1.0},"177":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"198":{"tf":1.0},"204":{"tf":1.0},"212":{"tf":1.0},"232":{"tf":2.0},"233":{"tf":1.0},"243":{"tf":1.0},"289":{"tf":1.0},"291":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"72":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"288":{"tf":1.0}}},"r":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"132":{"tf":1.0},"272":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"196":{"tf":1.0},"297":{"tf":1.0},"298":{"tf":1.0},"62":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"104":{"tf":1.0},"140":{"tf":1.0},"18":{"tf":1.0},"198":{"tf":1.0},"205":{"tf":1.0},"207":{"tf":1.0},"292":{"tf":1.0},"294":{"tf":1.0},"297":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"118":{"tf":1.0},"130":{"tf":1.0},"270":{"tf":1.0},"301":{"tf":1.0},"305":{"tf":1.0},"307":{"tf":1.0},"310":{"tf":1.0},"312":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"16":{"tf":1.0},"223":{"tf":1.4142135623730951},"257":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"285":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"289":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"295":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"14":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":3,"docs":{"23":{"tf":1.0},"30":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772}},"e":{"df":2,"docs":{"284":{"tf":1.0},"295":{"tf":1.0}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"212":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"308":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"216":{"tf":2.8284271247461903}},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"300":{"tf":1.0},"304":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{")":{".":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"\"":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}},"t":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"30":{"tf":3.4641016151377544}}},"df":1,"docs":{"30":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"'":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"'":{"a":{"d":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"35":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"300":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}}},"df":43,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"171":{"tf":1.0},"178":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"23":{"tf":3.3166247903554},"231":{"tf":1.0},"237":{"tf":1.0},"272":{"tf":1.0},"274":{"tf":1.0},"30":{"tf":2.6457513110645907},"300":{"tf":1.4142135623730951},"304":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":2.6457513110645907},"66":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":5,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"104":{"tf":1.0},"294":{"tf":1.0},"299":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":18,"docs":{"10":{"tf":1.0},"130":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"190":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"271":{"tf":1.0},"288":{"tf":1.0},"297":{"tf":1.4142135623730951},"30":{"tf":1.0},"300":{"tf":1.0},"303":{"tf":1.0},"311":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":9,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"196":{"tf":1.0},"20":{"tf":1.0},"234":{"tf":1.0},"32":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":20,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"111":{"tf":1.0},"129":{"tf":1.0},"168":{"tf":1.0},"174":{"tf":1.0},"195":{"tf":1.0},"197":{"tf":1.0},"207":{"tf":1.0},"233":{"tf":1.0},"298":{"tf":1.4142135623730951},"300":{"tf":1.0},"312":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":11,"docs":{"212":{"tf":1.0},"23":{"tf":1.0},"272":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":1.4142135623730951},"96":{"tf":1.0},"98":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"212":{"tf":1.7320508075688772}}}}}}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"195":{"tf":1.0},"288":{"tf":1.0},"292":{"tf":1.0},"295":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"264":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"31":{"tf":1.0},"33":{"tf":2.23606797749979},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"290":{"tf":1.0},"39":{"tf":1.0},"89":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"23":{"tf":1.7320508075688772},"290":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772}}}}},"u":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"205":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"112":{"tf":1.0},"205":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"k":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"205":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"205":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"df":8,"docs":{"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"194":{"tf":1.0},"205":{"tf":2.23606797749979},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"217":{"tf":1.0},"269":{"tf":1.0},"299":{"tf":1.0},"309":{"tf":1.0},"66":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"303":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"289":{"tf":1.0},"297":{"tf":1.0},"311":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"2":{"d":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"2":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"m":{"df":7,"docs":{"193":{"tf":1.0},"196":{"tf":1.7320508075688772},"205":{"tf":1.0},"207":{"tf":1.0},"237":{"tf":1.0},"289":{"tf":1.4142135623730951},"293":{"tf":1.0}}}},"df":3,"docs":{"299":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"130":{"tf":1.0},"204":{"tf":1.0},"270":{"tf":1.0},"271":{"tf":1.0},"312":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":21,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"198":{"tf":1.0},"229":{"tf":1.0},"23":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"254":{"tf":1.0},"256":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.0},"295":{"tf":1.0},"308":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"272":{"tf":1.0},"295":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"286":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"225":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"0":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0}}}}}}}}}},"d":{"df":1,"docs":{"285":{"tf":1.0}},"g":{"df":1,"docs":{"137":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"303":{"tf":1.0}}}}}}},"df":3,"docs":{"187":{"tf":1.0},"46":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"194":{"tf":1.0},"221":{"tf":1.0},"299":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"140":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"123":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"200":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"235":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":19,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"200":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"235":{"tf":1.7320508075688772},"297":{"tf":1.0},"30":{"tf":2.23606797749979},"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"72":{"tf":1.0},"96":{"tf":2.0}}}}}}},"i":{"d":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"195":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"113":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":2,"docs":{"269":{"tf":1.0},"272":{"tf":1.4142135623730951}}}}}}},"df":8,"docs":{"118":{"tf":1.0},"123":{"tf":1.0},"134":{"tf":1.0},"168":{"tf":1.0},"217":{"tf":1.0},"285":{"tf":1.0},"299":{"tf":1.0},"311":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"0":{"tf":1.0},"195":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"171":{"tf":1.0},"309":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"136":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":29,"docs":{"105":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.0},"187":{"tf":1.0},"20":{"tf":1.0},"219":{"tf":1.0},"229":{"tf":1.7320508075688772},"231":{"tf":1.7320508075688772},"232":{"tf":1.0},"256":{"tf":1.0},"267":{"tf":1.7320508075688772},"27":{"tf":1.0},"305":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.7320508075688772},"311":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"171":{"tf":1.0},"177":{"tf":1.4142135623730951},"195":{"tf":1.0},"292":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"187":{"tf":1.4142135623730951},"311":{"tf":1.0},"91":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"276":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"130":{"tf":1.0},"188":{"tf":1.0},"190":{"tf":1.0},"202":{"tf":1.0},"232":{"tf":1.0},"25":{"tf":1.4142135623730951},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"297":{"tf":1.4142135623730951},"302":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"195":{"tf":1.0},"66":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"285":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"139":{"tf":1.0},"23":{"tf":1.0},"293":{"tf":1.0},"298":{"tf":1.0},"30":{"tf":1.0},"312":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"296":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"195":{"tf":1.0},"276":{"tf":1.0},"30":{"tf":1.0},"304":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"21":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"143":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"299":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"189":{"tf":1.0},"209":{"tf":1.0}}}}}},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"311":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":14,"docs":{"10":{"tf":1.0},"225":{"tf":1.0},"238":{"tf":1.0},"252":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"270":{"tf":1.0},"300":{"tf":1.0},"311":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"86":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"=":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.0},"196":{"tf":1.0},"219":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"235":{"tf":1.0},"304":{"tf":1.0}}}}}}},"r":{"(":{"_":{"df":1,"docs":{"59":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"187":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"187":{"tf":1.0},"190":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}},"r":{"(":{"\"":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"'":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":13,"docs":{"124":{"tf":1.0},"134":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"187":{"tf":1.0},"218":{"tf":1.7320508075688772},"220":{"tf":1.0},"244":{"tf":1.4142135623730951},"281":{"tf":1.0},"43":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}}}}},"s":{"6":{"df":3,"docs":{"10":{"tf":1.0},"215":{"tf":1.0},"72":{"tf":1.0}}},"df":18,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"137":{"tf":1.0},"195":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"285":{"tf":2.0},"289":{"tf":1.0},"292":{"tf":1.0},"43":{"tf":1.4142135623730951},"57":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"223":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"75":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"118":{"tf":1.0},"151":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"27":{"tf":1.0},"285":{"tf":1.7320508075688772},"291":{"tf":1.0},"300":{"tf":1.0},"314":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"v":{".":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}},"u":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}}},"df":2,"docs":{"16":{"tf":1.4142135623730951},"49":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"o":{"d":{"d":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":11,"docs":{"0":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"293":{"tf":1.0},"59":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0}},"t":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":2.0}}}},"df":0,"docs":{}}}}}}}},"df":11,"docs":{"40":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":2.6457513110645907},"54":{"tf":1.0},"55":{"tf":2.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"10":{"tf":1.0},"194":{"tf":1.4142135623730951},"52":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"177":{"tf":1.0},"23":{"tf":1.0},"285":{"tf":1.0},"295":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"194":{"tf":1.0},"202":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":127,"docs":{"0":{"tf":1.0},"1":{"tf":2.8284271247461903},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":2.0},"104":{"tf":2.0},"11":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"133":{"tf":1.7320508075688772},"135":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.7320508075688772},"140":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"149":{"tf":1.0},"15":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"170":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"19":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"198":{"tf":1.0},"199":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"201":{"tf":1.4142135623730951},"202":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"21":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":1.0},"238":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"256":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"262":{"tf":1.0},"272":{"tf":1.4142135623730951},"285":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.4142135623730951},"29":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.4142135623730951},"297":{"tf":1.0},"298":{"tf":1.0},"300":{"tf":1.0},"31":{"tf":1.0},"313":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"2":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"[":{"5":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"131":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":15,"docs":{"130":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"177":{"tf":1.0},"187":{"tf":1.7320508075688772},"190":{"tf":2.23606797749979},"214":{"tf":1.0},"23":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.0},"298":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"285":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":18,"docs":{"139":{"tf":1.0},"190":{"tf":1.0},"194":{"tf":1.0},"217":{"tf":2.6457513110645907},"218":{"tf":1.0},"244":{"tf":1.0},"249":{"tf":1.0},"261":{"tf":1.4142135623730951},"270":{"tf":1.0},"288":{"tf":1.0},"299":{"tf":2.23606797749979},"300":{"tf":1.0},"301":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"188":{"tf":1.0},"308":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.0},"109":{"tf":1.4142135623730951},"205":{"tf":1.0},"21":{"tf":1.0},"225":{"tf":1.0},"286":{"tf":1.0},"293":{"tf":1.0},"30":{"tf":1.0},"300":{"tf":1.0},"303":{"tf":1.0},"312":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":2.0}}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"207":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"#":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"59":{"tf":2.0}}},"df":0,"docs":{}}}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"59":{"tf":2.0}}},"df":0,"docs":{}}}}}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"a":{"d":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"23":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"132":{"tf":1.0},"137":{"tf":1.0},"204":{"tf":1.0},"207":{"tf":1.0},"220":{"tf":1.4142135623730951},"23":{"tf":1.0},"285":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"i":{"df":3,"docs":{"250":{"tf":1.0},"266":{"tf":1.0},"6":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"140":{"tf":1.0},"208":{"tf":1.0},"239":{"tf":1.0},"266":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"291":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"139":{"tf":1.0},"240":{"tf":1.0},"92":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"139":{"tf":1.4142135623730951},"193":{"tf":1.0},"220":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":1.0},"238":{"tf":1.0},"87":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":54,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"136":{"tf":1.0},"140":{"tf":1.4142135623730951},"145":{"tf":1.0},"151":{"tf":1.0},"18":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":2.449489742783178},"198":{"tf":1.4142135623730951},"2":{"tf":1.0},"207":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.7320508075688772},"214":{"tf":1.0},"216":{"tf":1.4142135623730951},"219":{"tf":2.0},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.4142135623730951},"224":{"tf":1.0},"279":{"tf":1.0},"285":{"tf":1.4142135623730951},"286":{"tf":1.0},"288":{"tf":2.23606797749979},"289":{"tf":1.7320508075688772},"292":{"tf":2.8284271247461903},"293":{"tf":1.7320508075688772},"294":{"tf":2.0},"295":{"tf":2.8284271247461903},"297":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.7320508075688772}},"e":{"d":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"146":{"tf":2.449489742783178},"147":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":2,"docs":{"146":{"tf":1.0},"147":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":7,"docs":{"215":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"286":{"tf":1.0},"293":{"tf":1.4142135623730951},"308":{"tf":1.0},"66":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"285":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"192":{"tf":2.23606797749979},"203":{"tf":1.4142135623730951},"211":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":48,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"135":{"tf":1.0},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":2.23606797749979},"199":{"tf":2.23606797749979},"200":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"25":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":2.0},"294":{"tf":1.7320508075688772},"295":{"tf":2.6457513110645907},"299":{"tf":1.0},"30":{"tf":1.7320508075688772},"308":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"91":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"140":{"tf":1.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"272":{"tf":1.0}}}},"df":5,"docs":{"130":{"tf":1.0},"187":{"tf":1.0},"293":{"tf":1.0},"297":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}}},"y":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"f":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"1":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"3":{"2":{"df":7,"docs":{"100":{"tf":1.0},"160":{"tf":1.4142135623730951},"164":{"tf":2.0},"181":{"tf":1.0},"285":{"tf":1.0},"39":{"tf":2.8284271247461903},"43":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":18,"docs":{"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"199":{"tf":2.449489742783178},"204":{"tf":1.0},"25":{"tf":1.0},"285":{"tf":1.0},"297":{"tf":1.0},"30":{"tf":1.4142135623730951},"300":{"tf":1.0},"36":{"tf":2.6457513110645907},"55":{"tf":2.8284271247461903},"89":{"tf":1.7320508075688772},"91":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"105":{"tf":1.0},"112":{"tf":1.0},"217":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":2.23606797749979},"257":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0},"92":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"244":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"256":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"208":{"tf":1.0}}},"s":{"df":18,"docs":{"140":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.0},"264":{"tf":1.0},"27":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":1,"docs":{"168":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"289":{"tf":1.0}}}},"df":1,"docs":{"298":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"294":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":4,"docs":{"194":{"tf":1.0},"284":{"tf":1.0},"293":{"tf":1.4142135623730951},"294":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"194":{"tf":1.0},"205":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"104":{"tf":1.0},"231":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.0}}}}}}}},"df":6,"docs":{"115":{"tf":1.0},"198":{"tf":1.0},"210":{"tf":1.0},"52":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":33,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"140":{"tf":2.0},"195":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"219":{"tf":1.4142135623730951},"22":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":2.449489742783178},"231":{"tf":2.6457513110645907},"232":{"tf":1.0},"267":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"271":{"tf":1.7320508075688772},"285":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"308":{"tf":2.8284271247461903},"309":{"tf":2.23606797749979},"310":{"tf":1.0},"32":{"tf":1.4142135623730951},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"82":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"=":{"+":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{",":{"+":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"64":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"140":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"217":{"tf":1.0},"284":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":1.0},"66":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"(":{"\"":{".":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":5,"docs":{"12":{"tf":2.0},"232":{"tf":1.0},"249":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"df":14,"docs":{"11":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"217":{"tf":1.0},"233":{"tf":1.0},"234":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"291":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"194":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"297":{"tf":1.0}}}},"i":{"df":1,"docs":{"272":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"d":{"\"":{":":{"4":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"'":{"df":1,"docs":{"220":{"tf":1.0}}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"1":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{"df":2,"docs":{"101":{"tf":1.0},"104":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":4,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.4142135623730951}}},"2":{"df":4,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0}}},"3":{"df":4,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0}}},"df":11,"docs":{"145":{"tf":1.4142135623730951},"16":{"tf":1.0},"214":{"tf":2.0},"215":{"tf":2.23606797749979},"220":{"tf":2.6457513110645907},"221":{"tf":2.23606797749979},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.4142135623730951},"292":{"tf":1.0},"59":{"tf":2.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"130":{"tf":1.0},"272":{"tf":1.0},"288":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{")":{"/":{"$":{"(":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"#":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"\"":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"l":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"$":{"(":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":46,"docs":{"10":{"tf":2.0},"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":2.0},"131":{"tf":1.0},"132":{"tf":2.8284271247461903},"133":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"202":{"tf":1.4142135623730951},"216":{"tf":1.0},"219":{"tf":1.0},"223":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.0},"256":{"tf":1.0},"269":{"tf":1.0},"270":{"tf":1.4142135623730951},"272":{"tf":3.1622776601683795},"285":{"tf":3.1622776601683795},"287":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"299":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":1.0},"305":{"tf":1.0},"306":{"tf":1.0},"307":{"tf":1.0},"308":{"tf":1.0},"312":{"tf":2.449489742783178},"43":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"264":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"[":{"0":{"df":1,"docs":{"272":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"45":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}}},"l":{"df":1,"docs":{"43":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"272":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":21,"docs":{"1":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":3.1622776601683795},"195":{"tf":1.0},"202":{"tf":1.4142135623730951},"205":{"tf":1.0},"237":{"tf":1.0},"288":{"tf":1.7320508075688772},"289":{"tf":1.0},"292":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{}}}}},"d":{"df":11,"docs":{"0":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"16":{"tf":1.4142135623730951},"217":{"tf":1.0},"229":{"tf":1.4142135623730951},"236":{"tf":1.0},"259":{"tf":1.0},"302":{"tf":1.0},"303":{"tf":1.0},"312":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"177":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"132":{"tf":1.0},"244":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"67":{"tf":1.0}}},"df":13,"docs":{"137":{"tf":1.0},"140":{"tf":1.0},"254":{"tf":1.7320508075688772},"255":{"tf":1.0},"256":{"tf":1.0},"259":{"tf":1.4142135623730951},"263":{"tf":1.4142135623730951},"264":{"tf":1.0},"265":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}}},"df":26,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.0},"168":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.7320508075688772},"200":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":2.0},"218":{"tf":1.0},"219":{"tf":1.0},"23":{"tf":1.0},"285":{"tf":1.0},"288":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.7320508075688772},"297":{"tf":1.4142135623730951},"312":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.0},"99":{"tf":1.0}},"t":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"160":{"tf":1.0}},"z":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"315":{"tf":1.0}}}}}}},"x":{"df":3,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"52":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":25,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"140":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"205":{"tf":1.0},"219":{"tf":1.0},"238":{"tf":1.0},"254":{"tf":1.4142135623730951},"255":{"tf":1.0},"257":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"292":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}},"p":{"df":1,"docs":{"113":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"t":{"3":{"2":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"[":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"]":{")":{"[":{"0":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"164":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"1":{"0":{"0":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"160":{"tf":1.0},"165":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"0":{".":{"8":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"5":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"40":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"c":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"37":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":2.6457513110645907}},"o":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"276":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{")":{">":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"299":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":95,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"135":{"tf":2.23606797749979},"140":{"tf":1.0},"143":{"tf":2.23606797749979},"146":{"tf":2.6457513110645907},"149":{"tf":1.7320508075688772},"15":{"tf":2.449489742783178},"152":{"tf":2.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"166":{"tf":2.0},"169":{"tf":2.0},"172":{"tf":1.4142135623730951},"175":{"tf":1.0},"179":{"tf":2.0},"18":{"tf":1.7320508075688772},"182":{"tf":1.4142135623730951},"185":{"tf":2.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"193":{"tf":2.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.7320508075688772},"197":{"tf":1.0},"198":{"tf":2.6457513110645907},"199":{"tf":2.6457513110645907},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"205":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.4142135623730951},"217":{"tf":1.0},"218":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"221":{"tf":1.7320508075688772},"223":{"tf":1.0},"23":{"tf":2.0},"230":{"tf":1.0},"243":{"tf":1.7320508075688772},"249":{"tf":1.0},"25":{"tf":1.7320508075688772},"28":{"tf":1.0},"286":{"tf":1.4142135623730951},"288":{"tf":1.7320508075688772},"289":{"tf":1.7320508075688772},"290":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":2.6457513110645907},"294":{"tf":2.0},"295":{"tf":4.358898943540674},"297":{"tf":1.4142135623730951},"298":{"tf":1.7320508075688772},"299":{"tf":1.7320508075688772},"30":{"tf":2.6457513110645907},"300":{"tf":1.0},"308":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":2.449489742783178},"39":{"tf":2.8284271247461903},"4":{"tf":1.4142135623730951},"43":{"tf":2.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"52":{"tf":2.23606797749979},"55":{"tf":1.0},"59":{"tf":2.449489742783178},"8":{"tf":2.6457513110645907},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":2.23606797749979},"89":{"tf":2.6457513110645907},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":2.6457513110645907},"92":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"23":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"46":{"tf":1.7320508075688772},"49":{"tf":2.23606797749979},"55":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"299":{"tf":1.0}}}}}},"df":5,"docs":{"23":{"tf":1.0},"233":{"tf":1.0},"52":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":22,"docs":{"10":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"216":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"238":{"tf":1.0},"245":{"tf":1.0},"252":{"tf":1.0},"259":{"tf":1.0},"270":{"tf":1.0},"285":{"tf":1.0},"303":{"tf":1.0},"308":{"tf":1.0},"312":{"tf":1.0},"314":{"tf":1.0},"59":{"tf":1.4142135623730951},"67":{"tf":1.0},"85":{"tf":1.0},"92":{"tf":1.0}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"213":{"tf":1.0}}}}}}},"a":{"df":2,"docs":{"288":{"tf":1.7320508075688772},"289":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"g":{"0":{"df":2,"docs":{"288":{"tf":1.4142135623730951},"289":{"tf":1.4142135623730951}}},"df":1,"docs":{"216":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}}}},".":{"_":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"215":{"tf":1.0}}}},"df":0,"docs":{}},"d":{".":{"df":0,"docs":{},"t":{"df":2,"docs":{"288":{"tf":1.0},"292":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"j":{"df":6,"docs":{"132":{"tf":1.0},"285":{"tf":1.4142135623730951},"287":{"tf":1.0},"288":{"tf":1.4142135623730951},"292":{"tf":1.0},"294":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"194":{"tf":1.7320508075688772},"195":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"r":{"df":2,"docs":{"288":{"tf":1.0},"289":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"196":{"tf":2.23606797749979}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"285":{"tf":1.0},"294":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"196":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"199":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":3,"docs":{"132":{"tf":1.0},"285":{"tf":1.4142135623730951},"288":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"293":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":21,"docs":{"143":{"tf":1.7320508075688772},"190":{"tf":1.0},"192":{"tf":2.8284271247461903},"194":{"tf":2.23606797749979},"196":{"tf":2.6457513110645907},"198":{"tf":2.0},"199":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"210":{"tf":2.6457513110645907},"212":{"tf":2.23606797749979},"213":{"tf":2.0},"214":{"tf":2.0},"215":{"tf":2.0},"224":{"tf":1.4142135623730951},"238":{"tf":1.0},"288":{"tf":2.0},"289":{"tf":1.4142135623730951},"293":{"tf":3.3166247903554},"297":{"tf":1.4142135623730951},"299":{"tf":1.0},"91":{"tf":2.0}}},"r":{"c":{"df":1,"docs":{"253":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"139":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"292":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"}":{"/":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"x":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"272":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"272":{"tf":1.0}}}}}}},"df":5,"docs":{"223":{"tf":1.0},"266":{"tf":1.0},"272":{"tf":1.0},"276":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951}}}},"df":1,"docs":{"76":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"104":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"295":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.0}}}},"df":10,"docs":{"1":{"tf":1.0},"193":{"tf":1.0},"225":{"tf":1.0},"237":{"tf":1.0},"256":{"tf":1.0},"289":{"tf":1.0},"308":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"b":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"52":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"301":{"tf":1.0}}}}}}}}},"df":1,"docs":{"46":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":14,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.4142135623730951},"217":{"tf":1.0},"223":{"tf":1.0},"284":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":2.0},"295":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":1.0}}},"q":{"df":1,"docs":{"39":{"tf":2.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":3.605551275463989}}},"df":0,"docs":{},"t":{"df":2,"docs":{"213":{"tf":1.0},"238":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"192":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"b":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"298":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"280":{"tf":1.0}}},"df":2,"docs":{"304":{"tf":1.0},"307":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":34,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"256":{"tf":1.0},"26":{"tf":1.0},"270":{"tf":1.0},"29":{"tf":1.0},"291":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":4,"docs":{"132":{"tf":1.0},"299":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"9":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"220":{"tf":1.0}}},"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"[":{"1":{"3":{"5":{"0":{"]":{":":{"1":{"2":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"]":{":":{"9":{"5":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"]":{":":{"4":{"4":{"4":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"]":{":":{"3":{"0":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"2":{"]":{":":{"3":{"3":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{":":{"2":{"9":{"1":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"1":{"]":{":":{"2":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"7":{"]":{":":{"5":{"7":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"]":{":":{"4":{"7":{"7":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":83,"docs":{"0":{"tf":2.0},"10":{"tf":2.6457513110645907},"101":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"112":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"135":{"tf":1.0},"136":{"tf":1.0},"140":{"tf":2.0},"16":{"tf":2.23606797749979},"18":{"tf":1.0},"187":{"tf":1.7320508075688772},"189":{"tf":1.0},"190":{"tf":2.449489742783178},"191":{"tf":1.0},"193":{"tf":2.6457513110645907},"194":{"tf":3.3166247903554},"195":{"tf":3.605551275463989},"196":{"tf":1.7320508075688772},"198":{"tf":1.7320508075688772},"199":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"200":{"tf":1.0},"204":{"tf":1.4142135623730951},"205":{"tf":2.0},"206":{"tf":1.0},"207":{"tf":3.0},"209":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.7320508075688772},"217":{"tf":2.8284271247461903},"218":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"229":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"231":{"tf":1.0},"232":{"tf":2.0},"249":{"tf":1.0},"250":{"tf":1.4142135623730951},"266":{"tf":1.0},"285":{"tf":1.7320508075688772},"286":{"tf":1.0},"288":{"tf":3.3166247903554},"289":{"tf":2.8284271247461903},"29":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":3.872983346207417},"293":{"tf":2.8284271247461903},"294":{"tf":3.0},"295":{"tf":4.242640687119285},"297":{"tf":1.7320508075688772},"298":{"tf":2.0},"299":{"tf":2.0},"300":{"tf":1.4142135623730951},"309":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":2.0},"91":{"tf":2.8284271247461903},"92":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"285":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"132":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"293":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"187":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":18,"docs":{"187":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"249":{"tf":2.23606797749979},"250":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"284":{"tf":1.0},"293":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"94":{"tf":2.23606797749979}},"e":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"g":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"(":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"140":{"tf":1.0},"39":{"tf":3.3166247903554}},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"131":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"p":{"df":1,"docs":{"93":{"tf":1.0}}},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"174":{"tf":1.0},"178":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"229":{"tf":1.0},"308":{"tf":1.0}}}}},"b":{"df":1,"docs":{"23":{"tf":1.0}}},"df":1,"docs":{"52":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"259":{"tf":1.4142135623730951},"264":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"c":{":":{"\\":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"264":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":69,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":2.0},"133":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"145":{"tf":1.7320508075688772},"188":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.7320508075688772},"194":{"tf":2.23606797749979},"195":{"tf":1.7320508075688772},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"205":{"tf":1.0},"207":{"tf":1.0},"210":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":2.0},"219":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":2.0},"224":{"tf":1.4142135623730951},"233":{"tf":1.0},"244":{"tf":1.0},"250":{"tf":1.0},"266":{"tf":1.4142135623730951},"268":{"tf":1.0},"269":{"tf":1.0},"272":{"tf":1.7320508075688772},"285":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":2.449489742783178},"289":{"tf":2.0},"290":{"tf":1.0},"291":{"tf":1.4142135623730951},"292":{"tf":1.7320508075688772},"293":{"tf":2.0},"294":{"tf":2.449489742783178},"295":{"tf":2.23606797749979},"297":{"tf":1.4142135623730951},"298":{"tf":1.0},"299":{"tf":2.449489742783178},"304":{"tf":1.0},"306":{"tf":1.0},"308":{"tf":1.4142135623730951},"309":{"tf":1.0},"312":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.7320508075688772},"92":{"tf":1.0}}}}},"o":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"30":{"tf":1.0}}},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"293":{"tf":1.0},"295":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"196":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"196":{"tf":1.0},"295":{"tf":1.0}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"210":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"(":{"\"":{"2":{"d":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"(":{"df":0,"docs":{},"z":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"103":{"tf":1.0},"195":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"297":{"tf":1.4142135623730951},"33":{"tf":1.0}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":2,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"292":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"294":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"224":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":12,"docs":{"111":{"tf":1.0},"13":{"tf":1.0},"193":{"tf":3.1622776601683795},"196":{"tf":1.0},"198":{"tf":1.0},"205":{"tf":1.0},"215":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"221":{"tf":1.0},"224":{"tf":1.4142135623730951},"295":{"tf":1.0},"308":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":2,"docs":{"145":{"tf":1.7320508075688772},"205":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"312":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"u":{"b":{":":{"d":{"a":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"d":{"a":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"26":{"tf":1.0},"265":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"10":{"tf":1.0},"207":{"tf":1.0},"235":{"tf":1.0},"299":{"tf":1.0},"63":{"tf":1.0}},"n":{"df":8,"docs":{"192":{"tf":1.0},"199":{"tf":1.0},"204":{"tf":1.0},"232":{"tf":1.4142135623730951},"293":{"tf":1.0},"66":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":2.23606797749979},"120":{"tf":1.4142135623730951},"201":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"30":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.0},"303":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.7320508075688772},"69":{"tf":1.0},"9":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"293":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"140":{"tf":1.4142135623730951},"188":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"240":{"tf":1.0},"285":{"tf":1.0},"287":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.0},"9":{"tf":1.0}}}},"df":14,"docs":{"128":{"tf":1.0},"132":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"294":{"tf":1.0},"295":{"tf":2.0},"296":{"tf":1.0},"297":{"tf":1.4142135623730951},"298":{"tf":1.0},"86":{"tf":1.0}},"e":{"df":1,"docs":{"289":{"tf":1.0}}},"n":{"df":0,"docs":{},"n":{"a":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":4,"docs":{"137":{"tf":1.0},"188":{"tf":1.0},"292":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"g":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"256":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"a":{"df":3,"docs":{"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"314":{"tf":1.0}}}}}}},"r":{"a":{"b":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"292":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"313":{"tf":1.0},"85":{"tf":1.0}}},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"'":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}}},"a":{"df":3,"docs":{"292":{"tf":1.7320508075688772},"294":{"tf":1.4142135623730951},"299":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"292":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.0},"286":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"12":{"tf":1.0},"292":{"tf":1.7320508075688772},"294":{"tf":2.8284271247461903},"5":{"tf":1.0}}}},"p":{"df":1,"docs":{"312":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":2,"docs":{"0":{"tf":1.0},"288":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"177":{"tf":1.0},"225":{"tf":1.0},"238":{"tf":1.0},"293":{"tf":1.0},"300":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"236":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"273":{"tf":1.0},"274":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":13,"docs":{"144":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"g":{"df":2,"docs":{"156":{"tf":1.0},"159":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"1":{">":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"273":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"177":{"tf":1.0},"289":{"tf":1.7320508075688772}}}},"n":{"d":{"df":5,"docs":{"187":{"tf":1.0},"23":{"tf":1.0},"300":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":1,"docs":{"10":{"tf":1.0}}},"l":{"df":20,"docs":{"10":{"tf":1.0},"123":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"174":{"tf":1.0},"187":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"245":{"tf":1.0},"258":{"tf":1.0},"29":{"tf":1.0},"291":{"tf":1.0},"299":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"196":{"tf":1.0},"23":{"tf":1.0},"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.4142135623730951},"291":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.7320508075688772},"295":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"239":{"tf":1.0}}},"s":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"200":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"101":{"tf":1.0},"104":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"298":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"92":{"tf":1.0}}}}},"df":1,"docs":{"30":{"tf":1.0}},"e":{"a":{"d":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"193":{"tf":1.0},"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"123":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"244":{"tf":1.0},"251":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":2.0},"256":{"tf":1.4142135623730951},"257":{"tf":1.7320508075688772},"258":{"tf":1.0},"259":{"tf":1.7320508075688772},"260":{"tf":1.0},"261":{"tf":2.449489742783178},"263":{"tf":1.4142135623730951},"265":{"tf":1.4142135623730951},"278":{"tf":1.7320508075688772},"310":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"289":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"289":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"140":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"289":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"140":{"tf":1.0},"288":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":2.6457513110645907}}}}}}},"df":10,"docs":{"140":{"tf":1.4142135623730951},"174":{"tf":1.0},"178":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.7320508075688772},"289":{"tf":2.0},"291":{"tf":1.0},"292":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":2.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"p":{"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.0},"288":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}}},"n":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"6":{"tf":1.0}}},"df":45,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"140":{"tf":1.0},"19":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":2.0},"195":{"tf":1.7320508075688772},"20":{"tf":1.0},"205":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"217":{"tf":1.4142135623730951},"22":{"tf":1.0},"226":{"tf":1.0},"23":{"tf":1.4142135623730951},"256":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"286":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":2.449489742783178},"289":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":2.0},"293":{"tf":2.449489742783178},"294":{"tf":1.7320508075688772},"295":{"tf":1.7320508075688772},"296":{"tf":1.0},"297":{"tf":1.0},"298":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"308":{"tf":1.0},"314":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"238":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":4,"docs":{"192":{"tf":1.4142135623730951},"234":{"tf":1.4142135623730951},"235":{"tf":1.0},"236":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}},"l":{"d":{"df":1,"docs":{"288":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"/":{".":{".":{".":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"244":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"d":{"df":4,"docs":{"14":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"288":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"292":{"tf":1.0},"65":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.0},"140":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"302":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"279":{"tf":1.0}}},"df":5,"docs":{"140":{"tf":1.0},"195":{"tf":1.0},"264":{"tf":1.0},"279":{"tf":1.0},"299":{"tf":1.0}}}}},"p":{"a":{"\"":{"]":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"236":{"tf":2.6457513110645907}}}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"32":{"tf":1.0},"42":{"tf":1.0},"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"272":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":2.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":2.23606797749979}}}}}}}}},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},":":{"/":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"/":{"2":{".":{"5":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"?":{"df":0,"docs":{},"q":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}},"s":{":":{"/":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"308":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"308":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"263":{"tf":1.0},"265":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"264":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"c":{"3":{"3":{"3":{"9":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"(":{"[":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{".":{"df":5,"docs":{"100":{"tf":1.0},"112":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"1":{"2":{"8":{"df":2,"docs":{"160":{"tf":1.7320508075688772},"163":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":3,"docs":{"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"181":{"tf":1.0}}},"df":0,"docs":{}},"3":{"2":{".":{"a":{"d":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":14,"docs":{"15":{"tf":1.7320508075688772},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"181":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.4142135623730951},"220":{"tf":2.449489742783178},"221":{"tf":2.0},"285":{"tf":1.0},"293":{"tf":2.6457513110645907},"295":{"tf":4.0},"43":{"tf":1.4142135623730951},"59":{"tf":2.0},"9":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"6":{"4":{"df":5,"docs":{"160":{"tf":1.4142135623730951},"163":{"tf":1.0},"181":{"tf":1.0},"285":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"160":{"tf":1.4142135623730951},"162":{"tf":1.7320508075688772},"181":{"tf":1.0}}},"<":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"207":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"207":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"=":{"0":{"df":1,"docs":{"207":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"c":{"df":1,"docs":{"49":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"d":{"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"\"":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"e":{"a":{"df":5,"docs":{"285":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.4142135623730951},"294":{"tf":1.0},"66":{"tf":1.4142135623730951}},"l":{"df":3,"docs":{"194":{"tf":1.0},"286":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"198":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"198":{"tf":2.449489742783178},"212":{"tf":1.4142135623730951},"288":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"286":{"tf":1.0}}}}},"l":{"df":1,"docs":{"280":{"tf":1.0}}},"x":{"0":{"df":2,"docs":{"288":{"tf":1.0},"289":{"tf":1.0}}},"df":4,"docs":{"16":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"289":{"tf":1.7320508075688772},"290":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"138":{"tf":1.7320508075688772}}},"f":{"df":0,"docs":{},"s":{"=":{"$":{"'":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"177":{"tf":1.0},"205":{"tf":1.0},"244":{"tf":1.0},"253":{"tf":1.0},"297":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"105":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"201":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"8":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"(":{"&":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"249":{"tf":1.0},"286":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"286":{"tf":1.0},"299":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.4142135623730951}},"l":{"df":24,"docs":{"15":{"tf":1.0},"192":{"tf":2.23606797749979},"203":{"tf":1.4142135623730951},"206":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"215":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"236":{"tf":2.449489742783178},"290":{"tf":1.0},"293":{"tf":2.0},"295":{"tf":1.7320508075688772},"297":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"59":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":34,"docs":{"100":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"113":{"tf":1.0},"137":{"tf":1.0},"145":{"tf":1.4142135623730951},"187":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.4142135623730951},"214":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":1.4142135623730951},"237":{"tf":1.0},"238":{"tf":1.0},"259":{"tf":1.0},"285":{"tf":1.0},"289":{"tf":1.0},"294":{"tf":1.0},"296":{"tf":1.0},"297":{"tf":1.4142135623730951},"298":{"tf":1.4142135623730951},"303":{"tf":1.0},"39":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"235":{"tf":1.4142135623730951},"295":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"'":{".":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"'":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"215":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"16":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}}},"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.0}}}}}}}}},"df":84,"docs":{"0":{"tf":1.0},"10":{"tf":2.449489742783178},"103":{"tf":1.0},"104":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"12":{"tf":1.0},"123":{"tf":2.0},"129":{"tf":1.0},"13":{"tf":1.7320508075688772},"132":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"167":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":2.8284271247461903},"195":{"tf":2.23606797749979},"197":{"tf":1.4142135623730951},"198":{"tf":2.0},"199":{"tf":1.0},"200":{"tf":1.4142135623730951},"201":{"tf":2.0},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":2.0},"205":{"tf":1.0},"206":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.0},"214":{"tf":1.0},"225":{"tf":1.0},"234":{"tf":1.0},"285":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.7320508075688772},"292":{"tf":1.0},"293":{"tf":1.7320508075688772},"294":{"tf":3.1622776601683795},"295":{"tf":3.3166247903554},"297":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.7320508075688772},"300":{"tf":1.4142135623730951},"5":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"144":{"tf":1.0}}}}},"x":{"df":1,"docs":{"143":{"tf":1.0}}}},"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"144":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"144":{"tf":1.0}}}}},"x":{"df":1,"docs":{"143":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}},"s":{"(":{"'":{".":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"130":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"250":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":15,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"177":{"tf":1.0},"19":{"tf":1.0},"217":{"tf":1.0},"225":{"tf":1.4142135623730951},"308":{"tf":1.0},"314":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"!":{"(":{"\"":{"a":{"d":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"288":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"287":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}},"j":{"df":8,"docs":{"16":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.0},"196":{"tf":1.7320508075688772},"197":{"tf":1.0},"23":{"tf":1.0},"288":{"tf":2.0},"290":{"tf":1.0},"295":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"196":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":19,"docs":{"109":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"128":{"tf":1.0},"140":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"199":{"tf":1.0},"205":{"tf":1.0},"208":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"295":{"tf":1.7320508075688772},"309":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"199":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}},"f":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"213":{"tf":1.0},"220":{"tf":1.0},"236":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"162":{"tf":2.23606797749979}}}},"o":{"df":2,"docs":{"127":{"tf":1.0},"30":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.0},"134":{"tf":1.0},"171":{"tf":1.4142135623730951},"233":{"tf":1.0},"24":{"tf":1.0},"245":{"tf":1.0},"258":{"tf":1.0},"272":{"tf":1.0},"274":{"tf":1.0},"299":{"tf":2.0},"67":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"109":{"tf":1.0},"192":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"234":{"tf":2.0},"235":{"tf":1.0},"236":{"tf":1.0},"66":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"(":{"'":{".":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"264":{"tf":1.4142135623730951}}}}},"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"j":{"df":1,"docs":{"83":{"tf":2.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":1,"docs":{"146":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":5,"docs":{"162":{"tf":1.4142135623730951},"293":{"tf":1.0},"40":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"130":{"tf":1.0},"17":{"tf":1.0},"213":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":1.0},"304":{"tf":1.0},"312":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"221":{"tf":1.4142135623730951},"222":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"254":{"tf":1.7320508075688772},"258":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"263":{"tf":1.0},"264":{"tf":2.23606797749979},"265":{"tf":1.0},"275":{"tf":2.0}}},"n":{"c":{"df":11,"docs":{"142":{"tf":1.0},"145":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"293":{"tf":1.4142135623730951},"295":{"tf":1.0},"298":{"tf":1.0},"30":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{")":{")":{"?":{".":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":8,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"144":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"237":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"204":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"272":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"17":{"tf":1.0},"217":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":28,"docs":{"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"151":{"tf":1.0},"177":{"tf":1.0},"194":{"tf":1.0},"198":{"tf":1.0},"201":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"213":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"243":{"tf":1.0},"250":{"tf":1.0},"261":{"tf":1.0},"269":{"tf":1.0},"285":{"tf":1.0},"292":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.7320508075688772},"297":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"272":{"tf":1.0}},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"274":{"tf":1.0},"303":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"1":{"6":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"2":{"5":{"6":{"df":1,"docs":{"186":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"151":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"186":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"[":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"]":{")":{"[":{"0":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":6,"docs":{"0":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"288":{"tf":1.0},"39":{"tf":1.0}},"r":{"df":4,"docs":{"123":{"tf":1.0},"139":{"tf":1.0},"262":{"tf":1.0},"75":{"tf":1.0}}}},"n":{"d":{"df":12,"docs":{"123":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"194":{"tf":1.0},"218":{"tf":1.0},"284":{"tf":1.0},"295":{"tf":1.0},"298":{"tf":1.0},"304":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":1.0},"195":{"tf":1.0},"22":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"/":{"df":0,"docs":{},"h":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"201":{"tf":1.0},"205":{"tf":1.0},"23":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0}}}}},"f":{"a":{"c":{"df":18,"docs":{"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"216":{"tf":1.0},"229":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"285":{"tf":1.7320508075688772},"289":{"tf":1.0},"304":{"tf":1.4142135623730951},"306":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":2.0},"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"n":{"df":11,"docs":{"12":{"tf":1.0},"140":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"284":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.7320508075688772},"295":{"tf":1.4142135623730951},"298":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"285":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"201":{"tf":1.0},"202":{"tf":1.0},"295":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{"_":{"0":{"0":{"0":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"89":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"286":{"tf":1.0}}}}}}}},"o":{"<":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":3,"docs":{"187":{"tf":1.0},"218":{"tf":1.0},"92":{"tf":2.0}}}}},"df":0,"docs":{}}}}},"_":{"a":{"b":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"297":{"tf":1.0}}}}}}},"df":1,"docs":{"297":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"b":{"df":0,"docs":{},"i":{":":{":":{"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"297":{"tf":2.0},"298":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"275":{"tf":1.0},"66":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"23":{"tf":1.4142135623730951},"238":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"286":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"205":{"tf":1.0}}},"t":{"df":1,"docs":{"294":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"299":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":18,"docs":{"193":{"tf":1.4142135623730951},"194":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"204":{"tf":1.4142135623730951},"23":{"tf":1.0},"290":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.4142135623730951},"300":{"tf":1.0},"307":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"292":{"tf":1.0}}}}}}},"r":{"df":2,"docs":{"269":{"tf":1.4142135623730951},"272":{"tf":1.7320508075688772}}},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"205":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"205":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"160":{"tf":1.7320508075688772},"162":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":14,"docs":{"124":{"tf":1.0},"137":{"tf":1.0},"208":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.0},"285":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.0},"299":{"tf":1.0},"304":{"tf":1.0},"309":{"tf":1.0},"312":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":8,"docs":{"131":{"tf":1.0},"139":{"tf":1.0},"217":{"tf":1.0},"284":{"tf":1.0},"299":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}},"t":{"'":{"df":46,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"187":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"201":{"tf":1.0},"202":{"tf":1.0},"205":{"tf":1.0},"208":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.4142135623730951},"225":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"234":{"tf":1.0},"238":{"tf":1.4142135623730951},"285":{"tf":1.4142135623730951},"288":{"tf":1.4142135623730951},"289":{"tf":1.4142135623730951},"290":{"tf":1.4142135623730951},"292":{"tf":1.0},"293":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"297":{"tf":1.4142135623730951},"304":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"195":{"tf":1.0},"199":{"tf":1.0},"208":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"131":{"tf":1.0},"199":{"tf":1.7320508075688772},"201":{"tf":1.0},"288":{"tf":1.0},"311":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"97":{"tf":1.0}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"177":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"304":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":3.4641016151377544},"97":{"tf":2.8284271247461903}}},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":2.23606797749979}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":14,"docs":{"105":{"tf":1.0},"11":{"tf":1.0},"132":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"218":{"tf":1.0},"237":{"tf":1.0},"288":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"204":{"tf":1.0},"212":{"tf":1.0},"90":{"tf":1.0}}},"df":95,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"106":{"tf":2.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"129":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.7320508075688772},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":2.6457513110645907},"161":{"tf":1.4142135623730951},"162":{"tf":2.0},"163":{"tf":1.7320508075688772},"164":{"tf":1.7320508075688772},"165":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"170":{"tf":1.0},"171":{"tf":2.8284271247461903},"173":{"tf":1.0},"174":{"tf":2.0},"176":{"tf":1.0},"177":{"tf":2.449489742783178},"178":{"tf":1.7320508075688772},"180":{"tf":1.0},"181":{"tf":1.4142135623730951},"183":{"tf":1.0},"184":{"tf":2.23606797749979},"186":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.7320508075688772},"193":{"tf":1.4142135623730951},"196":{"tf":2.449489742783178},"197":{"tf":1.4142135623730951},"198":{"tf":2.6457513110645907},"199":{"tf":2.0},"200":{"tf":1.7320508075688772},"201":{"tf":1.4142135623730951},"204":{"tf":1.0},"205":{"tf":1.4142135623730951},"207":{"tf":1.7320508075688772},"209":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":1.0},"40":{"tf":1.0},"74":{"tf":1.4142135623730951},"79":{"tf":1.0},"85":{"tf":2.0},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"90":{"tf":2.0},"93":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"265":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"315":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"q":{"df":1,"docs":{"272":{"tf":1.4142135623730951}}},"s":{"'":{"df":2,"docs":{"289":{"tf":1.0},"97":{"tf":1.0}}},".":{"df":0,"docs":{},"j":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"285":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"197":{"tf":2.0},"198":{"tf":2.0},"212":{"tf":1.0},"213":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"_":{"b":{"df":0,"docs":{},"g":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"197":{"tf":1.0},"198":{"tf":3.3166247903554},"212":{"tf":1.7320508075688772},"213":{"tf":1.0},"8":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":5,"docs":{"199":{"tf":2.6457513110645907},"204":{"tf":1.0},"208":{"tf":1.0},"295":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"198":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"308":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"300":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"300":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"3":{"2":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"233":{"tf":1.7320508075688772},"300":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"(":{")":{".":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{">":{"(":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"308":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"'":{"a":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"96":{"tf":2.0},"97":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"174":{"tf":1.0},"177":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"233":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"91":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"&":{"4":{"2":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"4":{"2":{"df":1,"docs":{"249":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"107":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":1,"docs":{"109":{"tf":1.4142135623730951}},"s":{"(":{"&":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"108":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":3,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{"?":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"8":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"a":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"_":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"{":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"233":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"237":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{}}},"df":95,"docs":{"0":{"tf":2.6457513110645907},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.4142135623730951},"112":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":2.0},"130":{"tf":1.0},"132":{"tf":2.23606797749979},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":2.0},"14":{"tf":1.7320508075688772},"140":{"tf":3.0},"151":{"tf":1.4142135623730951},"162":{"tf":1.0},"17":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.0},"187":{"tf":2.449489742783178},"190":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":2.6457513110645907},"195":{"tf":2.23606797749979},"197":{"tf":1.0},"2":{"tf":1.4142135623730951},"201":{"tf":1.0},"202":{"tf":1.7320508075688772},"204":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951},"22":{"tf":1.0},"220":{"tf":1.4142135623730951},"225":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.7320508075688772},"234":{"tf":1.0},"235":{"tf":1.0},"244":{"tf":1.0},"249":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"282":{"tf":1.4142135623730951},"285":{"tf":2.0},"286":{"tf":1.0},"287":{"tf":1.7320508075688772},"288":{"tf":2.8284271247461903},"289":{"tf":2.6457513110645907},"290":{"tf":1.0},"291":{"tf":1.0},"292":{"tf":2.0},"293":{"tf":3.4641016151377544},"294":{"tf":2.449489742783178},"295":{"tf":3.872983346207417},"296":{"tf":1.0},"297":{"tf":3.0},"298":{"tf":2.0},"299":{"tf":1.0},"30":{"tf":1.4142135623730951},"300":{"tf":2.23606797749979},"301":{"tf":1.0},"303":{"tf":1.4142135623730951},"32":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":2.6457513110645907},"92":{"tf":2.23606797749979},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"212":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"93":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"p":{"c":{"1":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"249":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{")":{"?":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"198":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}}}}},":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"104":{"tf":2.449489742783178},"105":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"299":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"177":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"197":{"tf":2.0},"198":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":44,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"140":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.7320508075688772},"151":{"tf":1.0},"18":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.7320508075688772},"194":{"tf":1.4142135623730951},"198":{"tf":1.0},"200":{"tf":1.4142135623730951},"203":{"tf":1.0},"206":{"tf":1.7320508075688772},"207":{"tf":1.4142135623730951},"21":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"233":{"tf":1.0},"28":{"tf":1.0},"288":{"tf":2.0},"289":{"tf":2.0},"290":{"tf":2.23606797749979},"295":{"tf":1.7320508075688772},"298":{"tf":1.0},"299":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":2.0},"91":{"tf":2.449489742783178},"92":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{":":{":":{"_":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"289":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"90":{"tf":1.0}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"105":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"149":{"tf":1.0},"90":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"d":{"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"233":{"tf":1.0},"46":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":9,"docs":{"126":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"177":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.0},"285":{"tf":1.0},"46":{"tf":1.0},"89":{"tf":1.0}}}},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"286":{"tf":1.0},"29":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"192":{"tf":1.0},"285":{"tf":1.0},"292":{"tf":1.0},"311":{"tf":1.0},"96":{"tf":1.0}},"n":{"df":4,"docs":{"208":{"tf":1.0},"299":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"233":{"tf":1.0},"263":{"tf":1.0},"292":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":11,"docs":{"12":{"tf":1.0},"134":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"205":{"tf":1.0},"289":{"tf":1.0},"294":{"tf":1.0},"3":{"tf":1.0},"301":{"tf":1.0},"309":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"132":{"tf":1.0},"314":{"tf":1.0},"59":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"278":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"207":{"tf":1.7320508075688772},"299":{"tf":1.0},"59":{"tf":2.0},"66":{"tf":1.0}}}},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"160":{"tf":1.0},"23":{"tf":1.0},"272":{"tf":1.0},"292":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.0},"299":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"263":{"tf":1.0},"265":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"219":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"193":{"tf":1.0},"298":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"299":{"tf":1.0},"305":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"130":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":5,"docs":{"139":{"tf":1.0},"190":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"178":{"tf":1.0},"205":{"tf":1.0},"93":{"tf":1.0}}}},"v":{"df":4,"docs":{"104":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"244":{"tf":1.4142135623730951},"289":{"tf":1.0},"33":{"tf":1.0}}}},"n":{"0":{"df":2,"docs":{"292":{"tf":1.7320508075688772},"294":{"tf":1.4142135623730951}}},"df":3,"docs":{"292":{"tf":2.449489742783178},"297":{"tf":1.0},"46":{"tf":2.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"198":{"tf":1.0}}}}}},"df":5,"docs":{"171":{"tf":1.0},"195":{"tf":1.0},"292":{"tf":1.0},"294":{"tf":1.0},"297":{"tf":1.0}}}}}},"t":{"'":{"df":13,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"12":{"tf":1.4142135623730951},"195":{"tf":1.0},"23":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":2.0},"292":{"tf":2.0},"293":{"tf":1.0},"294":{"tf":1.7320508075688772},"295":{"tf":2.0},"297":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":1,"docs":{"297":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"311":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"66":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"305":{"tf":1.0}}}},"c":{"df":1,"docs":{"225":{"tf":1.0}}},"df":12,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"202":{"tf":1.0},"218":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"64":{"tf":2.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"131":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":6,"docs":{"288":{"tf":1.0},"289":{"tf":1.7320508075688772},"298":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}},"t":{"df":5,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"25":{"tf":1.0},"84":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"285":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}}}}},"k":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"208":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0},"269":{"tf":1.0},"66":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"174":{"tf":1.0},"178":{"tf":1.0},"184":{"tf":1.0}}}},"df":2,"docs":{"114":{"tf":1.4142135623730951},"263":{"tf":1.0}}},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":5,"docs":{"11":{"tf":1.0},"130":{"tf":2.449489742783178},"132":{"tf":1.0},"195":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}},"t":{"df":11,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":13,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"13":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.0},"256":{"tf":1.0},"272":{"tf":1.0},"3":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"55":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"217":{"tf":1.0},"86":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"292":{"tf":1.0},"308":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"23":{"tf":1.4142135623730951},"289":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"89":{"tf":1.0}}}}},"l":{")":{".":{"df":0,"docs":{},"o":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"126":{"tf":1.4142135623730951}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":2,"docs":{"269":{"tf":2.0},"272":{"tf":2.0}}}}},"o":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":2.0}}}},"df":0,"docs":{}},"df":16,"docs":{"10":{"tf":2.0},"11":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"193":{"tf":1.0},"205":{"tf":1.4142135623730951},"217":{"tf":1.0},"23":{"tf":1.4142135623730951},"295":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.0},"201":{"tf":1.0},"261":{"tf":1.0},"287":{"tf":1.0},"290":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"194":{"tf":1.0},"202":{"tf":1.0},"286":{"tf":1.0},"297":{"tf":1.0},"30":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":4,"docs":{"135":{"tf":1.0},"199":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"t":{")":{"*":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":5,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"x":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"a":{"df":3,"docs":{"18":{"tf":1.0},"199":{"tf":1.4142135623730951},"25":{"tf":1.0}}},"df":8,"docs":{"13":{"tf":1.0},"135":{"tf":1.0},"15":{"tf":1.0},"199":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"3":{"2":{"(":{"4":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":8,"docs":{"0":{"tf":1.0},"198":{"tf":1.7320508075688772},"199":{"tf":1.0},"221":{"tf":1.0},"311":{"tf":2.0},"58":{"tf":1.0},"8":{"tf":2.449489742783178},"89":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"36":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"n":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"30":{"tf":1.7320508075688772}},"g":{"df":7,"docs":{"187":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"289":{"tf":1.0},"300":{"tf":1.0},"66":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"192":{"tf":1.0},"211":{"tf":1.0},"284":{"tf":1.0},"288":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"219":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"k":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"132":{"tf":1.0},"140":{"tf":1.0},"188":{"tf":1.0},"19":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.7320508075688772},"216":{"tf":1.0},"229":{"tf":1.0},"238":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":2.0},"289":{"tf":1.4142135623730951},"292":{"tf":2.6457513110645907},"293":{"tf":1.4142135623730951},"294":{"tf":1.0},"295":{"tf":2.0},"297":{"tf":1.0},"298":{"tf":1.0},"312":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"194":{"tf":1.0},"195":{"tf":1.0}}}}},"p":{"df":5,"docs":{"50":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"72":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":3,"docs":{"104":{"tf":1.0},"292":{"tf":1.0},"34":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"66":{"tf":1.0}}}},"m":{"a":{"c":{"df":1,"docs":{"259":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"254":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"df":15,"docs":{"100":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.0},"188":{"tf":1.0},"199":{"tf":1.0},"219":{"tf":1.0},"253":{"tf":1.0},"281":{"tf":2.0},"292":{"tf":1.0},"299":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"14":{"tf":1.0},"293":{"tf":1.0},"314":{"tf":1.4142135623730951},"52":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"218":{"tf":2.449489742783178},"246":{"tf":1.0},"287":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":2.449489742783178}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"276":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"139":{"tf":1.0},"177":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.0}},"s":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"113":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"214":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":22,"docs":{"10":{"tf":1.0},"104":{"tf":1.0},"132":{"tf":1.0},"210":{"tf":1.0},"238":{"tf":1.0},"246":{"tf":1.0},"249":{"tf":1.0},"26":{"tf":1.0},"269":{"tf":1.0},"275":{"tf":1.0},"29":{"tf":1.0},"297":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":1.0},"313":{"tf":1.4142135623730951},"34":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"140":{"tf":1.4142135623730951},"245":{"tf":1.0},"258":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"91":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"276":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":11,"docs":{"111":{"tf":1.0},"225":{"tf":1.0},"232":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"104":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"237":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"130":{"tf":1.0},"145":{"tf":1.0},"216":{"tf":1.4142135623730951},"223":{"tf":1.0},"293":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"_":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"288":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"290":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"297":{"tf":1.0},"300":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"215":{"tf":1.0},"266":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"300":{"tf":1.0},"304":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"194":{"tf":1.0},"23":{"tf":1.0},"238":{"tf":1.0},"269":{"tf":1.0},"46":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.0}}}}},"h":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"199":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"271":{"tf":1.0}}}}},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"153":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"271":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"30":{"tf":2.0}},"n":{"df":4,"docs":{"303":{"tf":1.0},"308":{"tf":1.4142135623730951},"31":{"tf":1.0},"67":{"tf":1.0}}}},"df":1,"docs":{"10":{"tf":1.0}},"e":{")":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":23,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"135":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"195":{"tf":1.0},"202":{"tf":1.7320508075688772},"23":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.0},"238":{"tf":1.4142135623730951},"285":{"tf":1.4142135623730951},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":2.23606797749979},"295":{"tf":1.4142135623730951},"297":{"tf":1.0},"304":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"69":{"tf":1.0}},"t":{"df":1,"docs":{"295":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"132":{"tf":1.7320508075688772}}}}},"t":{"df":1,"docs":{"295":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"289":{"tf":1.0},"304":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"256":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"256":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"256":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"0":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"314":{"tf":1.4142135623730951},"315":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0}}}}},"df":2,"docs":{"18":{"tf":1.0},"292":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":20,"docs":{"139":{"tf":2.23606797749979},"156":{"tf":1.0},"159":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"18":{"tf":1.7320508075688772},"181":{"tf":1.0},"184":{"tf":1.0},"190":{"tf":1.0},"215":{"tf":1.0},"23":{"tf":1.0},"271":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"65":{"tf":2.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"y":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},",":{"+":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"308":{"tf":1.0},"66":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"272":{"tf":1.4142135623730951},"313":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":11,"docs":{"12":{"tf":1.0},"218":{"tf":1.0},"272":{"tf":1.0},"281":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":3.3166247903554},"49":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.7320508075688772},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":6,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"17":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"231":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"a":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"235":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":41,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"139":{"tf":1.0},"19":{"tf":1.0},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"193":{"tf":2.0},"194":{"tf":2.0},"196":{"tf":1.7320508075688772},"197":{"tf":1.7320508075688772},"198":{"tf":1.4142135623730951},"200":{"tf":2.23606797749979},"204":{"tf":2.449489742783178},"205":{"tf":2.0},"208":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"216":{"tf":1.0},"222":{"tf":1.0},"229":{"tf":1.0},"23":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"273":{"tf":1.0},"279":{"tf":1.0},"293":{"tf":2.0},"295":{"tf":2.23606797749979},"309":{"tf":1.4142135623730951},"39":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":2.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"249":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"30":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"d":{"df":4,"docs":{"11":{"tf":1.0},"195":{"tf":1.0},"285":{"tf":1.0},"295":{"tf":1.0}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"271":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"132":{"tf":1.0}},"i":{"df":1,"docs":{"132":{"tf":1.0}}}},"m":{"df":2,"docs":{"132":{"tf":1.0},"286":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"313":{"tf":1.0}}}},"u":{"df":1,"docs":{"220":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"177":{"tf":1.0},"262":{"tf":1.0},"289":{"tf":1.0},"302":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"281":{"tf":1.0}}}}}},"o":{"d":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"16":{"tf":1.4142135623730951},"243":{"tf":1.0},"308":{"tf":1.0}},"e":{"df":8,"docs":{"10":{"tf":1.0},"124":{"tf":1.0},"250":{"tf":1.0},"257":{"tf":1.0},"6":{"tf":1.0},"77":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":7,"docs":{"0":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":2.449489742783178},"218":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"233":{"tf":1.4142135623730951},"285":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":53,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.8284271247461903},"12":{"tf":3.3166247903554},"120":{"tf":1.4142135623730951},"123":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":2.449489742783178},"134":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"195":{"tf":1.0},"198":{"tf":1.4142135623730951},"199":{"tf":1.0},"201":{"tf":2.23606797749979},"202":{"tf":1.4142135623730951},"208":{"tf":1.0},"217":{"tf":1.7320508075688772},"243":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"272":{"tf":1.0},"285":{"tf":2.6457513110645907},"287":{"tf":1.0},"288":{"tf":2.0},"289":{"tf":2.0},"292":{"tf":1.7320508075688772},"294":{"tf":1.7320508075688772},"295":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.7320508075688772},"60":{"tf":1.0},"65":{"tf":2.23606797749979},"66":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"77":{"tf":2.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"84":{"tf":2.23606797749979},"85":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0}},"e":{"'":{"df":3,"docs":{"10":{"tf":1.0},"295":{"tf":1.0},"43":{"tf":1.0}}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}},"s":{".":{"_":{"_":{"df":0,"docs":{},"w":{"b":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"2":{"b":{"a":{"7":{"7":{"4":{"5":{"9":{"2":{"c":{"5":{"2":{"2":{"3":{"a":{"7":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":40,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"110":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.0},"171":{"tf":1.4142135623730951},"18":{"tf":1.0},"205":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"23":{"tf":1.0},"237":{"tf":1.0},"272":{"tf":1.0},"274":{"tf":1.0},"276":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.4142135623730951},"292":{"tf":1.0},"295":{"tf":1.4142135623730951},"296":{"tf":1.0},"298":{"tf":1.0},"302":{"tf":1.0},"312":{"tf":1.0},"314":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.4142135623730951},"296":{"tf":1.0},"298":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":6,"docs":{"199":{"tf":1.0},"289":{"tf":1.0},"30":{"tf":1.4142135623730951},"312":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}}},"z":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"256":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"25":{"tf":1.0}},"g":{"df":1,"docs":{"211":{"tf":1.4142135623730951}}},"v":{"c":{"df":1,"docs":{"264":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"140":{"tf":1.0},"250":{"tf":1.0},"285":{"tf":1.0},"289":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"30":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"192":{"tf":1.0},"198":{"tf":1.0},"232":{"tf":1.0},"254":{"tf":1.0},"292":{"tf":1.0},"297":{"tf":1.4142135623730951},"299":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"298":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":31,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"157":{"tf":1.0},"160":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"220":{"tf":1.0},"23":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"292":{"tf":1.0},"293":{"tf":2.0},"294":{"tf":2.449489742783178},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"88":{"tf":1.7320508075688772},"96":{"tf":1.0}},"e":{"df":1,"docs":{"39":{"tf":1.0}},"x":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"v":{"c":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}},"df":1,"docs":{"312":{"tf":1.0}}},"y":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"249":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{".":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"247":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"243":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"223":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.7320508075688772}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"312":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"100":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"=":{"\"":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":1,"docs":{"147":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"147":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":1,"docs":{"147":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"147":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":34,"docs":{"11":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"193":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"20":{"tf":1.0},"208":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"220":{"tf":2.449489742783178},"265":{"tf":1.0},"27":{"tf":1.0},"270":{"tf":1.0},"288":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":2.449489742783178},"308":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"85":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":4,"docs":{"199":{"tf":2.449489742783178},"208":{"tf":1.0},"295":{"tf":1.0},"85":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"162":{"tf":1.4142135623730951}},"o":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":10,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"140":{"tf":1.0},"240":{"tf":1.0},"279":{"tf":1.4142135623730951},"292":{"tf":1.0},"295":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"187":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"13":{"tf":1.0},"89":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"123":{"tf":1.0},"187":{"tf":1.0},"195":{"tf":1.0},"238":{"tf":1.0},"270":{"tf":1.0},"276":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.0},"32":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":43,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.7320508075688772},"198":{"tf":1.0},"211":{"tf":1.0},"23":{"tf":1.0},"236":{"tf":1.0},"249":{"tf":1.0},"250":{"tf":1.0},"267":{"tf":1.0},"269":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.4142135623730951},"292":{"tf":1.0},"293":{"tf":1.0},"297":{"tf":1.0},"300":{"tf":1.0},"309":{"tf":1.0},"312":{"tf":1.0},"38":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"199":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"194":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}},"w":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"293":{"tf":1.0}}},"df":1,"docs":{"295":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"220":{"tf":1.0},"221":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":1,"docs":{"206":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"15":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"293":{"tf":1.0}}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"89":{"tf":1.0}}}},"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"207":{"tf":2.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":46,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"130":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.7320508075688772},"156":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"18":{"tf":1.0},"191":{"tf":2.23606797749979},"196":{"tf":1.0},"198":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"213":{"tf":1.4142135623730951},"215":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":2.0},"293":{"tf":1.7320508075688772},"294":{"tf":1.0},"295":{"tf":2.6457513110645907},"302":{"tf":1.4142135623730951},"303":{"tf":1.4142135623730951},"312":{"tf":1.0},"313":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"290":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"195":{"tf":1.0},"249":{"tf":1.0},"288":{"tf":1.4142135623730951},"292":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"242":{"tf":1.0},"250":{"tf":1.0},"263":{"tf":1.0},"264":{"tf":1.0},"266":{"tf":1.0},"272":{"tf":1.4142135623730951},"64":{"tf":1.0},"69":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"o":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"203":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"261":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"293":{"tf":1.0},"299":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"308":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":14,"docs":{"119":{"tf":1.0},"128":{"tf":1.0},"140":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"244":{"tf":1.0},"252":{"tf":1.4142135623730951},"253":{"tf":1.0},"261":{"tf":1.0},"278":{"tf":1.0},"301":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}}}},"df":13,"docs":{"10":{"tf":1.0},"123":{"tf":1.0},"20":{"tf":1.0},"235":{"tf":2.23606797749979},"244":{"tf":1.0},"264":{"tf":1.0},"275":{"tf":1.7320508075688772},"278":{"tf":1.0},"39":{"tf":2.23606797749979},"51":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772}},"j":{"df":5,"docs":{"222":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"146":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.0},"135":{"tf":1.4142135623730951},"145":{"tf":1.0},"168":{"tf":1.0},"263":{"tf":1.0},"312":{"tf":1.0}},"e":{"df":7,"docs":{"100":{"tf":1.0},"152":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"23":{"tf":1.4142135623730951},"259":{"tf":1.0},"52":{"tf":1.0}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"100":{"tf":1.0},"177":{"tf":1.0},"196":{"tf":1.4142135623730951},"208":{"tf":1.0},"23":{"tf":1.4142135623730951},"240":{"tf":1.0},"243":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"194":{"tf":1.0},"288":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":52,"docs":{"1":{"tf":1.0},"10":{"tf":2.23606797749979},"100":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.4142135623730951},"168":{"tf":1.0},"171":{"tf":1.4142135623730951},"178":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"198":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"205":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"232":{"tf":1.0},"236":{"tf":1.0},"242":{"tf":1.0},"250":{"tf":1.0},"253":{"tf":1.0},"256":{"tf":1.0},"289":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"3":{"tf":1.0},"39":{"tf":2.0},"43":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"92":{"tf":1.0},"96":{"tf":1.0}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"w":{"df":15,"docs":{"177":{"tf":1.0},"190":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"285":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"300":{"tf":1.4142135623730951},"301":{"tf":1.0},"84":{"tf":1.0},"91":{"tf":1.0}}}},"p":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"u":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"314":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":12,"docs":{"140":{"tf":1.0},"144":{"tf":1.0},"153":{"tf":1.0},"167":{"tf":1.0},"170":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"291":{"tf":1.0},"293":{"tf":1.0},"40":{"tf":1.7320508075688772}}}},"m":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"62":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":39,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"114":{"tf":1.0},"13":{"tf":1.7320508075688772},"133":{"tf":1.0},"143":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":2.449489742783178},"161":{"tf":1.0},"162":{"tf":2.449489742783178},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"181":{"tf":1.0},"184":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"216":{"tf":2.449489742783178},"219":{"tf":1.4142135623730951},"223":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"236":{"tf":1.0},"27":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"309":{"tf":1.0},"313":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":3.3166247903554},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"59":{"tf":2.23606797749979},"62":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"23":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"160":{"tf":1.4142135623730951},"161":{"tf":1.0}}}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"220":{"tf":1.0},"221":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"196":{"tf":1.0}}}}}}},"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"196":{"tf":2.6457513110645907}}}}}}},"df":8,"docs":{"140":{"tf":1.0},"196":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"23":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"295":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"193":{"tf":1.0}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"295":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"193":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"211":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":41,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"103":{"tf":1.4142135623730951},"106":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"18":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"21":{"tf":1.0},"219":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"272":{"tf":2.6457513110645907},"28":{"tf":1.0},"285":{"tf":1.0},"287":{"tf":1.7320508075688772},"288":{"tf":2.6457513110645907},"289":{"tf":2.6457513110645907},"290":{"tf":1.4142135623730951},"292":{"tf":1.0},"293":{"tf":2.0},"295":{"tf":2.23606797749979},"300":{"tf":1.0},"308":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":2.0},"45":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"85":{"tf":2.449489742783178},"88":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"42":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"272":{"tf":1.4142135623730951},"273":{"tf":1.0},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"314":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"49":{"tf":2.0}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"315":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"k":{"(":{"_":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"a":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"59":{"tf":1.0}}},"df":1,"docs":{"97":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"244":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"l":{"d":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"207":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"207":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"242":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"123":{"tf":1.4142135623730951},"129":{"tf":1.0},"216":{"tf":1.0},"257":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0}}}}},"n":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":16,"docs":{"12":{"tf":1.7320508075688772},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"205":{"tf":1.0},"255":{"tf":1.0},"261":{"tf":1.0},"275":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.0},"52":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":35,"docs":{"0":{"tf":1.4142135623730951},"111":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"198":{"tf":1.0},"204":{"tf":1.4142135623730951},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"22":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"23":{"tf":1.4142135623730951},"243":{"tf":1.0},"259":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.4142135623730951},"292":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.7320508075688772},"297":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.4142135623730951},"303":{"tf":1.0},"314":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"295":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"1":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"df":1,"docs":{"49":{"tf":1.0}}},"2":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":23,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"b":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.0}},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}}}}}},"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}}}}}}}}},"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"288":{"tf":1.0},"292":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"295":{"tf":1.0}}}}},"df":1,"docs":{"165":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"284":{"tf":1.0},"303":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"df":6,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":2.0},"235":{"tf":1.0},"288":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"285":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"293":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"298":{"tf":1.4142135623730951}}}}}}},"t":{"df":3,"docs":{"238":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":4,"docs":{"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"285":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}}},"x":{"<":{"[":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"152":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"u":{"8":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"i":{"1":{"6":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}},"t":{"df":14,"docs":{"142":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"181":{"tf":1.0},"184":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951}}},"u":{"8":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"308":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":12,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"232":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"75":{"tf":1.0}}}}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"218":{"tf":1.0},"238":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"276":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"314":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"105":{"tf":1.0},"273":{"tf":1.0},"285":{"tf":1.0},"288":{"tf":1.0},"293":{"tf":1.0}}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"37":{"tf":1.0},"39":{"tf":3.3166247903554},"68":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"259":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"294":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":10,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"162":{"tf":1.0},"190":{"tf":1.0},"263":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"59":{"tf":1.0},"92":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"43":{"tf":1.0},"52":{"tf":1.0}}},"v":{"df":2,"docs":{"300":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"t":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":26,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"118":{"tf":1.0},"130":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"178":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"233":{"tf":1.0},"272":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"291":{"tf":1.0},"293":{"tf":1.0},"299":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"307":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"199":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":28,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":2.0},"134":{"tf":1.0},"137":{"tf":1.7320508075688772},"219":{"tf":1.0},"221":{"tf":1.4142135623730951},"244":{"tf":1.4142135623730951},"270":{"tf":1.0},"272":{"tf":2.0},"288":{"tf":1.0},"293":{"tf":1.0},"311":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":2.0},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"11":{"tf":1.0},"130":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"199":{"tf":1.0},"285":{"tf":1.0},"293":{"tf":1.0},"297":{"tf":1.0},"299":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"232":{"tf":2.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}},"df":2,"docs":{"221":{"tf":1.0},"272":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"141":{"tf":1.0},"305":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"289":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"263":{"tf":1.0},"265":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"312":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"244":{"tf":1.4142135623730951},"245":{"tf":1.4142135623730951},"254":{"tf":2.0},"255":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"263":{"tf":1.4142135623730951},"265":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"64":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":12,"docs":{"119":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"23":{"tf":2.449489742783178},"262":{"tf":1.0},"282":{"tf":1.0},"283":{"tf":1.0},"303":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0}}}},"r":{"df":4,"docs":{"177":{"tf":1.7320508075688772},"213":{"tf":1.0},"292":{"tf":1.4142135623730951},"294":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"293":{"tf":1.0}},"k":{"df":1,"docs":{"244":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"56":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"m":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":2,"docs":{"216":{"tf":2.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":22,"docs":{"102":{"tf":1.0},"142":{"tf":2.0},"145":{"tf":2.0},"148":{"tf":2.0},"151":{"tf":2.0},"154":{"tf":2.0},"157":{"tf":2.0},"160":{"tf":2.0},"168":{"tf":2.0},"171":{"tf":2.0},"174":{"tf":2.0},"178":{"tf":2.0},"181":{"tf":2.0},"184":{"tf":2.0},"187":{"tf":2.0},"196":{"tf":2.449489742783178},"200":{"tf":1.0},"204":{"tf":1.0},"207":{"tf":1.0},"297":{"tf":1.7320508075688772},"39":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"211":{"tf":1.0}}},"df":3,"docs":{"211":{"tf":2.449489742783178},"235":{"tf":1.7320508075688772},"236":{"tf":1.4142135623730951}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"288":{"tf":1.4142135623730951},"289":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":6,"docs":{"104":{"tf":1.0},"206":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"59":{"tf":1.0}},"e":{"d":{"[":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{"]":{"[":{"\"":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"\"":{"]":{"[":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"\"":{"]":{"[":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{"]":{"[":{"0":{"]":{"[":{"\"":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"\"":{"]":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"238":{"tf":1.0},"300":{"tf":1.0},"31":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"232":{"tf":1.0},"233":{"tf":1.0},"295":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":41,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"119":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"151":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"171":{"tf":1.0},"177":{"tf":1.0},"193":{"tf":1.0},"205":{"tf":1.0},"22":{"tf":1.0},"233":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.4142135623730951},"248":{"tf":1.0},"254":{"tf":1.0},"272":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":1.7320508075688772},"294":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.7320508075688772},"299":{"tf":1.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"292":{"tf":1.0}}},"df":1,"docs":{"292":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"0":{"df":1,"docs":{"294":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"294":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}}},"t":{"df":1,"docs":{"288":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"_":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"=":{"%":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"%":{";":{"c":{":":{"\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\\":{".":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"\\":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"264":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":20,"docs":{"129":{"tf":1.0},"130":{"tf":1.0},"20":{"tf":1.4142135623730951},"201":{"tf":1.0},"202":{"tf":1.7320508075688772},"259":{"tf":1.7320508075688772},"27":{"tf":2.0},"270":{"tf":1.0},"272":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"48":{"tf":2.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}},"y":{"df":2,"docs":{"131":{"tf":1.0},"9":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"190":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"1":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"c":{"!":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"1":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"_":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":2.449489742783178}}},"2":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"d":{"c":{"!":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"2":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"_":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":2.23606797749979}}},"df":1,"docs":{"264":{"tf":1.0}}},"df":4,"docs":{"10":{"tf":1.0},"280":{"tf":1.0},"281":{"tf":1.0},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"1":{".":{"d":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"d":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":2,"docs":{"223":{"tf":1.0},"224":{"tf":1.4142135623730951}},"f":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":6,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"174":{"tf":1.0},"194":{"tf":1.4142135623730951},"202":{"tf":1.0},"25":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.0},"288":{"tf":1.0},"298":{"tf":1.0},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"195":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"233":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"292":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"219":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"249":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"273":{"tf":1.0}}}}}}},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"5":{"tf":1.0}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"217":{"tf":1.0},"270":{"tf":1.0},"289":{"tf":1.0},"30":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"219":{"tf":1.0}}}},"n":{"df":3,"docs":{"136":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":6,"docs":{"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"19":{"tf":1.0},"208":{"tf":1.0},"304":{"tf":1.0},"66":{"tf":1.0}}}}}}},"y":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"217":{"tf":1.0},"29":{"tf":1.0},"302":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"6":{"tf":2.23606797749979}}}}},"s":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"130":{"tf":1.0},"14":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"171":{"tf":1.4142135623730951},"195":{"tf":1.0},"21":{"tf":1.0},"217":{"tf":1.0},"281":{"tf":1.0},"288":{"tf":1.4142135623730951},"297":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.7320508075688772},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"195":{"tf":1.0},"235":{"tf":1.0},"288":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.4142135623730951},"294":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"287":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"198":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"p":{"df":1,"docs":{"288":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"309":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":14,"docs":{"100":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"177":{"tf":1.0},"188":{"tf":1.0},"199":{"tf":1.0},"231":{"tf":1.0},"240":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.0},"295":{"tf":1.0},"66":{"tf":1.4142135623730951},"83":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":5,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"285":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"217":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"276":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"188":{"tf":1.0},"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"64":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"256":{"tf":1.0}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"208":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"270":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"d":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"275":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"201":{"tf":1.0},"203":{"tf":1.0},"269":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"130":{"tf":1.0},"177":{"tf":1.0},"62":{"tf":1.0}}}}},"s":{"df":1,"docs":{"55":{"tf":1.7320508075688772}},"e":{"d":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"(":{"[":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":7,"docs":{"17":{"tf":1.0},"194":{"tf":1.0},"23":{"tf":1.0},"249":{"tf":1.0},"291":{"tf":1.0},"295":{"tf":1.0},"299":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"216":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"105":{"tf":1.0},"295":{"tf":1.0},"92":{"tf":1.0}},"s":{"df":2,"docs":{"238":{"tf":1.0},"296":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"132":{"tf":1.0},"219":{"tf":1.0},"39":{"tf":2.8284271247461903}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"298":{"tf":1.0},"75":{"tf":1.0}}}}},"y":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"4":{"4":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"297":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"1":{"df":1,"docs":{"135":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"221":{"tf":1.4142135623730951},"243":{"tf":1.0},"290":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"309":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"105":{"tf":1.0},"137":{"tf":1.0},"24":{"tf":1.0}}}}}},"c":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"219":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"281":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"308":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"118":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"59":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":6,"docs":{"137":{"tf":1.0},"272":{"tf":1.0},"285":{"tf":1.0},"295":{"tf":1.4142135623730951},"298":{"tf":1.0},"64":{"tf":1.0}},"t":{"df":2,"docs":{"124":{"tf":1.0},"264":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"272":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"132":{"tf":1.0},"24":{"tf":1.0},"269":{"tf":1.4142135623730951},"271":{"tf":1.0},"272":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"=":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"272":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":3,"docs":{"266":{"tf":1.0},"270":{"tf":1.4142135623730951},"272":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":9,"docs":{"131":{"tf":1.0},"135":{"tf":1.4142135623730951},"239":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"30":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"53":{"tf":1.0},"8":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.0}}}},"df":1,"docs":{"124":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"134":{"tf":1.0},"2":{"tf":1.0},"202":{"tf":1.0},"274":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"285":{"tf":1.0},"299":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"249":{"tf":2.0},"28":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"91":{"tf":3.3166247903554},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"196":{"tf":1.0}}}}}}}}},"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"187":{"tf":1.0},"97":{"tf":1.0}}}},"df":1,"docs":{"196":{"tf":3.3166247903554}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"218":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":11,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"193":{"tf":2.6457513110645907},"194":{"tf":1.0},"196":{"tf":1.7320508075688772},"205":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951}}},"y":{"'":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"295":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":7,"docs":{"0":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"194":{"tf":1.7320508075688772},"195":{"tf":2.6457513110645907},"285":{"tf":1.0},"286":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"278":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":7,"docs":{"111":{"tf":1.0},"142":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"205":{"tf":2.0},"211":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":15,"docs":{"141":{"tf":1.0},"195":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"225":{"tf":1.0},"234":{"tf":1.0},"270":{"tf":1.0},"271":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"65":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"196":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"299":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"264":{"tf":1.0}}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"292":{"tf":1.7320508075688772},"294":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"292":{"tf":1.0}}}}}}}}},"0":{"df":1,"docs":{"292":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"155":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":7,"docs":{"156":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"292":{"tf":2.23606797749979},"293":{"tf":1.4142135623730951},"295":{"tf":2.0},"297":{"tf":1.0}}}},"u":{"b":{"df":65,"docs":{"10":{"tf":1.0},"100":{"tf":2.0},"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"12":{"tf":1.0},"135":{"tf":1.4142135623730951},"140":{"tf":1.0},"143":{"tf":3.3166247903554},"146":{"tf":3.872983346207417},"149":{"tf":1.7320508075688772},"15":{"tf":2.449489742783178},"152":{"tf":2.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"166":{"tf":2.0},"169":{"tf":2.0},"172":{"tf":1.4142135623730951},"175":{"tf":1.0},"179":{"tf":2.0},"182":{"tf":1.4142135623730951},"185":{"tf":2.0},"198":{"tf":1.4142135623730951},"204":{"tf":1.0},"206":{"tf":2.6457513110645907},"207":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":2.23606797749979},"215":{"tf":2.23606797749979},"216":{"tf":1.4142135623730951},"220":{"tf":2.449489742783178},"221":{"tf":2.23606797749979},"223":{"tf":2.23606797749979},"224":{"tf":2.23606797749979},"230":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.0},"28":{"tf":1.0},"286":{"tf":1.4142135623730951},"288":{"tf":1.7320508075688772},"289":{"tf":1.7320508075688772},"290":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":2.8284271247461903},"295":{"tf":1.0},"297":{"tf":2.0},"298":{"tf":1.7320508075688772},"299":{"tf":1.4142135623730951},"300":{"tf":1.0},"308":{"tf":2.0},"36":{"tf":1.0},"39":{"tf":2.8284271247461903},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"145":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"313":{"tf":1.4142135623730951}}}},"df":17,"docs":{"0":{"tf":1.4142135623730951},"132":{"tf":1.0},"20":{"tf":1.0},"238":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"313":{"tf":2.23606797749979},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}}}},"df":5,"docs":{"262":{"tf":1.0},"303":{"tf":1.0},"313":{"tf":1.4142135623730951},"314":{"tf":1.0},"66":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"194":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"202":{"tf":1.0},"205":{"tf":1.0},"293":{"tf":1.0},"46":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"df":2,"docs":{"265":{"tf":1.0},"288":{"tf":1.7320508075688772}}}},"t":{"df":2,"docs":{"243":{"tf":1.0},"297":{"tf":1.0}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"10":{"tf":1.0}}},"3":{"df":1,"docs":{"10":{"tf":1.0}}},"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"205":{"tf":1.0}}}}}},"df":3,"docs":{"112":{"tf":2.6457513110645907},"113":{"tf":2.0},"205":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"131":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"292":{"tf":1.0},"74":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"249":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":10,"docs":{"104":{"tf":1.0},"234":{"tf":1.0},"290":{"tf":1.0},"292":{"tf":1.0},"293":{"tf":1.0},"299":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}}}},"x":{"df":1,"docs":{"143":{"tf":1.7320508075688772}}}}},"r":{"#":{"#":{"\"":{"#":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"286":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"190":{"tf":1.0},"23":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"14":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"201":{"tf":1.0},"202":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":10,"docs":{"177":{"tf":1.0},"225":{"tf":1.0},"233":{"tf":1.4142135623730951},"272":{"tf":1.0},"286":{"tf":1.0},"297":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"308":{"tf":1.0},"43":{"tf":1.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":5,"docs":{"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{".":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"52":{"tf":2.449489742783178}}},"df":4,"docs":{"206":{"tf":1.0},"219":{"tf":1.0},"272":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"132":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"12":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.0},"284":{"tf":1.0},"292":{"tf":1.0},"299":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":3,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"249":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":3,"docs":{"278":{"tf":1.0},"305":{"tf":1.0},"310":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"l":{"df":5,"docs":{"215":{"tf":1.0},"293":{"tf":1.0},"295":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.8284271247461903}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"292":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"281":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"290":{"tf":1.0},"293":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":13,"docs":{"102":{"tf":1.4142135623730951},"12":{"tf":1.0},"141":{"tf":1.0},"184":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":2.6457513110645907},"294":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":2.8284271247461903},"49":{"tf":1.4142135623730951},"59":{"tf":1.0},"66":{"tf":1.4142135623730951},"90":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":1,"docs":{"103":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":2,"docs":{"102":{"tf":1.0},"104":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"196":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0},"245":{"tf":1.0},"250":{"tf":1.0},"258":{"tf":1.0},"64":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"85":{"tf":1.0}},"u":{"c":{"df":3,"docs":{"132":{"tf":1.4142135623730951},"238":{"tf":1.0},"309":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"a":{"b":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"a":{"b":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"293":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"298":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":16,"docs":{"130":{"tf":1.0},"139":{"tf":2.0},"140":{"tf":1.7320508075688772},"188":{"tf":1.0},"195":{"tf":1.7320508075688772},"199":{"tf":1.0},"200":{"tf":1.0},"236":{"tf":1.0},"288":{"tf":1.7320508075688772},"289":{"tf":1.0},"290":{"tf":1.0},"298":{"tf":2.0},"52":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"a":{"df":1,"docs":{"18":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"c":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":5,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"132":{"tf":1.0},"18":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"298":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.0},"139":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"312":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"52":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"151":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"194":{"tf":1.0},"27":{"tf":1.0}}}},"df":11,"docs":{"10":{"tf":1.0},"130":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.4142135623730951},"217":{"tf":1.0},"233":{"tf":1.0},"238":{"tf":1.0},"292":{"tf":1.0},"298":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"312":{"tf":1.0},"313":{"tf":1.7320508075688772},"73":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":4,"docs":{"295":{"tf":1.0},"303":{"tf":1.0},"312":{"tf":1.0},"38":{"tf":1.0}}}},"i":{"df":4,"docs":{"271":{"tf":1.0},"299":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"290":{"tf":1.0}}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"221":{"tf":1.0},"298":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"295":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"260":{"tf":1.7320508075688772}}},"v":{"df":4,"docs":{"126":{"tf":1.0},"140":{"tf":1.0},"263":{"tf":1.0},"288":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"197":{"tf":1.4142135623730951},"212":{"tf":1.0},"288":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{".":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"35":{"tf":1.0}}}}},"df":7,"docs":{"13":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"299":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"177":{"tf":1.4142135623730951},"246":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":3,"docs":{"140":{"tf":1.0},"28":{"tf":1.0},"313":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"217":{"tf":1.0},"29":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":3.605551275463989}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"133":{"tf":1.0},"301":{"tf":1.0},"310":{"tf":1.0}}}}}}}}},"r":{"(":{"c":{"df":1,"docs":{"297":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":8,"docs":{"160":{"tf":2.0},"171":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"297":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"313":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"52":{"tf":1.0}}},"g":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"50":{"tf":2.0},"52":{"tf":2.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":12,"docs":{"232":{"tf":1.0},"26":{"tf":1.0},"262":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"303":{"tf":1.0},"313":{"tf":1.0},"314":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"232":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"r":{"df":41,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"123":{"tf":1.0},"138":{"tf":1.0},"160":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"205":{"tf":1.0},"211":{"tf":1.0},"224":{"tf":1.4142135623730951},"229":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.0},"238":{"tf":1.0},"266":{"tf":1.0},"285":{"tf":1.0},"293":{"tf":1.4142135623730951},"298":{"tf":1.0},"308":{"tf":1.7320508075688772},"46":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}},"e":{"'":{"d":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"(":{"\"":{"@":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"'":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"244":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"211":{"tf":1.0}}}},"i":{"d":{"df":1,"docs":{"289":{"tf":1.0}}},"df":0,"docs":{},"z":{"df":1,"docs":{"230":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"229":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":5,"docs":{"10":{"tf":1.0},"130":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"92":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"249":{"tf":1.0},"293":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.4142135623730951}},"e":{".":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":2,"docs":{"28":{"tf":1.0},"30":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":11,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"299":{"tf":1.0},"30":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.0}},"e":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"207":{"tf":1.0}}}},"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"92":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"193":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"28":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"187":{"tf":1.0},"92":{"tf":1.0}}},"u":{"3":{"2":{"df":1,"docs":{"190":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":30,"docs":{"10":{"tf":2.0},"11":{"tf":1.4142135623730951},"137":{"tf":1.0},"18":{"tf":1.0},"187":{"tf":1.7320508075688772},"190":{"tf":2.0},"205":{"tf":1.0},"21":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"234":{"tf":1.0},"244":{"tf":1.0},"26":{"tf":1.0},"289":{"tf":1.0},"30":{"tf":1.0},"307":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"t":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"'":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"294":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"136":{"tf":1.0},"205":{"tf":1.0}}}}},"df":4,"docs":{"16":{"tf":2.23606797749979},"292":{"tf":1.7320508075688772},"293":{"tf":2.449489742783178},"295":{"tf":2.23606797749979}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"294":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"294":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"264":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.0}}}},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"152":{"tf":1.0},"153":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"185":{"tf":1.0},"186":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"170":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"143":{"tf":1.0},"144":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"149":{"tf":1.0},"150":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"4":{"2":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"166":{"tf":1.0},"167":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"152":{"tf":1.0},"153":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"185":{"tf":1.0},"186":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"143":{"tf":1.0},"144":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"166":{"tf":1.0},"167":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"179":{"tf":1.0},"180":{"tf":1.4142135623730951}}}}}},"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"4":{"2":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"155":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"179":{"tf":1.0},"180":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"1":{"0":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":58,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"13":{"tf":2.0},"134":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"160":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"184":{"tf":1.7320508075688772},"187":{"tf":2.0},"190":{"tf":1.7320508075688772},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":2.0},"196":{"tf":1.4142135623730951},"207":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":2.0},"217":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"23":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":3.3166247903554},"293":{"tf":2.23606797749979},"294":{"tf":1.7320508075688772},"295":{"tf":2.6457513110645907},"297":{"tf":2.6457513110645907},"298":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"59":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"91":{"tf":2.0},"92":{"tf":2.0},"96":{"tf":2.23606797749979},"97":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"1":{"tf":1.0},"77":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":3,"docs":{"205":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"g":{"b":{"(":{"0":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"2":{"5":{"5":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":1,"docs":{"36":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"0":{"tf":1.0},"285":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.0},"299":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"285":{"tf":1.0},"292":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"190":{"tf":1.4142135623730951},"195":{"tf":1.0},"244":{"tf":1.4142135623730951},"281":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0},"301":{"tf":1.0},"33":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"272":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"312":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":5,"docs":{"243":{"tf":1.0},"256":{"tf":1.0},"313":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"194":{"tf":1.0},"289":{"tf":1.0}}}}}},"n":{"d":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"299":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"162":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"39":{"tf":1.0},"66":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"w":{"df":1,"docs":{"113":{"tf":1.0}}}},"t":{"c":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"s":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"161":{"tf":1.0},"164":{"tf":1.0},"194":{"tf":1.0},"276":{"tf":1.4142135623730951},"308":{"tf":1.0}}}},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":51,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"132":{"tf":1.7320508075688772},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"217":{"tf":1.0},"23":{"tf":1.0},"238":{"tf":1.0},"240":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":2.0},"248":{"tf":1.4142135623730951},"25":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":2.449489742783178},"254":{"tf":2.0},"255":{"tf":1.7320508075688772},"260":{"tf":1.4142135623730951},"261":{"tf":1.7320508075688772},"262":{"tf":1.0},"265":{"tf":2.23606797749979},"270":{"tf":1.4142135623730951},"272":{"tf":1.7320508075688772},"274":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"277":{"tf":1.0},"278":{"tf":1.4142135623730951},"281":{"tf":1.4142135623730951},"29":{"tf":1.0},"295":{"tf":1.0},"299":{"tf":1.4142135623730951},"30":{"tf":1.0},"301":{"tf":1.0},"303":{"tf":1.0},"310":{"tf":1.4142135623730951},"312":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":2.8284271247461903},"77":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"247":{"tf":1.7320508075688772},"258":{"tf":1.4142135623730951},"266":{"tf":1.0},"270":{"tf":1.4142135623730951},"272":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":10,"docs":{"104":{"tf":1.0},"171":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"237":{"tf":1.0},"269":{"tf":1.0},"271":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"293":{"tf":1.4142135623730951},"299":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"244":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":5,"docs":{"126":{"tf":1.0},"160":{"tf":1.4142135623730951},"212":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":1.0}}},".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"215":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"/":{"df":0,"docs":{},"j":{"df":1,"docs":{"299":{"tf":1.0}}}},"_":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"311":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"244":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":6,"docs":{"264":{"tf":1.0},"272":{"tf":1.0},"285":{"tf":1.0},"313":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}},"df":123,"docs":{"0":{"tf":3.1622776601683795},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.7320508075688772},"131":{"tf":1.0},"134":{"tf":2.0},"139":{"tf":2.0},"14":{"tf":1.7320508075688772},"140":{"tf":1.4142135623730951},"141":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":2.0},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":2.0},"178":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.7320508075688772},"189":{"tf":1.0},"19":{"tf":1.0},"190":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.4142135623730951},"198":{"tf":2.23606797749979},"199":{"tf":1.7320508075688772},"2":{"tf":1.0},"200":{"tf":1.0},"204":{"tf":1.4142135623730951},"206":{"tf":1.0},"207":{"tf":1.7320508075688772},"209":{"tf":1.4142135623730951},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"215":{"tf":1.0},"216":{"tf":1.0},"219":{"tf":1.4142135623730951},"22":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.4142135623730951},"233":{"tf":1.0},"235":{"tf":1.0},"239":{"tf":1.0},"24":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.0},"249":{"tf":1.0},"250":{"tf":1.4142135623730951},"263":{"tf":1.4142135623730951},"266":{"tf":1.0},"269":{"tf":1.0},"275":{"tf":1.7320508075688772},"28":{"tf":1.0},"284":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":2.23606797749979},"288":{"tf":1.7320508075688772},"289":{"tf":2.0},"290":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":3.3166247903554},"294":{"tf":2.23606797749979},"295":{"tf":2.6457513110645907},"296":{"tf":1.7320508075688772},"297":{"tf":2.6457513110645907},"298":{"tf":2.23606797749979},"299":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":2.23606797749979},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772},"96":{"tf":2.23606797749979},"98":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"238":{"tf":2.0},"269":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"276":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"264":{"tf":1.7320508075688772},"275":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"314":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"9":{"tf":2.0}}}},"s":{"a":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"259":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"137":{"tf":1.0},"208":{"tf":1.0},"254":{"tf":1.7320508075688772},"255":{"tf":1.0},"259":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"135":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":23,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"177":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"207":{"tf":1.4142135623730951},"243":{"tf":1.0},"246":{"tf":1.0},"261":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":2.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.0},"298":{"tf":1.7320508075688772},"66":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"279":{"tf":1.0}}}}}},"w":{"df":3,"docs":{"290":{"tf":1.0},"294":{"tf":1.0},"295":{"tf":1.4142135623730951}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"1":{".":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":4,"docs":{"52":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"288":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"201":{"tf":1.0},"289":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"123":{"tf":1.0},"23":{"tf":1.0},"263":{"tf":1.0},"311":{"tf":1.0},"313":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.7320508075688772}}}}}}},"df":2,"docs":{"180":{"tf":1.7320508075688772},"315":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"229":{"tf":1.0},"259":{"tf":1.0},"30":{"tf":2.0}}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"25":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":6,"docs":{"195":{"tf":1.0},"214":{"tf":2.0},"23":{"tf":1.0},"289":{"tf":1.0},"297":{"tf":1.0},"89":{"tf":1.0}},"t":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":21,"docs":{"119":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"141":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"209":{"tf":1.0},"217":{"tf":1.7320508075688772},"219":{"tf":1.0},"221":{"tf":1.0},"256":{"tf":1.0},"274":{"tf":1.0},"284":{"tf":1.0},"297":{"tf":1.0},"299":{"tf":1.0},"74":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"130":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":42,"docs":{"10":{"tf":1.7320508075688772},"110":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":2.23606797749979},"120":{"tf":1.0},"128":{"tf":1.0},"14":{"tf":1.4142135623730951},"140":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"20":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"272":{"tf":1.0},"273":{"tf":1.0},"278":{"tf":1.0},"282":{"tf":1.0},"283":{"tf":1.0},"288":{"tf":2.23606797749979},"289":{"tf":1.0},"292":{"tf":1.7320508075688772},"293":{"tf":1.7320508075688772},"294":{"tf":1.7320508075688772},"295":{"tf":2.0},"296":{"tf":1.0},"297":{"tf":1.0},"310":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":1.0},"313":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}},"n":{"df":1,"docs":{"295":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"272":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"272":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"210":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"220":{"tf":2.0},"221":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"c":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"223":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"293":{"tf":1.4142135623730951}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"297":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{".":{"_":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"295":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"297":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"223":{"tf":1.0},"90":{"tf":1.0}}}},":":{":":{"a":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"297":{"tf":1.0},"298":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"298":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":13,"docs":{"15":{"tf":1.4142135623730951},"194":{"tf":1.0},"211":{"tf":1.0},"213":{"tf":1.0},"215":{"tf":1.0},"220":{"tf":2.23606797749979},"231":{"tf":1.4142135623730951},"290":{"tf":1.0},"293":{"tf":1.4142135623730951},"298":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"59":{"tf":1.0},"89":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"238":{"tf":1.0}}}}}},"n":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"j":{"df":3,"docs":{"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"12":{"tf":1.0},"141":{"tf":1.0},"262":{"tf":1.0},"28":{"tf":1.0},"303":{"tf":1.0},"313":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":2.449489742783178},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"315":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":3,"docs":{"192":{"tf":1.0},"194":{"tf":1.0},"292":{"tf":1.0}}},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"r":{"d":{"df":6,"docs":{"100":{"tf":1.0},"104":{"tf":2.449489742783178},"105":{"tf":1.0},"46":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":2.23606797749979}},"e":{"'":{"df":1,"docs":{"100":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.7320508075688772}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"102":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"101":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"104":{"tf":1.4142135623730951},"299":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":3,"docs":{"1":{"tf":1.0},"6":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"261":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"252":{"tf":1.0},"253":{"tf":1.0},"262":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"'":{"df":1,"docs":{"96":{"tf":1.0}}},"(":{"\"":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"293":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"295":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"df":1,"docs":{"293":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"196":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"196":{"tf":1.0},"295":{"tf":1.0}}}}}},".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"200":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"96":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"200":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},":":{":":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{}},"\\":{"_":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"193":{"tf":1.0},"220":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"_":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}},"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"a":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"\"":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"295":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"295":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":36,"docs":{"10":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"193":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.0},"200":{"tf":2.23606797749979},"214":{"tf":1.4142135623730951},"23":{"tf":1.0},"232":{"tf":1.4142135623730951},"238":{"tf":1.0},"253":{"tf":1.0},"259":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"262":{"tf":1.0},"264":{"tf":2.0},"295":{"tf":1.0},"30":{"tf":2.8284271247461903},"300":{"tf":1.0},"311":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.4142135623730951},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"&":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"193":{"tf":1.0}}},"df":8,"docs":{"111":{"tf":1.0},"13":{"tf":1.0},"193":{"tf":2.8284271247461903},"196":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"220":{"tf":2.23606797749979},"295":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"151":{"tf":1.0}}}}}},"h":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":1,"docs":{"43":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"215":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":8,"docs":{"111":{"tf":1.0},"200":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"298":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}}},"df":2,"docs":{"263":{"tf":1.0},"265":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"130":{"tf":1.0},"194":{"tf":2.0},"195":{"tf":2.0},"205":{"tf":1.0},"292":{"tf":2.23606797749979},"293":{"tf":1.7320508075688772},"294":{"tf":2.0},"295":{"tf":1.0},"299":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"91":{"tf":1.0}}},"p":{"df":3,"docs":{"124":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"e":{"df":1,"docs":{"191":{"tf":2.449489742783178}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"287":{"tf":1.0},"293":{"tf":1.0}}}}}},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"299":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":18,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"133":{"tf":1.0},"14":{"tf":1.0},"199":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"233":{"tf":1.0},"272":{"tf":1.4142135623730951},"289":{"tf":1.0},"29":{"tf":1.0},"295":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":9,"docs":{"197":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.4142135623730951},"293":{"tf":1.0},"295":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"289":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"198":{"tf":1.4142135623730951},"299":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"11":{"tf":1.0},"204":{"tf":1.0},"222":{"tf":1.0},"23":{"tf":1.0},"240":{"tf":1.0},"295":{"tf":1.4142135623730951},"72":{"tf":1.0},"77":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"19":{"tf":1.0},"249":{"tf":1.0},"290":{"tf":1.0},"299":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}},"i":{"df":9,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"177":{"tf":1.0},"194":{"tf":1.0},"205":{"tf":1.0},"23":{"tf":1.0},"285":{"tf":1.0},"286":{"tf":1.0},"288":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"292":{"tf":1.0},"294":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"171":{"tf":1.0},"196":{"tf":1.4142135623730951},"221":{"tf":1.0},"276":{"tf":1.0},"47":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"198":{"tf":1.0},"221":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":5,"docs":{"104":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":2.6457513110645907},"206":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"216":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"215":{"tf":1.4142135623730951},"232":{"tf":1.0},"312":{"tf":1.0}}}}},"l":{"a":{"b":{"df":2,"docs":{"289":{"tf":2.0},"290":{"tf":1.0}}},"df":0,"docs":{}},"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"151":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"184":{"tf":2.0},"207":{"tf":1.0},"233":{"tf":1.4142135623730951},"292":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"289":{"tf":1.0},"299":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"290":{"tf":1.0}}},"w":{"df":1,"docs":{"104":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"132":{"tf":1.0},"133":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"279":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"285":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"235":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"198":{"tf":1.0},"212":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.0},"130":{"tf":1.0},"196":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"293":{"tf":1.0}}},"i":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":2,"docs":{"139":{"tf":1.0},"299":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"&":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"169":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"4":{"2":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"202":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"295":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"143":{"tf":2.0},"144":{"tf":2.23606797749979}}}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"212":{"tf":1.0},"216":{"tf":1.7320508075688772},"288":{"tf":1.0},"299":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":6,"docs":{"104":{"tf":1.0},"198":{"tf":1.0},"289":{"tf":1.0},"293":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"85":{"tf":2.6457513110645907}},"e":{"'":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"312":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"134":{"tf":1.0},"140":{"tf":1.0},"190":{"tf":1.0},"217":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"225":{"tf":1.0},"285":{"tf":1.0},"289":{"tf":1.0},"292":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":32,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"272":{"tf":1.0},"281":{"tf":1.0},"29":{"tf":1.0},"300":{"tf":1.0},"304":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"292":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"281":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"272":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"315":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"18":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"12":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"c":{"df":2,"docs":{"190":{"tf":1.0},"285":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"130":{"tf":1.0},"232":{"tf":1.0},"288":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":11,"docs":{"0":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"223":{"tf":1.0},"238":{"tf":1.7320508075688772},"284":{"tf":1.0},"293":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0}},"i":{"df":13,"docs":{"192":{"tf":1.0},"193":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"201":{"tf":1.0},"204":{"tf":1.4142135623730951},"213":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.0},"233":{"tf":1.0},"297":{"tf":1.4142135623730951},"30":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"104":{"tf":1.0}},"i":{"df":1,"docs":{"229":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"297":{"tf":1.0}}}}}}},"df":3,"docs":{"11":{"tf":1.0},"130":{"tf":1.7320508075688772},"297":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":2.0}},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"312":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":19,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"308":{"tf":1.7320508075688772},"33":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"\"":{".":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"\"":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"'":{".":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"'":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"'":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"272":{"tf":1.0},"30":{"tf":1.4142135623730951},"305":{"tf":1.0}}},"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":2,"docs":{"263":{"tf":1.0},"265":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"238":{"tf":1.0},"285":{"tf":1.0},"79":{"tf":1.0}}}},"l":{"df":2,"docs":{"250":{"tf":1.0},"263":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"b":{"df":1,"docs":{"295":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"140":{"tf":2.0},"288":{"tf":1.7320508075688772}}}}}}}},"df":10,"docs":{"140":{"tf":1.0},"190":{"tf":1.0},"23":{"tf":1.0},"288":{"tf":3.1622776601683795},"289":{"tf":1.4142135623730951},"290":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"302":{"tf":1.4142135623730951}}}},"n":{"c":{"df":1,"docs":{"285":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"190":{"tf":1.0},"84":{"tf":1.0}}}}},"r":{"d":{"df":12,"docs":{"134":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"225":{"tf":1.0},"292":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.0},"312":{"tf":1.7320508075688772},"64":{"tf":2.0},"66":{"tf":2.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":21,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"171":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"217":{"tf":3.7416573867739413},"218":{"tf":1.0},"25":{"tf":1.4142135623730951},"261":{"tf":1.0},"288":{"tf":1.0},"295":{"tf":1.4142135623730951},"33":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"74":{"tf":1.0},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"61":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"208":{"tf":1.0},"266":{"tf":1.0},"49":{"tf":2.449489742783178},"59":{"tf":2.23606797749979},"62":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"123":{"tf":1.4142135623730951},"294":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"c":{">":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"204":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":13,"docs":{"191":{"tf":1.0},"192":{"tf":1.0},"196":{"tf":1.4142135623730951},"204":{"tf":2.0},"206":{"tf":1.0},"219":{"tf":1.4142135623730951},"237":{"tf":1.0},"293":{"tf":1.7320508075688772},"295":{"tf":1.7320508075688772},"299":{"tf":1.0},"30":{"tf":1.0},"85":{"tf":2.6457513110645907},"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"59":{"tf":1.0}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"6":{"4":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"134":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{":":{"a":{"d":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"9":{"9":{"1":{"df":0,"docs":{},"e":{"7":{"d":{"1":{"c":{"a":{"9":{"b":{"df":0,"docs":{},"f":{"9":{"c":{"0":{"c":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"a":{"d":{"7":{"0":{"b":{"a":{"4":{"8":{"7":{"8":{"5":{"b":{"9":{"a":{"8":{"df":0,"docs":{},"f":{"df":1,"docs":{"244":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"h":{"5":{"6":{"df":0,"docs":{},"e":{"5":{"df":0,"docs":{},"e":{"4":{"6":{"4":{"b":{"0":{"df":0,"docs":{},"e":{"7":{"df":0,"docs":{},"f":{"c":{"2":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"155":{"tf":1.0},"158":{"tf":1.0}}}}},"r":{"c":{":":{":":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"0":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"292":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"292":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"293":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"308":{"tf":1.0},"64":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"130":{"tf":1.0},"245":{"tf":1.0},"265":{"tf":1.0},"312":{"tf":1.0},"46":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":11,"docs":{"132":{"tf":1.0},"139":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"238":{"tf":1.0},"266":{"tf":1.0},"279":{"tf":1.0},"286":{"tf":1.0},"297":{"tf":1.0},"77":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"272":{"tf":1.0},"288":{"tf":1.4142135623730951},"289":{"tf":1.4142135623730951},"295":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772}}}}},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"233":{"tf":1.0},"298":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"287":{"tf":1.0},"289":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}}},"df":28,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"135":{"tf":1.0},"15":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"18":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.7320508075688772},"198":{"tf":1.0},"199":{"tf":1.4142135623730951},"206":{"tf":1.0},"219":{"tf":1.4142135623730951},"25":{"tf":1.0},"286":{"tf":1.4142135623730951},"292":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"298":{"tf":1.0},"299":{"tf":1.0},"30":{"tf":2.6457513110645907},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"89":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"256":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":2,"docs":{"174":{"tf":1.0},"178":{"tf":1.0}}},".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"101":{"tf":1.0},"104":{"tf":1.0}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"211":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"294":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":39,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"100":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.4142135623730951},"151":{"tf":1.0},"171":{"tf":2.449489742783178},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"177":{"tf":3.1622776601683795},"178":{"tf":1.7320508075688772},"179":{"tf":1.4142135623730951},"180":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"197":{"tf":2.449489742783178},"198":{"tf":1.7320508075688772},"199":{"tf":1.0},"201":{"tf":1.0},"211":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.7320508075688772},"232":{"tf":1.0},"28":{"tf":1.0},"285":{"tf":1.4142135623730951},"286":{"tf":1.4142135623730951},"292":{"tf":3.4641016151377544},"294":{"tf":1.4142135623730951},"297":{"tf":1.0},"30":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"223":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":3,"docs":{"127":{"tf":1.0},"132":{"tf":1.0},"295":{"tf":1.0}},"e":{"df":1,"docs":{"30":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"286":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},"df":31,"docs":{"100":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"15":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.7320508075688772},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"238":{"tf":1.0},"285":{"tf":1.0},"290":{"tf":1.4142135623730951},"293":{"tf":2.23606797749979},"295":{"tf":1.4142135623730951},"297":{"tf":1.7320508075688772},"36":{"tf":1.0},"39":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"111":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":2.0},"195":{"tf":1.0},"196":{"tf":2.0},"205":{"tf":3.0},"289":{"tf":1.0},"299":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"206":{"tf":1.0},"216":{"tf":1.0},"23":{"tf":1.4142135623730951},"240":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"194":{"tf":1.0},"195":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"295":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"194":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"108":{"tf":1.0},"270":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"92":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"211":{"tf":1.0},"225":{"tf":1.0},"295":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"221":{"tf":1.0},"84":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"12":{"tf":1.0},"195":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"193":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"137":{"tf":1.0},"194":{"tf":1.0},"259":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"278":{"tf":1.0},"279":{"tf":1.0},"67":{"tf":1.0}}}},"m":{"(":{".":{".":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"207":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"207":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"_":{"df":1,"docs":{"30":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"_":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"211":{"tf":1.4142135623730951},"229":{"tf":1.0},"9":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"216":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":47,"docs":{"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"138":{"tf":1.7320508075688772},"139":{"tf":2.23606797749979},"140":{"tf":2.449489742783178},"141":{"tf":1.0},"168":{"tf":1.0},"188":{"tf":1.0},"190":{"tf":1.4142135623730951},"207":{"tf":1.0},"218":{"tf":1.4142135623730951},"237":{"tf":1.0},"242":{"tf":1.4142135623730951},"249":{"tf":1.0},"250":{"tf":1.0},"256":{"tf":1.0},"271":{"tf":1.0},"272":{"tf":1.0},"275":{"tf":1.0},"292":{"tf":1.0},"295":{"tf":1.0},"302":{"tf":1.0},"312":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":2.6457513110645907},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":15,"docs":{"10":{"tf":1.0},"104":{"tf":1.0},"12":{"tf":1.