
BGM_INDEX_TO_NAME = {
  0x0000: "defaultse.bms", # Silence
  0x0001: "i_link.bms", # Outset
  0x0002: "get.bms", # Good item get jingle
  0x0003: "goma_a.bms", # Gohma phase 1
  0x0004: "enemy2.bms", # Fight with a common land enemy
  0x0005: "boco.bms", # Kalle Demos
  0x0006: "d_ryumt.bms", # Dragon Roost Cavern
  0x0007: "i_maju.bms", # Inside Forsaken Fortress 1
  0x0008: "house.bms", # Inside someone's house
  0x0009: "open_box.bms", # Dramatic chest open build up
  0x000A: "die_link.bms", # Game over
  0x000B: "sea_game.bms", # Boating course minigame
  0x000C: "sea_goal.bms", # Won the boating course minigame
  0x000D: "sea_fail.bms", # Lost the boating course minigame
  0x000E: "i_link2.bms", # Outset (exact duplicate)
  0x000F: "i_maju_j.bms", # Got thrown in Forsaken Fortress jail
  0x0010: "goma_b.bms", # Gohma phase 2
  0x0011: "house_t.bms", # Training with Orca
  0x0012: "tetra_meet.bms", # First meeting with Tetra
  0x0013: "enemy_comes.bms", # Kargarocs drop Bokoblins into Fairy Woods
  0x0014: "bird.bms", # Helmaroc
  0x0015: "tower.bms", # Helmaroc chasing you up the tower
  0x0016: "find_ttr.bms", # See Tetra hanging from a tree
  0x0017: "i_linkf.bms", # Fairy Woods
  0x0018: "house_g.bms", # Orca and Sturgeon's house
  0x0019: "mboss.bms", # Land miniboss
  0x001A: "mboss_s.bms", # Land miniboss (no intro)
  0x001B: "store.bms", # Beedle's shop
  0x001C: "sea_enemy.bms", # Fight with a common sea enemy
  0x001D: "sea_dawn.bms", # Sun rises on the Great Sea
  0x001E: "select.bms", # File select
  0x001F: "okmedori.bms", # Unused trumpet jingle 1
  0x0020: "okmacole.bms", # Unused trumpet jingle 2
  0x0021: "takt_mcl.bms", # Wind God's Aria by Makar, played when destroying a song stone
  0x0022: "takt_mdr.bms", # Earth God's Lyric by Medli, played when destroying a song stone
  0x0023: "d_amosu.bms", # Gohdan
  0x0024: "get_h.bms", # Heart container get jingle
  0x0025: "get_s.bms", # Meh item get jingle
  0x0026: "d_forest.bms", # Forbidden Woods
  0x0027: "get_song.bms", # Song get jingle
  0x0028: "kaminoto.bms", # Tower of the Gods
  0x0029: "rane.bms", # Molgera
  0x002A: "pirate.bms", # Riding on the outside of the pirate ship to Forsaken Fortress
  0x002B: "e_diocta.bms", # Sea miniboss
  0x002C: "pirate_c.bms", # Inside the pirate ship
  0x002D: "d_earth.bms", # Earth Temple
  0x002E: "sea.bms", # Sailing on the Great Sea
  0x002F: "d_wind.bms", # Wind Temple
  0x0030: "takt_dn.bms", # Song of Passing jingle
  0x0031: "takt_wnd.bms", # Wind's Requiem jingle
  0x0032: "takt_wrp.bms", # Ballad of Gales jingle
  0x0033: "tetra_meet_b.bms", # Unused Tetra theme
  0x0034: "hyrul_of.bms", # Hyrule Castle, asleep
  0x0035: "hyrul_on.bms", # Hyrule Castle, awake
  0x0036: "next_dry.bms", # Makar practicing the violin, heard from outside the cave
  0x0037: "next_wet.bms", # Makar practicing the violin, heard from inside the cave
  0x0038: "i_linkin.bms", # Outset with new game intro
  0x0039: "i_mori.bms", # Forest Haven Island
  0x003A: "i_ryu.bms", # Dragon Roost Island
  0x003B: "i_taura.bms", # Windfall Island
  0x003C: "sea_strm.bms", # Sailing on the Great Sea during endless night
  0x003D: "pirate_5.bms", # Pirates robbing the bomb shop
  0x003E: "house_t2.bms", # Training with Orca alternate (unused?, has a few extra instruments)
  0x003F: "i_moridk.bms", # Inside Forest Haven
  0x0040: "drug.bms", # Doc Bandam and Hollo's shops
  0x0041: "p_ganon1.bms", # Phantom Ganon (with intro, at Forsaken Fortress)
  0x0042: "d_ganon1.bms", # Ganon's Tower
  0x0043: "d_ganon2.bms", # Ganon's Tower maze
  0x0044: "baachan.bms", # Grandma's theme
  0x0045: "dekpinch.bms", # Deku Tree being attacked by ChuChus
  0x0046: "e_dioct2.bms", # Sea miniboss (no intro)
  0x0047: "p_ganon2.bms", # Phantom Ganon (no intro, in Ganon's Tower, or resuming after interruption at FF)
  0x0048: "bigpow.bms", # Jalhalla
  0x0049: "p_bigpow.bms", # Rematch Jalhalla
  0x004A: "p_boco.bms", # Rematch Kalle Demos
  0x004B: "p_goma_a.bms", # Rematch Gohma phase 1
  0x004C: "p_rane.bms", # Rematch Molgera fight
  0x004D: "e_ganon.bms", # Ganondorf fight
  0x004E: "mastersword.bms", # Pulling out the Master Sword
  0x004F: "get_perl.bms", # Pearl get jingle
  0x0050: "sea_game.bms", # Bird-man contest minigame (same as boating course)
  0x0051: "sea_goal.bms", # Won the bird-man contest minigame (same as boating course)
  0x0052: "sea_fail.bms", # Lost the bird-man contest minigame (same as boating course)
  0x0053: "elf.bms", # Fairy Fountain
  0x0054: "p_goma_b.bms", # Rematch Gohma phase 2
  0x0055: "i_link3.bms", # Outset alternate
  0x0056: "death_vl.bms", # Hyrule (very quiet and slow)
  0x0057: "jaboo.bms", # Jabun's cave, and the entrance room of Earth/Wind Temples
  0x0058: "subdun.bms", # Secret caves
  0x0059: "kugutu1.bms", # Puppet Ganon phase 1
  0x005A: "kugutu2.bms", # Puppet Ganon phase 2
  0x005B: "kugutu3.bms", # Puppet Ganon phase 3
  0x005C: "taraba_intro.bms", # Puppet Ganon fake victory fanfare
  0x005D: "get_box.bms", # Salvage get jingle
  0x005E: "i_maju.bms", # Inside Forsaken Fortress 2/3 (same as FF1)
  0x005F: "tak8_mcl.bms", # Wind God's Aria by Makar, played when returning to Molgera's room after defeating it
  0x0060: "tak8_mdr.bms", # Earth God's Lyric by Medli, played when returning to Jalhalla's room after defeating it
}

# TODO: I might need a more sophisticated system for keeping track of needed wave banks. instead of just the first/second index needed, it would be better to keep track of the specific .aw files needed for each BGM/stage/island, and then completely regenerate the list of first/second wave bank indexes from scratch based on what is needed for this particular randomizer seed.

FIRST_SCENE_WAVE_NEEDED_FOR_BGM = {
  #"i_linkf.bms":      0x05, # ?? doesn't work
  "i_taura.bms":      0x0B,
  "i_ryu.bms":        0x19,
  "i_mori.bms":       0x0F,
  "i_moridk.bms":     0x0F,
  
  "jaboo.bms":        0x22, # There's quite a few possibilities that would work here
  "subdun.bms":       0x26, # Many possibilities
  "elf.bms":          0x24,
  
  "store.bms":        0x10,
  "drug.bms":         0x16,
  
  #"d_ryumt.bms":      0x01, # test
  "d_forest.bms":     0x03,
  "kaminoto.bms":     0x06,
  #"i_maju.bms":       0x02, # doesn't sound necessary?
  "d_earth.bms":      0x12,
  "d_wind.bms":       0x08,
  "d_ganon1.bms":     0x17,
  "d_ganon2.bms":     0x18,
  
  "p_goma_a.bms":     0x1C,
  "p_goma_b.bms":     0x1C,
  "p_rane.bms":       0x1F,
  "taraba_intro.bms": 0x2A,
  
  "hyrul_of.bms":     0x14,
  "hyrul_on.bms":     0x14,
  #"death_vl.bms":     0x25, # doesn't sound necessary? hard to tell with how quiet it is
  
  "next_dry.bms":     0x0F,
  "takt_mcl.bms":     0x08,
  "tak8_mcl.bms":     0x08,
  "takt_mdr.bms":     0x12,
  "tak8_mdr.bms":     0x12,
  
  # TODO
}

# TODO: it seems the game might not load the 2nd scene waves until a second after the player enters the room? TODO: check if this breaks tracks that play immediately when entering the room
SECOND_SCENE_WAVE_NEEDED_FOR_BGM = {
  "mboss.bms":        0x05,
  "mboss_s.bms":      0x05,
  "e_diocta.bms":     0x06,
  "e_dioct2.bms":     0x06,
  "p_ganon1.bms":     0x0A,
  "p_ganon2.bms":     0x0A,
  
  "rane.bms":         0x09,
  "bigpow.bms":       0x0B,
  
  # not sure if this is necessary...?
  #"goma_b.bms":       0x01,
  
  "tetra_meet.bms":   0x03,
  
  # TODO
}

FIRST_SCENE_WAVE_NEEDED_FOR_STAGE = {
  "M_DragB": 0x01, # Gohma and Valoo's noises
  "GanonM":  0x18, # Ganon's Tower Phantom Ganon fight needs Phantom Ganon's voice
  "GanonJ":  0x18, # Ganon's Tower maze needs Phantom Ganon's voice
  
  # TODO
}

FIRST_SCENE_WAVE_NEEDED_FOR_ISLAND = {
   1: 0x02, # FF needs Phantom Ganon's voice
  11: 0x0B, # Windfall needs NPC voices
  
  # TODO
}

SECOND_SCENE_WAVE_NEEDED_FOR_STAGE = {
  # TODO
}

SECOND_SCENE_WAVE_NEEDED_FOR_ISLAND = {
  # TODO
}

BGMS_HARDCODED_TO_PLAY_FOR_STAGE = {
  "M_Dra09": ["mboss.bms", "mboss_s.bms"],
  "M_DragB": ["goma_a.bms", "goma_b.bms"],
  
  "kinMB": ["mboss.bms", "mboss_s.bms"],
  "kinBOSS": ["boco.bms"],
  
  "SirenMB": ["mboss.bms", "mboss_s.bms"],
  "SirenB": ["d_amosu.bms"],
  
  "M2tower": ["bird.bms", "tower.bms"],
  
  "M_DaiMB": ["mboss.bms", "mboss_s.bms"],
  "M_DaiB": ["bigpow.bms"],
  
  "kazeMB": ["mboss.bms", "mboss_s.bms"],
  "kazeB": ["rane.bms"],
  
  "Xboss0": ["p_goma_a.bms", "p_goma_b.bms"],
  "Xboss1": ["p_boco.bms"],
  "Xboss2": ["p_bigpow.bms"],
  "Xboss3": ["p_rane.bms"],
  "GanonM": ["p_ganon2.bms"],
  "GanonJ": ["p_ganon2.bms"],
  "GanonK": ["kugutu1.bms", "kugutu2.bms", "kugutu3.bms", "taraba_intro.bms"],
  "GTower": ["e_ganon.bms"],
  
  # TODO non-boss stuff
  # e.g. playing songs with medli/makar to destroy song stones in earth/wind temple.
}

BGMS_HARDCODED_TO_PLAY_FOR_ISLAND = {
   1: ["p_ganon1.bms", "p_ganon2.bms"],
  
  # TODO
}

# TODO: see if there's any way to allow sub BGMs to be mixed with regular BGMs.
# things that are sub bgms:
# * miniboss music
# * item get jingles
# * song play jingles
# specifically:
#[
#  "mboss.bms",
#  "mboss_s.bms",
#  
#  "e_diocta.bms"
#  "e_dioct2.bms"
#  
#  "p_ganon1.bms"
#  "p_ganon2.bms"
#  
#  "get_perl.bms",
#  "get_box.bms",
#  "open_box.bms",
#  "get_h.bms",
#  "get_s.bms",
#  "get.bms",
#  "get_song.bms",
#  
#  "takt_dn.bms",
#  "takt_wnd.bms",
#  "takt_wrp.bms",
#]

# TODO: test what happens when a randomized miniboss BGM gets interrupted by getting an item. does it properly resume the old BGM?

# TODO: see if common enemy combat music can be mixed with regular BGMs

BGM_RANDOMIZATION_GROUPS = [
  # Short jingles and fanfares
  [
    "get.bms",
    "get_h.bms",
    "get_s.bms",
    "get_song.bms",
    "get_perl.bms",
    
    "open_box.bms",
    "get_box.bms",
    "mastersword.bms",
    
    "sea_goal.bms",
    "sea_fail.bms",
    
    "takt_wnd.bms",
    "takt_wrp.bms",
    "takt_dn.bms",
  ],
  
  # Long, but non-looping sounds
  [
    "die_link.bms",
    "enemy_comes.bms",
    "sea_dawn.bms",
    
    "okmedori.bms",
    "okmacole.bms",
    "takt_mcl.bms",
    "takt_mdr.bms",
    "tak8_mcl.bms",
    "tak8_mdr.bms",
    "next_dry.bms",
    "next_wet.bms",
    
    "find_ttr.bms",
  ],
  
  # Common enemy combat music
  [
    "enemy2.bms",
    "sea_enemy.bms",
  ],
  
  # Miniboss combat music
  [
    "mboss.bms",
    "mboss_s.bms",
    
    "e_diocta.bms",
    "e_dioct2.bms",
    
    "p_ganon1.bms",
    "p_ganon2.bms",
  ],
  
  # Boss/miniboss combat music
  [
    "goma_a.bms",
    "goma_b.bms",
    "p_goma_a.bms",
    "p_goma_b.bms",
    
    "boco.bms",
    "p_boco.bms",
    
    "d_amosu.bms",
    
    "bird.bms",
    "tower.bms",
    
    "bigpow.bms",
    "p_bigpow.bms",
    
    "rane.bms",
    "p_rane.bms",
    
    "kugutu1.bms",
    "kugutu2.bms",
    "kugutu3.bms",
    "taraba_intro.bms",
    
    "e_ganon.bms",
  ],
  
  # Normal background music
  [
    # Islands
    "i_linkin.bms",
    "i_link.bms",
    #"i_link2.bms", # Exact duplicate of i_link.bms, not randomized
    "i_link3.bms",
    "i_taura.bms",
    "i_ryu.bms",
    "i_mori.bms",
    
    # Inside places
    "house.bms",
    "store.bms",
    "baachan.bms",
    "drug.bms",
    "elf.bms",
    "jaboo.bms",
    "subdun.bms",
    "i_moridk.bms",
    "dekpinch.bms",
    "house_g.bms",
    "house_t.bms",
    "house_t2.bms",
    "i_linkf.bms",
    
    # Pirates
    "pirate.bms",
    "pirate_c.bms",
    "pirate_5.bms",
    "tetra_meet.bms",
    "tetra_meet_b.bms",
    
    # Hyrule
    "hyrul_of.bms",
    "hyrul_on.bms",
    "death_vl.bms",
    # TODO: try to raise the volume of hyrul_of.bms and death_vl.bms
    
    # Dungeons
    "d_ryumt.bms",
    "d_forest.bms",
    "kaminoto.bms",
    "i_maju.bms",
    "i_maju_j.bms",
    "d_earth.bms",
    "d_wind.bms",
    "d_ganon1.bms",
    "d_ganon2.bms",
    
    # Sea music
    "sea.bms",
    "sea_strm.bms",
    "sea_game.bms",
    "select.bms",
  ],
]

SPECIAL_BGM_ID_TO_BGM_INDEX = {
  0x0105: 0x0005,
  0x0110: 0x0014,
  0x0111: 0x0014,
  0x0112: 0x0014,
  0x0115: 0x0015,
  0x0120: 0x0023,
  0x0121: 0x0023,
  0x0122: 0x0023,
  0x0123: 0x0023,
  0x0124: 0x0029,
  0x0125: 0x0028,
  0x0126: 0x0028,
  0x0130: 0x0042,
  0x0131: 0x0042,
  0x0132: 0x0042,
  0x0133: 0x0042,
  0x0140: 0x0048,
  0x0150: 0x0049,
  0x0151: 0x004A,
  0x0152: 0x004C,
}

# TODO: check if this creates memory issues when large songs replace small songs in low-memory areas such as chuchu cave
