/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Flecs", "index.html", [
    [ "Documentation", "md_docs_2Docs.html", [
      [ "What is an Entity Component System?", "index.html#autotoc_md0", null ],
      [ "Try it out!", "index.html#autotoc_md1", null ],
      [ "Documentation", "index.html#autotoc_md2", null ],
      [ "Performance", "index.html#autotoc_md3", null ],
      [ "Show me the code!", "index.html#autotoc_md4", null ],
      [ "Projects using Flecs", "index.html#autotoc_md5", [
        [ "Tempest Rising", "index.html#autotoc_md6", null ],
        [ "Territory Control", "index.html#autotoc_md7", null ],
        [ "The Forge", "index.html#autotoc_md8", null ],
        [ "Sol Survivor", "index.html#autotoc_md9", null ],
        [ "Equilibrium Engine", "index.html#autotoc_md10", null ],
        [ "Gravitas", "index.html#autotoc_md11", null ],
        [ "After Sun", "index.html#autotoc_md12", null ],
        [ "Tower defense (open source demo)", "index.html#autotoc_md13", null ],
        [ "Procedural City (open source demo)", "index.html#autotoc_md14", null ]
      ] ],
      [ "Resources", "index.html#autotoc_md15", [
        [ "Resources provided by the community :heart:", "index.html#autotoc_md16", null ],
        [ "Flecs around the web", "index.html#autotoc_md17", null ]
      ] ],
      [ "Flecs Hub", "index.html#autotoc_md18", null ],
      [ "Language bindings", "index.html#autotoc_md19", null ],
      [ "Getting Started", "md_docs_2Docs.html#autotoc_md21", null ],
      [ "Manuals", "md_docs_2Docs.html#autotoc_md22", null ],
      [ "API reference", "md_docs_2Docs.html#autotoc_md23", null ],
      [ "Examples", "md_docs_2Docs.html#autotoc_md24", null ],
      [ "Demos", "md_docs_2Docs.html#autotoc_md25", null ],
      [ "Articles", "md_docs_2Docs.html#autotoc_md26", null ]
    ] ],
    [ "Flecs Quickstart", "md_docs_2Quickstart.html", [
      [ "Building Flecs", "md_docs_2Quickstart.html#autotoc_md28", [
        [ "Dynamic linking", "md_docs_2Quickstart.html#autotoc_md29", null ],
        [ "Building with CMake", "md_docs_2Quickstart.html#autotoc_md30", null ],
        [ "Building with Bake", "md_docs_2Quickstart.html#autotoc_md31", null ],
        [ "Running tests (bake)", "md_docs_2Quickstart.html#autotoc_md32", [
          [ "Running tests (cmake, experimental)", "md_docs_2Quickstart.html#autotoc_md33", null ]
        ] ],
        [ "Emscripten", "md_docs_2Quickstart.html#autotoc_md34", null ],
        [ "Addons", "md_docs_2Quickstart.html#autotoc_md35", null ]
      ] ],
      [ "Concepts", "md_docs_2Quickstart.html#autotoc_md36", [
        [ "World", "md_docs_2Quickstart.html#autotoc_md37", null ],
        [ "Entity", "md_docs_2Quickstart.html#autotoc_md38", null ],
        [ "Id", "md_docs_2Quickstart.html#autotoc_md39", null ],
        [ "Component", "md_docs_2Quickstart.html#autotoc_md40", null ],
        [ "Tag", "md_docs_2Quickstart.html#autotoc_md41", null ],
        [ "Pair", "md_docs_2Quickstart.html#autotoc_md42", null ],
        [ "Hierarchies", "md_docs_2Quickstart.html#autotoc_md43", null ],
        [ "Instancing", "md_docs_2Quickstart.html#autotoc_md44", null ],
        [ "Type", "md_docs_2Quickstart.html#autotoc_md45", null ],
        [ "Singleton", "md_docs_2Quickstart.html#autotoc_md46", null ],
        [ "Filter", "md_docs_2Quickstart.html#autotoc_md47", null ],
        [ "Query", "md_docs_2Quickstart.html#autotoc_md48", null ],
        [ "System", "md_docs_2Quickstart.html#autotoc_md49", null ],
        [ "Pipeline", "md_docs_2Quickstart.html#autotoc_md50", null ],
        [ "Observer", "md_docs_2Quickstart.html#autotoc_md51", null ],
        [ "Module", "md_docs_2Quickstart.html#autotoc_md52", null ]
      ] ]
    ] ],
    [ "FAQ", "md_docs_2FAQ.html", [
      [ "What is an ECS?", "md_docs_2FAQ.html#autotoc_md54", null ],
      [ "Why is Flecs written in C?", "md_docs_2FAQ.html#autotoc_md55", null ],
      [ "Can I use Flecs with C++14 or higher?", "md_docs_2FAQ.html#autotoc_md56", null ],
      [ "Can I use std::vector or other types inside components?", "md_docs_2FAQ.html#autotoc_md57", null ],
      [ "What is an archetype?", "md_docs_2FAQ.html#autotoc_md58", null ],
      [ "How does Flecs compare with EnTT?", "md_docs_2FAQ.html#autotoc_md59", null ],
      [ "Is Flecs used for commercial projects?", "md_docs_2FAQ.html#autotoc_md60", null ],
      [ "Why are queries slow?", "md_docs_2FAQ.html#autotoc_md61", null ],
      [ "Why are queries taking up a lot of RAM?", "md_docs_2FAQ.html#autotoc_md62", null ],
      [ "Why is my system called multiple times per frame?", "md_docs_2FAQ.html#autotoc_md63", null ],
      [ "Can Flecs be compiled to web assembly?", "md_docs_2FAQ.html#autotoc_md64", null ],
      [ "Why am I getting an “use of undeclared identifier 'FLECS_ID …’” compiler error?", "md_docs_2FAQ.html#autotoc_md65", null ],
      [ "Why are my entity ids so large?", "md_docs_2FAQ.html#autotoc_md66", null ],
      [ "What is the difference between add & set? Why do both exist?", "md_docs_2FAQ.html#autotoc_md67", null ],
      [ "Can Flecs serialize components?", "md_docs_2FAQ.html#autotoc_md68", null ],
      [ "Why is Flecs so large?", "md_docs_2FAQ.html#autotoc_md69", null ],
      [ "Why does the explorer not work?", "md_docs_2FAQ.html#autotoc_md70", null ],
      [ "Does the explorer collect data from my application?", "md_docs_2FAQ.html#autotoc_md71", null ],
      [ "Why can't I see component values in the explorer?", "md_docs_2FAQ.html#autotoc_md72", null ],
      [ "How do I detect which entities have changed?", "md_docs_2FAQ.html#autotoc_md73", null ],
      [ "Are relationships just a component with an entity handle?", "md_docs_2FAQ.html#autotoc_md74", null ],
      [ "Can I create systems outside of the main function?", "md_docs_2FAQ.html#autotoc_md75", null ],
      [ "Can I use my own scheduler implementation?", "md_docs_2FAQ.html#autotoc_md76", null ],
      [ "Can I use Flecs without using systems?", "md_docs_2FAQ.html#autotoc_md77", null ],
      [ "Why does the lookup function not find my entity?", "md_docs_2FAQ.html#autotoc_md78", null ],
      [ "Can I add or remove components from within a system?", "md_docs_2FAQ.html#autotoc_md79", null ]
    ] ],
    [ "Designing with Flecs", "md_docs_2DesignWithFlecs.html", [
      [ "Entities", "md_docs_2DesignWithFlecs.html#autotoc_md81", [
        [ "Entity Initialization", "md_docs_2DesignWithFlecs.html#autotoc_md82", null ],
        [ "Entity Lifecycle", "md_docs_2DesignWithFlecs.html#autotoc_md83", null ],
        [ "Entity Names", "md_docs_2DesignWithFlecs.html#autotoc_md84", null ]
      ] ],
      [ "Components", "md_docs_2DesignWithFlecs.html#autotoc_md85", [
        [ "Component Size", "md_docs_2DesignWithFlecs.html#autotoc_md86", null ],
        [ "Complex component data", "md_docs_2DesignWithFlecs.html#autotoc_md87", null ]
      ] ],
      [ "Queries", "md_docs_2DesignWithFlecs.html#autotoc_md88", [
        [ "Use the right query", "md_docs_2DesignWithFlecs.html#autotoc_md89", null ],
        [ "Use in/inout/out annotations", "md_docs_2DesignWithFlecs.html#autotoc_md90", null ],
        [ "Annotations", "md_docs_2DesignWithFlecs.html#autotoc_md91", null ]
      ] ],
      [ "Systems", "md_docs_2DesignWithFlecs.html#autotoc_md92", [
        [ "System Scope", "md_docs_2DesignWithFlecs.html#autotoc_md93", null ],
        [ "System Scheduling", "md_docs_2DesignWithFlecs.html#autotoc_md94", null ]
      ] ],
      [ "Phases and Pipelines", "md_docs_2DesignWithFlecs.html#autotoc_md95", [
        [ "Selecting a Phase", "md_docs_2DesignWithFlecs.html#autotoc_md96", null ],
        [ "OnLoad", "md_docs_2DesignWithFlecs.html#autotoc_md97", null ],
        [ "PostLoad", "md_docs_2DesignWithFlecs.html#autotoc_md98", null ],
        [ "PreUpdate", "md_docs_2DesignWithFlecs.html#autotoc_md99", null ],
        [ "OnUpdate", "md_docs_2DesignWithFlecs.html#autotoc_md100", null ],
        [ "OnValidate", "md_docs_2DesignWithFlecs.html#autotoc_md101", null ],
        [ "PostUpdate", "md_docs_2DesignWithFlecs.html#autotoc_md102", null ],
        [ "PreStore", "md_docs_2DesignWithFlecs.html#autotoc_md103", null ],
        [ "OnStore", "md_docs_2DesignWithFlecs.html#autotoc_md104", null ],
        [ "Custom phases and pipelines", "md_docs_2DesignWithFlecs.html#autotoc_md105", null ]
      ] ],
      [ "Modules", "md_docs_2DesignWithFlecs.html#autotoc_md106", [
        [ "Defining Modules", "md_docs_2DesignWithFlecs.html#autotoc_md107", null ],
        [ "Module Dependencies and Ordering", "md_docs_2DesignWithFlecs.html#autotoc_md108", null ],
        [ "Modules and Feature Swapping", "md_docs_2DesignWithFlecs.html#autotoc_md109", null ],
        [ "Module Overhead", "md_docs_2DesignWithFlecs.html#autotoc_md110", null ]
      ] ],
      [ "Relationships", "md_docs_2DesignWithFlecs.html#autotoc_md111", null ]
    ] ],
    [ "Flecs Script Tutorial", "md_docs_2FlecsScriptTutorial.html", [
      [ "Getting Started with the Explorer", "md_docs_2FlecsScriptTutorial.html#autotoc_md113", null ],
      [ "The Basics", "md_docs_2FlecsScriptTutorial.html#autotoc_md114", null ],
      [ "Adding Components", "md_docs_2FlecsScriptTutorial.html#autotoc_md115", null ],
      [ "Drawing Shapes", "md_docs_2FlecsScriptTutorial.html#autotoc_md116", null ],
      [ "Drawing a Fence", "md_docs_2FlecsScriptTutorial.html#autotoc_md117", null ],
      [ "Prefabs", "md_docs_2FlecsScriptTutorial.html#autotoc_md118", null ],
      [ "Assemblies", "md_docs_2FlecsScriptTutorial.html#autotoc_md119", null ],
      [ "Grids", "md_docs_2FlecsScriptTutorial.html#autotoc_md120", null ],
      [ "Nested Assemblies", "md_docs_2FlecsScriptTutorial.html#autotoc_md121", null ]
    ] ],
    [ "Manual", "md_docs_2Manual.html", [
      [ "Introduction", "md_docs_2Manual.html#autotoc_md123", null ],
      [ "Design Goals", "md_docs_2Manual.html#autotoc_md124", [
        [ "1. Performance", "md_docs_2Manual.html#autotoc_md125", null ],
        [ "2. Portability", "md_docs_2Manual.html#autotoc_md126", null ],
        [ "3. Reusability", "md_docs_2Manual.html#autotoc_md127", null ],
        [ "4. Usability", "md_docs_2Manual.html#autotoc_md128", null ],
        [ "5. Extensibility", "md_docs_2Manual.html#autotoc_md129", null ],
        [ "6. Have fun!", "md_docs_2Manual.html#autotoc_md130", null ]
      ] ],
      [ "Diagrams", "md_docs_2Manual.html#autotoc_md131", [
        [ "High level architecture", "md_docs_2Manual.html#autotoc_md132", null ],
        [ "Component add flow", "md_docs_2Manual.html#autotoc_md133", null ],
        [ "Component remove flow", "md_docs_2Manual.html#autotoc_md134", null ],
        [ "Staging flow", "md_docs_2Manual.html#autotoc_md135", null ]
      ] ],
      [ "API design", "md_docs_2Manual.html#autotoc_md136", [
        [ "Naming conventions", "md_docs_2Manual.html#autotoc_md137", null ],
        [ "Idempotence", "md_docs_2Manual.html#autotoc_md138", null ],
        [ "Error handling", "md_docs_2Manual.html#autotoc_md139", null ],
        [ "Memory ownership", "md_docs_2Manual.html#autotoc_md140", null ],
        [ "Entity names", "md_docs_2Manual.html#autotoc_md141", null ],
        [ "Macros", "md_docs_2Manual.html#autotoc_md142", null ]
      ] ],
      [ "Entities", "md_docs_2Manual.html#autotoc_md143", [
        [ "Id recycling", "md_docs_2Manual.html#autotoc_md144", null ],
        [ "Generations", "md_docs_2Manual.html#autotoc_md145", null ],
        [ "Manual id generation", "md_docs_2Manual.html#autotoc_md146", null ],
        [ "Id ranges", "md_docs_2Manual.html#autotoc_md147", null ]
      ] ],
      [ "Types", "md_docs_2Manual.html#autotoc_md148", [
        [ "Basic usage", "md_docs_2Manual.html#autotoc_md149", null ],
        [ "Advanced usage", "md_docs_2Manual.html#autotoc_md150", null ]
      ] ],
      [ "Components", "md_docs_2Manual.html#autotoc_md151", [
        [ "Component handles", "md_docs_2Manual.html#autotoc_md152", [
          [ "Global component handles", "md_docs_2Manual.html#autotoc_md153", null ],
          [ "Local component handles", "md_docs_2Manual.html#autotoc_md154", null ]
        ] ],
        [ "Component disabling", "md_docs_2Manual.html#autotoc_md155", [
          [ "Limitations", "md_docs_2Manual.html#autotoc_md156", null ]
        ] ]
      ] ],
      [ "Tagging", "md_docs_2Manual.html#autotoc_md157", [
        [ "Tag handles", "md_docs_2Manual.html#autotoc_md158", null ]
      ] ],
      [ "Observers", "md_docs_2Manual.html#autotoc_md159", null ],
      [ "Modules", "md_docs_2Manual.html#autotoc_md160", [
        [ "Modules in C++", "md_docs_2Manual.html#autotoc_md161", null ]
      ] ],
      [ "Hierarchies", "md_docs_2Manual.html#autotoc_md162", [
        [ "Iteration", "md_docs_2Manual.html#autotoc_md163", null ],
        [ "Hierarchical queries", "md_docs_2Manual.html#autotoc_md164", null ],
        [ "Path identifiers", "md_docs_2Manual.html#autotoc_md165", null ],
        [ "Scoping", "md_docs_2Manual.html#autotoc_md166", null ],
        [ "Paths and signatures", "md_docs_2Manual.html#autotoc_md167", null ]
      ] ],
      [ "Inheritance", "md_docs_2Manual.html#autotoc_md168", [
        [ "Overriding", "md_docs_2Manual.html#autotoc_md169", null ],
        [ "Automatic overriding", "md_docs_2Manual.html#autotoc_md170", null ],
        [ "Inheritance hierarchies", "md_docs_2Manual.html#autotoc_md171", null ],
        [ "Prefabs", "md_docs_2Manual.html#autotoc_md172", null ]
      ] ],
      [ "Deferred operations", "md_docs_2Manual.html#autotoc_md173", null ]
    ] ],
    [ "Queries", "md_docs_2Queries.html", [
      [ "Highlights", "md_docs_2Queries.html#autotoc_md175", null ],
      [ "Definitions", "md_docs_2Queries.html#autotoc_md176", null ],
      [ "Examples", "md_docs_2Queries.html#autotoc_md177", null ],
      [ "Types", "md_docs_2Queries.html#autotoc_md178", [
        [ "Filters", "md_docs_2Queries.html#autotoc_md179", null ],
        [ "Cached Queries", "md_docs_2Queries.html#autotoc_md180", null ],
        [ "Rules", "md_docs_2Queries.html#autotoc_md181", null ]
      ] ],
      [ "Creation", "md_docs_2Queries.html#autotoc_md182", [
        [ "Query Descriptors (C)", "md_docs_2Queries.html#autotoc_md183", null ],
        [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md184", null ],
        [ "Query DSL", "md_docs_2Queries.html#autotoc_md185", null ]
      ] ],
      [ "Iteration", "md_docs_2Queries.html#autotoc_md186", [
        [ "Iterators (C)", "md_docs_2Queries.html#autotoc_md187", null ],
        [ "Each (C++)", "md_docs_2Queries.html#autotoc_md188", null ],
        [ "Iter (C++)", "md_docs_2Queries.html#autotoc_md189", null ],
        [ "Iteration safety", "md_docs_2Queries.html#autotoc_md190", null ]
      ] ],
      [ "Reference", "md_docs_2Queries.html#autotoc_md191", [
        [ "Components", "md_docs_2Queries.html#autotoc_md192", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md193", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md194", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md195", null ]
        ] ],
        [ "Wildcards", "md_docs_2Queries.html#autotoc_md196", null ],
        [ "Pairs", "md_docs_2Queries.html#autotoc_md197", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md198", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md199", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md200", null ]
        ] ],
        [ "Access modifiers", "md_docs_2Queries.html#autotoc_md201", [
          [ "Query Descriptors (C)", "md_docs_2Queries.html#autotoc_md202", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md203", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md204", null ]
        ] ],
        [ "Operator Overview", "md_docs_2Queries.html#autotoc_md205", null ],
        [ "And Operator", "md_docs_2Queries.html#autotoc_md206", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md207", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md208", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md209", null ]
        ] ],
        [ "Or Operator", "md_docs_2Queries.html#autotoc_md210", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md211", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md212", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md213", null ]
        ] ],
        [ "Not Operator", "md_docs_2Queries.html#autotoc_md214", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md215", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md216", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md217", null ]
        ] ],
        [ "Optional Operator", "md_docs_2Queries.html#autotoc_md218", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md219", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md220", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md221", null ]
        ] ],
        [ "Equality operators", "md_docs_2Queries.html#autotoc_md222", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md223", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md224", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md225", null ]
        ] ],
        [ "AndFrom, OrFrom, NotFrom Operators", "md_docs_2Queries.html#autotoc_md226", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md227", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md228", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md229", null ]
        ] ],
        [ "Query scopes", "md_docs_2Queries.html#autotoc_md230", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md231", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md232", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md233", null ]
        ] ],
        [ "Source", "md_docs_2Queries.html#autotoc_md234", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md235", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md236", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md237", null ]
        ] ],
        [ "Singletons", "md_docs_2Queries.html#autotoc_md238", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md239", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md240", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md241", null ]
        ] ],
        [ "Relationship Traversal", "md_docs_2Queries.html#autotoc_md242", [
          [ "Traversal Flags", "md_docs_2Queries.html#autotoc_md243", null ],
          [ "Iteration", "md_docs_2Queries.html#autotoc_md244", null ],
          [ "Limitations", "md_docs_2Queries.html#autotoc_md245", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md246", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md247", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md248", null ]
        ] ],
        [ "Instancing", "md_docs_2Queries.html#autotoc_md249", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md250", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md251", null ]
        ] ],
        [ "Variables", "md_docs_2Queries.html#autotoc_md252", [
          [ "Setting Variables", "md_docs_2Queries.html#autotoc_md253", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md254", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md255", null ]
        ] ],
        [ "Change Detection", "md_docs_2Queries.html#autotoc_md256", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md257", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md258", null ]
        ] ],
        [ "Sorting", "md_docs_2Queries.html#autotoc_md259", [
          [ "Sorting Algorithm", "md_docs_2Queries.html#autotoc_md260", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md261", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md262", null ]
        ] ],
        [ "Grouping", "md_docs_2Queries.html#autotoc_md263", [
          [ "Group Iterators", "md_docs_2Queries.html#autotoc_md264", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md265", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md266", null ]
        ] ],
        [ "Component Inheritance", "md_docs_2Queries.html#autotoc_md267", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md268", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md269", null ]
        ] ],
        [ "Transitive Relationships", "md_docs_2Queries.html#autotoc_md270", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md271", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md272", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md273", null ]
        ] ],
        [ "Reflexive Relationships", "md_docs_2Queries.html#autotoc_md274", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#autotoc_md275", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#autotoc_md276", null ],
          [ "Query DSL", "md_docs_2Queries.html#autotoc_md277", null ]
        ] ]
      ] ],
      [ "Performance", "md_docs_2Queries.html#autotoc_md278", [
        [ "Filter", "md_docs_2Queries.html#autotoc_md279", null ],
        [ "Cached Queries", "md_docs_2Queries.html#autotoc_md280", null ]
      ] ]
    ] ],
    [ "Systems", "md_docs_2Systems.html", [
      [ "System Iteration", "md_docs_2Systems.html#autotoc_md282", null ],
      [ "Using delta_time", "md_docs_2Systems.html#autotoc_md283", null ],
      [ "Tasks", "md_docs_2Systems.html#autotoc_md284", null ],
      [ "Pipelines", "md_docs_2Systems.html#autotoc_md285", [
        [ "Builtin Pipeline", "md_docs_2Systems.html#autotoc_md286", [
          [ "Builtin Pipeline Query", "md_docs_2Systems.html#autotoc_md287", null ]
        ] ],
        [ "Custom pipeline", "md_docs_2Systems.html#autotoc_md288", [
          [ "Pipeline switching performance", "md_docs_2Systems.html#autotoc_md289", null ]
        ] ],
        [ "Disabling systems", "md_docs_2Systems.html#autotoc_md290", null ]
      ] ],
      [ "Staging", "md_docs_2Systems.html#autotoc_md291", [
        [ "Sync points", "md_docs_2Systems.html#autotoc_md292", null ],
        [ "No readonly systems", "md_docs_2Systems.html#autotoc_md293", null ],
        [ "Threading", "md_docs_2Systems.html#autotoc_md294", null ],
        [ "Threading with Async Tasks", "md_docs_2Systems.html#autotoc_md295", null ]
      ] ],
      [ "Timers", "md_docs_2Systems.html#autotoc_md296", [
        [ "Interval", "md_docs_2Systems.html#autotoc_md297", null ],
        [ "Rate", "md_docs_2Systems.html#autotoc_md298", null ],
        [ "Tick source", "md_docs_2Systems.html#autotoc_md299", null ],
        [ "Nested tick sources", "md_docs_2Systems.html#autotoc_md300", null ]
      ] ]
    ] ],
    [ "Relationships", "md_docs_2Relationships.html", [
      [ "Definitions", "md_docs_2Relationships.html#autotoc_md302", null ],
      [ "Examples", "md_docs_2Relationships.html#autotoc_md303", null ],
      [ "Introduction", "md_docs_2Relationships.html#autotoc_md304", null ],
      [ "Relationship queries", "md_docs_2Relationships.html#autotoc_md305", [
        [ "Test if entity has a relationship pair", "md_docs_2Relationships.html#autotoc_md306", null ],
        [ "Test if entity has a relationship wildcard", "md_docs_2Relationships.html#autotoc_md307", null ],
        [ "Get parent for entity", "md_docs_2Relationships.html#autotoc_md308", null ],
        [ "Find first target of a relationship for entity", "md_docs_2Relationships.html#autotoc_md309", null ],
        [ "Find all targets of a relationship for entity", "md_docs_2Relationships.html#autotoc_md310", null ],
        [ "Find target of a relationship with component", "md_docs_2Relationships.html#autotoc_md311", null ],
        [ "Iterate all pairs for entity", "md_docs_2Relationships.html#autotoc_md312", null ],
        [ "Find all entities with a pair", "md_docs_2Relationships.html#autotoc_md313", null ],
        [ "Find all entities with a pair wildcard", "md_docs_2Relationships.html#autotoc_md314", null ],
        [ "Iterate all children for a parent", "md_docs_2Relationships.html#autotoc_md315", null ]
      ] ],
      [ "Relationship components", "md_docs_2Relationships.html#autotoc_md316", [
        [ "Using relationships to add components multiple times", "md_docs_2Relationships.html#autotoc_md317", null ]
      ] ],
      [ "Relationship wildcards", "md_docs_2Relationships.html#autotoc_md318", null ],
      [ "Inspecting relationships", "md_docs_2Relationships.html#autotoc_md319", null ],
      [ "Builtin relationships", "md_docs_2Relationships.html#autotoc_md320", [
        [ "The IsA relationship", "md_docs_2Relationships.html#autotoc_md321", [
          [ "Component sharing", "md_docs_2Relationships.html#autotoc_md322", null ]
        ] ],
        [ "The ChildOf relationship", "md_docs_2Relationships.html#autotoc_md323", [
          [ "Namespacing", "md_docs_2Relationships.html#autotoc_md324", null ],
          [ "Scoping", "md_docs_2Relationships.html#autotoc_md325", null ]
        ] ]
      ] ],
      [ "Cleanup properties", "md_docs_2Relationships.html#autotoc_md326", [
        [ "Examples", "md_docs_2Relationships.html#autotoc_md327", null ],
        [ "Cleanup order", "md_docs_2Relationships.html#autotoc_md328", [
          [ "Cleanup order during world teardown", "md_docs_2Relationships.html#autotoc_md329", null ],
          [ "World teardown sequence", "md_docs_2Relationships.html#autotoc_md330", null ]
        ] ]
      ] ],
      [ "Relationship properties", "md_docs_2Relationships.html#autotoc_md331", [
        [ "Tag property", "md_docs_2Relationships.html#autotoc_md332", null ],
        [ "Final property", "md_docs_2Relationships.html#autotoc_md333", null ],
        [ "DontInherit property", "md_docs_2Relationships.html#autotoc_md334", null ],
        [ "AlwaysOverride property", "md_docs_2Relationships.html#autotoc_md335", null ],
        [ "Transitive property", "md_docs_2Relationships.html#autotoc_md336", null ],
        [ "Reflexive property", "md_docs_2Relationships.html#autotoc_md337", null ],
        [ "Acyclic property", "md_docs_2Relationships.html#autotoc_md338", null ],
        [ "Traversable property", "md_docs_2Relationships.html#autotoc_md339", null ],
        [ "Exclusive property", "md_docs_2Relationships.html#autotoc_md340", null ],
        [ "Union property", "md_docs_2Relationships.html#autotoc_md341", null ],
        [ "Symmetric property", "md_docs_2Relationships.html#autotoc_md342", null ],
        [ "With property", "md_docs_2Relationships.html#autotoc_md343", null ],
        [ "OneOf property", "md_docs_2Relationships.html#autotoc_md344", null ]
      ] ],
      [ "Relationship performance", "md_docs_2Relationships.html#autotoc_md345", [
        [ "Introduction", "md_docs_2Relationships.html#autotoc_md346", null ],
        [ "Storing relationships", "md_docs_2Relationships.html#autotoc_md347", null ],
        [ "Id ranges", "md_docs_2Relationships.html#autotoc_md348", null ],
        [ "Fragmentation", "md_docs_2Relationships.html#autotoc_md349", null ],
        [ "Relationship flattening", "md_docs_2Relationships.html#autotoc_md350", null ],
        [ "Table Creation", "md_docs_2Relationships.html#autotoc_md351", null ],
        [ "Indexing", "md_docs_2Relationships.html#autotoc_md352", null ],
        [ "Wildcard Queries", "md_docs_2Relationships.html#autotoc_md353", null ]
      ] ]
    ] ],
    [ "REST API", "md_docs_2RestApi.html", [
      [ "Enable the REST API", "md_docs_2RestApi.html#autotoc_md355", null ],
      [ "Explorer", "md_docs_2RestApi.html#autotoc_md356", [
        [ "Queries", "md_docs_2RestApi.html#autotoc_md357", null ]
      ] ],
      [ "Endpoints", "md_docs_2RestApi.html#autotoc_md358", [
        [ "entity", "md_docs_2RestApi.html#autotoc_md359", [
          [ "path", "md_docs_2RestApi.html#autotoc_md360", null ],
          [ "label", "md_docs_2RestApi.html#autotoc_md361", null ],
          [ "brief", "md_docs_2RestApi.html#autotoc_md362", null ],
          [ "link", "md_docs_2RestApi.html#autotoc_md363", null ],
          [ "id_labels", "md_docs_2RestApi.html#autotoc_md364", null ],
          [ "base", "md_docs_2RestApi.html#autotoc_md365", null ],
          [ "values", "md_docs_2RestApi.html#autotoc_md366", null ],
          [ "private", "md_docs_2RestApi.html#autotoc_md367", null ],
          [ "type_info", "md_docs_2RestApi.html#autotoc_md368", null ],
          [ "alerts", "md_docs_2RestApi.html#autotoc_md369", null ],
          [ "Example", "md_docs_2RestApi.html#autotoc_md370", null ]
        ] ],
        [ "enable", "md_docs_2RestApi.html#autotoc_md371", null ],
        [ "disable", "md_docs_2RestApi.html#autotoc_md372", null ],
        [ "delete", "md_docs_2RestApi.html#autotoc_md373", null ],
        [ "set", "md_docs_2RestApi.html#autotoc_md374", null ],
        [ "query", "md_docs_2RestApi.html#autotoc_md375", [
          [ "name", "md_docs_2RestApi.html#autotoc_md376", null ],
          [ "offset", "md_docs_2RestApi.html#autotoc_md377", null ],
          [ "limit", "md_docs_2RestApi.html#autotoc_md378", null ],
          [ "term_ids", "md_docs_2RestApi.html#autotoc_md379", null ],
          [ "term_labels", "md_docs_2RestApi.html#autotoc_md380", null ],
          [ "ids", "md_docs_2RestApi.html#autotoc_md381", null ],
          [ "id_labels", "md_docs_2RestApi.html#autotoc_md382", null ],
          [ "sources", "md_docs_2RestApi.html#autotoc_md383", null ],
          [ "variables", "md_docs_2RestApi.html#autotoc_md384", null ],
          [ "is_set", "md_docs_2RestApi.html#autotoc_md385", null ],
          [ "values", "md_docs_2RestApi.html#autotoc_md386", null ],
          [ "entities", "md_docs_2RestApi.html#autotoc_md387", null ],
          [ "entity_labels", "md_docs_2RestApi.html#autotoc_md388", null ],
          [ "entity_ids", "md_docs_2RestApi.html#autotoc_md389", null ],
          [ "variable_labels", "md_docs_2RestApi.html#autotoc_md390", null ],
          [ "variable_ids", "md_docs_2RestApi.html#autotoc_md391", null ],
          [ "duration", "md_docs_2RestApi.html#autotoc_md392", null ],
          [ "type_info", "md_docs_2RestApi.html#autotoc_md393", null ],
          [ "Example:", "md_docs_2RestApi.html#autotoc_md394", null ]
        ] ],
        [ "stats", "md_docs_2RestApi.html#autotoc_md395", null ]
      ] ]
    ] ],
    [ "JSON format", "md_docs_2JsonFormat.html", [
      [ "Value kinds", "md_docs_2JsonFormat.html#autotoc_md397", [
        [ "Name", "md_docs_2JsonFormat.html#autotoc_md398", null ],
        [ "Path", "md_docs_2JsonFormat.html#autotoc_md399", null ],
        [ "Label", "md_docs_2JsonFormat.html#autotoc_md400", null ],
        [ "Id", "md_docs_2JsonFormat.html#autotoc_md401", null ],
        [ "Id**", "md_docs_2JsonFormat.html#autotoc_md402", null ],
        [ "Value", "md_docs_2JsonFormat.html#autotoc_md403", null ],
        [ "Type**", "md_docs_2JsonFormat.html#autotoc_md404", null ],
        [ "Entity", "md_docs_2JsonFormat.html#autotoc_md405", [
          [ "\"path", "md_docs_2JsonFormat.html#autotoc_md406", null ],
          [ "\"label", "md_docs_2JsonFormat.html#autotoc_md407", null ],
          [ "\"brief", "md_docs_2JsonFormat.html#autotoc_md408", null ],
          [ "\"link", "md_docs_2JsonFormat.html#autotoc_md409", null ],
          [ "\"is_a", "md_docs_2JsonFormat.html#autotoc_md410", null ],
          [ "\"ids", "md_docs_2JsonFormat.html#autotoc_md411", null ],
          [ "\"id_labels", "md_docs_2JsonFormat.html#autotoc_md412", null ],
          [ "\"hidden", "md_docs_2JsonFormat.html#autotoc_md413", null ],
          [ "\"values", "md_docs_2JsonFormat.html#autotoc_md414", null ],
          [ "\"type_info", "md_docs_2JsonFormat.html#autotoc_md415", null ],
          [ "Example", "md_docs_2JsonFormat.html#autotoc_md416", null ]
        ] ],
        [ "Result", "md_docs_2JsonFormat.html#autotoc_md417", [
          [ "parent", "md_docs_2JsonFormat.html#autotoc_md418", null ],
          [ "entities", "md_docs_2JsonFormat.html#autotoc_md419", null ],
          [ "entity_labels", "md_docs_2JsonFormat.html#autotoc_md420", null ],
          [ "entity_ids", "md_docs_2JsonFormat.html#autotoc_md421", null ],
          [ "sources", "md_docs_2JsonFormat.html#autotoc_md422", null ],
          [ "variables", "md_docs_2JsonFormat.html#autotoc_md423", null ],
          [ "variable_labels", "md_docs_2JsonFormat.html#autotoc_md424", null ],
          [ "variable_ids", "md_docs_2JsonFormat.html#autotoc_md425", null ],
          [ "ids", "md_docs_2JsonFormat.html#autotoc_md426", null ],
          [ "is_set", "md_docs_2JsonFormat.html#autotoc_md427", null ],
          [ "values", "md_docs_2JsonFormat.html#autotoc_md428", null ]
        ] ],
        [ "Iterator", "md_docs_2JsonFormat.html#autotoc_md429", [
          [ "\"ids", "md_docs_2JsonFormat.html#autotoc_md430", null ],
          [ "\"variables", "md_docs_2JsonFormat.html#autotoc_md431", null ],
          [ "\"results", "md_docs_2JsonFormat.html#autotoc_md432", null ],
          [ "\"eval_duration", "md_docs_2JsonFormat.html#autotoc_md433", null ],
          [ "\"type_info", "md_docs_2JsonFormat.html#autotoc_md434", null ],
          [ "Example", "md_docs_2JsonFormat.html#autotoc_md435", null ]
        ] ]
      ] ],
      [ "Entity serializer", "md_docs_2JsonFormat.html#autotoc_md436", [
        [ "Serializer options", "md_docs_2JsonFormat.html#autotoc_md437", [
          [ "serialize_path", "md_docs_2JsonFormat.html#autotoc_md438", null ],
          [ "serialize_label", "md_docs_2JsonFormat.html#autotoc_md439", null ],
          [ "serialize_brief", "md_docs_2JsonFormat.html#autotoc_md440", null ],
          [ "serialize_link", "md_docs_2JsonFormat.html#autotoc_md441", null ],
          [ "serialize_id_labels", "md_docs_2JsonFormat.html#autotoc_md442", null ],
          [ "serialize_base", "md_docs_2JsonFormat.html#autotoc_md443", null ],
          [ "serialize_private", "md_docs_2JsonFormat.html#autotoc_md444", null ],
          [ "serialize_hidden", "md_docs_2JsonFormat.html#autotoc_md445", null ],
          [ "serialize_values", "md_docs_2JsonFormat.html#autotoc_md446", null ],
          [ "serialize_type_info", "md_docs_2JsonFormat.html#autotoc_md447", null ]
        ] ]
      ] ],
      [ "Iterator serializer", "md_docs_2JsonFormat.html#autotoc_md448", [
        [ "Serializer options", "md_docs_2JsonFormat.html#autotoc_md449", [
          [ "serialize_term_ids", "md_docs_2JsonFormat.html#autotoc_md450", null ],
          [ "serialize_ids", "md_docs_2JsonFormat.html#autotoc_md451", null ],
          [ "serialize_sources", "md_docs_2JsonFormat.html#autotoc_md452", null ],
          [ "serialize_variables", "md_docs_2JsonFormat.html#autotoc_md453", null ],
          [ "serialize_is_set", "md_docs_2JsonFormat.html#autotoc_md454", null ],
          [ "serialize_values", "md_docs_2JsonFormat.html#autotoc_md455", null ],
          [ "serialize_entities", "md_docs_2JsonFormat.html#autotoc_md456", null ],
          [ "serialize_entity_labels", "md_docs_2JsonFormat.html#autotoc_md457", null ],
          [ "serialize_variable_labels", "md_docs_2JsonFormat.html#autotoc_md458", null ],
          [ "measure_eval_duration", "md_docs_2JsonFormat.html#autotoc_md459", null ],
          [ "serialize_type_info", "md_docs_2JsonFormat.html#autotoc_md460", null ]
        ] ]
      ] ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", null ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"alerts_2builder__i_8hpp.html",
"group__builtin__components.html#ga2bed0ce737e6695215e6f2c7f6873008",
"group__c__addons__metrics.html#gaa1674c3d19fec55cffeddc913d298813",
"group__cpp__addons__meta.html#gac38baa85a49b23f624cbb8490ed32503",
"group__ids.html#ga753c113137ba666cbe0b7263a6e89f0e",
"index.html#autotoc_md0",
"md_docs_2Queries.html#autotoc_md187",
"metrics_2decl_8hpp_source.html",
"structecs__app__desc__t.html#aac93d4bc65e8c868b30f4f539f1b18d3",
"structecs__query__desc__t.html#a319bdede3357800f4957583dde7294b1",
"structflecs_1_1___1_1enum__is__valid.html",
"structflecs_1_1entity__view.html#a9fdf9fb51173722f07ce3c5b5011ba66",
"structflecs_1_1units_1_1Mass.html",
"term_2impl_8hpp_source.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';