# SPDX-FileCopyrightText: 2023 Linus Jahn <lnj@kaidan.im>
#
# SPDX-License-Identifier: CC0-1.0


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was QXmppLegacyConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(_QXmpp_FIND_PARTS_REQUIRED)
if(QXmpp_FIND_REQUIRED)
    set(_QXmpp_FIND_PARTS_REQUIRED REQUIRED)
endif()
set(_QXmpp_FIND_PARTS_QUIET)
if(QXmpp_FIND_QUIETLY)
    set(_QXmpp_FIND_PARTS_QUIET QUIET)
endif()

# Pass through arguments to QXmppQt5
include(CMakeFindDependencyMacro)
find_package(QXmppQt5
    ${QXmpp_FIND_VERSION}
    ${_QXmpp_FIND_PARTS_REQUIRED}
    ${_QXmpp_FIND_PARTS_QUIET}
    COMPONENTS ${QXmpp_FIND_COMPONENTS}
)

set(QXmpp_FOUND ${QXmppQt5_FOUND})
