#ifndef SIMVOLEON_BASIC_H
#define SIMVOLEON_BASIC_H

/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

/*
  NOTE: basic.h is automatically generated from basic.h.cmake.in, so don't
  edit basic.h directly.
*/

/* *********************************************************************** */

/* A unique identifier to recognize the Systems in Motion's SimVoleon
 * library from application code.
 */
#define __SIMVOLEON__

/* The following #undef'ed defines are automatically defined and
 * synchronized with the settings in configure.in when ``configure''
 * is executed.
 *
 * The #ifndef wrapper is necessary because during development, these
 * are also defined in the config.h file generated by ``configure''.
 */
#ifndef SIMVOLEON_VERSION
#define SIMVOLEON_VERSION "2.1.0"

/* These are available for adding or omitting features based on
 * SimVoleon version numbers in client application sources.
 */
#ifndef SIMVOLEON_MAJOR_VERSION
#define SIMVOLEON_MAJOR_VERSION 2
#endif /* ! SIMVOLEON_MAJOR_VERSION */
#ifndef SIMVOLEON_MINOR_VERSION
#define SIMVOLEON_MINOR_VERSION 1
#endif /* ! SIMVOLEON_MINOR_VERSION */
#ifndef SIMVOLEON_MICRO_VERSION
#define SIMVOLEON_MICRO_VERSION 0
#endif /* ! SIMVOLEON_MICRO_VERSION */

#endif /* !SIMVOLEON_VERSION */ /* Ends configure-generated defines. */

/* *********************************************************************** */

/* Precaution to avoid an some errors easily made by the application
   programmer. */
#ifdef SIMVOLEON_DLL_API
# error Leave the internal SIMVOLEON_DLL_API define alone.
#endif /* SIMVOLEON_DLL_API */
#ifdef SIMVOLEON_INTERNAL
# ifdef SIMVOLEON_NOT_DLL
#  error The SIMVOLEON_NOT_DLL define is not supposed to be used when building the library, only when building Win32 applications.
# endif /* SIMVOLEON_INTERNAL && SIMVOLEON_NOT_DLL */
# ifdef SIMVOLEON_DLL
#  error The SIMVOLEON_DLL define is not supposed to be used when building the library, only when building Win32 applications.
# endif /* SIMVOLEON_INTERNAL && SIMVOLEON_DLL */
#endif /* SIMVOLEON_INTERNAL */

/*
  On MSWindows platforms, one of these defines must always be set when
  building application programs:

   - "SIMVOLEON_DLL", when the application programmer is using the library
     in the form of a dynamic link library (DLL)

   - "SIMVOLEON_NOT_DLL", when the application programmer is using the
     library in the form of a static object library (LIB)

  Note that either SIMVOLEON_DLL or SIMVOLEON_NOT_DLL _must_ be
  defined by the application programmer on MSWindows platforms, or
  else the #error statement will hit. Set up one or the other of these
  two defines in your compiler environment according to how the
  library was built -- as a DLL (use "SIMVOLEON_DLL") or as a LIB (use
  "SIMVOLEON_NOT_DLL").

  (Setting up defines for the compiler is typically done by either
  adding something like "/DSIMVOLEON_DLL" to the compiler's argument
  line (for command-line build processes), or by adding the define to
  the list of preprocessor symbols in your IDE GUI (in the MSVC IDE,
  this is done from the "Project"->"Settings" menu, choose the "C/C++"
  tab, then "Preprocessor" from the dropdown box and add the
  appropriate define)).

  It is extremely important that the application programmer uses the
  correct define, as using "SIMVOLEON_NOT_DLL" when "SIMVOLEON_DLL" is
  correct will cause mysterious crashes.
 */
/* FIXME: use a feature check to see if this is a platform which can
   recognize the __declspec keyword instead of the crap #if below.
   20030324 mortene. */
#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
# ifdef SIMVOLEON_INTERNAL
#  ifdef SIMVOLEON_MAKE_DLL
#   define SIMVOLEON_DLL_API __declspec(dllexport)
#  endif /* SIMVOLEON_MAKE_DLL */
# else /* !SIMVOLEON_INTERNAL */
#  ifdef SIMVOLEON_DLL
#   define SIMVOLEON_DLL_API __declspec(dllimport)
#  else /* !SIMVOLEON_DLL */
#   ifndef SIMVOLEON_NOT_DLL
#    error Define either SIMVOLEON_DLL or SIMVOLEON_NOT_DLL as appropriate for your linkage! See Inventor/C/basic.h for further instructions.
#   endif /* SIMVOLEON_NOT_DLL */
#  endif /* !SIMVOLEON_DLL */
# endif /* !SIMVOLEON_INTERNAL */
#endif /* Microsoft Windows */

/* Empty define to avoid errors when _not_ compiling an MSWindows DLL. */
#ifndef SIMVOLEON_DLL_API
# define SIMVOLEON_DLL_API
#endif /* !SIMVOLEON_DLL_API */


#endif /* !SIMVOLEON_BASIC_H */
