
#ifndef QUICKADDONS_EXPORT_H
#define QUICKADDONS_EXPORT_H

#ifdef QUICKADDONS_STATIC_DEFINE
#  define QUICKADDONS_EXPORT
#  define QUICKADDONS_NO_EXPORT
#else
#  ifndef QUICKADDONS_EXPORT
#    ifdef KF5QuickAddons_EXPORTS
        /* We are building this library */
#      define QUICKADDONS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define QUICKADDONS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef QUICKADDONS_NO_EXPORT
#    define QUICKADDONS_NO_EXPORT 
#  endif
#endif

#ifndef QUICKADDONS_DECL_DEPRECATED
#  define QUICKADDONS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef QUICKADDONS_DECL_DEPRECATED_EXPORT
#  define QUICKADDONS_DECL_DEPRECATED_EXPORT QUICKADDONS_EXPORT QUICKADDONS_DECL_DEPRECATED
#endif

#ifndef QUICKADDONS_DECL_DEPRECATED_NO_EXPORT
#  define QUICKADDONS_DECL_DEPRECATED_NO_EXPORT QUICKADDONS_NO_EXPORT QUICKADDONS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef QUICKADDONS_NO_DEPRECATED
#    define QUICKADDONS_NO_DEPRECATED
#  endif
#endif

#define QUICKADDONS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(QUICKADDONS_NO_DEPRECATED) && !defined(QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define QUICKADDONS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(QUICKADDONS_NO_DEPRECATED_WARNINGS) && !defined(QUICKADDONS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define QUICKADDONS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define QUICKADDONS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(QUICKADDONS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define QUICKADDONS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(QUICKADDONS_NO_DEPRECATED)
#  undef QUICKADDONS_DEPRECATED
#  define QUICKADDONS_DEPRECATED_EXPORT QUICKADDONS_EXPORT
#  define QUICKADDONS_DEPRECATED_NO_EXPORT QUICKADDONS_NO_EXPORT
#elif defined(QUICKADDONS_NO_DEPRECATED_WARNINGS)
#  define QUICKADDONS_DEPRECATED
#  define QUICKADDONS_DEPRECATED_EXPORT QUICKADDONS_EXPORT
#  define QUICKADDONS_DEPRECATED_NO_EXPORT QUICKADDONS_NO_EXPORT
#else
#  define QUICKADDONS_DEPRECATED QUICKADDONS_DECL_DEPRECATED
#  define QUICKADDONS_DEPRECATED_EXPORT QUICKADDONS_DECL_DEPRECATED_EXPORT
#  define QUICKADDONS_DEPRECATED_NO_EXPORT QUICKADDONS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define QUICKADDONS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define QUICKADDONS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef QUICKADDONS_NO_DEPRECATED
#  define QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57400
#endif
#ifdef QUICKADDONS_NO_DEPRECATED_WARNINGS
#  define QUICKADDONS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef QUICKADDONS_DEPRECATED_WARNINGS_SINCE
#  ifdef QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define QUICKADDONS_DEPRECATED_WARNINGS_SINCE QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define QUICKADDONS_DEPRECATED_WARNINGS_SINCE 0x57400
#  endif
#endif

#ifndef QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef QUICKADDONS_DEPRECATED
#  define QUICKADDONS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > QUICKADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define QUICKADDONS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if QUICKADDONS_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define QUICKADDONS_DEPRECATED_VERSION_5_88(text) QUICKADDONS_DECL_DEPRECATED_TEXT(text)
#else
#  define QUICKADDONS_DEPRECATED_VERSION_5_88(text)
#endif

#if QUICKADDONS_DEPRECATED_WARNINGS_SINCE >= 0x55d00
#  define QUICKADDONS_DEPRECATED_VERSION_5_93(text) QUICKADDONS_DECL_DEPRECATED_TEXT(text)
#else
#  define QUICKADDONS_DEPRECATED_VERSION_5_93(text)
#endif

#if QUICKADDONS_DEPRECATED_WARNINGS_SINCE >= 0x56800
#  define QUICKADDONS_DEPRECATED_VERSION_5_104(text) QUICKADDONS_DECL_DEPRECATED_TEXT(text)
#else
#  define QUICKADDONS_DEPRECATED_VERSION_5_104(text)
#endif
#define QUICKADDONS_DEPRECATED_VERSION_5(minor, text)      QUICKADDONS_DEPRECATED_VERSION_5_##minor(text)
#define QUICKADDONS_DEPRECATED_VERSION(major, minor, text) QUICKADDONS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define QUICKADDONS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) QUICKADDONS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define QUICKADDONS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) QUICKADDONS_DEPRECATED_VERSION(major, minor, text)
#  define QUICKADDONS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) QUICKADDONS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define QUICKADDONS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define QUICKADDONS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* QUICKADDONS_EXPORT_H */
