/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PnmImage
extends Component {
    private byte[] data = null;
    private int width = 0;
    private int height = 0;
    private int channel = 0;

    public PnmImage(int n, int n2, int n3) {
        this.channel = n;
        this.width = n2;
        this.height = n3;
        this.data = new byte[n2 * n3 * n];
    }

    public PnmImage(String string) {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            Pattern pattern = Pattern.compile("^P([56])$");
            String string2 = dataInputStream.readLine();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) {
                System.out.println("PNM header format error");
                return;
            }
            this.channel = matcher.group(1).compareTo("5") == 0 ? 1 : 3;
            pattern = Pattern.compile("^(\\d+) (\\d+)$");
            matcher = pattern.matcher(string2 = dataInputStream.readLine());
            if (!matcher.matches()) {
                System.out.println("PNM header format error");
                return;
            }
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
            string2 = dataInputStream.readLine();
            int n2 = this.width * this.height * this.channel;
            this.data = new byte[n2];
            while (n2 > 0) {
                try {
                    int n3 = dataInputStream.read(this.data, n, n2);
                    if (n3 == -1) {
                        System.err.println("    failed to read()");
                        break;
                    }
                    n += n3;
                    n2 -= n3;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] get_data() {
        return this.data;
    }

    public int get_width() {
        return this.width;
    }

    public int get_height() {
        return this.height;
    }

    public Image createROIImage(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5;
                nArray[i * n3 + j] = -16777216;
                if (this.channel == 1) {
                    Byte by = this.data[(n2 + i) * this.width + n + j];
                    short s = by < 0 ? (short)(256 + by) : (short)by.byteValue();
                    for (n5 = 0; n5 < 3; ++n5) {
                        nArray[i * n3 + j] = nArray[i * n3 + j] | s << 8 * n5;
                    }
                    continue;
                }
                for (int k = 0; k < 3; ++k) {
                    Byte by = this.data[((n2 + i) * this.width + n + j) * this.channel + (2 - k)];
                    n5 = by < 0 ? (int)((short)(256 + by)) : (int)by.byteValue();
                    nArray[i * n3 + j] = nArray[i * n3 + j] | n5 << 8 * k;
                }
            }
        }
        return this.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
    }

    public Image createScaleImage(double d) {
        Image image = this.createROIImage(0, 0, this.width, this.height);
        ReplicateScaleFilter replicateScaleFilter = new ReplicateScaleFilter((int)((double)this.width * d), (int)((double)this.height * d));
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), replicateScaleFilter);
        return this.createImage(filteredImageSource);
    }
}

