%feature("docstring") OT::CenteredFiniteDifferenceGradient
"First order centered finite-difference scheme.

Available constructors:
    CenteredFiniteDifferenceGradient(*epsilon, evalImpl*)

    CenteredFiniteDifferenceGradient(*step, evalImpl*)

Parameters
----------
evalImpl : :class:`~openturns.EvaluationImplementation`
    Implementation of the evaluation of a function.
epsilon : float, sequence of float
    Finite difference steps for each dimension.
step : :class:`~openturns.FiniteDifferenceStep`
    Defines how finite difference steps values are computed.

Notes
-----
*CenteredFiniteDifferenceGradient* provides a first order centered finite-
difference scheme:

.. math::

  \\frac{\\partial f_j}{\\partial x_i} \\approx \\frac{f_j(x + \\epsilon_i) - f_j(x - \\epsilon_i)}
                                                 {2 \\epsilon_i}

Examples
--------
>>> import openturns as ot
>>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
>>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
>>> epsilon = [0.01]*2
>>> myGradient = ot.CenteredFiniteDifferenceGradient(epsilon, myFunc.getEvaluation())
>>> inPoint = [1.]*2
>>> print(myGradient.gradient(inPoint))
[[  0.841471 -0.909282  0.735771 ]
 [  0.540293 -0.909282 -1.10366  ]]"
