%feature("docstring") OT::FejerExperiment
"Fejer experiment.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

This class computes Fejer and Clenshaw–Curtis quadrature,
`see also here <https://en.wikipedia.org/wiki/Clenshaw%E2%80%93Curtis_quadrature>`_

For any :math:`k=0,1,...,n-1`, let :math:`\\theta_k = \\dfrac{k\\pi}{n}`.
The Clenshaw-Curtis nodes are:

.. math::

    x_k = \\cos(\\theta_k)

for any :math:`k=0,1,...,n-1` and its associated weights are:

.. math::

    w_k = \\dfrac{c_k}{n}\\left(1-\\sum_{j=1}^{\\lfloor n/2\\rfloor}\\dfrac{b_j}{4j^2-1}\\cos\\left(2j\\theta_k\\right)\\right)

where:

.. math::

    b_j =
    \\begin{cases}
    2 & \\textrm{ if } j < n/2, \\\\
    1 & \\textrm{ otherwise},
    \\end{cases}

and:

.. math::

    c_k =
    \\begin{cases}
    1 & \\textrm{ if } k = 0 \\textrm{ or } n - 1, \\\\
    2 & \\textrm{ otherwise}.
    \\end{cases}

The type-1 Fejer quadrature rule uses the nodes:

.. math::

    x_k = \\cos(\\theta_{k + 1/2})

for any :math:`k=0,1,...,n-1` and the associated weights are:

.. math::

    w_k = \\dfrac{2}{n}\\left(1-2\\sum_{j=1}^{\\lfloor n/2\\rfloor}\\dfrac{1}{4j^2-1}\\cos\\left(j\\theta_{2k+1}\\right)\\right)

Finally, the type-2 Fejer quadrature rule is very close to the Clenshaw-Curtis rule. The two methods share the same
nodes (except the endpoints that are set to `0` within the `Fejer` method).  The weights of the type-2 Fejer quadrature rule are:

.. math::

    w_k=\\dfrac{4}{n+1}\\sin\\theta_k\\sum_{j=1}^{\\lfloor n/2\\rfloor}\\dfrac{\\sin\\left((2j-1)\\theta_k\\right)}{2j-1}

for any :math:`k=0,1,...,n-1`.

Parameters
----------
discretization : sequence of int, optional
    The number of nodes in each dimension. The sequence must be non-empty and must contain only positive values.
    The default discretization is *FejerExperiment-DefaultMarginalNodesNumber* in each dimension,
    see :class:`~openturns.ResourceMap`.
rule : int, optional
    Possible values include:

    - ot.FejerExperiment.FEJERTYPE1,
    - ot.FejerExperiment.FEJERTYPE2,
    - ot.FejerExperiment.CLENSHAWCURTIS.

    Default is `ot.FejerExperiment.CLENSHAWCURTIS`

See also
--------
openturns.FejerAlgorithm

Examples
--------
Create an experiment:

>>> import openturns as ot
>>> import openturns.experimental as otexp
>>> rule = otexp.FejerExperiment.FEJERTYPE1
>>> experiment = otexp.FejerExperiment([3], rule)
>>> experiment.setBounds(ot.Interval(4.0, 5.0))
>>> nodes, weights = experiment.generateWithWeights()
"

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::setDiscretization
"Accessor to the discretization of the tensorized rule.

Parameters
----------
discretization : :class:`~openturns.Indices`
    The number of integration point in each dimension."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::getDiscretization
"Accessor to the discretization of the tensorized rule.

Returns
-------
discretization : :class:`~openturns.Indices`
    The number of integration point in each dimension."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::setBounds
"Accessor to the design bounds.

Parameters
----------
bounds : :class:`~openturns.Interval`
    The bounds used for rescaling."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::getBounds
"Accessor to the design bounds.

Returns
-------
bounds : :class:`~openturns.Interval`
    The bounds used for rescaling."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::setRuleType
"Accessor to the generation rule.

Parameters
----------
ruleType : int
    The generation rule. Possible values include:

    - ot.FejerExperiment.FEJERTYPE1,
    - ot.FejerExperiment.FEJERTYPE2,
    - ot.FejerExperiment.CLENSHAWCURTIS."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::getRuleType
"Accessor to the generation rule.

Returns
-------
ruleType : int
    The generation rule."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::setUseNestedLevels
"Accessor to the levels interpretation flag.

Parameters
----------
useNestedLevels : bool
    Whether the level is raised to the power of two (only for FEJERTYPE2, CLENSHAWCURTIS nested rules) or interpreted as raw size."

// ---------------------------------------------------------------------

%feature("docstring") OT::FejerExperiment::getUseNestedLevels
"Accessor to the levels interpretation flag.

Returns
-------
useNestedLevels : bool
    Whether the level is raised to the power of two (only for FEJERTYPE2, CLENSHAWCURTIS nested rules) or interpreted as raw size."
