%feature("docstring") OT::GammaMuSigma
"Gamma distribution parameters.

Parameters
----------
mu : float
    Mean.

    Default value is 1.0.
sigma : float
    Standard deviation :math:`\\sigma > 0`.

    Default value is 1.0.
gamma : float, optional
    Shift parameter.

    Default value is 0.0.

Notes
-----
The native parameters are defined as follows:

.. math::

    k &= \\left( \\frac{\\mu-\\gamma}{\\sigma} \\right)^2 \\\\
    \\lambda &= \\frac{\\mu-\\gamma}{\\sigma^2}

See also
--------
Gamma

Examples
--------
Create the parameters of the Gamma distribution:

>>> import openturns as ot
>>> parameters = ot.GammaMuSigma(1.5, 2.5, -0.5)

Convert parameters into the native parameters:

>>> print(parameters.evaluate())
[0.64,0.32,-0.5]

The gradient of the transformation of the native parameters into the new
parameters:

>>> print(parameters.gradient())
[[  0.64   0.16   0     ]
 [ -0.512 -0.256  0     ]
 [ -0.64  -0.16   1     ]]"
