%feature("docstring") OT::UniformMuSigma
"Uniform distribution parameters.
    
Parameters
----------
mu : float
    Mean.

    Default value is 0.0.
sigma : float
    Standard deviation :math:`\\sigma > 0`.

    Default value is 0.57735.

Notes
-----
The native parameters are defined as follows:

.. math::

    a &= \\mu - \\sigma \\sqrt{3} \\\\
    b &= \\mu + \\sigma \\sqrt{3}

See also
--------
Uniform

Examples
--------
Create the parameters of the Uniform distribution:

>>> import openturns as ot
>>> parameters = ot.UniformMuSigma(8.4, 2.25)

Convert parameters into the native parameters:

>>> p_native = parameters.evaluate()

The gradient of the transformation of the native parameters into the new
parameters:

>>> p_grad = parameters.gradient()"
