/**
 *
 * @file c_spm.h
 *
 * SParse Matrix package precision dependent header.
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 1.2.4
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Alban Bellot
 * @author Tony Delarue
 * @author Alycia Lisito
 * @date 2024-05-29
 *
 * @generated from D:/W/B/src/pastix/spm/include/spm/z_spm.h, normal z -> c, Thu Jan  8 01:58:38 2026
 *
 * @addtogroup spm_dev_integer
 * @{
 *
 **/
#ifndef _c_spm_h_
#define _c_spm_h_

/**
 * @brief Integer routines
 */
void c_spmIntFltSortAsc( void **const    pbase,
                         const spm_int_t n );
void c_spmIntIntFltSortAsc( void ** const   pbase,
                            const spm_int_t n );

/**
 * @}
 * @addtogroup spm_dev_convert
 * @{
 *
 * @brief Conversion routines
 */
int c_spmConvertCSC2CSR( spmatrix_t *spm );
int c_spmConvertCSC2IJV( spmatrix_t *spm );
int c_spmConvertCSR2CSC( spmatrix_t *spm );
int c_spmConvertCSR2IJV( spmatrix_t *spm );
int c_spmConvertIJV2CSC( spmatrix_t *spm );
int c_spmConvertIJV2CSR( spmatrix_t *spm );

void c_spm2dense( const spmatrix_t *spm, spm_complex32_t *A );

/**
 * @}
 * @addtogroup spm_dev_matvec
 * @{
 *
 * @brief Matrix-Vector and matrix-matrix product routines
 */
int spm_cspmv( spm_trans_t            trans,
               spm_complex32_t        alpha,
               const spmatrix_t      *A,
               const spm_complex32_t *x,
               spm_int_t              incx,
               spm_complex32_t        beta,
               spm_complex32_t       *y,
               spm_int_t              incy );
int spm_cspmm( spm_side_t             side,
               spm_trans_t            transA,
               spm_trans_t            transB,
               spm_int_t              K,
               spm_complex32_t        alpha,
               const spmatrix_t      *A,
               const spm_complex32_t *B,
               spm_int_t              ldb,
               spm_complex32_t        beta,
               spm_complex32_t       *C,
               spm_int_t              ldc );

/**
 * @}
 * @addtogroup spm_dev_norm
 * @{
 *
 * @brief Norm computation routines
 */
float c_spmNorm( spm_normtype_t    ntype,
                  const spmatrix_t *spm );
float c_spmNormMat( spm_normtype_t         ntype,
                     const spmatrix_t      *spm,
                     spm_int_t              n,
                     const spm_complex32_t *A,
                     spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_check
 * @{
 *
 * @brief Extra routines
 */
void c_spmSort( spmatrix_t *spm );
spm_int_t c_spmMergeDuplicate( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief RHS routines
 */
int c_spmGenRHS( spm_rhstype_t     type,
                 int               nrhs,
                 const spmatrix_t *spm,
                 void             *x,
                 int               ldx,
                 void             *b,
                 int               ldb );
int c_spmGenMat( spm_rhstype_t           type,
                 int                     nrhs,
                 const spmatrix_t       *spm,
                 void                   *alpha,
                 unsigned long long int  seed,
                 void                   *A,
                 int                     lda );
int c_spmCheckAxb( spm_fixdbl_t      eps,
                   int               nrhs,
                   const spmatrix_t *spm,
                   void             *x0,
                   int               ldx0,
                   void             *b,
                   int               ldb,
                   const void       *x,
                   int               ldx );

void c_spmGatherRHS( int                    nrhs,
                     const spmatrix_t      *spm,
                     const spm_complex32_t *x,
                     spm_int_t              ldx,
                     int                    root,
                     spm_complex32_t       *gx,
                     spm_int_t              ldgx );

void c_spmReduceRHS( int               nrhs,
                     const spmatrix_t *spm,
                     spm_complex32_t  *bglob,
                     spm_int_t         ldbg,
                     spm_complex32_t  *bloc,
                     spm_int_t         ldbl );
void c_spmExtractLocalRHS( int                    nrhs,
                           const spmatrix_t      *spm,
                           const spm_complex32_t *bglob,
                           spm_int_t              ldbg,
                           spm_complex32_t       *bloc,
                           spm_int_t              ldbl );

/**
 * @}
 * @addtogroup spm_dev_print
 * @{
 *
 * @brief Output routines
 */
void c_spmPrint( FILE             *f,
                 const spmatrix_t *spm );
void c_spmPrintRHS( FILE             *f,
                    const spmatrix_t *spm,
                    int               nrhs,
                    const void       *x,
                    spm_int_t         ldx );
void c_spmDensePrint( FILE                  *f,
                      spm_int_t              m,
                      spm_int_t              n,
                      const spm_complex32_t *A,
                      spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_dof
 * @{
 *
 * @brief DOF routines
 */
void c_spmExpand( const spmatrix_t *spm_in,
                  spmatrix_t       *spm_out );
void c_spmDofExtend( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_scal
 * @{
 *
 * @brief Scaling routines
 */
void c_spmScal( const float  alpha,
                spmatrix_t   *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief Subroutines for random vector generation to be used in testings
 */
int c_spmRhsGenRndShm( const spmatrix_t      *spm,
                       spm_complex32_t        scale,
                       spm_int_t              n,
                       spm_complex32_t       *A,
                       spm_int_t              lda,
                       int                    shift,
                       unsigned long long int seed );
int c_spmRhsGenRndDist( const spmatrix_t      *spm,
                        spm_complex32_t        scale,
                        spm_int_t              n,
                        spm_complex32_t       *A,
                        spm_int_t              lda,
                        int                    shift,
                        unsigned long long int seed );

/**
 * @}
 */
#endif /* _c_spm_h_ */
