#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsnesmfgetsnes_ MATSNESMFGETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsnesmfgetsnes_ matsnesmfgetsnes
#endif
PETSC_EXTERN void matsnesmfgetsnes_(Mat *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatSNESMFGetSNES(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsnesmfsetreusebase_ MATSNESMFSETREUSEBASE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsnesmfsetreusebase_ matsnesmfsetreusebase
#endif
PETSC_EXTERN void matsnesmfsetreusebase_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatSNESMFSetReuseBase(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsnesmfgetreusebase_ MATSNESMFGETREUSEBASE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsnesmfgetreusebase_ matsnesmfgetreusebase
#endif
PETSC_EXTERN void matsnesmfgetreusebase_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatSNESMFGetReuseBase(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatesnesmf_ MATCREATESNESMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatesnesmf_ matcreatesnesmf
#endif
PETSC_EXTERN void matcreatesnesmf_(SNES *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatCreateSNESMF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdcomputejacobian_ MATMFFDCOMPUTEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdcomputejacobian_ matmffdcomputejacobian
#endif
PETSC_EXTERN void matmffdcomputejacobian_(SNES *a, Vec *b, Mat *c, Mat *d, void *e, PetscErrorCode *ierr)
{
  *ierr = MatMFFDComputeJacobian(*a, *b, *c, *d, e);
  if (*ierr) return;
}
