#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabelephemeral.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelephemeralgetlabel_ DMLABELEPHEMERALGETLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelephemeralgetlabel_ dmlabelephemeralgetlabel
#endif
PETSC_EXTERN void dmlabelephemeralgetlabel_(DMLabel *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMLabelEphemeralGetLabel(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabelephemeral.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelephemeralsetlabel_ DMLABELEPHEMERALSETLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelephemeralsetlabel_ dmlabelephemeralsetlabel
#endif
PETSC_EXTERN void dmlabelephemeralsetlabel_(DMLabel *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelEphemeralSetLabel(*a, *b);
  if (*ierr) return;
}
