#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateshared_ VECCREATESHARED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateshared_ veccreateshared
#endif
PETSC_EXTERN void veccreateshared_(MPI_Fint *a, PetscInt *b, PetscInt *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = VecCreateShared(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
